<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Vendor_api_model extends MY_Model {

	public function createVendor($data){

        $where = array("gst_no"=>$data['gst_no'],"pan_card" =>$data['pan_no']);
        $this->db->select('tbl_vendor.vendor_code, tbl_account_details.sales_code');
        $this->db->from('tbl_vendor');
        $this->db->join('tbl_account_details','tbl_vendor.added_userid = tbl_account_details.user_id','Left');
        $this->db->where($where);
        $dealer_data = $this->db->get();
        $response_array = '';
      
        $salesman_code = $this->db->group_by('user_id')->get_where('tbl_account_details', array("user_id"=>$data['salesman_id']))->row()->sales_code;

        if($dealer_data->num_rows() > 0){
            $rowData =  $dealer_data->row();
           $response_array = array(
               "dealer_no" => $rowData->vendor_code,
               "salesman_code" => $salesman_code
           );
        }else{ 

            $last_id = $this->db->select_max('vendor_id','max')->get('tbl_vendor')->row()->max;
            $vendor_type = array("SLYB-H-B2B"=>"DEALER");

            $last_id = $last_id + 1;
            $user_type = 'DEALER';
            $vendor_code = array_keys($vendor_type,$user_type)[0];

            $vendor_code = $vendor_code.'-'.$last_id;

            $insert_data = array(
                "name"=>$data['last_name'],
                "company"=>$data['company_name'],
                "email"=>$data['email'],
                "mobile"=>$data['phone_no'],
                "address"=>$data['address'],
                "city"=>$data['city'],
                "state"=>$data['state'],
                "pincode"=>$data['pincode'],
                "aadhar_no"=>$data['aadhar_no'],
                "pan_card"=>$data['pan_no'],
                "gst_no"=>$data['gst_no'],
                "vendor_code"=>$vendor_code
            );
            $this->db->insert('tbl_vendor', $insert_data);
            $insert_id = $this->db->insert_id();
            
            if(!empty($insert_id)){
                $response_array = array(
                    "dealer_no" => $vendor_code,
                    "salesman_code" => $salesman_code
                ); 
            }
        }
        return $response_array;
    } 
}
