<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Triage_Model extends MY_Model {

    public function __construct() {
        parent::__construct();
        $this->load->model('auditlog_model');
    }

    public function updateRmon ($data) {

        $rmon_id=$data['rmon_id'];
        $user_id=$this->session->userdata('user_id');
        $status='';

        if(empty($rmon_id) || $rmon_id <= 0){
            return false;
        }


        if($data['action'] == 'approve'){
            $status='WH_APPROVED';
        }

        if($data['action'] == 'reject'){
            $status='WH_REJECTED';
        }

        if($status==''){
            return false;
        }

        $this->db->trans_start(); //Start MySql transaction
	
        $rmon=array(
            'status'=>$status,
            'LAST_UPDATED_BY'=>$user_id,
            'LAST_UPDATE_DATE'=>date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($rmon);
        $this->db->where('trg_rmon_id',$rmon_id);
        $this->db->update('tbl_trg_rmon');
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }
        
		
		if($error['code']==0){

            if(!empty($data['remarks_header'])){
                $remark_array=array(
                    'reference_id'=>$rmon_id,
                    'reference_type'=>'trg_rmon',
                    'user_id'=>$this->session->userdata('user_id'),
                    'remark'=>$data['remarks_header'],
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark',$remark_array);
                $error=$this->db->error();
            }
        }

        $this->load->model('auditlog_model');
        
        $this->auditlog_model->insert_auditlog($rmon_id,'trg_rmon',$status,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction
        
        if($data['action']=='reject'){
            $return='rejected';
            return $return;
        }

        $return='approved';
        return $return;
    }

    public function validateRmonBySecurityAdmin ($data) {

        $rmon_id=$data['rmon_id'];
        $user_id=$this->session->userdata('user_id');
        $status='';

        if(empty($rmon_id) || $rmon_id <= 0){
            return false;
        }

        $status = 'ADMIN_APPROVED';

        $this->db->trans_start(); //Start MySql transaction
	
        $rmon=array(
            'type' => $data['type'],
            'purpose' => $data["purpose"],
            'expected_date'=> $data['expected_date'],
            'status' => $status,
            'LAST_UPDATED_BY' => $user_id,
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($rmon);
        $this->db->where('trg_rmon_id',$rmon_id);
        $this->db->update('tbl_trg_rmon');
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }
        
        $device_ids = $this->db->select('grnreport_id')->where('trg_rmon_id', $rmon_id)->get('tbl_trg_rmon_item')->result_array();
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }

        foreach($device_ids as $rows){

            $devices[] = array(

                            "grnreport_id" => $rows['grnreport_id'],
                            "status" => "IN_SERVICE"
                        );
        }

        $this->db->update_batch('tbl_grnreport',$devices,'grnreport_id');

        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }
		
		if($error['code']==0){
            if(!empty($data['remarks_header'])){
                $remark_array=array(
                    'reference_id'=>$rmon_id,
                    'reference_type'=>'trg_rmon',
                    'user_id'=>$this->session->userdata('user_id'),
                    'remark'=>$data['remarks_header'],
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark',$remark_array);
                $error=$this->db->error();
            }
        }

        $this->load->model('auditlog_model');
        
        $this->auditlog_model->insert_auditlog($rmon_id,'trg_rmon',$status,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction
        
        return true;
    }

    public function editRmon($data){

        $rmon_id=(int) $data[0]['rmon_id'];

        if($rmon_id<=0){
              return false;
        }

        if(empty($data[0]['rows'])){
            return false;
        }
        $old_rows=array(); $new_rows=array(); $delete_rows=array(); $old_rows_ids=array();
        
        foreach($data[0]['rows'] as $rowValue){
            //For New Rows
            if( $rowValue['trg_rmon_item_id']=='new_row'){

                $new_rows[] = array(
                    "trg_rmon_id" => $rmon_id,
                    "grnreport_id" => $rowValue["grnreport_id"],
                    "remarks" => $rowValue["remarks"],
                );
            }
            //Update Old Rows
            elseif($rowValue['trg_rmon_item_id']>0){
                
                $old_rows[] = array(
                    "trg_rmon_item_id" => $rowValue['trg_rmon_item_id'],
                    "grnreport_id" => $rowValue["grnreport_id"],
                    "remarks" => $rowValue["remarks"],
                );

                $old_rows_ids[]=$rowValue['trg_rmon_item_id'];

            }
        }

        $existing_rows=$this->db->select('trg_rmon_item_id')->where('trg_rmon_id',$rmon_id)->get('tbl_trg_rmon_item')->result_array();
        
        //Find Deleted Rows Id's
        foreach($existing_rows as $value){
            if(!in_array($value['trg_rmon_item_id'],$old_rows_ids)){
                $delete_rows[]=$value['trg_rmon_item_id'];
            }
        }

        $this->db->trans_start();

        $headerArray = array(
            "service_center" => $data[0]["service_center"],
            "status"=> "NEW",
            "LAST_UPDATED_BY"=> $this->session->userdata('user_id'),
            "LAST_UPDATE_DATE"=> date("Y-m-d H:i:s")
        );

        $this->db->set($headerArray);
        $this->db->where('trg_rmon_id',$rmon_id);
        $this->db->update('tbl_trg_rmon');
        $error=$this->db->error();

        if($error['code']!=0){
            $this->db->trans_rollback();
            return false;
        }

        //Insert new Rows
        if(!empty($new_rows) && $error['code']==0){
            $this->db->insert_batch('tbl_trg_rmon_item',$new_rows);
            $error= $this->db->error();
        }

        if($error['code']!=0){

            $this->db->trans_rollback();
            return false;
        }
        //Upload Old Rows
        if(!empty($old_rows) && $error['code']==0){
            $this->db->update_batch('tbl_trg_rmon_item',$old_rows,'trg_rmon_item_id');
            $error=$this->db->error();
        }
        
        if($error['code']!=0){
            $this->db->trans_rollback();
            return false;
        }
        // Delete Rows
        if(!empty($delete_rows) && $error['code']==0){
            $this->db->where_in('trg_rmon_item_id',$delete_rows);
            $this->db->delete('tbl_trg_rmon_item');
            $error=$this->db->error();
        }

        if($error['code']!=0){
            $this->db->trans_rollback();
            return false;
        }

        // Remarks
        if(!empty($data[0]['remarks_header']) && $error['code']==0){
            
            $remark_array=array(
                'reference_id'=>$rmon_id,
                'reference_type'=>'trg_rmon',
                'user_id'=> $this->session->userdata('user_id'),
                'remark'=> $data[0]['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_remark',$remark_array);
            $error=$this->db->error();
        }

        // Insert audit log for Sales Order
        $this->auditlog_model->insert_auditlog($rmon_id,'trg_rmon','NEW',$this->session->userdata('user_id'));

        if($error['code']==0){
            $this->db->trans_complete();
            return true;
        }else{
            $this->db->trans_rollback();
            return false;
        }

    }

    public function receiveRmonBySecurityAdmin($data){


        $rmon_id=$data['rmon_id'];
        $user_id=$this->session->userdata('user_id');
        $status='';
        $quantity = 0;

        if(empty($rmon_id) || $rmon_id <= 0){
            return false;
        }

        $this->db->trans_start(); //Start MySql transaction

        $items = $this->db->select('count(trg_rmon_item_id) as total_rows')->where('trg_rmon_id', $rmon_id)->get('tbl_trg_rmon_item')->row();

        $total_devices = $items->total_rows;

        $already_received = $this->db->select('count(trg_rmon_item_id) as total_rows')->where('status', 'RECEIVED')->where('trg_rmon_id', $rmon_id)->get('tbl_trg_rmon_item')->row();

        $received_items_old = $already_received->total_rows;

        if($data['received_rejected'] == 'YES'){ //Check whether we are updating rejected RMON or not. If YES, then old recevied_status should be ignored

            $received_items_old = 0;
        }

        foreach($data['rows'] as $rows){

            if($rows['received'] == 'received'){
                
                $quantity++;

                $item_rows[] = array(
                                    "trg_rmon_item_id" => $rows['trg_rmon_item_id'],
                                    "received_notes" => $rows["received_notes"],
                                    "status" => 'RECEIVED'
                                );
            }else{
                if($data['received_rejected'] == 'YES'){ // Update old status for received_reject
                    
                    $item_rows[] = array(
                        "trg_rmon_item_id" => $rows['trg_rmon_item_id'],
                        "received_notes" => $rows["received_notes"],
                        "status" => ''
                    );
                }else{
                    $item_rows[] = array(
                        "trg_rmon_item_id" => $rows['trg_rmon_item_id'],
                        "received_notes" => $rows["received_notes"],
                    );
                }
            }
        }

        if( ($quantity + $received_items_old) == $total_devices){

            $status = 'ADMIN_RECEIVED';

        }else{

            $status = 'ADMIN_PARTLY_RECEIVED';
        }

        $rmon=array(

            'status' => $status,
            'LAST_UPDATED_BY' => $user_id,
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($rmon);
        $this->db->where('trg_rmon_id',$rmon_id);
        $this->db->update('tbl_trg_rmon');
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }


        $this->db->update_batch('tbl_trg_rmon_item',$item_rows,'trg_rmon_item_id');
        
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }
		
		if($error['code']==0){

            if(!empty($data['remarks_header'])){
                $remark_array=array(
                    'reference_id'=>$rmon_id,
                    'reference_type'=>'trg_rmon',
                    'user_id'=>$this->session->userdata('user_id'),
                    'remark'=>$data['remarks_header'],
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark',$remark_array);
                $error=$this->db->error();
            }
        }

        $this->load->model('auditlog_model');
        
        $this->auditlog_model->insert_auditlog($rmon_id,'trg_rmon',$status,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction
        
        return true;

    }

    public function receiveRmonByWarehouse($data){

        $rmon_id=$data['rmon_id'];
        $user_id=$this->session->userdata('user_id');
        $status='';

        if(empty($rmon_id) || $rmon_id <= 0){
            return false;
        }

        $status_obj = $this->db->select('status')->where('trg_rmon_id', $rmon_id)->get('tbl_trg_rmon')->row();

        if($status_obj->status == 'ADMIN_PARTLY_RECEIVED'){

            $status = 'PARTLY_RECEIVED';
        }

        if($status_obj->status == 'ADMIN_RECEIVED'){

            $status = 'RECEIVED';
        }

        if($data['action'] == 'REJECT'){
            $status = 'RECEIVED_REJECTED';
        }

        if($status==''){
            return false;
        }

        $this->db->trans_start(); //Start MySql transaction
	
        $rmon=array(
            'status'=>$status,
            'LAST_UPDATED_BY'=>$user_id,
            'LAST_UPDATE_DATE'=>date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($rmon);
        $this->db->where('trg_rmon_id',$rmon_id);
        $this->db->update('tbl_trg_rmon');
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }

        $received_arr = $this->db->select('grnreport_id, status')->where('trg_rmon_id', $rmon_id)->get('tbl_trg_rmon_item')->result_array();
        
        foreach($received_arr as $rowValue){

            if($rowValue['status'] == 'RECEIVED'){
            
                // $grnreport_arr[] = array(
                //                         "grnreport_id" => $rowValue['grnreport_id'],
                //                         "status" => "IN_STOCK"
                //                     );

                $this->db->set('status','IN_STOCK');
                $this->db->where('grnreport_id',$rowValue['grnreport_id']);
                $this->db->where('status','IN_SERVICE');
                $this->db->update('tbl_grnreport');

                $error=$this->db->error();

                if($error['code'] != 0){
                    break; 
                }
            }
        }

       // $this->db->update_batch('tbl_grnreport',$grnreport_arr,'grnreport_id');

        //$error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }

        foreach($data['rows'] as $rows){

            $item_rows[] = array(
                "trg_rmon_item_id" => $rows['trg_rmon_item_id'],
                "received_notes" => $rows["received_notes"],
                "remarks" => $rows['remarks']
            );
        }

        $this->db->update_batch('tbl_trg_rmon_item',$item_rows,'trg_rmon_item_id');
        
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }
		
		if($error['code']==0){

            if(!empty($data['remarks_header'])){
                $remark_array=array(
                    'reference_id'=>$rmon_id,
                    'reference_type'=>'trg_rmon',
                    'user_id'=>$this->session->userdata('user_id'),
                    'remark'=>$data['remarks_header'],
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark',$remark_array);
                $error=$this->db->error();
            }
        }

        $this->load->model('auditlog_model');
        
        $this->auditlog_model->insert_auditlog($rmon_id,'trg_rmon',$status,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction
        
        if($data['action']=='reject'){
            $return='rejected';
            return $return;
        }

        $return='approved';
        return $return;

    }

}