<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Stocktransfer_Model extends MY_Model {

    public function __construct() {
        parent::__construct();
        $this->load->model('auditlog_model');
        $this->load->library('cliq_api');
    }

    public function createStocktransfer($data){
        
        $headerArray = array(); $rowsArray = array();
          
        $headerArray = array(
                            "website"=> $data[0]["website"],
                            "st_type"=> $data[0]["stocktransfer_type"],
                            "from_loc"=> $data[0]["from_loc"],
                            "to_loc"=> $data[0]["to_loc"],
                            "to_loc_type"=> $data[0]["to_locn_type"],
                            "tracking_id"=> $data[0]["tracking_id"],
                            "tracking_name"=> $data[0]["tracking_name"],
                            "status"=> "NEW",
                            "stocktransfer_date"=> $data[0]["stocktransfer_date"],
                            "CREATED_BY"=> $this->session->userdata('user_id'),
                            "CREATION_DATE"=> date("Y-m-d H:i:s")
                        );

        $this->db->trans_start();

        $this->db->insert('tbl_stocktransfer',$headerArray);

        $stocktransfer_id = $this->db->insert_id();
        $error = $this->db->error();
        
        if($error['code'] !=0){

            $this->db->trans_rollback();
            return false;
        }

        if($stocktransfer_id>0){

            foreach($data[0]["rows"] as $rowValue){
                           
                $rowsArray[] = array(
                    "stocktransfer_id"=> $stocktransfer_id,
                    "sku"=> $rowValue["sku"],
                    "grade"=> $rowValue["grade"],
                    "stock_type"=> $rowValue["stock_type"],
                    "fnsku"=> $rowValue["fnsku"],
                    "quantity"=>  $rowValue["quantity"],
                );
            }
        }

        if(empty($rowsArray)){

            $this->db->trans_rollback();
            return false;
        }

        $this->db->insert_batch('tbl_stocktransfer_item',$rowsArray);
        $error= $this->db->error();

        if($error['code'] != 0){
           
            $this->db->trans_rollback();
            return false;
        }
        
        $this->auditlog_model->insert_auditlog($stocktransfer_id,'stocktransfer',"NEW",$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction
        $this->cliq_api->postStocktransferImage($stocktransfer_id);
        return true;
        
    }

    public function editStocktransfer($data){

        $stocktransfer_id=(int) $data[0]['stocktransfer_id'];

        if($stocktransfer_id<=0){
              return false;
        }

        if(empty($data[0]['rows'])){
            return false;
        }
        $old_rows=array(); $new_rows=array(); $delete_rows=array(); $old_rows_ids=array();
        
        foreach($data[0]['rows'] as $rowValue){
            //For New Rows
            if( $rowValue['stocktransfer_item_id']=='new_row'){

                $new_rows[]=array(
                    "stocktransfer_id"=> $stocktransfer_id,
                    "sku"=> $rowValue["sku"],
                    "grade"=> $rowValue["grade"],
                    "stock_type"=> $rowValue["stock_type"],
                    "fnsku"=> $rowValue["fnsku"],
                    "quantity"=>  $rowValue["quantity"],
                );
            }
            //Update Old Rows
            elseif($rowValue['stocktransfer_item_id']>0){
                
                $old_rows[]=array(
                    "stocktransfer_item_id"=>$rowValue['stocktransfer_item_id'],
                    "quantity"=>$rowValue["quantity"],
                );

                $old_rows_ids[]=$rowValue['stocktransfer_item_id'];

            }
        }

        $existing_rows=$this->db->select('stocktransfer_item_id')->where('stocktransfer_id',$stocktransfer_id)->get('tbl_stocktransfer_item')->result_array();
        
        //Find Deleted Rows Id's
        foreach($existing_rows as $value){
            if(!in_array($value['stocktransfer_item_id'],$old_rows_ids)){
                $delete_rows[]=$value['stocktransfer_item_id'];
            }
        }

        $this->db->trans_start();

        $headerArray = array(
            "website"=> $data[0]["website"],
            "st_type"=> $data[0]["stocktransfer_type"],
            "from_loc"=> $data[0]["from_loc"],
            "to_loc"=> $data[0]["to_loc"],
            "tracking_id"=> $data[0]["tracking_id"],
            "tracking_name"=> $data[0]["tracking_name"],
            "status"=> "NEW",
            "stocktransfer_date"=>$data[0]["stocktransfer_date"],
            "LAST_UPDATED_BY"=> $this->session->userdata('user_id'),
            "LAST_UPDATE_DATE"=> date("Y-m-d H:i:s")
        );

        $this->db->set($headerArray);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();

        if($error['code']!=0){
            $this->db->trans_rollback();
            return false;
        }

        //Insert new Rows
        if(!empty($new_rows) && $error['code']==0){
            $this->db->insert_batch('tbl_stocktransfer_item',$new_rows);
            $error= $this->db->error();
        }
        
        //Upload Old Rows
        if(!empty($old_rows) && $error['code']==0){
            $this->db->update_batch('tbl_stocktransfer_item',$old_rows,'stocktransfer_item_id');
            $error=$this->db->error();
        }

        // Delete Rows
        if(!empty($delete_rows) && $error['code']==0){
            $this->db->where_in('stocktransfer_item_id',$delete_rows);
            $this->db->delete('tbl_stocktransfer_item');
            $error=$this->db->error();
        }
        
        // Remarks
        if(!empty($data['remarks_header']) && $error['code']==0){
            $remark_array=array(
                'reference_id'=>$stocktransfer_id,
                'reference_type'=>'stocktransfer',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark',$remark_array);
            $error=$this->db->error();
        }

        $this->load->model('auditlog_model');
        // Insert audit log for Sales Order
        $this->auditlog_model->insert_auditlog($stocktransfer_id,'stocktransfer','NEW',$this->session->userdata('user_id'));

        if($error['code']==0){
            $this->db->trans_complete();
            return true;
        }else{
            $this->db->trans_rollback();
            return false;
        }

    }

    public function getStocktransferList($status){

        $this->db->where('status', $status);
        $result = $this->db->get('STOCKTRANSFER_NOTE_LIST_VIEW')->result_array();
        //print $this->db->last_query();exit;
        if(!empty($result)){
            
            return $result;
        }else{
            
            return false;
        }
    }

    public function getStocktransferInvoiceList($status){

        $this->db->where('status', $status);
        $result = $this->db->get('STOCKTRANSFER_INVOICE_VIEW')->result_array();

        if(!empty($result)){
            
            return $result;
        }else{
            
            return false;
        }
    }

    public function getStocktransferheader($stocktransfer_id){
        $this->db->where('stocktransfer_id', $stocktransfer_id);
        $result = $this->db->get('STOCKTRANSFER_NOTE_LIST_VIEW')->row_array();
        
        if(!empty($result)){
            
            return $result;
        }else{
            
            return false;
        }
    }

    public function getStocktransferDetails($stocktransfer_id){

        $this->db->select('tbl_stocktransfer_item.*, tbl_grnreport.device_name');
        $this->db->where('tbl_stocktransfer_item.stocktransfer_id', $stocktransfer_id);
        $this->db->from('tbl_stocktransfer_item');
        $this->db->join('tbl_grnreport', 'tbl_grnreport.sku=tbl_stocktransfer_item.sku','inner');
        $this->db->group_by('tbl_stocktransfer_item.stocktransfer_item_id');
        $result = $this->db->get()->result_array();

        if(!empty($result)){
            return $result;
        }else{
            return false;
        }
    }

    public function getStocktransferInvoiceHeader($stocktransfer_id){

        $s_invoice = '(select count(stocktransfer_invoice_id) as total_quantity, sum(price) as total_amount';
        $s_invoice .= ',sum(taxable_amount) as total_taxable, sum(tax_amount) as total_tax';
        $s_invoice .= ',sum(exempt_amount) as total_exempt, stocktransfer_id from tbl_stocktransfer_invoice group by stocktransfer_id) as s_invoice';

        $this->db->select('tbl_stocktransfer.stocktransfer_id, tbl_stocktransfer.st_type, tbl_stocktransfer.from_loc, tbl_stocktransfer.to_loc');
        $this->db->select('tbl_stocktransfer.tracking_id, tbl_stocktransfer.tracking_name, tbl_stocktransfer.CREATION_DATE, tbl_stocktransfer.LAST_UPDATE_DATE');
        $this->db->select('tbl_stocktransfer.status, u1.username as CREATED_BY, u2.username as LAST_UPDATED_BY');
        $this->db->select('tbl_stocktransfer.website');
        $this->db->select('s_invoice.total_quantity, s_invoice.total_amount, s_invoice.total_taxable');
        $this->db->select('s_invoice.total_tax, s_invoice.total_exempt');
        $this->db->from('tbl_stocktransfer');
        $this->db->join('tbl_users as u1', 'u1.user_id = tbl_stocktransfer.CREATED_BY', 'Left');
        $this->db->join('tbl_users as u2', 'u2.user_id = tbl_stocktransfer.LAST_UPDATED_BY', 'Left');
        $this->db->join($s_invoice, 's_invoice.stocktransfer_id = tbl_stocktransfer.stocktransfer_id', 'Left');
        $this->db->where('tbl_stocktransfer.stocktransfer_id', $stocktransfer_id);
        
        $result = $this->db->get()->row_array();

        if(!empty($result)){
            
            return $result;
        }else{
            
            return false;
        }
    }

    public function getStocktransferInvoiceDetails($stocktransfer_id){
        // $this->db->select('sti.*, d.device_name, d.sku, d.imei1_no, d.imei2_no');
        // $this->db->select('d.nhdin, d.certification_grade as grade, d.stock_type');
        // $this->db->where('tbl_stocktransfer_invoice.stocktransfer_id', $stocktransfer_id);
        // $this->db->from('tbl_stocktransfer_invoice AS sti');
        // $this->db->join('tbl_grnreport AS d', 'd.grnreport_id=sti.device_id');
        // $rs = $this->db->get()->result_array();

        $rs = $this->db->from('tbl_stocktransfer_invoice AS sti')
                ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER')
                ->join('tbl_stocktransfer_note AS stn', 'stn.stocktransfer_invoice_id = sti.stocktransfer_invoice_id', 'LEFT')
                ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'Left')
                ->where('sti.stocktransfer_id', $stocktransfer_id)
                ->group_by('sti.stocktransfer_invoice_id')
                ->select("sti.*, GROUP_CONCAT(stn.to_loc ORDER BY stn.stocktransfer_note_id ASC SEPARATOR ',') AS stn_locns, st.from_loc AS st_from_loc, st.to_loc AS st_to_loc")
                ->select("d.nhdin, d.device_name, d.sku, d.imei1_no, d.imei2_no, d.certification_grade as grade, d.stock_type")
                ->get()->result_array();
        //         ->get_compiled_select();
        // echo $rs; die;

        if(!empty($rs)){
            return $rs;
        }else{
            return false;
        }
    }

    public function updateStocktransfer($data){
        $stocktransfer_id=$data['stocktransfer_id'];
        $user_id=$this->session->userdata('user_id');
        $status='';

        if(empty($stocktransfer_id) || $stocktransfer_id <= 0){
            return false;
        }


        if($data['action'] == 'approve'){
            $status='FINANCE_APPROVED';
        }

        if($data['action'] == 'reject'){
            $status='FINANCE_REJECTED';
        }

        if($status==''){
            return false;
        }

        $this->db->trans_start(); //Start MySql transaction
	
        $stocktransfer=array(
            'status'=>$status,
            'LAST_UPDATED_BY'=>$user_id,
            'LAST_UPDATE_DATE'=>date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            return false; 
        }
        
		
		if($error['code']==0){
            if(!empty($data['remarks_header'])){
                $remark_array=array(
                    'reference_id'=>$stocktransfer_id,
                    'reference_type'=>'stocktransfer',
                    'user_id'=>$this->session->userdata('user_id'),
                    'remark'=>$data['remarks_header'],
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark',$remark_array);
                $error=$this->db->error();
            }
        }

        $this->load->model('auditlog_model');
        
        $this->auditlog_model->insert_auditlog($stocktransfer_id,'stocktransfer',$status,$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction
        $this->cliq_api->postStocktransferImage($stocktransfer_id);
        if($data['action']=='reject'){
            $return='rejected';
            return $return;
        }

        $return='approved';
        return $return;
    }

    public function createSTInvoice($data){
    
        $stocktransfer_id = $data[0]['stocktransfer_id'];
        

        $stocktransfer_det = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('tbl_stocktransfer')->row();
        if (empty($stocktransfer_det)) {
            $msg = 'Invalid STO';
            GOTO ERROR;
        }
        
        /** Check whether STO Invoice already generated */
        $inv_details = $this->db->from('tbl_stocktransfer_invoice')
                ->where('stocktransfer_id', $stocktransfer_id)
                ->get()->result_array();
        if(!empty($inv_details)) {
            $msg = "STO Invoice already generated for this STO: ".$stocktransfer_id;
            GOTO ERROR;
        }

        $this->db->select('wfrom.state_gst_code as source_gst, wto.state_gst_code as target_gst');
        $this->db->from('tbl_stocktransfer');
        $this->db->join('tbl_wh_loc as wfrom', 'wfrom.short_code = tbl_stocktransfer.from_loc');
        $this->db->join('tbl_wh_loc as wto', 'wto.short_code = tbl_stocktransfer.to_loc');
        $this->db->where('tbl_stocktransfer.stocktransfer_id', $stocktransfer_id);
        $gst_ids = $this->db->get()->row();

        if($gst_ids->source_gst == $gst_ids->target_gst){
            $this->db->select('max(CAST(SUBSTRING_INDEX(stocktransfer_no,"-",-1) as UNSIGNED)) as max');
            $series = $this->db->where("stocktransfer_no LIKE 'DC-HYD-%'")->get('tbl_stocktransfer')->row()->max;
            $next_numner = $series + 1;
            $stocktransfer_no = "DC-HYD-".$next_numner;
            
        }else{
            $this->db->select('max(CAST(SUBSTRING_INDEX(stocktransfer_no,"-",-1) as UNSIGNED)) as max');
            $series = $this->db->where("stocktransfer_no LIKE 'STN-HYD-%'")->get('tbl_stocktransfer')->row()->max;
            $next_numner = $series + 1;
            $stocktransfer_no = "STN-HYD-".$next_numner;
        }
        
        /** Start:: If STN is Re-Invoicing with modifications. This code is to maintain same STN no. when getting re-invoiced again once after it is reverted back to prev. stage (by IT if such instruction received) */
        if (!empty($stocktransfer_det->stocktransfer_no)) {
            $stocktransfer_no = $stocktransfer_det->stocktransfer_no;
        }
        /** End:: If STN is Re-Invoicing with modifications. */

        $device_ids = [];

        $taxable_cat = TAXABLE_CATEGORY;

        foreach($data[0]['rows'] as $rowValue){

            if (strlen($rowValue['nhdin']) < 10) {
                $msg = 'Invalid Device Id found: ' . $rowValue['nhdin'];
                GOTO ERROR;
            }
            if (in_array($rowValue['device_id'], $device_ids)) {
                $msg = 'Duplicate Device Ids found: ' . $rowValue['nhdin'];
                GOTO ERROR;
            }
            $device_ids[] = $rowValue['device_id'];
            
            if($rowValue['tax_type'] == 'NO TAX'){

                $tax_amount = 0;
                $taxable_amount = 0;
                $exempt_amount = 0;
            }else{
                if(in_array($rowValue['category'],$taxable_cat)){
                    $taxable_amount = $rowValue['price'];
                    $exempt_amount = 0;
                    $tax_amount = $rowValue['price']*18/100;
                }else{
                    $taxable_amount = $rowValue['price'] - ($rowValue['unit_price'] + $rowValue['unit_price_tax']);
                    $exempt_amount = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                    $tax_amount = $taxable_amount*18/100;
                }
            }
            $rows[] = array(
                        "stocktransfer_id" => $rowValue['stocktransfer_id'],
                        "device_id" => $rowValue['device_id'],
                        "fnsku" => $rowValue['fnsku'],
                        "lpn_number" => $rowValue['lpn_number'],
                        "price" => $rowValue['price'],
                        "taxable_amount" => $taxable_amount,
                        "exempt_amount" => $exempt_amount,
                        "tax_amount" => $tax_amount,
                        "tax_type" => $rowValue['tax_type'],
                        "CREATED_BY" => $this->session->userdata('user_id')
                    );
            $grnRows[] = array(
                            "grnreport_id" => $rowValue['device_id'],
                            "status" => 'FFC',
                            "saletype" => $stocktransfer_det->website,
                            "warehouse" => $stocktransfer_det->website.'-'.$stocktransfer_det->to_loc,
                            "remark" => $stocktransfer_det->website.' FBA',
                            "ff_batch_no" => $stocktransfer_no,
                        );
        }

        $stn_quantity = $this->db->where('stocktransfer_id', $stocktransfer_id)->select('sum(quantity) as qty')->get('tbl_stocktransfer_item')->row()->qty;
        if ($stn_quantity != count($device_ids)) {
            $msg = 'Total Devices should match with quantity: ' . $stn_quantity;
            GOTO ERROR;
        }
        
        $this->db->trans_start();

        $this->db->insert_batch('tbl_stocktransfer_invoice', $rows);
        $error = $this->db->error();
        
        if($error['code'] != 0){
            GOTO ERROR;
        }

        $stocktransfer=array(
            'stocktransfer_no' => $stocktransfer_no,
            'status' => "INVOICED",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();
    
        if($error['code'] != 0){
            GOTO ERROR;
        }

        $this->db->update_batch('tbl_grnreport', $grnRows, 'grnreport_id');
        
        if($error['code'] != 0){
            GOTO ERROR;
        }

        if($error['code']==0){
            if(!empty($data[0]['remarks_header'])){
                $remark_array=array(
                    'reference_id'=>$stocktransfer_id,
                    'reference_type'=>'stocktransfer',
                    'user_id'=>$this->session->userdata('user_id'),
                    'remark'=>$data[0]['remarks_header'],
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark',$remark_array);
                $error=$this->db->error();
            }
        }

        $this->load->model('auditlog_model');
        
        $this->auditlog_model->insert_auditlog($stocktransfer_id,'stocktransfer',"INVOICED",$this->session->userdata('user_id'));

        $this->db->trans_complete(); // Complete Mysql Transaction
        $this->cliq_api->postStocktransferImage($stocktransfer_id);


        echo json_encode([
            'status' => true,
            'message' => 'STO Invoice created successfully'
        ]);
        exit;

        ERROR:
        $this->db->trans_rollback();

        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something wrong'
        ]);
        exit;
    }
}