<?php



/*

 * To change this license header, choose License Headers in Project Properties.

 * To change this template file, choose Tools | Templates

 * and open the template in the editor.

 */



/**

 * Description of payroll_model

 *

 * @author NaYeM

 */

class Stamphistory_model extends CI_Model

{
 
    public function getRelatedNhdinHistory($nhdin)
	{ 
		$cond="nhdin='".$nhdin."' or imei1_no='".$nhdin."' or eng_imei_no='".$nhdin."' or imei2_no='".$nhdin."'";
		
		$nhdinResult=$this->db->select('nhdin')->where($cond)->get('tbl_grnreport')->row(); 
		
		$nhdin=$nhdinResult->nhdin; 
		
		$inwardPending=$this->getRelatedNhdinHistoryFromGrnreport($nhdin);		
		
		$recivedStore=$this->getRelatedNhdinHistoryFromGrnreportRecivedStore($nhdin);
		
		$recivedAssessStore=$this->getRelatedNhdinHistoryFromReciAsses($nhdin);
		 
		$readyForSale=$this->getRelatedNhdinHistoryFromReadyForSale($nhdin);
		
		$trc=$this->getRelatedNhdinHistoryFromtTrc($nhdin);
		
		$inQc=$this->getRelatedNhdinHistoryFromInqc($nhdin);
		
		$inQcPass=$this->getRelatedNhdinHistoryFromInqcPass($nhdin);
		
		$inQcFail=$this->getRelatedNhdinHistoryFromInqcFail($nhdin);
		
		$l1Assesment=$this->getRelatedNhdinHistoryFromL1Assess($nhdin);
		
		$modalMismatch=$this->getRelatedNhdinHistoryFromModalMis($nhdin);
		
		$outQc=$this->getRelatedNhdinHistoryFromOutQc($nhdin);
		
		$outFail=$this->getRelatedNhdinHistoryFromOutQcFail($nhdin);
		
		$outPass=$this->getRelatedNhdinHistoryFromOutQcPass($nhdin);
		
		$outPassFinance=$this->getRelatedNhdinHistoryFromOutQcPassFinance($nhdin);
		
		$closedrfsTrc=$this->getRelatedNhdinHistoryFromRfsTrc($nhdin);
		
		$soldStamp=$this->getRelatedNhdinHistoryFromSoldStamp($nhdin);
		
		$inTransitOutbondSold=$this->inTransitOutbondSold($nhdin);
		
		$returnOriginStamp=$this->returnOriginStamp($nhdin);
		
		$salesReturn=$this->salesReturnStamp($nhdin);
		
		$assInspection=$this->assInspection($nhdin);
		
		$assRejected=$this->assRejected($nhdin);
		
		$assPass=$this->assPass($nhdin);
		
		$assFail=$this->assFail($nhdin);
		
		$readyForSaleTrc=$this->readyForSaleTrc($nhdin);
	
		$receivedAssessmentStoreAss=$this->receivedAssessmentStoreAss($nhdin);
		
		$assInspectionCompleted=$this->assInspectionCompleted($nhdin);
		
		$assDispatched=$this->assDispatched($nhdin);
		
		$onHoldStamp=$this->onHoldStamp($nhdin);
		
		$movedToAmazon=$this->movedToAmazon($nhdin);
		
		$certificationDepartment=$this->getRelatedNhdinHistoryFromtcertDept($nhdin);
		
		$failCertification=$this->getRelatedNhdinHistoryFromtcertifiedFail($nhdin);
		
		$passCertification=$this->getRelatedNhdinHistoryFromtcertifiedPass($nhdin);
		
		// $allBulkstatusStamp=$this->getRelatedNhdinHistoryFromBulkStatus($nhdin);
		  
		$finalArray=array_merge($inwardPending,$recivedStore,$recivedAssessStore,$trc,$inQc,$inQcPass,$inQcFail,$l1Assesment,$modalMismatch,$outQc,$outPass,$outPassFinance,$outFail,$closedrfsTrc,$soldStamp,$inTransitOutbondSold,$returnOriginStamp,$readyForSale,$salesReturn,$onHoldStamp,$assInspection,$assRejected,$assPass,$assFail,$readyForSaleTrc,$receivedAssessmentStoreAss,$assInspectionCompleted,$assDispatched,$movedToAmazon,$certificationDepartment,$failCertification,$passCertification);
		
		return $this->aasort($finalArray,'created_date');
	}
	 
	public function getNhdinLastStampStatus($nhdin)
	{
		$updateStatus='';
		
		$stampResult=$this->getRelatedNhdinHistory($nhdin);
		
		end($stampResult);    // move the internal pointer to the end of the array
		
		$key = key($stampResult); 
		
		if(isset($stampResult[$key]))
		{
			$updateStatus=$stampResult[$key]['update_status'];
		} 
		
		return $updateStatus;
	}
	 
	public function getNhdinLastStampStatusTime($nhdin)
	{
		$dateTime='';
		
		$stampResult=$this->getRelatedNhdinHistory($nhdin);
		
		end($stampResult);    // move the internal pointer to the end of the array
		
		$key = key($stampResult); 
		
		if(isset($stampResult[$key]))
		{
			$dateTime=$stampResult[$key]['created_date'];
		} 
		
		return $dateTime;
	}
	 
	public function getNhdinLastStampImeiNo($nhdin)
	{
		$imeiNo='';
		
		$stampResult=$this->getRelatedNhdinHistory($nhdin);
		
		end($stampResult);    // move the internal pointer to the end of the array
		
		$key = key($stampResult); 
		
		if(isset($stampResult[$key]))
		{
			$imeiNo=$stampResult[$key]['imei1_no'];
		} 
		
		return $imeiNo;
	}
	
	public function getNhdinLastSecondStampStatus($nhdin)
	{
		$updateStatus='';
		
		$stampResult=$this->getRelatedNhdinHistory($nhdin);
		
		end($stampResult);    // move the internal pointer to the end of the array
		
		$key = key($stampResult); 
		
		$key=$key-1;
		
		if(isset($stampResult[$key]))
		{
			$updateStatus=$stampResult[$key]['update_status'];
		} 
		
		return $updateStatus;
	}
	
	/*==get inward pending stamp==*/
	
	public function getRelatedNhdinHistoryFromGrnreport($nhdin)
	{ 
        $this->db->from('tbl_grnreport');
		$this->db->select('nhdin,uploadorder_userid,created_date,imei1_no');
        $this->db->where('nhdin',$nhdin); 
        $query = $this->db->get();
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei1_no'],
					'update_status'=>'INWARD PENDING FINANCE',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['uploadorder_userid'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromGrnreportRecivedStore($nhdin)
	{ 
	 
        $this->db->from('tbl_grnreport');
		$this->db->select('nhdin,movestoreuser_id,recivedstore_datetime,imei1_no');
        $this->db->where(array('nhdin'=>$nhdin,'inward_pending'=>'2','recived_store !='=>'0')); 
        $query = $this->db->get();
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei1_no'],
					'update_status'=>'RECEIVED STORE',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['recivedstore_datetime'],
					'uploadstatus_userid'=>$value['movestoreuser_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromReciAsses($nhdin)
	{       
		$this->db->where('nhdin',$nhdin); 
		$query = $this->db->get('tbl_recivedasses_stores');
        $result=$query->result_array(); 
 
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'RECEIVED ASSESSMENT STORES',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>'',
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;		
	}
	
	public function getRelatedNhdinHistoryFromReadyForSale($nhdin)
	{  
	
        $this->db->select('tbl_grnreport.nhdin,tbl_bulkstatus.engineer_name,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,tbl_readyforsale.created_date,tbl_readyforsale.user_id,tbl_readyforsale.imei_no');       
		$this->db->where(array('tbl_readyforsale.nhdin'=>$nhdin,'tbl_readyforsale.upload_type'=>'NEW')); 
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_readyforsale.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin');
		$query = $this->db->get('tbl_readyforsale');
        $result=$query->result_array(); 
 
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'READY FOR SALE',
					'engineer_name'=>$value['engineer_name'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;		
	}
	
	public function getRelatedNhdinHistoryFromtcertDept($nhdin)
	{  
        $this->db->select('nhdin,created_date,user_id,imei_no'); 		
        $this->db->where('nhdin',$nhdin);  
		$query = $this->db->get('tbl_certification_dept');
        $result=$query->result_array(); 

		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'CERTIFICATION DEPARTMENT',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;  		 
	}
	
	public function getRelatedNhdinHistoryFromtcertifiedPass($nhdin)
	{  
        $this->db->select('nhdin,created_date,user_id,imei_no'); 		
        $this->db->where('nhdin',$nhdin);  
		$query = $this->db->get('tbl_certification_pass');
        $result=$query->result_array(); 

		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'CERTIFICATION PASS',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;  		 
	}
	
	public function getRelatedNhdinHistoryFromtcertifiedFail($nhdin)
	{  
        $this->db->select('nhdin,created_date,user_id,imei_no'); 		
        $this->db->where('nhdin',$nhdin);  
		$query = $this->db->get('tbl_certification_fail');
        $result=$query->result_array(); 

		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'CERTIFICATION FAIL',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;  		 
	}
	
	public function getRelatedNhdinHistoryFromtTrc($nhdin)
	{  
        $this->db->select('nhdin,created_date,user_id,imei_no'); 		
        $this->db->where('nhdin',$nhdin);  
		$query = $this->db->get('tbl_trcassessment');
        $result=$query->result_array(); 

		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'TRIAGE',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;  		 
	}
	
	public function getRelatedNhdinHistoryFromInqc($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,trc_engassessment.imei_no,tbl_bulkstatus.update_status,trc_engassessment.eng_id,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,trc_engassessment.created_date,trc_engassessment.user_id');
        $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin,'purpose'=>'IN QC')); 
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=trc_engassessment.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('trc_engassessment');		
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'IN QC',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromInqcPass($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,tbl_inqcpass_stamp.imei_no,tbl_bulkstatus.update_status,tbl_bulkstatus.invoice_no,tbl_inqcpass_stamp.created_date,tbl_inqcpass_stamp.user_id,tbl_bulkstatus.bulkstatus_id');
         $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_inqcpass_stamp.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_inqcpass_stamp');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			
			$createdDateArray=array();
			
			foreach($result as $value)
			{
				
				$createdDateArray=json_decode($value['created_date']);
				
				if(!empty($createdDateArray))
				{  
				
					foreach($createdDateArray as $createdDateArrayValue)
					{
						$finalResult[]=array(
							'nhdin'=>$value['nhdin'],
							'imei1_no'=>$value['imei_no'],
							'update_status'=>'IN QC PASS',
							'engineer_name'=>$value['user_id'],
							'invoice_no'=>$value['invoice_no'],
							'remark'=>$this->Common_model->getFieldValue('engineer_remark','tbl_title_connectivity','bulkstatus_id',$value['bulkstatus_id']),
							'created_date'=>$createdDateArrayValue,
							'uploadstatus_userid'=>$value['user_id'],
						);
					}					
				}
			}
		} 
		
		return $finalResult;
	 	 
	 	 
	}
	
	public function getRelatedNhdinHistoryFromInqcFail($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,tbl_inqcfail_stamp.imei_no,tbl_bulkstatus.update_status,tbl_bulkstatus.invoice_no,tbl_inqcfail_stamp.created_date,tbl_inqcfail_stamp.user_id,tbl_bulkstatus.bulkstatus_id');
         $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_inqcfail_stamp.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_inqcfail_stamp');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			
			$createdDateArray=array();
			
			foreach($result as $value)
			{
				
				$createdDateArray=json_decode($value['created_date']);
				
				if(!empty($createdDateArray))
				{  
				
					foreach($createdDateArray as $createdDateArrayValue)
					{
						$finalResult[]=array(
							'nhdin'=>$value['nhdin'],
							'imei1_no'=>$value['imei_no'],
							'update_status'=>'IN QC FAIL',
							'engineer_name'=>$value['user_id'],
							'invoice_no'=>$value['invoice_no'],
							'remark'=>$this->Common_model->getFieldValue('engineer_remark','tbl_title_connectivity','bulkstatus_id',$value['bulkstatus_id']),
							'created_date'=>$createdDateArrayValue,
							'uploadstatus_userid'=>$value['user_id'],
						);
					}					
				}
			}
		} 
		
		return $finalResult;
	}
	
	public function getRelatedNhdinHistoryFromL1Assess($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,tbl_l1assessment.imei_no,tbl_bulkstatus.update_status,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,tbl_l1assessment.created_date,tbl_l1assessment.user_id');
        $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_l1assessment');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'L1 ASSESSMENT',
					'engineer_name'=>'',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromModalMis($nhdin)
	{  
	  
        $this->db->select('nhdin,imei_no,invoice_no,created_date,mismatch_userid');
        $this->db->where(array('nhdin'=>$nhdin,'confirm_mismatch'=>'1'));  
		$query = $this->db->get('tbl_modalmismatch');	
		$result=$query->result_array(); 
		 
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$nhdin,
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'MODEL MISMATCH',
					'engineer_name'=>'',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['mismatch_userid'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromOutQc($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,tbl_outqcstamp.imei_no,tbl_bulkstatus.update_status,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,tbl_bulkstatus.engineer_name,tbl_outqcstamp.created_date,tbl_outqcstamp.user_id');
         $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcstamp.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_outqcstamp');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'OUT QC',
					'engineer_name'=>$value['engineer_name'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	
	public function getRelatedNhdinHistoryFromOutQcFail($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin)); 
		$query = $this->db->get('tbl_outqcfail_salesstamp');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		
		if(!empty($result))
		{
			
			$createdDateArray=array();
			
			foreach($result as $value)
			{
				
				$createdDateArray=json_decode($value['created_date']);
				
				if(!empty($createdDateArray))
				{  
				
					foreach($createdDateArray as $createdDateArrayValue)
					{
						$finalResult[]=array(
							'nhdin'=>$value['nhdin'],
							'imei1_no'=>$value['imei_no'],
							'update_status'=>'OUT QC FAIL',
							'engineer_name'=>$value['user_id'],
							'invoice_no'=>'',
							'remark'=>$value['remark'],
							'created_date'=>$createdDateArrayValue,
							'uploadstatus_userid'=>$value['user_id'],
						);
					}					
				}
			}
		} 
		
		return $finalResult;
	 	 
	}
	
	
	public function getRelatedNhdinHistoryFromOutQcPass($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin));  
		$query = $this->db->get('tbl_outqcpass_salesstamp');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		
		if(!empty($result))
		{
			
			$createdDateArray=array();
			
			foreach($result as $value)
			{
				
				$createdDateArray=json_decode($value['created_date']);
				
				if(!empty($createdDateArray))
				{  
				
					foreach($createdDateArray as $createdDateArrayValue)
					{
						$finalResult[]=array(
							'nhdin'=>$value['nhdin'],
							'imei1_no'=>$value['imei_no'],
							'update_status'=>'OUT QC PASS-SALES',
							'engineer_name'=>$value['eng_id'],
							'invoice_no'=>'',
							'remark'=>$value['remark'],
							'created_date'=>$createdDateArrayValue,
							'uploadstatus_userid'=>$value['user_id'],
						);
					}					
				}
			}
		} 
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromOutQcPassFinance($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,tbl_outqcpass_finance.imei_no,tbl_bulkstatus.update_status,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,tbl_outqcpass_finance.created_date,tbl_outqcpass_finance.user_id');
         $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcpass_finance.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_outqcpass_finance');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		
		if(!empty($result))
		{
			 
			foreach($result as $value)
			{ 
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'OUT QC PASS-FINANCE',
					'engineer_name'=>'',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		} 
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromRfsTrc($nhdin)
	{ 
        $this->db->select('nhdin,imei_no,created_date,user_id');
         $this->db->where('nhdin',$nhdin);   
		$query = $this->db->get('trc_closedrfsassess');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'READY FOR SALE-TRC',
					'engineer_name'=>'',
					'invoice_no'=>'',
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromSoldStamp($nhdin)
	{ 
        $this->db->select('tbl_grnreport.nhdin,tbl_soldstamp.imei_no,tbl_bulkstatus.update_status,tbl_soldstamp.invoice_no,tbl_bulkstatus.remark, tbl_soldstamp.created_date, tbl_soldstamp.user_id');
        $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_soldstamp.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_soldstamp');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'SOLD',
					'engineer_name'=>'',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function inTransitOutbondSold($nhdin)
	{  
        $this->db->where('nhdin',$nhdin);   
		$query = $this->db->get('tbl_intransitoutbondsold');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'IN TRANSIT OUTBOUND SOLD',
					'engineer_name'=>'0',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function returnOriginStamp($nhdin)
	{ 
        $this->db->select('tbl_returntoorigin.imei_no,tbl_grnreport.nhdin,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,tbl_returntoorigin.created_date,tbl_returntoorigin.user_id');
        $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_returntoorigin.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_returntoorigin');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'RETURNED TO ORIGIN',
					'engineer_name'=>'',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function salesReturnStamp($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin));   
		$query = $this->db->get('tbl_salesreturn');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'SALES RETURN',
					'engineer_name'=>'',
					'invoice_no'=>$value['invoice_no'],
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		 
		return $finalResult;
	 	 
	}
	
	public function assInspection($nhdin)
	{  
        $this->db->where(array('tbl_assinspection.nhdin'=>$nhdin));   
		$query = $this->db->get('tbl_assinspection');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'AFTER-SALES-SERVICE-INSPECTION',
					'engineer_name'=>$value['engineer_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>'',
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function assRejected($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin,'update_status'=>'ass_rejected'));  
		$query = $this->db->get('tbl_receivedassess_ass');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'ASS REJECTED',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function assPass($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin,'update_status'=>'ass_pass'));  
		$query = $this->db->get('tbl_receivedassess_ass');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'ASS PASS',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function assFail($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin,'update_status'=>'ass_fail'));  
		$query = $this->db->get('tbl_receivedassess_ass');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'ASS FAIL',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function readyForSaleTrc($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin));  
		$query = $this->db->get('tbl_receivedassess_ass');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{ 
				$createdDateTime=$date = date('Y-m-d H:i:s',strtotime('+1 seconds',strtotime($value['created_date'])));
 
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'AFTER SALES SERVICE-TRC',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$createdDateTime,
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function receivedAssessmentStoreAss($nhdin)
	{  
        $this->db->where(array('nhdin'=>$nhdin,'movestore_user_id!='=>'0'));  
		$query = $this->db->get('tbl_receivedassess_ass');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'RECEIVED ASSESSMENT STORE-ASS',
					'engineer_name'=>$value['eng_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['movestore_time'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function assInspectionCompleted($nhdin)
	{ 
        $this->db->select('nhdin,imei_no,engineer_id,invoice_no,remark,created_date,user_id');
        $this->db->where(array('nhdin'=>$nhdin));  
		$query = $this->db->get('tbl_ass_inpectioncompleted');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'ASS INSPECTION COMPLETED',
					'engineer_name'=>$value['engineer_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function assDispatched($nhdin)
	{ 
        $this->db->where(array('nhdin'=>$nhdin));   
		$query = $this->db->get('tbl_ass_dispatched');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'ASS DISPATCHED',
					'engineer_name'=>$value['engineer_id'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function onHoldStamp($nhdin)
	{ 
        $this->db->where(array('nhdin'=>$nhdin));  
		$query = $this->db->get('tbl_onhold');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{				
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'ON HOLD',
					'engineer_name'=>'0',
					'invoice_no'=>'',
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function movedToAmazon($nhdin)
	{ 
        $this->db->select('tbl_moved_toamazon.imei_no,tbl_grnreport.nhdin,tbl_bulkstatus.invoice_no,tbl_bulkstatus.engineer_name,tbl_bulkstatus.remark,tbl_moved_toamazon.created_date,tbl_moved_toamazon.user_id');
        $this->db->where(array('tbl_grnreport.nhdin'=>$nhdin));  
		$this->db->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_moved_toamazon.bulkstatus_id'); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
		$query = $this->db->get('tbl_moved_toamazon');	
		$result=$query->result_array(); 
		
		$finalResult=array();
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$finalResult[]=array(
					'nhdin'=>$value['nhdin'],
					'imei1_no'=>$value['imei_no'],
					'update_status'=>'MOVED TO AMAZON',
					'engineer_name'=>$value['engineer_name'],
					'invoice_no'=>$value['invoice_no'],
					'remark'=>$value['remark'],
					'created_date'=>$value['created_date'],
					'uploadstatus_userid'=>$value['user_id'],
				);
			}
		}
		
		return $finalResult;
	 	 
	}
	
	public function getRelatedNhdinHistoryFromBulkStatus($nhdin)
	{  
        $this->db->select('tbl_grnreport.nhdin,tbl_grnreport.imei1_no,tbl_bulkstatus.update_status,tbl_bulkstatus.engineer_name,tbl_bulkstatus.invoice_no,tbl_bulkstatus.remark,tbl_bulkstatus.created_date,tbl_bulkstatus.uploadstatus_userid');
        $this->db->from('tbl_bulkstatus');
        $this->db->where('tbl_bulkstatus.nhdin',$nhdin); 
		$this->db->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin'); 
        $query = $this->db->get();
        return $query->result_array();   		 
	}
	
	function aasort (&$array, $key) {
		$sorter=array();
		$ret=array();
		reset($array);
		foreach ($array as $ii => $va) {
			$sorter[$ii]=$va[$key];
		}
		asort($sorter);
		foreach ($sorter as $ii => $va) {
			$ret[$ii]=$array[$ii];
		}
		return $array=$ret;
	}
 
	public function engineerRemak($bulkstatus_id,$bulkstatusRemark)
	{
		$engResult=$this->db->select('connectivity_id,engineer_remark')->where('bulkstatus_id',$bulkstatus_id)->get('tbl_title_connectivity')->row();
		
		if(!empty($engResult))
		{
			return $engResult->engineer_remark;
		}
		else
		{
			return $bulkstatusRemark;
		}
	}	
}

