<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class SalesOrder_Model extends MY_Model
{

    public $_table_name;
    public $_order_by;
    public $_primary_key;

    public function select_salesorder_by_id($salesorder_id)
    {
        $this->db->select('tbl_salesorder.*', false);
        $this->db->where('tbl_salesorder.salesorder_id', $salesorder_id);
        $query_result = $this->db->get();
        $result = $query_result->result();

        return $result;
    }

    public function get_salesorder($module_type = 1, $status = '')
    {
        if ($module_type == 2) {
            $this->db->where('sales_channel', 'EXPORT');
        } else {
            $this->db->where('sales_channel !=', 'EXPORT');
        }
        if ($status != '') {
            $this->db->where('status', $status);
        }
        $result = $this->db->order_by('salesorder_id', 'desc')->get('SALESORDER_RFS_LIST_VIEW')->result_array();
        return $result;
    }

    public function get_salesorder_count($module_type = 1)
    {
        if ($module_type == 2) {
            $this->db->where('sales_channel', 'EXPORT');
        } else {
            $this->db->where('sales_channel !=', 'EXPORT');
        }
        $this->db->select('COUNT(1) as total');
        $this->db->from('tbl_salesorder');
        $result = $this->db->get()->row_array();
        return $result;
    }


    public function get_salesOrderItem($salesorder_id)
    {
        $this->db->select('tbl_salesorder_item.*', false);
        $this->db->where('tbl_salesorder_item.salesorder_id', $salesorder_id);
        $query_result = $this->db->get();
        $result = $query_result->result();

        return $result;
    }

    public function create_salesorder($data)
    {
        $customer = $data['customer'];
        $seller = $data['seller'];
        $warehouse = $data['warehouse'];
        $payment_mode = $data['payment_mode'];
        $sales_channel_id = $data['sales_channel_id'];
        $user_id = $this->session->userdata('user_id');

        $this->db->trans_start();

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesorder')->get()->row_array();
        $next_number = $res['max'] + 1;
        $sales_code = 'SO-' . $warehouse . '-' . $next_number;
        $sales_channel = $data['sales_channel'];

        $salesorder_header = array(
            'salesorder_code' => $sales_code,
            'vendor_id' => $customer,
            'salesman_code' => $seller,
            'status' => 'FINANCE_PENDING',
            'CREATION_DATE' => date('Y-m-d H:i:s'),
            'LAST_UPDATE_DATE' => date('Y-m-d H:i:s'),
            'CREATED_BY' => $user_id,
            'warehouse' => $warehouse,
            'payment_mode' => $payment_mode,
            "sales_channel" => $sales_channel,
            "saleschannel_ref_id" => $sales_channel_id
        );
        $this->db->insert('tbl_salesorder', $salesorder_header);

        $salesorderid = $this->db->insert_id();
        $error = $this->db->error();

        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $salesorderid,
                    'reference_type' => 'salesorder',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }
        if ($error['code'] == 0) {
            $this->load->model('auditlog_model');
            // Insert audit log for Sales Order
            $this->auditlog_model->insert_auditlog($salesorderid, 'salesorder', 'FINANCE_PENDING', $this->session->userdata('user_id'));

            $sku = $data['sku'];
            $productdetails = array();
            foreach ($sku as $index => $value) {
                $amount = bcmul($data['price'][$index], $data['qty'][$index], 2);
                $product = array(
                    'salesorder_id' => $salesorderid,
                    'sku' => $data['sku'][$index],
                    'brand' => $data['brand'][$index],
                    'model_id' => $data['model_id'][$index],
                    'device_name' => $data['model'][$index],
                    'ram' => $data['ram'][$index],
                    'rom' => $data['rom'][$index],
                    'quantity' => $data['qty'][$index],
                    'sale_price' => $data['price'][$index],
                    'amount' => $amount,
                    'grade' => $data['grade'][$index],
                    'sales_terms' => $data['sales_terms'][$index],
                    'category' => $data['category'][$index],
                    'color' => $data['color'][$index]
                );
                array_push($productdetails, $product);
            }
            $this->db->insert_batch('tbl_salesorder_item', $productdetails);
            $error = $this->db->error();
            if ($error['code'] == 0) {
                $this->db->trans_complete();
                $error['salesorder_id'] = $salesorderid;
                return $error;
            } else {
                $this->db->trans_rollback();
                return $error;
            }
        }
    }
    public function get_salesorder_row($salesorderid)
    {
        $this->db->where('salesorder_id', $salesorderid);
        $result = $this->db->get('SALESORDER_RFS_LIST_VIEW')->result_array();
        return $result;
    }

    public function update_salesorder($data)
    {

        $salesorderid = $data['salesorder_id'];
        $user_id = $this->session->userdata('user_id');
        $status = '';

        if (empty($salesorderid) || $salesorderid <= 0) {
            return false;
        }

        //Get module_type
        $rs = $this->db->select('module_type')->from('tbl_salesorder')
                       ->where('salesorder_id', $salesorderid)->get()->row_array();
        $module_type = $rs['module_type'];


        if ($data['action'] == 'approve') {
            $status = 'FINANCE_APPROVED';
            $action = 'APPROVED';
        }

        if ($data['action'] == 'reject') {
            $status = 'FINANCE_REJECTED';
            $action = 'REJECTED';
        }

        if ($status == '') {
            return false;
        }

        $this->db->trans_start(); //Start MySql transaction

        $salesorder = array(
            'status' => $status,
            'LAST_UPDATED_BY' => $user_id,
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),
        );

        $this->db->set($salesorder);
        $this->db->where('salesorder_id', $salesorderid);
        $this->db->update('tbl_salesorder');
        $error = $this->db->error();

        if ($error['code'] == 0 && !empty($data['receipt_details'])) {

            $receipt_detals = $data['receipt_details'];
            $receipts = [];

            foreach ($receipt_detals as $receipt_row) {

                $receipts[] = array(
                    'receipt_id' => $receipt_row['receipt_id'],
                    'vendor_id' => $receipt_row['vendor_id'],
                    'salesorder_id' => $salesorderid,
                    'receipt_amount' => $receipt_row['receipt_amount'],
                    'salesorder_amount' => $receipt_row['salesorder_amount'],
                    'adjusted_amount' => $receipt_row['adjusted_amount'],
                    'CREATED_BY' => $user_id

                );
            }

            if (!empty($receipts)) {

                $this->db->insert_batch('tbl_receipt_so', $receipts);
            }
        }

        $reference_type = ($module_type == 2)? 'export_salesorder' : 'salesorder';
        
        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $salesorderid,
                    'reference_type' => $reference_type,
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->load->model('auditlog_model');

        $this->auditlog_model->insert_auditlog($salesorderid, $reference_type, $status, $this->session->userdata('user_id'));

        $this->db->trans_complete(); // Complete Mysql Transaction

        $this->cliq_api->postSalesImage($salesorderid);

        if ($data['action'] == 'reject') {
            $return = 'rejected';
            return $return;
        }

        $return = 'approved';
        return $return;
    }

    /***
     * Function to get quantity based on model_id, variant, category and grade
     * @input salesorderid int
     * 
     */
    public function get_salesorder_quantity($salesorderid)
    {

        $this->db->select("sum(quantity) as quantity,model_id,color,ram,rom,category,grade")->from('tbl_salesorder_item');
        $query = $this->db->where('salesorder_id', $salesorderid)->group_by("model_id,category,color,ram,rom,grade")->get();
        $result = $query->result_array();
        return $result;
    }

    public function insertBulkSalesOrder($header, $rowsArray, $remarks_header,$shipping_arr,$total_purchase_cost, $device_ActvStatusUpdate_arr = [], $logisticArray)
    {
        if (empty($header) || empty($rowsArray)) {
            return false;
            die;
        }

        $this->db->trans_start();

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesorder')->get()->row_array();
        $next_number = $res['max'] + 1;
        $sales_code = 'SO-' . $header["warehouse"] . '-' . $next_number;

        $header["salesorder_code"] = $sales_code;

        $this->db->insert('tbl_salesorder', $header);

        $salesorder_id = $this->db->insert_id();

        if ($salesorder_id > 0) {

            for ($i = 0; $i < sizeof($rowsArray); $i++) {

                $rowsArray[$i]["salesorder_id"] = $salesorder_id;
            }

            $this->db->insert_batch('tbl_salesorder_item', $rowsArray);
            $error = $this->db->error();

            if (count($device_ActvStatusUpdate_arr) > 0) {
                $this->db->update_batch('tbl_grnreport', $device_ActvStatusUpdate_arr, 'grnreport_id');
                $error = $this->db->error();
                if ($error['code'] != 0) {
                    $this->db->trans_rollback();
                    return false;
                }
            }

            if ($error['code'] == 0) {
                $reference_type = ($header['module_type'] == 2)? 'export_salesorder' : 'salesorder';

                if (!empty($remarks_header)) {

                    $remark_array = array(
                        'reference_id' => $salesorder_id,
                        'reference_type' => $reference_type,
                        'user_id' => $this->session->userdata('user_id'),
                        'remark' => $remarks_header,
                        "date" => date("Y-m-d H:i:s")
                    );
                    $this->db->insert('tbl_remark', $remark_array);
                }
                
                $shipping_to = array(
                    "shipping_from_id"  => $shipping_arr['shipping_from_id'],
                    "shipping_to_vendor"  => $shipping_arr['shipping_to_vendor'],
                    "billing_from_id"  => $shipping_arr['billing_from_id'],
                    "salesorder_id"     => $salesorder_id,
                    "address"           => $shipping_arr['address'],
                    "city"              => $shipping_arr['city'],
                    "state"             => $shipping_arr['state'],
                    "country"           => $shipping_arr['country'],
                    "pincode"           => empty($shipping_arr['pincode'])? null: $shipping_arr['pincode']
                    );

                $insrert = $this->db->insert('tbl_shipping_to_address', $shipping_to);

		$res = $this->db->select('max(CAST(SUBSTRING_INDEX(reference_no,"-",-1) as UNSIGNED)) as max')->from('tbl_so_link_logistic_partner')->get()->row_array();
        	$next_number = $res['max'] + 1;
        	$reference_no = 'LP-PAY-'. $next_number;
		if($logisticArray['payment_by'] == "CUSTOMER"){
			$reference_no = "NA";
		}
		$logistic_info = array(
                    "salesorder_id"  => $salesorder_id,
                    "logistic_name"  => $logisticArray['logistic_name'],
		    "reference_no"   => $reference_no,
                    "payment_by"     => $logisticArray['payment_by'],
		    "paid_amount"    => $logisticArray['paid_amount'],
		    "created_by"     => $this->session->userdata('user_id')
                    
                    );
		if(!empty($logistic_info)){
                    if($header['module_type'] != 2){
                        $this->db->insert('tbl_so_link_logistic_partner', $logistic_info);
                    }
                    
                }
                
		$error = $this->db->error();
                if ($error['code'] != 0) {
                    $this->db->trans_rollback();
                    return false;
                }

                $this->db->trans_complete();
                //Post to Cliq 
		$this->cliq_api->postSalesMarginImage($salesorder_id, $total_purchase_cost);
                $this->cliq_api->postSalesImage($salesorder_id);
                return true;

            } else {
                $this->db->trans_rollback();
                return false;
            }
        } else {
            $this->db->trans_rollback();
            return false;
        }
    }

    public function getVendorDetails($id)
    {
        if ($id > 0) {
            $vendorResult = $this->db->where('vendor_id', $id)->get('tbl_vendor')->row();
            $stateResult = $this->db->select('name,state_gst_id')->where('state_id', $vendorResult->state)->get('tbl_states')->row();
            if (!empty($vendorResult)) {
                $data['vendor_name'] = $vendorResult->name;
                $data['company'] = $vendorResult->company;
                $data['email'] = $vendorResult->email;
                $data['mobile'] = $vendorResult->mobile;
                $data['address'] = $vendorResult->address;
                $data['city'] = $vendorResult->city;
                $data['state_id'] = $vendorResult->state;
                $data['state'] = $stateResult->name;
                $data['pincode'] = $vendorResult->pincode;
                $data['vendor_code'] = $vendorResult->vendor_code;
                $data['gstno'] = $vendorResult->gst_no;
                $data['vendor_id'] = $vendorResult->vendor_id;
                $data['state_gst_id'] = $stateResult->state_gst_id;
            }
            return $data;
        }
    }

    public function editSalesOrder($data)
    {

        $salesorder_id = (int) $data['salesorder_id'];
        $total_amount = 0;
        $discount_amount = 0;
        $insurance_amount = 0;

        if ($salesorder_id <= 0) {
            return false;
        }
        if (empty($data['rows'])) {
            return false;
        }
        $old_rows = array();
        $new_rows = array();
        $delete_rows = array();
        $old_rows_ids = array();

        if ((int) $data['tcs_amount'] <= 0) {
            $tcs_amount = 0;
            $tcs_percent = 0;
        } else {
            $tcs_amount = $data['tcs_amount'];
            $tcs_percent = $data['tcs_percentage'];
        }

        foreach ($data['rows'] as $rowValue) {
            //For New Rows
            if ($rowValue['salesorder_item_id'] == 'new_row') {
                $new_rows[] = array(
                    "salesorder_id" => $salesorder_id,
                    "device_name" => $rowValue['device_name'],
                    "sku" => trim($rowValue['sku']),
                    "category" => $rowValue['category'],
                    "grade" => $rowValue['grade'],
                    "sale_price" => $rowValue['price'],
                    "quantity" => $rowValue["quantity"],
                    "sales_terms" => $rowValue["sales_terms"],
                    "amount" => $rowValue['price'] * $rowValue['quantity']
                );

                $total_amount += $rowValue['price'] * $rowValue['quantity'];
            }
            //Update Old Rows
            elseif ($rowValue['salesorder_item_id'] > 0) {

                $old_rows[] = array(
                    "salesorder_item_id" => $rowValue['salesorder_item_id'],
                    "sale_price" => $rowValue['price'],
                    "quantity" => $rowValue["quantity"],
                    "amount" => $rowValue['price'] * $rowValue['quantity']
                );

                $old_rows_ids[] = $rowValue['salesorder_item_id'];
                $total_amount += $rowValue['price'] * $rowValue['quantity'];
            }
        }

        if ($data['discount'] > 0) {
            $discount = $data['discount'];

            if ($data['discount_type'] == 'amount') {
                $discount_amount = $discount;
            } else {
                $discount_amount = $discount * $total_amount / 100;
            }
        }
        if ($data['insurance_value'] > 0) {
            $insurance_value = $data['insurance_value'];

            if ($data['insurance_type'] == 'amount') {
                $insurance_amount = $insurance_value;
            } else {
                $insurance_amount = $insurance_value * $total_amount / 100;
            }
        }

        $existing_rows = $this->db->select('salesorder_item_id')->where('salesorder_id', $salesorder_id)->get('tbl_salesorder_item')->result_array();

        //Find Deleted Rows Id's
        foreach ($existing_rows as $value) {
            if (!in_array($value['salesorder_item_id'], $old_rows_ids)) {
                $delete_rows[] = $value['salesorder_item_id'];
            }
        }

        $this->db->trans_start();

        $warehouse = $data["warehouse"];
        $sales_channel = $data["sales_channel"];
        $saleschannel_ref_id = $data["saleschannel_ref_id"];
        $payment_mode = $data["payment_mode"];
        $vendor_id = $data["vendor_id"];
        $res = $this->db->select('CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED) as so_num')->where('salesorder_id', $salesorder_id)->from('tbl_salesorder')->get()->row_array();
        $so_num = $res['so_num'];
        $sales_code = 'SO-' . $warehouse . '-' . $so_num;

        if ($data['status'] == 'DRAFT') {
            $status = 'DRAFT';
        } else {
            $status = 'FINANCE_PENDING';
        }

        $salesorder = array(
            'status' => $status,
            'warehouse' => $warehouse,
            'salesorder_code' => $sales_code,
            'sales_channel' => $sales_channel,
            'saleschannel_ref_id' => $saleschannel_ref_id,
            'payment_mode' => $payment_mode,
            'vendor_id' => $vendor_id,
            'discount_value' => $data['discount'],
            'discount_type' => $data['discount_type'],
            'discount_amount' => $discount_amount,
            'insurance_value' => $data['insurance_value'],
            'insurance_type' => $data['insurance_type'],
            'insurance_amount' => $insurance_amount,
            'freight_amount' => $data['freight_amount'],
            'tcs_amount' => $tcs_amount,
            'tcs_percent' => $tcs_percent,
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s")
        );

        $this->db->set($salesorder);
        $this->db->where('salesorder_id', $salesorder_id);
        $this->db->update('tbl_salesorder');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            return false;
        }

        //Insert new Rows
        if (!empty($new_rows) && $error['code'] == 0) {
            $this->db->insert_batch('tbl_salesorder_item', $new_rows);
            $error = $this->db->error();
        }

        //Upload Old Rows
        if (!empty($old_rows) && $error['code'] == 0) {
            $this->db->update_batch('tbl_salesorder_item', $old_rows, 'salesorder_item_id');
            $error = $this->db->error();
        }

        // Delete Rows
        if (!empty($delete_rows) && $error['code'] == 0) {
            $this->db->where_in('salesorder_item_id', $delete_rows);
            $this->db->delete('tbl_salesorder_item');
            $error = $this->db->error();
        }

        // Remarks
        if (!empty($data['remarks_header']) && $error['code'] == 0) {
            $remark_array = array(
                'reference_id' => $salesorder_id,
                'reference_type' => 'salesorder',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
            $error = $this->db->error();
        }

        $this->load->model('auditlog_model');
        // Insert audit log for Sales Order
        $this->auditlog_model->insert_auditlog($salesorder_id, 'salesorder', 'FINANCE_PENDING', $this->session->userdata('user_id'));

        if ($error['code'] == 0) {
            $this->db->trans_complete();
            return true;
        } else {
            $this->db->trans_rollback();
            return false;
        }
    }
}
