<?php

class Invoice_Model extends MY_Model
{
    public $_table_name;
    public $_order_by;
    public $_primary_key;

    public function get_payment_status($invoice_id)
    {

        $tax = $this->get_invoice_tax_amount($invoice_id);
        $discount = $this->get_invoice_discount($invoice_id);
        $invoice_cost = $this->get_invoice_cost($invoice_id);
        $payment_made = round($this->get_invoice_paid_amount($invoice_id), 2);
        $due = round(((($invoice_cost - $discount) + $tax) - $payment_made));
        $invoice_info = $this->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        if ($invoice_info->status == 'draft') {
            return lang('draft');
        } elseif ($invoice_info->status == 'Cancelled') {
            return lang('cancelled');
        } elseif ($payment_made < 1) {
            return lang('not_paid');
        } elseif ($due <= 0) {
            return lang('fully_paid');
        } else {
            return lang('partially_paid');
        }
    }

    public function invoice_payable($id)
    {
        return ($this->get_invoice_cost($id) + $this->get_invoice_tax_amount($id) - $this->get_invoice_discount($id));
    }


    public function invoice_perc($invoice)
    {
        $invoice_payment = $this->invoice_payment($invoice);
        $invoice_payable = $this->invoice_payable($invoice);
        if ($invoice_payable < 1 OR $invoice_payment < 1) {
            $perc_paid = 0;
        } else {
            $perc_paid = ($invoice_payment / $invoice_payable) * 100;
        }
        return round($perc_paid);
    }


    public function invoice_payment($invoice)
    {
        $this->ci->db->where('invoice', $invoice);
        $this->ci->db->select_sum('amount');
        $query = $this->ci->db->get('payments');
        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->amount;
        }
    }

    function ordered_items_by_id($id, $type = 'invoices')
    {
        $table = ($type == 'invoices' ? '' : 'estimate_') . 'tbl_items';
        $result = $this->db->where($type . '_id', $id)->order_by('order', 'asc')->get($table)->result();
        return $result;
    }

    function calculate_to($invoice_value, $invoice_id)
    {
        switch ($invoice_value) {
            case 'invoice_cost':
                return $this->get_invoice_cost($invoice_id);
                break;
            case 'tax':
                return $this->get_invoice_tax_amount($invoice_id);
                break;
            case 'discount':
                return $this->get_invoice_discount($invoice_id);
                break;
            case 'paid_amount':
                return $this->get_invoice_paid_amount($invoice_id);
                break;
            case 'invoice_due':
                return $this->get_invoice_due_amount($invoice_id);
                break;
            case 'total':
                return $this->get_invoice_total_amount($invoice_id);
                break;
        }
    }

    function get_invoice_cost($invoice_id)
    {
        $this->db->select_sum('total_cost');
        $this->db->where('invoices_id', $invoice_id);
        $this->db->from('tbl_items');
        $query_result = $this->db->get();
        $cost = $query_result->row();
        if (!empty($cost->total_cost)) {
            $result = $cost->total_cost;
        } else {
            $result = '0';
        }
        return $result;
    }


    public function get_invoice_tax_amount($invoice_id)
    {
        $invoice_info = $this->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        $tax_info = json_decode($invoice_info->total_tax);
        $tax = 0;
        if (!empty($tax_info)) {
            $total_tax = $tax_info->total_tax;
            if (!empty($total_tax)) {
                foreach ($total_tax as $t_key => $v_tax_info) {
                    $tax += $v_tax_info;
                }
            }
        }
        return $tax;
    }

    public function get_invoice_discount($invoice_id)
    {
        $invoice_info = $this->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        return $invoice_info->discount_total;

    }

    public function get_invoice_paid_amount($invoice_id)
    {

        $this->db->select_sum('amount');
        $this->db->where('invoices_id', $invoice_id);
        $this->db->from('tbl_payments');
        $query_result = $this->db->get();
        $amount = $query_result->row();
        $tax = $this->get_invoice_tax_amount($invoice_id);
        if (!empty($amount->amount)) {
            $result = $amount->amount;
        } else {
            $result = '0';
        }
        return $result;
    }

    public function get_invoice_due_amount($invoice_id)
    {

        $invoice_info = $this->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        $tax = $this->get_invoice_tax_amount($invoice_id);
        $discount = $this->get_invoice_discount($invoice_id);
        $invoice_cost = $this->get_invoice_cost($invoice_id);
        $payment_made = $this->get_invoice_paid_amount($invoice_id);
        $due_amount = (($invoice_cost - $discount) + $tax) - $payment_made + $invoice_info->adjustment;
        if ($due_amount <= 0) {
            $due_amount = 0;
        }
        return $due_amount;
    }

    public function get_invoice_total_amount($invoice_id)
    {

        $invoice_info = $this->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        $tax = $this->get_invoice_tax_amount($invoice_id);
        $discount = $this->get_invoice_discount($invoice_id);
        $invoice_cost = $this->get_invoice_cost($invoice_id);
        $payment_made = $this->get_invoice_paid_amount($invoice_id);

        $total_amount = $invoice_cost - $discount + $tax + $invoice_info->adjustment;
        if ($total_amount <= 0) {
            $total_amount = 0;
        }
        return $total_amount;
    }

    function all_invoice_amount()
    {
        $invoices = $this->db->get('tbl_invoices')->result();
        $cost[] = array();
        foreach ($invoices as $invoice) {
            $tax = round($this->get_invoice_tax_amount($invoice->invoices_id));
            $discount = round($this->get_invoice_discount($invoice->invoices_id));
            $invoice_cost = round($this->get_invoice_cost($invoice->invoices_id));

            $cost[] = ($invoice_cost + $tax) - $discount;
        }
        if (is_array($cost)) {
            return round(array_sum($cost), 2);
        } else {
            return 0;
        }
    }

    function all_outstanding()
    {
        $invoices = $this->db->get('tbl_invoices')->result();
        $due[] = array();
        foreach ($invoices as $invoice) {
            $due[] = $this->get_invoice_due_amount($invoice->invoices_id);
        }
        if (is_array($due)) {
            return round(array_sum($due), 2);
        } else {
            return 0;
        }
    }

    function client_outstanding($client_id, $project_id = null)
    {
        $due[] = array();
        if (!empty($project_id)) {
            $invoices_info = $this->db->where('project_id', $project_id)->get('tbl_invoices')->result();
        } else {
            $invoices_info = $this->db->where('client_id', $client_id)->get('tbl_invoices')->result();
        }

        foreach ($invoices_info as $v_invoice) {
            $due[] = $this->get_invoice_due_amount($v_invoice->invoices_id);
        }
        if (is_array($due)) {
            return round(array_sum($due), 2);
        } else {
            return 0;
        }
    }

    public function check_for_merge_invoice($client_id, $current_invoice)
    {

        $invoice_info = $this->db->where('client_id', $client_id)->get('tbl_invoices')->result();

        foreach ($invoice_info as $v_invoice) {
            if ($v_invoice->invoices_id != $current_invoice) {
                $payment_status = $this->get_payment_status($v_invoice->invoices_id);
                if ($payment_status == lang('not_paid') || $payment_status == lang('draft')) {
                    $invoice[] = $v_invoice;
                }
            }
        }
        if (!empty($invoice)) {
            return $invoice;
        } else {
            return array();
        }
    }

    public function get_invoice_filter()
    {
        $all_invoice = $this->get_permission('tbl_invoices');
        if (!empty($all_invoice)) {
            $all_invoice = array_reverse($all_invoice);
            foreach ($all_invoice as $v_invoices) {
                $year[] = date('Y', strtotime($v_invoices->invoice_date));
            }
        }
        if (!empty($year)) {
            $result = array_unique($year);
        }

        $statuses = array(
            array(
                'id' => 1,
                'value' => 'paid',
                'name' => lang('paid'),
                'order' => 1,
            ),
            array(
                'id' => 2,
                'value' => 'not_paid',
                'name' => lang('not_paid'),
                'order' => 2,
            ),
            array(
                'id' => 3,
                'value' => 'partially_paid',
                'name' => lang('partially_paid'),
                'order' => 3,
            ),
            array(
                'id' => 1,
                'value' => 'draft',
                'name' => lang('draft'),
                'order' => 1,
            ), array(
                'id' => 1,
                'value' => 'cancelled',
                'name' => lang('cancelled'),
                'order' => 1,
            ), array(
                'id' => 1,
                'value' => 'overdue',
                'name' => lang('overdue'),
                'order' => 1,
            ),
            array(
                'id' => 4,
                'value' => 'recurring',
                'name' => lang('recurring'),
                'order' => 4,
            ),
            array(
                'id' => 4,
                'value' => 'last_month',
                'name' => lang('last_month'),
                'order' => 4,
            ),
            array(
                'id' => 4,
                'value' => 'this_months',
                'name' => lang('this_months'),
                'order' => 4,
            )
        );
        if (!empty($result)) {
            foreach ($result as $v_year) {
                $test = array(
                    'id' => 1,
                    'value' => '_' . $v_year,
                    'name' => $v_year,
                    'order' => 1);
                if (!empty($test)) {
                    array_push($statuses, $test);
                }
            }
        }
        return $statuses;
    }

    // Get a list of recurring invoices
    public function recurring_invoices($client_id = null)
    {
        if (!empty($client_id)) {
            return $this->db->where(array('recurring' => 'Yes', 'client_id' => $client_id))->get('tbl_invoices')->result();
        } else {
            return $this->db->where(array('recurring' => 'Yes', 'invoices_id >' => 0))->get('tbl_invoices')->result();
        }
    }

    public function get_invoices($filterBy = null, $client_id = null)
    {
        if (!empty($client_id)) {
            $all_invoice = $this->db->where('client_id', $client_id)->get('tbl_invoices')->result();
        } else {
            $all_invoice = $this->get_permission('tbl_invoices');
        }
        if (empty($filterBy) || !empty($filterBy) && $filterBy == 'all') {
            return $all_invoice;
        } elseif ($filterBy == 'recurring') {
            return $this->recurring_invoices($client_id);
        } else {
            if (!empty($all_invoice)) {
                $all_invoice = array_reverse($all_invoice);
                foreach ($all_invoice as $v_invoices) {
                    if ($filterBy == 'paid') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('fully_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'not_paid') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('not_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'draft') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('draft')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'partially_paid') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('partially_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'cancelled') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('cancelled')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'overdue') {
                        $payment_status = $this->get_payment_status($v_invoices->invoices_id);
                        if (strtotime($v_invoices->due_date) < time() AND $payment_status != lang('fully_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'last_month' || $filterBy == 'this_months') {
                        if ($filterBy == 'last_month') {
                            $month = date('Y-m', strtotime('-1 months'));
                        } else {
                            $month = date('Y-m');
                        }
                        if (strtotime($v_invoices->invoice_month) == strtotime($month)) {
                            $invoice[] = $v_invoices;
                        }
                    } else if (strstr($filterBy, '_')) {
                        $year = str_replace('_', '', $filterBy);
                        if (strtotime($v_invoices->invoice_year) == strtotime($year)) {
                            $invoice[] = $v_invoices;
                        }
                    }

                }
            }
        }
        if (!empty($invoice)) {
            return $invoice;
        } else {
            return array();
        }
    }

    public function get_client_wise_invoice()
    {
        $all_invoice = $this->get_permission('tbl_invoices');
        $client_invoice = array();
        if (!empty($all_invoice)) {
            $all_invoice = array_reverse($all_invoice);
            foreach ($all_invoice as $v_invoices) {
                $due = $this->calculate_to('invoice_due', $v_invoices->invoices_id);
                if ($due != 0) {
                    $client_invoice[$v_invoices->client_id][] = $v_invoices;
                }
            }
            return $client_invoice;
        }
    }

    public function get_invoice_payment()
    {
        $all_invoice = $this->db->get('tbl_payments')->result();
        $all_method = $this->db->get('tbl_payment_methods')->result();
        if (!empty($all_invoice)) {
            $all_invoice = array_reverse($all_invoice);
            foreach ($all_invoice as $v_invoices) {
                $years[] = $v_invoices->year_paid;
            }
        }
        if (!empty($years)) {
            $result = array_unique($years);
        }

        $statuses = array(
            array(
                'id' => 4,
                'value' => 'last_month',
                'name' => lang('last_month'),
                'order' => 4,
            ),
            array(
                'id' => 4,
                'value' => 'this_months',
                'name' => lang('this_months'),
                'order' => 4,
            )
        );
        if (!empty($result)) {
            foreach ($result as $v_year) {
                $year = array(
                    'id' => 1,
                    'value' => '_' . $v_year,
                    'name' => $v_year,
                    'order' => 1);
                if (!empty($year)) {
                    array_push($statuses, $year);
                }
            }
        }
        if (!empty($all_method)) {
            foreach ($all_method as $v_method) {
                $method = array(
                    'id' => 1,
                    'value' => $v_method->payment_methods_id,
                    'name' => $v_method->method_name,
                    'order' => 1);
                if (!empty($method)) {
                    array_push($statuses, $method);
                }
            }
        }
        return $statuses;
    }

    public function get_payments($filterBy = null, $client_id = null)
    {
        if (!empty($client_id)) {
            $all_payments = $this->db->where('paid_by', $client_id)->get('tbl_payments')->result();
        } else {
            $all_payments = $this->db->get('tbl_payments')->result();
        }
        if (empty($filterBy) || !empty($filterBy) && $filterBy == 'all') {
            return $all_payments;
        } else {
            if (!empty($all_payments)) {
                foreach ($all_payments as $v_payments) {
                    if (is_numeric($filterBy)) {
                        if ($v_payments->payment_method == $filterBy) {
                            $payment[] = $v_payments;
                        }
                    } else if ($filterBy == 'last_month' || $filterBy == 'this_months') {
                        if ($filterBy == 'last_month') {
                            $month = date('m', strtotime('-1 months'));
                        } else {
                            $month = date('m');
                        }
                        if ($v_payments->month_paid == $month) {
                            $payment[] = $v_payments;
                        }
                    } else if (strstr($filterBy, '_')) {
                        $year = str_replace('_', '', $filterBy);
                        if (strtotime($v_payments->year_paid) == strtotime($year)) {
                            $payment[] = $v_payments;
                        }
                    }

                }
            }
        }

        if (!empty($payment)) {
            return $payment;
        } else {
            return array();
        }
    }

    public function total_sales($filter = null)
    {

        $total = 0;
        $all_payments = get_result('tbl_payments');
//        $currency = get_row(array('symbol' => $payment->currency));
        foreach ($all_payments as $payment) {
            $amount = $payment->amount;
//            if ($payment->currency != config_item('default_currency')) {
//                $amount = convert_currency($p->currency, $amount);
//            }
            $total += $amount;
        }
        return $total;

    }

    public function paid_by_date($year, $month = null)
    {
        $total = 0;
        if (!empty($month)) {
            $where = array('year_paid' => $year, 'month_paid' => $month);
        } else {
            $where = array('year_paid' => $year);
        }
        $payments = $this->db->where($where)->get('tbl_payments')->result();

        foreach ($payments as $p) {
            $amount = $p->amount;
//            if ($p->currency != config_item('default_currency')) {
//                $amount = Applib::convert_currency($p->currency, $amount);
//            }
            $total += $amount;
        }
        return $total;
    }

    public function get_invoice_report($filterBy = null, $range = null)
    {
        if (!empty($filterBy) && is_numeric($filterBy)) {
            $invoice = $this->db->where('client_id', $filterBy)->get('tbl_invoices')->result();
        } else {
            $all_data = $this->get_permission('tbl_invoices');
        }
        if (empty($filterBy) || !empty($filterBy) && $filterBy == 'all') {
            $invoice = $all_data;
        } elseif ($filterBy == 'recurring') {
            $invoice = $this->recurring_invoices();
        } else {
            if (!empty($all_data)) {
                $all_data = array_reverse($all_data);
                foreach ($all_data as $v_invoices) {
                    if ($filterBy == 'paid') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('fully_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'not_paid') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('not_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'draft') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('draft')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'partially_paid') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('partially_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'cancelled') {
                        if ($this->get_payment_status($v_invoices->invoices_id) == lang('cancelled')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'overdue') {
                        $payment_status = $this->get_payment_status($v_invoices->invoices_id);
                        if (strtotime($v_invoices->due_date) < time() AND $payment_status != lang('fully_paid')) {
                            $invoice[] = $v_invoices;
                        }
                    } else if ($filterBy == 'last_month' || $filterBy == 'this_months') {
                        if ($filterBy == 'last_month') {
                            $month = date('Y-m', strtotime('-1 months'));
                        } else {
                            $month = date('Y-m');
                        }
                        if (strtotime($v_invoices->invoice_month) == strtotime($month)) {
                            $invoice[] = $v_invoices;
                        }
                    } else if (strstr($filterBy, '_')) {
                        $year = str_replace('_', '', $filterBy);
                        if (strtotime($v_invoices->invoice_year) == strtotime($year)) {
                            $invoice[] = $v_invoices;
                        }
                    }
                }
            }
        }

        if (!empty($invoice)) {
            $invoices = array();

            if (!empty($range[0])) {
                foreach ($invoice as $v_invoice) {
                    if ($v_invoice->invoice_date >= $range[0] && $v_invoice->invoice_date <= $range[1]) {
                        array_push($invoices, $v_invoice);
                    }
                }
                return $invoices;
            } else {
                return $invoice;
            }
        } else {
            return array();
        }
    }

    public function get_payment_report($client_id = null, $range = null)
    {

        if (!empty($range[0])) {
            $where = array('paid_by' => $client_id, 'payment_date >=' => $range[0], 'payment_date <=' => $range[1]);
        } else if (!empty($client_id) && is_numeric($client_id)) {
            $where = array('paid_by' => $client_id);
        }
        if (!empty($where)) {
            return $this->db->where($where)->get('tbl_payments')->result();
        } else {
            return $this->db->get('tbl_payments')->result();
        }


    }

    public function createinvoice($param){
        if(!(!empty($param) && count($param['rows']) > 0)) {
            $msg = 'Please enter Device Ids';
            GOTO ERROR;
        }

        $device_ids = [];
        
        $amount=0;
        $tax=0;
        foreach($param['rows'] as $rowvalue) {
            $device_ids[] = $rowvalue['inward_id'];

            $amount+=$rowvalue['price'];
            
            if(in_array($param["sales_channel"], MARGINAL_NOT_ALLOWED_CHANNELS)){
                
                if($rowvalue['tax_type']=='CGSG12' || $rowvalue['tax_type']=='IGST12'){
                    $tax+=$rowvalue['price']-$rowvalue['price']/1.12;
                }else if(strtoupper($rowvalue['tax_type'])=='CGSG18' || $rowvalue['tax_type']=='IGST18'){
                    $tax+=$rowvalue['price']-$rowvalue['price']/1.18;
                }
            }else{
                if(strtolower($rowvalue['bill_type'])=='taxable'){
                    if($rowvalue['tax_type']=='CGSG12' || $rowvalue['tax_type']=='IGST12'){
                        $tax+=$rowvalue['price']-$rowvalue['price']/1.12;
                    }else if(strtoupper($rowvalue['tax_type'])=='CGSG18' || $rowvalue['tax_type']=='IGST18'){
                        $tax+=$rowvalue['price']-$rowvalue['price']/1.18;
                    }
                }

                if(strtolower($rowvalue['bill_type'])=='exempt'){
                    if($rowvalue['tax_type']=='CGSG12' || $rowvalue['tax_type']=='IGST12'){
                        $margin=$rowvalue['price']-($rowvalue['unit_price']+$rowvalue['unit_price_tax']);
                        $taxable=$margin/1.12;
                        $tax1=$margin-$taxable;
                        if($tax1<0){
                            $tax1=0 ;
                        } 
                        $tax+=$tax1;
                        if($margin<0) $margin=0;
                        $margin_perc=($margin/$rowvalue['price'])*100;
                    }else if($rowvalue['tax_type']=='CGSG18' || $rowvalue['tax_type']=='IGST18'){
                        $margin=$rowvalue['price']-($rowvalue['unit_price']+$rowvalue["unit_price_tax"]);
                        $taxable=$margin/1.18;
                        $tax1=$margin-$taxable;
                        if($tax1<0){
                            $tax1=0 ;
                        } 
                        $tax+=$tax1;
                        if($margin<0) $margin=0;
                        $margin_perc=($margin/$rowvalue['price'])*100;
                    }
                }
            }
        }

        /** Validating -- Devices */
        $rs = $this->db->where('status', 'RFS')->where_in('nhdin', $device_ids)->get('tbl_grnreport')->result_array();

        $eligible_devices = [];
        foreach ($rs as $key => $row) {
            $eligible_devices[] = $row['nhdin'];
        }

        $diff_arr = array_diff($device_ids, $eligible_devices);
        if (!empty($diff_arr)) {
            $msg = 'Device ID(s) ' . substr( implode(',', $diff_arr), 0, 45) . ((count($diff_arr) > 3)? '...':'') . ' not found in RFS';
            GOTO ERROR;
        }

        //Get salesman Id AND module_type 
        $query1=$this->db->select('salesman_code, module_type')->from('tbl_salesorder')->where('salesorder_id',$param["salesorder_id"])->get();
        $result1=$query1->row_array();
        $salesman_id = $result1['salesman_code'];
        $module_type = $result1['module_type'];
	$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr($param["warehouse"], 0, 1);

        if ($module_type == 1) {
            $series = "SL".$string.$current_year.$next_year;
            $res = $this->db->from('tbl_invoice AS inv')
                            ->join('tbl_salesorder AS so', 'so.salesorder_id = inv.salesorder_id AND so.module_type = 1', 'INNER')
                            ->like('inv.invoice_code',$series)
                            ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
                            ->get()->row_array();
            
            $next_number=$res['max']+1;
            if($res['max']==null) $next_number=1;
            $invoice_code=$series.'-'.$next_number;

        } else if ($module_type == 2) {
            $series = "SLE".$current_year.$next_year;
            $res = $this->db->from('tbl_invoice AS inv')
                            ->join('tbl_salesorder AS so', 'so.salesorder_id = inv.salesorder_id AND so.module_type = 2', 'INNER')
                            ->like('inv.invoice_code',$series)
                            ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
                            //->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"/",-1) as UNSIGNED)) as max')
                            ->get()->row_array();

            $next_number = ($res['max']==null)? 1 : $res['max']+1;
            $invoice_code = $series."-".$next_number;

            /* No Tax for Exporting */
            //$tax = 0;
            
        } else {
            GOTO ERROR;
        }

        $invoice_header=array(
            "vendor_id"=>$param["vendor_id"],
            "invoice_code"=>$invoice_code,
            "salesorder_id"=>$param["salesorder_id"],
            "salesman_id"=>$salesman_id,
            "sales_channel"=>$param["sales_channel"],
            "warehouse"=>$param["warehouse"],
            "status"=>"INVOICED",
            "invoice_amount"=>$amount,
            "tax_amount"=>$tax,
            "payment_mode"=>$param["payment_mode"],
            "CREATION_DATE"=>date("Y-m-d H:i:s"),
            "CREATED_BY"=>$this->session->userdata('user_id')
        );
        $this->db->trans_start();

        $this->db->insert('tbl_invoice',$invoice_header);
        $error=$this->db->error();
        if($error["code"] != 0) GOTO ERROR;

        $invoice_id=$this->db->insert_id();
        $rowdata=array();
        $sold_products=array();

        $reference_type = ($module_type == 2)? 'export_invoice' : 'invoice';
        if(!empty($param['remarks_header'])){
            $remark_array=array(
                'reference_id'=>$invoice_id,
                'reference_type'=> $reference_type,
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$param['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark',$remark_array);
            $error=$this->db->error();
        }
        $this->load->model('auditlog_model');
        // Insert audit log for invoice
        $this->auditlog_model->insert_auditlog($invoice_id, $reference_type,'INVOICED',$this->session->userdata('user_id'));
        
        foreach($param["rows"] as $value){
            $tax=0;
            $margin=0;
            $margin_perc=0;
            if(in_array($param["sales_channel"], MARGINAL_NOT_ALLOWED_CHANNELS)){
                if($value['tax_type']=='CGSG12' || $value['tax_type']=='IGST12'){
                    $tax=$value['price']-$value['price']/1.12;
                    $taxable = $value['price']/1.18;
                    $exempt=0.00;
                }else if($value['tax_type']=='CGSG18' || $value['tax_type']=='IGST18'){
                    $tax=$value['price']-$value['price']/1.18;
                    $taxable = $value['price']/1.18;
                    $exempt=0.00;
                }
            }else{
                if(strtolower($value['bill_type'])=='taxable'){
                    if($value['tax_type']=='CGSG12' || $value['tax_type']=='IGST12'){
                        $tax=$value['price']-$value['price']/1.12;
                        $taxable = $value['price']/1.18;
                        $exempt=0.00;
                    }else if($value['tax_type']=='CGSG18' || $value['tax_type']=='IGST18'){
                        $tax=$value['price']-$value['price']/1.18;
                        $taxable = $value['price']/1.18;
                        $exempt=0.00;
                    }
                }

                if(strtolower($value['bill_type'])=='exempt'){
                    if($value['tax_type']=='CGSG12' || $value['tax_type']=='IGST12'){
                        $margin=$value['price']-($value['unit_price']+$value['unit_price_tax']);
                        $exempt = $value['unit_price']+$value['unit_price_tax'];
                        $taxable=$margin/1.12;
                        $tax=$margin-$taxable;
                        if($margin<0) $margin=0;
                        
                        if($exempt > $value['price']){
                            $exempt = $value['price'];
                            $tax=0;
                            $taxable =0;
                        }

                        $margin_perc=($margin/$value['price'])*100;
                    }else if($value['tax_type']=='CGSG18' || $value['tax_type']=='IGST18'){
                        $margin=$value['price']-($value['unit_price']+$value['unit_price_tax']);
                        $exempt = $value['unit_price']+$value['unit_price_tax'];
                        $taxable=$margin/1.18;
                        $tax=$margin-$taxable;
                        if($margin<0) $margin=0;
                        if($exempt > $value['price']){
                            $exempt = $value['price'];
                            $tax=0;
                            $taxable =0;
                        }
                        $margin_perc=($margin/$value['price'])*100;
                    }
                }
            }

            // if ($module_type == 2)  {
            //     /* No Tax for Exporting */
            //     $tax = 0;
            //     $taxable = 0;
            //     $exempt = $value["price"];
            //     $value["tax_type"] = 'NA';
            //     $value["bill_type"] = 'EXEMPT';
            $row=array(
                "invoice_id"=>$invoice_id,
                "grnreport_id"=>$value["grnreport_id"],
                "deviceid"=>$value["inward_id"],
                "price"=>$value["price"],
                "tax_amount"=>$tax,
                "taxable_amount"=>$taxable,
                "exempt_amount"=>$exempt,
                "margin"=>$margin,
                "margin_perc"=>$margin_perc,
                "sales_terms"=>$value["sales_terms"],
                "category"=>$value["category"],
                "grade"=>$value["grade"],
                "tax_type"=>$value["tax_type"],
                "bill_type"=>$value["bill_type"],
                "CREATION_DATE"=>date("Y-m-d H:i:s")
            );
            array_push($rowdata,$row);

            $sold_items=array(
                "grnreport_id"=>$value["grnreport_id"],
                "status"=>"SOLD",
                "remark" => $invoice_code
            );

            array_push($sold_products,$sold_items);

            //Insert auditlog for device
            // $this->Auditlog_model->insert_grnreportAudit($value["grnreport_id"],$this->session->userdata("user_id"),"SOLD",$value["inward_id"]);
        }
        $this->db->insert_batch('tbl_invoice_item',$rowdata);
        $error=$this->db->error();

        if($error['code']==0) {
            $this->db->update_batch('tbl_grnreport',$sold_products,'grnreport_id');
            $error=$this->db->error();
            if($error["code"]==0){
                $this->db->where("salesorder_id",$param["salesorder_id"]);
                $this->db->update('tbl_salesorder',array("status"=>"INVOICED","LAST_UPDATED_BY"=>$this->session->userdata('user_id')));
                $error=$this->db->error();

                $reference_type = ($module_type == 2)? 'export_salesorder' : 'salesorder';
                $this->auditlog_model->insert_auditlog($param["salesorder_id"], $reference_type,'INVOICED',$this->session->userdata('user_id'));
            }
        }
        if($error["code"] != 0) { GOTO ERROR; }

        $this->db->trans_complete();

        return [
            'status' => true,
            'message' => 'Invoice created Successfully',
            'invoice_id' => $invoice_id
        ];

        ERROR:
        $this->db->trans_rollback();
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something wrong',
            'error' => isset($error)? $error : ''
        ];
    }

    public function bulk_so_invoice_creation($data) {
        // echo json_encode($data); exit;

        $device_ids = [];
        $so_code_wise = [];
        foreach($data['devices'] as $row) {
            $device_ids[] = $row['deviceid'];
            $so_code_wise[$row['so_code']][] = $row['deviceid'];
        }
        $so_codes = array_keys($so_code_wise);

        /** Validating -- Devices */
        $rs = $this->db->where('saletype', 'SELLERFLEX')->where('status', 'RFS')->where_in('nhdin', $device_ids)->get('tbl_grnreport')->result_array();

        $eligible_devices = [];
        $device_details = [];
        foreach ($rs as $key => $row) {
            $eligible_devices[] = $row['nhdin'];
            $device_details[$row['nhdin']] = $row;
        }

        $diff_arr = array_diff($device_ids, $eligible_devices);
        if (!empty($diff_arr)) {
            $msg = 'Device ID(s) ' . substr( implode(',', $diff_arr), 0, 45) . '... not found in SELLERFLEX / RFS';
            GOTO ERROR;
        }


        /** Validating -- SO_Codes */
        $result = $this->db->where_in('salesorder_code', $so_codes)->where('status', 'FINANCE_APPROVED')->get('tbl_salesorder')->result_array();
        $eligible_so_codes = [];
        $so_ids = [];
        foreach ($result as $key => $row) {
            $eligible_so_codes[] = $row['salesorder_code'];
            $so_ids[] = $row['salesorder_id'];
        }

        $diff_arr = array_diff($so_codes, $eligible_so_codes);
        if (!empty($diff_arr)) {
            $msg = 'SO_Code(s) ' . substr( implode(',', $diff_arr), 0, 40) . '... are not FINANCE_APPROVED';
            // GOTO ERROR;
        }

        
        /** Checking -- SO's are not Invoiced */
        $inv_result = $this->db->where_in('salesorder_id', $so_ids)->get('tbl_invoice')->result_array();
        if (!empty($inv_result)) {
            $inv = [];
            foreach ($inv_result as $inv_res) {
                $inv[] = $inv_res['invoice_code'];
            }
            $msg = 'Invoice already generated for Some orders. ' . substr( implode(',', $inv), 0, 45) . '...';
            GOTO ERROR;
        }

        
        /** Checking -- SO and Device are mapped correctly or not  */
        foreach($so_code_wise as $so_code => $arr) {
            $rs = $this->db->from('tbl_salesorder AS so')
                          ->join('tbl_salesorder_item AS si', 'si.salesorder_id = so.salesorder_id')
                          ->join('tbl_grnreport AS d', 'd.grnreport_id = si.grnreport_id')
                          ->where('so.salesorder_code', $so_code)
                        //   ->where_in('d.nhdin', $arr)
                          ->select('d.nhdin')
                          ->get()->result_array();

            $eligible_so_devices = array_column($rs, 'nhdin');

            $diff_arr = array_diff($arr, $eligible_so_devices);
            if (!empty($diff_arr)) {
                $msg = 'SO_Code "' . $so_code . '" is not for ' . substr( implode(',', $diff_arr), 0, 45) . '...';
                GOTO ERROR;
            }
            if (count($arr) != count($eligible_so_devices)) {
                $msg = 'Please fill all Devices under the SO_Code "' . $so_code . '"';
                GOTO ERROR;
            }
        }


        /** ===================== Invoice Creation ===================== */

        $so_Ids_arr = [];
        
		$this->db->trans_start();

        foreach($so_code_wise as $so_code => $arr) {
            $rs = $this->db->where('salesorder_code', $so_code)->get('SALESORDER_RFS_LIST_VIEW')->result_array();
            if (count($rs) == 0) {
                GOTO ERROR;
            }
            $so_view = $rs[0];

            $salesorder_id = $so_view['salesorder_id'];
            $so_Ids_arr[] = $salesorder_id;

            $sales_order = $this->db->where("salesorder_id", $salesorder_id)->get('tbl_salesorder')->row();

            
            $vendorResult = $this->db->where('vendor_id', $so_view['vendor_id'])->get('tbl_vendor')->row();
            $stateResult = $this->db->select('name, state_gst_id')->where('state_id', $vendorResult->state)->get('tbl_states')->row();

            if ($stateResult->state_gst_id == 36) {
                $tax_type = 'CGST18';
            } else {
                $tax_type = 'IGST18';
            }

            $so_items = $this->db->where("salesorder_id", $salesorder_id)->get('tbl_salesorder_item')->result_array();
            
            $sold_items = [];
            $inv_rows = array();
            $total_amount = 0;
            $total_tax = 0;

            foreach ($so_items as $rowValue) {
                $grn_id = $rowValue['grnreport_id'];

                $grnreport = $this->db->select('status, unit_price, unit_price_tax, stock_type, saletype, nhdin, invoice_type, bundle_id')->where('grnreport_id', $grn_id)->get('tbl_grnreport')->row();

                if (!isset($grnreport)) {
                    $msg = 'Error in Fetching Device Data';
                    GOTO ERROR;
                }
                if ($grnreport->status != 'RFS') {
                    $msg = $grnreport->nhdin . ' status is not RFS';
                    GOTO ERROR;
                }
                if ($grnreport->saletype != $sales_order->sales_channel) {
                    $msg = $grnreport->nhdin . ' saletype is mismatching with SO saletype';
                    GOTO ERROR;
                }

                $inv_status = ['INVOICED', 'PACKED', 'SHIPPED'];
                $rs_invoice = $this->db->select('inv.status, inv.invoice_code')
                            ->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id', 'Left')
                            ->where('ini.grnreport_id', $grn_id)
                            ->where_in('inv.status', $inv_status)
                            ->get('tbl_invoice_item AS ini')
                            ->result_array();
                if (!empty($rs_invoice)) {
                    $msg = $grnreport->nhdin . ' is already Invoiced';
                    GOTO ERROR;
                }
                
                $tax=0;
                $margin=0;
                $margin_perc=0;
                
                if (in_array($sales_order->sales_channel, MARGINAL_NOT_ALLOWED_CHANNELS)) {
                    $bill_type = 'TAXABLE';
                    
                    $tax = $rowValue['sale_price'] - $rowValue['sale_price'] / 1.18;
                    $taxable = $rowValue['sale_price'] / 1.18;
                    $exempt = 0.00;

                } else {
                    $bill_type = $grnreport->invoice_type;

                    if (strtolower($grnreport->invoice_type) == 'exempt') {

                        $margin = $rowValue['sale_price'] - ($grnreport->unit_price + $grnreport->unit_price_tax);
                        $exempt = $grnreport->unit_price + $grnreport->unit_price_tax;
                        $taxable = $margin / 1.18;
                        $tax = $margin - $taxable;

                        if ($margin < 0) $margin = 0;

                        if ($exempt > $rowValue['sale_price']) {
                            $exempt = $rowValue['sale_price'];
                            $tax = 0;
                            $taxable = 0;
                        }
                        $margin_perc = ($margin / $rowValue['sale_price']) * 100;
                        
                    } else {
                        $tax = $rowValue['sale_price'] - $rowValue['sale_price'] / 1.18;
                        $taxable = $rowValue['sale_price'] / 1.18;
                        $exempt = 0.00;
                    }
                }

                $total_amount += $rowValue['sale_price'];
                $total_tax += $tax;

                $inv_rows[] = array(
                    "grnreport_id" => $rowValue['grnreport_id'],
                    "deviceid" => $grnreport->nhdin,
                    "price" => $rowValue['sale_price'],
                    "tax_amount" => $tax,
                    "taxable_amount" => $taxable,
                    "exempt_amount" => $exempt,
                    "margin" => $margin,
                    "margin_perc" => $margin_perc,
                    "sales_terms" => $rowValue["sales_terms"],
                    "category" => $rowValue["category"],
                    "grade" => $rowValue["grade"],
                    "tax_type" => $tax_type,
                    "bill_type" => $bill_type,
                    "CREATION_DATE" => date("Y-m-d H:i:s")
                );
            }

            $salesman_id = $sales_order->salesman_code;
	    $current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
            $next_year = $current_year + 1;
            $string = substr($sales_order->warehouse, 0, 1);
            $series = "SL".$string.$current_year.$next_year;

            $res = $this->db->from('tbl_invoice AS inv')
                          ->join('tbl_salesorder AS so', 'so.salesorder_id = inv.salesorder_id AND so.module_type = 1', 'INNER')
                          ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
			  ->like('inv.invoice_code',$series)
                          ->get()->row_array();
            
            $next_number = ($res['max'] == null)? 1 : $res['max'] + 1;

            //$invoice_code = 'SLY-' . $sales_order->warehouse . '-' . $next_number;
	    $invoice_code=$series.'-'.$next_number;
            $invoice_header = array(
                "vendor_id" => $sales_order->vendor_id,
                "invoice_code" => $invoice_code,
                "salesorder_id" => $salesorder_id,
                "salesman_id" => $salesman_id,
                "sales_channel" => $sales_order->sales_channel,
                "warehouse" => $sales_order->warehouse,
                "status" => "INVOICED",
                "invoice_amount" => $total_amount,
                "tax_amount" => $total_tax,
                "payment_mode" => $sales_order->payment_mode,
                "CREATION_DATE" => date("Y-m-d H:i:s"),
                "CREATED_BY" => $this->session->userdata('user_id')
            );

            $this->db->insert('tbl_invoice', $invoice_header);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }

            $invoice_id = $this->db->insert_id();

            foreach ($inv_rows as $key => $rowValue) {
                $inv_rows[$key]['invoice_id'] = $invoice_id;
    
                $sold_items[] = array(
                    "grnreport_id" => $rowValue["grnreport_id"],
                    "status" => "SOLD",
                    "remark" => $invoice_code
                );
            }
            
            //Insert Invoice Items
            $this->db->insert_batch('tbl_invoice_item', $inv_rows);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }
            
            //Change Device Status
            $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }

            //Change Sales Order Status
            $this->db->where("salesorder_id", $salesorder_id)->update('tbl_salesorder', array("status" => "INVOICED", "LAST_UPDATED_BY" => $this->session->userdata('user_id')));
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }

            $this->load->model('auditlog_model');
            $this->auditlog_model->insert_auditlog(
                $invoice_id,
                'invoice',
                'INVOICED',
                $this->session->userdata('user_id')
            );

        }
        
		$this->db->trans_complete();

        foreach($so_Ids_arr as $so) {
            // $this->cliq_api->postSalesImage($so);
        }

        return[
			"status" => true,
			'message' => count($so_code_wise) . ' SO\'s are Invoiced successfully'
		];

        ERROR:
		$this->db->trans_rollback();

        return [
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ];

    }

   /* public function get_invoicelist($status=null){

        $this->db->select('tbl_invoice.invoice_id,tbl_invoice.invoice_code,tbl_invoice.status,tbl_invoice.CREATION_DATE,count(tbl_invoice_item.invoice_item_id) as quantity');
        $this->db->select(',tbl_invoice.LAST_UPDATE_DATE,tbl_invoice.CREATED_BY,tbl_invoice.LAST_UPDATED_BY,tbl_vendor.company as vendor_name');
        $this->db->select(',tbl_account_details.fullname as salesman,tbl_invoice.sales_channel, tbl_salesorder.saleschannel_ref_id,tbl_invoice.payment_mode,tbl_salesorder.salesorder_code as sales_code');
        $this->db->select('tbl_salesorder.discount_amount, tbl_salesorder.freight_amount, tbl_salesorder.insurance_amount, tbl_salesorder.tcs_amount');
        $this->db->select(',tbl_users.username as CREATED_BY,u.username as LAST_UPDATED_BY, tbl_invoice.invoice_amount as amount,tbl_invoice.tax_amount as tax');
        $this->db->from('tbl_invoice')->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id','Left');
        $this->db->join('tbl_account_details','tbl_account_details.user_id=tbl_invoice.salesman_id','Left');
        $this->db->join('tbl_users','tbl_users.user_id=tbl_invoice.CREATED_BY','Left');
        $this->db->join('tbl_users as u','u.user_id=tbl_invoice.LAST_UPDATED_BY','Left');
        $this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_invoice.salesorder_id','Left');
        $this->db->join('tbl_invoice_item','tbl_invoice_item.invoice_id=tbl_invoice.invoice_id','Left');
        if($status!=""){
            $this->db->where('tbl_invoice.status',$status);
        }
        $this->db->group_by('tbl_invoice.invoice_id');
        $query=$this->db->order_by('tbl_invoice.CREATED_BY','asc')->get();
        $result= $query->result_array();
        return $result;

    }
*/
    public function getinvoicedetails($invoiceid){

        $this->db->select("tbl_invoice_item.invoice_item_id,tbl_invoice_item.grnreport_id,tbl_invoice_item.slycost,tbl_invoice_item.slysp,tbl_invoice_item.margin,tbl_grnreport.unit_price,tbl_grnreport.unit_price_tax");
        $this->db->select(",tbl_invoice_item.category,tbl_invoice_item.price,tbl_grnreport.color,tbl_grnreport.ram,tbl_grnreport.rom,tbl_grnreport.certification_grade as grade");
        $this->db->select("tbl_invoice_item.margin_perc,tbl_invoice_item.sales_terms,tbl_invoice_item.tax_type,tbl_invoice_item.tax_amount");
        $this->db->select(",tbl_invoice_item.bill_type,tbl_grnreport.device_name,tbl_grnreport.imei1_no as imei,tbl_grnreport.nhmod,tbl_grnreport.nhdin,tbl_colorcode.color_code");
        $this->db->from("tbl_invoice_item");
        $this->db->join("tbl_grnreport","tbl_grnreport.grnreport_id=tbl_invoice_item.grnreport_id","Left");
        $this->db->join('tbl_colorcode','tbl_colorcode.color=tbl_grnreport.color','Left');
        $this->db->where('invoice_id',$invoiceid);
        $query=  $this->db->get();
        $result=$query->result_array();

        return $result;
    }

    public function getInvoiceRows_pdf($invoiceid){
        $this->db->select('tbl_invoice.invoice_code,tbl_invoice.invoice_id,tbl_invoice.CREATION_DATE,tbl_vendor.company,tbl_vendor.address,tbl_vendor.city,tbl_states.name as state,tbl_states.state_gst_id as state_id,tbl_vendor.pincode');
        $this->db->select(',tbl_invoice.LAST_UPDATE_DATE,tbl_vendor.company as vendor_name,tbl_vendor.gst_no,tbl_vendor.pan_card,tbl_salesorder.sales_channel,tbl_salesorder.saleschannel_ref_id');
        $this->db->select(',tbl_invoice.payment_mode,tbl_salesorder.salesorder_code as sales_code,tbl_account_details.sales_code as salesman,tbl_salesorder.warehouse');
        $this->db->select(',tbl_invoice.invoice_amount as amount,tbl_invoice.tax_amount as tax, tbl_salesorder.discount_amount, tbl_salesorder.freight_amount');
        $this->db->select('tbl_salesorder.insurance_amount, tbl_salesorder.tcs_amount, tbl_salesorder.tcs_percent');
        $this->db->from('tbl_invoice')->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id','Left');
        $this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_invoice.salesorder_id','Left');
        $this->db->join('tbl_states','tbl_vendor.state=tbl_states.state_id','Left');
        $this->db->join('tbl_account_details','tbl_account_details.user_id=tbl_salesorder.salesman_code','Left');
        $this->db->where('tbl_invoice.invoice_id',$invoiceid);
        $query1=$this->db->order_by('invoice_id','ASC')->get();
        $invoiceheader=$query1->result_array();

        $this->db->select("tbl_invoice_item.tax_amount,tbl_grnreport.certification_grade,tbl_grnreport.invoice_type,tbl_invoice_item.category,tbl_grnreport.unit_price,tbl_grnreport.unit_price_tax");
        $this->db->select(",tbl_invoice_item.price,tbl_grnreport.color,tbl_grnreport.ram,tbl_grnreport.rom,tbl_invoice_item.tax_type,tbl_invoice_item.sales_terms,tbl_invoice_item.bill_type");
        $this->db->select(",tbl_grnreport.device_name,tbl_grnreport.nhmod,tbl_grnreport.nhdin,tbl_colorcode.color_code,tbl_grnreport.imei1_no as imei");
        $this->db->from("tbl_invoice_item");
        $this->db->join("tbl_grnreport","tbl_grnreport.grnreport_id=tbl_invoice_item.grnreport_id","Left");
        $this->db->join('tbl_colorcode','tbl_colorcode.color=tbl_grnreport.color','Left');
        $this->db->where('invoice_id',$invoiceid);
        //$this->db->group_by('nhmod,ram,rom,grade,category,color');
        $query2=  $this->db->get();
        $result_rows=$query2->result_array();

        $data["header"]=$invoiceheader;
        $data["rows"]=$result_rows;

        return $data;
    }

    public function getPackedList($invoiceid){
        $this->db->select('tbl_invoice.invoice_code,tbl_invoice.CREATION_DATE,tbl_vendor.company');
        $this->db->select(',tbl_salesorder.salesorder_code as sales_code');
        $this->db->from('tbl_invoice')->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id','Left');
        $this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_invoice.salesorder_id','Left');
        $this->db->where('tbl_invoice.invoice_id',$invoiceid);
        $query1=$this->db->order_by('invoice_id','ASC')->get();
        $invoiceheader=$query1->result_array();

        $this->db->select("tbl_grnreport.certification_grade,tbl_invoice_item.category,count(tbl_invoice_item.invoice_item_id) as quantity");
        $this->db->select(",tbl_invoice_item.price,tbl_grnreport.color,tbl_grnreport.bin_number,tbl_grnreport.ram,tbl_grnreport.rom");
        $this->db->select(",tbl_grnreport.device_name,tbl_grnreport.nhmod,tbl_colorcode.color_code");
        $this->db->from("tbl_invoice_item");
        $this->db->join("tbl_grnreport","tbl_grnreport.grnreport_id=tbl_invoice_item.grnreport_id","Left");
        $this->db->join('tbl_colorcode','tbl_colorcode.color=tbl_grnreport.color','Left');
        $this->db->where('invoice_id',$invoiceid);
        $this->db->group_by('nhmod,ram,rom,grade,category,color');
        $query2=  $this->db->get();
        $result_rows=$query2->result_array();

        $data["header"]=$invoiceheader;
        $data["rows"]=$result_rows;

        return $data;
    }

    public function getInvoiceSummary($invoice_id){
        $this->db->select('tbl_invoice.invoice_code,tbl_invoice.CREATION_DATE,tbl_vendor.company,tbl_invoice.invoice_id');
        $this->db->from('tbl_invoice')->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id','Left');
        $this->db->where('tbl_invoice.invoice_id',$invoice_id);
        $query1=$this->db->order_by('invoice_id','ASC')->get();
        $invoiceheader=$query1->row_array();

        $this->db->select('count(invoice_item_id) as quantity ')->from('tbl_invoice_item')->where('invoice_id',$invoice_id);
        $query2=$this->db->group_by('invoice_id')->get();
        $count=$query2->row_array();
        $data["header"]=$invoiceheader;
        $data['count']=$count;
        return $data;
    }

    public function createPackedList($invoice_id,$package){
        if(!empty($package)){
            $this->db->trans_start();
            $this->db->insert_batch('tbl_packinglist',$package);
            $error=$this->db->error();
            if($error['code']==0){
                $this->db->where('invoice_id',$invoice_id)->update('tbl_invoice',array("status"=>'PACKED'));
                $error=$this->db->error();
            }
        }else{
            return false;
        }

        if($error['code']==0){
            $this->db->trans_complete();
            return true;
        }else{
            $this->db->trans_rollback();
            return false;
        }
        
    }

    public function bulk_package_update($data) {
        // echo json_encode($data); exit;

        $inv_codes = [];
        foreach($data['package_data'] as $key => $arr) {
            if (!in_array($arr['invoice_code'], $inv_codes)) {
                $inv_codes[] = $arr['invoice_code'];
            }
        }

        /** Check Valid Invoice Codes */
        $rs = $this->db->from('tbl_invoice AS inv')
                       ->where_in('inv.invoice_code', $inv_codes)
                       ->where('inv.status', 'INVOICED')
                       ->select('inv.invoice_id, inv.invoice_code')
                       ->get()->result_array();

        $eligible_inv_codes = [];
        $inv_code_ids = [];
        foreach($rs as $arr) {
            $eligible_inv_codes[] = $arr['invoice_code'];
            $inv_code_ids[ $arr['invoice_code'] ] = $arr['invoice_id'];
        }
        
        $diff_arr = array_diff($inv_codes, $eligible_inv_codes);
        if (!empty($diff_arr)) {
            $msg = 'Some Invoices are not in Invoiced Stage - ' . substr( implode(',', $diff_arr), 0, 45) . '...';
            GOTO ERROR;
        }

        /** Check whether Invoice Item's Package Details updated or not */
        $rs = $this->db->from('tbl_invoice_item AS ini')
                       ->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id')
                       ->where_in('inv.invoice_code', $inv_codes)
                       ->where('(ini.box_number is null or ini.box_number = 0)')
                       ->select('inv.invoice_id, inv.invoice_code')
                       ->get()->result_array();
        
        $non_eligible_inv_codes = [];
        foreach($rs as $arr) {
            $non_eligible_inv_codes[] = $arr['invoice_code'];
        }
        
        if (!empty($non_eligible_inv_codes)) {
            $msg = 'Some Invoice\'s Package Details not yet added - ' . substr( implode(',', $non_eligible_inv_codes), 0, 45) . '...';
            GOTO ERROR;
        }

        /** Fetching Boxes(or)Package Details */
        $rs_inv_pck = $this->db->from('tbl_invoice_item AS ini')
                       ->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id', 'INNER')
                       ->where_in('inv.invoice_code', $inv_codes)
                       ->where('inv.status', 'INVOICED')
                       ->select('inv.invoice_id, inv.invoice_code, ini.box_number, COUNT(DISTINCT ini.invoice_item_id) AS total_inv_items')
                       ->group_by('inv.invoice_id, ini.box_number')
                       ->get()->result_array();

        $inv_box_dtl = [];
        foreach($rs_inv_pck as $arr) {
            $inv_box_dtl[ $arr['invoice_code'] ][  $arr['box_number'] ] = $arr['total_inv_items'];
        }
        

        /** Comparing the Uploaded BoxWise Quantity data with Stored Package Details */
        foreach($data['package_data'] as $key => $arr) {
            if (!isset( $inv_box_dtl[ $arr['invoice_code'] ][ $arr['package_num'] ] )
            || ($inv_box_dtl[ $arr['invoice_code'] ][ $arr['package_num'] ] != $arr['package_qty'])) {
                $msg = 'Quantity for InvCode: ' .$arr['invoice_code']. ' in Package No:' .$arr['package_num']. ' is mismatched with the Package Details';
                GOTO ERROR;
            }
            unset($inv_box_dtl[ $arr['invoice_code'] ][ $arr['package_num'] ]);
            if (empty($inv_box_dtl[ $arr['invoice_code'] ])) {
                unset($inv_box_dtl[ $arr['invoice_code'] ]);
            }
        }

        if (!empty($inv_box_dtl)) {
            $msg = 'Package Details are missing for some Invoice Codes - ' . substr( implode(',', array_keys($inv_box_dtl) ), 0, 45) . '...';
            GOTO ERROR;
        }

        /** Saving the Uploaded Data */

        $inv_ids = [];
        $pck_data = [];
        foreach($data['package_data'] as $key => $arr) {
            $pck_data[] = [
                'invoice_id' => $inv_code_ids[ $arr['invoice_code'] ],
                'package_no' =>  $arr['package_num'],
                'quantity' => $arr['package_qty'],
                'remark' => $arr['remarks'],
                'user_id' => $this->session->userdata('user_id')
            ];

            $inv_ids[] = $inv_code_ids[ $arr['invoice_code'] ];
        }
        $inv_ids = array_unique($inv_ids);

        if (count($pck_data) == 0 || count($inv_ids) == 0) {
            $msg = 'Please fill CSV File';
            GOTO ERROR;
        }

        $this->db->trans_start();
        
        $this->db->insert_batch('tbl_packinglist',$pck_data);
        if($this->db->error()['code'] != 0) { GOTO ERROR; }

        $this->db->where_in('invoice_id', $inv_ids)->update('tbl_invoice',array("status"=>'PACKED'));
        if($this->db->error()['code'] != 0) { GOTO ERROR; }

        $this->db->trans_complete();

        
        return[
			"status" => true,
			'message' => count($inv_ids) . ' Invoices\'s are Packed successfully'
		];

        ERROR:
		$this->db->trans_rollback();

        return [
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ];
    }

    
    public function getInvoicePackages(){
        $this->db->select('count(tbl_packinglist.packinglist_id) as no_packages,sum(tbl_packinglist.quantity) as quantity');
        $this->db->select('tbl_invoice.invoice_id,tbl_invoice.invoice_code,tbl_vendor.company as vendor_name,tbl_packinglist.date');
        $this->db->from('tbl_packinglist');
        $this->db->join('tbl_invoice','tbl_packinglist.invoice_id=tbl_invoice.invoice_id');
        $this->db->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id');
        $this->db->where('tbl_invoice.status','PACKED');
        $this->db->group_by('tbl_packinglist.invoice_id');
        $query=$this->db->get();
        $result=$query->result_array();
        $error=$this->db->error();
        if($error['code']==0){
            return $result;
        }else{
            return null;
        }
    }

    public function getInvoiceAmount($invoice_id){
        if($invoice_id>0){
            $query=$this->db->select('sum(price) as amount')->from('tbl_invoice_item')->where('invoice_id',$invoice_id)->group_by('invoice_id')->get();
            $result=$query->row();
            if(!empty($result)){
                return $result;
            }else{
                return false;
            }

        }
    }

    public function createShipping($invoice_id,$data){
        if($invoice_id>0 && !empty($data)){
            $this->db->trans_start();
            $this->db->insert('tbl_shipping_list',$data);
            $id=$this->db->insert_id();
            if($id>0){
                $this->db->where("invoice_id",$invoice_id);
                $this->db->update('tbl_invoice',array("status"=>'SHIPPED',"LAST_UPDATED_BY"=>$this->session->userdata('user_id')));
                $error=$this->db->error();
                if($error['code']==0){
                    $this->db->trans_complete();
                    return $id;
                }else{
                    $this->db->trans_rollback();
                    return false;
                }
            }else{
                $this->db->trans_rollback();
                return false;
            }
            
        }else{
            return false;
        }
    }

    public function getShippingList(){
        $this->db->select('tbl_shipping_list.shipping_list_id,tbl_shipping_list.invoice_id, tbl_shipping_list.delivery_mode, tbl_shipping_list.logistics_partner_name');
        $this->db->select('tbl_shipping_list.docket_number, tbl_shipping_list.pickup_boy, tbl_shipping_list.employee_name, tbl_shipping_list.transporter');
        $this->db->select('tbl_shipping_list.user_id, tbl_shipping_list.eway_bill, tbl_shipping_list.eway_bill_date, tbl_shipping_list.CREATION_DATE');
        $this->db->select('tbl_invoice.invoice_id,tbl_invoice.invoice_code,tbl_vendor.company as vendor_name');
        $this->db->from('tbl_shipping_list');
        $this->db->join('tbl_invoice','tbl_shipping_list.invoice_id=tbl_invoice.invoice_id');
        $this->db->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id');
        $this->db->where('tbl_invoice.status','SHIPPED');

        $query=$this->db->get();
        $result=$query->result_array();
        
        $error=$this->db->error();
        if($error['code']==0){
            return $result;
        }else{
            return null;
        }
    }

    public function rejectInvoice($invoice_id,$remark){
        if($invoice_id>0){
            $this->db->trans_start();

            $this->db->where("invoice_id",$invoice_id);
            $this->db->update('tbl_invoice',array("status"=>'rejected',"LAST_UPDATED_BY"=>$this->session->userdata('user_id')));
            $error=$this->db->error();
            if($error['code']==0){
                if(strlen($remark)>0){
                    $remark_data=array(
                        "reference_id"=>$invoice_id,
                        "reference_type"=>"invoice",
                        "remark"=>$remark,
                        "user_id"=>$this->session->userdata('user_id')
                    );
                    $this->db->insert('tbl_remark',$remark_data);
                    $id=$this->db->insert_id();
                    if($id>0){
                        $this->db->trans_complete();
                        return true;
                    }else{
                        $this->db->trans_rollback();
                        return false;
                    }
                }else{
                    $this->db->trans_complete();
                    return true; 
                }
               
            }else{
                $this->db->trans_rollback();
                return false;
            }
        }else{
            return false;
        }
    }

    public function getinvoiceHeader($invoice_id){
        $this->db->select('tbl_invoice.invoice_code,tbl_invoice.invoice_id,tbl_invoice.CREATION_DATE, tbl_vendor.address,tbl_vendor.city,tbl_states.name as state,tbl_vendor.pincode');
        $this->db->select(',tbl_invoice.LAST_UPDATE_DATE,tbl_vendor.company as vendor_name,tbl_vendor.gst_no,tbl_vendor.pan_card,tbl_salesorder.sales_channel,tbl_salesorder.saleschannel_ref_id');
        $this->db->select(',tbl_invoice.payment_mode,tbl_salesorder.salesorder_code as sales_code,tbl_account_details.sales_code as salesman,tbl_salesorder.warehouse,tbl_vendor.vendor_code,tbl_vendor.mobile');
        $this->db->select(',tbl_invoice.invoice_amount as amount,tbl_invoice.tax_amount as tax');
        $this->db->from('tbl_invoice')->join('tbl_vendor','tbl_vendor.vendor_id=tbl_invoice.vendor_id','Left');
        $this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_invoice.salesorder_id','Left');
        $this->db->join('tbl_states','tbl_vendor.state=tbl_states.state_id','Left');
        $this->db->join('tbl_account_details','tbl_account_details.user_id=tbl_salesorder.salesman_code','Left');
        $this->db->where('tbl_invoice.invoice_id',$invoice_id);
        $query1=$this->db->order_by('invoice_id','ASC')->get();
        $invoiceheader=$query1->result_array();
        return $invoiceheader;
    }

    public function editInvoice($invoice_id,$new_rows,$old_rows){
        if($invoice_id>0){
            $sales_channel = $this->db->select('salesc_channel')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row->sales_channel;
            $this->db->trans_start();
            $this->db->where("invoice_id",$invoice_id);
            $this->db->update('tbl_invoice',array("status"=>'INVOICED',"LAST_UPDATED_BY"=>$this->session->userdata('user_id')));
            $error=$this->db->error();
            if($error['code']==0){
                if(!empty($new_rows)){
                    $rowdata=array();
                    $sold_products=array();
                    foreach($new_rows as $value){
                        $tax=0;
                        $margin=0;
                        $margin_perc=0;
                        if(in_array(strtoupper($sales_channel), MARGINAL_NOT_ALLOWED_CHANNELS)){
                            if($value['tax_type']=='CGSG12' || $value['tax_type']=='IGST12'){
                                $tax=$value['price']-$value['price']/1.12;
                            }else if($value['tax_type']=='CGSG18' || $value['tax_type']=='IGST18'){
                                $tax=$value['price']-$value['price']/1.18;
                            }
                        }else{
                            if(strtolower($value['bill_type'])=='taxable'){
                                if($value['tax_type']=='CGSG12' || $value['tax_type']=='IGST12'){
                                    $tax=$value['price']-$value['price']/1.12;
                                }else if($value['tax_type']=='CGSG18' || $value['tax_type']=='IGST18'){
                                    $tax=$value['price']-$value['price']/1.18;
                                }
                            }
            
                            if(strtolower($value['bill_type'])=='exempt'){
                                if($value['tax_type']=='CGSG12' || $value['tax_type']=='IGST12'){
                                    $margin=$value['price']-($value['unit_price']+$value['unit_price_tax']);
                                    $exempt = $value['unit_price']+$value['unit_price_tax'];
                                    $taxable=$margin/1.12;
                                    $tax=$margin-$taxable;
                                    if($margin<0) $margin=0;
                                    if($exempt > $value['price']){
                                        $exempt = $value['price'];
                                        $tax=0;
                                        $taxable =0;
                                    }
                                    $margin_perc=($margin/$value['price'])*100;
                                }else if($value['tax_type']=='CGSG18' || $value['tax_type']=='IGST18'){
                                    $margin=$value['price']-($value['unit_price']+$value['unit_price_tax']);
                                    $exempt = $value['unit_price']+$value['unit_price_tax'];
                                    $taxable=$margin/1.18;
                                    $tax=$margin-$taxable;
                                    if($margin<0) $margin=0;

                                    if($exempt > $value['price']){
                                        $exempt = $value['price'];
                                        $tax=0;
                                        $taxable =0;
                                    }
                                    $margin_perc=($margin/$value['price'])*100;
                                }
                            }
                        }
                        $row=array(
                            "invoice_id"=>$invoice_id,
                            "grnreport_id"=>$value["grnreport_id"],
                            "deviceid"=>$value["inward_id"],
                            "price"=>$value["price"],
                            "tax_amount"=>$tax,
                            "taxable_amount"=>$taxable,
                            "exempt_amount"=>$exempt,
                            "margin"=>$margin,
                            "margin_perc"=>$margin_perc,
                            "sales_terms"=>$value["sales_terms"],
                            "category"=>$value["category"],
                            "grade"=>$value["grade"],
                            "tax_type"=>$value["tax_type"],
                            "bill_type"=>$value["bill_type"],
                            "CREATION_DATE"=>date("Y-m-d H:i:s")
                        );
                        array_push($rowdata,$row);
    
                        $sold_items=array(
                            "grnreport_id"=>$value["grnreport_id"],
                            "status"=>"SOLD"
                        );
    
                        array_push($sold_products,$sold_items);
                    }
                    if($error['code']==0){
                        $query3=$this->db->select('invoice_item_id,grnreport_id')->where('invoice_id',$invoice_id)->from('tbl_invoice_item')->get();
                        $existing_rows=$query3->result_array();
                        $error=$this->db->error();
                    }
                    
                    if(!empty($rowdata)){
                        $this->db->insert_batch('tbl_invoice_item',$rowdata);
                        $error=$this->db->error();
                        if($error['code']==0){
                            $this->db->update_batch('tbl_grnreport',$sold_products,'grnreport_id');
                            $error=$this->db->error();
                        }
                    }
                    
                }
                
                if($error['code']==0){
                    foreach($existing_rows as $ext){
                        if($old_rows[$ext['invoice_item_id']]==true){

                        }else{
                            $delete_rows[]=$ext["invoice_item_id"];
                            $return_products[]=array("grnreport_id"=>$ext["grnreport_id"],
                                                        "status"=>'RFS');
                        }
                    }
                }
                if(!empty($delete_rows) && $error['code']==0){
                    $this->db->where_in('invoice_item_id',$delete_rows);
                    $this->db->delete('tbl_invoice_item');
                    $error=$this->db->error();
                }
                if(!empty($return_products) && $error['code']==0){
                    $this->db->update_batch('tbl_grnreport',$return_products,'grnreport_id');
                    $error=$this->db->error();
                }

                if($error['code']==0){
                    $this->db->trans_complete();
                    return true;
                }else{
                    $this->db->trans_rollback();
                    return false;
                }
            }
        }else{
            return false;
        }
    }

    public function cancelInvoice($invoice_id,$data=[]){
        
        if($invoice_id>0){
        
            $devices = array();
            $user_id = $this->session->userdata('user_id');
            
            $invoice = array(
                            "status" => 'VOID',
                            "LAST_UPDATED_BY" => $user_id
                        );

            $salesorder = array(
                            "status" => 'VOID',
                            "LAST_UPDATED_BY" => $user_id
                        );
           
            $this->db->trans_start();
            $this->db->where("invoice_id",$invoice_id);
            $this->db->update('tbl_invoice', $invoice);
            $error=$this->db->error();

            if($error['code'] != 0){
                
                $this->db->trans_rollback();
                return false;
                exit;
            }
            
            $so_id = $this->db->select('salesorder_id')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();

            $salesorder_id = $so_id->salesorder_id;

            $this->db->where("salesorder_id",$salesorder_id);
            $this->db->update('tbl_salesorder', $salesorder);
            $error=$this->db->error();

            if($error['code'] != 0){
                
                $this->db->trans_rollback();
                return false;
                exit;
            }

            $invoice_item = $this->db->select('grnreport_id')->where('invoice_id', $invoice_id)->get('tbl_invoice_item')->result_array();

            foreach($invoice_item as $rowvalue){

                $devices[] = array(
                    "status" => "RFS",
                    "grnreport_id" => $rowvalue["grnreport_id"]
                );

            }

            $this->db->update_batch('tbl_grnreport',$devices,'grnreport_id');
            $error=$this->db->error();

            if($error['code'] != 0){
                
                $this->db->trans_rollback();
                return false;
                exit;
            }
            if(!empty($data['remarks_header'])){

                $remark_data=array(
                        "reference_id"=>$invoice_id,
                        "reference_type"=>"invoice",
                        "remark"=>$data["remarks_header"],
                        "user_id"=>$this->session->userdata('user_id')
                );
                $this->db->insert('tbl_remark',$remark_data);
            }


            $this->db->trans_complete();
            return true;
            exit;

        }else{

            return false;
        }
    }

    
    public function createInvoice_forNonProduct($data) {
            
        /** ===================== Saving Record in SO ===================== */

        if (false) { // Not using this code as no SO needed for Non-Product Invoice

            $creation_date = date('Y-m-d H:i:s');

            if((int) $data['tcs_amount'] <= 0){
                $tcs_amount = 0;
                $tcs_percent = 0;
            }else{
                $tcs_amount = $data['tcs_amount'];
                $tcs_percent = $data['tcs_percentage'];
            }
            
            $so_header = array(
                "vendor_id"=> $data['customer'],
                "payment_mode"=>$data['payment_mode'],
                // "warehouse"=>$data['warehouse'],
                "tcs_amount" => $tcs_amount,
                "tcs_percent" => $tcs_percent,
                "status"=> $data['status'],
                "sales_channel" => 'NON_PRODUCT',
                "CREATION_DATE"=>$creation_date,
                "CREATED_BY"=>$this->session->userdata('user_id')
            );

            $total_amount = 0;
            foreach ($data['rows'] as $obj) {
                $total_amount += $obj['t_price'];
            }

            // if($data['discount'] > 0){
            //     $discount = $data['discount'];
                
            //     if($data['discount_type'] == 'amount'){
            //         $discount_amount = $discount;
            //     }else{
            //         $discount_amount = $discount*$total_amount/100;
            //     }
            // }else{
            //     $discount_amount = 0;
            // }

            // if($data['insurance_value'] > 0){
            //     $insurance_value = $data['insurance_value'];
                
            //     if($data['insurance_type'] == 'amount'){
            //         $insurance_amount = $insurance_value;
            //     }else{
            //         $insurance_amount = $insurance_value*$total_amount/100;
            //     }
            // }else{
            //     $insurance_amount = 0;
            // }

            // $so_header['discount_value'] = $data['discount'];
            // $so_header['discount_type'] = $data['discount_type'];
            // $so_header['discount_amount'] = $discount_amount;
            // $so_header['insurance_value'] = $data['insurance_value'];
            // $so_header['insurance_type'] = $data['insurance_type'];
            // $so_header['insurance_amount'] = $insurance_amount;
            // $so_header['freight_amount'] = $data['freight_amount'];

            if(empty($so_header)){
                GOTO ERROR;
            }

            $shipping_to_data = $data['shipping_data'];
            $shipping_from_id = $data['shipping_from_id'];
            $billing_from_id = $data['billing_from_id'];
            
            $state_name = $this->db->get_where('tbl_states', array("state_id" => $shipping_to_data[0]['to_state']))->row()->name;
            $shipping_to = array(
                "shipping_from_id"  => $shipping_from_id,
                "billing_from_id"   => $billing_from_id,
                "address"           => $shipping_to_data[0]['to_address'],
                "city"              => $shipping_to_data[0]['to_city'],
                "state"             => $state_name,
                "country"           => 'INDIA',
                "pincode"           => empty($shipping_to_data[0]['to_pincode'])? null: $shipping_to_data[0]['to_pincode']
            );

            
            $this->db->trans_start();
            
            $this->db->insert('tbl_salesorder', $so_header);
            $salesorder_id = $this->db->insert_id();

            if (!($salesorder_id > 0)) {
                $msg = 'Error in Inserting Record';
                GOTO ERROR;
            }

            $shipping_to['salesorder_id'] = $salesorder_id;
            $insert = $this->db->insert('tbl_shipping_to_address', $shipping_to);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }

        }

        /** ===================== Invoice Creation ===================== */
        
        // $vendorResult = $this->db->where('vendor_id', $so_header['vendor_id'])->get('tbl_vendor')->row();
        // $stateResult = $this->db->select('name, state_gst_id')->where('state_id', $vendorResult->state)->get('tbl_states')->row();

        // if ($stateResult->state_gst_id == 36) {
        //     $tax_type = 'CGST18';
        // } else {
        //     $tax_type = 'IGST18';
        // }

        $tax_rate_arr = [];
        $hsn_code_arr = [];

        $total_amount = 0;
        $total_tax = 0;
        
        foreach ($data['rows'] as $obj) {
            $total_amount += $obj['t_price'];
            $total_tax += $obj['tax_amount'];

            $inv_rows[] = array(
                // "invoice_id" => $invoice_id,
                "description" => $obj['description'],
                "hsn_code" => $obj['hsn_code'],
                "quantity" => $obj['quantity'],
                "price" => $obj['t_price'],
                "exempt_amount" => $obj['t_exempt'],
                "tax_rate" => $obj['tax_rate'],
                "taxable_amount" => $obj['taxable_amount'],
                "tax_amount" => $obj['tax_amount'],
                "CREATION_DATE" => date("Y-m-d H:i:s")
            );

            if (!in_array($obj['tax_rate'], $tax_rate_arr)) {
                $tax_rate_arr[] = $obj['tax_rate'];
            }
            if (!in_array($obj['hsn_code'], $hsn_code_arr)) {
                $hsn_code_arr[] = $obj['hsn_code'];
            }
        }

        if (count($tax_rate_arr) > 1) {
            $msg = 'All Invoice Items should have same Tax Rate';
            GOTO ERROR;
        }
        if (count($hsn_code_arr) > 1) {
            $msg = 'All Invoice Items should have same HSN Code';
            GOTO ERROR;
        }

        $res = $this->db->from('tbl_invoice AS inv')
                        ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
                        ->get()->row_array();
        $next_number = ($res['max'] == null)? 1 : $res['max'] + 1;
        $invoice_code = 'SLY-HYD-' . $next_number;

        $invoice_header = array(
            "vendor_id" => $data['customer'],
            "invoice_code" => $invoice_code,
            // "salesorder_id" => $salesorder_id,
            "salesorder_id" => null,
            "sales_channel" => 'NON_PRODUCT',
            "status" => "INVOICED",
            "invoice_amount" => $total_amount,
            "tax_amount" => $total_tax,
            "payment_mode" => $data['payment_mode'],
            "CREATION_DATE" => date("Y-m-d H:i:s"),
            "CREATED_BY" => $this->session->userdata('user_id')
        );

        $this->db->trans_start();

        $this->db->insert('tbl_invoice', $invoice_header);
        if ($this->db->error()['code'] != 0) { GOTO ERROR; }

        $invoice_id = $this->db->insert_id();

        if (!($invoice_id > 0)) {
            $msg = 'Error in Inserting Invoice';
            GOTO ERROR;
        }

        foreach ($inv_rows as $key => $obj) {
            $inv_rows[$key]['invoice_id'] = $invoice_id;
        }
        
        /** Insert Invoice_Items */
        $this->db->insert_batch('tbl_invoice_nonproduct_item', $inv_rows);
        if ($this->db->error()['code'] != 0) { GOTO ERROR; }

        if(!empty($data['remarks_header'])){
            $remark_array=array(
                'reference_id'=>$invoice_id,
                'reference_type'=> 'invoice',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark',$remark_array);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }
        }
        
        /** Insert into Audit_Log */
        $this->load->model('auditlog_model');
        $this->auditlog_model->insert_auditlog(
            $invoice_id,
            'invoice',
            'INVOICED',
            $this->session->userdata('user_id')
        );
        
        $this->db->trans_complete();

        return [
            "status" => true,
            'message' => 'NonProduct Invoice done successfully',
            'invoice_id' => $invoice_id
        ];

        ERROR:
        $this->db->trans_rollback();

        return [
            'status' => false,
            'message' => isset($msg)? $msg : "Unable to perform your request",
            'error' => isset($error)? $error : ''
        ];
    }

}