<?php

class Creditnotes_Model extends MY_Model
{
    public function getDeviceInfoBySalesReference($sales_channel,$saleschannel_ref_id){
		$where=array(
			"sales_channel"=>$sales_channel,
			"refid"=>$saleschannel_ref_id
		);
		$result = $this->db->select('deviceid,device_name,SKU,stock_type,grade,invoice_code')->where($where)->get('SALES_CHANNEL_REF_VIEW ')->result_array();
        return $result;        
    }

  	public function getDeviceInfoByInvoice($invoice_code){

		$result = $this->db->where('invoice_code', $invoice_code)->get('SEARCHBY_INVOICE_VIEW')->result_array();
		$invoice_item_ids = array_column($result, 'invoice_item_id');
		$exist_invoice_item_ids = $this->db->select('invoice_item_id')->where_in('invoice_item_id', $invoice_item_ids)->get('tbl_salesreturn_item')->result_array();
		$exist_invoice_item_ids_arr = array_column($exist_invoice_item_ids, 'invoice_item_id');
		$data = [];

		if(count($exist_invoice_item_ids)>0){
			foreach($result as $key=>$value){
				if(!in_array($value['invoice_item_id'], $exist_invoice_item_ids_arr)){
					$data[] = $value;
				}
			}
		}else{
			$data = $result;
		}
		
		return $data;
  	}

  	public function getDeviceInfoByIMEI($imei1_no){
  		$result = $this->db->select('device_name,nhdin,SKU,stock_type,certification_grade,status')->where('imei1_no',$imei1_no)->get('tbl_grnreport')->row();
        return $result;
    }

    public function getDeviceInfoById($deviceid){
    	$result = $this->db->select('device_name,nhdin,SKU,stock_type,certification_grade,status')->where('nhdin',$deviceid)->get('tbl_grnreport')->row();
        return $result;
    }

    public function getInvoiceByDeviceId($device_id){
    	$result = $this->db->select('device_id,device_name,sku,stock_type,grade,invoice_code')->where('device_id',$device_id)->get('SEARCHBY_INVOICE_NO_VIEW')->row();
    	return $result;
    }

    public function getInvoiceNo($name){
   		$result = $this->db->select('device_id,device_name,sku,stock_type,grade,invoice_code')->where('name',$name)->get('SEARCHBY_INVOICE_NO_VIEW')->row();
   		return $result;
    }

    public function getInvoiceByImei($imei1_no){
    	$result = $this->db->select('device_id,device_name,sku,stock_type,grade,invoice_code')->where('IMEI',$imei1_no)->get('SEARCHBY_INVOICE_NO_VIEW')->row();
    	return $result;
    }

     public function getInvoiceBySalesChanelRefId($refid){
		$result = $this->db->select('deviceid,device_name,SKU,stock_type,grade,invoice_code')->where('refid',$refid)->get('SEARCHBY_CHANNEL_REF_NO_VIEW ')->row();
		return $result;
    }	
	
	public function getSalesReturnList($status){

		if($status==''){
			$status='PENDING';
		}
		
                if($status == 'CLAIM_REQUIRED'){
			$status = array('CN_CREATED', 'LOST_IN_TRANSIT');
		}
		
		$result = $this->db->where_in('status',$status)->get('SALESRETURN_LIST_VIEW')->result_array();
		return $result;
	}

	public function getSalesReturnDetails($salesreturn_id){
		
		$this->db->select('tbl_salesreturn_item.received_product, tbl_salesreturn_item.product_condition, tbl_salesreturn_item.dent_type');
		$this->db->select('tbl_salesreturn_item.damage_type, tbl_salesreturn_item.remarks,tbl_grnreport.nhdin, tbl_grnreport.device_name');
		$this->db->join('tbl_grnreport','tbl_salesreturn_item.device_id = tbl_grnreport.grnreport_id');
		$result = $this->db->where('tbl_salesreturn_item.salesreturn_id',$salesreturn_id)->get('tbl_salesreturn_item')->result_array();

		$error = $this->db->error();
		if($error['code'] == 0){
			return $result;
		}else{
			return false;
		}
	}

	public function getSalesReturnRowsforCN($salesreturn_id){

		if($salesreturn_id>0){
			$result = $this->db->where('salesreturn_id',$salesreturn_id)->get('SALESRETURN_CN_ROWS_VIEW')->result_array();
			
			$error = $this->db->error();
			if($error['code'] == 0){
				return $result;
			}else{
				return false;
			}	
		}
	}
}	 
?>