<?php



/*

 * To change this license header, choose License Headers in Project Properties.

 * To change this template file, choose Tools | Templates

 * and open the template in the editor.

 */



/**

 * Description of payroll_model

 *

 * @author NaYeM

 */

class Common_Model extends CI_Model
{

    public function insertActivities($module,$fieldId,$activity,$msg)	
	{
 
			// $module="Item Master";

			// $activity="activity_update_a_old_device";

			// $msg=$data['product_name']. "Device updated successfully";

			

		 $activity = array(

			'user' => $this->session->userdata('user_id'),

			'module' => $module,

			'module_field_id' => $fieldId,

			'activity' => '( '.$activity.' )',

			'value1' => $msg

		);

		$this->db->insert('tbl_activities',$activity);

	}



	public function getVendorCompanyNameFormVendorCode($vendorCode)

	{

		$result=$this->db->where('vendor_code',$vendorCode)->select('company')->get('tbl_vendor')->row();

		

		$companyName='';

		if(!empty($result))

		{

			$companyName=ucfirst($result->company);

		}

		

		return $companyName;

	}


	public function getVendorNameFormVendorCode($vendorCode,$para2='')
	{
		
		if($para2!='')
		{
			return $this->db->select('name')->where('invoice_id',$para2)->get('tbl_createinvoice')->row()->name;
		}
		else
		{ 
			$result=$this->db->where('vendor_code',$vendorCode)->select('company')->get('tbl_vendor')->row();
			$name='';
			if(!empty($result))
			{
				$name=ucfirst($result->company);
			}
			return $name;
		}
		
	}

	

	public function getVendorStateFormVendorCode($vendorCode)

	{

		$result=$this->db->where('vendor_code',$vendorCode)->select('state')->get('tbl_vendor')->row();

		

		$state='';

		if(!empty($result))

		{

			$state=ucfirst($result->state);

		}

		

		return $state;

	}

	

	

	

	public function getdeviceNameFromNHMOD($nhmod)
	{

		$result=$this->db->where('nhmod',$nhmod)->select('product_name')->get('tbl_product_details')->row();

		

		$productName='';

		if(!empty($result))
		{

			$productName=ucfirst($result->product_name);

		}

		

		return $productName;

	}

	

	

	

	/*==Get Nhdin No===*/

	

 

	

	public function getOrderIdForNHDIN($mode,$stock_subtype='')
	{
		$mode=strtoupper(strtoupper(preg_replace('/\s+/', '', $mode))); 
		
		$orderSettingResult=$this->db->query("SELECT * FROM tbl_setting WHERE portal='$mode' FOR UPDATE")->row(); 

		$orderExtender1=$orderSettingResult->order_extender_1;

		$orderExtender2=$orderSettingResult->order_extender_2;

		$generation_id=$orderSettingResult->generation_id;

		
		$portal_code='';

		if($stock_subtype!='')
		{
			$stock_subtype=strtoupper(strtoupper(preg_replace('/\s+/', '', $stock_subtype))); 
		} 

		if($mode=='PREXO' && $stock_subtype=='REGULAR')
		{
			$portal_code="RGP";
		} 
		elseif($mode=='PREXO' && $stock_subtype=='CA')
		{
			$portal_code="CAP";
		} 
		elseif($mode=='OPENBOX' && $stock_subtype=='NTF')
		{
			$portal_code="NTB";
		}  
		elseif($mode=='OPENBOX' && $stock_subtype=='CX')
		{
			$portal_code="CXB";
		}   
		elseif($mode=='OPENBOX' && $stock_subtype=='TF')
		{
			$portal_code="TFB";
		}  
		elseif($mode=='BRANDREFURBISHED' && $stock_subtype=='NTF')
		{
			$portal_code="NTB";
		}  
		elseif($mode=='BRANDREFURBISHED' && $stock_subtype=='CX')
		{
			$portal_code="CXB";
		} 

		/*==update order no if create new Order==*/

		$this->db->query("UPDATE tbl_setting SET order_no=(order_no+1) WHERE portal='$mode'");

		 $order_id=$orderSettingResult->order_no.$orderExtender1.$orderExtender2.$generation_id.$portal_code;		

		return $order_id;
	 }

		

	  public function getNHDIN($newOrderID,$device_id,$kmod,$location,$box_type='')
	  {

		//DEVICE ID EXTENDER
		$deviceExtender="T";
		 
		$year=date("y");
		$month=date("m");
 
		$device_code=str_pad($device_id, 7, "0", STR_PAD_LEFT);
   
		// $KDIN=$location."-".$newOrderID.$device_code.$deviceExtender.$box_type."-".$kmod;
		
		$KDIN=$deviceExtender.$box_type.$year.$month.$device_code;
		
		$data=array("kdin"=>$KDIN,"kmod"=>$kmod);

		return $data;

	  }
 

	public function getFieldValue($fieldName,$tableName,$whrfieldName,$whrfieldValue)
	{

		$value='';

		$result=$this->db->select($fieldName)->where($whrfieldName,$whrfieldValue)->get($tableName)->row();

		

		if(!empty($result))

		{

			if(isset($result->$fieldName))

			{

				$value=$result->$fieldName;

			}

		}

		

		return $value;

	}

	 



	 /*==get all pending order detail from grn report==*/

	 

	public function totalInwardPending()
	{
		$total=0;

		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			 $locCond="nhdin LIKE '%".$shortState."%'";
		}
		else
		{ 
			 $locCond="grnreport_id!='0'";
		}
		
		$result=$this->db->select('COUNT(grnreport_id) as total')->where('status','INWARD')->get('tbl_grnreport')->row();

		if(!empty($result))
		{
			if($result->total!='')
			{
				$total=$result->total;
			}
		}
		return $total;

	}


	public function totalUnattemptCertification()
	{
		$total=0;
 
		$result=$this->db->select('COUNT(certification_id) as total')->where('status','1')->get('tbl_certification_dept')->row_array();

		if(!empty($result) && $result['total'])
		{
			$total=$result['total'];
		}
		
		return $total;
	}


	public function totalApproveCertification()
	{
		$total=0;
 
		$result=$this->db->select('COUNT(certification_id) as total')->where('status','1')->get('tbl_certification_pass')->row_array();

		if(!empty($result) && $result['total'])
		{
			$total=$result['total'];
		}
		
		return $total;
	}


	public function totalFailCertification()
	{
		$total=0;
 
		$result=$this->db->select('COUNT(certification_id) as total')->where('status','1')->get('tbl_certification_fail')->row_array();

		if(!empty($result) && $result['total'])
		{
			$total=$result['total'];
		}
		
		return $total;
	}

	public function totalReturntowarehousebyTriage()
	{
		$total=0;
 
		$result=$this->db->select('COUNT(warehouse_id) as total')->where('status','1')->get('tbl_returntowarehousetriage')->row_array();

		if(!empty($result) && $result['total'])
		{
			$total=$result['total'];
		}
		
		return $total;
	}
	
	public function totalReturntowarehousebyCerti()
	{
		$total=0;
 
		$result=$this->db->select('COUNT(warehouse_id) as total')->where('status','1')->get('tbl_returntowarehousecertification')->row_array();

		if(!empty($result) && $result['total'])
		{
			$total=$result['total'];
		}
		
		return $total;
	}
 
	/*==get all recived stored invoice from grn report==*/
		
		/*==set condition for get result location wise==*/
		 
	public function getLocationCond()
	{
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			return $locCond="tbl_bulkstatus.nhdin LIKE '%".$shortState."%'";
		}
		else
		{ 
			return $locCond="tbl_bulkstatus.bulkstatus_id!='0'";
		}
	}	
	
	public function totalRejectOrder()
	{ 
		
		$total=0;
		
		$result=$this->db->select('COUNT(reject_id) as total')->where('status','1')->get('tbl_purchasereject')->row();

		if(!empty($result))
		{
			if($result->total!='')
			{
				$total=$result->total;
			}
		}
		
		return $total;
	} 	
	
	public function totalTriageToWarehouse()
	{  
		$result=$this->getRowResult('COUNT(assessment_id) as total','tbl_comtriageto_warehouse',array('status'=>'1'));
		  
		return (float) $result['total'];
	} 
	
	public function totalRecivedOrderInvoice()
	{
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='BLR')
			{
				$location="BANGALORE";
			}
			else
			{
				$location="HYDERABAD";
			}
			
			$locCond="tbl_grnreport.warehouse LIKE '%".$location."%'"; 
		}
		else
		{ 
			 $locCond="tbl_grnreport.grnreport_id!='0'";
		}
		
		$total=0;
		
		$result=$this->db->select('COUNT(tbl_grnreport.grnreport_id) as total')->where('recived_store','1')->where($locCond)->get('tbl_grnreport')->row();

		if(!empty($result))
		{
			if($result->total!='')
			{
				$total=$result->total;
			}
		}
		
		return $total;
	}	 

	

	public function getUserNameByUserId($userId)
	{
		$name='';

		$nameResult=$this->db->select('username')->where('user_id',$userId)->get('tbl_users')->row();

		if(!empty($nameResult))
		{
			$name=$nameResult->username;
		}

		return $name;

	}

	public function totalOnHoldStores()
	{
		$locCond=$this->setlocCondForDashboard();

		$result=$this->db->select('stamp_id')->where($locCond)->where('status','1')->get('tbl_onhold')->result_array();
		
		return count($result);
	} 
	
	public function returnToOrigin()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_returntoorigin.stamp_id')->where($locCond)->where('tbl_returntoorigin.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_returntoorigin.bulkstatus_id')->get('tbl_returntoorigin')->result_array();
		
		return count($result);
	}
	
	public function totalSalesReturn()
	{
		//$locCond=$this->Common_model->setlocCondForDashboard();
		
		//$result=$this->db->select('tbl_salesreturn.stamp_id')->where($locCond)->where('status','1')->get('tbl_salesreturn')->//result_array();
		
		//return count($result);
		return 0;
	} 
	
	public function totalAfterSalesServiceTrc()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where($locCond)->where('status','1')->get('tbl_receivedassess_ass')->result_array();
		
		return count($result);
	} 
	
	public function totalRecivedAssessStoresAss()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where($locCond)->where('receivedassstore_status','1')->get('tbl_receivedassess_ass')->result_array();
		
		return count($result);
	} 
	
	public function totalAssInspectionCompleted()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where($locCond)->where('status','1')->get('tbl_ass_inpectioncompleted')->result_array();
		
		return count($result);
	} 
	
	public function totalAssDispatched()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where($locCond)->where('status','1')->get('tbl_ass_dispatched')->result_array();
		
		return count($result);
	} 
	
	public function totalAfterSalesServiceInspection()
	{
		
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where('status','1')->where($locCond)->get('tbl_assinspection')->result_array();
 
		return count($result);
	}
 
	public function totalAssFail()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where(array('update_status'=>'ass_fail'))->where($locCond)->get('tbl_receivedassess_ass')->result_array();
 
		return count($result);
	}
 
	public function totaldismeltingDevice()
	{ 
		$result=$this->db->select('count(dismantling_id) as total')->where(array('status'=>'1'))->get('tbl_dismantling_devices')->row_array();
 
		return (int) $result['total'];
	}
	
	public function totalAssPass()
	{
		
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where(array('update_status'=>'ass_pass'))->where($locCond)->get('tbl_receivedassess_ass')->result_array();
 
		return count($result);
	}
	
	public function totalAssRejected()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where(array('update_status'=>'ass_rejected'))->where($locCond)->get('tbl_receivedassess_ass')->result_array();
 
		return count($result);
	}
	
	public function totalOutQcPass()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_bulkstatus.bulkstatus_id')->where('tbl_title_connectivity.connectivity_status','outqc_passsales')->where($locCond)->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_title_connectivity.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_title_connectivity')->result_array();
 
		return count($result);
	}
	
	public function totalPrelove()
	{ 
		$result=$this->getAllResult('stamp_id','tbl_prelove',array('status'=>'1'));
 
		return count($result);
	}
	
	public function totalOutQcPassSales()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		 
		$result=$this->db->select('stamp_id')->where('status','1')->where($locCond)->get('tbl_outqcpass_salesstamp')->result_array();
		
		return count($result);
	}
	
	public function totalOutQcPassSalesFinance()
	{
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='DLI')
			{
				$locCond="tbl_bulkstatus.nhdin NOT LIKE '%BLR%'";
			}
			else
			{
				$locCond="tbl_bulkstatus.nhdin LIKE '%".$shortState."%'";
			}			
		}
		else
		{ 
			$locCond="tbl_bulkstatus.bulkstatus_id!='0'";
		}
		
		$result=$this->db->select('tbl_outqcpass_finance.stamp_id')->where('tbl_outqcpass_finance.status','1')->where($locCond)->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcpass_finance.bulkstatus_id')->get('tbl_outqcpass_finance')->result_array();
		
		return count($result);
	}
	
	public function totalRfsTrc()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('trc_closedrfsassess.assessment_id')->where('trc_closedrfsassess.status','1')->where($locCond)->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=trc_closedrfsassess.bulkstatus_id')->get('trc_closedrfsassess')->result_array();
		
		return count($result);
	}
	 
	public function totalPurchaseReturn()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_bulkstatus.bulkstatus_id')->where('tbl_bulkstatus.update_status','PURCHASE RETURN')->where($locCond)->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('tbl_bulkstatus')->result_array();
 
		return count($result);
	}
 
	public function totalInTransitOutbondSold()
	{
		$locCond=$this->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where($locCond)->where('status','1')->get('tbl_intransitoutbondsold')->result_array();
		
		return count($result);
	}
	
	public function totalOutQc()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_outqcstamp.outqc_id')->where('tbl_outqcstamp.status','1')->where($locCond)->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_outqcstamp.bulkstatus_id')->get('tbl_outqcstamp')->result_array();
		
		return count($result);
	}
 
	
	public function totalSoldSalesStamp()
	{ 
	
		/*===SET LOCATION COND==*/
		
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='BLR')
			{
				$location="BANGALORE";
			}
			else
			{
				$location="HYDERABAD";
			}
			
			$cond="warehouse LIKE '%".$location."%' and status='1'";
		}
		else
		{ 
			$cond="status='1'";
		} 
			
		$result=$this->db->select('tbl_soldstamp.stamp_id')->where($cond)->get('tbl_soldstamp')->result_array();
		
		return count($result);
	}
 
	public function totalOutQcFailSales()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('stamp_id')->where('status','1')->where($locCond)->get('tbl_outqcfail_salesstamp')->result_array();
 
		return count($result);
	} 
	
	public function totalmovedToAmazon()
	{
		 
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='BLR')
			{
				$location="BANGALORE";
			}
			else
			{
				$location="HYDERABAD";
			}
			
			$locCond="tbl_grnreport.warehouse LIKE '%".$location."%'"; 
		}
		else
		{ 
			 $locCond="tbl_grnreport.grnreport_id!='0'";
		}
		
		$result=$this->db->select('tbl_moved_toamazon.stamp_id')->where($locCond)->where('tbl_moved_toamazon.status','1')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_moved_toamazon.nhdin')->get('tbl_moved_toamazon')->result_array();
		
		return count($result);
	}
 
	public function totalTrc()
	{
		$locCond=$this->Common_model->setlocCondForDashboard();
		
		$result=$this->db->select('assessment_id')->where($locCond)->where('status','1')->get('tbl_trcassessment')->result_array();
 
		return count($result);
	}
 
	public function totalRepairedOk()
	{ 
		$result=$this->db->select('assessment_id')->where('device_pass_status','REPAIRED OK')->where('status','1')->get('tbl_recivedasses_stores')->result_array();
 
		return count($result);
	}
	
	public function totalBer()
	{  
		$result=$this->db->select('assessment_id')->where('device_pass_status','BER')->where('status','1')->get('tbl_recivedasses_stores')->result_array();
 
		return count($result);
	}
	
	
	public function totalPfp()
	{ 
		$result=$this->db->select('assessment_id')->where('device_pass_status','PFP')->where('status','1')->get('tbl_recivedasses_stores')->result_array();
 
		return count($result);
	}
	
	public function totalPwr()
	{
		 
		$result=$this->db->select('assessment_id')->where('device_pass_status','RWR')->where('status','1')->get('tbl_recivedasses_stores')->result_array();
 
		return count($result);
	}
	
	public function totalInqc()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_bulkstatus.bulkstatus_id')->where(array('trc_engassessment.status'=>'1','trc_engassessment.current_status'=>'IN QC'))->where($locCond)->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=trc_engassessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('trc_engassessment')->result_array();
		
		return count($result);
	}
	
	public function totalInqcFail()
	{
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='BLR')
			{
				$location="BANGALORE";
			}
			else
			{
				$location="HYDERABAD";
			}
			
			$locCond="tbl_grnreport.warehouse LIKE '%".$location."%'"; 
		}
		else
		{ 
			 $locCond="tbl_inqcfail_stamp.stamp_id!='0'";
		} 
		 
		$result=$this->db->select('tbl_inqcfail_stamp.stamp_id')->where(array('tbl_inqcfail_stamp.status'=>'1'))->where($locCond)->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_inqcfail_stamp.nhdin')->get('tbl_inqcfail_stamp')->result_array();
		
		return count($result);
	}
	
	public function totalInqcPass()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_bulkstatus.bulkstatus_id')->where(array('trc_engassessment.status'=>'1','trc_engassessment.current_status'=>'IN QC PASS'))->where($locCond)->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=trc_engassessment.bulkstatus_id')->join('tbl_grnreport','tbl_grnreport.nhdin=tbl_bulkstatus.nhdin')->get('trc_engassessment')->result_array();
		
		return count($result);
	}
	
	
	public function totalRecivedAssStores()
	{
		$locCond=$this->setlocCondForDashboard();
 
		$result=$this->db->select('assessment_id')->where('status','1')->where($locCond)->get('tbl_recivedasses_stores')->result_array();
	
		return count($result);
	}
	
	public function totalMismatchModal()
	{
		
		$cond="confirm_mismatch='1'";
		
		if($this->session->userdata('locationValue')!='ALL')
		{
			$cond.=" and warehouse='".$this->session->userdata('locationValue')."'";
		}
	
		$result=$this->db->select('mismatch_id')->where($cond)->get('tbl_modalmismatch')->result_array();
		
		return count($result);
	}
	
	
	public function totalReadyForSale()
	{ 
		/*===SET LOCATION COND==*/
		
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='BLR')
			{
				$location="BANGALORE";
			}
			else
			{
				$location="HYDERABAD";
			}
			
			$cond="warehouse LIKE '%".$location."%' and status='1'";
		}
		else
		{ 
			$cond="status='1'";
		}
		
		$result=$this->db->select('sale_id')->where($cond)->get('tbl_readyforsale')->result_array();
 
		return count($result);
	} 
	
	public function totalL1Assessment()
	{
		$locCond=$this->getLocationCond();
		
		$result=$this->db->select('tbl_l1assessment.repair_id')->where($locCond)->where('tbl_l1assessment.status','1')->join('tbl_bulkstatus','tbl_bulkstatus.bulkstatus_id=tbl_l1assessment.bulkstatus_id')->get('tbl_l1assessment')->result_array();
 
		return count($result);
	} 
	
	public function getBulkstatusById($statusId)
	{
		$result=$this->db->where('bulkstatus_id',$statusId)->get('tbl_bulkstatus')->row_array();
		return $result;
	}
	
	public function getGrnReportById($nhdin)
	{
		$result=$this->db->select('nhdin,imei1_no,device_name')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		return $result;
	}
	
	public function getnhppByNhdin($nhdin)
	{
		$nhpp=0;
		$result=$this->db->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		if(!empty($result))
		{
			$nhpp=$result['nhpp'];
		}
		return $nhpp;
	}
	
	public function getTypeIdByProductName($proName)
	{
		
		$type_id="";
		
		$result=$this->db->where('product_name',$proName)->get('tbl_product_details')->row_array();
		
		if(!empty($result))
		{
			$type_id=$result['type_id'];
		}
		return $type_id;
	}
 
	public function getTypeNameByTypeId($typeId)
	{
		$name='';
		
		$result=$this->db->where('type_id',$typeId)->get('tbl_device_type')->row_array();
		
		if(!empty($result))
		{
			$name=ucfirst($result['name']);
		}
		
		return $name;
	}
	
	public function createOrderRefId()
	{
		$orderRefNo=1;
		
		$result=$this->db->select('max(order_refno) as order_id')->get('tbl_bulkorder')->row();
		
		if(!empty($result))
		{  
			$orderRefNo=(int)(($result->order_id)+1);
		}
		
		return $orderRefNo;
	}
	
	public function createInvoiceRefId()
	{
		$orderRefNo=1;
		
		$location=$this->session->userdata('location');
		
		$result=$this->db->select('MAX(invoice_refno) as invoice_refno')->where('warehouse',$location)->get('tbl_createinvoice')->row();
		 
		if(!empty($result) && $result->invoice_refno!='')
		{  
			$refNo=$result->invoice_refno;
			
			$orderRefNo=($refNo+1);
		}
		
		return $orderRefNo;
	}
	
	public function getInvoiceRefArray($startValue,$data)
	{ 
		foreach($data as $value)
		{
			$invoiceRefNo[]=array(
				'vendor_mobile'=>$value,
				'refNo'=>$startValue,
			);
			
			$startValue++;
		}
		
		return $invoiceRefNo;
	}
	
	public function getRefNoFromArray($Refarray,$mobile)
	{
		$refNo=0;
		
		foreach($Refarray as $RefarrayValue)
		{
			if($RefarrayValue['vendor_mobile']==$mobile)
			{
				$refNo=$RefarrayValue['refNo'];
			}
		}
		
		return $refNo;
	}
	
	public function getEngineerIdByassesMentId($id)
	{
		$engId=0;
		$result=$this->db->where('assessment_id',$id)->get('trc_engassessment')->row()->eng_id;
		
		if($result!='')
		{
			$engId=$result;
		}
		
		return $engId;
	}
	
	public function createCreditNoteRefNo()
	{
		$refNo='0';
		
		$result=$this->db->select('refno')->order_by('creditnote_id','desc')->get('tbl_creditnote')->row();
		
		if(!empty($result))
		{
			$refNo=$result->refno;
		} 
		$fianlrefNo=$refNo+1; 
		
		return $fianlrefNo;
	}
	
	public function createFormatNoteRefNo($no,$vendorCode)
	{
		$numlength = strlen((string)$no);
		
		$idno=$numlength;
 
		if($idno ==1){
			$userUnique_id= "CN00".$no.'-'.$vendorCode;
		}
		elseif($idno ==2)
		{
			$userUnique_id= "CN0".$no.'-'.$vendorCode;
		}
		else
		{
			$userUnique_id="CN".$no.'-'.$vendorCode;			
		}
		return $userUnique_id;
	}
	
	public function createUserSalesRefNo($no)
	{
		$userId=$no;
		$numlength = strlen((string)$no);
		
		$idno=$numlength;
 
		if($idno ==1){
			$userUnique_id= "00".$userId;
		}
		elseif($idno ==2)
		{
			$userUnique_id= "0".$userId;
		}
		else
		{
			$userUnique_id=$userId;			
		}
		return $userUnique_id;
	}
	
  
	
	public function getCreditNoteByVendorCode($vendor_code)
	{
		
		$total='0.00';
		
		$result=$this->db->select('SUM(tbl_createinvoice.nhsp) as total')->where('tbl_createinvoice.vendor_code',$vendor_code)->join('tbl_createinvoice', 'tbl_creditnote.invoice_id = tbl_createinvoice.invoice_id')->get('tbl_creditnote')->row()->total;

		if($result!='')
		{
			$total=$result;
		}
		return $total;
	}
	
	public function getUsedCreditNoteByVendorCode($vendor_code)
	{
		
		$total='0.00';
		
		$result=$this->db->select('SUM(credit_note) as total')->where('vendor_code',$vendor_code)->get('tbl_accstatement')->row();
 	 
		if(!empty($result) && ($result->total!=''))
		{
			$total=$result->total;
		}
		return $total;
	}
 
	
	public function getVendorAdvanceAmount($vendor_code)
	{		
		$amount=0.00;
		
		$result=$this->db->select('SUM(total) as total')->where(array('vendor_code'=>$vendor_code))->get('tbl_advancepayment')->row();
		
		if($result->total!='')
		{
			$amount=$result->total;
		}
		
		return $amount;
	}
	

	public function getVendorDepositAmount($vendor_code)
	{		
		$amount=0;
		
		$result=$this->db->select('SUM(total) as total')->where(array('vendor_code'=>$vendor_code))->get('tbl_accstatement')->row();
		
		if($result->total!='')
		{
			$amount=$result->total;
		}
		
		return $amount;
	}
 
	public function getTotalVendorInvoiceAmount($vendorCode)
	{
		$invoiceAmount=0;
		
		$result=$this->db->select('invoice_refno')->group_by('invoice_refno')->where(array('vendor_code'=>$vendorCode))->get('tbl_accstatement')->result();
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$invoiceAmount+=$this->db->select('SUM(nhsp) as nhsptotal')->where(array('invoice_code'=>$value->invoice_refno,'vendor_code'=>$vendorCode))->get('tbl_createinvoice')->row()->nhsptotal;		
			}
		}
		
		return $invoiceAmount;
	}
 
	public function getTotalVendorInvoiceQty($vendorCode)
	{
		$qty=0;
		
		$result=$this->db->select('invoice_refno')->group_by('invoice_refno')->where(array('vendor_code'=>$vendorCode))->get('tbl_accstatement')->result();
		
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$qty+=$this->db->select('qty')->where('invoice_refno',$value->invoice_refno)->get('tbl_save_invoice')->row()->qty;		
			}
		}
		
		return $qty;
	}
	
	public function getVendorOutstandingAmount($vendorCode)
	{		
		$invoiceAmount=0;$totalAmount=0;$oustandingAmount=0;
		
		$vendorInvoiceAmount=$this->getTotalVendorInvoiceAmount($vendorCode);
		
		$vendorAdvanceAmount=$this->getVendorAdvanceAmount($vendorCode);
		
		$vendorDepositAmount=$this->getVendorDepositAmount($vendorCode);
 
		return $vendorInvoiceAmount-($vendorAdvanceAmount+$vendorDepositAmount);
	}

	public function getSeriesForVenBuyerCode($para1)
	{ 
		$numlength = strlen((string)$para1);
		
		$idno=$numlength;
 
		if($idno ==1){
			$userUnique_id= "0".$para1;
		}
		else
		{
			$userUnique_id=$para1;			
		}
		return $userUnique_id;
	}
	
	
	public function getSeriesForInvoiceCode($invoiceRefNo)
	{
		$userId=$invoiceRefNo;
		
		$numlength = strlen((string)$invoiceRefNo);
		
		$idno=$numlength;
 
		if($idno ==1){
			$userUnique_id= "0000".$userId;
		}
		elseif($idno ==2)
		{
			$userUnique_id= "000".$userId;
		}
		elseif($idno ==3)
		{
			$userUnique_id= "00".$userId;
		}
		elseif($idno ==4)
		{
			$userUnique_id= "0".$userId;
		}
		else
		{
			$userUnique_id=$userId;			
		}
		return $userUnique_id;
	}
	
	public function getInvoiceCode($billType,$invoiceRefNo,$state='')
	{
		$code='';
		
		if($billType=='TAXABLE')
		{
			$code='SIHT'.$this->getSeriesForInvoiceCode($invoiceRefNo);
		}
		
		if($billType=='EXEMPTED')
		{
			$code='SIHE'.$this->getSeriesForInvoiceCode($invoiceRefNo); 
		}
		
		return $code;
	}
	 
	public function getShortValueOfState($state)
	{
		$state=strtoupper($state);
		
		if($state=='BANGALORE')
		{
			return "BLR";
		}
		elseif($state=='LUCKNOW')
		{
			return "LUK";
		}
		else
		{
			return "DLI";
		}
	}
	
	public function getFullStateNameOfShortName($state)
	{
		if($state=='BLR')
		{
			return "BANGALORE";
		}
		elseif($state=='LUK')
		{
			return "LUCKNOW";
		}
		else
		{
			return "DELHI";
		}
	}
	
	public function getDeviceDetailByNhdin($nhdin)
	{
		$result=$this->db->select('tbl_product_details.*')->where(array('tbl_grnreport.nhdin'=>$nhdin))->join('tbl_grnreport','tbl_grnreport.device_name=tbl_product_details.product_name')->get('tbl_product_details')->row_array();
		
		return $result;
	}
	
	public function updateAllTableNhdin($oldNhdin,$newNhdin)
	{
		$tableName=array('tbl_title_connectivity','tbl_bulkstatus','tbl_l1assessment','tbl_outqcpass_salesstamp','tbl_outqcstamp','tbl_outqcfail_salesstamp','tbl_outqcpass_salesstamp','tbl_readyforsale','tbl_recivedasses_stores','tbl_soldstamp','tbl_trcassessment','trc_closedrfsassess','trc_engassessment','tbl_inqcpass_stamp','tbl_inqcfail_stamp','tbl_outqcpass_finance','tbl_intransitoutbondsold','tbl_salesreturn','tbl_returntoorigin','tbl_assinspection','tbl_receivedassess_ass','tbl_ass_inpectioncompleted','tbl_ass_dispatched','tbl_onhold','tbl_moved_toamazon');
		
		foreach($tableName as $tableNameValue)
		{
			$this->db->where('nhdin',$oldNhdin)->update($tableNameValue,array('nhdin'=>$newNhdin));
		} 
	}
	
	public function getTitleConnectDataByNhdin($nhdin)
	{
		$result=$this->db->select('category,storage_capacity,physical_housing,physical_housing1,physical_housing4,physical_housing5,physical_housing6,perfectworking_condition,working_condition,physical_screen,physical_screen1,device_color,ram,camera_front,camera_main,display_screen,processor,sim_info,os,battery_charging,network_brand,network_type,device_condition,storage_capacity')->where('nhdin',$nhdin)->order_by('connectivity_id','desc')->get('tbl_title_connectivity')->row_array();
		 
		 return $result;
	}
	
	public function getDeviceImeiNo($nhdin)
	{
		$cond="(nhdin='".$nhdin."' or old_nhdin='".$nhdin."')";
		
		$engImei=$this->db->select('eng_imei_no,imei1_no')->where($cond)->get('tbl_grnreport')->row();
		
		$imei1No=$engImei->imei1_no;
		
		if(!empty($engImei))
		{
			if($engImei->eng_imei_no!='' && $engImei->eng_imei_no!='0' )
			{
				$imei1No=$engImei->eng_imei_no;
			}			
		} 
		
		return $imei1No;
	}
	
	
	public function checkRfsType($nhdin)
	{
		$engCond="(current_status='IN QC FAIL' or current_status='IN QC PASS' or current_status='ASS FAIL' or current_status='ASS REJECTED' or current_status='ASS PASS' or current_status='OUT QC FAIL' or current_status='OUT QC PASS-SALES') and nhdin='".$nhdin."'";
		
		$engResult=$this->db->where($engCond)->get('trc_engassessment')->row();
		 
		if(!empty($engResult))
		{
			return "PROCESSED";
		}
		else
		{
			return "UNPROCESSED";
		}
	}
 
	public function getTaxRsValueByNhdin($nhdin,$nhsp,$nhpp,$taxType)
	{ 
		$taxValue=0.00; $baseMargin=0.00;$taxRatio=0;
		
		$productResult=$this->db->select('tbl_device_type.tax_ratio')->where('tbl_readyforsale.nhdin',$nhdin)->join('tbl_product_details','tbl_product_details.nhmod=tbl_readyforsale.nhmod')->join('tbl_device_type','tbl_product_details.type_id=tbl_device_type.type_id')->get('tbl_readyforsale')->row();
		 
		if(!empty($productResult))
		{
			$taxRatio=$productResult->tax_ratio;
		}
		
		if($taxType=='EXEMPTED')
		{
			$margin=$nhsp-$nhpp;
			
			if($margin>0)
			{
				$baseMargin=($margin/(100+$taxRatio))*100;
			 
				$taxValue=round(($margin-$baseMargin),2);
				 
			} 
		}
		else
		{  
			$taxValue=(($nhsp*100)/(100+$taxRatio));
			
			$taxValue=round(($nhsp-$taxValue),2);
			
	 	}
		
		if($taxValue>0)
		{
			$taxValue=($taxValue);
		}
 
		$result=array(
			'taxvalue'=>$taxValue,
			'tax_ratio'=>str_replace('.00','',$taxRatio.""),
		);
		
		return $result;
	}
	
	function getInvoiceAddressLocationWise($location)
	{
		if($location=='BANGALORE')
		{
			$address=array(
				'address'=>"2ND FLOOR, 6/3, S.S. BUILDING, GANDHI BAZAR,BASAVANAGUDI, BANGALORE - 560004",
				'telephone'=>'080-43009937',
				'gst'=>'29AACCO4542Q1ZU',
			);
		}
		else
		{
			$address=array(
				'address'=>"18/23, WEA, ARYA SAMAJ ROAD, KAROL BAGH, NEW DELHI - 110005",
				'telephone'=>'011 - 49876543',
				'gst'=>'07AACCO4542Q1Z0',
			);
		}
		
		return $address;
	}

	function getVendorDetailByVendorCode($vendorCode)
	{
		$result=$this->db->select('gst_no,company,mobile,address')->where('vendor_code',$vendorCode)->get('tbl_vendor')->row_array();
	 
		return $result;
	}
	
	
	public function getAmountOfIssueVendorCreditNote($vendorCode)
	{
		$result=$this->db->select('SUM(tbl_createinvoice.nhsp)  as total')->where(array('tbl_createinvoice.vendor_code'=>$vendorCode,'tbl_creditnote.status'=>'1'))->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_creditnote.invoice_id')->get('tbl_creditnote')->row_array();
	
		return $result;
	}
	
	public function getAmountOfCancelVendorCreditNote($vendorCode)
	{
		$result=$this->db->select('SUM(tbl_createinvoice.nhsp)  as total')->where(array('tbl_createinvoice.vendor_code'=>$vendorCode,'tbl_creditnote.status'=>'0'))->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_creditnote.invoice_id')->get('tbl_creditnote')->row_array();

		return $result;
	}
	

	public function insertStampData($tblName,$nhdin,$bulkstatus_id,$engineer_id,$remark)
	{
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'nhdin'=>$nhdin,
			'bulkstatus_id'=>$bulkstatus_id,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'engineer_id'=>$engineer_id, 
			'remark'=>$remark,
			'awb'=>'',
		);
		
		$this->db->insert($tblName,$data);
	}
	
	public function insertStampDataWithSold($tblName,$nhdin,$bulkstatus_id,$sold_id,$engineer_id,$remark)
	{
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'nhdin'=>$nhdin,
			'bulkstatus_id'=>$bulkstatus_id,
			'sold_id'=>$sold_id,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'engineer_id'=>$engineer_id, 
			'remark'=>$remark, 
		);
		
		$this->db->insert($tblName,$data);
	}
	 
	public function insertAssInspecCompleted($nhdin,$bulkstatus_id,$engineer_id)
	{ 
		
		$soldId=0;$engAssesmentId=0;$actionBulkstatusId=0;$remark='';$warehouse='';
		
		$assResult=$this->db->select('sold_id,eng_assesment_id,bulkstatus_id,remark,warehouse')->where(array('nhdin'=>$nhdin,'status'=>'0','receivedassstore_status'=>'1'))->get('tbl_receivedassess_ass')->row_array();
		
		if(!empty($assResult))
		{
			$soldId=$assResult['sold_id'];			
			$engAssesmentId=$assResult['eng_assesment_id'];			
			$actionBulkstatusId=$assResult['bulkstatus_id'];
			$remark=$assResult['remark'];
			$warehouse=$assResult['warehouse'];
		}
 
		
		$soldResult=$this->db->select('invoice_no,nhmod,device_type,product_name,sale_channel,order_id,selling_mode,category,nhsp')->where('stamp_id',$soldId)->get('tbl_soldstamp')->row_array();
		
		$invoiceNo='';$nhmod='';$productType='';$productName='';$saleChannel='';$orderId='';$sellingMode='';$category='';$nhsp='';
		
		if(!empty($soldResult))
		{
			$invoiceNo=$soldResult['invoice_no'];
			$nhmod=$soldResult['nhmod'];
			$productType=$soldResult['device_type'];
			$productName=$soldResult['product_name'];
			$saleChannel=$soldResult['sale_channel'];
			$orderId=$soldResult['order_id'];
			$sellingMode=$soldResult['selling_mode'];
			$category=$soldResult['category'];
			$nhsp=$soldResult['nhsp'];
		}
		
		$engComment='';
		
		$engTitleResult=$this->db->select('engineer_remark')->where('eng_assesment_id',$engAssesmentId)->get('tbl_title_connectivity')->row_array();
		
		if(!empty($engTitleResult))
		{
			$engComment=$engTitleResult['engineer_remark'];
		} 
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatus_id, 
			'action_bulkstatusid'=>$actionBulkstatusId,
			'nhdin'=>$nhdin,
			'sold_id'=>$soldId,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'engineer_id'=>$engineer_id, 
			'invoice_no'=>$invoiceNo, 
			'nhmod'=>$nhmod, 
			'product_type'=>$productType, 
			'product_name'=>$productName, 
			'sales_channel'=>$saleChannel, 
			'order_id'=>$orderId, 
			'selling_mode'=>$sellingMode, 
			'category'=>$category, 
			'nhsp'=>$nhsp, 
			'other_remark'=>$engComment, 
			'warehouse'=>$warehouse, 
			'remark'=>$remark, 
		);
		
		$this->db->insert('tbl_ass_inpectioncompleted',$data);
	}
	
	function no_to_words($no)
	{
		$words = array('0'=> '' ,'1'=> 'one' ,'2'=> 'two' ,'3' => 'three','4' => 'four','5' => 'five','6' => 'six','7' => 'seven','8' => 'eight','9' => 'nine','10' => 'ten','11' => 'eleven','12' => 'twelve','13' => 'thirteen','14' => 'fouteen','15' => 'fifteen','16' => 'sixteen','17' => 'seventeen','18' => 'eighteen','19' => 'nineteen','20' => 'twenty','30' => 'thirty','40' => 'fourty','50' => 'fifty','60' => 'sixty','70' => 'seventy','80' => 'eighty','90' => 'ninty','100' => 'hundred','1000' => 'thousand','100000' => 'lakh','10000000' => 'crore');
		if($no == 0)
		{
			$value=' ';
		}
		else 
		{
			$novalue='';
			$highno=$no;
			$remainno=0;
			$value=100;
			$value1=1000;
			while($no>=100) 
			{
				if(($value <= $no) &&($no < $value1))
				{
					$novalue=$words["$value"];
					$highno = (int)($no/$value);
					$remainno = $no % $value;
					break;
				}
				$value= $value1;
				$value1 = $value * 100;
			}
			if(array_key_exists("$highno",$words))
			{
				$value=$words["$highno"]." ".$novalue." ".$this->no_to_words($remainno);
			}
			else 
			{
				$unit=$highno%10;
				$ten =(int)($highno/10)*10;
				$value=$words["$ten"]." ".$words["$unit"]." ".$novalue." ".$this->no_to_words($remainno);
			}
		}
		 
		return strtoupper($value);
	}
	
	public function getNhmodAvgFromRfs($nhmod)
	{ 
		$repairCost=0;
		
		$result=$this->db->group_by('nhmod')->select('nhmod,COUNT(nhmod) as totalNhmod,SUM(nhpp) as totalNhpp,AVG(nhpp) as nhppAverage,type_id')->where(array('status'=>'1','nhmod'=>$nhmod))->get('tbl_readyforsale')->row_array();
		
		if($result['type_id']=='2' || $result['type_id']=='4')
		{
			$result['totalNhpp']=$result['totalNhpp']+$repairCost;
			
			$result['nhppAverage']=round(($result['totalNhpp']/$result['totalNhmod']),2);
		} 
			
		return $result;
	}
	
	
	public function getFullQcNhdpForRfs()
	{
		
		/*==CALCULATE FULL QC NHDP WHEN RFS DATA IS NEW==*/
		
		$rfsResult=$this->db->select('stock_subtype,vendor_code,sale_id,nhdin,nhmod,type_id')->where(array('status'=>'1','upload_type'=>'NEW'))->get('tbl_readyforsale')->result();
		
		if(!empty($rfsResult))
		{
			foreach($rfsResult as $rfsResultValue)
			{
				$companyCode=strtoupper($this->getFieldValue('name','tbl_vendor','vendor_code',$rfsResultValue->vendor_code)); 
				
				$fullQcNhdp=0;
				
				$nhmod=$rfsResultValue->nhmod;
					 
				$avgResult=$this->getNhmodAvgFromRfs($nhmod);
					 
				if(!empty($avgResult))
				{  
					$subType=$rfsResultValue->stock_subtype;
					
					$avg=$avgResult['nhppAverage'];
					 
					if($rfsResultValue->type_id=='2' || $rfsResultValue->type_id=='4')
					{
						$fullQcNhdp=round(($avg/0.85),2);
					}
					else if($companyCode=='FLIPKART' && $subType=='CA')
					{
						$fullQcNhdp=round(($avg/0.90),2);
					}
					else if($companyCode=='FLIPKART' && $subType=='REGULAR')
					{
						$fullQcNhdp=round(($avg/0.78),2);
					}
					else if($companyCode=='AMAZON' && $subType=='REGULAR')
					{
						$fullQcNhdp=round(($avg/0.60),2);
					}
					else if(($companyCode=='AMAZON' || $companyCode=='SNAPDEAL' || $companyCode=='FLIPKART') && $subType=='NTF')
					{
				
						$fullQcNhdp=round(($avg/0.96),2);
					}
					else if(($companyCode=='AMAZON' || $companyCode=='SNAPDEAL' || $companyCode=='FLIPKART') && $subType=='CX')
					{
				
						$fullQcNhdp=round(($avg/0.90),2);
					}
					else if(($companyCode=='AMAZON' || $companyCode=='SNAPDEAL' || $companyCode=='FLIPKART') && $subType=='')
					{
				
						$fullQcNhdp=round(($avg/0.88),2);
					}
					
					/*==UPDATE VALUE==*/
					 
					if($fullQcNhdp>0)
					{  
						$this->db->where('sale_id',$rfsResultValue->sale_id)->update('tbl_readyforsale',array('fullqc_nhdpvalue'=>$fullQcNhdp));			
					}
				} 
			}
		} 
		
		
		/*==CALCULATE FULL QC NHDP WHEN RFS DATA IS OLD==*/
		
		$oldRfsResult=$this->db->select('stock_subtype,vendor_code,sale_id,nhdin,nhmod,type_id,company_code')->where(array('status'=>'1','upload_type'=>'OLD'))->get('tbl_readyforsale')->result();
	 
		if(!empty($oldRfsResult))
		{
			foreach($oldRfsResult as $oldRfsResultValue)
			{
				$companyCode=strtoupper($oldRfsResultValue->company_code); 
				
				$fullQcNhdp=0;
				
				$nhmod=$oldRfsResultValue->nhmod;
					 
				$avgResult=$this->getNhmodAvgFromRfs($nhmod);
					 
				if(!empty($avgResult))
				{  
					$subType=$oldRfsResultValue->stock_subtype;
					
					$avg=$avgResult['nhppAverage'];
					 
					if($oldRfsResultValue->type_id=='2' || $oldRfsResultValue->type_id=='4')
					{
						$fullQcNhdp=round(($avg/0.85),2);
					}
					else if($companyCode=='FLIPKART' && $subType=='CA')
					{
						$fullQcNhdp=round(($avg/0.90),2);
					}
					else if($companyCode=='FLIPKART' && $subType=='REGULAR')
					{
						$fullQcNhdp=round(($avg/0.78),2);
					}
					else if($companyCode=='AMAZON' && $subType=='REGULAR')
					{
						$fullQcNhdp=round(($avg/0.60),2);
					}
					else if(($companyCode=='AMAZON' || $companyCode=='SNAPDEAL' || $companyCode=='FLIPKART') && $subType=='NTF')
					{
				
						$fullQcNhdp=round(($avg/0.96),2);
					}
					else if(($companyCode=='AMAZON' || $companyCode=='SNAPDEAL' || $companyCode=='FLIPKART') && $subType=='CX')
					{
				
						$fullQcNhdp=round(($avg/0.90),2);
					}
					else if(($companyCode=='AMAZON' || $companyCode=='SNAPDEAL' || $companyCode=='FLIPKART') && $subType=='')
					{
				
						$fullQcNhdp=round(($avg/0.88),2);
					}
					/*==UPDATE VALUE==*/
					 
					if($fullQcNhdp>0)
					{  
						$this->db->where('sale_id',$oldRfsResultValue->sale_id)->update('tbl_readyforsale',array('fullqc_nhdpvalue'=>$fullQcNhdp));			
					}
				} 
			}
		} 
	}
	
	
	public function getNhwpNhopValue($nhdin)
	{
		$rfsResult=$this->db->select('stock_subtype,vendor_code,sale_id,nhdin,nhmod')->where(array('status'=>'1','nhdin'=>$nhdin))->get('tbl_readyforsale')->result();
		
		if(!empty($rfsResult))
		{
			foreach($rfsResult as $rfsResultValue)
			{
				$result=$this->db->group_by('nhmod')->select('nhmod,SUM(fullqc_nhdpvalue) as totalNhdpValue,AVG(fullqc_nhdpvalue) as fulQcNhdpAverage')->where(array('status'=>'1','nhmod'=>$rfsResultValue->nhmod))->get('tbl_readyforsale')->row_array();
				
				if(!empty($result))
				{
					$avgValue=$result['fulQcNhdpAverage'];
				
					if($avgValue>0)
					{
						$nhwpValue=round(($avgValue/0.90),2); 
						
						$nhopValue=round(($avgValue/0.80),2); 
						 
						$this->db->where('sale_id',$rfsResultValue->sale_id)->update('tbl_readyforsale',array('website_nhdp'=>$avgValue,'nhop_value'=>$nhopValue,'nhwp_value'=>$nhwpValue));
					}
				}
			}			
		}
	
	}

	public function insertReadyForSaleData($nhdin,$bulkstatus_id,$rtoStatus,$salesRetStatus)
	{
		$rfsType=$this->checkRfsType($nhdin);
		
		$grnResult=$this->db->select('nhdp,nhmod,nhpp,device_name,stock_type,stock_subtype,tax_type,vendor_code,imei1_no,imei2_no,warehouse,vendor_name')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$productResult=$this->db->select('tbl_device_type.name as deviceName,tbl_device_brand.name as deviceBrand')->where('tbl_product_details.nhmod',$grnResult['nhmod'])->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')->join('tbl_device_brand','tbl_device_brand.brand_id=tbl_product_details.brand_id')->get('tbl_product_details')->row_array();
		
		$vendorResult=$this->db->select('name')->where('vendor_code',$grnResult['vendor_code'])->get('tbl_vendor')->row_array();
		
		$qc_status='';
		
		$currentStatus=$this->db->select('current_status')->where('nhdin',$nhdin)->order_by('assessment_id','DESC')->get('trc_engassessment')->row();
		
		if(!empty($currentStatus))
		{
			$qc_status=$currentStatus->current_status;
		}
		
		$deviceResult=$this->getTitleConnectDataByNhdin($nhdin);
		
		$color='';$ram='';$rom='';$device_cond='';$deviceCate='';$camera_front='';$camera_main='';$display_screen='';$processor='';$sim_info='';$os='';$battery_charging='';
		
		$workCond1='';$workCond2='';$workCond3='';$workCond4='';$workCond5='';$screen1='';$screen2='';$category='';
		
		$phyHous1='';$phyHous2='';$phyHous3='';$phyHous4='';$phyHous5='';$phyHous6='';$phyHous7='';$network_brand='';$network_type='';
		
		if(!empty($deviceResult))
		{
			$battery_charging= $deviceResult['battery_charging'];
			
			$network_brand= $deviceResult['network_brand'];
			
			$network_type= $deviceResult['network_type'];
			
			$color= $deviceResult['device_color'];
			
			$ram= $deviceResult['ram'];
			
			$rom= $deviceResult['storage_capacity'];
			
			$device_cond= $deviceResult['device_condition'];
			
			$deviceCate= $deviceResult['category'];
			
			$category= $deviceResult['category'];
			
			$camera_front= $deviceResult['camera_front'];
			
			$camera_main= $deviceResult['camera_main'];
			
			$display_screen= $deviceResult['display_screen'];
			
			$processor= $deviceResult['processor'];
			
			$sim_info= $deviceResult['sim_info'];
			
			$os= $deviceResult['os'];
			
			$screen1= $deviceResult['physical_screen'];
			
			$screen2= $deviceResult['physical_screen1'];
			
			$phyHous1= $deviceResult['physical_housing'];
			
			$phyHous2= $deviceResult['physical_housing1'];
			
			$phyHous3= $deviceResult['physical_housing2'];
			
			$phyHous4= $deviceResult['physical_housing3'];
			
			$phyHous5= $deviceResult['physical_housing4'];
			
			$phyHous6= $deviceResult['physical_housing5'];
			
			$phyHous7= $deviceResult['physical_housing6'];
 
			$worCondResult=explode(',',$deviceResult['perfectworking_condition']);
			
			if(isset($worCondResult[0]))
			{
				$workCond1= $worCondResult[0]; 
			} 
					
			if(isset($worCondResult[1]))
			{
				$workCond2= $worCondResult[1];  
			} 	
			if(isset($worCondResult[2]))
			{
				$workCond3= $worCondResult[2];  
			} 	
			if(isset($worCondResult[3]))
			{
				$workCond4= $worCondResult[3];  
			} 	
			if(isset($worCondResult[4]))
			{
				$workCond5= $worCondResult[4];  
			} 					
		}
		
		$productid_status=0;
		
		if($grnResult['nhmod']!='' && $color!='' && $ram!='' && $rom!='' && $category!='' && $device_cond!='')
		{
			$productid_status=1;
		}
		
		$vendorName='';
		
		if(!empty($vendorResult))
		{ 
			$vendorName=$vendorResult['name'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatus_id,
			'nhdin'=>$nhdin,
			'nhmod'=>$grnResult['nhmod'],
			'nhpp'=>$grnResult['nhpp'],
			'fullqc_nhdpvalue'=>$grnResult['nhpp'],
			'product_name'=>$grnResult['device_name'],
			'device_type'=>$productResult['deviceName'],
			'device_brand'=>$productResult['deviceBrand'],
			'stock_type'=>$grnResult['stock_type'],
			'stock_subtype'=>$grnResult['stock_type'],
			'tax_type'=>$grnResult['tax_type'],
			'vendor_code'=>$grnResult['vendor_code'],
			'rto_status'=>$rtoStatus,
			'salesreturn_status'=> $salesRetStatus,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'imei2_no'=> $grnResult['imei2_no'],
			'rfs_type'=>$rfsType,
			'supplier_name'=>$grnResult['vendor_name'],
			'company_code'=>$vendorName,
			'warehouse'=> $grnResult['warehouse'],
			'qc_status'=>$qc_status,
			'color'=>$color,
			'ram'=>$ram,
			'rom'=>$rom, 
			'network_brand'=>$network_brand,
			'network_type'=>$network_type, 
			'ageing_id'=>'',
			'device_cond'=>$device_cond,
			'device_category'=>$deviceCate, 
			'device_category2'=>$category, 
			'front_camera'=>$camera_front,
			'primary_camera'=>$camera_main, 
			'display'=>$display_screen, 
			'processor'=>$processor, 
			'sim_type'=>$sim_info, 
			'clock_speed'=>'', 
			'os'=>$os, 
			'battery'=>$battery_charging, 
			'working_cond1'=>$workCond1,
			'working_cond2'=> $workCond2,
			'working_cond3'=> $workCond3,
			'working_cond4'=> $workCond4,
			'working_cond5'=> $workCond5,
			'screen_cond1'=> $screen1,
			'screen_cond2'=> $screen2,
			'housing_cond1'=> $phyHous1,
			'housing_cond2'=> $phyHous2,
			'housing_cond3'=> $phyHous3,
			'housing_cond4'=> $phyHous4,
			'housing_cond5'=> $phyHous5,
			'housing_cond6'=> $phyHous6,
			'housing_cond7'=> $phyHous7,
			'product_id'=> $this->createProductId($grnResult['nhmod'],$color,$ram,$rom,$category,$device_cond),
			'productid_status'=> $productid_status, 
			'created_date'=>date('Y-m-d H:i:s',strtotime('+1 seconds',strtotime(date("Y-m-d H:i:s")))),
		);
		
		$this->db->insert('tbl_readyforsale',$data);
		
	}
	
	
	public function createProductId($nhmod,$color,$ram,$rom,$category,$cond)
	{
		$colorCode='AEB5';
		
		$getColorCode=$this->db->select('color_code')->where('color_name',$color)->get('tbl_devicecolor')->row_array();
		
		$productId='';
		
		if($nhmod!='')
		{
			$productId.=$nhmod;
		}
		
		if($color!='')
		{
			if(!empty($colodeCode))
			{
				$productId.=$colorCode;
			}
			else
			{
				$productId.=$getColorCode['color_code'];
			}			
		}
		
		if($ram!='')
		{
			$productId.=strtoupper($ram);
		}

		if($rom!='')
		{
			$productId.=strtoupper($rom);
		}
		
		if($category!='')
		{
			if(strtoupper($category)=='REFURBISHED')
			{
				$productId.="REF";
			}
			
			if(strtoupper($category)=='CERTIFIED PRE-OWNED')
			{
				$productId.="CPD";
			}
			
			if(strtoupper($category)=='UNBOXED')
			{
				$productId.="REF";
			}
		}
		
		if($cond!='')
		{
			if(strtoupper($cond)=='LIKE NEW')
			{
				$productId.="LN";
			}
			
			if(strtoupper($cond)=='VERY GOOD')
			{
				$productId.="VG";
			}
			
			if(strtoupper($cond)=='FAIR')
			{
				$productId.="FR";
			}
		}
		
		return $productId;
	}
	
	public function getAllDeviceColorNameWithCode()
	{
		$result=$this->db->get('tbl_devicecolor')->result_array();
		
		return $result;
		
	}
	
	public function setlocCondForDashboard()
	{
		if($this->session->userdata('locationValue')!='ALL' && $this->session->userdata('locationValue')!='')
		{  
			$shortState=$this->getShortValueOfState($this->session->userdata('locationValue'));
			
			if($shortState=='BLR')
			{
				$locCond="warehouse LIKE '%BANGALORE%'";
			}
			else
			{
				$locCond="warehouse LIKE '%HYDERABAD%'"; 
			}		
		}
		else
		{ 
			 $locCond="created_date!='0000-00-00 00:00:00'";
		}
		
		return $locCond;
	}
	
	public function insertHoldStampData($nhdin,$bulkstatus_id,$remark)
	{
		$result=$this->db->select('tbl_grnreport.nhmod,tbl_grnreport.device_name,tbl_device_type.name as typeName')->join('tbl_product_details','tbl_product_details.nhmod=tbl_grnreport.nhmod')->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')->get('tbl_grnreport')->row_array();
		
		$nhmod='';$typeName='';;$device_name='';
		
		if(!empty($result))
		{
			$nhmod=$result['nhmod'];
			$typeName=$result['typeName'];
			$device_name=$result['device_name'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'nhdin'=>$nhdin,
			'bulkstatus_id'=>$bulkstatus_id,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'remark'=>$remark, 
			'nhmod'=>$nhmod,
			'product_type'=>$typeName,
			'product_name'=>$device_name,
			'warehouse'=>$this->session->userdata('location'),
		);
		
		$this->db->insert('tbl_onhold',$data);
	}
	
	function insertOutbondSoldData($nhdin,$bulkstatus_id,$sold_id)
	{
		$soldResult=$this->db->select('nhmod,device_type,product_name,sale_channel,order_id,selling_mode,nhsp,invoice_no,name,warehouse')->where('stamp_id',$sold_id)->get('tbl_soldstamp')->row_array();
		
		$data=array
		(
			'user_id'=>$this->session->userdata('user_id'),
			'nhdin'=>$nhdin,
			'bulkstatus_id'=>$bulkstatus_id,
			'sold_id'=>$sold_id,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),  
			'nhmod'=>$soldResult['nhmod'],
			'product_type'=>$soldResult['device_type'],
			'product_name'=>$soldResult['product_name'],
			'sales_channel'=>$soldResult['sale_channel'],
			'order_id'=>$soldResult['order_id'],
			'selling_mode'=>$soldResult['selling_mode'],
			'category'=>$soldResult['category'],  
			'nhsp'=>$soldResult['nhsp'], 
			'invoice_no'=>$soldResult['invoice_no'],
			'remark'=>$soldResult['name'],
			'warehouse'=>$soldResult['warehouse'],
		);
		
		$this->db->insert('tbl_intransitoutbondsold',$data);
	}
	
	public function insertTrcAssessmentData($bulkstatus_id,$nhdin,$remark='')
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$typeName='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			
			$typeName=$grnResult['product_type'];
			
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatus_id,
			'nhdin'=>$nhdin,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,
			'product_type'=>$typeName,
			'product_name'=>$productName,
			'warehouse'=>$warehouse,	
			'remark'=>$remark,	
		);
		
		$this->db->insert('tbl_trcassessment',$data);
	}
	
	public function insertcertiDeptData($bulkstatus_id,$nhdin)
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$typeName='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			
			$typeName=$grnResult['product_type'];
			
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatus_id,
			'nhdin'=>$nhdin,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,
			'product_type'=>$typeName,
			'product_name'=>$productName,
			'warehouse'=>$warehouse,	
		);
		
		$this->db->insert('tbl_certification_dept',$data);
	}
	
	public function insertOutqcFailData($assesmentId,$bulkstatus_id,$nhdin,$date)
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$productType='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			 
			$productType=$grnResult['product_type'];
			 
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		
		$bulkstatusResult=$this->db->select('sales_channel,order_id,selling_mode,category')->where('bulkstatus_id',$bulkstatus_id)->get('tbl_outqcfail_salesstamp')->row_array();
		
		$salesChannel='';$orderId='';$sellingMode='';$category='';
		
		if(!empty($bulkstatusResult))
		{
			$salesChannel=$bulkstatusResult['sale_channel'];
			
			$orderId=$bulkstatusResult['order_id']; 
			
			$sellingMode=$bulkstatusResult['selling_mode'];
			
			$category=$bulkstatusResult['category']; 
		}
		
		$remark='';$engineer_remark='';
		
		$engTitleResult=$this->db->select('remark,engineer_remark')->where('bulkstatus_id',$bulkstatus_id)->get('tbl_title_connectivity')->row_array();
		
		if(!empty($engTitleResult))
		{
			$remark=$engTitleResult['remark'];
			
			$engineer_remark=$engTitleResult['engineer_remark'];
			
		}
		
		$data=array(
			'eng_assessment_id'=>$assesmentId,
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatus_id,
			'nhdin'=>$nhdin,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,
			'product_type'=>$productType,
			'product_name'=>$productName,
			'sales_channel'=>$salesChannel,
			'order_id'=>$orderId,
			'selling_mode'=>$sellingMode,
			'category'=>$category,
			'eng_id'=>$this->session->userdata('user_id'),
			'remark'=>$remark,
			'other_remark'=>$engineer_remark,
			'warehouse'=>$warehouse,
			'created_date'=>$date,
		);
		
		$this->db->insert('tbl_outqcfail_salesstamp',$data);
		
	}

	public function insetOutQcpassSalesData($nhdin,$engId,$bulkstatus_id,$engAssessmentId=0)
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$productType='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			
			$productType=$grnResult['product_type'];
			
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		
		$bulkstatusResult=$this->db->select('sale_channel,order_id,selling_mode,category,remark')->where('bulkstatus_id',$bulkstatus_id)->get('tbl_bulkstatus')->row_array();
		
		$saleChannel='';$orderId='';$sellingMode='';$category='';$remark='';
		
		if(!empty($bulkstatusResult))
		{
			$saleChannel=$bulkstatusResult['sale_channel'];
			
			$orderId=$bulkstatusResult['order_id'];
			
			$sellingMode=$bulkstatusResult['selling_mode'];
			
			$category=$bulkstatusResult['category'];
			
			$remark=$bulkstatusResult['remark'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'eng_id'=>$engId, 
			'bulkstatus_id'=>$bulkstatus_id,
			'eng_assessment_id'=>$engAssessmentId,
			'nhdin'=>$nhdin, 
			'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,
			'product_type'=>$productType,
			'product_name'=>$productName,
			'sale_channel'=>$saleChannel,
			'order_id'=>$orderId,
			'selling_mode'=>$sellingMode,
			'category'=>$category,
			'warehouse'=>$warehouse,
			'remark'=>$remark,
			'created_date'=>json_encode(array(date("Y-m-d H:i:s"))),
		);
		
		$this->db->insert('tbl_outqcpass_salesstamp',$data);
	}
	
	
	public function insertDispatchData($nhdin,$bulkstatusId,$remark)
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$productType='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			
			$productType=$grnResult['product_type'];
			
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		
		$inspectionCompleteResult=$this->db->select('sold_id,engineer_id,action_bulkstatusid')->where(array('nhdin'=>$nhdin,'status'=>'1'))->order_by('stamp_id','desc')->get('tbl_ass_inpectioncompleted')->row_array();
		
		$soldId=0;$engId=0;$action_bulkstatusid=0;
		
		if(!empty($inspectionCompleteResult))
		{
			$soldId=$inspectionCompleteResult['sold_id'];
			
			$engId=$inspectionCompleteResult['engineer_id'];
			
			$action_bulkstatusid=$inspectionCompleteResult['action_bulkstatusid'];
		}
		
		$soldResult=$this->db->where('stamp_id',$soldId)->get('tbl_soldstamp')->row_array();
		
		$salesChannel='';$orderId='';$sellingMode='';$category='';$invoiceNo='';$nhsp='0.00';
		
		if(!empty($soldResult))
		{
			$salesChannel=$soldResult['sale_channel'];
			
			$orderId=$soldResult['order_id'];
			
			$sellingMode=$soldResult['selling_mode'];
			
			$category=$soldResult['category'];
			
			$nhsp=$soldResult['nhsp'];
			
			$invoiceNo=$soldResult['invoice_no'];
		}
		
		$engId=0;$engAssessmentId=0;
		
		$receivedAsseStatus=$this->db->select('bulkstatus_id')->where(array('nhdin'=>$nhdin,'status'=>'0','receivedassstore_status'=>'1'))->order_by('stamp_id','desc')->get('tbl_receivedassess_ass')->row_array();
		
		$AssessmentBulkstatusId=0;
		
		if(!empty($receivedAsseStatus))
		{
			$AssessmentBulkstatusId=$receivedAsseStatus['bulkstatus_id']; 
		}
 	
		$titleConnectResult=$this->db->where('bulkstatus_id',$AssessmentBulkstatusId)->get('tbl_title_connectivity')->row_array();
		
		$engRemark='';
		
		if(!empty($titleConnectResult))
		{
			$engRemark=$titleConnectResult['engineer_remark'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'nhdin'=>$nhdin,
			'bulkstatus_id'=>$bulkstatusId,
			'action_bulkstatusid'=>$action_bulkstatusid,
			'sold_id'=>$soldId,
			'nhmod'=>$nhmod,
			'product_type'=>$productType,
			'product_name'=>$productName,
			'sales_channel'=>$salesChannel,
			'order_id'=>$orderId,
			'selling_mode'=>$sellingMode,
			'category'=>$category,
			'nhsp'=>$nhsp,
			'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),
			'engineer_id'=>$engId,
			'invoice_no'=>$invoiceNo,
			'remark'=>$remark,
			'other_remark'=>$engRemark,
			'warehouse'=>$warehouse,		
		);
		
		$this->db->insert('tbl_ass_dispatched',$data);
	}
	
	public function insertSalesReturn($bulkstatusId,$nhdin)
	{
		
		$outbondResult=$this->db->select('sold_id,nhmod,product_type,product_name,sales_channel,order_id,selling_mode,category,nhsp,invoice_no,warehouse')->where(array('nhdin'=>$nhdin))->order_by('stamp_id','desc')->get('tbl_intransitoutbondsold')->row_array();
		
		$soldId=0;$nhmod='';$product_type='';$product_name='';$sales_channel='';$order_id='';$selling_mode='';$category='';$nhsp='';$invoice_no='';$warehouse='';
		
		if(!empty($outbondResult))
		{
			$soldId=$outbondResult['sold_id'];
			
			$nhmod=$outbondResult['nhmod'];
			
			$product_type=$outbondResult['product_type'];
			
			$product_name=$outbondResult['product_name'];
			
			$sales_channel=$outbondResult['sales_channel'];
			
			$order_id=$outbondResult['order_id'];
			
			$selling_mode=$outbondResult['selling_mode'];
			
			$category=$outbondResult['category'];
			
			$nhsp=$outbondResult['nhsp'];
			
			$invoice_no=$outbondResult['invoice_no']; 
			
			$warehouse=$outbondResult['warehouse'];
		}
				
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatusId,
			'nhdin'=>$nhdin,
			'sold_id'=>$soldId,
			'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,
			'product_type'=>$product_type,
			'product_name'=>$product_name,
			'sales_channel'=>$sales_channel,
			'order_id'=>$order_id,
			'selling_mode'=>$selling_mode,
			'category'=>$category,
			'invoice_no'=>$invoice_no,
			'nhsp'=>$nhsp,
			'warehouse'=>$warehouse,
		);
		
		$this->db->insert('tbl_salesreturn',$data);
	}
	
	function insertReceivedAssesmentAssData($bulkstatusId,$engAsesId,$nhdin,$updateStatus,$remark)
	{
		
		$soldId=$this->getFieldValue('sold_id','tbl_assinspection','bulkstatus_id',$bulkstatusId);
		
		$nhmod='';$productType='';$productName='';$warehouse='';$saleChannel='';$orderId='';$sellingMode='';$category='';$invoiceNo='';$nhsp='';
		
		$soldResult=$this->db->where('stamp_id',$soldId)->get('tbl_soldstamp')->row_array();
		
		if(!empty($soldResult))
		{
			$nhmod=$soldResult['nhmod'];
			
			$productType=$soldResult['device_type'];
			
			$productName=$soldResult['product_name'];
			
			$warehouse=$soldResult['warehouse'];
			
			$saleChannel=$soldResult['sale_channel'];
			
			$orderId=$soldResult['order_id'];
			
			$sellingMode=$soldResult['selling_mode'];
			
			$category=$soldResult['category'];
			
			$invoiceNo=$soldResult['invoice_no'];
			
			$nhsp=$soldResult['nhsp'];
		}
		
		$engAssessmentResult=$this->db->select('engineer_remark')->where('eng_assesment_id',$engAsesId)->get('tbl_title_connectivity')->row_array();
		
		$otherRemark='';
		
		if(!empty($engAssessmentResult))
		{
			$otherRemark=$engAssessmentResult['engineer_remark'];
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'eng_id'=>$this->session->userdata('user_id'),
			'eng_assesment_id'=>$engAsesId,
			'bulkstatus_id'=>$bulkstatusId,
			'nhdin'=>$nhdin,
			'sold_id'=>$soldId,
			'update_status'=>$updateStatus,
			'imei_no'=>$this->Common_model->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,
			'product_type'=>$productType,
			'product_name'=>$productName,
			'sales_channel'=>$saleChannel,
			'order_id'=>$orderId,
			'selling_mode'=>$sellingMode,
			'category'=>$category,
			'invoice_no'=>$invoiceNo,
			'nhsp'=>$nhsp,
			'remark'=>$remark,
			'other_remark'=>$otherRemark,
			'warehouse'=>$warehouse,
		);
		
		$this->db->insert('tbl_receivedassess_ass',$data);
	}
	
	
	
	function insertAssInspectionData($nhdin,$bulkstatusId,$engId)
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$productType='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			
			$productType=$grnResult['product_type'];
			
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		
		$soldResult=$this->db->select('stamp_id,nhsp,invoice_no,category,selling_mode,order_id,sale_channel,vendor_code')->where('nhdin',$nhdin)->order_by('stamp_id','DESC')->get('tbl_soldstamp')->row_array();
		
		$nhsp='0.00';$invoiceNo='';$category='';$sellingMode='';$orderId='';$saleChannel='';$soldId='0';$vendor_code='';
		
		if(!empty($soldResult))
		{
			$soldId=$soldResult['stamp_id'];
			
			$vendor_code=$soldResult['vendor_code'];
			
			$nhsp=$soldResult['nhsp'];
			
			$invoiceNo=$soldResult['invoice_no'];
			
			$category=$soldResult['category'];
			
			$sellingMode=$soldResult['selling_mode'];
			
			$orderId=$soldResult['order_id'];
			
			$saleChannel=$soldResult['sale_channel']; 
		}
		
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatusId,
			'nhdin'=>$nhdin,
			'sold_id'=>$soldId,
			'vendor_code'=>$vendor_code,
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'engineer_id'=>$engId,
			'invoice_no'=>$invoiceNo,
			'nhmod'=>$nhmod,
			'product_type'=>$productType,
			'product_name'=>$productName,
			'sales_channel'=>$saleChannel,
			'order_id'=>$orderId,
			'selling_mode'=>$sellingMode,
			'category'=>$category,
			'nhsp'=>$nhsp,
			'warehouse'=>$warehouse,
		);
		
		$this->db->insert('tbl_assinspection',$data);
	}
	
	function insertDismantlingData($nhdin,$bulkstatusId)
	{
		$grnResult=$this->db->select('nhmod,product_type,device_name,warehouse')->where('nhdin',$nhdin)->get('tbl_grnreport')->row_array();
		
		$nhmod='';$productType='';$productName='';$warehouse='';
		
		if(!empty($grnResult))
		{
			$nhmod=$grnResult['nhmod'];
			
			$productType=$grnResult['product_type'];
			
			$productName=$grnResult['device_name'];
			
			$warehouse=$grnResult['warehouse'];
		}
		 
		$data=array(
			'user_id'=>$this->session->userdata('user_id'),
			'bulkstatus_id'=>$bulkstatusId,
			'nhdin'=>$nhdin,  
			'imei_no'=>$this->getDeviceImeiNo($nhdin),
			'nhmod'=>$nhmod,  
			'product_type'=>$productType,
			'product_name'=>$productName,    
			'warehouse'=>$warehouse,
		);
		
		$this->db->insert('tbl_dismantling_devices',$data);
	}
	
	function getRowResult($field,$table_name,$cond)
	{
		$database=$this->load->database('default', true);		
		$result=$database->select($field)->get_where($table_name,$cond)->row_array();
		$database->close();
		return $result;
	}
	
	function getAllResult($field,$table_name,$cond)
	{
		$database=$this->load->database('default', true);		
		$result=$database->select($field)->get_where($table_name,$cond)->result_array();
		$database->close();
		return $result;
	}
	
	function insertData($table_name,$data)
	{ 
		$database=$this->load->database('default',true);
		$database->insert($table_name,$data);
		$id=$database->insert_id();
		$database->close();
		return $id;
	}
	
	function updateData($whrcol,$whrcolVal,$table_name,$data)
	{
		$database=$this->load->database('default',true);
		$database->where($whrcol,$whrcolVal)->update($table_name,$data); 
		$database->close(); 
	}
	
	function deleteData($whrcol,$whrcolVal,$table_name)
	{
		$database=$this->load->database('default',true);
		$database->where($whrcol,$whrcolVal)->delete($table_name); 
		$database->close(); 
	}
	
	function getResultOrderBy($field,$table_name,$cond,$ordercol,$order_by)
	{
		$database=$this->load->database('default', true);		
		$result=$database->select($field)->order_by($ordercol,$order_by)->get_where($table_name,$cond)->result_array();
		$database->close();
		return $result;
	}
	
	function insertReturnToWarehouse($nhdin,$bulkstatusId)
	{
		$nhdinResult=$this->db->get_where('tbl_grnreport',array('nhdin'=>$nhdin))->row_array();
		
		if(!empty($nhdinResult))
		{
			$data=array(
				'user_id'=>$this->session->userdata('user_id'),
				'bulkstatus_id'=>$bulkstatusId,
				'nhdin'=>$nhdin,
				'imei_no'=>$this->getDeviceImeiNo($nhdin),
				'nhmod'=>$nhdinResult['nhmod'],
				'product_type'=>$nhdinResult['product_type'],
				'product_name'=>$nhdinResult['device_name'],
				'warehouse'=>$nhdinResult['warehouse'],
			);
			
			$this->db->insert('tbl_returntowarehouse',$data);
		}
	}
	
	public function gettotalDeviceByAdmin()
	{
		$qty=0;
		
		$result=$this->getAllResult('package_qty','tbl_security_admin',array());
		 
		if(!empty($result))
		{
			foreach($result as $value)
			{
				if($value['package_qty']!='')
				{
					$qtyArray=json_decode($value['package_qty'],TRUE);
					
					$qty+=array_sum($qtyArray);
				}
			}
		}
		
		return $qty;
	}
	
	public function getSKU($modelid, $ram, $rom, $color, $color_code = null){
		$sku = $modelid;
		
		if(!empty($ram))
			$sku .= '-'. $ram;
				
		if(!empty($rom))
			$sku .= '-'. $rom;
		
		if(!empty($color) && !isset($color_code)) {
			$color_code = $this->db->where('color',$color)->get('tbl_colorcode')->row()->color_code;
		}

		if(!empty($color_code))
			   $sku .= '-'. $color_code;
		
		return $sku;
	}
	
	public function getColorCodes_List() {
		$rs = $this->db->select('color, color_code')->get('tbl_colorcode')->result_object();

		$list = [];
		foreach($rs as $v) {
			$list[$v->color] = $v->color_code;
		}

		return $list;
	}
	public function getDeviceMemory_List_for($type) {
		$rs = $this->db->where('type', $type)->select('value')->get('tbl_device_memory')->result_object();

		$list = [];
		foreach($rs as $v) {
			$list[] = $v->value;
		}

		return $list;
	}

	public function getRfsView($category,$saletype){

		$query=$this->db->where(array('stock_type'=>$category,'saletype'=>$saletype))->get('RFS_VIEW');
		$result=$query->result_array();
		
		return $result;
	}
	
	public function getDevice_ActivationConditions_List() {
		$rs = $this->db->get('tbl_device_condition')->result_object();

		$list = [];
		foreach($rs as $v) {
			$list[$v->id] = $v->device_condition;
		}

		return $list;
	}
	
}

