<?php
class Auditlog_Model extends MY_Model{

    public function insert_grnreportAudit($grnreport_id, $user_id, $status, $deviceid){

        $insert_array=array(
            "grnreport_id"=>$grnreport_id,
            "user_id"=>$user_id,
            "deviceid"=>$deviceid,
            "status"=>$status,
            "date"=>date("Y-m-d H:i:s")
        );
        $this->db->insert('tbl_grnreport_audit',$insert_array);
        $error=$this->db->error();
        if($error['code']==0){
            return true;
        }else{
            return false;
        }
    }

    public function get_grnreportAudit($grnreport_id){
        
        $this->db->select('tbl_grnreport_audit.status,tbl_grnreport_audit.date,tbl_users.username');
        $this->db->from('tbl_grnreport_audit');
        $this->db->join('tbl_users','tbl_users.user_id=tbl_grnreport_audit.user_id','Left');
        $query=$this->db->where('grnreport_id',$grnreport_id)->get();
        $result=$query->result_array();
        if(!empty($result)){
            return $result;
        }else{
            return false;
        }
    }

    public function insert_auditlog($reference_id, $reference_type, $status, $user_id){

        $insert_array=array(
            "reference_id"=>$reference_id,
            "user_id"=>$user_id,
            "reference_type"=>$reference_type,
            "status"=>$status,
            "date"=>date("Y-m-d H:i:s")
        );
        $this->db->insert('tbl_audit_log',$insert_array);
        $error=$this->db->error();

        if($error['code']==0){
            return true;
        }else{
            return false;
        }
        
    }

    public function get_auditlog($reference_id, $reference_type){

        $this->db->select('tbl_audit_log.status,tbl_audit_log.date,tbl_users.username');
        $this->db->from('tbl_audit_log');
        $this->db->join('tbl_users','tbl_users.user_id=tbl_audit_log.user_id','Left');
        $this->db->where('reference_id',$reference_id);
        $query=$this->db->where('reference_type',$reference_type)->get();
        $result=$query->result_array();
        if(!empty($result)){
            return $result;
        }else{
            return false;
        }
    }
}