<?php

class Api_model extends MY_Model{

    public function getSalesreps(){

        $query=$this->db->select("fullname,tbl_account_details.user_id,sales_code, department_id, sales_area")
        ->where("sales_code!=","")
        ->where("sales_code is not null")
        ->where('banned',0)
        ->join('tbl_users', 'tbl_users.user_id = tbl_account_details.user_id')
        ->get("tbl_account_details");
        $result=$query->result_array();

        return $result;
    }

    public function getProductBrand(){

        $query=$this->db->select("DISTINCT(product_brand)")->order_by("product_brand")->get("tbl_grnreport");
        $result=$query->result_array();

        return $result;
    }

    public function getProductDetails($brandname){

        $query=$this->db->select("DISTINCT(device_name)")->where('product_brand',$brandname)->order_by("device_name")->get("tbl_grnreport");
        $result=$query->result_array();
        if(!empty($result)){
            $prdet=array();
            foreach($result as $value)
			{
                $query2=$this->db->distinct()->select("tbl_grnreport.ram,tbl_grnreport.rom,tbl_grnreport.color,tbl_grnreport.nhmod,tbl_colorcode.color_code")->from("tbl_grnreport")->join('tbl_colorcode','tbl_colorcode.color=tbl_grnreport.color','Left')->where('device_name',$value['device_name'])->get();
                $result2=$query2->result_array();
                foreach($result2 as $productvalues){
                    $variant=$productvalues['color'].'-'.$productvalues['ram'].'-'.$productvalues['rom'];
                    $prdet[]=array(
                        'device_name'=>$value['device_name'],
                        'ram'=>$productvalues['ram'],
                        'rom'=>$productvalues['rom'],
                        'color'=>$productvalues['color'],
                        'color_code'=>$productvalues['color_code'],
                        'nhmod'=>$productvalues['nhmod']
                    );
                }
            }
        }
        return $prdet;
    }

    public function getstock($productname){
        $query=$this->db->select("count(device_name) as stock")->where('device_name',$productname)->get("tbl_grnreport");
        $result=$query->result_array();

        return $result;
    }

    
    public function getsalesorderdetails($salesorder_id){

        $this->db->select("tbl_salesorder_item.*, tbl_grnreport.nhdin");
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_salesorder_item.grnreport_id', 'Left');
        $this->db->where('tbl_salesorder_item.salesorder_id',$salesorder_id);
        $query=  $this->db->get('tbl_salesorder_item');
        $result=$query->result_array();

        return $result;
    }

    public function getWarehouseList(){

        $this->db->select("warehouse,short_code");
        $query=  $this->db->get('tbl_wh_loc');
        $result=$query->result_array();

        return $result;
    }

    public function gradewise_stock($modelid,$category,$sku){

        $variants=array(
            'module_type' => 1,
            "SKU"=>$sku,
            
            "status"=>"RFS",
            "stock_type"=>$category
        );
        $query=$this->db->select("count(grnreport_id) as stock, certification_grade as grade")->where($variants)->group_by('certification_grade')->get('tbl_grnreport');
        $stock_result=$query->result_array();

        $for_reserved=array(
            'module_type' => 1,
            "sku"=>$sku,
            "model_id"=>$modelid
        );
        $status=array("FINANCE_PENDING","FINANCE_REJECTED","FINANCE_APPROVED");
       $this->db->select("sum(quantity) as reserved_qty,grade")->where($for_reserved)->where('tbl_salesorder_item.category', $category)->group_by('grade')->from('tbl_salesorder_item');
       $this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_salesorder_item.salesorder_id','Left');
       $query2= $this->db->where_in("tbl_salesorder.status",$status)->get();
        $reserved_result=$query2->result_array();
        $error1=$this->db->error();

        if(!empty($stock_result)){
			foreach($stock_result as $value){
					$stock[$value["grade"]]=$value["stock"];
			}
			$result['stock']=$stock;
        }else{
            $result['stock']=array();
        }

        if(!empty($reserved_result)){
			foreach($reserved_result as $value){
					$reserved[$value["grade"]]=$value["reserved_qty"];
                }
                $result['reserved']=$reserved;
        }else{
            $result['reserved']=array();
        }
        return $result;
    }

    public function SkuGrade_StockAvblty($modelid,$category,$sku, $grade){

        $variants=array(
            'module_type' => 1,
            "SKU"=>$sku,
            "status"=>"RFS",
            "stock_type"=>$category,
            'certification_grade' => $grade
        );
        // $query=$this->db->select("count(grnreport_id) as stock, certification_grade as grade")->where($variants)->group_by('certification_grade')->get('tbl_grnreport');
        $query=$this->db->select("count(grnreport_id) as stock")->where($variants)->get('tbl_grnreport');
        $stock = $query->row()->stock;

        if (!isset($stock)) {
            $stock = 0;
        }

        $for_reserved=array(
            'module_type' => 1,
            "sku"=>$sku,
            "model_id"=>$modelid,
            'grade' => $grade
        );
        $status=array("FINANCE_PENDING","FINANCE_REJECTED","FINANCE_APPROVED");
        // $this->db->select("sum(quantity) as reserved_qty,grade")->where($for_reserved)->where('tbl_salesorder_item.category', $category)->group_by('grade')->from('tbl_salesorder_item');
        $this->db->select("sum(quantity) as reserved_qty")->where($for_reserved)->where('tbl_salesorder_item.category', $category)->from('tbl_salesorder_item');
        $this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_salesorder_item.salesorder_id','Left');
        $query2= $this->db->where_in("tbl_salesorder.status",$status)->get();
        $reserved_qty = $query2->row()->reserved_qty;

        if (!isset($reserved_qty)) {
            $reserved_qty = 0;
        }

        return [
            'stock' => (int) $stock,
            'reserved' => (int) $reserved_qty,
            'avblty' => (int) $stock - (int) $reserved_qty
        ];
    }

    public function getRemarks($id,$type){
        $query=$this->db->select('remark,tbl_remark.user_id,tbl_users.username,tbl_remark.date')->where('reference_id',$id)->where('reference_type',$type)->from('tbl_remark');
        $query=$this->db->join('tbl_users','tbl_users.user_id=tbl_remark.user_id','Left')->get();
        $result=$query->result_array();
        $error=$this->db->error();
        if($error['code']==0 && !empty($result)){
            return $result;
        }else{
            return false;
        }
    }

    public function getcolor_sku($sku){
        $sku2=explode("-",$sku);
        $where=array(
            "nhmod"=>$sku2[0],
            "ram"=>$sku2[1],
            "rom"=>$sku2[2],
            "color_code"=>$sku2[3]
        );
        $color=$this->db->select("tbl_grnreport.color,tbl_grnreport.product_brand,tbl_grnreport.device_name")->from('tbl_grnreport')->join('tbl_colorcode','tbl_colorcode.color=tbl_grnreport.color','Left')->where($where)->get()->row();
        $error=$this->db->error();
        if($error['code']==0){
            return $color;
        }else{
            return false;
        }
    }

}