<?php


class Hostbooks_authenticator extends Admin_Model
{
    private $environment = 'PRODUCTION';
    
    

    public function postLogin()
    {
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_login_url')->get('tbl_config')->row()->value;
            $username = $this->db->select('value')->where('config_key', 'hostbooks_username')->get('tbl_config')->row()->value;
            $password = $this->db->select('value')->where('config_key', 'hostbooks_password')->get('tbl_config')->row()->value;
            $companyUID = $this->db->select('value')->where('config_key', 'hostbooks_company_id')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxinapiaccounts.hostbooks.in/securitycenter/user/login';
            $username = 'amish@sloyd.in';
            $password = "12345678";
            $companyUID = 'EEB37C63-9FE5-F8F7-51A2-C2DFC452CE78';
        }

        $ch = curl_init($url);

        $data = json_encode(['username' => $username, 'password' => $password]);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);
        $result = json_decode($result, TRUE);
	if ($result['status'] == 200) {
            $access_token = $result['data']['user']['accessToken'];
            $preserve_key = $result['data']['user']['preserveKey'];
	    $this->session->set_userdata('hostbooks_access_token', $access_token);
            $this->session->set_userdata('hostbooks_preserve_key', $preserve_key);
            $this->session->set_userdata('hostbooks_company', $companyUID);
        }
        curl_close($ch);
    }

    public function getCompanyList()
    {
        $this->postLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_companylist_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxinapiaccounts.hostbooks.in/securitycenter/user/companies';
        }

        $ch = curl_init($url);

        $http_header = array(
            'x-version: IND',
            'x-auth-token:' . $this->session->userdata('hostbooks_access_token'),
        );

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);
        $result = json_decode($result, TRUE);
	if ($result['status'] == 200) {
        //$companyUID = $result['data']['comapanies'][0]['companyUID'];
	$companyUID = $result['data']['user'][0]['companyUID'];
        $this->session->set_userdata('hostbooks_company', $companyUID);
        }
        curl_close($ch);
    }

    public function getValidateLogin()
    {
        $this->getCompanyList();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_validate_login')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxinapiaccounts.hostbooks.in/securitycenter/user/validateUserLogin';
        }

        $ch = curl_init($url);

        $http_header = array(
            'x-version: IND',
            'x-preserveKey:' . $this->session->userdata('hostbooks_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_company'),
            'x-forwarded-portal:true'
        );

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);
        $result = json_decode($result, TRUE);
        //var_dump($result);exit;
        if ($result['status'] == 200) {
            $access_token = $result['data']['user']['accessToken'];
            $preserve_key = $result['data']['user']['preserveKey'];
            $companyUUID = $result['data']['user']['companyUUID'];

            $this->session->set_userdata('hostbooks_company_access_token', $access_token);
            $this->session->set_userdata('hostbooks_company_preserve_key', $preserve_key);
            $this->session->set_userdata('hostbooks_companyUUID', $companyUUID);
        }
        curl_close($ch);
        return $result['status'];
    }

    public function postVendor($vendor_id = 0, $is_export = false)
    {
        if ($vendor_id > 0) {
            $this->db->select('tbl_vendor.*, tbl_states.name as state_name')
                     ->join('tbl_states', 'tbl_states.state_id  = tbl_vendor.state', 'left')
                     ->where('tbl_vendor.vendor_id', $vendor_id);
            $result = $this->db->get('tbl_vendor')->result_array();
        }
        if (!empty($result)) {
            $vendor_details = $result[0];
        }
        if (empty($this->session->userdata('hostbooks_company_access_token'))) {
            $this->getValidateLogin();
        }

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_master_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/master/add';
        }

        $ch = curl_init($url);


        if ($is_export) {
            $address = array(
                // "addressGSTIN" => strtoupper($vendor_details['gst_no']),
                "address1" => $vendor_details['address'],
                "city" => 'Other Territory',
                "state" => 'Other Territory',
                // "country" => 'Other Territory',
                "country" => $vendor_details['country'],
            );
        } else {
            $address = array(
                "addressGSTIN" => strtoupper($vendor_details['gst_no']),
                "address1" => $vendor_details['address'],
                "city" => $vendor_details['city'],
                "state" => $vendor_details['state_name'],
                "zip" => $vendor_details['pincode'],
                "country" => "INDIA",
                "pan" => $vendor_details['pan_card'],
                "gstin" => strtoupper($vendor_details['gst_no']),
            );
        }

        $PADR = $address;
        $PADR['type'] = "PADR";

        $BADR = $address;
        $BADR['type'] = "BADR";

        $SADR = $address;
        $SADR['type'] = "SADR";
        $contactGSTIN = [];
        $contactTds = [];

        if (!empty($vendor_details['gst_no']) && !$is_export) {
            $contactGSTIN = array(
                "number" => strtoupper($vendor_details['gst_no']),
                "verified" => false,
                "defaultGstin" => true,
                "billingAddress" => $BADR,
                "shippingAddress" => $SADR
            );

            $deducteeAddress = $address;
            $contactTds = array(
                "deducteeAddress" => $deducteeAddress,
                "tdsApplicable" => true,
                "deducteeName" => $vendor_details['company'],
                "pan" => "29AAMFT0950G",
                "deducteeType" => "company",
                "type" => "PADR"
            );
        }

        $address = [$PADR, $BADR, $SADR];

        if ($vendor_details['used_type'] == 'supplier') {
            $is_vendor = true;
            $is_customer = false;
            $type = "vendor";
        } else {
            $is_vendor = false;
            $is_customer = true;
            $type = "customer";
        }
        $data = array(
            "name" => $vendor_details['company'],
            "accountNumber" => $vendor_details['vendor_code'],
            "employee" => false,
            "vendor" => $is_vendor,
            "customer" => $is_customer,
            "primaryType" => $vendor_details['user_type'],
            "pan" => $vendor_details['pan_card'],
            "email" => $vendor_details['email'],
            "mobile" => $vendor_details['mobile'],
            "status" => "COAC",
            "address" => $address,
            "primaryType" => $type,
            "openingDate" => date("d-m-Y"),
            "contactPerson" => [],
            "contactGroupRelation" => [],
            "basedDiscount" => "yes",
            "contactInventoryMapping" => [],
        );
        
        if ($is_export) {
            $data['mobile'] = null;
        }
        if (!empty($contactGSTIN)) {
            $data['contactGstin'] = [$contactGSTIN];
            //$data['contactTds'] = $contactTds;
        }
        $Req_data = array("contactList" => [$data]);
        $data = json_encode($Req_data);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );

        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        $result = json_decode($result, TRUE);
        curl_close($ch);

        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        if($result['status'] == 401){
            $status = $this->getValidateLogin();
            if($status == 200){
                $this->postVendor($vendor_id);
            }
        }

        return [
            'HB_Vendor_Request' => $Req_data,
            'HB_Vendor_Response' => $result
        ];
    }

    public function postBulkVendor($bulk_vendor_details = array())
    {
        $this->getValidateLogin();
        $url = $this->db->select('value')->where('config_key', 'hostbooks_master_add_url')->get('tbl_config')->row()->value;

        $ch = curl_init($url);
        foreach ($bulk_vendor_details as $vendor_details) {
            $address = array(
                "addressGSTIN" => strtoupper($vendor_details['gst_no']),
                "address1" => $vendor_details['address'],
                "city" => $vendor_details['city'],
                "state" => "Telangana",
                "zip" => $vendor_details['pincode'],
                "country" => "INDIA",
                "pan" => $vendor_details['pan_card'],
                "gstin" => strtoupper($vendor_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";
            $BADR = $address;
            $BADR['type'] = "BADR";
            $SADR = $address;
            $SADR['type'] = "SADR";

            $contactGSTIN = array(
                "number" => strtoupper($vendor_details['gst_no']),
                "verified" => false,
                "defaultGstin" => true,
                "billingAddress" => $BADR,
                "shippingAddress" => $SADR
            );

            $address = [$PADR, $BADR, $SADR];

            if ($vendor_details['used_type'] == 'supplier') {
                $is_vendor = true;
                $is_customer = false;
                $type = "vendor";
            } else {
                $is_vendor = false;
                $is_customer = true;
                $type = "customer";
            }
            $data[] = array(
                "name" => $vendor_details['company'],
                "accountNumber" => $vendor_details['vendor_code'],
                "employee" => false,
                "vendor" => $is_vendor,
                "customer" => $is_customer,
                "primaryType" => $vendor_details['user_type'],
                "pan" => $vendor_details['pan_card'],
                "email" => $vendor_details['email'],
                "mobile" => $vendor_details['mobile'],
                "status" => "COAC",
                "address" => $address,
                "primaryType" => $type,
                "openingDate" => date("d-m-Y"),
                "contactPerson" => [],
                "contactGroupRelation" => [],
                "basedDiscount" => "yes",
                "contactInventoryMapping" => [],
                "contactTds" => array(
                    "deducteeAddress" => new stdClass(),
                    "deducteeType" => null
                ),
                "contactGSTIN" => [$contactGSTIN]
            );
        }

        $data = array("contactList" => $data);
        $data = json_encode($data);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        $result = json_decode($result, TRUE);
        curl_close($ch);
    }

    public function createInvoice($invoice_id = 0, $DIFFERENCE = 0) {
        //return true;

        /** START:: Checking whether Export Invoice or not */
        $sales_channel = $this->db->where('invoice_id', $invoice_id)->select('sales_channel')->get('tbl_invoice')->row()->sales_channel;
        if ($sales_channel == 'EXPORT') {
            return $this->createInvoice_forExports($invoice_id);
        }
        /** END:: Checking whether Export Invoice or not */


        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
        }
        $this->getValidateLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        if (count($invoice_data) == 0) {
            $msg = 'Invalid Invoice';
            GOTO ERROR;
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            if ($invoice_details['sales_channel'] == 'OFFLINE') {
                $cost_center = 'Marketing';
            } else {
                $cost_center = 'E-commerce';
            }

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } elseif (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = round($invoice_details['total_amount'] / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = false;
            } else {
                $taxable_amount = round(($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = true;
            }
            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['qty'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['qty'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['qty'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['qty'], 2);

            $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['qty'], 2);

            $total_tax = round($total_taxable * 0.18, 2, PHP_ROUND_HALF_UP);
	
            if (strtolower($invoice_details['state_name']) == 'telangana') {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2, PHP_ROUND_HALF_UP) + $total_tax;
            }
            
            //FOR 2 PAISA DIFFERENCE
            //$total_amount = roundUpToAny($total_amount);
            //$total_amount = $total_amount - 0.02; // for 0.98
            //$total_amount = $total_amount + 0.02; // for 0.02
	    
            $total_amount = $total_amount + $DIFFERENCE;
                        
            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );

            $net_amount = $invoice_details['total_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2);
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            $tcs_amount = round($total_amount * $invoice_details['tcs_percent'] / 100, 2);
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
		
            $branch = "H.O";
            $company_gstin = "36AASCS2801C1ZI";

            if($invoice_details['warehouse'] == "HYD"){
                $branch = "H.O";
                $company_gstin = "36AASCS2801C1ZI";
            } else if($invoice_details['warehouse'] == "NOIDA"){
                $branch = "NOIDA";
                $company_gstin = "09AASCS2801C1ZF";
            }
        	//echo $company_gstin; exit;
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['qty'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );
            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" =>  $company_gstin,
                "branch" => $branch,
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => $marginal_flag,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['invoice_code'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
	    //echo "<pre>"; print_r($data); echo "</pre>"; exit;
        
        $HB_vendor_Res = $this->postVendor($vendor_id);

        $req_data = array("invoiceList" => $data);
        $post_data = json_encode($req_data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
	    curl_close($ch);
        
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	        $checkCalculationError = $this->calculateDiff($error);
	        //echo $checkCalculationError ; exit;
            
            if($checkCalculationError && $checkCalculationError!== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->createInvoice($invoice_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
            }
        }
        // print '<pre>'.$data.'</pre>';
        // var_dump($result);exit;

        if ($result['status'] == 200) {
            if ($result['data']['TransactionSuccessfulData']['invoiceListTotalSuccessObjects'] >0) {
                $HB_invoice_codes = $result['data']['TransactionSuccessfulData']['invoiceListSuccess'];

                $this->db->where_in('invoice_code', $HB_invoice_codes)->update('tbl_invoice', ['is_HB_integrated' => 1]);
            }
        }

        // return true;

        return [
            'status' => true,
            'message' => isset($msg)? $msg : 'Successful',
            'HB_Vendor_Request' => $HB_vendor_Res['HB_Vendor_Request'],
            'HB_Vendor_Response' => $HB_vendor_Res['HB_Vendor_Response'],
            'HB_Request' => $req_data,
            'HB_Response' => $result
        ];

        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong'
        ];
    }

    public function postFFInvoice($invoice_id = 0, $DIFFERENCE = 0)
    {
        //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('ecom_invoice_id', $invoice_id)->get('ECOM_INVOICE_LIST_VIEW')->result_array();
        }
        $this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            $cost_center = 'E-commerce';

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } else if (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = $invoice_details['invoice_amount'] / 1.18;
                $marginal_flag = false;
            } else {
                $taxable_amount = ($invoice_details['invoice_amount'] - $invoice_details['exempt_amount']) / 1.18;
                $marginal_flag = true;
            }

            if (empty($invoice_details['freight_amount'])) {
                $invoice_details['freight_amount'] = 0;
            }

            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['quantity'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['quantity'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['quantity'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2, PHP_ROUND_HALF_UP);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['quantity'], 2);

            $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['quantity'], 2);
            $total_tax = round($total_taxable * 0.18, 2, PHP_ROUND_HALF_UP);

            $wh_details = $this->db->select('state,gst_number')->where('short_code', $invoice_details['warehouse'])->get('tbl_wh_loc')->row();

            if (strtolower($wh_details->state) == 'telangana') {
                $branch = "H.O";
                $companyGSTIN = $wh_details->gst_number;
            } else {
                $branch = $wh_details->state;
                $companyGSTIN = $wh_details->gst_number;
            }
            if (strtolower($invoice_details['state_name']) == strtolower($wh_details->state)) {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $total_tax;
            }

            $total_amount = $total_amount + $DIFFERENCE;

            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );
            $net_amount = $invoice_details['invoice_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2,  PHP_ROUND_HALF_UP);
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }

            //$total_amount = $total_amount-0.02; //for .98

            $roundoff_amount = round($net_amount - $total_amount, 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['quantity'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );

            if (empty($invoice_details['source_invoice_date']) || $invoice_details['source_invoice_date'] == '0000-00-00') {
                $invoice_date = $invoice_details['sale_date'];
            } else {
                $invoice_date = $invoice_details['source_invoice_date'];
            }


            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" => trim($companyGSTIN),
                "branch" => $branch,
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_date)),
                "dueDate" => date("d-m-Y", strtotime($invoice_date)),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => $marginal_flag,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['ecom_invoice_no'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        $HB_vendor_Res = $this->postVendor($vendor_id);

        $req_data = array("invoiceList" => $data);
        $post_data = json_encode($req_data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
	
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	    
            $checkCalculationError = $this->calculateDiff($error);
            //echo "<pre>"; print_r($result); echo "</pre>"; exit;
            if(($result['status'] != 400) && $checkCalculationError && $checkCalculationError !== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                    //echo $checkCalculationError;
                $this->postFFInvoice($invoice_id, $checkCalculationError);
            }else{
                //echo "Else";
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);            
            }
	    
       }
	   //var_dump($data);exit;
        //    return true;

        return [
            'HB_Vendor_Request' => $HB_vendor_Res['HB_Vendor_Request'],
            'HB_Vendor_Response' => $HB_vendor_Res['HB_Vendor_Response'],
            'HB_Request' => $req_data,
            'HB_Response' => $result
        ];
    }

    public function postOfflineCreditNote($salesreturn_id = 0, $DIFFERENCE = 0)
    {
        //return true;
        if ($salesreturn_id > 0) {
            $invoice_data = $this->db->where('salesreturn_id', $salesreturn_id)->get('CREDITNOTE_HOSTBOOKS_POST_VIEW')->result_array();
        }
        $this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;

        foreach ($invoice_data as $invoice_details) {

            $state_name = explode('-', $invoice_details['location'])[1];

            if ($state_name == 'Jammu and Kashmir') {
                $state_name = 'Jammu & Kashmir';
            }

            if ($state_name == 'Dadra and Nagar Haveli') {
                $state_name = 'Dadra & Nagar Haveli';
            }

            if ($state_name == 'Andaman and Nicobar Islands') {
                $state_name = 'Andaman & Nicobar Islands';
            }

            if ($state_name == 'Daman and Diu') {
                $state_name = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $state_name,
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );

            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            if ($invoice_details['sales_channel'] == 'OFFLINE') {
                $cost_center = 'Marketing';
            } else {
                $cost_center = 'Marketing';
            }

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } else if (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = $invoice_details['total_amount'] / 1.18;
                $marginal_flag = false;
            } else {
                $taxable_amount = ($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18;
                $marginal_flag = true;
            }

            if (empty($invoice_details['freight_amount'])) {
                $invoice_details['freight_amount'] = 0;
            }

            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['quantity'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['quantity'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['quantity'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['quantity'], 2);

            $total_taxable = round(($unit_price  -  $discount_per_unit) * $invoice_details['quantity'], 2);
            $total_tax = round($total_taxable * 0.18, 2);

            $wh_details = $this->db->select('state,gst_number')->where('short_code', $invoice_details['warehouse'])->get('tbl_wh_loc')->row();

            if (strtolower($wh_details->state) == 'telangana') {
                $branch = "H.O";
                $companyGSTIN = $wh_details->gst_number;
            } else {
                $branch = $wh_details->state;
                $companyGSTIN = $wh_details->gst_number;
            }

            if (strtolower($state_name) == strtolower($wh_details->state)) {

                $cgst_amount = $sgst_amount = round($total_tax/ 2, 2, PHP_ROUND_HALF_UP);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $total_tax;
            }
	    $total_amount = $total_amount + $DIFFERENCE;
            if ($invoice_details['tcs_amount'] > 0) {
                $txnIncomeTaxTcs = array(
                    "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
                );

		        $tcs_amount = round($total_amount * ($invoice_details['tcs_percent'] / 100),2, PHP_ROUND_HALF_UP);
            }

            $net_amount = $invoice_details['total_amount'] + $tcs_amount + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2, PHP_ROUND_HALF_UP);
            // print $invoice_details['tcs_amount'];exit;
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            
            //FOR 2 Paisa Differnce
            //$total_amount = $total_amount-0.02; //for .98
            //$total_amount = $total_amount-0.01; //for .99
            //$total_amount = $total_amount+0.01; //for .01
            //$total_amount = $total_amount+0.02; //for .02
            //$total_amount = ceil($total_amount);
            
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['quantity'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );



            $data[] = array(
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "placeSupplyName" => $state_name,
                "typeCode" => "SSCN",
                "originalInvoiceNumber" => $invoice_details['invoice_no'],
                "originalInvoiceDate" => date("d-m-Y", strtotime($invoice_details['invoice_date'])),
                "withMaterialFlag" => true,
                "issueDate" => date("d-m-Y", strtotime($invoice_details['last_modified'])),
                "number" => $invoice_details['creditnote_no'],
                "currencyCode" => "INR",
                "category" => "SelTrue",
                "branch" => $branch,
                "reference" => null,
                "customerGstin" => trim(strtoupper($invoice_details['gst_no'])),
                "companyGstin" => trim($companyGSTIN),
                "txnType" => "SCN",
                "txnStatus" => "TRPN",
                "taxType" => "ETAX",
                "status" => "SCNAP",
                "gstnType" => $gstinType,
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "termCondition" => null,
                "customersNotes" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "date" => date("d-m-Y", strtotime($invoice_details['last_modified'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['last_modified'])),
                "otherReference" => null,
                "vendorCode" => null,
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "bankNumber" => null,
                "bankName" => null,
                "bankIfsc" => null,
                "branchName" => null,
                "reverseChargeFlag" => false,
                "roundingAmount" => strval($roundoff_amount),
                "roundFlag" => true,
                "amount" => $net_amount,
                "licenceNo" =>  null,
                "marginSchemeFlag" => $marginal_flag,
                "flatDiscountFlag" => $discount_flag,
                "lineItems" => $itemlist,

            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        $this->postVendor($vendor_id);
        $data = array("creditNoteList" => $data);
        $data = json_encode($data, JSON_PRETTY_PRINT);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	
	    $checkCalculationError = $this->calculateDiff($error);
	    //echo $checkCalculationError ; exit;
            if($checkCalculationError && $checkCalculationError !== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->postOfflineCreditNote($salesreturn_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                "invoice_id" => $salesreturn_id,
                "invoice_no" => $invoice_details['creditnote_no'],
                "error" => $error
            );
            $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);            }

        }

        return true;
    }

    public function postFFCreditNote($salesreturn_id = 0,$DIFFERENCE = 0)
    {
        //return true;
        if ($salesreturn_id > 0) {
            $invoice_data = $this->db->where('ecom_invoice_id', $salesreturn_id)->get('ECOM_INVOICE_LIST_VIEW')->result_array();
            //print $this->db->last_query();exit;
        }
        $this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;

        foreach ($invoice_data as $invoice_details) {

            $state_name = $invoice_details['state_name'];

            if ($state_name == 'Jammu and Kashmir') {
                $state_name = 'Jammu & Kashmir';
            }

            if ($state_name == 'Dadra and Nagar Haveli') {
                $state_name = 'Dadra & Nagar Haveli';
            }

            if ($state_name == 'Andaman and Nicobar Islands') {
                $state_name = 'Andaman & Nicobar Islands';
            }

            if ($state_name == 'Daman and Diu') {
                $state_name = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $state_name,
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );

            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            $cost_center = 'E-commerce';

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } else if (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = $invoice_details['invoice_amount'] / 1.18;
                $marginal_flag = false;
            } else {
                $taxable_amount = ($invoice_details['invoice_amount'] - $invoice_details['exempt_amount']) / 1.18;
                $marginal_flag = true;
            }

            if (empty($invoice_details['freight_amount'])) {
                $invoice_details['freight_amount'] = 0;
            }

            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['quantity'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['quantity'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['quantity'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['quantity'], 2);

            $total_taxable = round(($unit_price  -  $discount_per_unit) * $invoice_details['quantity'], 2);
            $total_tax = round($total_taxable * 0.18, 2);

            $wh_details = $this->db->select('state,gst_number')->where('short_code', $invoice_details['warehouse'])->get('tbl_wh_loc')->row();

            if (strtolower($wh_details->state) == 'telangana') {
                $branch = "H.O";
                $companyGSTIN = $wh_details->gst_number;
            } else {
                $branch = $wh_details->state;
                $companyGSTIN = $wh_details->gst_number;
            }

            if (strtolower($state_name) == $wh_details->state) {

                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $total_tax;
            }
            $total_amount = $total_amount + $DIFFERENCE;
            if ($invoice_details['tcs_amount'] > 0) {
                $txnIncomeTaxTcs = array(
                    "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
                );
            }

            $net_amount = $invoice_details['invoice_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2, PHP_ROUND_HALF_UP);
            // print $invoice_details['tcs_amount'];exit;
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }

             //FOR 2 Paisa Differnce
            //$total_amount = $total_amount-0.02; //for .98
            //$total_amount = $total_amount-0.01; //for .99
            //$total_amount = $total_amount+0.01; //for .01
            //$total_amount = $total_amount+0.02; //for .02
            
            $roundoff_amount = round($net_amount - ($total_amount + $invoice_details['tcs_amount']), 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['quantity'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );

            if (empty($invoice_details['source_invoice_date']) || $invoice_details['source_invoice_date'] == '0000-00-00') {
                $invoice_date = $invoice_details['sale_date'];
            } else {
                $invoice_date = $invoice_details['source_invoice_date'];
            }

            $data[] = array(
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "placeSupplyName" => $state_name,
                "typeCode" => "SSCN",
                "originalInvoiceNumber" => $invoice_details['ecom_invoice_no'],
                "originalInvoiceDate" => date("d-m-Y", strtotime($invoice_date)),
                "withMaterialFlag" => true,
                "issueDate" => date("d-m-Y", strtotime($invoice_details['returned_date'])),
                "number" => $invoice_details['creditnote_no'],
                "currencyCode" => "INR",
                "category" => "SelTrue",
                "branch" => $branch,
                "reference" => null,
                "customerGstin" => trim(strtoupper($invoice_details['gst_no'])),
                "companyGstin" => trim($companyGSTIN),
                "txnType" => "SCN",
                "txnStatus" => "TRPN",
                "taxType" => "ETAX",
                "status" => "SCNAP",
                "gstnType" => $gstinType,
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "termCondition" => null,
                "customersNotes" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "date" => date("d-m-Y", strtotime($invoice_details['returned_date'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['returned_date'])),
                "otherReference" => null,
                "vendorCode" => null,
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "bankNumber" => null,
                "bankName" => null,
                "bankIfsc" => null,
                "branchName" => null,
                "reverseChargeFlag" => false,
                "roundingAmount" => strval($roundoff_amount),
                "roundFlag" => true,
                "amount" => $net_amount,
                "licenceNo" =>  null,
                "marginSchemeFlag" => $marginal_flag,
                "flatDiscountFlag" => $discount_flag,
                "lineItems" => $itemlist,

            );
            $vendor_id = $invoice_details['vendor_id'];
        }
	
        $this->postVendor($vendor_id);
        $data = array("creditNoteList" => $data);
        $data = json_encode($data, JSON_PRETTY_PRINT);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        curl_close($ch);
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	
	    $checkCalculationError = $this->calculateDiff($error);
	    //echo $checkCalculationError ; exit;
            if($checkCalculationError && $checkCalculationError !== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->postFFCreditNote($salesreturn_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                "invoice_id" => $salesreturn_id,
                "invoice_no" => $invoice_details['creditnote_no'],
                "error" => $error
            );
            $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);            }

            }

        return true;
    }

    public function createPurchaseInvoice($invoice_id = 0)
    {
        //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('admin_id', $invoice_id)->get('PURCHASE_HOSTBOOKS_VIEW')->row();
        }
        //$this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        /**************************************************************************************** */

        $state_name = $this->db->where('state_id', $invoice_data->state)->get('tbl_states')->row()->name;

        if ($state_name == 'Jammu and Kashmir') {
            $state_name = 'Jammu & Kashmir';
        }

        if ($state_name == 'Dadra and Nagar Haveli') {
            $state_name = 'Dadra & Nagar Haveli';
        }

        if ($state_name == 'Andaman and Nicobar Islands') {
            $state_name = 'Andaman & Nicobar Islands';
        }

        if ($state_name == 'Daman and Diu') {
            $state_name = 'Daman & Diu';
        }

        $address = array(
            "address1" => $invoice_data->address,
            "city" => $invoice_data->city,
            "state" => $state_name,
            "zip" => $invoice_data->pincode,
            "country" => "INDIA",
            "pan" => $invoice_data->pan_card,
            "gstin" => $invoice_data->gst_no
        );
        $PADR = $address;
        $PADR['type'] = "PADR";

        $SADR = $address;
        $SADR['type'] = "SADR";


        $category = $this->db->select('stock_type')->where('invoice_no', $invoice_data->invoice_no)
            ->limit(1)->get('tbl_grnreport')->row()->stock_type;

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
	$insurance_cat = INSURANCE_CATEGORY;
        if (in_array($category, $open_cat)) {
            $inv_code = 'SPOB';
            $inv_name = 'Open Box-Smartphone';
            $marginal_flag = false;
        } else if (in_array($category, $new_cat)) {
            $inv_code = 'SPNB';
            $inv_name = 'New Mobiles-Smartphones';
            $marginal_flag = false;
	} else if (in_array($category, $insurance_cat)) {
            $inv_code = 'SPPO';
            $inv_name = 'Pre-Owned-Smartphone';
            $marginal_flag = false;
        } else {
            $inv_code = 'SPPO';
            $inv_name = 'Pre-Owned-Smartphone';
            $marginal_flag = true;
        }


        //Calculations
        $total_amount = $invoice_data->invoice_value;
        $unit_price = $invoice_data->taxable_value / $invoice_data->invoice_qty;
        $unit_price = round($unit_price, 2);
	$single_unit_amount = $total_amount / $invoice_data->invoice_qty;
	$single_unit_amount = round($single_unit_amount, 2);

        //Exempt per unit
        $exempt_per_unit = round($invoice_data->exempt_value / $invoice_data->invoice_qty, 2);
        $total_taxable = round($unit_price * $invoice_data->invoice_qty, 2);
        $total_exempt = round($exempt_per_unit * $invoice_data->invoice_qty, 2);
        $tcs = 0;

        if ($invoice_data->tcs > 0) {
            $tcs = round($total_amount * 0.1 / 100, 2);
            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => '0.1' //It is GST TCS Rate like 10 for 10%//
            );
        }
        $total_tax_amount = round($total_taxable * 0.18, 2);

        if (strtolower($state_name) == "telangana") {
            $cgst_amount = $sgst_amount = round($total_taxable * 0.18 / 2, 2);
            $igst = 0;
        } else {
            $igst = $total_tax_amount;
            $cgst_amount = $sgst_amount = 0;
        }

        $total_amount =  round($total_taxable + $total_exempt + $cgst_amount + $sgst_amount + $igst, 2);

        if ($invoice_data->tcs > 0) {
            $tcs = round($total_amount * 0.1 / 100, 2);
        }

        $invoice_amount = round($invoice_data->invoice_value + $tcs, 2, PHP_ROUND_HALF_UP);

        if ($marginal_flag == false) {
            $account_name = "Purchase Account";
            $itc_eligibility = "INGD";
            $itc_claim = 100.00;
        } else {
            $account_name = "Purchase Account";
            $marginal_account = "Purchase Account-Exempt";
            $itc_eligibility = "IELG";
            $itc_claim = 0.00;
        }

        if ($invoice_data->invoice_value != $total_amount) {
            $round_off = round($invoice_data->invoice_value - $total_amount, 2);
            $round_flag = true;
        } else {
            $round_off = 0;
            $round_flag = false;
        }

        $line_items = array(
            "saleType" => "Normal",
            "quantity" => $invoice_data->invoice_qty,
            "unitPrice" => strval(round($unit_price, 2)),
            "discount" => 0,
            "addDiscount" => 0,
            "freightUnit" => 0,
            "deliveryUnit" => 0,
            "cess" => 0,
            "addCess" => 0,
            "costCenter" => "Procurement",
            "itcClaim" => $itc_claim,
            "itcEligibility" => $itc_eligibility,
            "itcCess" => 0.0,
            "amount" => strval($total_amount),
            "total_amount" => strval($total_amount),
	    //"totalCost" => strval($total_amount),
            "totalCost" => strval($single_unit_amount),
            "exemptAmount" => strval($exempt_per_unit),
	    //"exemptAmount" => 0.1,
	    "inventoryType" => "Smartphone",
            "itemCode" => $inv_code,
            "itemName" => $inv_name,
            "description" => "Smartphone",
            "gstRate" => 18,
            "hsnSac" => "851712",
            "conversionUnitName" => "",
            "type" => "Smartphones",
            "unitName" => "Units",
            "accountName" => $account_name,
            "accountExemptName" => $marginal_account,
            "accountExemptCode" => "40022"
        );

        $bill_list = array(
            "taxType" => "ETAX",
            "typeCode" => "PBILL",
            "currencyCode" => "INR",
            "companyGstin" => "36AASCS2801C1ZI",
            "branch" => "H.O",
            "category" => "SelTrue",
            "billType" => "R",
            "custBillNumber" => $invoice_data->invoice_no,
            "custBillDate" => date("d-m-Y", strtotime($invoice_data->invoice_date)),
            "billDate" => date("d-m-Y", strtotime($invoice_data->invoice_date)),
            "date" => date("d-m-Y", strtotime($invoice_data->invoice_date)),
            "dueDate" => date("d-m-Y", strtotime($invoice_data->invoice_date)),
            "contactCode" => $invoice_data->vendor_code,
            "contactName" => $invoice_data->company,
            "customerGstin" => $invoice_data->gst_no,
            "placeSupplyName" => $state_name,
            "shipAddress" => $SADR,
            "vendorAddress" => $PADR,
            "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
            "itcClaimCheckFlag" => true,
            "vendorCode" => $invoice_data->vendor_code,
            "agentFlag" => false,
            "amount" => strval(round($invoice_amount, 2)),
            "roundingAmount" => strval($round_off),
            "number" => $invoice_data->invoice_no,
            "roundFlag" => $round_flag,
            "marginSchemeFlag" => $marginal_flag,
            "status" => "BAPP",
            "gstnType" => "B2B",
            "lineItems" => array($line_items)

        );
	
        $this->postVendor($invoice_data->supplier_id);
        $data = array("billList" => array($bill_list));
        $data = json_encode($data, JSON_PRETTY_PRINT);
	//echo "<pre>"; print_r($data); echo "</pre>"; exit;
        //print $data;exit;

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
	//echo "<pre>"; print_r($result); echo "</pre>"; exit;
        curl_close($ch);
        $error = '';

        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }

            $insert_arr = array(
                "invoice_id" => $invoice_id,
                "invoice_no" => $invoice_data->invoice_no,
                "error" => $error
            );
            $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
        }

        return true;
    }

    public function postPurchaseReturn($purchase_return_id = 0){    
        
        //return true;
        if ($purchase_return_id > 0) {
            $invoice_data = $this->db->where('purchase_return_id', $purchase_return_id)->get('PR_HOSTBOOKS_VIEW')->row();
        }else{
            return false;
        }

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        /**************************************************************************************** */

        $state_name = $this->db->where('state_id', $invoice_data->state)->get('tbl_states')->row()->name;

        if ($state_name == 'Jammu and Kashmir') {
            $state_name = 'Jammu & Kashmir';
        }

        if ($state_name == 'Dadra and Nagar Haveli') {
            $state_name = 'Dadra & Nagar Haveli';
        }

        if ($state_name == 'Andaman and Nicobar Islands') {
            $state_name = 'Andaman & Nicobar Islands';
        }

        if ($state_name == 'Daman and Diu') {
            $state_name = 'Daman & Diu';
        }

        $address = array(
            "address1" => $invoice_data->address,
            "city" => $invoice_data->city,
            "state" => $state_name,
            "zip" => $invoice_data->pincode,
            "country" => "INDIA",
            "pan" => $invoice_data->pan_card,
            "gstin" => $invoice_data->gst_no
        );
        $PADR = $address;
        $PADR['type'] = "PADR";

        $SADR = $address;
        $SADR['type'] = "SADR";


        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        if (in_array($invoice_data->category, $open_cat)) {
            $inv_code = 'SPOB';
            $inv_name = 'Open Box-Smartphone';
            $marginal_flag = false;
        } else if (in_array($invoice_data->category, $new_cat)) {
            $inv_code = 'SPNB';
            $inv_name = 'New Mobiles-Smartphones';
            $marginal_flag = false;
        } else {
            $inv_code = 'SPPO';
            $inv_name = 'Pre-Owned-Smartphone';
            $marginal_flag = true;
        }

        //Calculations
        $total_amount = $invoice_data->total_amount;
        $unit_price = $invoice_data->taxable_amount / $invoice_data->quantity;
        $unit_price = round($unit_price, 2);

        //Exempt per unit
        $exempt_per_unit = round($invoice_data->exempt_amount / $invoice_data->quantity, 2);

        $total_taxable = round($unit_price * $invoice_data->quantity, 2);
        $total_exempt = round($exempt_per_unit * $invoice_data->quantity, 2);
        $tcs = 0;
        // if ($invoice_data->tcs > 0) {
        //     $tcs = round($total_amount * 0.1 / 100, 2);
        //     $txnIncomeTaxTcs = array(
        //         "incomeTaxTcsValue" => '0.1' //It is GST TCS Rate like 10 for 10%//
        //     );
        // }
        
        $total_tax_amount = round($total_taxable * 0.18, 2);
        if (strtolower($state_name) == "telangana") {

            $cgst_amount = $sgst_amount = round($total_taxable * 0.18 / 2, 2);
            $igst = 0;
        } else {
            $igst = $total_tax_amount;
            $cgst_amount = $sgst_amount = 0;
        }

        $total_amount =  round($total_taxable + $total_exempt + $cgst_amount + $sgst_amount + $igst, 2);


        // if ($invoice_data->tcs > 0) {
        //     $tcs = round($total_amount * 0.1 / 100, 2);
        // }

        $invoice_amount = round($invoice_data->total_amount + $tcs, 2, PHP_ROUND_HALF_UP);

        if ($marginal_flag == false) {
            $account_name = "Purchase Account";
            $itc_eligibility = "INGD";
            $itc_claim = 100.00;
        } else {
            $account_name = "Purchase Account";
            $marginal_account = "Purchase Account-Exempt";
            $itc_eligibility = "IELG";
            $itc_claim = 0.00;
        }

        if ($invoice_data->total_amount != $total_amount) {
            $round_off = round($invoice_data->total_amount - $total_amount, 2);
            $round_flag = true;
        } else {
            $round_off = 0;
            $round_flag = false;
        }

        if($invoice_data->return_type == 'rejected'){
            $material_flag = true;
        }else{
            $material_flag = false;
        }

        $line_items = array(
            "saleType" => "Normal",
            "quantity" => $invoice_data->quantity,
            "unitPrice" => strval(round($unit_price, 2)),
            "discount" => 0,
            "addDiscount" => 0,
            "freightUnit" => 0,
            "deliveryUnit" => 0,
            "cess" => 0,
            "addCess" => 0,
            "costCenter" => "Procurement",
            "itcClaim" => $itc_claim,
            "itcEligibility" => $itc_eligibility,
            "itcCess" => 0.0,
            "amount" => strval($total_amount),
            "total_amount" => strval($total_amount),
            "totalCost" => strval($total_amount),
            "exemptAmount" => strval($exempt_per_unit),
            "inventoryType" => "Smartphone",
            "itemCode" => $inv_code,
            "itemName" => $inv_name,
            "description" => "Smartphone",
            "gstRate" => 18,
            "hsnSac" => "851712",
            "conversionUnitName" => "",
            "type" => "Smartphones",
            "unitName" => "Units",
            "accountName" => $account_name,
            "accountExemptName" => $marginal_account,
            "accountExemptCode" => "40022"
        );

        $bill_list = array(
            "taxType" => "ETAX",
            //"typeCode" => "SSCN",
            "currencyCode" => "INR",
            "txnType" => "PCN",
            "txnStatus" => "TRPN",
            "status" => "PCNDT",
            "companyGstin" => "36AASCS2801C1ZI",
            "branch" => "H.O",
            "category" => "SelTrue",
            "billType" => "R",
            "custBillNumber" => $invoice_data->purchase_return_no,
            "custBillDate" => date("d-m-Y", strtotime($invoice_data->creditnote_date)),
            "originalBillNumber" => $invoice_data->invoice_no,
            "originalBillDate" => date("d-m-Y", strtotime($invoice_data->invoice_date)),
            "withMaterialFlag" => $material_flag,
            "issueDate" => date("d-m-Y", strtotime($invoice_data->creditnote_date)),
            "date" => date("d-m-Y", strtotime($invoice_data->creditnote_date)),
            "billDate" => date("d-m-Y", strtotime($invoice_data->creditnote_date)),
            "reference" => $invoice_data->creditnote_no,
            "dueDate" => date("d-m-Y", strtotime($invoice_data->creditnote_date)),
            "contactCode" => $invoice_data->vendor_code,
            "contactName" => $invoice_data->vendor_name,
            "customerGstin" => $invoice_data->gst_no,
            "placeSupplyName" => $state_name,
            "shipAddress" => $SADR,
            "vendorAddress" => $PADR,
            //"txnIncomeTaxTcs" => $txnIncomeTaxTcs,
            "itcClaimCheckFlag" => true,
            "vendorCode" => $invoice_data->vendor_code,
            "agentFlag" => false,
            "amount" => strval(round($invoice_amount, 2)),
            "roundingAmount" => strval($round_off),
            "number" => $invoice_data->creditnote_no,
            "roundFlag" => $round_flag,
            "marginSchemeFlag" => $marginal_flag,
            "gstnType" => "B2B",
            "reverseChargeFlag" => false,
            
            "lineItems" => array($line_items)

        );
        $this->postVendor($invoice_data->vendor_id);
        $data = array("debitNoteList" => array($bill_list));
        $data = json_encode($data, JSON_PRETTY_PRINT);


        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }
        $this->postVendor($vendor_id);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);
	$error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
        }
        if(!empty($error)){
            $insert_arr = array(
                    "invoice_id" => $purchase_return_id,
                    "invoice_no" => $invoice_data->purchase_return_no,
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
        }
        var_dump($result);exit;
    }


    public function calculateDiff($errorString = '')
    {
        if(strpos($errorString, "not balance") !== false){
            preg_match('#\((.*?)\)#', $errorString, $match);
            
            $newArr = explode( " || ", $match[0]);
            $calculated = preg_replace('/[^0-9\.]/', "", $newArr[0]);
            $given = preg_replace('/[^0-9\.]/', "", $newArr[1]);
            $diff = $calculated - $given;
            
            return $diff;
          }else{
            return false;
          }
    }

   // FOR ADD INVOICES IN HOST BOOKS FROM MANUAL

   public function createHostBookInvoice($invoice_id = 0, $DIFFERENCE = 0)
    {
        //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
        }
        $this->getValidateLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            if ($invoice_details['sales_channel'] == 'OFFLINE') {
                $cost_center = 'Marketing';
            } else {
                $cost_center = 'E-commerce';
            }

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } elseif (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = round($invoice_details['total_amount'] / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = false;
            } else {
                $taxable_amount = round(($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = true;
            }
            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['qty'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['qty'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['qty'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['qty'], 2);

            $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['qty'], 2);

            $total_tax = round($total_taxable * 0.18, 2, PHP_ROUND_HALF_UP);
	    if (strtolower($invoice_details['state_name']) == 'telangana') {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2, PHP_ROUND_HALF_UP) + $total_tax;
            }
            
            //FOR 2 PAISA DIFFERENCE
            //$total_amount = roundUpToAny($total_amount);
            //$total_amount = $total_amount - 0.02; // for 0.98
            //$total_amount = $total_amount + 0.02; // for 0.02
	    
	    
	    $total_amount = $total_amount + $DIFFERENCE;
                        
            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );

            $net_amount = $invoice_details['total_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2);
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            $tcs_amount = round($total_amount * $invoice_details['tcs_percent'] / 100, 2);
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['qty'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );
            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" =>  '36AASCS2801C1ZI',
                "branch" => "H.O",
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => $marginal_flag,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['invoice_code'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        $this->postVendor($vendor_id);
        $data = array("invoiceList" => $data);
        $data = json_encode($data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
	curl_close($ch);
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
//echo $total_amount."<br>";
//echo $error; exit;
	    $checkCalculationError = $this->calculateDiff($error);
	    echo $checkCalculationError ; exit;
            if($checkCalculationError && $DIFFERENCE !== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->createInvoice($invoice_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
            }

            
        }
        // print '<pre>'.$data.'</pre>';
        // var_dump($result);exit;

        return true;
    }

    // ADD SALES RETURN INVOICES MANUALLAY

	public function manualPostOfflineCreditNote($salesreturn_id = 0)
    {
        //return true;
        if ($salesreturn_id > 0) {
            $invoice_data = $this->db->where('salesreturn_id', $salesreturn_id)->get('CREDITNOTE_HOSTBOOKS_POST_VIEW')->result_array();
        }
        $this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;

        foreach ($invoice_data as $invoice_details) {

            $state_name = explode('-', $invoice_details['location'])[1];

            if ($state_name == 'Jammu and Kashmir') {
                $state_name = 'Jammu & Kashmir';
            }

            if ($state_name == 'Dadra and Nagar Haveli') {
                $state_name = 'Dadra & Nagar Haveli';
            }

            if ($state_name == 'Andaman and Nicobar Islands') {
                $state_name = 'Andaman & Nicobar Islands';
            }

            if ($state_name == 'Daman and Diu') {
                $state_name = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $state_name,
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );

            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            if ($invoice_details['sales_channel'] == 'OFFLINE') {
                $cost_center = 'Marketing';
            } else {
                $cost_center = 'Marketing';
            }

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } else if (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = $invoice_details['total_amount'] / 1.18;
                $marginal_flag = false;
            } else {
                $taxable_amount = ($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18;
                $marginal_flag = true;
            }

            if (empty($invoice_details['freight_amount'])) {
                $invoice_details['freight_amount'] = 0;
            }

            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['quantity'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['quantity'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['quantity'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['quantity'], 2);

            $total_taxable = round(($unit_price  -  $discount_per_unit) * $invoice_details['quantity'], 2);
            $total_tax = round($total_taxable * 0.18, 2);

            $wh_details = $this->db->select('state,gst_number')->where('short_code', $invoice_details['warehouse'])->get('tbl_wh_loc')->row();

            if (strtolower($wh_details->state) == 'telangana') {
                $branch = "H.O";
                $companyGSTIN = $wh_details->gst_number;
            } else {
                $branch = $wh_details->state;
                $companyGSTIN = $wh_details->gst_number;
            }

            if (strtolower($state_name) == strtolower($wh_details->state)) {

                $cgst_amount = $sgst_amount = round($total_tax/ 2, 2, PHP_ROUND_HALF_UP);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $total_tax;
            }
            if ($invoice_details['tcs_amount'] > 0) {
                $txnIncomeTaxTcs = array(
                    "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
                );

		        $tcs_amount = round($total_amount * ($invoice_details['tcs_percent'] / 100),2, PHP_ROUND_HALF_UP);
            }

            $net_amount = $invoice_details['total_amount'] + $tcs_amount + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2, PHP_ROUND_HALF_UP);
            // print $invoice_details['tcs_amount'];exit;
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            
            //FOR 2 Paisa Differnce
            //$total_amount = $total_amount-0.02; //for .98
            //$total_amount = $total_amount-0.01; //for .99
            //$total_amount = $total_amount+0.01; //for .01
            //$total_amount = $total_amount+0.02; //for .02
            //$total_amount = ceil($total_amount);
            
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['quantity'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );



            $data[] = array(
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "placeSupplyName" => $state_name,
                "typeCode" => "SSCN",
                "originalInvoiceNumber" => $invoice_details['invoice_no'],
                "originalInvoiceDate" => date("d-m-Y", strtotime($invoice_details['invoice_date'])),
                "withMaterialFlag" => true,
                "issueDate" => date("d-m-Y", strtotime($invoice_details['last_modified'])),
                "number" => $invoice_details['creditnote_no'],
                "currencyCode" => "INR",
                "category" => "SelTrue",
                "branch" => $branch,
                "reference" => null,
                "customerGstin" => trim(strtoupper($invoice_details['gst_no'])),
                "companyGstin" => trim($companyGSTIN),
                "txnType" => "SCN",
                "txnStatus" => "TRPN",
                "taxType" => "ETAX",
                "status" => "SCNAP",
                "gstnType" => $gstinType,
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "termCondition" => null,
                "customersNotes" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "date" => date("d-m-Y", strtotime($invoice_details['last_modified'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['last_modified'])),
                "otherReference" => null,
                "vendorCode" => null,
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "bankNumber" => null,
                "bankName" => null,
                "bankIfsc" => null,
                "branchName" => null,
                "reverseChargeFlag" => false,
                "roundingAmount" => strval($roundoff_amount),
                "roundFlag" => true,
                "amount" => $net_amount,
                "licenceNo" =>  null,
                "marginSchemeFlag" => $marginal_flag,
                "flatDiscountFlag" => $discount_flag,
                "lineItems" => $itemlist,

            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        $this->postVendor($vendor_id);
        $data = array("creditNoteList" => $data);
        $data = json_encode($data, JSON_PRETTY_PRINT);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }

            $insert_arr = array(
                "invoice_id" => $salesreturn_id,
                "invoice_no" => $invoice_details['creditnote_no'],
                "error" => $error
            );
            $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
        }

        return true;
    }

    // ADD FULLFILLMENT RETURN INVOICES TO HOSTBOOKS MANUALLY

    public function manualPostFFCreditNote($salesreturn_id = 0)
    {
        //return true;
        if ($salesreturn_id > 0) {
            $invoice_data = $this->db->where('ecom_invoice_id', $salesreturn_id)->get('ECOM_INVOICE_LIST_VIEW')->result_array();
            //print $this->db->last_query();exit;
        }
        $this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;

        foreach ($invoice_data as $invoice_details) {

            $state_name = $invoice_details['state_name'];

            if ($state_name == 'Jammu and Kashmir') {
                $state_name = 'Jammu & Kashmir';
            }

            if ($state_name == 'Dadra and Nagar Haveli') {
                $state_name = 'Dadra & Nagar Haveli';
            }

            if ($state_name == 'Andaman and Nicobar Islands') {
                $state_name = 'Andaman & Nicobar Islands';
            }

            if ($state_name == 'Daman and Diu') {
                $state_name = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $state_name,
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );

            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            $cost_center = 'E-commerce';

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } else if (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = $invoice_details['invoice_amount'] / 1.18;
                $marginal_flag = false;
            } else {
                $taxable_amount = ($invoice_details['invoice_amount'] - $invoice_details['exempt_amount']) / 1.18;
                $marginal_flag = true;
            }

            if (empty($invoice_details['freight_amount'])) {
                $invoice_details['freight_amount'] = 0;
            }

            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['quantity'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['quantity'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['quantity'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['quantity'], 2);

            $total_taxable = round(($unit_price  -  $discount_per_unit) * $invoice_details['quantity'], 2);
            $total_tax = round($total_taxable * 0.18, 2);

            $wh_details = $this->db->select('state,gst_number')->where('short_code', $invoice_details['warehouse'])->get('tbl_wh_loc')->row();

            if (strtolower($wh_details->state) == 'telangana') {
                $branch = "H.O";
                $companyGSTIN = $wh_details->gst_number;
            } else {
                $branch = $wh_details->state;
                $companyGSTIN = $wh_details->gst_number;
            }

            if (strtolower($state_name) == $wh_details->state) {

                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $total_tax;
            }
            if ($invoice_details['tcs_amount'] > 0) {
                $txnIncomeTaxTcs = array(
                    "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
                );
            }

            $net_amount = $invoice_details['invoice_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2, PHP_ROUND_HALF_UP);
            // print $invoice_details['tcs_amount'];exit;
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }

             //FOR 2 Paisa Differnce
            //$total_amount = $total_amount-0.02; //for .98
            //$total_amount = $total_amount-0.01; //for .99
            //$total_amount = $total_amount+0.01; //for .01
            //$total_amount = $total_amount+0.02; //for .02
            
            $roundoff_amount = round($net_amount - ($total_amount + $invoice_details['tcs_amount']), 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['quantity'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );

            if (empty($invoice_details['source_invoice_date']) || $invoice_details['source_invoice_date'] == '0000-00-00') {
                $invoice_date = $invoice_details['sale_date'];
            } else {
                $invoice_date = $invoice_details['source_invoice_date'];
            }

            $data[] = array(
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "placeSupplyName" => $state_name,
                "typeCode" => "SSCN",
                "originalInvoiceNumber" => $invoice_details['ecom_invoice_no'],
                "originalInvoiceDate" => date("d-m-Y", strtotime($invoice_date)),
                "withMaterialFlag" => true,
                "issueDate" => date("d-m-Y", strtotime($invoice_details['returned_date'])),
                "number" => $invoice_details['creditnote_no'],
                "currencyCode" => "INR",
                "category" => "SelTrue",
                "branch" => $branch,
                "reference" => null,
                "customerGstin" => trim(strtoupper($invoice_details['gst_no'])),
                "companyGstin" => trim($companyGSTIN),
                "txnType" => "SCN",
                "txnStatus" => "TRPN",
                "taxType" => "ETAX",
                "status" => "SCNAP",
                "gstnType" => $gstinType,
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "termCondition" => null,
                "customersNotes" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "date" => date("d-m-Y", strtotime($invoice_details['returned_date'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['returned_date'])),
                "otherReference" => null,
                "vendorCode" => null,
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "bankNumber" => null,
                "bankName" => null,
                "bankIfsc" => null,
                "branchName" => null,
                "reverseChargeFlag" => false,
                "roundingAmount" => strval($roundoff_amount),
                "roundFlag" => true,
                "amount" => $net_amount,
                "licenceNo" =>  null,
                "marginSchemeFlag" => $marginal_flag,
                "flatDiscountFlag" => $discount_flag,
                "lineItems" => $itemlist,

            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        $this->postVendor($vendor_id);
        $data = array("creditNoteList" => $data);
        $data = json_encode($data, JSON_PRETTY_PRINT);
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }

            $insert_arr = array(
                "invoice_id" => $salesreturn_id,
                "invoice_no" => $invoice_details['creditnote_no'],
                "error" => $error
            );
            $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
        }

        return true;
    }

// TEST OFFLINE INVOICE

    public function testInvoice($invoice_id = 0, $DIFFERENCE = 0)
    {
        
	    //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
        }
        $this->getValidateLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            if ($invoice_details['sales_channel'] == 'OFFLINE') {
                $cost_center = 'Marketing';
            } else {
                $cost_center = 'E-commerce';
            }

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } elseif (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = round($invoice_details['total_amount'] / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = false;
            } else {
                $taxable_amount = round(($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = true;
            }

            $exempt_amount = round($invoice_details['exempt_amount'],2,PHP_ROUND_HALF_UP);
	    $invoice_amount = round($invoice_details['total_amount'],2,PHP_ROUND_HALF_UP);
	    //$exempt_amount = 40462.9;
	    //$invoice_amount = 40462.9;
	    $discount_amount = round($invoice_details['discount_amount'],2,PHP_ROUND_HALF_UP);
	    $net_invoice_amount = round(($invoice_amount-$discount_amount),2,PHP_ROUND_HALF_UP);
	    
	    if($exempt_amount > $net_invoice_amount){
			
			$net_invoice_amount = round($net_invoice_amount,1);
			$exempt_amount = $net_invoice_amount;
			$invoice_amount = $net_invoice_amount;
			$taxable_amount = 0;
			$discount_amount_excl_tax = $taxable_amount / 1.18;
			$discount_per_unit = round($taxable_amount / $invoice_details['qty'], 2);
			
		} else{
			$exempt_amount = $exempt_amount;
			$invoice_amount = $invoice_amount;
			$discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
			$discount_per_unit = round($discount_amount_excl_tax / $invoice_details['qty'], 2);
			
		}
	    
	    $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['qty'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['qty'], 2);
	    $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['qty'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

	    //echo $discount_per_unit; exit;
	    $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['qty'], 2);
            $total_tax = round($total_taxable * 0.18, 2, PHP_ROUND_HALF_UP);
	    
	    if (strtolower($invoice_details['state_name']) == 'telangana') {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2, PHP_ROUND_HALF_UP) + $total_tax;
            }
            	    
	    $total_amount = $total_amount + $DIFFERENCE;
                        
            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );
	    
            if($exempt_amount >= $net_invoice_amount){
			$net_amount = $exempt_amount;
			
		} else{
			$net_amount = $invoice_details['total_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
			
		}
		
            //$net_amount = round($net_amount, 2);
	    if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }
	    //echo $discount_amount_excl_tax; exit;
            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            $tcs_amount = round($total_amount * $invoice_details['tcs_percent'] / 100, 2);
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
	    if($roundoff_amount < 0){
		$roundoff_amount = 0;
		}
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['qty'],
                "unitPrice" => strval($unit_price),
		//"unitPrice" => 0,
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );
            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" =>  '36AASCS2801C1ZI',
                "branch" => "H.O",
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => strval(round($net_amount, 2)),
                "marginSchemeFlag" => 1,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['invoice_code'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
	
	
        $this->postVendor($vendor_id);
        $data = array("invoiceList" => $data);
	    //echo "<pre>"; print_r($data); echo "</pre>"; exit;

        $data = json_encode($data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
	    curl_close($ch);
	    //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	    $checkCalculationError = $this->calculateDiff($error);
	    //echo $checkCalculationError ; exit;
            if($checkCalculationError && $checkCalculationError!== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->createInvoice($invoice_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
            }

            
        }
        // print '<pre>'.$data.'</pre>';
        //var_dump($result);exit;

        return true;
    }

    public function checkInvoice($invoice_id = 0, $DIFFERENCE = 0)
    {
        
	    //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
        }
        $this->getValidateLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            if ($invoice_details['sales_channel'] == 'OFFLINE') {
                $cost_center = 'Marketing';
            } else {
                $cost_center = 'E-commerce';
            }

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } elseif (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = round($invoice_details['total_amount'] / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = false;
            } else {
                $taxable_amount = round(($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18,2,PHP_ROUND_HALF_UP);
                $marginal_flag = true;
            }

            $exempt_amount = round($invoice_details['exempt_amount'],2,PHP_ROUND_HALF_UP);
	    $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['qty'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['qty'], 2);
	    $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
	    $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['qty'], 2);
	    $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['qty'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

	   //echo $discount_per_unit; exit;
	    $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['qty'], 2);
            $total_tax = round($total_taxable * 0.18, 2, PHP_ROUND_HALF_UP);
	    
	    if (strtolower($invoice_details['state_name']) == 'telangana') {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2, PHP_ROUND_HALF_UP) + $total_tax;
            }
            	    
	    $total_amount = $total_amount + $DIFFERENCE;
                        
            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );
	    
            $net_amount = $invoice_details['total_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
			
	    //$net_amount = round($net_amount, 2);
	    if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }
	    //echo $discount_amount_excl_tax; exit;
            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            $tcs_amount = round($total_amount * $invoice_details['tcs_percent'] / 100, 2);
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
	    if($roundoff_amount < 0){
		$roundoff_amount = 0;
		}
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['qty'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );
            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" =>  '36AASCS2801C1ZI',
                "branch" => "H.O",
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => 1,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['invoice_code'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
	    echo "<pre>"; print_r($data); echo "</pre>"; exit;

        $this->postVendor($vendor_id);
        $data = array("invoiceList" => $data);
        $data = json_encode($data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
	    curl_close($ch);
	    //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	    $checkCalculationError = $this->calculateDiff($error);
	    //echo $checkCalculationError ; exit;
            if($checkCalculationError && $checkCalculationError!== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->createInvoice($invoice_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
            }

            
        }
        // print '<pre>'.$data.'</pre>';
        // var_dump($result);exit;

        return true;
    }
    
    public function postFFInvoice_test($invoice_id = 0, $DIFFERENCE = 0)
    {
        //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('ecom_invoice_id', $invoice_id)->get('ECOM_INVOICE_LIST_VIEW')->result_array();
        }
        $this->getValidateLogin();

        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            $cost_center = 'E-commerce';

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } else if (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = $invoice_details['invoice_amount'] / 1.18;
                $marginal_flag = false;
            } else {
                $taxable_amount = ($invoice_details['invoice_amount'] - $invoice_details['exempt_amount']) / 1.18;
                $marginal_flag = true;
            }

            if (empty($invoice_details['freight_amount'])) {
                $invoice_details['freight_amount'] = 0;
            }

            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['quantity'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / 1.18, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['quantity'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['quantity'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2, PHP_ROUND_HALF_UP);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / 1.18;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['quantity'], 2);

            $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['quantity'], 2);
            $total_tax = round($total_taxable * 0.18, 2, PHP_ROUND_HALF_UP);

            $wh_details = $this->db->select('state,gst_number')->where('short_code', $invoice_details['warehouse'])->get('tbl_wh_loc')->row();

            if (strtolower($wh_details->state) == 'telangana') {
                $branch = "H.O";
                $companyGSTIN = $wh_details->gst_number;
            } else {
                $branch = $wh_details->state;
                $companyGSTIN = $wh_details->gst_number;
            }
            if (strtolower($invoice_details['state_name']) == strtolower($wh_details->state)) {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['quantity'], 2) + $total_tax;
            }

            $total_amount = $total_amount + $DIFFERENCE;

            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );
            $net_amount = $invoice_details['invoice_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2,  PHP_ROUND_HALF_UP);
            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }

            //$total_amount = $total_amount-0.02; //for .98

            $roundoff_amount = round($net_amount - $total_amount, 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['quantity'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "18%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 18,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );

            if (empty($invoice_details['source_invoice_date']) || $invoice_details['source_invoice_date'] == '0000-00-00') {
                $invoice_date = $invoice_details['sale_date'];
            } else {
                $invoice_date = $invoice_details['source_invoice_date'];
            }


            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" => trim($companyGSTIN),
                "branch" => $branch,
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_date)),
                "dueDate" => date("d-m-Y", strtotime($invoice_date)),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => $marginal_flag,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['ecom_invoice_no'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        $HB_vendor_Res = $this->postVendor($vendor_id);

        $req_data = array("invoiceList" => $data);
        $post_data = json_encode($req_data, JSON_PRETTY_PRINT);
        //echo "<pre>"; print_r($data); echo "</pre>"; exit;
        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
	
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);
	
        $result = json_decode($result1, TRUE);
        curl_close($ch);
        $error = '';


        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
	    
            $checkCalculationError = $this->calculateDiff($error);
            //echo "<pre>"; print_r($result); echo "</pre>"; exit;
            if(($result['status'] != 400) && $checkCalculationError && $checkCalculationError !== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                    //echo $checkCalculationError;
                $this->postFFInvoice_test($invoice_id, $checkCalculationError);
            }else{
                //echo "Else";
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);            
            }
	    
       }

	   //var_dump($data);exit;
       
       return [
            'HB_Vendor_Request' => $HB_vendor_Res['HB_Vendor_Request'],
            'HB_Vendor_Response' => $HB_vendor_Res['HB_Vendor_Response'],
            'HB_Request' => $req_data,
            'HB_Response' => $result
       ];
    }
 
    public function createInvoice_forNonProduct($invoice_id = 0, $DIFFERENCE = 0) {
            
        //return true;
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('NON_PRODUCT_INVOICE_EXPORT_REPORT_VIEW')->result_array();
        }
        $this->getValidateLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        
        foreach ($invoice_data as $invoice_details) {

            $gst_rate = $invoice_details['tax_rate'];
            if (count(explode(',', $gst_rate)) > 1) {
                $msg = 'Multiple Tax Rates present in same Invoice: '. $invoice_details['invoice_code'];
                GOTO ERROR;
            }
            $TAX_RATE = round(((float) $gst_rate) / 100, 2);
            // $TAX_RATE = 0.18;
            // echo json_encode(['taxrate' => $TAX_RATE]);exit;

            $TAXABLE_RATE = 1 + $TAX_RATE;

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => $invoice_details['city'],
                "state" => $invoice_details['state_name'],
                "zip" => $invoice_details['pincode'],
                "country" => "INDIA",
                "pan" => $invoice_details['pan_card'],
                "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            $cost_center = 'NON_PRODUCT';

            $inv_code = null;
            $inv_name = 'Non-Product';

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

            if ($invoice_details['exempt_amount'] == 0) {
                $taxable_amount = round($invoice_details['total_amount'] / $TAXABLE_RATE,2,PHP_ROUND_HALF_UP);
                $marginal_flag = false;
            } else {
                $taxable_amount = round(($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / $TAXABLE_RATE,2,PHP_ROUND_HALF_UP);
                $marginal_flag = true;
            }
            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = 0;
            $freight_amount_per_unit = 0;

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['qty'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['qty'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = 0;
            $discount_per_unit = 0;

            $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['qty'], 2);

            $total_tax = round($total_taxable * $TAX_RATE, 2, PHP_ROUND_HALF_UP);

            if (strtolower($invoice_details['state_name']) == 'telangana') {
                $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2) + $sgst_amount + $cgst_amount;
            } else {
                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2, PHP_ROUND_HALF_UP) + $total_tax;
            }
            
            //FOR 2 PAISA DIFFERENCE
            //$total_amount = roundUpToAny($total_amount);
            //$total_amount = $total_amount - 0.02; // for 0.98
            //$total_amount = $total_amount + 0.02; // for 0.02
        
            $total_amount = $total_amount + $DIFFERENCE;
                        
            // $txnIncomeTaxTcs = array(
            //     "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            // );
            $txnIncomeTaxTcs = null;

            // $net_amount = $invoice_details['total_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = $invoice_details['total_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2);

            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                // $account_name = "Sale of Goods";
            } else {
                // $account_name = "Sale of Goods";
                // $marginal_account = "Sale of Goods-Exempt";
                $marginal_account = "NonProduct-Exempt";
            }
            $account_name = "Sale of Services";
            
            // $tcs_amount = round($total_amount * $invoice_details['tcs_percent'] / 100, 2);
            $tcs_amount = 0;
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
            
            $itemlist[0] = array(
                // "saleType" => "Normal",
                "quantity" => $invoice_details['qty'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => $gst_rate . "%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                // "inventoryType" => "Smartphone",
                // "itemCode" => $inv_code,
                // "itemName" => $inv_name,
                "description" => null,
                "gstRate" => $gst_rate,
                // "hsnSac" => "851712",
                "conversionUnitName" => null,
                // "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );
            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" =>  '36AASCS2801C1ZI',
                "branch" => "H.O",
                // "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => $invoice_details['state_name'],
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                // "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => $marginal_flag,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['invoice_code'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "SINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );

            $vendor_id = $invoice_details['vendor_id'];
        }
        //echo "<pre>"; print_r($data); echo "</pre>"; exit;
        
        $HB_vendor_Res = $this->postVendor($vendor_id);

        $req_data = array("invoiceList" => $data);
        $post_data = json_encode($req_data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);
        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
            $checkCalculationError = $this->calculateDiff($error);
            //echo $checkCalculationError ; exit;
            if (($result['status'] != 400) && $checkCalculationError && $checkCalculationError!== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->createInvoice_forNonProduct($invoice_id, $checkCalculationError);
            } else {
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
            }
            
        }
        // print '<pre>'.$data.'</pre>';
        // var_dump($result);exit;

        if ($result['status'] == 200) {
            if ($result['data']['TransactionSuccessfulData']['invoiceListTotalSuccessObjects'] >0) {
                $HB_invoice_codes = $result['data']['TransactionSuccessfulData']['invoiceListSuccess'];

                $this->db->where_in('invoice_code', $HB_invoice_codes)->update('tbl_invoice', ['is_HB_integrated' => 1]);
            }
        }

        return [
            'status' => true,
            'message' => isset($msg)? $msg : 'Successful',
            'HB_Vendor_Request' => $HB_vendor_Res['HB_Vendor_Request'],
            'HB_Vendor_Response' => $HB_vendor_Res['HB_Vendor_Response'],
            'HB_Request' => $req_data,
            'HB_Response' => $result
        ];

        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong'
        ];
    }
    
    public function createInvoice_forExports($invoice_id = 0, $DIFFERENCE = 0) {
        
        if ($invoice_id > 0) {
            $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
        }
        $this->getValidateLogin();
        if ($this->environment == 'PRODUCTION') {
            $url = $this->db->select('value')->where('config_key', 'hostbooks_transaction_add_url')->get('tbl_config')->row()->value;
        } else {
            $url = 'https://sandboxin2accounts.hostbooks.in/hostbook/api/transaction/add';
        }

        if (count($invoice_data) == 0) {
            $msg = 'Invalid Invoice';
            GOTO ERROR;
        }

        $TAX_RATE = 0;
        $TAXABLE_RATE = 1 + $TAX_RATE;

        $open_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;
        foreach ($invoice_data as $invoice_details) {

            if ($invoice_details['state_name'] == 'Jammu and Kashmir') {
                $invoice_details['state_name'] = 'Jammu & Kashmir';
            }

            if ($invoice_details['state_name'] == 'Dadra and Nagar Haveli') {
                $invoice_details['state_name'] = 'Dadra & Nagar Haveli';
            }

            if ($invoice_details['state_name'] == 'Andaman and Nicobar Islands') {
                $invoice_details['state_name'] = 'Andaman & Nicobar Islands';
            }

            if ($invoice_details['state_name'] == 'Daman and Diu') {
                $invoice_details['state_name'] = 'Daman & Diu';
            }

            $address = array(
                "address1" => $invoice_details['address'],
                "city" => 'Other Territory',
                "state" => 'Other Territory',
                // "country" => 'Other Territory',
                // "city" => !empty($invoice_details['city'])? $invoice_details['city'] : 'Other Territory',
                // "state" => !empty($invoice_details['state'])? $invoice_details['state'] : 'Other Territory',
                // "zip" => !empty($invoice_details['pincode'])? $invoice_details['pincode'] : 'NA',
                "country" => $invoice_details['country'],
                // "pan" => $invoice_details['pan_card'],
                // "gstin" => strtoupper($invoice_details['gst_no']),
            );
            $PADR = $address;
            $PADR['type'] = "PADR";

            $BADR = $address;
            $BADR['type'] = "BADR";

            $SADR = $address;
            $SADR['type'] = "SADR";

            $cost_center = $invoice_details['sales_channel'];

            if (in_array($invoice_details['category'], $open_cat)) {
                $inv_code = 'SPOB';
                $inv_name = 'Open Box-Smartphone';
            } elseif (in_array($invoice_details['category'], $new_cat)) {
                $inv_code = 'SPNB';
                $inv_name = 'New Mobiles-Smartphones';
            } else {
                $inv_code = 'SPPO';
                $inv_name = 'Pre-Owned-Smartphone';
            }

            if (!empty($invoice_details['gst_no'])) {
                $gstinType = 'B2B';
            } else {
                $gstinType = 'B2C';
            }

        
            // $taxable_amount = round(($invoice_details['total_amount'] - $invoice_details['exempt_amount']) / 1.18,2,PHP_ROUND_HALF_UP);
            $taxable_amount = 0;
            $marginal_flag = true;
                
            $exempt_amount = $invoice_details['exempt_amount'];
            $freight_amount_per_unit_incl_tax = $invoice_details['freight_amount'] / $invoice_details['qty'];
            $freight_amount_per_unit = round($freight_amount_per_unit_incl_tax / $TAXABLE_RATE, 2);

            $margin_sale_price_per_unit = round(($exempt_amount + $taxable_amount) / $invoice_details['qty'], 2);
            $exempt_amount_per_unit = round($exempt_amount / $invoice_details['qty'], 2);

            $unit_price = round($margin_sale_price_per_unit - $exempt_amount_per_unit, 2);

            $discount_amount_excl_tax = $invoice_details['discount_amount'] / $TAXABLE_RATE;
            $discount_per_unit = round($discount_amount_excl_tax / $invoice_details['qty'], 2);

            $total_taxable = round(($unit_price + $freight_amount_per_unit -  $discount_per_unit) * $invoice_details['qty'], 2);

            $total_tax = round($total_taxable * $TAX_RATE, 2, PHP_ROUND_HALF_UP);
	
            // if (strtolower($invoice_details['state_name']) == 'telangana') {
                $s_gst = round($total_tax / 2, 2);
                $s_gst = ($s_gst > 0)? $s_gst : 0;
                $cgst_amount = $sgst_amount = $s_gst;

                $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2) + $sgst_amount + $cgst_amount;
            // } else {
            //     $t_gst = ($total_tax > 0)? $total_tax : 0;
            //     $total_amount = $total_taxable + round($exempt_amount_per_unit * $invoice_details['qty'], 2, PHP_ROUND_HALF_UP) + $t_gst;
            // }
            
            //FOR 2 PAISA DIFFERENCE
            //$total_amount = roundUpToAny($total_amount);
            //$total_amount = $total_amount - 0.02; // for 0.98
            //$total_amount = $total_amount + 0.02; // for 0.02
	    
            $total_amount = $total_amount + $DIFFERENCE;
                        
            $txnIncomeTaxTcs = array(
                "incomeTaxTcsValue" => $invoice_details['tcs_percent'], //It is GST TCS Rate like 10 for 10%//
            );

            $net_amount = $invoice_details['total_amount'] + $invoice_details['tcs_amount'] + $invoice_details['freight_amount'] - $invoice_details['discount_amount'];
            $net_amount = round($net_amount, 2);

            if ($discount_amount_excl_tax > 0) {
                $discount_flag = true;
            } else {
                $discount_flag = false;
            }

            if ($marginal_flag == false) {
                $margin_sale_price_per_unit = 0;
                $account_name = "Sale of Goods";
            } else {
                $account_name = "Sale of Goods";
                $marginal_account = "Sale of Goods-Exempt";
            }
            $tcs_amount = round($total_amount * $invoice_details['tcs_percent'] / 100, 2);
            $roundoff_amount = round($net_amount - ($total_amount + $tcs_amount), 2);
            $itemlist[0] = array(
                "saleType" => "Normal",
                "quantity" => $invoice_details['qty'],
                "unitPrice" => strval($unit_price),
                "discount" => strval($discount_per_unit),
                "addDiscount" => 0,
                "freightUnit" => strval($freight_amount_per_unit),
                "deliveryUnit" => 0,
                "taxRateName" => "0%",
                "cess" => 0,
                "addCess" => 0,
                "costCenter" => $cost_center,
                "itcClaim" => 0,
                "amount" => strval(round($total_amount, 2)),
                "total_amount" => strval(round($total_amount, 2)),
                "marginSalePrice" => strval($margin_sale_price_per_unit),
                "marginPurchasePrice" => strval($exempt_amount_per_unit),
                "inventoryType" => "Smartphone",
                "itemCode" => $inv_code,
                "itemName" => $inv_name,
                "description" => null,
                "gstRate" => 0,
                "hsnSac" => "851712",
                "conversionUnitName" => null,
                "type" => "Smartphones",
                "unitName" => "Units",
                "accountName" => $account_name,
                "accountExemptName" => $marginal_account
            );
            $data[] = array(
                "taxType" => "ETAX",
                "currencyCode" => "INR",
                "priceGroupName" => null,
                "companyGstin" =>  '36AASCS2801C1ZI',
                "branch" => "H.O",
                "category" => "SelTrue",
                "countrySupply" => null,
                "invoiceType" => "R",
                "date" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "dueDate" => date("d-m-Y", strtotime($invoice_details['CREATION_DATE'])),
                "contactCode" => $invoice_details['vendor_code'],
                "contactName" => $invoice_details['vendor_name'],
                "customerGstin" => strtoupper($invoice_details['gst_no']),
                "placeSupplyName" => 'Other Territory',
                "Export type" => 'WPYT',  // WPYT=Export With Payment / WOPYT=Export Without Payment
                "billAddress" => $BADR,
                "shipAddress" => $SADR,
                "txnIncomeTaxTcs" => $txnIncomeTaxTcs,
                "warehouseAddress" => null,
                "customerAddress" => null,
                "termCondition" => null,
                "customersNotes" => null,
                "shippingNumber" => null,
                "shippingDate" => null,
                "shippingPortCode" => null,
                "purchaseOrderNumber" => null,
                "purchaseOrderDate" => null,
                "buyerOrderNumber" => null,
                "buyerOrderDate" => null,
                "eWayBillNumber" => null,
                "eWayBillDate" => null,
                "lRNo" => null,
                "otherReference" => null,
                //"vendorCode" => $invoice_details['vendor_code'],
                "vehicleNumber" => null,
                "termsOfPayment" => null,
                "cin" => null,
                "sameAsC" => false,
                "sameAsV" => false,
                "sameAsS" => false,
                "sameAsW" => false,
                "amount" => $net_amount,
                "marginSchemeFlag" => $marginal_flag,
                "roundingAmount" => strval($roundoff_amount),
                "number" => $invoice_details['invoice_code'],
                "flatDiscountFlag" => $discount_flag,
                "roundFlag" => true,
                "lineItems" => $itemlist,
                "typeCode" => "EINV",
                "status" => "INAP",
                "gstnType" => $gstinType,
            );
            $vendor_id = $invoice_details['vendor_id'];
        }
        //echo "<pre>"; print_r($data); echo "</pre>"; exit;

        $HB_vendor_Res = $this->postVendor($vendor_id, true);

        $req_data = array("invoiceList" => $data);
        $post_data = json_encode($req_data, JSON_PRETTY_PRINT);

        $http_header = array(
            'Content-Type:application/json',
            'x-auth-token:' . $this->session->userdata('hostbooks_company_access_token'),
            'x-preserveKey:' . $this->session->userdata('hostbooks_company_preserve_key'),
            'x-company:' . $this->session->userdata('hostbooks_companyUUID'),
        );
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);

        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $error = '';
        if ($result['status'] != 200) {

            foreach ($result['errorList'] as $value) {
                $error .= $value . '<br>';
            }

            foreach ($result['fieldErrors'] as $value) {
                $error .= $value['message'] . '<br>';
            }
            $checkCalculationError = $this->calculateDiff($error);
            //echo $checkCalculationError ; exit;
            
            if(($result['status'] != 400) && $checkCalculationError && $checkCalculationError!== 0 && $checkCalculationError<=1 && $checkCalculationError>=-1){
                $this->createInvoice_forExports($invoice_id, $checkCalculationError);
            }else{
                $insert_arr = array(
                    "invoice_id" => $invoice_id,
                    "invoice_no" => $invoice_details['invoice_code'],
                    "error" => $error
                );
                $this->db->insert('tbl_hostbooks_fail_log', $insert_arr);
            }
            
        }
        // print '<pre>'.$data.'</pre>';
        // var_dump($result);exit;
        
        if ($result['status'] == 200) {
            if ($result['data']['TransactionSuccessfulData']['invoiceListTotalSuccessObjects'] >0) {
                $HB_invoice_codes = $result['data']['TransactionSuccessfulData']['invoiceListSuccess'];

                $this->db->where_in('invoice_code', $HB_invoice_codes)->update('tbl_invoice', ['is_HB_integrated' => 1]);
            }
        }
        
        return [
            'status' => true,
            'message' => isset($msg)? $msg : 'Successful',
            'HB_Vendor_Request' => $HB_vendor_Res['HB_Vendor_Request'],
            'HB_Vendor_Response' => $HB_vendor_Res['HB_Vendor_Response'],
            'HB_Request' => $req_data,
            'HB_Response' => $result
        ];
        
        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong'
        ];
    }
    
    
}
