<?php

class Einvoice extends Admin_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    function postLogin()
    {
        $url = $this->db->select('value')->where('key', 'login_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $username = $this->db->select('value')->where('key', 'username')->get('tbl_hostbooks_einv_det')->row()->value;
        $password = $this->db->select('value')->where('key', 'password')->get('tbl_hostbooks_einv_det')->row()->value;
        $connectorID = $this->db->select('value')->where('key', 'connectorID')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->select('value')->where('key', 'secret_key')->get('tbl_hostbooks_einv_det')->row()->value;
        $data = array(
            'loginId' => $username,
            'password' => $password,
            'conneectorId' => $connectorID,
        );

        $data_string = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Secret-Key: ' . $secret_key
        ));
        //execute
        $result = curl_exec($ch);
        //close connection
        curl_close($ch);
        $result = json_decode($result, true);

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postLogin',
            'request' => $data_string,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            return false;
        }

        $result_arr = $result['hbLoginRes'];

        $update_user_account_no = array(
            "key" => "user_account_no",
            "value" => $result_arr['user_account_no']

        );
        $update_token = array(
            "key" => "token",
            "value" => $result_arr['token']

        );

        //no of rows
        $result = $this->db->where('key', 'user_account_no')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'user_account_no')->update('tbl_hostbooks_einv_det', $update_user_account_no);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_user_account_no);
        }

        $result = $this->db->where('key', 'token')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'token')->update('tbl_hostbooks_einv_det', $update_token);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_token);
        }
        return true;
    }

    public function postAuthenticate()
    {
        $this->postLogin();
        $url = $this->db->select('value')->where('key', 'auth_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $user_account_no = $this->db->where('key', 'user_account_no')->get('tbl_hostbooks_einv_det')->row()->value;
        $Connectorid = $this->db->where('key', 'Connectorid')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'secret_key')->get('tbl_hostbooks_einv_det')->row()->value;

        $data = array(
            'user_account_no' => $user_account_no,
            'Connectorid' => $Connectorid
        );

        $data_string = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Secret-Key: ' . $secret_key
        ));
        //execute
        $result = curl_exec($ch);
        //close connection
        curl_close($ch);
        $result = json_decode($result, true);

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postAuthenticate',
            'request' => $data_string,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            return false;
        }

        $update_hb_auth_token = array(
            "key" => "hb_auth_token",
            "value" => "Bearer " . $result['hbToken'],
        );
        //hbsecretkey
        $update_hb_secret_key = array(
            "key" => "hbsecretkey_auth",
            "value" => $result['hbsecretkey'],
        );

        //expires
        $update_expires = array(
            "key" => "auth_expires",
            "value" => $result['expires'],
        );

        //no of rows
        $result = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'hb_auth_token')->update('tbl_hostbooks_einv_det', $update_hb_auth_token);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_hb_auth_token);
        }

        $result = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'hbsecretkey_auth')->update('tbl_hostbooks_einv_det', $update_hb_secret_key);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_hb_secret_key);
        }

        $result = $this->db->where('key', 'auth_expires')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'auth_expires')->update('tbl_hostbooks_einv_det', $update_expires);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_expires);
        }
        return true;
    }

    public function getAuthToken()
    {
        $this->postAuthenticate();
        $gstin = $this->db->where('key', 'gstin')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->row()->value;
        $hbtoken = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->row()->value;
        $url = $this->db->select('value')->where('key', 'auth_token_url')->get('tbl_hostbooks_einv_det')->row()->value;

        //start curl
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Secret-Key: ' . $secret_key,
            'Authorization: ' . $hbtoken
        ));
        //execute
        $result = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($result, true);
        
        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'getAuthenticate',
            'request' => $url,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            return false;
        }

        $update_hb_auth_token = array(
            "key" => "hb_auth_token_get",
            "value" => "Bearer " . $result['respObj']['eInvApiLoginDetails']['authToken'],
        );

        //e_InvoiceTokenExp
        $update_e_InvoiceTokenExp = array(
            "key" => "e_InvoiceTokenExp",
            "value" => $result['respObj']['eInvApiLoginDetails']['e_InvoiceTokenExp'],
        );

        //no of rows
        $result = $this->db->where('key', 'hb_auth_token_get')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'hb_auth_token_get')->update('tbl_hostbooks_einv_det', $update_hb_auth_token);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_hb_auth_token);
        }

        $result = $this->db->where('key', 'e_InvoiceTokenExp')->get('tbl_hostbooks_einv_det')->num_rows();
        if ($result > 0) {
            $this->db->where('key', 'e_InvoiceTokenExp')->update('tbl_hostbooks_einv_det', $update_e_InvoiceTokenExp);
        } else {
            $this->db->insert('tbl_hostbooks_einv_det', $update_e_InvoiceTokenExp);
        }
        return true;
    }

    public function postEinvoice($invoice_id)
    {
        $rs = $this->db->from('tbl_invoice')->where('invoice_id', $invoice_id)->get()->row();
        if (empty($rs)) {
            $msg = 'Invalid Invoice ID';
            GOTO ERROR;
        }
        if ($rs->sales_channel == 'NON_PRODUCT') {
            return $this->postEinvoice_for_NonProduct($invoice_id);
        }

        $this->getAuthToken();
        $url = $this->db->select('value')->where('key', 'generate_irn_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $gstin = $this->db->where('key', 'gstin')->get('tbl_hostbooks_einv_det')->row()->value;
        $company_name = $this->db->where('key', 'company_name')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_address = $this->db->where('key', 'company_address')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_loc = $this->db->where('key', 'company_loc')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_pin = $this->db->where('key', 'company_pin')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_st_code = $this->db->where('key', 'company_st_code')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->row()->value;
        $hbtoken = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->row()->value;

        //TranDtls
        $TranDtls = array(
            "TaxSch" => "GST",
            "SupTyp" => "B2B"
        );

        $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->row();

        $DocDtls = array(
            "Typ" => "INV",
            "No" => $invoice_data->invoice_code,
            "Dt" =>  date("d/m/Y", strtotime($invoice_data->CREATION_DATE))
        );

        //Seller Details
        $SellerDtls = array(
            "Gstin" => $gstin,
            "LglNm" => $company_name,
            "Addr1" => $slr_address,
            "Loc" => $slr_loc,
            "Pin" => $slr_pin,
            "Stcd" => $slr_st_code
        );

        //Dispatch Details 

        $DispatchDtls = array(
            "Nm" => $company_name,
            "Addr1" => $slr_address,
            "Loc" => $slr_loc,
            "Pin" => $slr_pin,
            "Stcd" => $slr_st_code

        );

        //Buyer Details
        //ADDED STRTOUPPPER to minimize GSTNO Errors
        $BuyerDtls = array(
            "Gstin" => strtoupper($invoice_data->gst_no),
            "LglNm" => $invoice_data->vendor_name,
            "Addr1" => $invoice_data->address,
            "Loc" => $invoice_data->city,
            "Pin" => $invoice_data->pincode,
            "Stcd" => explode("-", $invoice_data->location)[0],
            "Pos" => explode("-", $invoice_data->location)[0]
        );

        if ($invoice_data->location == "Other") {
            $BuyerDtls['Stcd'] = $invoice_data->other_location;
        }

        $openbox_cat = OPENBOX_CATEGORY;
        $new_cat = NEW_CATEGORY;

        if (in_array($invoice_data->category, $openbox_cat)) {
            $prod_desc = 'Open Box-Smartphone';
        }else if(in_array($invoice_data->category, $new_cat)){
            $prod_desc = 'New-Smartphone';
        }else {
            $prod_desc = 'Pre-Owned-Smartphone';
        }

        $taxable_amount = 0;
        $quantity = $invoice_data->qty;
        $freight_amount = $invoice_data->freight_amount;
        $discount_amount = $invoice_data->discount_amount;
        $total_tax = 0;

        if (empty($freight_amount)) {
            $freight_amount = 0;
        }
        if (empty($discount_amount)) {
            $discount_amount = 0;
        }

        if ($invoice_data->exempt_amount == 0) {
            $taxable_amount = $invoice_data->total_amount / 1.18;
        } else {
            $taxable_amount = ($invoice_data->total_amount - $invoice_data->exempt_amount) / 1.18;
        }

        //Per Unit
        $taxable_per_unit = round($taxable_amount / $quantity, 2);
        $freight_amount_per_unit_incl_tax = $freight_amount / $invoice_data->qty;
        $discount_amount_per_unit_incl_tax = $discount_amount /  $invoice_data->qty;

        $freight_amount_per_unit_excl_tax = $freight_amount_per_unit_incl_tax / 1.18;
        $discount_amount_per_unit_excl_tax = $discount_amount_per_unit_incl_tax / 1.18;

        $unit_price = round($taxable_per_unit + $freight_amount_per_unit_excl_tax,2);
        $TotAmt = round(($unit_price) * $quantity, 2);

        $total_taxable_amount = round($TotAmt - $discount_amount_per_unit_excl_tax, 2);

        $total_tax = round($total_taxable_amount * 0.18, 2);

        if (explode("-", $invoice_data->location)[0] == $slr_st_code) {
            $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
            $igst_amount = 0;
        } else {
            $sgst_amount = 0;
            $cgst_amount = 0;
            $igst_amount  = $total_tax;
        }

        $net_amount = $total_taxable_amount + $cgst_amount + $sgst_amount + $igst_amount;
        $net_amount = round($net_amount, 2, PHP_ROUND_HALF_UP);


        //ItemList
        $itemList = array(
            "SlNo" => 1,
            "PrdDesc" => $prod_desc,
            "IsServc" => "N",
            "HSNCd" => "851712",
            "Qty" => $invoice_data->qty,
            "Unit" => "UNT",
            "FreeQty" => 0,
            "UnitPrice" => $unit_price,
            "TotAmt" => $TotAmt,
            "Discount" => round($discount_amount_per_unit_excl_tax,2),
            "AssAmt" => $total_taxable_amount,
            "GstRt" => 18,
            "IgstAmt" => $igst_amount,
            "CgstAmt" => $cgst_amount,
            "SgstAmt" => $sgst_amount,
            "TotItemVal" => $net_amount,
        );

        $ValDtls = array(
            "AssVal" => $total_taxable_amount,
            "CgstVal" => $cgst_amount,
            "SgstVal" => $sgst_amount,
            "IgstVal" => $igst_amount,
            "TotInvVal" => $net_amount,
        );

        //Start JSON data
        $data = array(
            "version" => "1.1",
            "TranDtls" => $TranDtls,
            "DocDtls" => $DocDtls,
            "SellerDtls" => $SellerDtls,
            "BuyerDtls" => $BuyerDtls,
            "DispDtls" => $DispatchDtls,
            "ShipDtls" => $BuyerDtls,
            "itemList" => [$itemList],
            "ValDtls" => $ValDtls
        );

        $Einvoice['Request'] = $data;

        $data_string = json_encode($data, JSON_PRETTY_PRINT);
        //curl init
        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Secret-Key: ' . $secret_key,
                'Authorization: ' . $hbtoken
            )
        );
        $result = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($result, true);
        $Einvoice['Response'] = $result;

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postEinvoice',
            'request' => $data_string,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'invoice_id' => $invoice_id,
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            GOTO ERROR;
        }

        $irn = $result['respObj']['irn'];
        $signedQRCode = $result['respObj']['signedQRCode'];

        $arr = array(
            'irn' => $irn,
            'qr_code' => $signedQRCode,
            'irn_status' => $result['respObj']['status'],
        );

        $this->db->where('invoice_id', $invoice_id)->update('tbl_invoice', $arr);
        
        return [
            'status' => true,
            'message' => 'E-Invoice created successfully',
            'Einvoice' => $Einvoice
        ];

        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong',
            'Einvoice' => $Einvoice
        ];
    }

    public function postCancelIRN($invoice_id)
    {
        $irn = $this->db->select('irn')->where('invoice_id',$invoice_id)->get('tbl_invoice')->row()->irn;

        if(empty($irn)){
            return false;
        }

        $url = $this->db->select('value')->where('key','cancel_irn_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->row()->value;
        $hbtoken = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->row()->value;

        $data = array(
            "irn" => $irn,
            "CnlRsn" => 3,
            "CnlRem" => "Order was Cancelled"
        );

        $data_string = json_encode($data);

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Secret-Key: ' . $secret_key,
                'Authorization: ' . $hbtoken
            )
        );

        $result = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($result, true);

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postCancelIRN',
            'request' => $data_string,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'invoice_id' => $invoice_id,
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            return false;
        }

        $this->db->where('invoice_id', $invoice_id)->update('tbl_invoice', array('irn_status' => 'CNL'));

        return true;
    }
    
    public function postEinvoice_for_NonProduct($invoice_id)
    {
        $this->getAuthToken();
        $url = $this->db->select('value')->where('key', 'generate_irn_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $gstin = $this->db->where('key', 'gstin')->get('tbl_hostbooks_einv_det')->row()->value;
        $company_name = $this->db->where('key', 'company_name')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_address = $this->db->where('key', 'company_address')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_loc = $this->db->where('key', 'company_loc')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_pin = $this->db->where('key', 'company_pin')->get('tbl_hostbooks_einv_det')->row()->value;
        $slr_st_code = $this->db->where('key', 'company_st_code')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->row()->value;
        $hbtoken = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->row()->value;

        //TranDtls
        $TranDtls = array(
            "TaxSch" => "GST",
            "SupTyp" => "B2B"
        );

        $invoice_data = $this->db->where('invoice_id', $invoice_id)->get('NON_PRODUCT_INVOICE_EXPORT_REPORT_VIEW')->row();

        $DocDtls = array(
            "Typ" => "INV",
            "No" => $invoice_data->invoice_code,
            "Dt" =>  date("d/m/Y", strtotime($invoice_data->CREATION_DATE))
        );

        //Seller Details
        $SellerDtls = array(
            "Gstin" => $gstin,
            "LglNm" => $company_name,
            "Addr1" => $slr_address,
            "Loc" => $slr_loc,
            "Pin" => $slr_pin,
            "Stcd" => $slr_st_code
        );

        //Dispatch Details 

        $DispatchDtls = array(
            "Nm" => $company_name,
            "Addr1" => $slr_address,
            "Loc" => $slr_loc,
            "Pin" => $slr_pin,
            "Stcd" => $slr_st_code

        );

        //Buyer Details
        //ADDED STRTOUPPPER to minimize GSTNO Errors
        $BuyerDtls = array(
            "Gstin" => strtoupper($invoice_data->gst_no),
            "LglNm" => $invoice_data->vendor_name,
            "Addr1" => $invoice_data->address,
            "Loc" => $invoice_data->city,
            "Pin" => $invoice_data->pincode,
            "Stcd" => explode("-", $invoice_data->location)[0],
            "Pos" => explode("-", $invoice_data->location)[0]
        );

        if ($invoice_data->location == "Other") {
            $BuyerDtls['Stcd'] = $invoice_data->other_location;
        }

        // $openbox_cat = OPENBOX_CATEGORY;
        // $new_cat = NEW_CATEGORY;

        // if (in_array($invoice_data->category, $openbox_cat)) {
        //     $prod_desc = 'Open Box-Smartphone';
        // }else if(in_array($invoice_data->category, $new_cat)){
        //     $prod_desc = 'New-Smartphone';
        // }else {
        //     $prod_desc = 'Pre-Owned-Smartphone';
        // }
        $prod_desc = 'Non-Product';

        $hsn_code = $invoice_data->hsn_code;
        $gst_rate = $invoice_data->tax_rate;
        if (count(explode(',', $gst_rate)) > 1) {
            $msg = 'Multiple Tax Rates present in same Invoice: '. $invoice_data['invoice_code'];
            GOTO ERROR;
        }
        if (count(explode(',', $hsn_code)) > 1) {
            $msg = 'Multiple HSN Codes present in same Invoice: '. $invoice_data['invoice_code'];
            GOTO ERROR;
        }
        $TAX_RATE = round(((float) $gst_rate) / 100, 2);
        $TAXABLE_RATE = 1 + $TAX_RATE;

        $taxable_amount = 0;
        $quantity = $invoice_data->qty;
        $freight_amount = $invoice_data->freight_amount;
        $discount_amount = $invoice_data->discount_amount;
        $total_tax = 0;

        if (empty($freight_amount)) {
            $freight_amount = 0;
        }
        if (empty($discount_amount)) {
            $discount_amount = 0;
        }

        if ($invoice_data->exempt_amount == 0) {
            $taxable_amount = $invoice_data->total_amount / $TAXABLE_RATE;
        } else {
            $taxable_amount = ($invoice_data->total_amount - $invoice_data->exempt_amount) / $TAXABLE_RATE;
        }

        //Per Unit
        $taxable_per_unit = round($taxable_amount / $quantity, 2);
        $freight_amount_per_unit_incl_tax = $freight_amount / $invoice_data->qty;
        $discount_amount_per_unit_incl_tax = $discount_amount /  $invoice_data->qty;

        $freight_amount_per_unit_excl_tax = $freight_amount_per_unit_incl_tax / $TAXABLE_RATE;
        $discount_amount_per_unit_excl_tax = $discount_amount_per_unit_incl_tax / $TAXABLE_RATE;

        $unit_price = round($taxable_per_unit + $freight_amount_per_unit_excl_tax,2);
        $TotAmt = round(($unit_price) * $quantity, 2);

        $total_taxable_amount = round($TotAmt - $discount_amount_per_unit_excl_tax, 2);

        $total_tax = round($total_taxable_amount * $TAX_RATE, 2);

        if (explode("-", $invoice_data->location)[0] == $slr_st_code) {
            $cgst_amount = $sgst_amount = round($total_tax / 2, 2);
            $igst_amount = 0;
        } else {
            $sgst_amount = 0;
            $cgst_amount = 0;
            $igst_amount  = $total_tax;
        }

        $net_amount = $total_taxable_amount + $cgst_amount + $sgst_amount + $igst_amount;
        $net_amount = round($net_amount, 2, PHP_ROUND_HALF_UP);


        //ItemList
        $itemList = array(
            "SlNo" => 1,
            "PrdDesc" => $prod_desc,
            "IsServc" => "N",
            "HSNCd" => $hsn_code,
            "Qty" => $invoice_data->qty,
            "Unit" => "UNT",
            "FreeQty" => 0,
            "UnitPrice" => $unit_price,
            "TotAmt" => $TotAmt,
            "Discount" => round($discount_amount_per_unit_excl_tax,2),
            "AssAmt" => $total_taxable_amount,
            "GstRt" => $gst_rate,
            "IgstAmt" => $igst_amount,
            "CgstAmt" => $cgst_amount,
            "SgstAmt" => $sgst_amount,
            "TotItemVal" => $net_amount,
        );

        $ValDtls = array(
            "AssVal" => $total_taxable_amount,
            "CgstVal" => $cgst_amount,
            "SgstVal" => $sgst_amount,
            "IgstVal" => $igst_amount,
            "TotInvVal" => $net_amount,
        );

        //Start JSON data
        $data = array(
            "version" => "1.1",
            "TranDtls" => $TranDtls,
            "DocDtls" => $DocDtls,
            "SellerDtls" => $SellerDtls,
            "BuyerDtls" => $BuyerDtls,
            "DispDtls" => $DispatchDtls,
            "ShipDtls" => $BuyerDtls,
            "itemList" => [$itemList],
            "ValDtls" => $ValDtls
        );

        $Einvoice['Request'] = $data;

        $data_string = json_encode($data, JSON_PRETTY_PRINT);
        //curl init
        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Secret-Key: ' . $secret_key,
                'Authorization: ' . $hbtoken
            )
        );
        $result = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($result, true);
        $Einvoice['Response'] = $result;

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postEinvoice',
            'request' => $data_string,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'invoice_id' => $invoice_id,
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            GOTO ERROR;
        }

        $irn = $result['respObj']['irn'];
        $signedQRCode = $result['respObj']['signedQRCode'];

        $arr = array(
            'irn' => $irn,
            'qr_code' => $signedQRCode,
            'irn_status' => $result['respObj']['status'],
        );

        $this->db->where('invoice_id', $invoice_id)->update('tbl_invoice', $arr);

        return [
            'status' => true,
            'message' => 'E-Invoice created successfully',
            'Einvoice' => $Einvoice
        ];
        
        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong',
            'Einvoice' => $Einvoice
        ];
    }

    public function getIRNDetails($invoice_id){
        
        if(empty($invoice_id)){
            return false;
        }

        $irn = $this->db->select('irn')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row()->irn;

        $this->getAuthToken();
        
        $url = $this->db->select('value')->where('key','get_irn_details_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->row()->value;
        $hbtoken = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->row()->value;

        $invoice_id = $this->db->where('irn', $irn)->get('tbl_invoice')->row()->invoice_id;

        $url = $url ."?irn=". $irn;

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Secret-Key: ' . $secret_key,
                'Authorization: ' . $hbtoken
            )
        );

        $result = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($result, true);

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postGetIRNDetails',
            'request' => $url,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'invoice_id' => $invoice_id,
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            return false;
        }

        return true;
    }

    public function postGetIrnByInv($invoice_id)
    {
        if($invoice_id <=0){
            return false;
        }
        $inv_det = $this->db->select('invoice_code, CREATION_DATE')->where('invoice_id',$invoice_id)->get('tbl_invoice')->row();

        if(empty($inv_det)){
            return false;
        }

        $url = $this->db->select('value')->where('key','get_irn_by_inv_url')->get('tbl_hostbooks_einv_det')->row()->value;
        $secret_key = $this->db->where('key', 'hbsecretkey_auth')->get('tbl_hostbooks_einv_det')->row()->value;
        $hbtoken = $this->db->where('key', 'hb_auth_token')->get('tbl_hostbooks_einv_det')->row()->value;

        $data = array(
            "doctype" => "INV",
            "docnum" => $inv_det->invoice_code,
            "docdate" => date("d/m/Y", strtotime($inv_det->CREATION_DATE))
        );

        $data_string = json_encode($data);

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Secret-Key: ' . $secret_key,
                'Authorization: ' . $hbtoken
            )
        );

        $result = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($result, true);

        $insert_arr = array(
            'user_id' => $this->session->userdata('user_id'),
            'api' => 'postGetIrnByInv',
            'request' => $data_string,
            'response' => json_encode($result),
            'status' => $result['isSuccess'],
            'invoice_id' => $invoice_id,
            'updated_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('tbl_einv_log', $insert_arr);

        if ($result['isSuccess'] == false) {
            return false;
        }
        return true;
    }
   
}
