<?php

class Cliq_api extends Admin_Model
{
    
    private $ENV = 'DEVELOPMENT';
    public function getAccessToken($data = array())
    {
        //$refresh_token = $this->db->select('value')->where('config_key', 'cliq_refresh_token')->get('tbl_config')->row()->value;

        $url = "https://accounts.zoho.com/oauth/v2/token";

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result1 = curl_exec($ch);

        $result = json_decode($result1, TRUE);
        curl_close($ch);

        $access_token = $result['access_token'];

        $access_token_array = array(
            "value" => $access_token
        );

        $access_expire_array = array(
            "value" => mktime() + 3000
        );

        if(!empty($access_token)){
            $this->db->where('config_key', "cliq_access_token")->update('tbl_config', $access_token_array);
            $this->db->where('config_key', "cliq_access_expire")->update('tbl_config', $access_expire_array);
        }


        return true;
    }

    public function postMessage()
    {
        return true;
    }

    public function postImage($path = '', $filename = '', $post_type = '')
    {
        //return true;
        if (empty($path)) {
            return true;
        }
        if(empty($post_type)){
            return true;
        }
        
        $channel_name = $this->db->select('value')->where('config_key', $post_type)->get('tbl_config')->row()->value;
        
        $scope = "ZohoCliq.Webhooks.CREATE,ZohoCliq.Channels.CREATE,ZohoCliq.Channels.READ,ZohoCliq.Channels.UPDATE,ZohoCliq.Channels.DELETE";
        //	callback URL specified when the application was defined--has to match what the application says
       // $callback_uri = "https://erp.sloyd.in/admin/Cliq/accessRefreshToken";
       $callback_uri = "http://localhost/erp/admin/cliq/accessRefreshToken";

        $refresh_token = $this->db->select('value')->where('config_key', 'cliq_refresh_token')->get('tbl_config')->row()->value;
        $cliq_access_expire = $this->db->select('value')->where('config_key', 'cliq_access_expire')->get('tbl_config')->row()->value;

        $client_id = $this->db->select('value')->where('config_key', 'cliq_client_id')->get('tbl_config')->row()->value;
        $client_secret = $this->db->select('value')->where('config_key', 'cliq_client_secret')->get('tbl_config')->row()->value;

        $current_time = mktime();
        $interval = $current_time - $cliq_access_expire;
        if ($interval > 0) {
            //print $interval;exit;

            $data = array(
                "refresh_token" => $refresh_token,
                "client_id" => $client_id,
                "client_secret" => $client_secret,
                "grant_type" => "refresh_token",
                "redirect_uri" => $callback_uri,
                "scope" => $scope
            );
            $this->getAccessToken($data);
        }
        $access_token = $this->db->select('value')->where('config_key', 'cliq_access_token')->get('tbl_config')->row()->value;

        $url = "https://cliq.zoho.com/api/v2/channelsbyname/".$channel_name."/files?bot_unique_name=sloydbot";

        $cfile = new CURLFile($path, "png", $filename . ".png");

        $http_header = array(
            "Authorization: Zoho-oauthtoken " . $access_token,
            //"Content-Type: application/json",
            "Content-Disposition: form-data",
        );
        $param = array(
            "file" => $cfile
        );
        //$text_msg = ["text" => "test"];
        $ch = curl_init($url);
        // $data = json_encode($text_msg);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result1 = curl_exec($ch);
        // var_dump($result1);exit;
        curl_close($ch);
        return true;
    }

    public function postSalesImage($salesorder_id = 0)
    {
        //return true;
        if ((int)$salesorder_id <= 0) {
            return true;
        }
        $order_dets = $this->db->where('salesorder_id', $salesorder_id)->get('SALESORDER_RFS_LIST_VIEW')->row();

        if ($order_dets->sales_channel == 'OFFLINE') {
            $post_type = 'cliq_salesorder_group';
        } else if ($order_dets->sales_channel == 'EXPORT') {
            $post_type = 'cliq_salesorder_export';
        } else {
            $post_type = 'cliq_salesorder_group_online';
        }

        // Create the image
        $img = imagecreatetruecolor(600, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 599, 399, $white);

        if ($order_dets->status == 'FINANCE_PENDING') {
            // The text to draw
            $where_remark = array(
                "reference_id" => $salesorder_id,
                "reference_type" => "salesorder"
            );
            $remark = $this->db->select('remark')->where($where_remark)->order_by('remarks_id', 'ASC')->get('tbl_remark')->row()->remark;
            $lines[] = 'S.O Created By    : ' . strtoupper($order_dets->CREATED_BY);
            $lines[] = 'Sales Executive   : ' . strtoupper($order_dets->fullname);
            $lines[] = 'S.O No            : ' . $order_dets->salesorder_code;
            $lines[] = 'Vendor Name       : ' . strtoupper($order_dets->vendor_name);
            $lines[] = 'Vendor Code       : ' . $order_dets->vendor_code;
            $lines[] = 'Sales Channel     : ' . $order_dets->sales_channel;
            $lines[] = 'Category          : ' . $order_dets->category;
            $lines[] = 'Quantity          : ' . $order_dets->quantity;
            $lines[] = 'S.O Amount        : ' . $order_dets->amount;
            $lines[] = 'Freight Amount    : ' . $order_dets->freight_amount;
            $lines[] = 'Discount Amount   : ' . $order_dets->discount_amount;
            $lines[] = 'TCS Amount        : ' . $order_dets->tcs_amount;
            $lines[] = 'Net Amount        : ' . $order_dets->net_invoice_amount;
            $lines[] = 'Payment Mode      : ' . strtoupper($order_dets->payment_mode);
            $lines[] = 'Remarks           : ' . $remark;
            $lines[] = 'Dear Sir, Please Approve this S.O';
        } else if ($order_dets->status == 'INVOICED') {
            $invoice_no = $this->db->select('invoice_code')->where('salesorder_id', $salesorder_id)->get('tbl_invoice')->row()->invoice_code;
            $lines[] = 'S.O No            : ' . $order_dets->salesorder_code;
            $lines[] = 'Invoice No        : ' . $invoice_no;
            $lines[] = 'Vendor Name       : ' . strtoupper($order_dets->vendor_name);
            $lines[] = 'Vendor Code       : ' . $order_dets->vendor_code;
            $lines[] = 'Category          : ' . $order_dets->category;
            $lines[] = 'Quantity          : ' . $order_dets->quantity;
            $lines[] = 'status            : ' . str_replace('_', ' ', $order_dets->status);
            $lines[] = 'S.O Amount        : ' . $order_dets->amount;
            $lines[] = 'Freight Amount    : ' . $order_dets->freight_amount;
            $lines[] = 'Discount Amount   : ' . $order_dets->discount_amount;
            $lines[] = 'TCS Amount        : ' . $order_dets->tcs_amount;
            $lines[] = 'Net Amount        : ' . $order_dets->net_invoice_amount;
        } else {
            $lines[] = 'S.O No            : ' . $order_dets->salesorder_code;
            $lines[] = 'Vendor Name       : ' . strtoupper(wordwrap($order_dets->vendor_name, 10, "\n"));
            $lines[] = 'Vendor Code       : ' . $order_dets->vendor_code;
            $lines[] = 'Sales Channel     : ' . $order_dets->sales_channel;
            $lines[] = 'Category          : ' . $order_dets->category;
            $lines[] = 'Quantity          : ' . $order_dets->quantity;
            $lines[] = 'status            : ' . str_replace('_', ' ', $order_dets->status);
            $lines[] = 'Net Amount        : ' . $order_dets->net_invoice_amount;
        }

        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 570, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);
            $y += 25;
            imageline($img, $x, $y - 5, 570, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 570, 20, 570, $y - 5, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/sales.png");
        $this->postImage("./uploads/sales.png", "sales", $post_type);
        return true;
    }

    public function postStocktransferImage($stocktransfer_id = 0)
    {
        //return true;
        if ((int)$stocktransfer_id <= 0) {
            return true;
        }
        $order_dets = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('STOCKTRANSFER_NOTE_LIST_VIEW')->row();

        // Create the image
        $img = imagecreatetruecolor(500, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 499, 399, $white);

        $lines[] = 'STN Created By     : ' . strtoupper($order_dets->CREATED_BY);
        $lines[] = 'Stocktransfer Type : ' . strtoupper($order_dets->st_type);
        $lines[] = 'Stocktransfer No   : ' . strtoupper($order_dets->stocktransfer_no);
        $lines[] = 'To Location        : ' . $order_dets->to_loc;
        $lines[] = 'Tracking ID        : ' . $order_dets->tracking_id;
        $lines[] = 'Tracking Name      : ' . $order_dets->tracking_name;
        $lines[] = 'Stocktransfer Date : ' . date("d-m-Y", strtotime($order_dets->stocktransfer_date));
        $lines[] = 'Category           : ' . $order_dets->stock_type;
        $lines[] = 'Quantity           : ' . $order_dets->total_quantity;
        $lines[] = 'Status             : ' . $order_dets->status;

        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 470, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);
            $y += 25;
            imageline($img, $x, $y - 5, 470, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 470, 20, 470, $y - 5, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/stn.png");
        imagedestroy($img);
        $this->postImage("./uploads/stn.png", "stn", 'cliq_stocktransfer_group');
        return true;
    }

    public function postModelMismtachImage($model_mismatch_id = 0)
    {
        //return true;
        if ((int)$model_mismatch_id <= 0) {
            return true;
        }
        $order_dets = $this->db->where('model_mismatch_id', $model_mismatch_id)->get('MODEL_MISMATCH_LIST_VIEW')->row();

        // Create the image
        $img = imagecreatetruecolor(500, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 499, 399, $white);

        $lines[] = 'Created By         : ' . strtoupper($order_dets->created_by);
        $lines[] = 'Mismatch Type      : ' . strtoupper($order_dets->mismatch_type);
        $lines[] = 'Device ID          : ' . strtoupper($order_dets->device_id);
        $lines[] = 'Expected Model     : ' . $order_dets->expected_device_name;
        $lines[] = 'Received Model     : ' . $order_dets->received_device_name;
        $lines[] = 'Received Variant   : ' . $order_dets->received_ram.' - '.$order_dets->received_rom;
        $lines[] = 'Status             : ' . $order_dets->status;

        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 470, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);
            $y += 25;
            imageline($img, $x, $y - 5, 470, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 470, 20, 470, $y - 5, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/mm.png");
        imagedestroy($img);
        $this->postImage("./uploads/mm.png", "mm", 'model_mismatch_group');
        return true;
    }

    public function postCertificationImage($stockTypeArr = [], $action_type = '')
    {
        //return true;
        if (empty($stockTypeArr)) {
            return true;
        }
        // Create the image
        $img = imagecreatetruecolor(500, 400);

        // Create some colors
        $red = imagecolorallocate($img, 255, 0, 0);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 499, 399, $white);

        if($action_type === 'ASSIGN'){
            $lines[] = 'Devices Assigned For Certification';
        }
        
        if($action_type === 'SUBMIT'){
            $lines[] = 'Devices Submitted to WH from Cert.';
        }

        $lines[] = 'Created By         : ' . strtoupper($this->session->userdata('user_name'));
        $lines[] = 'Date               : ' . date("d-m-Y h:i A");
        
        $total_deivces = 0;
        foreach($stockTypeArr as $key => $count){
            $lines[] = str_pad($key,19," ").': ' . $count;
            $total_deivces += $count;
        }
        $lines[] = 'Total Devices      : ' . $total_deivces;

        $x = 30;
        $y = 20;
        
        imageline($img, $x, $y, 470, $y, $black);
        
        foreach ($lines as $key => $line) {
            if($key === 0){
                imagestring($img, 5, $x + 5, $y, $line, $red);
            }else{
                imagestring($img, 5, $x + 5, $y, $line, $black);
            }
            
            $y += 25;
            imageline($img, $x, $y - 5, 470, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 10, $blue);
        imageline($img, 470, 20, 470, $y - 10, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/cp.png");
        imagedestroy($img);
        $this->postImage("./uploads/cp.png", "mm", 'cliq_test');
        return true;
    }

    
    public function create_Dashboard_Certf_Image($data) {
        // Create the image
        $img = imagecreatetruecolor(600, 250);


        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        
        imagefilledrectangle($img, 0, 0, 599, 399, $white);

        $header = imagecolorallocate($img, 159, 197, 212);
        $footer = imagecolorallocate($img, 95, 158, 160);


        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 570, $y, $blue);

        
        foreach ($data as $k => $v) {
            if ($k == 0) {
                imagefilledrectangle($img, $x, $y, 570, $y+20, $header);
            } else if ($v['0'] == 'Total') {
                imagefilledrectangle($img, $x, $y, 570, $y+20, $footer);
            }

            imagestring($img, 5, $x + 5, $y, $v['0'], $black);
            imagestring($img, 5, $x + 250, $y, $v['1'], $black);
            imagestring($img, 5, $x + 350, $y, $v['2'], $black);
            imagestring($img, 5, $x + 450, $y, $v['3'], $black);
            $y += 25;
            imageline($img, $x, $y - 5, 570, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 570, 20, 570, $y - 5, $blue);

        imagesetthickness($img, 10);
        
        $img_locn = '/uploads/dashboard_stats/dashboard_stats_certification'. date('YmdHis') .'.png';
        imagepng($img, '.'.$img_locn);

        return [
            'status' => true,
            'img_locn' => $img_locn
        ];

    }
    
    public function send_Image_to_CliqBot($img_locn, $img_about) {
        $img_locn = '.'. $img_locn;

        $this->postImage($img_locn, $img_about, 'cliq_dev_testing');
        unlink($img_locn);
    }

    public function postOfflineStocktransferImage($order_dets)
    {
        //return true;
        if (empty($order_dets)) {
            return true;
        }
        // Create the image
        $img = imagecreatetruecolor(500, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 499, 399, $white);
        if($order_dets['status'] == "INVOICED" || $order_dets['status'] == "PACKED"){
            $lines[] = 'STN No              : ' . strtoupper($order_dets['invoice_no']);
            $lines[] = 'STN Approved By     : ' . strtoupper($order_dets['created_user']);
        } else if($order_dets['status'] == "DISPATCHED"){
            $lines[] = 'STN No          : ' . strtoupper($order_dets['invoice_no']);
            $lines[] = 'Gate Pass No        : ' . strtoupper($order_dets['gate_pass_no']);
            $lines[] = 'E- MORN No          : ' . strtoupper($order_dets['morn_no']);
            $lines[] = 'STN Dispatched By   : ' . strtoupper($order_dets['created_user']);
        } else{
            $lines[] = 'STO Created By      : ' . strtoupper($order_dets['created_user']);
        }
        
        $lines[] = 'Stocktransfer No        : ' . strtoupper($order_dets['stn_no']);
        $lines[] = 'From Location           : ' . $order_dets['from_loc'];
        $lines[] = 'To Location             : ' . $order_dets['to_loc'];
        $lines[] = 'Stocktransfer Date      : ' . date("d-m-Y", strtotime($order_dets['stn_date']));
        $lines[] = 'Category                : ' . $order_dets['category'];
        $lines[] = 'Quantity                : ' . $order_dets['total_qty'];
        $lines[] = 'Status                  : ' . $order_dets['status'];
        
        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 470, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);
            $y += 25;
            imageline($img, $x, $y - 5, 470, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 470, 20, 470, $y - 5, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/stn.png");
        imagedestroy($img);
        $this->postImage("./uploads/stn.png", "stn", 'cliq_offline_stock_transfer_group');
        return true;
    }
    public function postOfflineStockinwardImage($order_dets)
    {
        //return true;
        if (empty($order_dets)) {
            return true;
        }
        // Create the image
        $img = imagecreatetruecolor(500, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 499, 399, $white);
        if($order_dets['status'] == "FINANCE_PENDING"){
            
            $lines[] = 'STN Inward By           : ' . strtoupper($order_dets['created_user']);
        } else{
            $lines[] = 'Inward Updated By   : ' . strtoupper($order_dets['created_user']);
        }
        $lines[] = 'MRN No                  : ' . strtoupper($order_dets['mrn_no']);
        $lines[] = 'Stocktransfer No        : ' . strtoupper($order_dets['stn_no']);
        $lines[] = 'From Location           : ' . $order_dets['from_loc'];
        $lines[] = 'To Location             : ' . $order_dets['to_loc'];
        $lines[] = 'Category                : ' . $order_dets['category'];
        $lines[] = 'Quantity                : ' . $order_dets['total_qty'];
        $lines[] = 'Status                  : ' . str_replace('_', ' ', $order_dets['status']);
        
        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 470, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);
            $y += 25;
            imageline($img, $x, $y - 5, 470, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 470, 20, 470, $y - 5, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/stn.png");
        imagedestroy($img);
        $this->postImage("./uploads/stn.png", "stn", 'cliq_offline_stock_transfer_group');
        return true;
    }
	
    public function postSalesMarginImage($salesorder_id = 0, $total_purchase_cost = 0)
    {
        //return true;
        if ((int)$salesorder_id <= 0) {
            return true;
        }
        $order_dets = $this->db->where('salesorder_id', $salesorder_id)->get('SALESORDER_RFS_LIST_VIEW')->row();
        $post_type = 'cliq_salesorder_margins_offline';
    
	$so_date = date("d-m-Y", strtotime($order_dets->CREATION_DATE));
        $so_amount = $order_dets->amount;
        $discount_amount = $order_dets->discount_amount;
        $actual_so_amount = $so_amount - $discount_amount;
        $margin = $actual_so_amount - $total_purchase_cost;
        $margin = number_format((float)$margin, 2, '.', '');
        $margin_percent = ($margin / $total_purchase_cost) * 100;
	$margin_percent = number_format((float)$margin_percent, 2, '.', '');
        
        // Create the image
        $img = imagecreatetruecolor(600, 400);

        // Create some colors
        $lightsky = imagecolorallocate($img, 255, 255, 255);
        $blue = imagecolorallocate($img, 25, 25, 112);
        $black = imagecolorallocate($img, 0, 0, 0);
        $white = imagecolorallocate($img, 255, 255, 255);
        imagefilledrectangle($img, 0, 0, 599, 399, $white);

        if ($order_dets->status == 'FINANCE_PENDING' || $order_dets->status == 'CANCELED') {
            // The text to draw
            
	    $lines[] = 'S.O Date          : ' . $so_date;
            $lines[] = 'S.O No            : ' . $order_dets->salesorder_code;
            $lines[] = 'Vendor Name       : ' . strtoupper($order_dets->vendor_name);
            $lines[] = 'Vendor Code       : ' . $order_dets->vendor_code;
            $lines[] = 'Sales Channel     : ' . $order_dets->sales_channel;
            $lines[] = 'Category          : ' . $order_dets->category;
            $lines[] = 'Quantity          : ' . $order_dets->quantity;
            $lines[] = 'S.O Amount        : ' . $order_dets->amount;
            $lines[] = 'Discount Amount   : ' . $order_dets->discount_amount;
            $lines[] = 'Purchase Cost     : ' . $total_purchase_cost;
            $lines[] = 'Margin            : ' . $margin;
            $lines[] = 'Margin %          : ' . $margin_percent;
	    $lines[] = 'Status            : ' . $order_dets->status;
        }

        $x = 30;
        $y = 20;
        imageline($img, $x, $y, 570, $y, $blue);
        foreach ($lines as $line) {
            imagestring($img, 5, $x + 5, $y, $line, $black);
            $y += 25;
            imageline($img, $x, $y - 5, 570, $y - 5, $blue);
        }

        imageline($img, $x,  20, $x, $y - 5, $blue);
        imageline($img, 570, 20, 570, $y - 5, $blue);

        imagesetthickness($img, 10);
        imagepng($img, "./uploads/sales_margin.png");
        $this->postImage("./uploads/sales_margin.png", "sales_margin", $post_type);
        return true;
    }
    
    public function postDashboardImage()
    {
        $this->postImage("assets/dashboard/erp_dashboard.png", "ERP-DASHBOARD", 'cliq_dashboard_actuals');
        //echo $update; exit;
        return true;
    }

}
