<?php

class Amazon_Api extends Admin_Model {

    private $config;

    // private $reportType_Responses = [
    //     'GET_FLAT_FILE_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL' => 'gzip',
    //     'GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA' => 'text',
    //     'GET_FBA_FULFILLMENT_CUSTOMER_RETURNS_DATA' => 'text',
    // ];

    /** Set Config Params of Amazon Api */
    private function set_Config_Params() {

        if (isset($this->config)) {
            return true;
        }
        
        /** -------------------------------------------------------------------
         *          Get Config Params 
         * ------------------------------------------------------------------- */
 
         $this->config = [
             'amazon_client_id' => '',
             'amazon_client_secret' => '',
             'amazon_baseUrl' => '',
             'amazon_refresh_token' => '',
             'amazon_access_token' => '',
             'amazon_access_token_expiry' => '',
         ];
 
         $rs = $this->db->like('config_key', 'amazon_', 'RIGHT')->get('tbl_config')->result_array();
 
         foreach($rs as $row) {
             foreach($this->config as $k => $v) {
                 if ($k == $row['config_key']) {
                     $this->config[$k] = $row['value'];
                 }
             }
         }

         return true;
    }
    
    /** Access Token for Amazon Api */
    private function getAccessToken($data = array()) {
        /** Get Config Params */
        $this->set_Config_Params();
        
        /** Validating Access Token */
        $current_time = mktime();
        $interval = $current_time - $this->config['amazon_access_token_expiry'];

        if ($interval > 0) {
            /** Fetching Access Token */

            $data = array(
                "refresh_token" => $this->config['amazon_refresh_token'],
                "client_id" => $this->config['amazon_client_id'],
                "client_secret" => $this->config['amazon_client_secret'],
                "grant_type" => "refresh_token",
            );
            

            $url = "https://api.amazon.com/auth/o2/token";

            /** START:: CURL Api Call */
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));

            $Curl_Res = curl_exec($ch);
            curl_close($ch);
            /** END:: CURL Api Call */

            $Res = json_decode($Curl_Res, TRUE);

            $access_token = $Res['access_token'];
            $access_token_expiry = mktime() + $Res['expires_in'] - 300;

            if(!empty($access_token)){
                $this->db->where('config_key', "amazon_access_token")->update('tbl_config', ['value' => $access_token]);
                $this->db->where('config_key', "amazon_access_token_expiry")->update('tbl_config', ['value' => $access_token_expiry]);
            }

            $this->config['amazon_access_token'] = $this->db->select('value')->where('config_key', "amazon_access_token")->get('tbl_config')->row()->value;
            $this->config['amazon_access_token_expiry'] = $this->db->select('value')->where('config_key', "amazon_access_token_expiry")->get('tbl_config')->row()->value;

        }

        return true;
    }

    public function createReport($req_obj) {

        if (!isset($req_obj->report_type) || !isset($req_obj->from_date) || !isset($req_obj->to_date)) {
            $msg = 'Input Data not Sufficient';
            GOTO ERROR;
        }

        $crnt_date = date('Y-m-d H:i:s');
        $yest_date = date("Y-m-d H:i:s", strtotime('-24 hours', time()));
        $past_mnth_date = date("Y-m-d H:i:s", strtotime('-1 month', time()));
        // echo $past_mnth_date; exit;

        if ($req_obj->from_date > $req_obj->to_date) {
            $msg = 'From Date should be less than To Date';
            GOTO ERROR;
        }
        
        /** Get Access Token */
        $this->getAccessToken();

        

        /** Checking Report Existence */

        $rs = $this->db->from('tbl_amazon_reports')
                      ->where('reportType', $req_obj->report_type)
                      ->where('from_date', $req_obj->from_date)
                      ->where('to_date', $req_obj->to_date);

        if ($past_mnth_date < $req_obj->to_date) {
            $rs->where('requested_date >', $yest_date);
        }

        $rs = $rs->where_in('processingStatus', ['DONE', 'IN_PROGRESS', 'IN_QUEUE'])
                      ->select('reportId, requested_date')
                      ->order_by('requested_date', 'DESC')
                    //   ->get_compiled_select(); echo $rs; exit;
                      ->get()->result_array();
                      
        if (count($rs) >0) {
            $reportId = $rs[0]['reportId'];
            $requested_date = $rs[0]['requested_date'];
            
            if ($req_obj->force_new_report) {
                $min_hours = 3;
                $last_req_dt = $rs[0]['requested_date'];
                $next_req_dt = date('Y-m-d H:i:s', strtotime('+'.$min_hours.' hours', strtotime($last_req_dt)));
                
                if ($crnt_date > $next_req_dt) {
                    GOTO GENERATE_NEW_REPORT;
                }
            }

            return [
                'status' => true,
                'message' => 'Existing Report ID is fetched',
                'reportId' => (int) $reportId,
                'requested_date' => $requested_date
            ];
        }


        GENERATE_NEW_REPORT:

        /** -------------------------------------------------------------------
         *          Fetching Report_ID 
         * ------------------------------------------------------------------- */

        $url = $this->config['amazon_baseUrl'] . '/reports/2021-06-30/reports';

        $http_header = array(
            'Content-Type: application/json',
            'Accept: application/json',
            'x-amz-access-token: ' . $this->config['amazon_access_token'],
        );

        $data = [
            'marketplaceIds' => [
                "A21TJRUUN4KGV"
              ],
              "reportType" => $req_obj->report_type,
              "reportOptions" => [
                "dolore_a6" => "<string>",
                "sit_c6" => "<string>"
              ],
              "dataStartTime" => $req_obj->from_date,
              "dataEndTime" => $req_obj->to_date
        ];

        $crnt_date = date('Y-m-d H:i:s');

        /** START:: CURL Api Call */
        $ch = curl_init($url);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt( $ch, CURLOPT_HTTPHEADER, $http_header);

        $Curl_Res = curl_exec($ch);
        curl_close($ch);
        /** END:: CURL Api Call */

        $Res = json_decode($Curl_Res, TRUE);
        
        if (isset($Res['errors'])) {
            $msg = $Res['errors'][0]['code'] .' - '. $Res['errors'][0]['message'];
            $err = json_encode($Res);
            GOTO ERROR;
        }

        $reportId = $Res['reportId'];

        if (empty($reportId) || strlen($reportId) < 8) {
            $msg = 'Error in Fetching Report ID: '. $Curl_Res;
            GOTO ERROR;
        }

        $ins_data = [
            'reportId' => $reportId,
            'requested_date' => $crnt_date,
            'from_date' => $req_obj->from_date,
            'to_date' => $req_obj->to_date,
            'reportType' => $req_obj->report_type
        ];

        $status = $this->db->insert('tbl_amazon_reports', $ins_data);

        if (!$status) {
            $msg = 'Error in saving Report ID';
            GOTO ERROR;
        }

        return [
            'status' => true,
            'message' => 'New Report ID is generated',
            'reportId' => (int) $reportId
        ];

        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];

    }

    public function getReport($reportId) {
        /** Get Access Token */
        $this->getAccessToken();

        /** -------------------------------------------------------------------
         *          Processing Report
         * ------------------------------------------------------------------- */

        $url = $this->config['amazon_baseUrl'] . '/reports/2021-06-30/reports/{reportId}';

        $url = str_replace('{reportId}', $reportId, $url);

        $http_header = array(
            // 'Content-Type: application/json',
            'Accept: application/json',
            'x-amz-access-token: ' . $this->config['amazon_access_token'],
        );

        
        /** START:: CURL Api Call */
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt( $ch, CURLOPT_HTTPHEADER, $http_header);

        $Curl_Res = curl_exec($ch);
        curl_close($ch);
        /** END:: CURL Api Call */

        $Res = json_decode($Curl_Res, TRUE);

        if (isset($Res['errors'])) {
            $msg = $Res['errors'][0]['code'] .' - '. $Res['errors'][0]['message'];
            $err = json_encode($Res);
            GOTO ERROR;
        }
        
        if (empty($Res['reportId']) || $Res['reportId'] != $reportId) {
            $msg = 'Error in Fetching Report Document: '. $Curl_Res;
            GOTO ERROR;
        }

        $upd_data = [
            'processingStatus' => $Res['processingStatus'],
            // 'dataStartTime' => $Res['dataStartTime'],
            // 'dataEndTime' => $Res['dataEndTime'],
            // 'createdTime' => $Res['createdTime'],
            'last_updated' => date('Y-m-d H:i:s')
        ];
        if ($Res['processingStatus'] == 'DONE') {
            $upd_data['reportDocumentId'] = $Res['reportDocumentId'];
        }
        
        $status = $this->db->where('reportId', $Res['reportId'])->update('tbl_amazon_reports', $upd_data);

        if (!$status) {
            $msg = 'Error in saving Report Document Status';
            GOTO ERROR;
        }

        return [
            'status' => true,
            'message' => 'Report Document Status is - "' . $Res['processingStatus'] . '"',
            'report_status' => $Res['processingStatus'],
            'reportId' => (int) $Res['reportId'],
        ];

        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
            'error' => isset($err)? $err : '',
        ];

    }

    public function getReportDocument($reportId) {

        $doc_ctr = 0;
        FETCH_DOCUMENT_ID:
        $doc_ctr++;

        $rs = $this->db->from('tbl_amazon_reports')
                      ->where('reportId', $reportId)
                      ->get()
                      ->result_array();

        if (count($rs) == 0) {
            $msg = 'Report not found with reportId: ' . $reportId;
            GOTO ERROR;
        } else if ($rs[0]['processingStatus'] != 'DONE') {
            if (!isset($rs[0]['processingStatus']) || in_array($rs[0]['processingStatus'], ['IN_PROGRESS', 'IN_QUEUE'])) {

                $Res = $this->getReport($reportId);
                if (!$Res['status']) {
                    $msg = $Res['message'];
                    $err = $Res['error'];
                    GOTO ERROR;
                }

                if ($Res['report_status'] == 'DONE') {
                    if ($doc_ctr > 2) GOTO ERROR;
                    GOTO FETCH_DOCUMENT_ID;
                } else {
                    $msg = 'Report Processing status is - "'. $Res['report_status'] .'"';
                    GOTO ERROR;
                }
            }
            $msg = 'Report Processing status is - "'. $rs[0]['processingStatus'] .'"';
            GOTO ERROR;
        } else if (!isset($rs[0]['reportDocumentId'])) {
            $msg = 'Report Document ID seems to be invalid';
            GOTO ERROR;
        }

        $reportDocumentId = $rs[0]['reportDocumentId'];

        
        /** -------------------------------------------------------------------
         *          Fetching Report Document URL
         * ------------------------------------------------------------------- */
        
        /** Get Access Token */
        $this->getAccessToken();

        $url = $this->config['amazon_baseUrl'] . '/reports/2021-06-30/documents/{reportDocumentId}';

        $url = str_replace('{reportDocumentId}', $reportDocumentId, $url);

        $http_header = array(
            // 'Content-Type: application/json',
            'Accept: application/json',
            'x-amz-access-token: ' . $this->config['amazon_access_token'],
        );

        
        /** START:: CURL Api Call */
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt( $ch, CURLOPT_HTTPHEADER, $http_header);

        $Curl_Res = curl_exec($ch);
        curl_close($ch);
        /** END:: CURL Api Call */

        $Res = json_decode($Curl_Res, TRUE);

        if (isset($Res['errors'])) {
            $msg = $Res['errors'][0]['code'] .' - '. $Res['errors'][0]['message'];
            $err = json_encode($Res);
            GOTO ERROR;
        }
         
        if (empty($Res['reportDocumentId']) || empty($Res['url'])) {
            $msg = 'Error in Fetching Report Document URL: '. $Curl_Res;
            GOTO ERROR;
        }

        $upd_data = [
            'url' => $Res['url'],
            'last_updated' => date('Y-m-d H:i:s')
        ];
        if (isset($Res['compressionAlgorithm'])) {
            $upd_data['compressionAlgorithm'] = $Res['compressionAlgorithm'];
        }

        $status = $this->db->where('reportId', $reportId)
                          ->where('reportDocumentId', $reportDocumentId)
                          ->update('tbl_amazon_reports', $upd_data);
        if (!$status) {
            $msg = 'Error in saving Report Document URL';
            GOTO ERROR;
        }

        return [
            'status' => true,
            'message' => 'Report Document URL is fetched successfully',
            'url' => $Res['url'],
            'reportId' => (int) $Res['reportId'],
        ];
        
        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];
    }

    public function getReport_Data($reportId) {
        $rs = $this->db->from('tbl_amazon_reports')
                      ->where('reportId', $reportId)
                      ->get()
                      ->result_array();

        if (count($rs) == 0) {
            $msg = 'Report not found with reportId: ' . $reportId;
            GOTO ERROR;
        } else if ($rs[0]['processingStatus'] != 'DONE') {
            $msg = 'Report Processing status is - "'. $rs[0]['processingStatus'] .'"';
            GOTO ERROR;
        } else if (!isset($rs[0]['url'])) {
            $msg = 'Report Document URL seems to be unavailable';
            GOTO ERROR;
        }

        $reportType = $rs[0]['reportType'];
        $url = $rs[0]['url'];
        $compressionAlgorithm = $rs[0]['compressionAlgorithm'];


        // $Amz_Dwnlds_Path = dirname(__FILE__) . DIRECTORY_SEPARATOR. '..' .DIRECTORY_SEPARATOR. '..' .DIRECTORY_SEPARATOR. 'uploads' .DIRECTORY_SEPARATOR. 'amazon_downloads';
        // $filename = $Amz_Dwnlds_Path .DIRECTORY_SEPARATOR. date('Ymd_His').'.zip';
        
        /** START:: CURL Api Call */
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, true);
        // curl_setopt( $ch, CURLOPT_HTTPHEADER, []);

        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects

        
        $Curl_Res = curl_exec($ch);
        
        // Execute the cURL request and handle errors
        if ($Curl_Res === false) {
            $msg = "ResError: " . curl_error($ch);
            curl_close($ch);
            GOTO ERROR;
        }

        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        curl_close($ch);
        /** END:: CURL Api Call */

        $Curl_Res_arr = process_CurlResponse($Curl_Res, $header_size);

        $Curl_Res_header = $Curl_Res_arr['header'];
        $Curl_Res_body = $Curl_Res_arr['body'];
        
        // echo json_encode($Curl_Res_header); exit;

        if ($Curl_Res_header['status']['code'] != 200
        || strpos($Curl_Res_header['Content-Type'], 'application/xml') !== false) {
            $msg = 'Report URL Expired';
            GOTO ERROR;
        }

        if (strtolower($compressionAlgorithm) == 'gzip') {
            $Curl_Res_body = gzdecode($Curl_Res_body);
        }

        $Amz_Orders_Data = convert_TextData_to_JsonData($Curl_Res_body);

        // echo json_encode($Amz_Orders_Data); exit;

        $Response = null;
        if ($reportType == 'GET_FLAT_FILE_ALL_ORDERS_DATA_BY_ORDER_DATE_GENERAL') {
            $Response = $this->save_AllOrders_Data($Amz_Orders_Data, $reportId);

        } else if ($reportType == 'GET_FBA_FULFILLMENT_CUSTOMER_SHIPMENT_SALES_DATA') {
            $Response = $this->save_LocationData_In_AllOrders_Data($Amz_Orders_Data, $reportId);
            // $Response = $this->save_Shipments_Data($Amz_Orders_Data, $reportId);

        } else if ($reportType == 'GET_FBA_FULFILLMENT_CUSTOMER_RETURNS_DATA') {
            // echo json_encode($Amz_Orders_Data); exit;
            $Response = $this->save_FbaReturns_Data($Amz_Orders_Data, $reportId);
        }

        if (empty($Response)) {
            $msg = 'No Response';
            GOTO ERROR;
        }

        return $Response;
        
        ERROR:
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];
    }

    private function save_AllOrders_Data($Amz_Orders_Data, $reportId = 0) {
        $Order_Ids = array_column($Amz_Orders_Data, 'amazon-order-id');

        $Existing_Order_Ids = [];
        if (count($Order_Ids) > 0) {
            $Existing_Order_Ids = $this->db->from('tbl_amazon_orders_data')
                                    ->where_in('amazon_order_id', $Order_Ids)
                                    ->select('amazon_order_id')->get()->result_array();
            $Existing_Order_Ids = array_column($Existing_Order_Ids, 'amazon_order_id');
        }

        // $New_Order_Ids = array_diff($Order_Ids, $Existing_Order_Ids);

        $key_values = [
            'amazon_order_id'         => 'amazon-order-id',
            'merchant_order_id'       => 'merchant-order-id',
            'purchase_date_utc'       => 'purchase-date',
            'last_updated_date_utc'   => 'last-updated-date',
            'order_status'            => 'order-status',
            'fulfillment_channel'     => 'fulfillment-channel',
            'sales_channel'           => 'sales-channel',
            'order_channel'           => 'order-channel',
            'ship_service_level'      => 'ship-service-level',
            'product_name'            => 'product-name',
            'sku'                     => 'sku',
            'asin'                    => 'asin',
            'number_of_items'         => 'number-of-items',
            'item_status'             => 'item-status',
            'quantity'                => 'quantity',
            'currency'                => 'currency',
            'item_price'              => 'item-price',
            'item_tax'                => 'item-tax',
            'shipping_price'          => 'shipping-price',
            'shipping_tax'            => 'shipping-tax',
            'gift_wrap_price'         => 'gift-wrap-price',
            'gift_wrap_tax'           => 'gift-wrap-tax',
            'item_promotion_discount' => 'item-promotion-discount',
            'ship_promotion_discount' => 'ship-promotion-discount',
            'ship_city'               => 'ship-city',
            'ship_state'              => 'ship-state',
            'ship_postal_code'        => 'ship-postal-code',
            'ship_country'            => 'ship-country',
            'promotion_ids'           => 'promotion-ids',
            'purchase_order_number'   => 'purchase-order-number',
            'fulfilled_by'            => 'fulfilled-by',
        ];

        $crnt_date = date('Y-m-d H:i:s');

        $Amz_Order_Asins = [];
        
        $ins_data = [];
        $upd_data = [];
        $total_records = 0;
        foreach($Amz_Orders_Data as $v) {
            if (empty($v['amazon-order-id'])) { continue; }

            $temp = [
                'last_reportId' => $reportId,
                'purchase_date' => convert_DateTime_UTC_to_Local($v['purchase-date']),
                'last_updated_date' => convert_DateTime_UTC_to_Local($v['last-updated-date']),
            ];
            foreach($key_values as $i => $j) {
                $temp[$i] = $v[$j];
            }

            if (isset($Amz_Order_Asins[$v['amazon-order-id']][$v['asin']])) {
                $Amz_Order_Asins[$v['amazon-order-id']][$v['asin']] += 1;
            } else {
                $Amz_Order_Asins[$v['amazon-order-id']][$v['asin']] = 1;
            }
            $temp['package_index'] = $Amz_Order_Asins[$v['amazon-order-id']][$v['asin']];

            if (in_array($v['amazon-order-id'], $Existing_Order_Ids)) {
                $temp['updated_date'] = $crnt_date;
                $upd_data[] = $temp;
            } else {
                $temp['created_date'] = $crnt_date;
                $ins_data[] = $temp;
            }
            $total_records++;
        }

        $this->db->trans_start();

        if (count($upd_data) > 0) {
            foreach($upd_data as $k => $v) {
                $where_arr = [
                    'amazon_order_id' => $v['amazon_order_id'],
                    'asin' => $v['asin'],
                    'package_index' => $v['package_index'],
                    // 'purchase_date' => $v['purchase_date'],
                ];
                $rs = $this->db->from('tbl_amazon_orders_data')
                                ->where($where_arr)
                                ->get()->result_array();
                if (count($rs) > 0) {
                    unset($v['amazon_order_id']);
                    unset($v['asin']);
                    $status_upd = $this->db->where($where_arr)->update('tbl_amazon_orders_data', $v);
                } else {
                    $rs = $this->db->where('amazon_order_id', $v['amazon_order_id'])
                                ->where('is_added_inERP', 1)->get('tbl_amazon_orders_data')->result_array();
                    if (count($rs) >0) {
                        $v['is_added_inERP'] = 1;
                    }
                    $status_ins = $this->db->insert('tbl_amazon_orders_data', $v);
                }
                
                if ($this->db->error()['code'] != 0) { GOTO ERROR; }
            }
        }

        if (count($ins_data) > 0) {
            $status_ins = $this->db->insert_batch('tbl_amazon_orders_data', $ins_data);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }
        }
        
        $this->db->trans_complete();

        return [
            'status' => true,
            'message' => $total_records . ' records fetched and saved in ERP successfully'
        ];
            
        ERROR:
        $this->db->trans_rollback();
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];
    }

    private function save_LocationData_In_AllOrders_Data($Amz_Orders_Data, $reportId = 0) {
        $Order_Ids = array_column($Amz_Orders_Data, 'amazon-order-id');
        
        $Existing_Order_Ids = [];
        if (count($Order_Ids) > 0) {
            $Existing_Order_Ids = $this->db->from('tbl_amazon_orders_data')
                                    ->where_in('amazon_order_id', $Order_Ids)
                                    ->select('amazon_order_id')->get()->result_array();
            $Existing_Order_Ids = array_column($Existing_Order_Ids, 'amazon_order_id');
        }

        // $New_Order_Ids = array_diff($Order_Ids, $Existing_Order_Ids);

        $crnt_date = date('Y-m-d H:i:s');
        
        $ins_data = [];
        $upd_data = [];
        $total_records = 0;
        $amz_order_ids = [];
        foreach($Amz_Orders_Data as $v) {
            if (empty($v['amazon-order-id'])) { continue; }

            $temp = [
                'amazon_order_id' => $v['amazon-order-id'],
                'asin' => $v['asin'],
                'shipment_date' => convert_DateTime_UTC_to_Local($v['shipment-date']),
                'fnsku' => $v['fnsku'],
                'fulfillment_center_id' => $v['fulfillment-center-id'],
            ];

            if (in_array($v['amazon-order-id'], $Existing_Order_Ids)) {
                $temp['updated_date'] = $crnt_date;
                $upd_data[] = $temp;
            
                $total_records++;
            }
            
            $amz_order_ids[] = $temp['amazon_order_id'];
        }


        $this->db->trans_start();

        if (count($upd_data) > 0) {
            foreach($upd_data as $k => $v) {
                $where_arr = [
                    'amazon_order_id' => $v['amazon_order_id'],
                    'asin' => $v['asin'],
                ];
                unset($v['amazon_order_id']);
                unset($v['asin']);
                $status_upd = $this->db->where($where_arr)->update('tbl_amazon_orders_data', $v);
                if ($this->db->error()['code'] != 0) { GOTO ERROR; }
            }
        }
        
        $this->db->trans_complete();

        return [
            'status' => true,
            'message' => $total_records . ' Fulfilment locations updated in ERP successfully'
        ];
            
        ERROR:
        $this->db->trans_rollback();
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];
    }

    private function save_Shipments_Data($Amz_Orders_Data, $reportId = 0) {
        return false;
        $Order_Ids = array_column($Amz_Orders_Data, 'amazon-order-id');

        $Existing_Order_Ids = $this->db->from('tbl_amazon_shipments_data')
                                    ->where_in('amazon_order_id', $Order_Ids)
                                    ->select('amazon_order_id')->get()->result_array();
        $Existing_Order_Ids = array_column($Existing_Order_Ids, 'amazon_order_id');

        // $New_Order_Ids = array_diff($Order_Ids, $Existing_Order_Ids);

        $crnt_date = date('Y-m-d H:i:s');
        
        $ins_data = [];
        $upd_data = [];
        foreach($Amz_Orders_Data as $v) {
            $temp = [
                'amazon_order_id' => $v['amazon-order-id'],
                'asin' => $v['asin'],
                // 'shipment_date' => $v['shipment-date'],
                'shipment_date_utc' => $v['shipment-date'],
                'sku' => $v['sku'],
                'fnsku' => $v['fnsku'],
                'fulfillment_center_id' => $v['fulfillment-center-id'],
                'quantity' => $v['quantity'],
                'currency' => $v['currency'],
                'item_price_per_unit' => $v['item-price-per-unit'],
                'shipping_price' => $v['shipping-price'],
                'gift_wrap_price' => $v['gift-wrap-price'],
                'ship_city' => $v['ship-city'],
                'ship_state' => $v['ship-state'],
                'ship_postal_code' => $v['ship-postal-code'],
                'last_reportId' => $reportId
            ];
            if (in_array($v['amazon-order-id'], $Existing_Order_Ids)) {
                $temp['updated_date'] = $crnt_date;
                $upd_data[] = $temp;
            } else {
                $temp['created_date'] = $crnt_date;
                $ins_data[] = $temp;
            }
        }


        $this->db->trans_start();

        if (count($upd_data) > 0) {
            $status_upd = $this->db->update_batch('tbl_amazon_shipments_data', $upd_data, ['amazon_order_id', 'asin']);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }
        }
        if (count($ins_data) > 0) {
            $status_ins = $this->db->insert_batch('tbl_amazon_shipments_data', $ins_data);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }
        }
        
        $this->db->trans_complete();

        return [
            'status' => true,
            'message' => count($Amz_Orders_Data) . ' records fetched and saved in ERP successfully'
        ];
            
        ERROR:
        $this->db->trans_rollback();
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];
    }

    
    private function save_FbaReturns_Data($Amz_Orders_Data, $reportId = 0) {
        $Order_Ids = array_column($Amz_Orders_Data, 'order-id');

        $Existing_Order_Ids = [];
        if (count($Order_Ids) > 0) {
            $Existing_Order_Ids = $this->db->from('tbl_amazon_fba_returns')
                                    ->where_in('amazon_order_id', $Order_Ids)
                                    ->select('amazon_order_id')->get()->result_array();
            $Existing_Order_Ids = array_column($Existing_Order_Ids, 'amazon_order_id');
        }
        // $New_Order_Ids = array_diff($Order_Ids, $Existing_Order_Ids);

        $key_values = [
            'amazon_order_id'         =>  'order-id',
            'asin'                    =>  'asin',
            'return_date_utc'         =>  'return-date',
            'sku'                     =>  'sku',
            'fnsku'                   =>  'fnsku',
            'product_name'            =>  'product-name',
            'quantity'                =>  'quantity',
            'fulfillment_center_id'   =>  'fulfillment-center-id',
            'detailed_disposition'    =>  'detailed-disposition',
            'reason'                  =>  'reason',
            'license_plate_number'    =>  'license-plate-number',
            'customer_comments'       =>  'customer-comments',
        ];

        $crnt_date = date('Y-m-d H:i:s');
        
        $Amz_Order_Asins = [];
        
        $ins_data = [];
        $upd_data = [];
        $total_records = 0;
        foreach($Amz_Orders_Data as $v) {
            if (empty($v['order-id'])) { continue; }

            $temp = [
                'last_reportId' => $reportId,
                'return_date' => convert_DateTime_UTC_to_Local($v['return-date']),
            ];
            foreach($key_values as $i => $j) {
                $temp[$i] = $v[$j];
            }

            if (isset($Amz_Order_Asins[$v['order-id']][$v['asin']])) {
                $Amz_Order_Asins[$v['order-id']][$v['asin']] += 1;
            } else {
                $Amz_Order_Asins[$v['order-id']][$v['asin']] = 1;
            }
            $temp['package_index'] = $Amz_Order_Asins[$v['order-id']][$v['asin']];

            if (in_array($v['order-id'], $Existing_Order_Ids)) {
                $temp['updated_date'] = $crnt_date;
                $upd_data[] = $temp;
            } else {
                $temp['created_date'] = $crnt_date;
                $ins_data[] = $temp;
            }
            $total_records++;
        }

        $this->db->trans_start();

        if (count($upd_data) > 0) {
            foreach($upd_data as $k => $v) {
                $where_arr = [
                    'amazon_order_id' => $v['amazon_order_id'],
                    'asin' => $v['asin'],
                    'package_index' => $v['package_index'],
                ];
                $rs = $this->db->from('tbl_amazon_fba_returns')
                                ->where($where_arr)
                                ->get()->result_array();
                if (count($rs) > 0) {
                    unset($v['amazon_order_id']);
                    unset($v['asin']);
                    $status_upd = $this->db->where($where_arr)->update('tbl_amazon_fba_returns', $v);
                } else {
                    $status_ins = $this->db->insert('tbl_amazon_fba_returns', $v);
                }
                
                if ($this->db->error()['code'] != 0) { GOTO ERROR; }
            }
        }

        if (count($ins_data) > 0) {
            $status_ins = $this->db->insert_batch('tbl_amazon_fba_returns', $ins_data);
            if ($this->db->error()['code'] != 0) { GOTO ERROR; }
        }
        
        $this->db->trans_complete();

        return [
            'status' => true,
            'message' => $total_records . ' records fetched and saved in ERP successfully'
        ];
            
        ERROR:
        $this->db->trans_rollback();
        return [
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request',
			'error' => isset($err)? $err : ''
        ];
    }

}
