<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of dompdf_helper
 *
 * @author Parimal
 */
require_once("dompdf/autoload.inc.php");
use Dompdf\Dompdf;
use Dompdf\Options;

function pdf_create($html, $filename = '', $stream = TRUE, $set_paper = '', $attach = null, $folder_name = null,$header='')
{

    $options = new Options();
    $options->set('defaultFont', 'dejavusanscondensed');
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($html);

    if ($set_paper != '') {
        $dompdf->setPaper(array(0, 0, 900, 841), 'portrait');
    } else {
        $dompdf->setPaper("a4", "portrait");
    }
    $dompdf->render();
        // Parameters
    $x          = 510;
    $y          = 805;
    $text       = "Page {PAGE_NUM} of {PAGE_COUNT}"; 
    $font       = $dompdf->getFontMetrics()->get_font('times', 'normal');   
    $size       = 7;    
    $color      = #555555; //array(3,3,3);
    $word_space = 0.0;
    $char_space = 0.0;
    $angle      = 0.0;

    $firstPageId = $dompdf->getCanvas()->get_cpdf()->getFirstPageId();
    $objects = $dompdf->getCanvas()->get_cpdf()->objects;

    $pages = array_filter($objects, function($v) {
        return $v['t'] == 'page';
        });

    $number = 1;
    $count=count($pages);
    if($header!=''){
        foreach($pages as $pageId => $page) {
            if(($pageId + 1) !== $firstPageId) {
                $dompdf->getCanvas()->reopen_object($pageId + 1);
                $dompdf->getCanvas()->text(30, 20, $header, $font, 8, $color);
                $dompdf->getCanvas()->close_object();
                
            }
            $number++;
        }
    }

    $dompdf->getCanvas()->page_text($x, $y, $text, $font, $size, $color, $word_space, $char_space, $angle);

    //$dompdf->getCanvas()->page_text(    505, 15, $text, $font, $size, $color, $word_space, $char_space, $angle  );

    if($attach==true) $attachments=array("Attachment"=>true);

    else $attachments=array("Attachment"=>false);

    if ($stream) {

        $pdf_string = $dompdf->output();
        if (!empty($attach)) {
            if (!empty($folder_name)) {
                $folder = "uploads/" . $folder_name . '/' . $filename . ".pdf";;
            } else {
                $folder = "uploads/" . $filename . ".pdf";;
            }
            file_put_contents($folder, $pdf_string);
        } else {
            $dompdf->stream($filename . ".pdf", $attachments);
        }
    } else {
        return $dompdf->output();
    }
}

function pdf_picklist($html,$filename='', $stream = FALSE){
    
    $options = new Options();
    $options->set('defaultFont', 'dejavusanscondensed');
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($html);

  
    $dompdf->setPaper("a4", "portrait");

    $dompdf->render();

    $attachments=array("Attachment"=>false);
    $dompdf->output();
    $dompdf->stream($filename . ".pdf", $attachments);
}