<?php

function gav($list, $key, $default = '') {
    if (!isset($list)) {
        return $default;
    } else if (is_array($list)) {
        return isset($list[$key])? $list[$key] : $default;
    } else if (is_object($list)) {
        return isset($list->{$key})? $list->{$key} : $default;
    }
    return $default;
}


function get_FinancialYear($now = 0) {
    /** If 
     * $now = 0  --> Current Financial Year
     * $now = -1  --> Previous Financial Year
     * $now = -2  --> Before Previous Financial Year
     * $now = 1  --> Next Financial Year
     * ....
     */
    
    /** This is just for Local Env as per the records available in Local DB */
    if (ENVIRONMENT == 'development') {
        // Means Let Current Financial Year be the FinYear in before 2 Years
        // $now -= 2;
    }

	if ((int) date('m') < 4) {
        $fin_year = (date('Y') - 1 + $now) . '-' . (date('y') + $now);
    } else {
        $fin_year = (date('Y') + $now) . '-' . (date('y') + 1 + $now);
    }

    return $fin_year;
}

function get_FinancialYearPeriod($fin_year, $now = 0) {
    /** If 
     * $now = 0  --> Financial Year given in Param1
     * $now = -1  --> Prev Financial Year to the one given in Param1
     * $now = -2  --> Before Prev Financial Year to the one given in Param1
     * $now = 1  --> Next Financial Year to the one given in Param1
     * ....
     */
    $arr = explode('-', $fin_year);

    return [
        'fin_yr_frm' => ((int)$arr[0] + $now) . '-04-01',
        'fin_yr_to' => ((int)('20' . $arr[1]) + $now) . '-04-01'
    ];
}

/** Gives the Financial Years list in the given date period -- Not using anywhere */
function get_FinancialYears_inDateRange($frm_date, $to_date) {
    $from_obj = DateTime::createFromFormat("Y-m-d", $frm_date);
    $to_obj = DateTime::createFromFormat("Y-m-d", $to_date);

    if ($from_obj->format('m') < 4) {
        $frm_FY_a = $from_obj->format('Y') - 1;
    } else {
        $frm_FY_a = $from_obj->format('Y');
    }

    if ($to_obj->format('m') < 4) {
        $to_FY_a = $to_obj->format('Y') - 1;
    } else {
        $to_FY_a = $to_obj->format('Y');
    }

    $FY_list = [];
    for($i = $frm_FY_a; $i <= $to_FY_a; $i++) {
        $FY_list[] = $i . '-' . ((int) date('y', strtotime($i . '-04-01')) +1);
    }
    
    return $FY_list;
}

/** Just for Dashboard Related as of now */
function get_DashboardRelated_CustomResponse($frm_date, $to_date) {
    $from_obj = DateTime::createFromFormat("Y-m-d", $frm_date);
    $to_obj = DateTime::createFromFormat("Y-m-d", $to_date);

    $range_frm = new DateTime($from_obj->format('Y-m-d'));
    $range_to = new DateTime($to_obj->format('Y-m-d'));

    $Res = [
        'frm_mnth_DaysPortion' => 0,
        'to_mnth_DaysPortion' => 0,
        'range' => null
    ];

    if ($from_obj->format('Y-m') == $to_obj->format('Y-m')) {
        $frm_mnth_days = (int) $to_obj->diff($from_obj)->format("%a") + 1;
        $frm_mnth_days_t = (int) $from_obj->format('t') - 4; // Removing 4 Sunday_Holidays

        $Res['frm_mnth_DaysPortion'] = $frm_mnth_days / $frm_mnth_days_t;
        $Res['frm_mnth'] = $from_obj->format('Y-m');
        
        $Res['range'] = null;

    } else {
        if ((int) $from_obj->format('d') == 1) {
            $Res['frm_mnth_DaysPortion'] = 0;
        } else {
            // $frm_mnth_days = $from_obj->diff( new DateTime('last day of '. $from_obj->format('Y-m')) )->format("%a");
            // $from_mnth_days_t = cal_days_in_month(CAL_GREGORIAN, $from_obj->format('m'), $from_obj->format('Y'));
            
            $frm_mnth_days = (int) $from_obj->format('t') - (int) $from_obj->format('d') + 1;
            $frm_mnth_days_t = (int) $from_obj->format('t') - 4; // Removing 4 Sunday_Holidays

            // $Res['frm_mnth_days'] = $frm_mnth_days;
            // $Res['frm_mnth_days_t'] = $frm_mnth_days_t;
            $Res['frm_mnth_DaysPortion'] = $frm_mnth_days / $frm_mnth_days_t;
            $Res['frm_mnth'] = $from_obj->format('Y-m');
            
            $range_frm->modify('+1 month');
        }
        
        if ((int) $to_obj->format('d') == (int) $to_obj->format('t')) {
            $Res['to_mnth_DaysPortion'] = 0;
            
        } else {
            $to_mnth_days = (int) $to_obj->format('d');
            $to_mnth_days_t = (int) $to_obj->format('t') - 4; // Removing 4 Sunday_Holidays
            
            // $Res['to_mnth_days'] = $to_mnth_days;
            // $Res['to_mnth_days_t'] = $to_mnth_days_t;
            $Res['to_mnth_DaysPortion'] = $to_mnth_days / $to_mnth_days_t;
            $Res['to_mnth'] = $to_obj->format('Y-m');
            
            $range_to->modify('-1 month');
        }

        $range_frm = $range_frm->format('Y-m') .'-01';
        $range_to = $range_to->format('Y-m') .'-'. $range_to->format('t');

        if (new DateTime( $range_frm ) < new DateTime( $range_to )) {
            $Res['range'] = [
                'range_frm' => $range_frm,
                'range_to' => $range_to
            ];
        }
        
    }

    return $Res;
}


function process_CurlResponse($Curl_Res, $header_size) {
    $Curl_Res_header = substr($Curl_Res, 0, $header_size);
    $Curl_Res_body = substr($Curl_Res, $header_size);

    $Curl_Res_header = json_encode($Curl_Res_header);
    $Curl_Res_header = explode('\n', $Curl_Res_header);

    $Header = [];

    foreach($Curl_Res_header as $k => $v) {
        $v = trim($v, '\r');

        if ($k == 0) {
            $temp = explode(' ', $v);
            $Header['status'] = [
                'version' => $temp[0],
                'code' => $temp[1],
                'status' => $temp[2],
            ];
        } else {
            $pos = strpos($v, ': ');
            if ($pos !== false) {
                $Header[substr($v, 0, $pos)] = substr($v, $pos+2);
            } else {
                $Header[] = $v;
            }
        }
    }

    return [
        'header' => $Header,
        'body' => $Curl_Res_body
    ];

}

function convert_TextData_to_JsonData($text_data) {
    $text_data = json_encode($text_data);

    $data = explode('\n', $text_data);
    $data_records_cnt = count($data);

    $data_header = trim($data[0], '"');
    $data_header = rtrim($data_header, '\r');

    $data_header = explode('\t', $data_header);

    $ResponseData = [];
    foreach($data as $k => $v) {
        if ($k == 0) { continue; }

        if ($k+1 == $data_records_cnt) {
            $v = trim($v, '"');
        }
        $v = trim($v, '\r');

        $temp = explode('\t', $v);
        $temp_arr = [];
        foreach($temp as $indx => $value) {
            $temp_arr[$data_header[$indx]] = $value;
        }

        $ResponseData[$k-1] = $temp_arr;
    }

    return $ResponseData;
}

/**
 *  Input format should be like "2023-10-31T23:34:04+00:00" 
 *  Output format will be "2023-10-31 23:34:04"
 */
function convert_DateTime_UTC_to_Local($dateString) {
    if (empty($dateString)) {
        return null;
    }
    // Create a DateTime object from the string (considering 'Asia/Kolkata' timezone)
    $dateTime = new DateTime($dateString, new DateTimeZone('UTC'));

    // Convert to the desired timezone (+05:30)
    $dateTime->setTimezone(new DateTimeZone('Asia/Kolkata'));  // Replace with your desired +05:30 timezone

    // Format the DateTime object to MySQL datetime format
    $Local_Datetime = $dateTime->format('Y-m-d H:i:s');

    return $Local_Datetime;
}