<?php

class Yieldreports extends Admin_Controller
{

    public function __construct()
    {

        parent::__construct();
    }

    public function manage_yieldreports($active = 0)
    {

        if ($active <= 0) {

            $data['active'] = 1;
        } else {

            $data['active'] = $active;
        }

        $data['title'] = 'Yield Reports';

        $data['subview'] = $this->load->view('admin/yieldreports/manage_yieldreports', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function getSalesorderList()
    {

	$status_arr = array("CANCELED","CANCELLED","FINANCE_REJECTED","FULL_RETURN","VOID","WAREHOUSE_REJECTED");
        $this->db->select('tbl_salesorder.salesorder_id, tbl_salesorder.salesorder_code, tbl_salesorder.sales_channel, tbl_vendor.company as vendor_name');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_salesorder.vendor_id', 'Left');
        $this->db->where_not_in('tbl_salesorder.status',$status_arr);
	$result = $this->db->get('tbl_salesorder')->result_array();
        $records = array();

        foreach ($result as $rowValue) {
            $records[] = array(
                "salesorder_id" => $rowValue['salesorder_id'],
                "salesorder_code" => $rowValue['salesorder_code'],
                "sales_channel" => $rowValue['sales_channel'],
                "vendor_name" => $rowValue['vendor_name'],
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getSalesorderYieldExcel()
    {

        $salesorder_id = $this->input->get('salesorder_id');

        if (empty($salesorder_id) || (int)$salesorder_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Sales order yield report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A5:J5')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1:A3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('B1:B3')->getFont()->setBold(true)->setSize(12);

        $this->db->select('tbl_salesorder.salesorder_id, tbl_salesorder.salesorder_code, tbl_salesorder.CREATION_DATE, tbl_vendor.company as vendor_name');
       // $this->db->select('discount_amount, insurance_amount, tcs_amount, freight_amount');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_salesorder.vendor_id', 'Left');
        $header = $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('Customer Name');
        $objSheet->getCell('A2')->setValue('Salesorder No');
        $objSheet->getCell('A3')->setValue('Date');

        //Header Values
        $objSheet->getCell('B1')->setValue($header->vendor_name);
        $objSheet->getCell('B2')->setValue($header->salesorder_code);
        $objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A5')->setValue('Device Name');
        $objSheet->getCell('B5')->setValue('SKU');
        $objSheet->getCell('C5')->setValue('Cost Price');
        $objSheet->getCell('D5')->setValue('Sale Price');
        $objSheet->getCell('E5')->setValue('Quantity');
        $objSheet->getCell('F5')->setValue('Cost Amount');
        $objSheet->getCell('G5')->setValue('Sale Amount');
        $objSheet->getCell('H5')->setValue('Margin');
        $objSheet->getCell('I5')->setValue('Margin (%)');

        $result = $this->db->where('salesorder_id', $salesorder_id)->get('SO_YIELD_REPORTS_VIEW')->result_array();
        if (!empty($result)) {
            $rowCount = 6;
            $total_cost_price = 0;
            $total_sale_price = 0;
         //   $total_amount = 0;
            foreach ($result as $rowValue) {
                $cost_amount = bcmul($rowValue['cost_price'], $rowValue['quantity'], 2);
                $sale_amount = bcmul($rowValue['sale_price_no_tax'], $rowValue['quantity'], 2);
                if($rowValue['sale_price_incl_tax'] < $rowValue['cost_price']){
                    $sale_amount = $rowValue['sale_price_incl_tax'];
                }
           //     $total_amount += $rowValue['sale_price_incl_tax'];
                
                $margin = $sale_amount - $cost_amount;
                $margin_perc = ($margin / $sale_amount) * 100;

                $total_cost_price += $cost_amount;
                $total_sale_price += $sale_amount;

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $rowValue['device_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['sku']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, number_format($rowValue['cost_price'], 2, '.', ''));
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, number_format($rowValue['sale_price_no_tax'], 2, '.', ''));
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $rowValue['quantity']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $cost_amount);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $sale_amount);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $margin);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, sprintf('%.2f', $margin_perc));

                $rowCount++;
            }
            $objSheet->getStyle('F' . $rowCount . ':I' . $rowCount)->getFont()->setBold(true)->setSize(10);
            $total_margin = $total_sale_price - $total_cost_price;
            $total_margin_perc = ($total_margin / $total_sale_price) * 100;

            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $total_cost_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $total_sale_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $total_margin);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, sprintf('%.2f', $total_margin_perc));
            
            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Total Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $total_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Discount Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $header->discount_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Freight Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $header->freight_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Insurance Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $header->insurance_amount);

            $price_collected = $total_amount + $header->insurance_amount + $header->freight_amount - $discount_amount;
            $net_amount = $price_collected + $header->tcs_amount;

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Price Collected');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $price_collected);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'TCS Collected');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $header->tcs_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Net Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $net_amount);

            
        }
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Yield_' . $header->salesorder_code;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

    public function getSalesorderOfflineYieldExcel()
    {

        $salesorder_id = $this->input->get('salesorder_id');

        if (empty($salesorder_id) || (int)$salesorder_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format,  with < 0 being in red color
        $currencyFormat = '#,#0.## \;[Red]-#,#0.## \';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Sales order yield report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A5:K5')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1:A3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('B1:B3')->getFont()->setBold(true)->setSize(12);

        $this->db->select('tbl_salesorder.salesorder_id, tbl_salesorder.salesorder_code, tbl_salesorder.CREATION_DATE, tbl_vendor.company as vendor_name');
        $this->db->select('discount_amount, insurance_amount, tcs_amount, freight_amount');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_salesorder.vendor_id', 'Left');
        $header = $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('Customer Name');
        $objSheet->getCell('A2')->setValue('Salesorder No');
        $objSheet->getCell('A3')->setValue('Date');

        //Header Values
        $objSheet->getCell('B1')->setValue($header->vendor_name);
        $objSheet->getCell('B2')->setValue($header->salesorder_code);
        $objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A5')->setValue('Device Name');
        $objSheet->getCell('B5')->setValue('Device Name');
        $objSheet->getCell('C5')->setValue('SKU');
        $objSheet->getCell('D5')->setValue('Cost Price');
        $objSheet->getCell('E5')->setValue('Sale Price');
        $objSheet->getCell('F5')->setValue('Quantity');
        $objSheet->getCell('G5')->setValue('Cost Amount');
        $objSheet->getCell('H5')->setValue('Sale Amount');
        $objSheet->getCell('I5')->setValue('Discount Amount');
        $objSheet->getCell('J5')->setValue('Margin');
        $objSheet->getCell('K5')->setValue('Margin (%)');

        $taxable_cat = TAXABLE_CATEGORY;

        $result = $this->db->where('salesorder_id', $salesorder_id)->get('YIELD_OFFLINE_SALESORDER_VIEW')->result_array();
        if (!empty($result)) {
            $rowCount = 6;
            $total_cost_price = 0;
            $total_sale_price = 0;
            foreach ($result as $rowValue) {
                // $cost_amount = bcmul($rowValue['cost_price'], $rowValue['quantity'], 2);
                // $sale_amount = bcmul($rowValue['sale_price_no_tax'], $rowValue['quantity'], 2);

                // $margin = $sale_amount- $cost_amount;
                //  $margin_perc = ($margin/$sale_amount)*100;

                // $total_cost_price += $cost_amount;
                //$total_sale_price += $sale_amount ;

                if (in_array($rowValue['category'],$taxable_cat)) {
                    $total_amount += $rowValue['sale_price'];
                    $sale_price = $rowValue['sale_price'] / 1.18;
                    $cost_price = $rowValue['unit_price'];
                    $total_cost_price += $cost_price;
                    $total_sale_price += $sale_price;
                } else {
                   
                    $total_amount += $rowValue['sale_price'];
                    $taxable_amount = ($rowValue['sale_price'] - ($rowValue['unit_price'] + $rowValue["unit_price_tax"])) / 1.18;
                    $exempt_amount = $rowValue['unit_price'] + $rowValue["unit_price_tax"];

                    $cost_price = $rowValue['unit_price'];
                    $total_cost_price += $cost_price;

                    if($rowValue['sale_price'] < $exempt_amount){
                        $taxable_amount = 0;
                        $sale_price = $rowValue['sale_price'];
                    }else{
                        $sale_price = $taxable_amount + $exempt_amount;
                    }

                    
                    $total_sale_price += $sale_price;
                }
                $discount_amount = $rowValue['discount_amount'];
                $so_qty = count($result);
                $td_discount = $discount_amount / $so_qty ;
                $td_discount = number_format((float)$td_discount, 2, '.', '');
                $yield_amount = ($sale_price - $td_discount) - $cost_price;
                $yield_perc = $yield_amount / $sale_price * 100;



                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $rowValue['device_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['device_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['SKU']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, number_format($rowValue['unit_price'], 2, '.', ''));
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, number_format($sale_price, 2, '.', ''));
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, 1);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $rowValue['unit_price']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $sale_price);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $td_discount);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $yield_amount);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, sprintf('%.2f', $yield_perc));

                $rowCount++;
            }
            $objSheet->getStyle('G' . $rowCount . ':J' . $rowCount)->getFont()->setBold(true)->setSize(10);
            $total_yield_amount = ($total_sale_price - $discount_amount) -$total_cost_price;
            $total_yield_perc = $total_yield_amount / $total_sale_price * 100;

            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $total_cost_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $total_sale_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $total_yield_amount);
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, sprintf('%.2f', $total_yield_perc));

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Total Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $total_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, 'Discount Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $header->discount_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Freight Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $header->freight_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Insurance Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $header->insurance_amount);

            $price_collected = $total_amount + $header->insurance_amount + $header->freight_amount - $header->discount_amount;
            $net_amount = $price_collected + $header->tcs_amount;

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Price Collected');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $price_collected);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'TCS Collected');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $header->tcs_amount);

            $rowCount ++;
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Net Amount');
            $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $net_amount);

        }



        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Yield_' . $header->salesorder_code;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }



    public function getInvoiceList()
    {

	$status_arr = array("VOID","FULL_RETURN");
        $this->db->select('tbl_invoice.invoice_id, tbl_invoice.invoice_code, tbl_vendor.company as vendor_name');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id', 'Left');
	$this->db->where_not_in('tbl_invoice.status',$status_arr);
        $result = $this->db->get('tbl_invoice')->result_array();

        $records = array();

        foreach ($result as $rowValue) {
            $records[] = array(
                "invoice_id" => $rowValue['invoice_id'],
                "invoice_code" => $rowValue['invoice_code'],
                "vendor_name" => $rowValue['vendor_name'],
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getInvoiceYieldExcel()
    {

        $invoice_id = $this->input->get('invoice_id');

        if (empty($invoice_id) || (int)$invoice_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Invoice yield report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A5:J5')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1:A3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('B1:B3')->getFont()->setBold(true)->setSize(12);

        $this->db->select('tbl_invoice.invoice_id, tbl_invoice.salesorder_id, tbl_invoice.invoice_code, tbl_invoice.CREATION_DATE, tbl_vendor.company as vendor_name');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id', 'Left');
        $header = $this->db->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();

        $total_discount = $this->db->get_where("tbl_salesorder", array("salesorder_id"=>$header->salesorder_id))->row()->discount_amount;
        
        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('Customer Name');
        $objSheet->getCell('A2')->setValue('Invoice No');
        $objSheet->getCell('A3')->setValue('Date');

        //Header Values
        $objSheet->getCell('B1')->setValue($header->vendor_name);
        $objSheet->getCell('B2')->setValue($header->invoice_code);
        $objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A5')->setValue('INWARD ID');
        $objSheet->getCell('B5')->setValue('Device Name');
        $objSheet->getCell('C5')->setValue('SKU');
        $objSheet->getCell('D5')->setValue('Cost Price');
        $objSheet->getCell('E5')->setValue('Exempt Value');
        $objSheet->getCell('F5')->setValue('Taxble Amount');
        $objSheet->getCell('G5')->setValue('Discount');
        $objSheet->getCell('H5')->setValue('Total Taxable Value');
        $objSheet->getCell('I5')->setValue('Margin');
        $objSheet->getCell('J5')->setValue('Margin (%)');

        $result = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_YIELD_VIEW')->result_array();
        $invoice_qty = count($result);
        if($total_discount > 0){
            $device_discount = $total_discount / $invoice_qty ;
            $discount_excl_tax = ($device_discount * 100) / 118 ;
        } else {
            $discount_excl_tax = 0;
        }
        if (!empty($result)) {
            $rowCount = 6;
            $total_cost_price = 0;
            $total_sale_price = 0;
            $total_exempt_amount = 0;
            $total_taxable_amount = 0;
            $total_taxable_value = 0;
            foreach ($result as $rowValue) {
                $cost_price = $rowValue['cost_price'];
                $exempt_amount = $rowValue['exempt_amount'];
                $taxable_amount = $rowValue['taxable_amount'];
                $sale_price = $rowValue['sale_price'];
                $discount = number_format((float)$discount_excl_tax, 2, '.', '');
                $taxable_value = $sale_price - $discount;
                $margin = $taxable_value - $cost_price;
                $margin_perc = ($margin / $sale_price) * 100;

                $total_cost_price += $cost_price;
                $total_sale_price += $sale_price;
                $total_exempt_amount += $exempt_amount;
                $total_taxable_amount += $taxable_amount;
                $total_taxable_value += $taxable_value;


                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $rowValue['device_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['device_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['SKU']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $cost_price);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $exempt_amount);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $taxable_amount);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $discount);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $taxable_value);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $margin);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, sprintf('%.2f', $margin_perc));

                $rowCount++;
            }
            $objSheet->getStyle('D' . $rowCount . ':J' . $rowCount)->getFont()->setBold(true)->setSize(10);
            $total_margin = $total_sale_price - $total_cost_price;
            $total_margin_perc = ($total_margin / $total_sale_price) * 100;

            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $total_cost_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $total_exempt_amount);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $total_taxable_amount);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $total_taxable_value);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $total_margin);
            $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, sprintf('%.2f', $total_margin_perc));
        }



        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Yield_' . $header->invoice_code;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

    public function getVendorYieldExcel()
    {

        $vendor_id = $this->input->get('vendor_id');

        if (empty($vendor_id) || (int)$vendor_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Customer-wise Yield report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A3:I3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1:B1')->getFont()->setBold(true)->setSize(12);

        $header = $this->db->select('company as vendor_name, vendor_code')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('Customer Name');

        //Header Values
        $objSheet->getCell('B1')->setValue($header->vendor_name);
        //$objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A3')->setValue('Date');
        $objSheet->getCell('B3')->setValue('Invoice No');
        $objSheet->getCell('C3')->setValue('INWARD ID');
        $objSheet->getCell('D3')->setValue('Device Name');
        $objSheet->getCell('E3')->setValue('SKU');
        $objSheet->getCell('F3')->setValue('Cost Price');
        $objSheet->getCell('G3')->setValue('Sale Price');
        $objSheet->getCell('H3')->setValue('Margin');
        $objSheet->getCell('I3')->setValue('Margin (%)');

        $start_date = $this->db->select('value')->where('config_key', 'insight_purchase_start_date')->get('tbl_config')->row()->value;

        $where_arr = array(
            "DATE(CREATION_DATE) >=" => $start_date,
            "vendor_id" => $vendor_id
        );
        $result = $this->db->where($where_arr)->get('INVOICE_YIELD_VIEW')->result_array();
        if (!empty($result)) {
            $rowCount = 4;
            $total_cost_price = 0;
            $total_sale_price = 0;
            foreach ($result as $rowValue) {
                $cost_price = $rowValue['cost_price'];
                $sale_price = $rowValue['sale_price'];

                $margin = $sale_price - $cost_price;
                $margin_perc = ($margin / $sale_price) * 100;

                $date = date('d-m-Y', strtotime($rowValue['CREATION_DATE']));

                $total_cost_price += $cost_price;
                $total_sale_price += $sale_price;

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $date);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['invoice_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['device_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $rowValue['device_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $rowValue['SKU']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $cost_price);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $sale_price);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $margin);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, sprintf('%.2f', $margin_perc));

                $rowCount++;
            }

            $objSheet->getStyle('F' . $rowCount . ':I' . $rowCount)->getFont()->setBold(true)->setSize(10);
            $total_margin = $total_sale_price - $total_cost_price;
            $total_margin_perc = ($total_margin / $total_sale_price) * 100;

            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $total_cost_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $total_sale_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $total_margin);
            $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, sprintf('%.2f', $total_margin_perc));
        }



        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Yield_' . $header->vendor_code;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

    public function getDateYieldExcel()
    {

        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if (empty($from_date) || empty($to_date)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_check_arr = explode('-', $from_date);
        $to_check_arr = explode('-', $to_date);

        if (!checkdate($from_check_arr[1], $from_check_arr[2], $from_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid From Date';
            echo json_encode($json);
            exit;
        }

        if (!checkdate($to_check_arr[1], $to_check_arr[2], $to_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid To Date';
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format,  with < 0 being in red color
        $currencyFormat = '#,#0.## \;[Red]-#,#0.## \';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Date-wise Yield report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A4:O4')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1:A2')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('B1:B2')->getFont()->setBold(true)->setSize(12);

        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('From Date');
        $objSheet->getCell('A2')->setValue('To Date');

        //Header Values
        $objSheet->getCell('B1')->setValue(date("d-m-Y", strtotime($from_date)));
        $objSheet->getCell('B2')->setValue(date("d-m-Y", strtotime($to_date)));

        // Table Header
        $objSheet->getCell('A4')->setValue('Date');
        $objSheet->getCell('B4')->setValue('Invoice No');
        $objSheet->getCell('C4')->setValue('Customer Name');
        $objSheet->getCell('D4')->setValue('Inward Id');
        $objSheet->getCell('E4')->setValue('Batch No');
        
        $objSheet->getCell('F4')->setValue('Category');
        $objSheet->getCell('G4')->setValue('Product Type');
        $objSheet->getCell('H4')->setValue('Sale Type');
        $objSheet->getCell('I4')->setValue('Warehouse');
        
        
        $objSheet->getCell('J4')->setValue('Device Name');
        $objSheet->getCell('K4')->setValue('SKU');
        $objSheet->getCell('L4')->setValue('Cost Price');
        $objSheet->getCell('M4')->setValue('Sale Price');
        $objSheet->getCell('N4')->setValue('Margin');
        $objSheet->getCell('O4')->setValue('Margin (%)');

        $where_arr = array(
            "DATE(CREATION_DATE) >=" => $from_date,
            "DATE(CREATION_DATE) <=" => $to_date,
            "status !=" => "VOID"
        );
        $result = $this->db->where($where_arr)->get('INVOICE_YIELD_VIEW')->result_array();
        if (!empty($result)) {

            $rowCount = 5;
            $total_cost_price = 0;
            $total_sale_price = 0;
            foreach ($result as $rowValue) {
                $cost_price = $rowValue['cost_price'];
                $sale_price = $rowValue['sale_price'];

                $margin = $sale_price - $cost_price;
                $margin_perc = ($margin / $sale_price) * 100;

                $date = date('d-m-Y', strtotime($rowValue['CREATION_DATE']));

                $total_cost_price += $cost_price;
                $total_sale_price += $sale_price;

                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $date);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['invoice_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['vendor_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $rowValue['device_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $rowValue['batch_no']);
                
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $rowValue['stock_type']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $rowValue['product_type']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $rowValue['saletype']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $rowValue['warehouse']);
                
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $rowValue['device_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $rowValue['SKU']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $cost_price);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $sale_price);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $margin);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, sprintf('%.2f', $margin_perc));

                $rowCount++;
            }
            $objSheet->getStyle('K' . $rowCount . ':O' . $rowCount)->getFont()->setBold(true)->setSize(10);
            $total_margin = $total_sale_price - $total_cost_price;
            $total_margin_perc = ($total_margin / $total_sale_price) * 100;

            $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $total_cost_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $total_sale_price);
            $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $total_margin);
            $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, sprintf('%.2f', $total_margin_perc));
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Yield_' . date('m-d-Y_hia');
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

    public function getYieldOfflineSalesorder()
    {

        $salesorder_id = $this->input->get('salesorder_id');
        $sale_price = 0;
        $taxable_amount = 0;
        $exempt_amount = 0;
        $cost_price = 0;
        $total_amount = 0;
        $quantity = 0;
        $total_tax = 0;
        $taxable_cat = TAXABLE_CATEGORY;
        if ($salesorder_id > 0) {
            $result = $this->db->where('salesorder_id', $salesorder_id)->get('YIELD_OFFLINE_SALESORDER_VIEW')->result_array();

            foreach ($result as $rowvalue) {
                $quantity++;

                if ($rowvalue['grnreport_id'] > 0) {
                    if (in_array($rowvalue['category'], $taxable_cat)) {
                        $total_amount += $rowvalue['sale_price'];
                        $sale_price += $rowvalue['sale_price'] / 1.18;
                        $cost_price += $rowvalue['unit_price'];

                        $tax = $rowvalue['sale_price'] - $rowvalue['sale_price'] / 1.18;
                        $total_tax += $tax;
                    } else {
                        $total_amount += $rowvalue['sale_price'];
                        $taxable_amount = ($rowvalue['sale_price'] - ($rowvalue['unit_price'] + $rowvalue["unit_price_tax"])) / 1.18;
                        $exempt_amount = $rowvalue['unit_price'] + $rowvalue["unit_price_tax"];
                        $cost_price += $rowvalue['unit_price'];

                        $sale_price += $taxable_amount + $exempt_amount;

                        $margin = $rowvalue['sale_price'] - ($rowvalue['unit_price'] + $rowvalue["unit_price_tax"]);

                        $tax = $margin - $taxable_amount;

                        if ($margin < 0) $margin = 0;

                        if ($exempt_amount > $rowvalue['sale_price']) {
                            $tax = 0;
                        }
                        $total_tax += $tax;
                    }
                    $salesorder_no = $rowvalue['salesorder_code'];
                    $vendor_name = $rowvalue['vendor_name'];
                    $salesorder_date = $rowvalue['CREATION_DATE'];
                    $insurance_amount = $rowvalue['insurance_amount'];
                    $freight_amount = $rowvalue['freight_amount'];
                    $tcs_amount = $rowvalue['tcs_amount'];
                }

                $discount = $rowvalue['discount_amount'];
                $device_sub_category = $rowvalue['device_sub_category'];
            }

            $sale_price_discount = $sale_price - $discount / 1.18;

            $total_tax = $total_tax - ($discount - $discount / 1.18);

            $yield_amount = $sale_price_discount - $cost_price;
            $yield_perc = $yield_amount / $sale_price_discount * 100;

            $price_collected = $total_amount + $freight_amount + $insurance_amount - $discount;
            $net_amount = $price_collected + $tcs_amount;
            $json["data"][] = array(
                "status" => 1,
                "salesorder_id" => $salesorder_id,
                "salesorder_no" => $salesorder_no,
                "vendor_name" => $vendor_name,
                "quantity" => $quantity,
                "total_amount" => sprintf("%.02f", $total_amount),
                "cost_price" => sprintf("%.02f", $cost_price),
                "sale_price" => sprintf("%.02f", $sale_price),
                "discount" => sprintf("%.02f", $discount),
                "sale_price_discount" => sprintf("%.02f", $sale_price_discount),
                "tax_amount" => sprintf("%.02f", $total_tax),
                "yield_amount" => sprintf("%.02f", $yield_amount),
                "yield_perc" => sprintf("%.02f", $yield_perc),
                "date" => $salesorder_date,
                "price_collected" => sprintf("%.02f", $price_collected),
                "tcs_amount" => sprintf("%.02f", $tcs_amount),
                "net_amount" => sprintf("%.02f", $net_amount),
                "device_sub_category" => $device_sub_category
            );
            //$json['result'] = array(
              //  "price_collected" => $price_collected,
                //"tcs_amount" => $tcs_amount,
                //"net_amount" => $net_amount
            //);
            echo json_encode($json);
            exit;
        }
        $json['status'] = 0;
        echo json_encode($json);
        exit;
    }

    public function getYieldOnlineSalesOrder()
    {
        $salesorder_id = $this->input->get('salesorder_id');

        if (empty($salesorder_id) || (int)$salesorder_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('salesorder_id', $salesorder_id)->get('SO_YIELD_REPORTS_VIEW')->result_array();
        if (!empty($result)) {
            $total_cost_price = 0;
            $total_sale_price = 0;
            $quantity = 0;
            $total_amount = 0;
            foreach ($result as $rowValue) {
                $cost_amount = $rowValue['cost_price'] * $rowValue['quantity'];
                $sale_amount = $rowValue['sale_price_no_tax'] * $rowValue['quantity'];

                $total_cost_price += $cost_amount;
                $total_sale_price += $sale_amount;
                $quantity += $rowValue['quantity'];
                $total_amount += $rowValue['amount'];
            }
        } else {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $yield_amount = $total_sale_price - $total_cost_price;
        $yield_perc = $yield_amount / $total_sale_price * 100;

        $this->db->select('tbl_salesorder.salesorder_id, tbl_salesorder.salesorder_code, tbl_salesorder.CREATION_DATE, tbl_vendor.company as vendor_name');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_salesorder.vendor_id', 'Left');
        $header = $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

        $json["data"][] = array(
            "status" => 1,
            "salesorder_id" => $salesorder_id,
            "salesorder_no" => $header->salesorder_code,
            "vendor_name" => $header->vendor_name,
            "quantity" => $quantity,
            "total_amount" => $total_amount,
            "cost_price" => $total_cost_price,
            "sale_price" => $total_sale_price,
            "yield_amount" => $yield_amount,
            "yield_perc" => $yield_perc,
            "date" => date('d-m-Y', strtotime($header->CREATION_DATE))
        );
        echo json_encode($json);
        exit;
    }

    public function getYieldInvoice()
    {
        $invoice_id = $this->input->get('invoice_id');

        if (empty($invoice_id) || (int)$invoice_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $result = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_YIELD_VIEW')->result_array();
        if (!empty($result)) {
            $total_cost_price = 0;
            $total_sale_price = 0;
            $total_amount = 0;
            $quantity = 0;
            foreach ($result as $rowValue) {
                $cost_price = $rowValue['cost_price'];
                $sale_price = $rowValue['sale_price'];

                $margin = $sale_price - $cost_price;
                $margin_perc = ($margin / $sale_price) * 100;

                $total_cost_price += $cost_price;
                $total_sale_price += $sale_price;
                $total_amount + $rowValue['price'];
                $category = $rowValue['category'];

                $quantity++;
            }
        }
        $yield_amount = $total_sale_price - $total_cost_price;
        $yield_perc = $yield_amount / $total_sale_price * 100;

        $this->db->select('tbl_invoice.invoice_id, tbl_invoice.invoice_code, tbl_invoice.CREATION_DATE, tbl_vendor.company as vendor_name');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id', 'Left');
        $header = $this->db->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();

        $json["data"][] = array(
            "status" => 1,
            "invoice_id" => $invoice_id,
            "invoice_no" => $header->invoice_code,
            "vendor_name" => $header->vendor_name,
            "category" => $category,
            "quantity" => $quantity,
            "total_amount" => $total_amount,
            "cost_price" => $total_cost_price,
            "sale_price" => $total_sale_price,
            "yield_amount" => $yield_amount,
            "yield_perc" => $yield_perc,
            "date" => date('d-m-Y', strtotime($header->CREATION_DATE))
        );
        echo json_encode($json);
        exit;
    }

    public function getYieldInvoiceSummary()
    {
        $invoice_id = $this->input->get('invoice_id');

        if (empty($invoice_id) || (int)$invoice_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $result = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_YIELD_VIEW')->result_array();
        if (!empty($result)) {
            $total_cost_price = 0;
            $total_sale_price = 0;
            $total_amount = 0;
            $quantity = 0;
            foreach ($result as $rowValue) {
                $cost_price = $rowValue['cost_price'];
                $sale_price = $rowValue['sale_price'];

                $margin = $sale_price - $cost_price;
                $margin_perc = ($margin / $sale_price) * 100;

                $total_cost_price += $cost_price;
                $total_sale_price += $sale_price;
                $total_amount + $rowValue['price'];
                $category = $rowValue['category'];

                $quantity++;
            }
        }
        $yield_amount = $total_sale_price - $total_cost_price;
        $yield_perc = $yield_amount / $total_sale_price * 100;

        $this->db->select('tbl_invoice.invoice_id, tbl_invoice.invoice_code, tbl_invoice.CREATION_DATE, tbl_vendor.company as vendor_name');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id', 'Left');
        $header = $this->db->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();

        $json["data"][] = array(
            "status" => 1,
            "invoice_id" => $invoice_id,
            "invoice_no" => $header->invoice_code,
            "vendor_name" => $header->vendor_name,
            "category" => $category,
            "quantity" => $quantity,
            "total_amount" => $total_amount,
            "cost_price" => $total_cost_price,
            "sale_price" => $total_sale_price,
            "yield_amount" => $yield_amount,
            "yield_perc" => $yield_perc,
            "date" => date('d-m-Y', strtotime($header->CREATION_DATE))
        );
        echo json_encode($json);
        exit;
    }
}
