<?php
class Worksheet extends CI_Controller
{

    public function __construct()
    {

        parent::__construct();
        $this->load->model('worksheet_model');
        $this->load->model('login_model');

        if (!$this->login_model->is_logged_in()) {
            redirect(base_url(), 'location', 301);
        }
    }

    public function manage_worksheet($active = 0)
    {

        if ($active > 0) {

            $data['active'] = $active;
        } else {

            $data['active'] = 1;
        }
        $data['title'] = 'WORKSHEET LIST';
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data);
    }

    public function getWorksheetList()
    {

        $status = $this->input->get('status');
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];
        $role_id = $user_data['role_id'];
        $role_name = $this->db->select('role_name')->from('tbl_trg_um_roles')
            ->where('role_id', $role_id)->get()->row()->role_name;

        $data = array();
        if ($role_name == "TRIAGE_TECHNICIAN") {

            $res = $this->db->select('*')->from('WORKSHEET_LIST_VIEW') // Total worksheet list
                ->where(array("status" => $status, "assigned_user" => $user_id, "flag" => 1))
                ->order_by('created_date', 'desc')
                ->group_by('worksheet_id')
                ->get()->result();
        } else {

            $res = $this->db->select('*')->from('WORKSHEET_LIST_VIEW') // Total worksheet list
                ->where(array("status" => $status, "flag" => 1))
                ->order_by('created_date', 'desc')
                ->group_by('worksheet_id')
                ->get()->result();
        }
        // $res = $this->db->select('*')->from('WORKSHEET_LIST_VIEW') // Total worksheet list
        //     ->where(array("status" => $status, "flag" => 1))
        //     ->order_by('created_date', 'desc')
        //     ->group_by('worksheet_id')
        //     ->get()->result();

        if (empty($res)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        foreach ($res as $value) {
            $worksheet_id = $value->worksheet_id;
            $assigned_user = $value->username;
            $sub_status = $value->sub_status;

            if ($sub_status == 'PARTS_FOR_PENDING' || $sub_status == 'L4_PENDING' || $sub_status == 'SPARE_PENDING' || $sub_status == 'IN_PROGRESS' || $sub_status == 'SPARE_ALLOCATE' || $sub_status == 'REBOOT_ISSUE' || $sub_status == 'IMEI_REPAIR') {
                $sub_status = str_replace('_', ' ', $sub_status);
            } elseif ($sub_status == 'IN_WARRANTY' || $sub_status == 'RE_OPEN') {
                $sub_status = str_replace('_', '-', $sub_status);
            }
            $assigned_by = $value->assigned_by;
            $created_by = $this->db->get_where('tbl_trg_users', array("user_id" => $assigned_by))->row()->username;
            $check_worksheet = $this->db->get_where('tbl_trg_worksheet_spare_item', array("worksheet_id" => $worksheet_id))->num_rows();
            if ($check_worksheet > 0) {
                $case = 1;
            } else {
                $case = 0;
            }
            $data[] = array(
                'remarks' => $value->remark,
                'worksheet_id' => $value->worksheet_id,
                'worksheet_no' => $value->worksheet_no,
                'device_id' => $value->device_id,
                'device_name' => $value->device_name,
                'batch_no' => $value->batch_no,
                'grnreport_id' => $value->grnreport_id,
                'device_condition' => $value->device_condition,
                'issue_type' => $value->issue_type,
                'assigned_user' => $assigned_user,
                'assigned_by' => $created_by,
                'sub_status' => $sub_status,
                'status' => $status,
                'level_type' => $value->name,
                'created_date' => $value->created_date,
                'updated_date' => $value->updated_date,
                'certification_remarks' => $value->remark,
                'case' => $case
            );
        }
        //echo "<pre>"; print_r($data); echo "</pre>"; exit;
        $result = $data;
        if (empty($result)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        $json['data'] = $result;
        echo json_encode($json);
        exit;
    }

    public function getCompletedWorksheetList()
    {

        $device_id = $this->input->get('device_id');
        $data = array();
        //$device_id = "TD18100003586";
        $res = $this->db->select('*')->from('WORKSHEET_LIST_VIEW') // Total worksheet list
            ->where(array("device_id" => $device_id, "status" => "COMPLETE", "flag" => 1))
            ->order_by('created_date', 'desc')
            ->group_by('worksheet_id')
            ->get()->result();

        if (empty($res)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        foreach ($res as $value) {
            $worksheet_id = $value->worksheet_id;
            $assigned_user = $value->username;
            $sub_status = $value->sub_status;

            if ($sub_status == 'PARTS_FOR_PENDING' || $sub_status == 'L4_PENDING' || $sub_status == 'SPARE_PENDING' || $sub_status == 'IN_PROGRESS' || $sub_status == 'SPARE_ALLOCATE' || $sub_status == 'REBOOT_ISSUE' || $sub_status == 'IMEI_REPAIR') {
                $sub_status = str_replace('_', ' ', $sub_status);
            } elseif ($sub_status == 'IN_WARRANTY' || $sub_status == 'RE_OPEN') {
                $sub_status = str_replace('_', '-', $sub_status);
            }
            $assigned_by = $value->assigned_by;
            $created_by = $this->db->get_where('tbl_trg_users', array("user_id" => $assigned_by))->row()->username;
            $check_worksheet = $this->db->get_where('tbl_trg_worksheet_spare_item', array("worksheet_id" => $worksheet_id))->num_rows();
            if ($check_worksheet > 0) {
                $case = 1;
            } else {
                $case = 0;
            }
            $data[] = array(
                'remarks' => $value->remark,
                'worksheet_id' => $value->worksheet_id,
                'worksheet_no' => $value->worksheet_no,
                'device_id' => $value->device_id,
                'device_name' => $value->device_name,
                'grnreport_id' => $value->grnreport_id,
                'device_condition' => $value->device_condition,
                'issue_type' => $value->issue_type,
                'assigned_user' => $assigned_user,
                'assigned_by' => $created_by,
                'sub_status' => $sub_status,
                'level_type' => $value->name,
                'created_date' => $value->created_date,
                'updated_date' => $value->updated_date,
                'certification_remarks' => $value->remark,
                'case' => $case
            );
        }
        //echo "<pre>"; print_r($data); echo "</pre>"; exit;
        $result = $data;
        if (empty($result)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        $json['data'] = $result;
        echo json_encode($json);
        exit;
    }

    public function getDeviceRemarks()
    {

        $worksheet_id = $this->input->get('worksheet_id');
        $data = array();
        $res = $this->db->select('*')->from('WORKSHEET_REMARKS_VIEW') // Get worksheet remarks
            ->where('worksheet_id', $worksheet_id)->order_by('remarks_id', 'desc')
            ->get()
            ->result();
        if (empty($res)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        foreach ($res as $value) {
            $assigned_by = $value->assigned_by;
            $created_by = $this->db->get_where('tbl_trg_users', array("user_id" => $assigned_by))
                ->row()->username;
            $data[] = array(
                'remarks' => $value->remarks,
                'assigned_by' => $created_by,
                'created_date' => $value->created_date,
                'level_type' => $value->name,
                'issue_type' => $value->issue_type,
                'assigned_user' => $value->username
            );
        }
        $result = $data;
        if (empty($result)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        $json['data'] = $result;
        echo json_encode($json);
        exit;
    }

    public function updateWorksheetForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 4;
            $data['title'] = 'UPDATE WORKSHEET';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function allocateWorksheetForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 16;
            $data['title'] = 'ALLOCATE WORKSHEET';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function getDeviceInfo()
    {

        $worksheet_id = $this->input->get('worksheet_id');

        if ((int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $result = $this->worksheet_model->getDeviceInfo($worksheet_id);

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['data'] = $result;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function changeWorksheetStatus()
    {

        $worksheet_id = $this->input->get('worksheet_id');

        if ((int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];
        $remarks_row = $this->db->get_where('tbl_trg_worksheet_remarks', array("worksheet_id" => $worksheet_id, "flag" => "1"))->row();
        $level_type = $remarks_row->level_type;
        $issue_type = $remarks_row->issue_type;
        $update = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', array('status' => 'IN_PROGRESS', 'sub_status' => 'IN_PROGRESS'));
        if ($update) {
            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_by" => $user_id,
                "assigned_user" => $user_id,
                "level_type" => $level_type,
                "issue_type" => $issue_type,
                "remarks" => "Work Started",
                "status" => "IN_PROGRESS"
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
        }
        if (!($update)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateWorksheet()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];
        $service_status = $data["service_status"];
        $pending_spare_ids = $data["spare_id"];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($service_status == "PARTS_FOR_PENDING") {

            $db_spareIds = [];
            $spare_ids = $this->db->get_where('tbl_trg_worksheet_spare_item', array('worksheet_id =' => $worksheet_id))->result_array();
            foreach ($spare_ids as $key => $value) {
                $spare[] = $value['worksheet_spare_item_id'];
                $spareIdArr = ["spare_id" => $spare[$key]];
                $db_spareIds[] = $spareIdArr;
            }

            $rejectIdsArray = array();
            foreach ($db_spareIds as $data1) {

                $duplicate = false;
                foreach ($pending_spare_ids as $data2) {
                    if ($data1['spare_id'] === $data2['spare_id']) $duplicate = true;
                }

                if ($duplicate === false) $rejectIdsArray[] = $data1;
            }
            $record = array(
                //"updated_by" => 10,
                "updated_by" => $user_id,
                "remarks" => $data['remarks']
            );
            $length = count($pending_spare_ids);

            for ($i = 0; $i < $length; $i++) {
                $this->db->where('worksheet_spare_item_id', $pending_spare_ids[$i]['spare_id'])->update('tbl_trg_worksheet_spare_item', $record);
            }

            $length_1 = count($rejectIdsArray);
            if ($length_1 > 0) {
                $row_data = array(
                    //"updated_by" => 10,
                    "updated_by" => $user_id,
                    "status" => "INACTIVE",
                    "remarks" => $data['remarks']
                );
                for ($i = 0; $i < $length_1; $i++) {
                    $this->db->where('worksheet_spare_item_id', $rejectIdsArray[$i]['spare_id'])->update('tbl_trg_worksheet_spare_item', $row_data);
                }
            }
        }
        if ($service_status == "HOLD") {
            
            $update_worksheet = array(

                "device_condition" => $data['device_condition'],
                "status" => "PENDING",
                "sub_status" => $data['hold_status'],
                "pending_reason" => $data['pending_reason']
            );
        } else{

            $update_worksheet = array(

                "device_condition" => $data['device_condition'],
                "status" => "PENDING",
                "sub_status" => $data['service_status'],
                "pending_reason" => $data['pending_reason']
            );
        }
        $updateAssign = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', $update_worksheet);

        if ($updateAssign) {
            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                //"assigned_by" => $data['previous_user'],
                "assigned_by" => $user_id,
                "assigned_user" => 10, // triage manager
                "level_type" => 1,
                "status" => "PENDING",
                "issue_type" => $data['issue_type'],
                "remarks" => $data['remarks']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);

            if ($service_status == "PARTS_FOR_PENDING") {

                $spare_data = $data['spare_info'];
                $totalCnt = count($spare_data);
                if ($totalCnt > 1) {
                    $spare_name = [];
                    $spare_quantity = [];
                    $spare_color = [];
                    $spare_price = [];
                    $array_data = [];
                    foreach ($spare_data as $key => $val) {
                        $spare_name[] = $val['spare_name'];
                        $spare_quantity[] = $val['spare_quantity'];
                        $spare_color[] = $val['spare_color'];
                        $spare_price[] = $val['spare_price'];
                        $spareArr = [
                            "worksheet_id" => $worksheet_id,
                            "spare_name" => $spare_name[$key],
                            "color" => $spare_color[$key],
                            "price" => $spare_price[$key],
                            "spare_quantity" => $spare_quantity[$key],
                            //"created_by" => $data['previous_user'],
                            "created_by" => $user_id,
                            "remarks" => $data['remarks'],
                            "status" => "PENDING"

                        ];
                        $array_data[] = $spareArr;
                    }
                    $this->db->insert_batch('tbl_trg_worksheet_spare_item', $array_data);
                } else if ($totalCnt == 1) {
                    $singleRecord = array(

                        "worksheet_id" => $worksheet_id,
                        "spare_name" => $spare_data[0]['spare_name'],
                        "spare_quantity" => $spare_data[0]['spare_quantity'],
                        "color" => $spare_data[0]['spare_color'],
                        "price" => $spare_data[0]['spare_price'],
                        //"created_by" => $data['previous_user'],
                        "created_by" => $user_id,
                        "remarks" => $data['remarks'],
                        "status" => "PENDING"
                    );
                    $this->db->insert('tbl_trg_worksheet_spare_item', $singleRecord);
                }
            }
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function reAssignWorksheet($device_id = 0)
    {

        if (empty($device_id)) {
            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {
            $worksheet_id = $this->db->order_by('worksheet_id', 'desc')->limit(1)->get_where('tbl_trg_worksheet', array("device_id" => $device_id))->row()->worksheet_id;
            $data['active'] = 2;
            $data['title'] = 'RE ASSIGN WORKSHEET';
            $data['update_device_id'] = $device_id;
            $data['re_assign_workheet_id'] = $worksheet_id;
        }

        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function getDeviceTotalInfo()
    {

        $device_id = $this->input->get('device_id');

        if ($device_id == '') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $result = $this->db->get_where('ynewco_erp.tbl_grnreport', array('nhdin =' => $device_id))->row();
        $device_data = $this->db->order_by('worksheet_id', 'desc')->limit(1)->get_where('tbl_trg_worksheet', array('device_id =' => $device_id))->row();
        $warehouse_location = $result->warehouse;
        $warehouse = "SLOYD-" . $warehouse_location;
        $worksheet_status = $device_data->sub_status;
        $status = '';
        if ($worksheet_status == "IN_PROGRESS") {
            $status = "IN PROGRESS";
        } elseif ($worksheet_status == "PARTS_FOR_PENDING") {
            $status = "PARTS FOR PENDING";
        }
        // elseif ($worksheet_status == "BER_PENDING")
        // {
        //     $status = "BER PENDING";
        // }
        elseif ($worksheet_status == "SPARE_ALLOCATE") {
            $status = "SPARE ALLOCATE";
        } elseif ($worksheet_status == "SPARE_PENDING") {
            $status = "SPARE PENDING";
        } elseif ($worksheet_status == "IN_WARRANTY") {
            $status = "IN-WARRANTY";
        } elseif ($worksheet_status == "RE_OPEN") {
            $status = "RE-OPEN";
        } elseif ($worksheet_status == "REBOOT_ISSUE") {
            $status = "REBOOT ISSUE";
        } elseif ($worksheet_status == "IMEI_REPAIR") {
            $status = "IMEI REPAIR";
        } elseif ($worksheet_status == "L4_PENDING") {
            $status = "L4 PENDING";
        } else {
            $status = $worksheet_status;
        }

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['data'] = array(

            "product_brand" => $result->product_brand,
            "device_name" => $result->device_name,
            "warehouse" => $warehouse,
            "SKU" => $result->SKU,
            "ram" => $result->ram,
            "rom" => $result->rom,
            "worksheet_id" => $device_data->worksheet_id,
            "worksheet_no" => $device_data->worksheet_no,
            "device_id" => $device_data->device_id,
            "status" => $status,
            "device_condition" => $device_data->device_condition,
            "service_type" => $device_data->issue_type,
            "remark" => $result->checked_by,
            "worksheet_status" => $worksheet_status
        );
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function reAssignToTechnician()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];
        $pending_spare_ids = $data['spare_data'];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $db_spareIds = [];
        $spare_ids = $this->db->get_where('tbl_trg_worksheet_spare_item', array('worksheet_id =' => $worksheet_id))->result_array();
        foreach ($spare_ids as $key => $value) {
            $spare[] = $value['worksheet_spare_item_id'];
            $spareIdArr = ["spare_id" => $spare[$key]];
            $db_spareIds[] = $spareIdArr;
        }

        $rejectIdsArray = array();
        foreach ($db_spareIds as $data1) {

            $duplicate = false;
            foreach ($pending_spare_ids as $data2) {
                if ($data1['spare_id'] === $data2['spare_id']) $duplicate = true;
            }

            if ($duplicate === false) $rejectIdsArray[] = $data1;
        }
        $record = array(
            //"updated_by" => 10,
            "updated_by" => $user_id,
            "remarks" => $data['remarks'],
        );
        $length = count($pending_spare_ids);

        for ($i = 0; $i < $length; $i++) {
            $this->db->where('worksheet_spare_item_id', $pending_spare_ids[$i]['spare_id'])->update('tbl_trg_worksheet_spare_item', $record);
        }

        $length_1 = count($rejectIdsArray);
        if ($length_1 > 0) {
            $row_data = array(
                //"updated_by" => 10,
                "updated_by" => $user_id,
                "status" => "INACTIVE",
            );
            for ($i = 0; $i < $length_1; $i++) {
                $this->db->where('worksheet_spare_item_id', $rejectIdsArray[$i]['spare_id'])->update('tbl_trg_worksheet_spare_item', $row_data);
            }
        }
        $re_assig_device = array(

            "status" => "ASSIGNED",
            "issue_type" => $data['service_type'],
            "sub_status" => "ASSIGNED"
        );
        $this->db->where('worksheet_id', $worksheet_id);
        $update_task = $this->db->update('tbl_trg_worksheet', $re_assig_device);

        if ($update_task) {

            $this->db->where('worksheet_id', $worksheet_id);
            $update_task = $this->db->update('tbl_trg_worksheet_remarks', array("flag" => 0));

            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => $data['assigned_user'],
                //"assigned_by" => 10, // Triage Manager
                "assigned_by" => $user_id, // Triage Manager
                "level_type" => $data['level_type'],
                "status" => "ASSIGNED",
                "issue_type" => $data['service_type'],
                "remarks" => $data['remarks']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
            $spareId_length = count($pending_spare_ids);
            if ($spareId_length > 0) {
                for ($i = 0; $i < $spareId_length; $i++) {
                    $this->db->where('worksheet_spare_allocation_id', $pending_spare_ids[$i]['spare_id'])->update('tbl_trg_worksheet_spare_allocation', array("user_id" => $user_id));
                }
            }
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateWorksheetStatusForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 3;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function actionWorksheetStatusForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 14;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function reOpenWorksheetForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 13;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function updateWorksheetServiceStatus()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $row_sub_status = $this->db->get_where('tbl_trg_worksheet', array("worksheet_id" => $worksheet_id))->row()->sub_status;
        if ($row_sub_status == "BER") {

            $sub_status = "BER";
        } elseif ($row_sub_status == "IN_WARRANTY") {

            $sub_status = $row_sub_status;
        } elseif ($row_sub_status == "REBOOT_ISSUE") {

            $sub_status = $row_sub_status;
        } elseif ($row_sub_status == "IMEI_REPAIR") {

            $sub_status = $row_sub_status;
        } elseif ($row_sub_status == "LOCKED") {

            $sub_status = $row_sub_status;
        } elseif ($row_sub_status == "DEFERRAL") {

            $sub_status = "RETAIN";
        } 
        // elseif ($row_sub_status == "HOLD") {

        //     $sub_status = "RETAIN";
        // } 
        else {
            $sub_status = $data['status'];
        }

        if ($sub_status == "RE_OPEN") {

            $update_worksheet = array(

                "status" => "PENDING",
                "sub_status" => $sub_status
            );
        } elseif ($sub_status == "REBOOT_ISSUE" || $sub_status == "IMEI_REPAIR" || $sub_status == "LOCKED") {

            $update_worksheet = array(

                "status" => "OS_PENDING",
                "sub_status" => $sub_status
            );
        } else {

            $spare_data = $this->db->get_where('tbl_trg_worksheet_spare_allocation',array("worksheet_id"=>$worksheet_id))
                ->result();
                foreach($spare_data as $spare_usage){
                    $spare_status = $spare_usage->status;
                    $spare_item_id = $spare_usage->spare_item_id;
                    if($spare_status == "UNUSED"){
                        $status = "IN_STOCK";
                    } else{
                        $status = $spare_usage->status;
                    }
                    $this->db->where('spare_item_id',$spare_item_id )->update('tbl_trg_spare_inventory_item',array("status"=>$status));
                }
             $update_worksheet = array(

                "issue_type" => $data['issue_type'],
                "status" => $sub_status,
                "sub_status" => $sub_status
            );
        }
        $completeWorksheet = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', $update_worksheet);

        if ($completeWorksheet) {

            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => 4,
                //"assigned_by" => 10,
                "assigned_by" => $user_id,
                "level_type" => 1,
                "status" => $sub_status,
                "remarks" => $data['remark'],
                "issue_type" => $data['issue_type']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function reOpenWorksheetServiceStatus()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $update_worksheet = array(

            "status" => "PENDING",
            "sub_status" => $data['status']
        );

        $completeWorksheet = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', $update_worksheet);

        if ($completeWorksheet) {

            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => 10,
                //"assigned_by" => 10,
                "assigned_by" => $user_id,
                "level_type" => 1,
                "status" => "PENDING",
                "remarks" => $data['remark']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateWorksheetStatusToPFPForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 5;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function getSpareData()
    {
        $worksheet_id = $this->input->get('worksheet_id');
        $status = "ALLOCATED";

        if ((int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $service_status = $this->db->get_where('tbl_trg_worksheet', array("worksheet_id" => $worksheet_id))->row()->status;
        $result = $this->worksheet_model->displaySpareData($worksheet_id);
        if ($service_status == 'PARTS_FOR_PENDING' || $service_status == 'SPARE_PENDING' || $service_status == 'SPARE_ALLOCATE' || $service_status == 'HOLD' || $service_status == 'RETAIN' || $service_status == 'BER' || $service_status == 'IN_WARRANTY' || $service_status == 'REPAIRED' || $service_status == 'COMPLETE') {

            $res = $this->db->select('*')->from('WORKSHEET_ALLOCATED_SPARES_VIEW')
                ->where('worksheet_id', $worksheet_id)->where('status', $status)->get()->result();

            $spare_data = $this->db->select('*')->from('WORKSHEET_SPARE_DATA_VIEW')
                ->where('worksheet_id', $worksheet_id)->where('status', $status)->get()->result();
        } else if ($service_status == 'ASSIGNED' || $service_status == 'IN_PROGRESS' || $service_status == 'PENDING' || $service_status == 'REVIEW') {

            $res = $this->db->select('*')->from('WORKSHEET_ALLOCATED_SPARES_VIEW')
                ->where('worksheet_id', $worksheet_id)
                ->where_not_in('status', array("REJECTED"))
                ->get()->result();

            $spare_data = $this->db->select('*')->from('WORKSHEET_SPARE_DATA_VIEW')
                ->where('worksheet_id', $worksheet_id)
                //->where_in('status', array("ALLOCATED","CONSUMED"))
                ->get()->result();
        }

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['data'] = $result;
        $json['assigned_spares'] = $res;
        $json['spare_data'] = $spare_data;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function displaySpareData()
    {

        $worksheet_id = $this->input->get('worksheet_id');
        if ((int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $service_status = $this->db->get_where('tbl_trg_worksheet', array("worksheet_id" => $worksheet_id))->row()->status;
        $result = $this->worksheet_model->displaySpareData($worksheet_id);
        if ($service_status == 'PARTS_FOR_PENDING' || $service_status == 'SPARE_PENDING' || $service_status == 'SPARE_ALLOCATE' || $service_status == 'HOLD' || $service_status == 'RETAIN' || $service_status == 'BER' || $service_status == 'IN_WARRANTY' || $service_status == 'REPAIRED' || $service_status == 'COMPLETE') {
            $res = $this->db->select('*')->from('WORKSHEET_ALLOCATED_SPARES_VIEW')
                ->where('worksheet_id', $worksheet_id)->get()->result();

            $spare_data = $this->db->select('*')->from('WORKSHEET_SPARE_DATA_VIEW')
                ->where('worksheet_id', $worksheet_id)->get()->result();
        } elseif ($service_status == 'ASSIGNED' || $service_status == 'IN_PROGRESS' || $service_status == 'PENDING' || $service_status == 'REVIEW') {
            $res = $this->db->select('*')->from('WORKSHEET_ALLOCATED_SPARES_VIEW')
                ->where('worksheet_id', $worksheet_id)
                //->where_in('status', array("ALLOCATED","CONSUMED"))
                ->get()->result();

            $spare_data = $this->db->select('*')->from('WORKSHEET_SPARE_DATA_VIEW')
                ->where('worksheet_id', $worksheet_id)
                //->where_in('status', array("ALLOCATED","CONSUMED"))
                ->get()->result();
        }

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['data'] = $result;
        $json['assigned_spares'] = $res;
        $json['spare_data'] = $spare_data;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateSpareForm($spare_id = 0)
    {

        if (empty($spare_id) || (int)$spare_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 7;
            $data['title'] = 'UPDATE SPARE';
            $data['update_spare_id'] = $spare_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function assignWorksheetToWarehouse()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        $spare_id = $data['spare_id'];
        if (empty($data) || (int)$data['spare_id'] <= 0) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $record = array(

            "created_by" => 2,
            "status" => $data['status'],
            "remarks" => $data['remarks'],
        );

        $update = $this->db->where(array('spare_id' => $spare_id))->update('tbl_trg_worksheet_spare_item', $record);
        if ($update) {

            $spare_data = $this->db->group_by('worksheet_id')->get_where('tbl_trg_worksheet_spare_item', array('spare_id =' => $spare_id))->row();
            $spare_qnty = $spare_data->spare_quantity;
            $spare_required_no = $spare_data->required_spare_no;
            $worksheet_id = $spare_data->worksheet_id;
            $add_count = $spare_required_no + $spare_qnty;
            $new_array = array(
                "required_spare_no" => $add_count
            );
            $this->db->where(array('worksheet_id' => $worksheet_id))->update('tbl_trg_worksheet_spare_item', $new_array);
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
        exit;
    }

    public function updateTaskForm($task_id = 0)
    {

        if (empty($task_id) || (int)$task_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'TASKLIST';
        } else {
            $data['active'] = 4;
            $data['title'] = 'UPDATE TASK';
            $data['update_task_id'] = $task_id;
            $data['device_status'] = $this->task_model->getDeviceStatus($task_id);
        }
        $data['subview'] = $this->load->view('admin/task/manage_task', $data, true);
        $this->load->view('_layout_main', $data); //page load
    }

    public function updateWkTaskForm($task_id = 0)
    {

        if (empty($task_id) || (int)$task_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'TASKLIST';
        } else {

            $data['active'] = 5;
            $data['title'] = 'UPDATE TASK';
            $data['update_task_id'] = $task_id;
        }
        $data['subview'] = $this->load->view('admin/task/manage_task', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function getTotalTechniciansList()
    {

        $result = $this->db->get_where('tbl_trg_engineer', array('role_id =' => '2'))->result_array();

        if (!empty($result) && count($result) == 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function getTotalLevelList()
    {

        $result = $this->db->get_where('tbl_trg_dropdown', array('type =' => 'level'))->result_array();

        if (!empty($result) && count($result) == 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function getTotalSpareList()
    {

        $result = $this->db->get('tbl_trg_spare_type')->result_array();

        if (!empty($result) && count($result) == 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function getTotalDeviceId()
    {

        $result = $this->db->where(array("status" => "COMPLETE"))->group_by('device_id')->get('tbl_trg_worksheet')->result_array();

        if (!empty($result) && count($result) == 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function assignWarehouse($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 8;
            $data['title'] = 'ASSIGN WAREHOUSE';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data);
    }

    public function getSpareCretaedInfo()
    {

        $worksheet_id = $this->input->get('worksheet_id');

        if ((int)$worksheet_id <= 0) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $result = $this->worksheet_model->getCreatedSpareData($worksheet_id);

        if (empty($result)) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['data'] = $result;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function assignToWarehouse()
    {

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        $worksheet_id = $data['worksheet_id'];
        $approve_spare_ids = $data['spare_data'];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($data) || (int)$data['worksheet_id'] <= 0) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $db_spareIds = [];
        $spare_ids = $this->db->get_where('tbl_trg_worksheet_spare_item', array('worksheet_id =' => $worksheet_id))->result_array();
        foreach ($spare_ids as $key => $value) {
            $spare[] = $value['worksheet_spare_item_id'];
            $spareIdArr = ["spare_id" => $spare[$key]];
            $db_spareIds[] = $spareIdArr;
        }
        $rejectIdsArray = array();

        foreach ($db_spareIds as $data1) {

            $duplicate = false;
            foreach ($approve_spare_ids as $data2) {
                if ($data1['spare_id'] === $data2['spare_id']) $duplicate = true;
            }

            if ($duplicate === false) $rejectIdsArray[] = $data1;
        }
        $record = array(
            //"updated_by" => 10,
            "updated_by" => $user_id,
            "status" => $data['status'],
            "procurement_status" => "yes",
            "remarks" => $data['remarks'],
        );
        $length = count($approve_spare_ids);

        for ($i = 0; $i < $length; $i++) {
            $update = $this->db->where('worksheet_spare_item_id', $approve_spare_ids[$i]['spare_id'])->update('tbl_trg_worksheet_spare_item', $record);
        }

        $length_1 = count($rejectIdsArray);
        if ($length_1 > 0) {
            $row_data = array(
                //"updated_by" => 10,
                "updated_by" => $user_id,
                "status" => "REJECTED",
            );
            for ($i = 0; $i < $length_1; $i++) {
                $this->db->where(array(
                    'worksheet_spare_item_id' => $rejectIdsArray[$i]['spare_id'],
                    'status!=' => 'INACTIVE',
                ))->update('tbl_trg_worksheet_spare_item', $row_data);
            }
        }

        if ($update) {
            $this->db->where('worksheet_id', $worksheet_id);
            $this->db->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => 4,
                //"assigned_by" => 10, // triage manager
                "assigned_by" => $user_id, // triage manager
                "level_type" => 1,
                "status" => "SPARE_PENDING",
                "remarks" => $data['remarks'],
                "issue_type" => $data['issue_type']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
            $status = array(

                "status" => "SPARE_PENDING",
                "sub_status" => "SPARE_PENDING"
            );
            $this->db->where(array('worksheet_id' => $worksheet_id))->update('tbl_trg_worksheet', $status);
            $spare_idvalues = $this->db->get_where('tbl_trg_worksheet_spare_item', array('worksheet_id =' => $worksheet_id))->result();
            foreach ($spare_idvalues as $value) {
                $spare_id = $value->worksheet_spare_item_id;
                $spare_data = $this->db->group_by('worksheet_id')->get_where('tbl_trg_worksheet_spare_item', array(
                    'worksheet_spare_item_id =' => $spare_id,
                    'status =' => 'APPROVED'
                ))->row();
            }
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
        exit;
    }

    public function changeWorksheetStatusForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 9;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function changeWorksheetServiceStatus()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];
        $spare_data = $data["spare_data"];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $update_worksheet = array(

            //"status" => "PENDING",
            "status" => $data['status'],
            "sub_status" => $data['status'],
            "pending_reason" => $data['pending_reason']
        );

        $updateWorksheet = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', $update_worksheet);

        if ($updateWorksheet) {

            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => 10,
                //"assigned_by" => 10, // triage manager
                "assigned_by" => $user_id,
                "level_type" => 1,
                "status" => $data['status'],
                "remarks" => $data['remark']
            );

            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
            $length = count($spare_data);
            if ($length > 0) {
                for ($i = 0; $i < $length; $i++) {
                    $newArray = array(
                        "remarks" => $spare_data[$i]['spare_remarks'],
                        "user_id" => $user_id,
                        "status" => "REJECTED"
                    );
                    $this->db->where('worksheet_spare_allocation_id', $spare_data[$i]['spare_id'])->update('tbl_trg_worksheet_spare_allocation', $newArray);
                }

                $this->db->where(array("worksheet_id" => $worksheet_id, "status" => "ALLOCATED"))
                    ->update(
                        'tbl_trg_worksheet_spare_item',
                        array(
                            "status" => "APPROVED",
                            //"updated_by" => 10
                            "updated_by" => $user_id
                        )
                    );
            }
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function reAssignWorksheetToTechnician($device_id = 0)
    {

        if (empty($device_id)) {
            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {
            $worksheet_id = $this->db->order_by('worksheet_id', 'desc')->limit(1)->get_where('tbl_trg_worksheet', array("device_id" => $device_id))->row()->worksheet_id;
            $data['active'] = 10;
            $data['title'] = 'RE ASSIGN WORKSHEET';
            $data['update_device_id'] = $device_id;
            $data['re_assign_workheet_id'] = $worksheet_id;
        }

        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function returnWorksheetToWarehouseForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 11;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }

    public function updateSpareStatus()
    {

        $spare_id = $this->input->get('spare_id');
        $user_id = $this->input->get('user_id');
        $spare_status = $this->input->get('spare_status');
        $spare_remarks = $this->input->get('spare_remarks');

        if (empty($spare_id) || (int)$spare_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $update_status = array(
            "user_id" => $user_id,
            "status" => $spare_status,
            "remarks" => $spare_remarks
        );
        $this->db->where('worksheet_spare_allocation_id', $spare_id)->update('tbl_trg_worksheet_spare_allocation', $update_status);

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function submitWorksheetStatusToWarehouseForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 12;
            $data['title'] = 'UPDATE WORKSHEET STATUS';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }
    public function submitSparependingDeviceForm($worksheet_id = 0)
    {

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {

            $data['active'] = 1;
            $data['title'] = 'WORKSHEET LIST';
        } else {

            $data['active'] = 17;
            $data['title'] = 'ASSIGN';
            $data['update_worksheet_id'] = $worksheet_id;
        }
        $data['subview'] = $this->load->view('admin/worksheet/manage_worksheet', $data, true);
        $this->load->view('_layout_main', $data); //page load

    }
    public function getTotalColorsList()
    {

        $result = $this->db->order_by('color', 'asc')->get('ynewco_erp.tbl_colorcode')->result_array();

        if (!empty($result) && count($result) == 0) {

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }
    public function updateOsPendingWorksheetStatus()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];

        if (empty($worksheet_id) || (int) $worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $update_worksheet = array(
            "status" => $data['status'],
            "sub_status" => $data['status']
        );
        $completeWorksheet = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', $update_worksheet);

        if ($completeWorksheet) {

            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => 10,
                "assigned_by" => 4,
                "level_type" => 34,
                "status" => $data['status'],
                "remarks" => $data['remark'],
                "issue_type" => $data['issue_type']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getTotalDeviceServiceInfo()
    {

        $device_id = $this->input->get('device_id');
        //$device_id = "TD19100043387";
        $data = array();

        $res = $this->db->select('worksheet_no,worksheet_id')->from('tbl_trg_worksheet')
            ->where('device_id', $device_id)->get()->result();

        // $res = $this->db->select('*')->from('WORKSHEET_LIST_VIEW') // Total worksheet list
        //     ->where(array("device_id" => $device_id, "status" => "COMPLETE", "flag" => 1))
        //     ->order_by('created_date', 'desc')
        //     ->group_by('worksheet_id')
        //     ->get()->result();

        if (empty($res)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        foreach ($res as $value) {
            $worksheet_id = $value->worksheet_id;
            $worksheet_no = $value->worksheet_no;
            $device_log = $this->db->order_by('remarks_id', 'desc')->get_where('tbl_trg_worksheet_remarks', array("worksheet_id" => $worksheet_id))
                ->result();
            foreach ($device_log as $log_data) {

                $assigned_user = $log_data->assigned_user;
                $assigned_to = $this->db->get_where('tbl_trg_users', array("user_id" => $assigned_user))->row()->username;
                if (preg_match('/^[a-z]+_[a-z]+$/i', $log_data->status)) {
                    $status = str_replace('_', ' ', $log_data->status);
                } else {
                    $status = $log_data->status;
                }
                $data[] = array(
                    'worksheet_no' => $worksheet_no,
                    'status' => $status,
                    'assigned_to' => $assigned_to,
                    'remarks' => $log_data->remarks,
                    'created_date' => $log_data->created_date
                );
            }
        }

        $result = $data;
        if (empty($result)) {

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        $json['data'] = $result;
        echo json_encode($json);
        exit;
    }

    public function sparePendingWorksheet()
    {

        $result = $this->db->get_where('tbl_trg_worksheet', array("status" => "spare_pending"))->result_array();

        if (!empty($result) && count($result) == 0) {

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function getPDF()
    {

        // $worksheet_id = $this->input->get('spare_pending');
        // $id_array = explode(",", $worksheet_id);

        $id_array = array(3, 4, 5);
        if (empty($id_array)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $spare_pdf = array();
        // $result = $this->db->select('worksheet.worksheet_no, worksheet.device_id, worksheet.status, genreport.device_name,
        // spare_item.spare_name, spare_item.color, spare_item.spare_quantity, spare_item.price, spare_item.updated_date,')
        //     ->from('tbl_trg_worksheet as worksheet')
        //     ->join('tbl_trg_worksheet_spare_item as spare_item', 'worksheet.worksheet_id = spare_item.worksheet_id')
        //     ->join('ynewco_erp.tbl_grnreport as genreport', 'genreport.nhdin = worksheet.device_id')
        //     ->where(array("worksheet.status" => "SPARE_PENDING", "spare_item.status" => "APPROVED", "worksheet.worksheet_id" => $worksheet_id ))
        //     ->get()->result_array();

        if (!empty($id_array)) {

            $total_quantity = 0;
            $total_price = 0;
            $grand_total = 0;

            foreach ($id_array as $key => $worksheet_data) {

                $result = $this->db->select('worksheet.worksheet_no, worksheet.device_id, worksheet.status, genreport.device_name,
                    spare_item.spare_name, spare_item.color, spare_item.spare_quantity, spare_item.price, spare_item.updated_date,')
                    ->from('tbl_trg_worksheet as worksheet')
                    ->join('tbl_trg_worksheet_spare_item as spare_item', 'worksheet.worksheet_id = spare_item.worksheet_id')
                    ->join('ynewco_erp.tbl_grnreport as genreport', 'genreport.nhdin = worksheet.device_id')
                    ->where(array("worksheet.worksheet_id" => $worksheet_data, "spare_item.status" => "APPROVED"))
                    ->get()->result_array();

                foreach ($result as $value) {
                    $amount = $value["spare_quantity"] * $value["price"];
                    $total_quantity += $value['spare_quantity'];
                    $grand_total += $amount;
                    $total_price += $value["price"];
                    $spare_pdf[] = array(
                        'worksheet_no' => $value["worksheet_no"],
                        'device_id' => $value["device_id"],
                        'device_name' => $value["device_name"],
                        'quantity' => $value["spare_quantity"],
                        'spare_name' => $value["spare_name"],
                        'color' => $value["color"],
                        'price' => $value["price"],
                        'amount' => $amount
                    );
                }
            }
            $data['grand_total'] = $grand_total;
            $amount_words = $this->getIndianCurrency($grand_total);
            $data['total_quantity'] = $total_quantity;
            $data['amount_words'] = $amount_words;
            $data['total_price'] = $total_price;
            $data['rows'] = $spare_pdf;
        }

        if (empty($data)) {

            $json['status'] = 0;
            $json['data'] = array();
            echo json_encode($json);
            exit;
        } else {

            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/worksheet/pdf_spare_request', $data, TRUE);
            pdf_create($viewfile, TRUE);
        }
    }

    public function getSRSumarry()
    {

        $spare_pdf = array();


        $total_quantity = 0;
        //$total_price = 0;
        //$grand_total = 0;

        $result = $this->db->select('worksheet.worksheet_no, worksheet.device_id, worksheet.status, genreport.device_name,
                    spare_item.spare_name, spare_item.color, 
                     SUM(spare_item.spare_quantity) as spare_quantity , spare_item.price, spare_item.updated_date,')
            ->from('tbl_trg_worksheet as worksheet')
            ->join('tbl_trg_worksheet_spare_item as spare_item', 'worksheet.worksheet_id = spare_item.worksheet_id')
            ->join('ynewco_erp.tbl_grnreport as genreport', 'genreport.nhdin = worksheet.device_id')
            ->where(array("worksheet.status" => "SPARE_PENDING", "spare_item.status" => "APPROVED"))
            ->group_by(array("genreport.device_name", "spare_item.spare_name", "spare_item.color"))
            ->get()->result_array();

        foreach ($result as $value) {
            //$amount = $value["spare_quantity"] * $value["price"];
            $total_quantity += $value['spare_quantity'];
            //$grand_total += $amount;
            //$total_price += $value["price"];
            $spare_pdf[] = array(
                //'worksheet_no' => $value["worksheet_no"],
                //'device_id' => $value["device_id"],
                'device_name' => $value["device_name"],
                'quantity' => $value["spare_quantity"],
                'spare_name' => $value["spare_name"],
                'color' => $value["color"],
                // 'price' => $value["price"],
                // 'amount' => $amount
            );
        }

        // $data['grand_total'] = $grand_total;
        //$amount_words = $this->getIndianCurrency($grand_total);
        $data['total_quantity'] = $total_quantity;
        //$data['amount_words'] = $amount_words;
        //$data['total_price'] = $total_price;
        $data['rows'] = $spare_pdf;

        if (empty($data)) {

            $json['status'] = 0;
            $json['data'] = array();
            echo json_encode($json);
            exit;
        } else {

            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/worksheet/sr_summary', $data, TRUE);
            pdf_create($viewfile, TRUE);
        }
    }

    function getIndianCurrency(float $number)
    {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(
            0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
        );
        $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str[] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ?  $Rupees : '') . $paise . ' Rupees Only';
    }

    public function getSparePendingReport()
    {
        
        $csv_output = "S/NO, WORKSHEET NO, DEVICE ID, SPARE NAME, DESCRIPTION";
       
        $result = $this->db->select('worksheet.worksheet_id,worksheet.worksheet_no, worksheet.device_id,
            spare_item.spare_name')
            ->from('tbl_trg_worksheet as worksheet')
            ->join('tbl_trg_worksheet_spare_item as spare_item', 'worksheet.worksheet_id = spare_item.worksheet_id')
            ->where(array("worksheet.status" => "SPARE_PENDING", "spare_item.status" => "APPROVED"))
            ->get()->result_array();
        $spare_pdf = array();
        $row_count = 1;
        if (!empty($result)) {

            foreach ($result as $value) {

                $worksheet_id = $value['worksheet_id'];
                $remarks = $this->db->select('remarks')->from('tbl_trg_worksheet_remarks')
                    ->where(array("worksheet_id"=>$worksheet_id, "flag"=>"1"))->get()->row()->remarks;
                
                $spare_pdf[] = array(

                    "row_count" => $row_count,
                    'worksheet_no' => $value["worksheet_no"],
                    'device_id' => $value["device_id"],
                    'spare_name' => $value["spare_name"],
                    'description' => str_replace(array(',', "\r\n", "\n", "\r", '"'), ' ', $remarks)
                );
                $row_count++; 
            }
            $data['rows'] = $spare_pdf;
        }
        
        $csv_output .= "\n";
        if (!empty($spare_pdf)) {
            foreach ($spare_pdf as $periodic_report) {

                $csv_output .= $periodic_report['row_count'] . ",";
                $csv_output .= $periodic_report['worksheet_no'] . ",";
                $csv_output .= $periodic_report['device_id'] . ",";
                $csv_output .= $periodic_report['spare_name'] . ",";
                $csv_output .= $periodic_report['description'] . ",";
              
                $csv_output .= "\n";
            }
        }
        //echo "<pre>"; print_r($csv_output); echo "</pre>"; exit;
        
        if (empty($spare_pdf)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $filename = "Spare Pending Report";
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;

    }

    public function changeSparePendingStatus()
    {

        $request = file_get_contents("php://input", true);
        $data = json_decode($request, true);
        $worksheet_id = $data["worksheet_id"];
        //session data
        $user_data = $this->session->userdata('user_data');
        $user_id = $user_data['user_id'];

        if (empty($worksheet_id) || (int)$worksheet_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $update_worksheet = array(

            "issue_type" => $data['issue_type'],
            "status" => "PENDING",
            "sub_status" => "PARTS_FOR_PENDING"
        );
        
        $changeStatus = $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet', $update_worksheet);

        if ($changeStatus) {

            $this->db->where('worksheet_id', $worksheet_id)->update('tbl_trg_worksheet_remarks', array("flag" => 0));
            $add_device_remarks = array(

                "worksheet_id" => $worksheet_id,
                "assigned_user" => 10,
                "assigned_by" => $user_id,
                "level_type" => 1,
                "status" => "PENDING",
                "remarks" => $data['remark'],
                "issue_type" => $data['issue_type']
            );
            $this->db->insert('tbl_trg_worksheet_remarks', $add_device_remarks);
        }
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }


}