<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Warehouse_location extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();
    }

    public function manage_location($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }
        
        $data['title'] = 'LOCATIONS';
        
        $data['subview'] = $this->load->view('admin/warehouse_location/manage_location', $data, TRUE);
        
        $this->load->view('admin/_layout_main', $data);
    }
    public function getStateList()
    {

        $result = $this->db->select('state_id, name')->from('tbl_states')->get()->result();

        $state_list = [];
        foreach ($result as $val) {

            $state_name = str_replace('_', ' ', $val->name);
            $state_list[] = array(
                "state_id" => $val->state_id,
                "state_name" => $state_name
            );
        }

        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        $json['data'] = $state_list;
        echo json_encode($json);
        exit;
    }
    
    public function addlogistic()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data)) {
            $json['status'] = 0;
            $json['msg'] = "Your not posted any data ";
            echo json_encode($json);
            die;
        }
        $check_count = $this->db->get_where('tbl_wh_loc', array("state" => $data['state']))->num_rows();
        if($check_count > 0){
            $json['status'] = 0;
            $json['msg'] = "Your Adding satate is already exist ";
            echo json_encode($json);
            die;
        }
        $add_partner_arr = array(
                "business_type" => $data['business_type'],
                "gst_number" => $data['gst_number'],
                "state" => $data['state'],
                "city" => $data['city'],
                "warehouse" => $data['warehouse'],
                "short_code" => $data['short_code'],
                "address" => $data['address'],
                "state_gst_code" => $data['gst_code'],
                "invoice_seq_code" => $data['invoice_seq_code']
            );
        
        $this->db->insert('tbl_wh_loc', $add_partner_arr);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    
    public function getLocationList()
    {
        $result = $this->db->get('tbl_wh_loc')->result_array();
        $result_arr = [];

        foreach ($result as $data) {
            
            $result_arr[] = array(
                "business_type" => $data['business_type'],
                "gst_number" => $data['gst_number'],
                "state" => $data['state'],
                "city" => $data['city'],
                "warehouse" => $data['warehouse'],
                "short_code" => $data['short_code'],
                "address" => $data['address'],
                "gst_code" => $data['state_gst_code'],
                "invoice_seq_no" => $data['invoice_seq_code']
            );
        }

        $response = array(
            'status' => 1,
            'message' => 'Location List',
            'data' => $result_arr
        );
        echo json_encode($response);
        exit;
    }
    
    
}
