<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Vendor extends Admin_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Vendor_model');
		$this->load->library('hostbooks_authenticator');
	}

	public function index()
	{
		$data['title'] = "Vendor Detail"; //Page title
		$data['subview'] = $this->load->view('admin/vendor/vender_option', $data, TRUE);
		$this->load->view('admin/_layout_main', $data);
	}


	public function manage_vendor($type = NULL, $id = NULL, $active = 1)
	{
		$user_type = $this->input->get('user_type');

		if ($type == '') {
			/*===set message==*/
			set_message('error', "Something Wrong.Please Try Again.");
			redirect($_SERVER['HTTP_REFERER']);
			die;
		}

		$data['active'] = $active;
		if (is_numeric($id) && $active == 1) {
			$data['active'] = 2;
		}

		$data['department_id'] = $this->Common_model->getFieldValue('department_id', 'tbl_account_details', 'user_id', $this->session->userdata('user_id'));

		/*==for tab menu icon===*/
		if ($type == 'buyer') {
			$data['list'] = "BUYER LIST";
			$data['add'] = "CREATE BUYER";
			$data['used_type'] = 'buyer';
			$data['button'] = "ADD BUYER";
			$data['up_button'] = "UPDATE BUYER";
			$data['type'] = "buyer";

			/*==GET RESULT USER LOCATION WISE==*/
			$cond = "used_type='buyer'";

			if ($this->session->userdata('user_type') != '1') {
				$loginUserLocation = $this->session->userdata('location');

				if ($loginUserLocation == 'BANGALORE') {
					//$cond="vendor_code LIKE '%NHBOFB%'";
				} else {
					//$cond="vendor_code LIKE '%NHBOFD%'";
				}
			}
		} else {
			$data['list'] = "SUPPLIER LIST";
			$data['add'] = "CREATE SUPPLIER";
			$data['used_type'] = 'supplier';
			$data['button'] = "Add SUPPLIER";
			$data['up_button'] = "Add SUPPLIER";
			$data['type'] = "supplier";

			/*==GET RESULT USER LOCATION WISE==*/
			$cond = "used_type='supplier'";
		}

		$data['vendorResult'] = array();

		if ($id != '') {
			$data['vendorResult'] = $this->db->where('vendor_id', $id)->get('tbl_vendor')->row();
		}

		$data['state_list'] = $this->db->order_by('name', 'asc')->get('tbl_states')->result();
		$data['result'] = $this->db->order_by('vendor_id', 'desc')->where($cond)->where('used_type', $data['used_type'])->get('tbl_vendor')->result();
		$data['title'] = "MANAGE VENDOR"; //Page title
		$data['page'] = lang('device');
		$data['subview'] = $this->load->view('admin/vendor/manage_vendor', $data, TRUE);
		$this->load->view('admin/_layout_main', $data);
	}


	function create_vendor($id = NULL)
	{
		$data = $this->input->post();

		/*==start update vendor work==*/
		if ($id != '') {
			$this->db->where('vendor_id', $id)->update('tbl_vendor', $data);
			
			/*==InsertActivities==*/
			$module = "Vendor Detail";
			$activity = "activity_update_a_vendor_detail";
			$msg = "Vendor Detail updated successfully,which vendor id is:-" . $id;
			$this->Common_model->insertActivities($module, $id, $activity, $msg);

			/*===set message==*/
			set_message('success', $msg);
			redirect($_SERVER['HTTP_REFERER']);
			die;
		}
		
		/*==End update vendor detail  work==*/
		if ($id == '') {
			unset($data['vendor_id']);
			$data['added_userid'] = $this->session->userdata('user_id');
			$this->db->insert('tbl_vendor', $data);
			$insert_id = $this->db->insert_id();

			/*==UPDATE VENDOR CODE AFTER CREATE NEW VENDOR==*/
			$state = $this->session->userdata('location');
			$codeNO = $this->Common_model->getSeriesForVenBuyerCode($insert_id);
			$userType = $this->input->post('user_type');

			$code = '';
			if ($data['used_type'] == 'supplier') {
				if ($userType == 'BULK') {
					$code = "SLYSPB2B-" . $codeNO;
				} else if ($userType == 'PARTNERS') {
					$code = "SLYSPPTR-" . $codeNO;
				} else if ($userType == 'INDIVIDUAL') {
					$code = "SLYSPC2B-" . $codeNO;
				}
			} else {
				if ($userType == 'DEALER') {
					$code = "SLYB-H-B2B-" . $codeNO;
				} else if ($userType == 'INDIVIDUAL') {
					$code = "SLYB-H-B2C-" . $codeNO;
				} else if ($userType == 'ONLINE') {
					$code = "SLYB-H-ONL-" . $codeNO;
				} else if ($userType == 'FULFILLMENT') {
					$code = "SLYB-H-FF-" . $codeNO;
				} else if ($userType == 'EXPORT') {
					$code = "SLYB-H-EXP-" . $codeNO;
				}
			}

			$this->db->where('vendor_id', $insert_id)->update('tbl_vendor', array('vendor_code' => $code));

			/*==InsertActivities==*/
			$module = "Vendor Detail";
			$activity = "activity_added_a_new_vendor";
			$msg = "Vendor Added successfully which vendor id is:-" . $insert_id;
			$this->Common_model->insertActivities($module, $insert_id, $activity, $msg);

			$data['supplier_code'] = $code;
			$this->hostbooks_authenticator->postVendor($insert_id);
			/*===set message==*/
			set_message('success', $msg);
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function addHostbooksCustomer($vendor_id)
	{
		$this->hostbooks_authenticator->postVendor($vendor_id);
	}

	function getCustomersApi()
	{
		$customerResult = $this->Vendor_model->getCustomers();
		$data = array();

		if (!empty($customerResult)) {
			foreach ($customerResult as $customer) {
				$data[] = array(
					$customer['vendor_id'] => $customer['name'],
				);
			}
		}

		$result['data'] = $data;
		echo json_encode($result);
		die;
	}

	public function uploadVendorDetails()
	{
		$type = "";
		$msg = "";
		if (isset($_FILES["csv_file"])) {
			$file_name = $_FILES['csv_file']['name'];
			$file_size = $_FILES['csv_file']['size'];
			$file_tmp = $_FILES['csv_file']['tmp_name'];
			$file_type = $_FILES['csv_file']['type'];
			$file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
			$extensions = array("csv");

			if (in_array($file_ext, $extensions) === false) {
				$msg = "extension not allowed, please choose a CSV file.";
			}

			if ($file_size > 2097152) {
				$msg = 'File size must not exceed 2 MB';
			}

			if (empty($errors) == false) {
				$type = "error";
				$msg = "NO FILE SELECTED.PLEASE TRY AGAIN";
				$this->session->set_userdata($type, $msg);
				header("location:" . $_SERVER['HTTP_REFERER']);
				die;
			}

			$state_res = $this->db->select('state_id, name')->get('tbl_states')->result_array();
			$state_array = array();
			foreach ($state_res as $state) {
				$state_array[strtolower($state['name'])] = $state['state_id'];
			}

			$handle = fopen($_FILES['csv_file']['tmp_name'], "r");
			$first_line = true;
			$vendorRecords = array();
			$row = 1;
			
			while ($col = fgetcsv($handle)) {
				if ($first_line == false && !empty($col[0])) {
					if(empty($col[2])){
						$type = "error";
						$msg = "Company Name is required in Row- ". $row;
						$this->session->set_userdata($type, $msg);
						header("location:" . $_SERVER['HTTP_REFERER']);
						die;
					}

					// Check gst with regex
					if(!empty($col[9])){
						$gst_regex = '/^([0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}[Z]{1}[0-9A-Z]{1})+$/';
						if(!preg_match($gst_regex, $col[3])){
							$type = "error";
							$msg = "GST is not valid in Row- ". $row;
							$this->session->set_userdata($type, $msg);
							header("location:" . $_SERVER['HTTP_REFERER']);
							die;
						}
					}else{
						$col[9] = '';
					}

					// check if pincode is valid
					$pincode_regex = '/^[1-9][0-9]{5}$/';
					if(!preg_match($pincode_regex, $col[8])){
						$type = "error";
						$msg = "Pincode is not valid in Row- ". $row;
						$this->session->set_userdata($type, $msg);
						header("location:" . $_SERVER['HTTP_REFERER']);
						die;
					}

					$mobile_regex = '/^[9876][0-9]{9}$/';
					if(!preg_match($mobile_regex, $col[4])){
						$type = "error";
						$msg = "Mobile is not valid in Row- ". $row;
						$this->session->set_userdata($type, $msg);
						header("location:" . $_SERVER['HTTP_REFERER']);
						die;
					}

					//check State
					$state_name = strtolower($col[7]);
					if(!array_key_exists($state_name, $state_array)){
						$type = "error";
						$msg = "State is not valid in Row- ". $row;
						$this->session->set_userdata($type, $msg);
						header("location:" . $_SERVER['HTTP_REFERER']);
						die;
					}
					
					$vendorRecords[] = array(
						'name' => $col[1],
						'user_type' => $col[0],
						'company' => $col[2],
						'email' => $col[3],
						'mobile' => $col[4],
						'address' => $col[5],
						'city' => $col[6],
						'state' => $state_array[$state_name],
						'pincode' => $col[8],
						'gst_no' => $col[9],
					);

				}
				$first_line = false;
				$row++;
			}
			fclose($handle);
			
			$status = $this->Vendor_model->createVendors($vendorRecords);
			header("location:" . $_SERVER['HTTP_REFERER'] . '?status=' . $status);
			die;
		}
	}

	public function getVendorList($type = NULL, $id = NULL)
	{
		$user_type = $this->input->get('user_type');
		$type = $this->input->get('type');
		$result = array();

		if(!empty($type)){
			$this->db->where('used_type', $type);
		}

		if(!empty($user_type)){
			$this->db->where('user_type', $user_type);
		}
		
		$result = $this->db->get('tbl_vendor')->result_array();

		if (empty($result)) {
			$json['data'] = array();
			echo json_encode($json);
			die;
		}

		foreach ($result as $rowValue) {
			$created_date = date("d-m-Y", strtotime($rowValue['created_date']));
		
			if ($created_date == '01-01-1970' || $created_date == '30-11--0001') {
				$created_date = '';
			}
		
			$rows[] = array(
				"vendor_id" => $rowValue["vendor_id"],
				"vendor_code" => $rowValue["vendor_code"],
				"user_type" => $rowValue["user_type"],
				"name" => $rowValue["name"],
				"company" => $rowValue["company"],
				"alias" => $rowValue["alias"],
				"business_role" => $rowValue["business_role"],
				"city" => $rowValue["city"],
				"email" => $rowValue["email"],
				"mobile" => $rowValue["mobile"],
				"address" => $rowValue["address"],
				"account_number" => $rowValue["account_number"],
				"bank_name" => $rowValue["bank_name"],
				"ifsc_no" => $rowValue["ifsc_no"],
				"gst_no" => $rowValue["gst_no"],
				"aadhar_no" => $rowValue["aadhar_no"],
				"created_date" => $created_date,
			);
		}

		$json["data"] = $rows;
		echo json_encode($json);
		die;
	}

	function createFFVendor(){
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);
		$insert_arr = array(
			"added_userid" => $this->session->userdata('user_id'),
			"name" => $data['customer_name'],
			"company" => $data['company_name'],
			"user_type" => $data['customer_type'],
			"email" => $data['email'],
			"mobile" => $data['mobile'],
			"address" => str_replace('"', ' ', $data['address']),
			"city" => $data['city'],
			"state" => $data['state'],
			"pincode" => $data['pincode'],
			"pan_card" => '',
			"aadhar_no" => '',
			"gst_no" => '',
			"created_date" => date("Y-m-d H:i:s"),
			"modify_time" => date("Y-m-d H:i:s"),
			"country" => $data['country'],
			"used_type" => "buyer"
		);
		$this->db->insert('tbl_vendor', $insert_arr);
		$insert_id = $this->db->insert_id();

		if(empty($insert_id)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		/*==UPDATE VENDOR CODE AFTER CREATE NEW VENDOR==*/
		$codeNO = $this->Common_model->getSeriesForVenBuyerCode($insert_id);
		$code = "SLYB-H-FF-" . $codeNO;
		$this->db->where('vendor_id', $insert_id)->update('tbl_vendor', array('vendor_code' => $code));

		/*==InsertActivities==*/
		$module = "Vendor Detail";
		$activity = "activity_added_a_new_vendor";
		$msg = "Vendor Added successfully which vendor id is:-" . $insert_id;
		$this->Common_model->insertActivities($module, $insert_id, $activity, $msg);

		/*===set message==*/
		$json['status'] = 1;
		$json['msg'] = $msg;
		echo json_encode($json);
		exit;
	}

	function checkVendorExist(){
		$data = json_decode(file_get_contents("php://input"), TRUE);

		if(empty($data)){
			$json['status'] = 0;
			$json['message'] = "No Data Found";
			echo json_encode($json);
			exit;
		}

		if(!empty($data['gst_no'])){
			if($data['used_type'] == "supplier"){
				$query = "SELECT vendor_id FROM tbl_vendor WHERE gst_no = '".$data['gst_no']."' AND used_type = '".$data['used_type']."'";
			
			} else {
				$query = "SELECT vendor_id FROM tbl_vendor WHERE used_type = '".$data['used_type']."' AND ( gst_no = '".$data['gst_no']."' ";
				if (!empty($data['pan_card'])) {
					$query .= " OR pan_card = '". $data['pan_card'] ."' ";
				}
				$query .= ")";
			}
			$gstin_check = $this->db->query($query)->row();
		
		
// 			$gstin_check = $this->db->select('vendor_id')
// 							->where('gst_no', $data['gst_no'])
// 							->or_where('pan_card', $data['pan_card'])
// 							->where('used_type', $data['used_type'])
// 							->get('tbl_vendor')->row();

			if(!empty($gstin_check)){
				$json['status'] = 0;
				$json['message'] = strtoupper($data['used_type']) . " with this GSTIN / PAN Already Exist";
				echo json_encode($json);
				exit;
			}
		}

		$pincode_name_check = $this->db->select('vendor_id')
		                                   ->where('pincode', $data['pincode'])
										   ->where('company', $data['company'])
										   ->where('used_type', $data['used_type'])
										   ->get('tbl_vendor')->row_array();

		if(!empty($pincode_name_check)){
			$json['status'] = 2;
			$json['message'] = strtoupper($data['used_type']) . " with same Name and Pincode Already Exist";
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	function checkExportVendorExist(){
		$data = json_decode(file_get_contents("php://input"), TRUE);

		if(empty($data)){
			$json['status'] = 0;
			$json['message'] = "No Data Found";
			echo json_encode($json);
			exit;
		}

		$company_check = $this->db->select('vendor_id')
		                          ->where('user_type', 'EXPORT')
		                          ->where('company', $data['company'])
								  ->get('tbl_vendor')->row_array();
		
		if(!empty($company_check)){
			$json['status'] = 2;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}
	
}
