<?php 

class Triage extends Admin_Controller {

    public function __construct()
    {
        parent::__construct(); 
        /*load model*/
        $this->load->model('auditlog_model');
        $this->load->model('triage_model');
        
    }

    public function manage_triage($active = 0){
        
        if($active <=0){
            
            $data['active'] = 1;
        }else{

            $data['active'] = $active;
        }

        $data['title'] = 'TRIAGE';

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getRmonList(){
        
        $status = $this->input->get('status');
        $records = array();

        $this->db->where('status', $status);
        $result = $this->db->get('TRG_RMON_VIEW')->result_array();


        if(!empty($result)){
            foreach($result as $rowValue){

                if( $rowValue['EXPECTED_DATE'] == '' || $rowValue['EXPECTED_DATE'] == null){

                    $expected_date = '';
                }else{
                    $expected_date = date('d-m-Y', strtotime($rowValue['EXPECTED_DATE']));
                }

                $records[] = array(
                                "rmon_id" => $rowValue["trg_rmon_id"],
                                "rmon_code" => $rowValue["rmon_code"],
                                "status" => str_replace("_"," ",$rowValue["status"]),
                                "type" => $rowValue["type"],
                                "purpose" => $rowValue["purpose"],
                                "total_qty" => $rowValue["total_qty"],
                                "received_qty" => $rowValue["received_qty"],
                                "EXPECTED_DATE" => $expected_date,
                                "service_center" => $rowValue["sc_name"].'-'.$rowValue["sc_location"],
                                "CREATED_BY" => $rowValue["CREATED_BY"],
                                "LAST_UPDATED_BY" => $rowValue["LAST_UPDATED_BY"],
                                "CREATION_DATE" => date("d-m-y", strtotime($rowValue["CREATION_DATE"])),
                                "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($rowValue["LAST_UPDATE_DATE"])),
                            );
            }
        }

        $json['data'] = $records;
        echo json_encode($json);
        die;

    }

    public function getServiceCenterList(){

        $records = array();

        $result = $this->db->get('tbl_trg_service_center')->result_array();

        if(!empty($result)){
            foreach($result as $rowValue){

                $records[] = array(
                                "trg_service_center_id" => $rowValue["trg_service_center_id"],
                                "sc_name" => $rowValue["sc_name"],
                                "sc_location" => $rowValue["location"],
                                "sc_city" => $rowValue["city"],
                                "sc_state" => $rowValue["state"],
                                "sc_pincode" => $rowValue["pincode"],
                            );
            }
        }

        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function getRmonDetails(){
        $rmon_id = $this->input->get('rmon_id');

        if((int) $rmon_id <=0){
            
            $data['result'] = array();
            echo json_encode($data);
            die;
        }

        $result = $this->db->where('trg_rmon_id',$rmon_id)->get('TRG_RMON_ITEM_VIEW')->result_array();


        if(empty($result)){

            $data['result'] = array();
            echo json_encode($data);
            die;
        }

        foreach($result as $rowValue){

            if($rowValue['return_status'] == NULL){
                
                $return_status = '';
            }else{
                
                $return_status = $rowValue['return_status'];
            }

            if(empty($rowValue['received_notes'])){
                
                $received_notes = '';
            }else{
                
                $received_notes = $rowValue['received_notes'];
            }

            $records[] = array(
                                "rmon_id" => $rmon_id,
                                "rmon_item_id" => $rowValue["trg_rmon_item_id"],
                                "device_name" => $rowValue["device_name"],
                                "device_id" => $rowValue["device_id"],
                                "grnreport_id" => $rowValue["grnreport_id"],
                                "imei" => $rowValue["imei"],
                                "sku" => $rowValue["SKU"],
                                "grade" => $rowValue["grade"],
                                "category" => $rowValue["stock_type"],
                                "product_status" => $rowValue["product_status"],
                                "return_status" => $return_status,
                                "remarks" => $rowValue["remarks"],
                                "received_notes" => $received_notes,
                            );
        }

        $data['result'] = $records;
        echo json_encode($data);
        die;

    }

    public function createServiceCenter(){

        $request = file_get_contents("php://input");  
		$data = json_decode($request,true);
	
		   
		$record = array(

			"sc_name" => $data[0]["sc_name"],
			"location" => $data[0]["sc_location"],
			"city" => $data[0]["sc_city"],
			"state" => $data[0]["sc_state"],
            "pincode" => $data[0]["sc_pincode"]
            
		);

		// Start Inserting
        $this->db->insert('tbl_trg_service_center',$record);
        
        $error = $this->db->error();

		if($error['code'] != 0){
            
            $json["status"] = 0;
            echo json_encode($json);
		    die;
		}
        
        $json["status"] = 1;
        
		echo json_encode($json);
		die;
    }

    public function createRmon(){

        $request = file_get_contents("php://input");  
        $data = json_decode($request,true);
        
        if(empty($data)){
            
            $json["status"] = 0;
            echo json_encode($json);
		    die;
        }

        $res=$this->db->select('max(CAST(SUBSTRING_INDEX(rmon_code,"-",-1) as UNSIGNED)) as max')->from('tbl_trg_rmon')->get()->row_array();
       	$next_number=$res['max']+1;
        $rmon_code='RMON-'.$next_number;
        
        if(empty($data[0]["service_center"]) || empty($data[0]["rows"])){
            
            $json["status"] = 0;
            echo json_encode($json);
		    die;
        }
           
		$record = array(

			"rmon_code" => $rmon_code,
            "service_center" => $data[0]["service_center"],
            "status" => "NEW",
            "CREATED_BY" => $this->session->userdata('user_id'),
            "CREATION_DATE" => date("Y-m-d H:i:s")
		);

        // Start Inserting
        $this->db->trans_start();

        $this->db->insert('tbl_trg_rmon',$record);
        $rmon_id = $this->db->insert_id();
        $error = $this->db->error();

        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json["status"] = 0;
            echo json_encode($json);
		    die;
        }

        foreach($data[0]["rows"] as $rowValue){

            $records[] = array(
                                "trg_rmon_id" => $rmon_id,
                                "grnreport_id" => $rowValue["grnreport_id"],
                                "remarks" => $rowValue["remarks"],
                            );
        }

        $this->db->insert_batch('tbl_trg_rmon_item',$records);
		$error=$this->db->error();
       
        if($error['code'] != 0){
            
            $this->db->trans_rollback();
            $json["status"] = 0;
            echo json_encode($json);
		    die;
        }
        
        $this->auditlog_model->insert_auditlog($rmon_id,'trg_rmon',"NEW",$this->session->userdata('user_id'));
 
        $this->db->trans_complete(); // Complete Mysql Transaction

        $json["status"] = 1;
        echo json_encode($json);
        die;
    }

    public function updateRmonForm($rmon_id){

        if ($rmon_id > 0) {
            
            $data['active'] = 5;
            $data['title'] = 'UPDATE RMON';
            $data['rmon_id'] = $rmon_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'TRIAGE';
        }

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getRmonHeader(){

        $rmon_id = $this->input->get('rmon_id');

        if ((int) $rmon_id <= 0) {
            
            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        $records = array();

        $result = $this->db->where('trg_rmon_id', $rmon_id)->get('TRG_RMON_VIEW')->row_array();
        if(!empty($result)){

                $records[] = array(
                                "rmon_id" => $result["trg_rmon_id"],
                                "rmon_code" => $result["rmon_code"],
                                "status" => str_replace("_"," ",$result["status"]),
                                "type" => $result["type"],
                                "purpose" => $result["purpose"],
                                "EXPECTED_DATE" => $result["EXPECTED_DATE"],
                                "service_center" => $result["sc_name"].'-'.$result["sc_location"],
                                "service_center_id" => $result["service_center"],
                                "CREATED_BY" => $result["CREATED_BY"],
                                "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
                                "CREATION_DATE" => $result["CREATION_DATE"],
                                "LAST_UPDATE_DATE" => $result["LAST_UPDATE_DATE"],
                            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        die;
    }

    public function updateRmon(){

        $request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
        
        $status=$this->Common_model->getRowResult('status','tbl_trg_rmon',array("trg_rmon_id"=>$data['rmon_id']));
		
		//Check Status of the Stocktransfer Order
		if($status['status'] !='NEW'){
			$json['status']=0;
			echo json_encode($json);
			die;
		}

		$result=$this->triage_model->updateRmon($data);

		if($result=="approved"){

			$json['status']=1;
			$json['message']='approved';
			echo json_encode($json);
			die;

		}elseif($result=="rejected"){

			$json['status']=1;
			$json['message']='rejected';
			echo json_encode($json);
			die;

		}else{

			$json['status']=0;
			echo json_encode($json);
			die;
		}
    }

    public function validateRmonBySecurityAdminForm($rmon_id){
        
        if ($rmon_id > 0) {
            
            $data['active'] = 6;
            $data['title'] = 'VALIDATE RMON';
            $data['rmon_id'] = $rmon_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'TRIAGE';
        }

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
        
    }

    public function editRmonForm($rmon_id){
        
        if ($rmon_id > 0) {
            
            $data['active'] = 7;
            $data['title'] = 'EDIT RMON';
            $data['rmon_id'] = $rmon_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'TRIAGE';
        }

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
        
    }

    public function receiveAdminRmonForm($rmon_id){
        
        if ($rmon_id > 0) {
            
            $data['active'] = 8;
            $data['title'] = 'RECEIVE OUTWARD NOTE';
            $data['rmon_id'] = $rmon_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'TRIAGE';
        }

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
        
    }

    public function receiveRejectedRmonForm($rmon_id){
        
        if ($rmon_id > 0) {
            
            $data['active'] = 10;
            $data['title'] = 'RECEIVE OUTWARD NOTE';
            $data['receive_rejected_rmon_id'] = $rmon_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'TRIAGE';
        }

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
        
    }

    public function receiveWHRmonForm($rmon_id){
        
        if ($rmon_id > 0) {
            
            $data['active'] = 9;
            $data['title'] = 'RECEIVE OUTWARD NOTE';
            $data['rmon_id'] = $rmon_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'TRIAGE';
        }

        $data['subview'] = $this->load->view('admin/triage/manage_triage', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
        
    }

    public function receiveRmonByWarehouse(){

        $request = file_get_contents("php://input", true);  
        $data = json_decode($request,true);

        if( (int) $data['rmon_id'] <=0){

            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $status=$this->Common_model->getRowResult('status','tbl_trg_rmon',array("trg_rmon_id"=>$data['rmon_id']));

        //Check Status of the RMON
		if($status['status'] !='ADMIN_RECEIVED' && $status['status'] != 'ADMIN_PARTLY_RECEIVED'){
            
            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $result=$this->triage_model->receiveRmonByWarehouse($data);

		if($result== true){

			$json['status']=1;
			echo json_encode($json);
			die;

		}else{

			$json['status']=0;
			echo json_encode($json);
			die;
		}
    }

    public function receiveRmonBySecurityAdmin(){

        $request = file_get_contents("php://input", true);  
        $data = json_decode($request,true);

        if( (int) $data['rmon_id'] <=0){

            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $status=$this->Common_model->getRowResult('status','tbl_trg_rmon',array("trg_rmon_id"=>$data['rmon_id']));

        //Check Status of the RMON
        if($status['status'] !='ADMIN_APPROVED' && $status['status'] != 'ADMIN_PARTLY_RECEIVED' && $status['status'] != 'PARTLY_RECEIVED' && $status['status'] != 'RECEIVED_REJECTED'){
			$json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $result=$this->triage_model->receiveRmonBySecurityAdmin($data);

		if($result== true){

			$json['status']=1;
			echo json_encode($json);
			die;

		}else{

			$json['status']=0;
			echo json_encode($json);
			die;
		}
    }


    public function validateRmonBySecurityAdmin(){

        $request = file_get_contents("php://input", true);  
        $data = json_decode($request,true);

        if( (int) $data['rmon_id'] <=0){

            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $status=$this->Common_model->getRowResult('status','tbl_trg_rmon',array("trg_rmon_id"=>$data['rmon_id']));

        //Check Status of the RMON
		if($status['status'] !='WH_APPROVED'){
			$json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $result=$this->triage_model->validateRmonBySecurityAdmin($data);

		if($result== true){

			$json['status']=1;
			echo json_encode($json);
			die;

		}else{

			$json['status']=0;
			echo json_encode($json);
			die;
		}
		
    }

    public function editRmon(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if(empty($data) || empty($data[0]['rmon_id'])){
            $json['status'] = 0;
            echo json_encode($json);
            die;

        }

        $result = $this->triage_model->editRmon($data);
        
        if($result == true){

            $json['status'] = 1;
            echo json_encode($json);
            die;

        }else{

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

    }

    public function getDeviceDetails(){

        $device_id = $this->input->get('device_id');

        if( empty($device_id) ){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $result = $this->db->where('nhdin', $device_id)->get('tbl_grnreport')->row();
        $error = $this->db->error();

        if(empty($result) || $error['code'] != 0 || $result->status != 'FOR_SERVICE'){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $device_details = array(

                            "grnreport_id" => $result->grnreport_id,
                            "device_name" => $result->device_name,
                            "stock_type" => $result->stock_type,
                            "sku" => $result->SKU,
                            "grade" => $result->certification_grade,
                            "imei" => $result->imei1_no,
                            "status" => $result->status

                        );
        
        $json['result'] = $device_details;
        $json['status'] = 1;
        echo json_encode($json);
        exit;

    }

    public function rmon_pdf($rmon_id=0){

        $records = [];
        
        $download=$this->input->get('download');

        $result = $this->db->where('trg_rmon_id', $rmon_id)->get('TRG_RMON_VIEW')->row_array();
        
        if(!empty($result)){

                $data = [
                                "rmon_id" => $result["trg_rmon_id"],
                                "rmon_code" => $result["rmon_code"],
                                "status" => str_replace("_"," ",$result["status"]),
                                "type" => $result["type"],
                                "purpose" => $result["purpose"],
                                "EXPECTED_DATE" => $result["EXPECTED_DATE"],
                                "service_center" => $result["sc_name"].'-'.$result["sc_location"],
                                "service_center_id" => $result["service_center"],
                                "CREATED_BY" => $result["CREATED_BY"],
                                "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
                                "CREATION_DATE" => $result["CREATION_DATE"],
                                "LAST_UPDATE_DATE" => $result["LAST_UPDATE_DATE"],
                ];
        }

        if($rmon_id>0){
            $result = $this->db->where('trg_rmon_id',$rmon_id)->get('TRG_RMON_ITEM_VIEW')->result_array();

            foreach($result as $rowValue){

                $records[] = array(
                                    "rmon_id" => $rmon_id,
                                    "rmon_item_id" => $rowValue["trg_rmon_item_id"],
                                    "device_name" => $rowValue["device_name"],
                                    "device_id" => $rowValue["device_id"],
                                    "grnreport_id" => $rowValue["grnreport_id"],
                                    "imei" => $rowValue["imei"],
                                    "sku" => $rowValue["SKU"],
                                    "grade" => $rowValue["grade"],
                                    "category" => $rowValue["stock_type"],
                                    "product_status" => $rowValue["product_status"],
                                    "return_status" => $rowValue["return_status"],
                                    "remarks" => $rowValue["remarks"],
                                );
            }
        }
         
        $data['rows'] = $records;
        $data["quantity_words"] = $this->numbertoWords(count($records));

     
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/triage/rmon_pdf', $data, TRUE);
        pdf_create($viewfile, "RMON#".$rmon_id,TRUE,'',$download,'','');
    }

    public function numbertoWords(float $number){
        
        $no = $number;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        
        $words = array(0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
        
        $digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
        
        while( $i < $digits_length ) {
        
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
        
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }
        
        $words = implode('', array_reverse($str));
        return $words;
    }

}

?>