<?php
class Tools extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function manage_tools($active = 0)
    {

        $data['title'] = "TOOLS";
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data["active"] = 1;
        }

        $data['subview'] = $this->load->view('admin/tools/manage_tools', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getOfficeSales()
    {
        $search_type = $this->input->get('search_type');
        $search_string = $this->input->get('search_string');

        $where_arr = array(
            "salesorder_code" => $search_string,
            "saleschannel_ref_id" => $search_string,
            "awb_no" => $search_string,
            "invoice_code" => $search_string,
            "saleschannel_refid" => $search_string,
            "creditnote_code" => $search_string,
            "salesreturn_code" => $search_string,
            "docket_no" => $search_string,
            "claim_no" => $search_string,
            "incident_no" => $search_string,
            "reference_no" => $search_string,
        );

        $search_result = $this->db->or_where($where_arr)->get('SALES_SEARCH_VIEW')->row();

        if (empty($search_result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if ($search_type == 'invoice') {
            $result = $this->getInvoiceHeader($search_result->invoice_id);
            $items = $this->getInvoiceItems($search_result->invoice_id);
        }

        if ($search_type == 'salesorder') {
            $result = $this->getSalesorderHeader($search_result->salesorder_id);
            $items = $this->getSalesorderItems($search_result->salesorder_id);
        }

        if ($search_type == 'salesreturn') {
            $result = $this->getSalesreturnHeader($search_result->salesreturn_id);
            $items = $this->getSalesreturnItems($search_result->salesreturn_id);
        }

        if ($search_type == 'claim') {
            $result = $this->getClaimHeader($search_result->claims_id);
            // $items = $this->getSalesreturnItems($search_result->salesreturn_id);
        }
        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if (empty($items)) {
            $items = [];
        }
        $json['status'] = 1;
        $json['result'] = $result;
        $json['items'] = $items;
        echo json_encode($json);
        exit;
    }

    public function getFulfillmentSales()
    {
        $search_type = $this->input->get('search_type');
        $search_string = $this->input->get('search_string');

        $where_arr = array(
            "ecom_invoice_no" => $search_string,
            "saleschannel_ref_id" => $search_string,
            "creditnote_no" => $search_string,
            "invoice_ref_id" => $search_string
        );

        $search_result = $this->db->or_where($where_arr)->get('ECOM_INVOICE_LIST_VIEW')->row();

        if (empty($search_result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if ($search_type == 'fulfillment_invoice') {
            $result = $this->getFFInvoiceHeader($search_result->ecom_invoice_id);
            $items = $this->getFFInvoiceItems($search_result->ecom_invoice_id);
        }

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if (empty($items)) {
            $items = [];
        }
        $json['status'] = 1;
        $json['result'] = $result;
        $json['items'] = $items;
        echo json_encode($json);
        exit;
    }

    public function getStocktransfer()
    {
        $search_type = $this->input->get('search_type');
        $search_string = $this->input->get('search_string');

        $where_arr = array(
            "stocktransfer_no" => $search_string,
            "tracking_id" => $search_string,
            "tracking_name" => $search_string,
            "removable_id" => $search_string
        );

        $search_result = $this->db->or_where($where_arr)->get('tbl_stocktransfer')->row();

        if (empty($search_result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if ($search_type == 'stocktransfer') {
            $result = $this->getStocktransferHeader($search_result->stocktransfer_id, $search_result->st_type);
            $items = $this->getStocktransferitems($search_result->stocktransfer_id, $search_result->st_type);
        }

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if (empty($items)) {
            $items = [];
        }
        $json['status'] = 1;
        $json['result'] = $result;
        $json['items'] = $items;
        echo json_encode($json);
        exit;
    }

    public function getInvoiceHeader($invoice_id = 0)
    {
        if ((int) $invoice_id <= 0) {
            return false;
        }

        $result  =  $this->db->where('invoice_id', $invoice_id)->get('INVOICE_EXPORT_REPORT_VIEW')->row();
        if (empty($result)) {
            return false;
        }

        return $result;
    }

    public function getInvoiceItems($invoice_id = 0)
    {
        if ((int) $invoice_id <= 0) {
            return false;
        }
        $rows = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_PDF_ROWS_VIEW')->result_array();

        if (!empty($rows)) {

            foreach ($rows as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'deviceid' => $value["nhdin"],
                    'price' => $value["price"],
                    'imei' => $value["imei"],
                    'ram' => $value["ram"],
                    'rom' => $value["rom"],
                    'grade' => $value["certification_grade"],
                    'sku' => $value["SKU"],
                    'category' => $value["category"],
                    'tax_amount' => $value["tax_amount"],
                    'price' => $value["price"],
                    'tax_type' => $value["tax_type"],
                    'sales_terms' => $value['sales_terms'],
                    'bill_type' => $value['bill_type'],

                );
            }
        }
        return $invoice_rows;
    }

    public function getSalesorderHeader($salesorder_id = 0)
    {
        if ((int) $salesorder_id <= 0) {
            return false;
        }
        $result  =  $this->db->where('salesorder_id', $salesorder_id)->get('SALESORDER_LIST_VIEW')->row();

        if (empty($result)) {
            return false;
        }

        return $result;
    }

    public function getSalesorderItems($salesorder_id = 0)
    {
        if ((int) $salesorder_id <= 0) {
            return false;
        }
        $items = [];

        $this->db->select("tbl_salesorder_item.*, tbl_grnreport.nhdin");
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_salesorder_item.grnreport_id', 'Left');
        $result =  $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder_item')->result_array();


        if (!empty($result)) {
            foreach ($result as $value) {

                $device_id = $value["nhdin"];
                if (empty($device_id)) {
                    $device_id = '';
                }
                $items[] = array(
                    'product_name' => $value["device_name"],
                    'device_id' => $device_id,
                    'price' => $value["sale_price"],
                    'quantity' => $value["quantity"],
                    'amount' => $value["amount"],
                    'sku' => $value["sku"],
                    'category' => $value['category'],
                    'grade' => $value['grade'],
                    'sales_terms' => $value['sales_terms'],
                );
            }
        }

        return $items;
    }

    public function getSalesreturnHeader($salesreturn_id = 0)
    {
        if ((int) $salesreturn_id <= 0) {
            return false;
        }

        $result = $this->db->where_in('salesreturn_id', $salesreturn_id)->get('SALESRETURN_LIST_VIEW')->row_array();

        if (!empty($result)) {

            $returned_date = date("d-m-Y", strtotime($result['returned_date']));

            if ($returned_date == '01-01-1970' || $returned_date == '30-11--0001') {
                $returned_date = '';
            }
            $request_date = date("d-m-Y", strtotime($result['request_date']));
            if ($request_date == '01-01-1970' || $request_date == '30-11--0001') {
                $request_date = '';
            }

            $header = array(
                "salesreturn_id" => $result['salesreturn_id'],
                "salesreturn_code" => $result['salesreturn_code'],
                "creditnote_code" => $result['creditnote_code'],
                "vendor_name" => $result['vendor_name'],
                "invoice_qty" => $result['invoice_qty'],
                "saleschannel" => $result['saleschannel'],
                "saleschannel_refid" => $result['saleschannel_refid'],
                "mode_of_receipt" => $result['mode_of_receipt'],
                "status" => $result['status'],
                "claim_no" => $result["claim_no"],
                "delivered_by" => $result['delivered_by'],
                "quantity" => $result['quantity'],
                "no_of_pkg" => $result['no_of_pkg'],
                "invoice_no" => $result['invoice_no'],
                "claim_required" => $result['claim_required'],
                "auto_claim" => $result['auto_claim'],
                "return_type" => $result['return_type'],
                "reason_for_return" => $result['reason_for_return'],
                "returned_date" => $returned_date,
                "request_date" => $request_date,
                "docket_no" => $result['docket_no'],
                "warehouse" => $result['warehouse'],
                "created_date" => date("d-m-Y", strtotime($result['created_date'])),
                "last_modified" => date("d-m-Y", strtotime($result['last_modified'])),
                "CREATED_BY" => $result['CREATED_BY'],
                "LAST_UPDATED_BY" => $result['LAST_UPDATED_BY'],
            );
        }

        if (empty($result) || empty($header)) {
            return false;
        }

        return $header;
    }

    public function getSalesreturnItems($salesreturn_id = 0)
    {
        if ((int) $salesreturn_id <= 0) {
            return false;
        }
        $items = [];

        $result = $this->db->where('salesreturn_id', $salesreturn_id)->get('SALESRETURN_CN_ROWS_VIEW')->result_array();
        if (!empty($result)) {
            foreach ($result as $rowValue) {

                $items[] = array(
                    "deviceid" => $rowValue['nhdin'],
                    "device_name" => $rowValue['device_name'],
                    "received_product" => $rowValue['received_product'],
                    "product_condition" => $rowValue['product_condition'],
                    "damage_type" => $rowValue['damage_type'],
                    "dent_type" => $rowValue['dent_type'],
                    "remarks" => $rowValue['remarks'],
                    "category" => $rowValue['category'],
                    "sku" => $rowValue['sku'],
                    "grade" => $rowValue['grade'],
                    "price" => $rowValue['price'],
                    "taxable_amount" => $rowValue['taxable_amount'],
                    "exempt_amount" => $rowValue['exempt_amount'],
                    "tax_amount" => $rowValue['tax_amount'],
                    "tax_type" => $rowValue['tax_type'],
                    "bill_type" => $rowValue['bill_type'],
                );
            }
        }

        return $items;
    }


    public function getClaimHeader($claims_id = 0)
    {

        if ((int) $claims_id <= 0) {

            return false;
        }

        $result = $this->db->where('claims_id', $claims_id)->get('CLAIMS_LIST_VIEW')->row();
        $header = [];

        if (empty($result)) {
            return false;
        }

        $header = array(

            "claim_no" => $result->claim_no,
            "incident_no" => $result->incident_no,
            "claim_date" => $result->claim_date,
            "salesreturn_id" => $result->salesreturn_id,
            "salesreturn_no" => $result->salesreturn_no,
            "invoice_id" => $result->invoice_id,
            "invoice_no" => $result->invoice_no,
            "invoice_amount" => $result->invoice_amount,
            "salesorder_no" => $result->salesorder_no,
            "salesorder_id" => $result->salesorder_id,
            "sales_channel" => $result->sales_channel,
            "status" => $result->status,
            "approved_amount" => $result->approved_amount,
            "approved_date" => $result->approved_date,
            "payment_ref_id" => $result->payment_ref_id,
            "saleschannel_ref_id" => $result->saleschannel_ref_id,
            "vendor_id" => $result->vendor_id,
            "vendor_name" => $result->vendor_name,
            "quantity" => $result->quantity,
            "claim_amount" => $result->claim_amount,
            "created_by" => $result->created_by,
            "last_updated_by" => $result->last_updated_by,
            "creation_date" => $result->CREATION_DATE,
            "last_update_date" => $result->LAST_UPDATE_DATE,
        );

        return $header;
    }

    public function getFFInvoiceHeader($ecom_invoice_id = 0)
    {

        if ((int) $ecom_invoice_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->where('ecom_invoice_id', $ecom_invoice_id);
        $result = $this->db->get('ECOM_INVOICE_LIST_VIEW')->row();

        if (empty($result)) {
            return false;
        }
        $records = array();

        $records = array(
            'ecom_invoice_id' => $result->ecom_invoice_id,
            'ecom_invoice_no' => $result->ecom_invoice_no,
            'creditnote_no' => $result->creditnote_no,
            'vendor_name' => $result->vendor_name,
            'vendor_id' => $result->vendor_id,
            'salesman' => $result->salesman,
            'salesman_id' => $result->salesman_id,
            'status' => $result->status,
            'payment_mode' => $result->payment_mode,
            'warehouse' => $result->warehouse,
            'sales_channel' => $result->sales_channel,
            'saleschannel_ref_id' => $result->saleschannel_ref_id,
            'invoice_ref_id' => $result->invoice_ref_id,
            'quantity' => $result->quantity,
            'total_amount' => $result->invoice_amount,
            'total_taxable' => $result->taxable_amount,
            'total_exempt' => $result->exempt_amount,
            'total_tax' => $result->tax_amount,
            'created_by' => $result->created_by,
            'last_updated_by' => $result->last_updated_by,
            "sale_date" => date("d-m-Y", strtotime($result->sale_date)),
            "returned_date" => date("d-m-Y", strtotime($result->returned_date)),
            "creation_date" => date("d-m-Y", strtotime($result->creation_date)),
            "last_update_date" => date("d-m-Y", strtotime($result->last_update_date))
        );

        return $records;
    }

    public function getFFInvoiceItems($ecom_invoice_id = 0)
    {

        if (empty($ecom_invoice_id) || (int) $ecom_invoice_id <= 0) {
            return false;
        }

        $this->db->where('ecom_invoice_id', $ecom_invoice_id);
        $result = $this->db->get('ECOM_INVOICE_ITEM_VIEW')->result_array();

        $records = array();
        if (!empty($result)) {
            foreach ($result as $rowValue) {
                $records[] = array(
                    "nhdin" => $rowValue['nhdin'],
                    "device_name" => $rowValue['device_name'],
                    "stock_type" => $rowValue['stock_type'],
                    "grade" => $rowValue['grade'],
                    "sku" => $rowValue['sku'],
                    "fnsku" => $rowValue['fnsku'],
                    "price" => $rowValue['price'],
                    "taxable_amount" => $rowValue['taxable_amount'],
                    "exempt_amount" => $rowValue['exempt_amount'],
                    "tax_amount" => $rowValue['tax_amount'],
                    "tax_type" => $rowValue['tax_type'],
                    "bill_type" => $rowValue['bill_type'],
                );
            }
        }

        return $records;
    }

    public function getStocktransferHeader($stocktransfer_id = 0, $st_type = '')
    {
        if (empty($st_type) || (int) $stocktransfer_id <= 0) {
            return false;
        }

        if ($st_type == 'OUTWARD') {
            $this->db->where('stocktransfer_id', $stocktransfer_id);
            $result = $this->db->get('STOCKTRANSFER_NOTE_LIST_VIEW')->row_array();
        } else if ($st_type == 'INWARD') {
            $this->db->where('stocktransfer_id', $stocktransfer_id);
            $result = $this->db->get('STOCKTRANSFER_NOTE_LIST_VIEW')->row_array();
        } else {
            return false;
        }

        if (empty($result)) {
            return false;
        }
        $stocktransfer_date = date("d-m-Y", strtotime($result["stocktransfer_date"]));
        if ($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001') {
            $stocktransfer_date = '';
        }
        $header = array(
            "stocktransfer_id" => $result["stocktransfer_id"],
            "website" => $result["website"],
            "stocktransfer_type" => $result["st_type"],
            "from_loc" => $result["from_loc"],
            "to_loc" => $result["to_loc"],
            "status" => $result["status"],
            "tracking_id" => $result["tracking_id"],
            "tracking_name" => $result["tracking_name"],
            "removable_id" => $result["removable_id"],
            "total_amount" => $result["total_amount"],
            "total_quantity" => $result["total_quantity"],
            "stocktransfer_date" => $stocktransfer_date,
            "received_date" => $result['received_date'],
            "CREATED_BY" => $result["CREATED_BY"],
            "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
            "CREATION_DATE" => date("d-m-Y", strtotime($result["CREATION_DATE"])),
            "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($result["LAST_UPDATE_DATE"])),
        );

        return $header;
    }

    public function getStocktransferItems($stocktransfer_id = 0, $st_type = '')
    {
        if (empty($st_type) || (int) $stocktransfer_id <= 0) {
            return false;
        }
        if ($stocktransfer_id > 0) {

            $this->db->where('stocktransfer_id', $stocktransfer_id);
            $result = $this->db->get('STOCKTRANSFER_INVOICE_ITEM_VIEW')->result_array();

            if (!empty($result)) {

                foreach ($result as $rowValue) {

                    $rows[] = array(
                        "sku" => $rowValue["SKU"],
                        "grade" => $rowValue["certification_grade"],
                        "device_name" => $rowValue["device_name"],
                        "device_id" => $rowValue["nhdin"],
                        "category" => $rowValue["stock_type"],
                        "fnsku" => $rowValue["fnsku"],
                        "quantity" => 1,
                        "lpn_number" => $rowValue["lpn_number"],
                        "tracking_id" => $rowValue["tracking_id"],
                        "imei" => $rowValue["imei1_no"],
                        "exempt_amount" => $rowValue['exempt_amount'],
                        "taxable_amount" => $rowValue['taxable_amount'],
                        "tax_amount" => $rowValue['tax_amount'],
                        "tax_type" => $rowValue['tax_type'],
                        "price" => $rowValue['price'],
                        "unit_price" => $rowValue['unit_price'],
                        "unit_price_tax" => $rowValue['unit_price_tax'],
                    );
                }
            }
        }
        return $rows;
    }

    public function getBacthNoList()
    {

        $result = $this->db->select('distinct(batch_no)')->get('tbl_grnreport')->result_array();

        $json = $result;
        echo json_encode($json);
        die;
    }

    public function uploadPickList()
    {

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        $items = $data['items'];
        $batch_no = $data['batch_no'];
        $result = [];
        foreach ($items as $val) {
            $quantity = $val['quantity'];
            $array = array(
                "device_name" => $val["device_name"],
                'procurement_grade' => $val['procurement_grade'],
                'status' => 'RFS',
                'saletype' => 'OFFLINE',
                "batch_no" => $batch_no
            );

            $getdata = $this->db->select('nhdin, othervendor_id, product_brand, device_name, procurement_grade')->where($array)->limit($quantity)->get('tbl_grnreport')->result_array();

            foreach ($getdata as $rowValue) {
                $result[] = array(
                    "nhdin" => $rowValue["nhdin"],
                    "othervendor_id" => $rowValue["othervendor_id"],
                    "product_brand" => $rowValue["product_brand"],
                    "device_name" => $rowValue["device_name"],
                    "procurement_grade" => $rowValue["procurement_grade"],
                );
            }
        }

        $json = $result;
        echo json_encode($json);
        die;
    }

    public function addCustomerAlias()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        $alias = $data['alias'];
        $vendors = $data['vendors'];

        if (empty($alias) || empty($vendors)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if (($key = array_search($alias, $vendors)) !== false) {
            unset($vendors[$key]);
        }
        
        $update = $this->db->where('vendor_id', $alias);
        $this->db->set('business_role', "PARENT")->update('tbl_vendor');
        if($update){
            
            $this->db->where_in('vendor_id', $vendors);
            $this->db->set('business_role', "CHILD")->update('tbl_vendor');
        }
        
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getVendorAliases()
    {
        $data = [];
        $result = $this->db->select('alias')->group_by('alias')->get('tbl_vendor')->result_array();

        foreach ($result as $rowValue) {
            if (!empty($rowValue['alias'])) {
                $data[] = array(
                    "alias_name" => $rowValue['alias'],
                );
            }
        }

        $json['result'] = $data;
        echo json_encode($json);
        exit;
    }

    public function getInvoiceListByAlias()
    {

        $alias = $this->input->get('alias_name');
        $ref_id = $this->input->get('ref_id');
        $data = array();

        if (empty($alias)) {
            $result['data'] = $data;
            echo json_encode($result);
            die;
        }

        if(!empty($ref_id)){
            $this->db->where('saleschannel_ref_id', $ref_id);
        }

        $invoiceList = $this->db->where_in('alias', $alias)->where('status != "VOID"')->get('INVOICE_LIST_VIEW')->result_array();

        if (!empty($invoiceList)) {
            foreach ($invoiceList as $invoice) {
                $net_invoice_amount = $invoice['amount'] - $invoice['discount_amount'] + $invoice['insurance_amount'] + $invoice['freight_amount'] + $invoice['tcs_amount'];
                $data[] = array(
                    "invoice_id" => $invoice['invoice_id'],
                    "invoice_code" => $invoice['invoice_code'],
                    "vendor_name" => $invoice['vendor_name'],
                    "salesman" => $invoice['salesman'],
                    "alias_name" => $invoice['alias'],
                    "status" => $invoice['status'],
                    "CREATION_DATE" => date('d-m-Y', strtotime($invoice['CREATION_DATE'])),
                    "LAST_UPDATE_DATE" => date('d-m-Y', strtotime($invoice['LAST_UPDATE_DATE'])),
                    "CREATED_BY" => $invoice['CREATED_BY'],
                    "LAST_UPDATED_BY" => $invoice['LAST_UPDATED_BY'],
                    "amount" => $invoice['amount'],
                    "tax" => $invoice['tax'],
                    "discount_amount" => $invoice['discount_amount'],
                    "freight_amount" => $invoice['freight_amount'],
                    "insurance_amount" => $invoice['insurance_amount'],
                    "tcs_amount" => $invoice['tcs_amount'],
                    "net_invoice_amount" => $net_invoice_amount,
                    "amount_ex_tax" => round($invoice['amount'] - $invoice['tax'], 2),
                    "sales_code" => $invoice['sales_code'],
                    "sales_channel" => $invoice['sales_channel'],
                    "saleschannel_ref_id" => $invoice['saleschannel_ref_id'],
                    "payment_mode" => $invoice['payment_mode'],
                    "quantity" => $invoice['quantity'],
                );
            }
        }

        $result['data'] = $data;

        echo json_encode($result);

        die;
    }

    public function getSaleschannelRefIdByAlias()
    {
        $alias_name = $this->input->get('alias_name');
        if (empty($alias_name)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $rows = [];
        $this->db->select('saleschannel_ref_id')->where_in('alias', $alias_name)->where('status != "VOID"');
        $result = $this->db->group_by('saleschannel_ref_id')->get('INVOICE_LIST_VIEW')->result_array();
        

        if (!empty($result)) {

            foreach ($result as $rowValue) {

                $rows[] = array(
                    "saleschannel_ref_id" => $rowValue['saleschannel_ref_id']
                );
            }
        }
        $json['result'] = $rows;
        echo json_encode($json);
        exit;
    }
}
