<?php
class Stocktransfer_out extends Admin_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->model('stocktransfer_model');
        $this->load->library('cliq_api');
    }

    public function manage_stocktransfer($active=0){
		
        $data['title'] = "STOCK TRANSFER";
        if($active>0){
            $data['active'] = $active;
        }else{
            $data["active"] = 1;
        }
        
        $data['subview'] = $this->load->view('admin/stocktransfer_out/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }
    
    public function getWareHouse(){
        
		$result=$this->db->get_where("tbl_wh_loc", array("warehouse" => "Sloyd"))->result_array();
		$json['status']='1';
		if(!empty($result)){
			foreach($result as $value){
					$salesorder[]=array(
						'warehouse'=>$value["warehouse"],
						'location'=>$value["warehouse"],
						'short_code'=>$value["short_code"]
					);
				}
				$json['result']=$salesorder;
		}
		echo json_encode($json);
		die;
	}
	
	public function getBulk_Tdidwise_Stock() {
		$request = file_get_contents('php://input', true);
		$req_data = json_decode($request, true);
		$td_list = [];
		foreach($req_data as $k => $v) {
			$td_id = $v['device_id'];
			array_push($td_list, $td_id);
		}
		$validateData = $this->db->select('nhdin, status')->from('tbl_grnreport')
		    ->where('saletype','OFFLINE')->where_in('nhdin', $td_list)
		    ->where_not_in('status', 'RFS')->get()->result();
		//echo "<pre>"; print_r($validateData); echo "</pre>"; exit;
		if(!empty($validateData)){
		    foreach($validateData as $key => $value) {
		        echo json_encode([
        			'status' => 0,
        			'message' => $value->nhdin. " is not a RFS / OFFLINE device"
        		]);
        		
		    }
		}
		
		$result = $this->db->select('*')->from('tbl_grnreport')->where_in('nhdin', $td_list)->get()->result();
		    
		$avble_stock = [];
        
		foreach($result as $k => $v) {
			
			$avble_stock[] = array(
			    "grnreport_id" => $v->grnreport_id,
			    "category" => $v->stock_type,
			    "nhdin" => $v->nhdin,
			    "device_name" => $v->device_name,
			    "sku" => $v->SKU,
			    "grade" => $v->certification_grade
			    );
		}

		echo json_encode([
			'status' => true,
			'data' => $avble_stock
		]);
		exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => 'Something went wrong'
		]);
		exit;
	}
	
    
    public function createStocktransfer(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        
        $from_loc = $data[0]['from_loc'];
        
        $warehouse = $this->db->get_where("tbl_wh_loc", array("short_code" => $from_loc))->row()->city;
		$warehouse = strtoupper($warehouse);
		
        $data = $data[0];
        $rows = $data['rows'];
        $category = $data['category'] ;
        $grn_ids = [];
        foreach($rows as $val){
            array_push($grn_ids, $val['grnreport_id']);
        }
        //$this->db->trans_start();
        
        $grn_data = $this->db->where_in('grnreport_id', $grn_ids)->select('nhdin,warehouse, stock_type')->from('tbl_grnreport')->get()->result();
        
        if(!empty($grn_data)){
            foreach($grn_data as $grn_val){
                if($grn_val->stock_type != $category || $grn_val->warehouse != $warehouse){
                    $json['status'] = 2;
                    $json['message'] = $grn_val->nhdin .  " Not in ". $category . " or Not in " .$warehouse . " location";
                    echo json_encode($json);
                    die;
                }
                 
            }
        }
        
        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(stn_no,"-",-1) as UNSIGNED)) as max')->from('tbl_offline_stocktransfer')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }
        $stn_no = "SLY-STO-".$data['from_loc']."-".$next_number;
        $header_arr = array(
            "stn_no" => $stn_no,
            "category" => $category,
            "from_loc" => $data['from_loc'],
            "to_loc" => $data['to_loc'],
            "status" => "NEW",
            "stn_date" => $data['stocktransfer_date'],
            "created_by" => $this->session->userdata('user_id'),
            "last_updated_by" => $this->session->userdata('user_id')
            
            );
        $this->db->insert('tbl_offline_stocktransfer', $header_arr);
        $insert_id = $this->db->insert_id();
        $error = $this->db->error();
        
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }
        $row_arr = [];
        foreach($rows as $row_val){
            $row_arr[] = array(
                "stn_id" => $insert_id,
                "grnreport_id" => $row_val['grnreport_id'],
                "grade" => $row_val['grade']
                );
        }
        $this->db->insert_batch('tbl_offline_stocktransfer_item', $row_arr);
        $this->db->where_in('grnreport_id', $grn_ids);
        $this->db->update('tbl_grnreport', array("status"=>"STN"));
        
        $created_user = $this->db->get_where("tbl_users", array("user_id" => $header_arr['created_by']))->row()->username;
        $header_arr['created_user'] = $created_user;
        $header_arr['total_qty'] = count($rows);
        $error = $this->db->error();
        
        if($error['code']==0){
					$data['status']=1;
					$this->cliq_api->postOfflineStocktransferImage($header_arr);
				}else{
					$data['status']=0;
				}
        
        
        // if ($error['code'] != 0) {
        //     $this->db->trans_rollback();
        //     $json_arr['status'] = 0;
        //     $json_arr['message'] = $error['message'];
        //     echo json_encode($json_arr);
        //     exit;
        // }
        //$this->cliq_api->postOfflineStocktransferImage($header_arr);
        // Complete Mysql Transaction
        echo json_encode($data);
		
        //$this->db->trans_complete();
        exit;
    }

    public function getStocktransferList(){

        $status =  $this->input->get('status');
        if($status == ''){
            $status = 'NEW';
        }

        $result = array();
        $result = $this->db->get_where('tbl_offline_stocktransfer', array('status' => $status))->result_array();
        
        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
        foreach($result as $rowValue){
             $stocktransfer_date = date("d-m-Y", strtotime($rowValue['stn_date']));
                if($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001'){
                    $stocktransfer_date = '';
                }
            $last_updated_by = $this->db->get_where("tbl_users", array("user_id" => $rowValue['last_updated_by']))->row()->username;
            $stn_count = $this->db->get_where("tbl_offline_stocktransfer_item", array("stn_id" => $rowValue['stn_id']))->num_rows();
            $rows[] = array(
                        "stn_id" => $rowValue["stn_id"],
                        "stn_no" => $rowValue["stn_no"],
                        "from_loc" => $rowValue["from_loc"],
                        "to_loc" => $rowValue["to_loc"],
                        "total_quantity" => $stn_count,
                        "status" => $rowValue["status"],
                        "stn_date" =>$stocktransfer_date,    
                        "LAST_UPDATED_BY" => $last_updated_by,
                        "CREATION_DATE" => date("d-m-Y",strtotime($rowValue["created_date"])),
                        "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($rowValue["last_updated_date"])),
                    );
        }

        $json["data"] = $rows;
        echo json_encode($json);
        die;
        
    }
    
    public function getStocktransferDetails(){

        $stocktransfer_id = $this->input->get('stn_id');
        if($stocktransfer_id>0){

           $result = $this->db->get_where("tbl_offline_stocktransfer_item", array("stn_id" => $stocktransfer_id))->result_array();;
            if(!empty($result)){

                foreach($result as $rowValue){
                    $grnreport_id = $rowValue['grnreport_id'];
                    $grn_data = $this->db->get_where("tbl_grnreport", array("grnreport_id" => $grnreport_id))->row_array();
                    $rows[] = array(
                                "stn_item_id" => $rowValue["stn_item_id"],
                                "nhdin" => $grn_data["nhdin"],
                                "sku" => $grn_data["SKU"],
                                "grade" => $rowValue["grade"],
                                "device_name" => $grn_data["device_name"],
                                "stock_type" => $grn_data["stock_type"]
                        );
                }
            }
        }

        $json['result'] = $rows;
        echo json_encode($json);
        exit;
    }
    public function dowloadStocktransferItems()
    {

        $stn_id = $this->input->get('stn_id');
        
        if( (int) $stn_id <=0){

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $stn_no = $this->db->get_where("tbl_offline_stocktransfer", array("stn_id" => $stn_id))->row()->stn_no;
        $csv_output = "DEVICE ID, CATEGORY, PRODUCT BRAND, DEVICE NAME, COLOR, RAM, ROM, SKU, GRADE";
        $rows = [];
        $result = $this->db->get_where("tbl_offline_stocktransfer_item", array("stn_id" => $stn_id))->result_array();
        if(!empty($result)){

            foreach($result as $rowValue){
                $grnreport_id = $rowValue['grnreport_id'];
                $grn_data = $this->db->get_where("tbl_grnreport", array("grnreport_id" => $grnreport_id))->row_array();
                $rows[] = array(
                            "nhdin" => $grn_data["nhdin"],
                            "product_brand" => $grn_data["product_brand"],
                            "color" => $grn_data["color"],
                            "ram" => $grn_data["ram"],
                            "rom" => $grn_data["rom"],
                            "sku" => $grn_data["sku"],
                            "grade" => $rowValue["grade"],
                            "device_name" => $grn_data["device_name"],
                            "stock_type" => $grn_data["stock_type"]
                    );
            }
        }
      
        $csv_output .= "\n";
        if (!empty($rows)) {
            foreach ($rows as $periodic_report) {

                $csv_output .= $periodic_report['nhdin'] . ",";
                $csv_output .= $periodic_report['stock_type'] . ",";
                $csv_output .= $periodic_report['product_brand'] . ",";
                $csv_output .= $periodic_report['device_name'] . ",";
                $csv_output .= $periodic_report['color'] . ",";
                $csv_output .= $periodic_report['ram'] . ",";
                $csv_output .= $periodic_report['rom'] . ",";
                $csv_output .= $periodic_report['sku'] . ",";
                $csv_output .= $periodic_report['grade'] . ",";
		        
                $csv_output .= "\n";
            }
        }
        if (empty($rows)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $filename = $stn_no."_device_list";
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;
    }
    
    public function approveStockTransfer(){
        
        $stn_id = $this->input->get('stn_id');
        if((int)$stn_id <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $status = $this->input->get('status');
        if($status == "INVOICED"){
            //$this->db->trans_start();
            $stn_data = $this->db->get_where("tbl_offline_stocktransfer", array("stn_id" => $stn_id))->row();
            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(invoice_no,"-",-1) as UNSIGNED)) as max')->from('tbl_offline_stocktransfer_invoice')->get()->row_array();
            $next_number = $res['max'] + 1;
    
            if ($res['max'] == null) {
                $next_number = 1;
            }
            $invoice_no = "SLY-STN-".$stn_data->from_loc."-".$next_number;
            $header_arr = array(
                "invoice_no" => $invoice_no,
                "stn_id" => $stn_id,
                "category" => $stn_data->category,
                "status" => $status,
                "created_by" => $this->session->userdata('user_id'),
                "last_updated_by" => $this->session->userdata('user_id')
                
                );
            $this->db->insert('tbl_offline_stocktransfer_invoice', $header_arr);
            $insert_id = $this->db->insert_id();
            $error = $this->db->error();
            
            if ($insert_id <= 0) {
                $json_arr['message'] = $error['message'];
                echo json_encode($json_arr);
                exit;
            }
            $stn_items = $this->db->get_where("tbl_offline_stocktransfer_item", array("stn_id" => $stn_id))->result_array();
            $row_arr = [];
            foreach($stn_items as $row_val){
                $grn_data = $this->db->get_where("tbl_grnreport", array("grnreport_id" => $row_val['grnreport_id']))->row_array();
                
                if($stn_data->category == "OPEN BOX" || $stn_data->category == "NEW"){
                    $tax_percentage = 18;
                    $tax_amount = ($grn_data['unit_price'] * 18 ) / 100;
                } else {
                    $tax_percentage = 0;
                    $tax_amount = 0;
                }
                $row_arr[] = array(
                    "invoice_id" => $insert_id,
                    "grnreport_id" => $row_val['grnreport_id'],
                    "grade" => $row_val['grade'],
                    "purchase_cost" => $grn_data['unit_price'],
                    "tax_percent" => $tax_percentage,
                    "tax_amount" => $tax_amount,
                    
                    );
            }
            $this->db->insert_batch('tbl_offline_stocktransfer_invoice_item', $row_arr);
            
            $stn_arr = array(
                "status" => $status,
                "last_updated_by" => $this->session->userdata('user_id')
                
                );
            $update_stn = $this->db->where('stn_id', $stn_id)->update("tbl_offline_stocktransfer", $stn_arr);
            $created_user = $this->db->get_where("tbl_users", array("user_id" => $header_arr['last_updated_by']))->row()->username;
            $header_arr['created_user'] = $created_user;
            $header_arr['invoice_no'] = $invoice_no;
            $header_arr['stn_no'] = $stn_data->stn_no;
            $header_arr['from_loc'] = $stn_data->from_loc;
            $header_arr['to_loc'] = $stn_data->to_loc;
            $header_arr['stn_date'] = $stn_data->stn_date;
            $header_arr['category'] = $stn_data->category;
            $header_arr['status'] = $status;
            $header_arr['total_qty'] = $this->db->get_where("tbl_offline_stocktransfer_item", array("stn_id" => $stn_id))->num_rows();
            
            $error = $this->db->error();
            if($error['code']==0){
					$data['status']=1;
					$this->cliq_api->postOfflineStocktransferImage($header_arr);
				}else{
					$data['status']=0;
				}
				
            //$this->cliq_api->postOfflineStocktransferImage($header_arr);
            //$this->db->trans_complete(); // Complete Mysql Transaction
            //$json['status'] = 1;
            echo json_encode($json);
            exit;
        } else if($status == "PACKED"){
            
            $stn_data = $this->db->get_where("tbl_offline_stocktransfer", array("stn_id" => $stn_id))->row();
            
            //$this->db->trans_start();
            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(morn_no,"-",-1) as UNSIGNED)) as max')->from('tbl_offline_stocktransfer_invoice')->get()->row_array();
            $next_number = $res['max'] + 1;
    
            if ($res['max'] == null) {
                $next_number = 1;
            }
            $morn_no = "SLY-MORN-".$stn_data->from_loc."-".$next_number;
            $header_arr = array(
                "morn_no" => $morn_no,
                "status" => $status,
                "last_updated_by" => $this->session->userdata('user_id')
                
                );
            $this->db->where('stn_id',$stn_id)->update('tbl_offline_stocktransfer_invoice', $header_arr);
            
            $stn_arr = array(
                "status" => $status,
                "last_updated_by" => $this->session->userdata('user_id')
                
                );
            $update_stn = $this->db->where('stn_id', $stn_id)->update("tbl_offline_stocktransfer", $stn_arr);
            
            $created_user = $this->db->get_where("tbl_users", array("user_id" => $header_arr['last_updated_by']))->row()->username;
            $header_arr['invoice_no'] = $this->db->get_where("tbl_offline_stocktransfer_invoice", array("stn_id" => $stn_id))->row()->invoice_no;
            $header_arr['morn_no'] = $morn_no;
            $header_arr['created_user'] = $created_user;
            $header_arr['stn_no'] = $stn_data->stn_no;
            $header_arr['from_loc'] = $stn_data->from_loc;
            $header_arr['to_loc'] = $stn_data->to_loc;
            $header_arr['stn_date'] = $stn_data->stn_date;
            $header_arr['category'] = $stn_data->category;
            $header_arr['status'] = $status;
            $header_arr['total_qty'] = $this->db->get_where("tbl_offline_stocktransfer_item", array("stn_id" => $stn_id))->num_rows();
            $error = $this->db->error();
            if($error['code']==0){
					$data['status']=1;
					$this->cliq_api->postOfflineStocktransferImage($header_arr);
				}else{
					$data['status']=0;
				}
            
            //$this->db->trans_complete(); // Complete Mysql Transaction
            $json['status'] = 1;
            echo json_encode($json);
            exit;
        }

	}
	
	public function getStocktransferInvoiceList(){
        $status =  $this->input->get('status');
        if($status == ''){
            $status = 'INVOICED';
        }

        $result = $this->db->get_where("tbl_offline_stocktransfer_invoice", array("status" => $status))->result_array();
        
        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $rows = [];
        foreach($result as $rowValue){
            
            $stn_data = $this->db->get_where("tbl_offline_stocktransfer", array("stn_id" => $rowValue["stn_id"]))->row_array();
            $inv_data = $this->db->select('COUNT(invoice_id) as total_quantity, SUM(purchase_cost) as total_amount, SUM(tax_amount) as total_tax')
                ->where(array("invoice_id" => $rowValue["invoice_id"]))->get("tbl_offline_stocktransfer_invoice_item")->row_array();
            if($stn_data['category'] == "OPEN BOX" || $stn_data['category'] == "NEW"){
                 $total_taxable = $inv_data["total_amount"];
            } else {
                $total_taxable = 0;
            }
            $rows[] = array(
                        "stocktransfer_id" => $rowValue["stn_id"],
                        "invoice_no" => $rowValue["invoice_no"],
                        "stocktransfer_series_no" => $stn_data['stn_no'],
                        "from_loc" => $stn_data["from_loc"],
                        "to_loc" => $stn_data["to_loc"],
                        "total_quantity" => $inv_data["total_quantity"],
                        "total_amount" => $inv_data["total_amount"],
                        "total_taxable" => $total_taxable,
                        "total_tax" => $inv_data["total_tax"],
                        "status" => $rowValue["status"],
                        "CREATION_DATE" => date("Y-m-d",strtotime($rowValue["created_date"])),
                        "LAST_UPDATE_DATE" => date("Y-m-d", strtotime($rowValue["updated_date"])),
                    );
        }

        $json["data"] = $rows;
        echo json_encode($json);
        die;
        
    }
    public function createDispatchForm($stocktransfer_id){
        
        $data['title'] = "DISPATCH STOCK TRANSFER";

        if($stocktransfer_id>0){
            
            $result = $this->db->select('status')->where('stn_id',$stocktransfer_id)->get('tbl_offline_stocktransfer')->row();
            
            if($result->status == 'PACKED'){
                $data['active'] = 7;
                $data["stocktransfer_id"] = $stocktransfer_id;
            }
        }

        if($data['active'] != 7){
            $data['active'] = 1;
        }

        $data['subview'] = $this->load->view('admin/stocktransfer_out/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }
    public function getStocktransferInvoiceHeader($stocktransfer_id=0){
        
        
        if($stocktransfer_id > 0){
            $result = $this->db->get_where("tbl_offline_stocktransfer_invoice", array("stn_id" => $stocktransfer_id))->row_array();
        } else{
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $stn_data = $this->db->get_where("tbl_offline_stocktransfer", array("stn_id" => $stocktransfer_id))->row_array();
        $inv_data = $this->db->select('COUNT(stn_item_id) as total_quantity')
            ->where(array("stn_id" => $stocktransfer_id))->get("tbl_offline_stocktransfer_item")->row_array();
        $invoice_header = $this->db->get_where("tbl_offline_stocktransfer_invoice", array("stn_id" => $stocktransfer_id))->row();
        $invoice_no = $invoice_header->invoice_no;
        $invoice_id = $invoice_header->invoice_id;
        $rows = array(
                    "stocktransfer_id" => $result["stocktransfer_id"],
                    "stn_no" => $stn_data["stn_no"],
                    "invoice_no" => $invoice_no,
                    "invoice_id" => $invoice_id,
                    "to_loc" => $stn_data["to_loc"],
                    "from_loc" => $stn_data["from_loc"],
                    "to_loc" => $stn_data["to_loc"],
                    "total_quantity" => $inv_data["total_quantity"],
                    "LAST_UPDATE_DATE" => date("Y-m-d", strtotime($result["LAST_UPDATE_DATE"])),
                );

        $json["result"] = $rows;
        echo json_encode($json);
        die;
    }
    
    public function createDispatch($stocktransfer_id){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data) || (int) $stocktransfer_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $user_id = $this->session->userdata('user_id');

        foreach($data as $rowValue){

            $packages[] = array(
                "package_no" => $rowValue['package_no'],
                "quantity" => $rowValue['package_qty'],
                "stocktransfer_id" => $stocktransfer_id,
                "CREATED_BY" => $user_id
            );
        }

        if(empty($packages)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->db->insert_batch('tbl_offline_stocktransfer_dispatch', $packages);
        $insertId = $this->db->insert_id();
        if($insertId <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        //echo "Enterd In"; exit;
        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(gate_pass_no,"-",-1) as UNSIGNED)) as max')->from('tbl_offline_shipping_list')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }
        $stn_data = $this->db->get_where("tbl_offline_stocktransfer", array("stn_id" => $stocktransfer_id))->row_array();
        $gate_pass_no = "GP-STN-".$stn_data['from_loc']."-".$next_number;
        $shipping_list = array(
            
                "invoice_id" => $data[0]['invoice_id'],
                "stn_id" => $stocktransfer_id,
                "delivery_mode" => $data[0]['delivery_mode'],
                "pickup_boy" => $data[0]['pickup_by'],
                "logistics_partner_name" => $data[0]['lp_name'],
                "docket_number" => $data[0]['docket_no'],
                "gate_pass_no" => $gate_pass_no,
                "user_id" => $user_id
            );
        $this->db->insert('tbl_offline_shipping_list', $shipping_list);
        
        $status = array("status" => 'DISPATCHED', "LAST_UPDATED_BY" => $user_id);
        $this->db->where('stn_id', $stocktransfer_id)->update('tbl_offline_stocktransfer', $status);
        $this->db->where('stn_id', $stocktransfer_id)->update('tbl_offline_stocktransfer_invoice', $status);
        
        $gatePassData = $this->db->select('st.*, si.invoice_no, si.morn_no,COUNT(sii.invoice_id) as quantity,sl.gate_pass_no')->from('tbl_offline_stocktransfer st')
            ->join('tbl_offline_stocktransfer_invoice si', 'st.stn_id = si.stn_id')
            ->join('tbl_offline_stocktransfer_invoice_item sii', 'si.invoice_id = sii.invoice_id')
            ->join('tbl_offline_shipping_list sl', 'si.stn_id = sl.stn_id')->get()->row_result();
        
            $created_user = $this->db->get_where("tbl_users", array("user_id" => $gatePassData['last_updated_by']))->row()->username;
            $header_arr['invoice_no'] = $gatePassData['invoice_no'];
            $header_arr['created_user'] = $created_user;
            $header_arr['stn_no'] = $gatePassData['stn_no'];
            $header_arr['from_loc'] = $gatePassData['from_loc'];
            $header_arr['to_loc'] = $gatePassData['to_loc'];
            $header_arr['stn_date'] = $gatePassData['stn_date'];
            $header_arr['category'] = $gatePassData['category'];
            $header_arr['status'] = $gatePassData['status'];
            $header_arr['total_qty'] = $gatePassData['quantity'];
            $header_arr['gate_pass_no'] = $gatePassData['gate_pass_no'];
            $header_arr['morn_no'] = $gatePassData['morn_no'];
            $error = $this->db->error();
            if($error['code']==0){
					$data['status']=1;
					$this->cliq_api->postOfflineStocktransferImage($header_arr);
				}else{
					$data['status']=0;
				}
        
        echo json_encode($json);
        die;
    }
    public function gatepass_pdf($stocktransfer_id = 0)
	{

        $download = $this->input->get('download');

		if ((int) $stocktransfer_id <= 0) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
        //echo "Enterd"; exit;
		$ship_details = $this->db->where('stn_id', $stocktransfer_id)->get('tbl_offline_shipping_list')->row();

		$gatepass_no = $ship_details->gate_pass_no;
		$invoice_id = $ship_details->invoice_id;
		$stn_id = $ship_details->stn_id;
		$date = $ship_details->CREATION_DATE;
        

		if (empty($ship_details)) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
        $stn_data = $this->db->select('*')->where('stn_id', $stocktransfer_id)->get('tbl_offline_stocktransfer')->row();
		$category = $stn_data->category;
		$from_loc = $stn_data->from_loc;
		$to_loc = $stn_data->to_loc;
		
		$invoice_no = $this->db->select('*')->where('stn_id', $stocktransfer_id)->get('tbl_offline_stocktransfer_invoice')->row()->invoice_no;
		$ship_details = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('tbl_offline_stocktransfer_dispatch')->row();
		
		$from_addr =  $this->db->select('address')->where('short_code', $from_loc)->get('tbl_wh_loc')->row()->address;
		
		$data['from_addr'] = $from_addr;
		$data['invoice_code'] = $invoice_no;
		$data['stock_type'] = $category;
		$data['gatepass_no'] = $gatepass_no;
		$data['quantity'] = $ship_details->quantity;
		$data['package'] = $ship_details->package_no;
		$data['date'] = date('d-m-Y', strtotime($date));

		$this->load->helper('dompdf');

		$viewfile = $this->load->view('admin/stocktransfer_out/stn_gatepass', $data, TRUE);

		pdf_picklist($viewfile, "gatepass#" . $stocktransfer_id, TRUE, '', $download, '', '');
	}
	
	public function invoicePdf(){
        
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $type = $this->input->get('type');
        if((int) $stocktransfer_id <=0){
            return false;
        }

        $download=$this->input->get('download');
        
        $result = $this->db->from('tbl_offline_stocktransfer_invoice AS sti')
                ->join('tbl_offline_stocktransfer AS st', 'st.stn_id = sti.stn_id', 'INNER')
                ->join('tbl_offline_stocktransfer_invoice_item AS stii', 'stii.invoice_id = sti.invoice_id', 'INNER')
                ->join('tbl_grnreport AS d', 'd.grnreport_id = stii.grnreport_id', 'Left')
                ->where('sti.stn_id', $stocktransfer_id)
                //->group_by('stii.invoice_id')
                ->select("sti.*, stii.*,  st.from_loc, st.to_loc")
                ->select("d.nhdin, d.device_name, d.sku, d.imei1_no, d.imei2_no, d.stock_type")
                ->get()->result_array();
        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $total_amount = 0;
        $total_tax = 0;
        $total_taxable = 0;
        $total_exempt = 0;
        $total_price = 0;
        if(!empty($result)){
        
            foreach($result as $value){
                
                    if($value['category'] == "OPEN BOX" || $value['category'] == "NEW"){
                        $taxable_amount = $value['purchase_cost'];
                        $exempt_amount = 0;
                        $tax_rate = 18;
                    } else{
                        $taxable_amount = 0;
                        $exempt_amount = $value['purchase_cost'];
                        $tax_rate = 0;
                    }
                    $total_taxable += $taxable_amount;
                    $total_amount += $value['purchase_cost'] + $value['tax_amount']; 
                    $total_tax += $value['tax_amount'];
                    $total_exempt += $exempt_amount;
                    $total_price += $value['purchase_cost'];
					$invoice_rows[]=array(
                        
                        'product_name' => $value["device_name"],
						'deviceid' => $value["nhdin"],
						'imei' => $value["imei1_no"],
						'category' => $value["stock_type"],
						'price' => $value["purchase_cost"],
						'taxable_amount'=> $taxable_amount,
						'exempt_amount' => $exempt_amount,
						'tax_amount' => $value["tax_amount"],
                        'tax_rate' => $tax_rate,                        
					);
			}
				$data['rows']=$invoice_rows;
        }
        
        //echo "<pre>"; print_r($data['rows']); echo "</pre>"; exit;
        //$header = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('STOCKTRANSFER_INVOICE_VIEW')->row();
        if(!empty($result)){
            
            $amount_words = $this->getIndianCurrency($total_amount);

            $from_wh = $this->db->where('short_code', $result[0]['from_loc'])->get('tbl_wh_loc')->row();
            $to_wh = $this->db->where('short_code', $result[0]['to_loc'])->get('tbl_wh_loc')->row();
            
            if(!empty($result["header"][0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id',substr($result["header"][0]["gst_no"],0,2))->get('tbl_states')->row();
            
            if($from_wh->state_gst_code == $to_wh->state_gst_code){
                $title = "Delivery Challan";
                $from = 'Consigner';
                $to = 'Consignee';
                $invoice_type = 'Challan Number';
                
                if(strtolower($type) == 'original'){
                    $type_str = 'ORIGINAL FOR CONSIGNEE';
                }
                if(strtolower($type) == 'duplicate'){
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if(strtolower($type) == 'triplicate'){
                    $type_str = 'TRIPLICATE FOR CONSIGNER';
                }

            }else{
                $title = 'Tax Invoice';
                $from = 'Bill To';
                $to = 'Ship To';
                $invoice_type = 'Invoice Number';
                if(strtolower($type) == 'original'){
                    $type_str = 'ORIGINAL FOR RECIPIENT';
                }
                if(strtolower($type) == 'duplicate'){
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if(strtolower($type) == 'triplicate'){
                    $type_str = 'TRIPLICATE FOR SUPPLIER';
                }
            }
            
            $data['from'] = $from;
            $data["from_wh"]["gst_number"] = $from_wh->gst_number;
            $data["from_wh"]["warehouse"] = $from_wh->warehouse;
            $data["from_wh"]["business_type"] = $from_wh->business_type;
            $data["from_wh"]["state"] = $from_wh->state;
            $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
            $data["from_wh"]["city"] = $from_wh->city;
            $data["from_wh"]["short_code"] = $from_wh->short_code;
            $data["from_wh"]["address"] = $from_wh->address;
           
            //To Warehouse
            $data['to'] = $to;
            $data["to_wh"]["gst_number"] = $to_wh->gst_number;
            $data["to_wh"]["warehouse"] = $to_wh->warehouse;
            $data["to_wh"]["business_type"] = $to_wh->business_type;
            $data["to_wh"]["state"] = $to_wh->state;
            $data["to_wh"]["state_id"] = $to_wh->state_gst_code;
            $data["to_wh"]["city"] = $to_wh->city;
            $data["to_wh"]["short_code"] = $to_wh->short_code;
            $data["to_wh"]["address"] = $to_wh->address;

            $data['title'] = $title;
            $data['type'] = $type_str;
            $data['invoice_type'] = $invoice_type;
            $data["st_invoice_no"] = $result[0]['invoice_no'];
            $data["date"] = date("d-m-Y",strtotime($result[0]['created_date']));
            $data["total_amount"] = $total_amount;
            $data["total_tax"] = $total_tax;
            $data["total_taxable"] = $total_taxable;
            $data["total_exempt"] = $total_exempt;
            $data["total_price"] = $total_price;
            $data['amount_words'] = $amount_words;
            
        }
       
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/stocktransfer_out/pdf_invoice', $data, TRUE);
        $header=$data["invoice_code"].' | '.$data['date'];
        pdf_create($viewfile, $data["invoice_code"],TRUE,'',$download,null,$header);
       
    }
    
    public function invoiceHeaderPdf(){
        
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $type = $this->input->get('type');
        if((int) $stocktransfer_id <=0){
            return false;
        }

        $download=$this->input->get('download');
        
        $result = $this->db->from('tbl_offline_stocktransfer_invoice AS sti')
                ->join('tbl_offline_stocktransfer AS st', 'st.stn_id = sti.stn_id', 'INNER')
                ->join('tbl_offline_stocktransfer_invoice_item AS stii', 'stii.invoice_id = sti.invoice_id', 'INNER')
                ->join('tbl_grnreport AS d', 'd.grnreport_id = stii.grnreport_id', 'Left')
                ->where('sti.stn_id', $stocktransfer_id)
                //->group_by('stii.invoice_id')
                ->select("sti.*, stii.*,  st.from_loc, st.to_loc")
                ->select("d.nhdin, d.device_name, d.sku, d.imei1_no, d.imei2_no, d.stock_type")
                ->get()->result_array();
        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $total_amount = 0;
        $total_tax = 0;
        $total_taxable = 0;
        $total_exempt = 0;
        $total_price = 0;
        $total_qty = 0;
        //$tax_rate = 0;
        if(!empty($result)){
        
            foreach($result as $value){
                
                    if($value['category'] == "OPEN BOX" || $value['category'] == "NEW"){
                        $taxable_amount = $value['purchase_cost'];
                        $exempt_amount = 0;
                        $tax_rate = 18;
                    } else{
                        $taxable_amount = 0;
                        $exempt_amount = $value['purchase_cost'];
                        $tax_rate = 0;
                    }
                    $total_qty += 1;
                    $total_taxable += $taxable_amount;
                    $total_amount += $value['purchase_cost'] + $value['tax_amount']; 
                    $total_tax += $value['tax_amount'];
                    $total_exempt += $exempt_amount;
                    $total_price += $value['purchase_cost'];
					$invoice_rows[]=array(
                        
                        'product_name' => $value["device_name"],
						'deviceid' => $value["nhdin"],
						'imei' => $value["imei1_no"],
						'category' => $value["stock_type"],
						'price' => $value["purchase_cost"],
						'taxable_amount'=> $taxable_amount,
						'exempt_amount' => $exempt_amount,
						'tax_amount' => $value["tax_amount"],
                        'tax_rate' => $tax_rate,                        
					);
			}
				$data['rows']=$invoice_rows;
        }
        
        //echo "<pre>"; print_r($data['rows']); echo "</pre>"; exit;
        //$header = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('STOCKTRANSFER_INVOICE_VIEW')->row();
        if(!empty($result)){
            
            $amount_words = $this->getIndianCurrency($total_amount);

            $from_wh = $this->db->where('short_code', $result[0]['from_loc'])->get('tbl_wh_loc')->row();
            $to_wh = $this->db->where('short_code', $result[0]['to_loc'])->get('tbl_wh_loc')->row();
            
            if(!empty($result["header"][0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id',substr($result["header"][0]["gst_no"],0,2))->get('tbl_states')->row();
            
            if($from_wh->state_gst_code == $to_wh->state_gst_code){
                $title = "Delivery Challan";
                $from = 'Consigner';
                $to = 'Consignee';
                $invoice_type = 'Challan Number';
                
                if(strtolower($type) == 'original'){
                    $type_str = 'ORIGINAL FOR CONSIGNEE';
                }
                if(strtolower($type) == 'duplicate'){
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if(strtolower($type) == 'triplicate'){
                    $type_str = 'TRIPLICATE FOR CONSIGNER';
                }

            }else{
                $title = 'Tax Invoice';
                $from = 'Bill To';
                $to = 'Ship To';
                $invoice_type = 'Invoice Number';
                if(strtolower($type) == 'original'){
                    $type_str = 'ORIGINAL FOR RECIPIENT';
                }
                if(strtolower($type) == 'duplicate'){
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if(strtolower($type) == 'triplicate'){
                    $type_str = 'TRIPLICATE FOR SUPPLIER';
                }
            }
            
            $data['from'] = $from;
            $data["from_wh"]["gst_number"] = $from_wh->gst_number;
            $data["from_wh"]["warehouse"] = $from_wh->warehouse;
            $data["from_wh"]["business_type"] = $from_wh->business_type;
            $data["from_wh"]["state"] = $from_wh->state;
            $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
            $data["from_wh"]["city"] = $from_wh->city;
            $data["from_wh"]["short_code"] = $from_wh->short_code;
            $data["from_wh"]["address"] = $from_wh->address;
           
            //To Warehouse
            $data['to'] = $to;
            $data["to_wh"]["gst_number"] = $to_wh->gst_number;
            $data["to_wh"]["warehouse"] = $to_wh->warehouse;
            $data["to_wh"]["business_type"] = $to_wh->business_type;
            $data["to_wh"]["state"] = $to_wh->state;
            $data["to_wh"]["state_id"] = $to_wh->state_gst_code;
            $data["to_wh"]["city"] = $to_wh->city;
            $data["to_wh"]["short_code"] = $to_wh->short_code;
            $data["to_wh"]["address"] = $to_wh->address;

            $data['title'] = $title;
            $data['type'] = $type_str;
            $data['invoice_type'] = $invoice_type;
            $data["st_invoice_no"] = $result[0]['invoice_no'];
            $data["date"] = date("d-m-Y",strtotime($result[0]['created_date']));
            $data["total_amount"] = $total_amount;
            $data["total_tax"] = $total_tax;
            $data["total_taxable"] = $total_taxable;
            $data["total_exempt"] = $total_exempt;
            $data["total_price"] = $total_price;
            $data['amount_words'] = $amount_words;
            $data['total_qty'] = $total_qty;
            $data['tax_rate'] = $tax_rate;
            $data['category'] = $result[0]['stock_type'];
            
        }
       
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/stocktransfer_out/pdf_header_invoice', $data, TRUE);
        $header=$data["invoice_code"].' | '.$data['date'];
        pdf_create($viewfile, $data["invoice_code"],TRUE,'',$download,null,$header);
       
    }
    
    public function cancelStocktransfer($stocktransfer_id){

        if( (int) $stocktransfer_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status=$this->Common_model->getRowResult('status','tbl_stocktransfer',array("stocktransfer_id"=>$stocktransfer_id));
		
		//Check Status of the Stocktransfer Order
		if($status['status'] !='NEW' && $status != 'FINANCE_REJECTED'){
            
            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $stocktransfer=array(
            'status' => "CANCELED",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();

        if($error['code'] != 0){
            
            $json['status']=0;
			echo json_encode($json);
			die;
        }
        $this->cliq_api->postStocktransferImage($stocktransfer_id);
        $json['status'] = 1;
		echo json_encode($json);
		die;

    }
    
    public function pickListPdf(){
        $stocktransfer_id = $this->input->get('stn_id');
        $grade_required = $this->input->get('grade'); 
		if($stocktransfer_id>0){
		$data=array();
	
        $stocktransfer = $this->db->get_where('tbl_offline_stocktransfer', array("stn_id"=>$stocktransfer_id))->row()->stn_no;
                            
        $data["stocktransfer_no"] = $stocktransfer;
        $data["date"] = date("d-m-Y", strtotime($stocktransfer->created_date));
        
		$this->db->select('grnreport_id, grade')->where('stn_id', $stocktransfer_id);
		$result = $this->db->get('tbl_offline_stocktransfer_item')->result_array();
		$grn_ids = [];
		foreach($result as $value){
		    array_push($grn_ids, $value['grnreport_id']);
		}
		
		$grn_data = $this->db->group_by('SKU')->where_in('grnreport_id', $grn_ids)->select('product_brand,device_name,SKU, COUNT(SKU) as qty')->get('tbl_grnreport')->result_array();
		
		if(!empty($grn_data)){
			foreach($grn_data as $val){
				//$device_data = $this->db->select('nhdin, product_brand,device_name,rom,ram,GROUP_CONCAT(distinct(bin_number)) as bin_number')->where('grnreport_id', $value['grnreport_id'])->get('tbl_grnreport')->row();
				$rows[]=array(
				    
					'device_name'=>$val['device_name'],
					'brand'=>$val['product_brand'],
                    'SKU'=>$val["SKU"],
                    'qty'=>$val['qty']
				
				);
				//$data['category'] = $device_data->stock_type;
			}
			$data["rows"] = $rows;
		}
		}
       $this->load->helper('dompdf');
		$viewfile = $this->load->view('admin/stocktransfer_out/picklist_stocktransfer_pdf', $data, TRUE);
		//var_dump($data);exit;
		pdf_picklist($viewfile, "PickList");

	}
    public function getStocktransferHeader($stocktransfer_id=0){

        if($stocktransfer_id>0){
            
            $result = $this->stocktransfer_model->getStocktransferheader($stocktransfer_id);
        }else{
            
            $json['data'] = array();
            echo json_encode($json);
            die;
        }

        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
            $stocktransfer_date = date("d-m-Y", strtotime($result["stocktransfer_date"]));
            if($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001'){
                $stocktransfer_date = '';
            }
            $rows[] = array(
                        "stocktransfer_id" => $result["stocktransfer_id"],
                        "website" => $result["website"],
                        "stocktransfer_type" => $result["st_type"],
                        "from_loc" => $result["from_loc"],
                        "to_loc" => $result["to_loc"],
                        "status" => $result["status"],
                        "tracking_id" => $result["tracking_id"],
                        "tracking_name" => $result["tracking_name"],
                        "total_amount" => $result["total_amount"],
                        "total_quantity" => $result["total_quantity"],
                        "stocktransfer_date"=> $stocktransfer_date,
                        "CREATED_BY" => $result["CREATED_BY"],
                        "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
                        "CREATION_DATE" => date("d-m-Y",strtotime($result["CREATION_DATE"])),
                        "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($result["LAST_UPDATE_DATE"])),
              );

        $json["data"] = $rows;
        echo json_encode($json);
        die;
    }

    public function getStocktransferInvoiceDetails(){
        
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        if($stocktransfer_id>0){

            $result = $this->stocktransfer_model->getStocktransferInvoiceDetails($stocktransfer_id);
             if(!empty($result)){
 
                 foreach($result as $rowValue){
                     $rows[] = array(
                                "nhdin" => $rowValue["nhdin"],
                                "imei1_no" => $rowValue["imei1_no"],
                                "imei2_no" => $rowValue["imei2_no"],
                                "sku" => $rowValue["sku"],
                                "grade" => $rowValue["grade"],
                                "device_name" => $rowValue["device_name"],
                                "stock_type" => $rowValue["stock_type"],
                                "fnsku" => $rowValue["fnsku"],
                                "lpn_number" => $rowValue["lpn_number"],
                                "price" => $rowValue["price"],
                                "taxable_amount" => $rowValue["taxable_amount"],
                                "exempt_amount" => $rowValue["exempt_amount"],
                                "tax_amount" => $rowValue["tax_amount"],
                                "tax_type" => $rowValue["tax_type"],
                                "stn_locns" => $rowValue["stn_locns"],
                                "st_from_loc" => $rowValue["st_from_loc"],
                                "st_to_loc" => $rowValue["st_to_loc"],
                             );
                 }
             }
         }
 
         $json['result'] = $rows;
         echo json_encode($json);
         exit;

    }

    public function getDeviceinfoByNhdin(){

        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $nhdin = $this->input->get('nhdin');

        if(empty($stocktransfer_id) || $stocktransfer_id<=0){
            $json['status']='0';
            $json['msg']="No Stocktransfer Note present".$stocktransfer_id;
            echo json_encode($json);
            die;
        }

		  $grnResult=$this->db->where('nhdin',$nhdin)->where('status','RFS')->get('tbl_grnreport')->row();
			
		  // Rule1: Check valid Device Id 1
		  if(empty($grnResult)){
		       $json['status']='0';
			   $json['msg']="Enter valid Inward Device Id.";
			   echo json_encode($json);
		       die;
		  }
		  
		  // Rule 2: Check associated salesorder.	
          $st_details = $this->stocktransfer_model->getStocktransferDetails($stocktransfer_id);

          if(empty($st_details)){
			   $json['status']='0';
			   $json['msg']="Stotransfer Note Not found #".$stocktransfer_id;
			   echo json_encode($json);
		       die;
		  } 	

          // Rule 3: Check SKU First, then STOCK TYPE and finally Grade
		  $stock_type = '';
		  $sale_price = 0;
		  foreach($st_details as $item){
		       if(trim($item['sku'])==trim($grnResult->SKU)){
				  if(trim($item['stock_type'])==trim($grnResult->stock_type)){
					 if(trim($item['grade'])==trim($grnResult->certification_grade)){
					    $stock_type=trim($grnResult->stock_type);
                        $fnsku = $item['fnsku'];
						break;
				     }  
				  }
			   }
		  } 	  
		
          // Rule 4: SKU MISMATCH		
          if(empty($stock_type)){
			  $json['status']='0';
			  $json['msg']="SKU/CATEGORY/GRADE MISMATCH.";
			  echo json_encode($json);
		      die;
		  }		
	      
		  $tax=0;
      
		
            $deviceNhmod=$grnResult->nhmod;
			$typeId=0;
			$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','nhmod',$deviceNhmod);
			$taxRatio=$this->Common_model->getFieldValue('tax_ratio','tbl_device_type','type_id',$typeId);

            $this->db->select('wfrom.state_gst_code as source_gst, wto.state_gst_code as target_gst');
            $this->db->from('tbl_stocktransfer');
            $this->db->join('tbl_wh_loc as wfrom', 'wfrom.short_code = tbl_stocktransfer.from_loc');
            $this->db->join('tbl_wh_loc as wto', 'wto.short_code = tbl_stocktransfer.to_loc');
            $this->db->where('tbl_stocktransfer.stocktransfer_id', $stocktransfer_id);
            $gst_ids = $this->db->get()->row();

            $taxable_cat = TAXABLE_CATEGORY;
            if(in_array($grnResult->stock_type, $taxable_cat)){
                $item_value = $grnResult->unit_price;
                $sale_price = bcmul( $item_value, 1.10, 2 );
            }else{
                $item_value = $grnResult->unit_price + $grnResult->unit_price_tax;
                $sale_price = bcmul( $item_value, 1.10, 2 );
            }

            $roundup_amount = ceil($sale_price/50)*50;
            $diff = $roundup_amount - $sale_price;
            if($diff > 25){
                $sale_price = floor($sale_price/50)*50;
            }else{
                $sale_price = $roundup_amount;
            }

            if($gst_ids->source_gst == $gst_ids->target_gst){
                $tax_type = 'NO TAX';
                $tax_amount = 0;
            }else{
                $tax_type = 'IGST18';

                if(in_array($grnResult->stock_type, $taxable_cat)){
                    $tax_amount = $sale_price*18/100;
                }else{
                    $tax_amount = ($sale_price - $item_value)*18/100;
                }
            }

			$json['status']='1';			      
			$json['tax_ratio'] = (int) $taxRatio;
			$json['product_name'] = $grnResult->device_name;
			$json['imei'] = $grnResult->imei1_no;	
			$json['tax_type'] = $tax_type;
			$json['tax_amount'] = $tax_amount;
			$json['grnreport_id'] = $grnResult->grnreport_id;
			$json['grade'] = $grnResult->certification_grade;
			$json['category'] = $grnResult->stock_type;
			$json['sale_price'] = $sale_price;
			$json['fnsku'] = $fnsku;
			$json['unit_price'] = $grnResult->unit_price;
			$json['unit_price_tax'] = $grnResult->unit_price_tax;
			$json['sku'] = $grnResult->SKU;		
	  
			echo json_encode($json);
		    die;
    }

    public function getNewRow(){
        $sno=$this->input->post('sno');
        $trId = "trId".$sno;
        
		$html='<tr id="trId'.$sno.'" class="product_rows">';
				
		$html.= '<td><input class="form-control nhdin_cls" required onchange="getDeviceInfoBynhdin('.$sno.')" placeholder="INWARDID" id="nhdin'.$sno.'" name="nhdin[]"  value="" type="text"></td>
				<td><input class="form-control" placeholder="LPN NUMBER" id="lpn_number'.$sno.'"  name="lpn_number[]" value="" type="text"></td>
				<td><input class="form-control" required placeholder="PRODUCT NAME" id="product_name'.$sno.'"  name="product_name[]" value="" type="text" readonly></td>
				<td><input class="form-control" required placeholder="IMEI" id="imei'.$sno.'" name="imei[]"  value="" type="text" readonly></td>				
				<td><input class="form-control" required placeholder="SKU" id="sku'.$sno.'" name="sku[]"  value="" type="text" readonly></td>				
				<td><input class="form-control" required placeholder="CATEGORY" id="category'.$sno.'" name="category[]"  value="" type="text" readonly></td>			
				<td><input class="form-control" required placeholder="FNSKU" id="fnsku'.$sno.'" name="fnsku[]"  value="" type="text" readonly></td>';
		$html.=	'<td><input class="form-control input_price" required onkeypress="return isNumberKey(event)" placeholder="PRICE" id="price'.$sno.'" name="price[]" value="" type="text" readonly></td>
				<td><input class="form-control input_tax" readonly required onkeypress="return isNumberKey(event)" id="tax_amount'.$sno.'" placeholder="TAX" name="tax_amount[]" value="" type="text" readonly></td>
		
                 <td><input readonly class="form-control" required name="grade[]" id="grade'.$sno.'" placeholder="SELECT GRADE" readonly></td>
                 <td><input selected disabled="false" class="form-control" required name="tax_type[]" id="tax_type'.$sno.'"></td>
                 ';

		$html.= '<td><a onclick="deleteRow(\''.$trId.'\')" class="btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
		        <input class="form-control input_grnreport_id" name="grnreport_id[]" id="grnreport_id'.$sno.'" value=""00 type="hidden">
		        <input class="form-control" name="unit_price[]" id="unit_price'.$sno.'" type="hidden">
		        <input class="form-control" name="unit_price_tax[]" id="unit_price_tax'.$sno.'" type="hidden">
		        </tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
    }

    function getIndianCurrency(float $number){
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
        $digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
        while( $i < $digits_length ) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ?'Rupees '.$Rupees: '') . $paise.'Only';
    }

    public function uploadFiles($stocktransfer_id){

        if( (int) $stocktransfer_id <= 0){
            $json['status'] = 0;
                $json['error'] = "No Stock Transfer Selected";
                echo json_encode($json);
                die;
        }

        if (!is_dir('upload_st/'.$stocktransfer_id)) {
            mkdir('./upload_st/' . $stocktransfer_id, 0777, TRUE);
        
        }
        
        $config['upload_path'] = './upload_st/'.$stocktransfer_id.'/';
        $config['allowed_types'] = 'pdf';

        $this->load->library('upload', $config);

        if ( ! $this->upload->do_upload('file'))
        {
                $error = $this->upload->display_errors();

                $json['status'] = 0;
                $json['error'] = $error;
                echo json_encode($json);
                die;
        }
                
        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function getSOFileslist(){

        $stocktransfer_id = $this->input->get('stocktransfer_id');

        if(empty($stocktransfer_id)){
            
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $files = scandir( "./upload_st/".$stocktransfer_id."/" );
        $file_names = array();
         
        foreach( $files as $file ){

            if($file != '.' && $file != '..'){

                $file_names[] = array(

                    "file_name" => $file
                );
            }
            
        }

        $json['status'] = 1;
        $json["directory"] = "upload_st/".$stocktransfer_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
    }
}