<?php
class Stocktransfer_inward extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('auditlog_model');
        $this->load->model('stocktransfer_model');
    }

    public function manage_stocktransfer_inward($active = 0)
    {

        $data['title'] = "STOCK TRANSFER INWARD";
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data["active"] = 1;
        }

        $data['subview'] = $this->load->view('admin/stocktransfer_inward/manage_stocktransfer_inward', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getStocktransferHeader($stocktransfer_id = 0)
    {

        if ($stocktransfer_id > 0) {

            $this->db->where('stocktransfer_id', $stocktransfer_id);
            $result = $this->db->get('STOCKTRANSFER_NOTE_LIST_VIEW')->row_array();
        } else {

            $json['data'] = array();
            echo json_encode($json);
            die;
        }

        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $stocktransfer_date = date("d-m-Y", strtotime($result["stocktransfer_date"]));
        if ($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001') {
            $stocktransfer_date = '';
        }

        $rows[] = array(
            "stocktransfer_id" => $result["stocktransfer_id"],
            "stocktransfer_no" => $result["stocktransfer_no"],
            "website" => $result["website"],
            "stocktransfer_type" => $result["st_type"],
            "from_loc" => $result["from_loc"],
            "to_loc" => $result["to_loc"],
            "status" => $result["status"],
            "tracking_id" => $result["tracking_id"],
            "removable_id" => $result["removable_id"],
            "total_amount" => $result["total_amount"],
            "total_quantity" => $result["total_quantity"],
            "stocktransfer_date" => $stocktransfer_date,
            "received_date" => $result['received_date'],
            "CREATED_BY" => $result["CREATED_BY"],
            "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
            "CREATION_DATE" => date("d-m-Y", strtotime($result["CREATION_DATE"])),
            "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($result["LAST_UPDATE_DATE"])),
        );

        $json["data"] = $rows;
        echo json_encode($json);
        die;
    }

    public function getStocktransferDetails()
    {

        $stocktransfer_id = $this->input->get('stocktransfer_id');
        if ($stocktransfer_id > 0) {

            $this->db->where('tbl_stocktransfer_item.stocktransfer_id', $stocktransfer_id);
            $result = $this->db->get('tbl_stocktransfer_item')->result_array();

            if (!empty($result)) {

                foreach ($result as $rowValue) {

                    $rows[] = array(
                        "stocktransfer_item_id" => $rowValue["stocktransfer_item_id"],
                        "sku" => $rowValue["sku"],
                        "grade" => $rowValue["grade"],
                        "device_name" => $rowValue["device_name"],
                        "stock_type" => $rowValue["stock_type"],
                        "fnsku" => $rowValue["fnsku"],
                        "tracking_id" => $rowValue["tracking_id"],
                        "quantity" => $rowValue["quantity"],
                    );
                }
            }
        }
        $json['status'] = 1;
        $json['result'] = $rows;
        echo json_encode($json);
        exit;
    }

    public function getStocktransferDeviceDetails()
    {

        $stocktransfer_id = $this->input->get('stocktransfer_id');
        if ($stocktransfer_id > 0) {

            $this->db->where('stocktransfer_id', $stocktransfer_id);
            $result = $this->db->get('STOCKTRANSFER_INVOICE_ITEM_VIEW')->result_array();
            if (!empty($result)) {

                foreach ($result as $rowValue) {

                    $rows[] = array(
                        "stocktransfer_item_id" => $rowValue["stocktransfer_item_id"],
                        "sku" => $rowValue["SKU"],
                        "grade" => $rowValue["certification_grade"],
                        "device_name" => $rowValue["device_name"],
                        "device_id" => $rowValue["nhdin"],
                        "category" => $rowValue["stock_type"],
                        "fnsku" => $rowValue["fnsku"],
                        "quantity" => 1,
                        "lpn_number" => $rowValue["lpn_number"],
                        "tracking_id" => $rowValue["tracking_id"],
                        "imei" => $rowValue["imei1_no"],
                        "exempt_amount" => $rowValue['exempt_amount'],
                        "taxable_amount" => $rowValue['taxable_amount'],
                        "tax_amount" => $rowValue['tax_amount'],
                        "tax_type" => $rowValue['tax_type'],
                        "price" => $rowValue['price'],
                        "unit_price" => $rowValue['unit_price'],
                        "unit_price_tax" => $rowValue['unit_price_tax'],
                        "remarks" => $rowValue['remarks'],
                    );
                }
            }
        }
        $json['status'] = 1;
        $json['result'] = $rows;
        echo json_encode($json);
        exit;
    }

    public function uploadFiles($stocktransfer_id)
    {

        if ((int) $stocktransfer_id <= 0) {
            $json['status'] = 0;
            $json['error'] = "No Stock Transfer Selected";
            echo json_encode($json);
            die;
        }

        if (!is_dir('upload_st/' . $stocktransfer_id)) {
            mkdir('./upload_st/' . $stocktransfer_id, 0777, TRUE);
        }

        $config['upload_path'] = './upload_st/' . $stocktransfer_id . '/';
        $config['allowed_types'] = 'pdf';

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            $error = $this->upload->display_errors();

            $json['status'] = 0;
            $json['error'] = $error;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function getSOFileslist()
    {

        $stocktransfer_id = $this->input->get('stocktransfer_id');

        if (empty($stocktransfer_id)) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $files = scandir("./upload_st/" . $stocktransfer_id . "/");
        $file_names = array();

        foreach ($files as $file) {

            if ($file != '.' && $file != '..') {

                $file_names[] = array(

                    "file_name" => $file
                );
            }
        }

        $json['status'] = 1;
        $json["directory"] = "upload_st/" . $stocktransfer_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
    }

    public function getStockFnsku()
    {

        $fnsku = $this->input->get('fnsku');
        $warehouse = $this->input->get('warehouse');;
        if (empty($fnsku) || empty($warehouse)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->select('count(tbl_grnreport.nhdin) as total_stock');
        $this->db->where('tbl_grnreport.warehouse LIKE "%-' . $warehouse . '"')->where('fnsku', $fnsku);
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
        $total_stock = $this->db->group_by('fnsku')->get('tbl_stocktransfer_invoice')->row()->total_stock;
        // print $this->db->last_query();exit;
        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];

        $this->db->select('count(tbl_ecom_invoice_item.ecom_invoice_item_id) as sold')->where('fnsku', $fnsku)->where('warehouse', $warehouse)->where_in('status', $where_status);
        $this->db->join('tbl_ecom_invoice', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
        $sold_stock = $this->db->group_by('fnsku')->get('tbl_ecom_invoice_item')->row()->sold;


        $json['status'] = 1;
        $json['stock'] = $total_stock - $sold_stock;
        echo json_encode($json);
        exit;
    }

    public function createInwardStocktransfer()
    {

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        $claim = $data['claim_required'];

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $headerArray = array();
        $rowsArray = array();
        $headerArray = array(
            "website" => $data[0]["saleschannel"],
            "st_type" => $data[0]["stocktransfer_type"],
            "from_loc" => $data[0]["from_loc"],
            "to_loc" => $data[0]["to_loc"],
            //"tracking_id"=> $data[0]["tracking_id"],
            "removable_id" => $data[0]["removable_id"],
            "claim_required" => $claim,
            "status" => "ADMIN_PENDING",
            "received_date" => $data[0]["received_date"],
            "stocktransfer_date" => $data[0]["stocktransfer_date"],
            "CREATED_BY" => $this->session->userdata('user_id'),
            "CREATION_DATE" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->insert('tbl_stocktransfer', $headerArray);

        $stocktransfer_id = $this->db->insert_id();
        $error = $this->db->error();

        if ($error['code'] != 0) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($stocktransfer_id > 0) {

            foreach ($data[0]["rows"] as $rowValue) {

                $rowsArray[] = array(
                    "stocktransfer_id" => $stocktransfer_id,
                    "tracking_id" => $rowValue["tracking_id"],
                    "courier_name" => $rowValue["courier_name"],
                    "fnsku" => $rowValue["fnsku"],
                    "quantity" =>  $rowValue["quantity"],
                );
            }
        }
        if (empty($rowsArray)) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->db->insert_batch('tbl_stocktransfer_item', $rowsArray);
        $error = $this->db->error();

        if ($error['code'] != 0) {

            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->auditlog_model->insert_auditlog($stocktransfer_id, 'stocktransfer', "ADMIN_PENDING", $this->session->userdata('user_id'));

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function getInwardNewRow()
    {
        $sno = $this->input->post('sno');
        $trId = "trId" . $sno;

        $html = '<tr id="trId' . $sno . '" class="update_inward_product_rows">';
        $html .= '<td><a onclick="deleteRow(\'' . $trId . '\')" class="btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
                <input class="form-control input_grnreport_id" id="inward_grnreport_id' . $sno . '" value="" type="hidden">
                
                <td><input class="form-control inward_imei_cls" required onchange="getInwardDeviceInfoByimei(' . $sno . ')" placeholder="IMEI" id="inward_imei' . $sno . '" value="" type="text"></td>
                
                <td><input class="form-control" required placeholder="INWARDID" id="inward_nhdin' . $sno . '" value="" type="text" readonly></td>				
				<td><input class="form-control" required placeholder="LP Number" id="inward_lpn' . $sno . '" value="" type="text"></td>
                <td>
                    <select class="form-control select_box" required placeholder="TRACKING ID" id="inward_tracking_id' . $sno . '" onchange="setCourierName(' . $sno . ')" >
                        <option value ="" >TRACKING ID</option>
                    </select>
                </td>
				<td><input class="form-control" placeholder="COURIER NAME" id="inward_courier_name' . $sno . '" value="" type="text"></td>
                <td><textarea class="form-control" placeholder="REMARKS" id="inward_remarks' . $sno . '"></textarea></td>
                <td><input class="form-control" required placeholder="FNSKU" id="inward_fnsku' . $sno . '" value="" type="text" readonly></td>
				<td><input class="form-control" required placeholder="PRODUCT NAME" id="inward_product_name' . $sno . '" value="" type="text" readonly></td>
				<td><input class="form-control" required placeholder="SKU" id="inward_sku' . $sno . '" value="" type="text" readonly></td>				
                <td><input class="form-control" required placeholder="CATEGORY" id="inward_category' . $sno . '" value="" type="text" readonly></td>
                <td><input class="form-control" placeholder="PRICE" id="inward_price' . $sno . '"  value="" type="text" readonly></td>
                <td><input class="form-control" placeholder="TAX" id="inward_tax' . $sno . '"  value="" type="text" readonly></td>
                <td><input class="form-control" placeholder="TAX TYPE" id="inward_tax_type' . $sno . '"  value="" type="text" readonly></td>
                <td><input readonly class="form-control" id="inward_grade' . $sno . '" placeholder="SELECT GRADE" readonly></td>
                <input class="form-control" required id="inward_unit_price' . $sno . '" type="hidden" readonly>
                <input class="form-control" required id="inward_unit_price_tax' . $sno . '" type="hidden" readonly>
		        </tr>';

        $json['status'] = '1';
        $json['html'] = $html;
        echo json_encode($json);
        die;
    }

    public function updateInwardStocktransferForm($stocktransfer_id)
    {

        $data['active'] = 1;
        $data['title'] = "UPDATE STOCK TRANSFER";
        if ($stocktransfer_id > 0) {
            $result = $this->db->select('status')->where('stocktransfer_id', $stocktransfer_id)->get('tbl_stocktransfer')->row();

            if ($result->status == 'ADMIN_PENDING') {
                $data['active'] = 3;
                $data["inward_stocktransfer_id"] = $stocktransfer_id;
            }
        }

        $data['subview'] = $this->load->view('admin/stocktransfer_inward/manage_stocktransfer_inward', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updateInwardStocktransferForm_WH($stocktransfer_id)
    {

        $data['active'] = 1;
        $data['title'] = "UPDATE STOCK TRANSFER";

        if ($stocktransfer_id > 0) {
            $result = $this->db->select('status')->where('stocktransfer_id', $stocktransfer_id)->get('tbl_stocktransfer')->row();

            if ($result->status == 'WAREHOUSE_PENDING') {
                $data['active'] = 4;
                $data["inward_stocktransfer_wh_id"] = $stocktransfer_id;
            }
        }

        $data['subview'] = $this->load->view('admin/stocktransfer_inward/manage_stocktransfer_inward', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updateInwardStocktransferForm_Finance($stocktransfer_id)
    {

        $data['active'] = 1;
        $data['title'] = "UPDATE STOCK TRANSFER";

        if ($stocktransfer_id > 0) {
            $result = $this->db->select('status')->where('stocktransfer_id', $stocktransfer_id)->get('tbl_stocktransfer')->row();

            if ($result->status == 'FINANCE_PENDING') {
                $data['active'] = 5;
                $data["inward_stocktransfer_finance_id"] = $stocktransfer_id;
            }
        }

        $data['subview'] = $this->load->view('admin/stocktransfer_inward/manage_stocktransfer_inward', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updateInwardStocktransferForm_Inprogress($stocktransfer_id)
    {

        $data['active'] = 1;
        $data['title'] = "UPDATE STOCK TRANSFER";

        if ($stocktransfer_id > 0) {
            $result = $this->db->select('status')->where('stocktransfer_id', $stocktransfer_id)->get('tbl_stocktransfer')->row();

            if ($result->status == 'IN_PROGRESS') {
                $data['active'] = 6;
                $data["inward_stocktransfer_id"] = $stocktransfer_id;
            }
        }

        $data['subview'] = $this->load->view('admin/stocktransfer_inward/manage_stocktransfer_inward', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getInwardDeviceinfoByimei()
    {

        $stocktransfer_id = $this->input->get('inward_stocktransfer_id');
        $imei = $this->input->get('imei');

        if (empty($stocktransfer_id) || $stocktransfer_id <= 0) {
            $json['status'] = '0';
            $json['msg'] = "No Stocktransfer Note present" . $stocktransfer_id;
            echo json_encode($json);
            die;
        }
        $stock_object = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('tbl_stocktransfer')->row();
        $warehouse = $stock_object->website . '-' . $stock_object->from_loc;

        $grnResult = $this->db->where("imei1_no", $imei)->or_where("imei2_no", $imei)->where("warehouse", $warehouse)->get('tbl_grnreport')->row();

        // Rule1: Check valid Device Id 1
        if (empty($grnResult)) {
            $json['status'] = '0';
            $json['msg'] = "Enter valid IMEI No.";
            echo json_encode($json);
            die;
        }

        $fnsku = $this->db->select('fnsku')->where('sku', $grnResult->SKU)->get('tbl_stocktransfer_item')->row()->fnsku;

        $this->db->select('wfrom.state_gst_code as source_gst, wto.state_gst_code as target_gst');
        $this->db->from('tbl_stocktransfer');
        $this->db->join('tbl_wh_loc as wfrom', 'wfrom.short_code = tbl_stocktransfer.from_loc');
        $this->db->join('tbl_wh_loc as wto', 'wto.short_code = tbl_stocktransfer.to_loc');
        $this->db->where('tbl_stocktransfer.stocktransfer_id', $stocktransfer_id);
        $gst_ids = $this->db->get()->row();

        $taxable_cat = TAXABLE_CATEGORY;
        if (in_array($grnResult->stock_type ,$taxable_cat)) {
            $item_value = $grnResult->unit_price;
            $sale_price = bcmul($item_value, 1.10, 2);
        } else {
            $item_value = $grnResult->unit_price + $grnResult->unit_price_tax;
            $sale_price = bcmul($item_value, 1.10, 2);
        }

        $roundup_amount = ceil($sale_price / 50) * 50;
        $diff = $roundup_amount - $sale_price;
        if ($diff > 25) {
            $sale_price = floor($sale_price / 50) * 50;
        } else {
            $sale_price = $roundup_amount;
        }

        if ($gst_ids->source_gst == $gst_ids->target_gst) {
            $tax_type = 'NO TAX';
            $tax_amount = 0;
        } else {
            $tax_type = 'IGST18';

            if (in_array($grnResult->stock_type ,$taxable_cat)) {
                $tax_amount = $sale_price * 18 / 100;
            } else {
                $tax_amount = ($sale_price - $item_value) * 18 / 100;
            }
        }

        $json['status'] = 1;
        $json['product_name'] = $grnResult->device_name;
        $json['nhdin'] = $grnResult->nhdin;
        $json['grnreport_id'] = $grnResult->grnreport_id;
        $json['grade'] = $grnResult->certification_grade;
        $json['category'] = $grnResult->stock_type;
        $json['fnsku'] = $fnsku;
        $json['tax_type'] = $tax_type;
        $json['tax_amount'] = $tax_amount;
        $json['sale_price'] = $sale_price;
        $json['unit_price'] = $grnResult->unit_price;
        $json['unit_price_tax'] = $grnResult->unit_price_tax;
        $json['sku'] = $grnResult->SKU;

        echo json_encode($json);
        die;
    }

    public function updateInwardST()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $st_data = $this->db->from('tbl_stocktransfer')->where('stocktransfer_id', $data['inward_stocktransfer_id'])->get()->row();
        $st_items_data = $this->db->from('tbl_stocktransfer_item')->where('stocktransfer_id', $data['inward_stocktransfer_id'])->get()->result_array();

        if (empty($st_data) || empty($st_items_data)) {
            $msg = 'Invalid ST Inward';
            GOTO ERROR;
        }
        if ($st_data->status != 'ADMIN_PENDING') {
            $msg = 'ST Inward is in ' . $st_data->status . ' stage';
            GOTO ERROR;
        }

        $fnsku_arr = [];
        foreach($st_items_data as $row) {
            $fnsku_arr[$row['fnsku']] = $row['quantity'];
        }
        $ctr_fnsku_arr = $fnsku_arr;

        //var_dump($data[]);exit;
        $this->db->select('wfrom.state_gst_code as source_gst, wto.state_gst_code as target_gst');
        $this->db->from('tbl_stocktransfer');
        $this->db->join('tbl_wh_loc as wfrom', 'wfrom.short_code = tbl_stocktransfer.from_loc');
        $this->db->join('tbl_wh_loc as wto', 'wto.short_code = tbl_stocktransfer.to_loc');
        $this->db->where('tbl_stocktransfer.stocktransfer_id', $data['inward_stocktransfer_id']);
        $gst_ids = $this->db->get()->row();

        if ($gst_ids->source_gst == $gst_ids->target_gst) {
            $this->db->select('max(CAST(SUBSTRING_INDEX(stocktransfer_no,"-",-1) as UNSIGNED)) as max');
            $series = $this->db->where("stocktransfer_no LIKE 'DC-IN-HYD-%'")->get('tbl_stocktransfer')->row()->max;
            $next_numner = $series + 1;
            $stocktransfer_no = "DC-IN-HYD-" . $next_numner;
        } else {
            $this->db->select('max(CAST(SUBSTRING_INDEX(stocktransfer_no,"-",-1) as UNSIGNED)) as max');
            $series = $this->db->where("stocktransfer_no LIKE 'STN-IN-HYD-%'")->get('tbl_stocktransfer')->row()->max;
            $next_numner = $series + 1;
            $stocktransfer_no = "STN-IN-HYD-" . $next_numner;
        }

        $stocktransfer = array(
            'from_loc' => $data["from_loc"],
            'claim_required' => $data['claim_required'],
            'received_date' => $data['received_date'],
            'status' => "WAREHOUSE_PENDING",
            "stocktransfer_no" => $stocktransfer_no,
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),
        );

        $taxable_cat = TAXABLE_CATEGORY;
        foreach ($data['rows'] as $rowValue) {

            if ($rowValue['tax_type'] == 'NO TAX') {

                $tax_amount = 0;
                $taxable_amount = 0;
                $exempt_amount = 0;
            } else {
                if (in_array($rowValue['category'],$taxable_cat)) {
                    $taxable_amount = $rowValue['price'];
                    $exempt_amount = 0;
                    $tax_amount = $rowValue['price'] * 18 / 100;
                } else {
                    $taxable_amount = $rowValue['price'] - ($rowValue['unit_price'] + $rowValue['unit_price_tax']);
                    $exempt_amount = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                    $tax_amount = $taxable_amount * 18 / 100;
                }
            }

            if (!isset($fnsku_arr[$rowValue['fnsku']])) {
                $msg = 'FNSKU related to IMEI '. $rowValue['imei'] . ' is not related to this ST INWARD';
                GOTO ERROR;
            }
            if ($ctr_fnsku_arr[$rowValue['fnsku']] < 1) {
                $msg = 'FNSKU "'. $rowValue['fnsku'] . '" devices count should be equal to '. $fnsku_arr[$rowValue['fnsku']];
                GOTO ERROR;
            }
            $ctr_fnsku_arr[$rowValue['fnsku']]--;

            $rows[] = array(
                "stocktransfer_id" => $data['inward_stocktransfer_id'],
                "device_id" => $rowValue['device_id'],
                "fnsku" => $rowValue['fnsku'],
                "tracking_id" => $rowValue['tracking_id'],
                "courier_name" => $rowValue['courier_name'],
                "lpn_number" => $rowValue['lpn_number'],
                "remarks" => $rowValue['remarks'],
                "price" => $rowValue['price'],
                "taxable_amount" => $taxable_amount,
                "exempt_amount" => $exempt_amount,
                "tax_amount" => $tax_amount,
                "tax_type" => $rowValue['tax_type'],
                "CREATED_BY" => $this->session->userdata('user_id'),
            );

            $grnRows[] = array(
                "grnreport_id" => $rowValue['device_id'],
                "saletype" => "OFFLINE",
                "warehouse" => "HYDERABAD",
                "remark" => 'FBA RETURN',
                "status" => "RETURN"
            );
        }

        foreach($ctr_fnsku_arr as $fnsku => $cnt) {
            if ($cnt != 0) {
                $msg = 'FNSKU "'. $fnsku . '" devices count should be equal to '. $fnsku_arr[$fnsku];
                GOTO ERROR;
            }
        }

        $this->db->trans_start();

        $this->db->insert_batch('tbl_stocktransfer_invoice', $rows);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id', $data['inward_stocktransfer_id']);
        $this->db->update('tbl_stocktransfer');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->db->update_batch('tbl_grnreport', $grnRows, 'grnreport_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($error['code'] == 0) {
            if (!empty($data[0]['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['inward_stocktransfer_id'],
                    'reference_type' => 'stocktransfer',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data[0]['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->load->model('auditlog_model');

        $this->auditlog_model->insert_auditlog($data['stocktransfer_id'], 'stocktransfer', "INVOICED", $this->session->userdata('user_id'));

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        $json['message'] = 'Status updated';
        echo json_encode($json);
        die;

        ERROR:
        $json['status'] = 0;
        $json['message'] = isset($msg)? $msg : 'Something wrong';
        echo json_encode($json);
        die;
    }

    public function updateStocktransfer_wh()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $stocktransfer = array(
            'status' => "FINANCE_PENDING",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),
        );

        $this->db->trans_start();


        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id', $data['stocktransfer_id']);
        $this->db->update('tbl_stocktransfer');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($error['code'] == 0) {
            if (!empty($data[0]['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['inward_stocktransfer_id'],
                    'reference_type' => 'stocktransfer',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data[0]['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->load->model('auditlog_model');

        $this->auditlog_model->insert_auditlog($data['stocktransfer_id'], 'stocktransfer', "INVOICED", $this->session->userdata('user_id'));

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function updateStocktransfer_Finance()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $item_count = $this->db->select('sum(quantity) as count')->where('stocktransfer_id', $data['stocktransfer_id'])->get('tbl_stocktransfer_item')->row()->count;
        $invoice_count = $this->db->select('count(stocktransfer_invoice_id) as count')->where('stocktransfer_id', $data['stocktransfer_id'])->get('tbl_stocktransfer_invoice')->row()->count;

        if ($item_count == $invoice_count) {
            $status = 'COMPLETED';
        } else {
            $status = 'IN_PROGRESS';
        }
        $stocktransfer = array(
            'status' => $status,
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),
        );

        $st_inv = $this->db->select('device_id')->where('stocktransfer_id', $data['stocktransfer_id'])->get('tbl_stocktransfer_invoice')->result_array();

        foreach($st_inv as $stnrow){
            $grnResult = $this->db->select('grnreport_id, status')->where('grnreport_id', $stnrow['device_id'])->get('tbl_grnreport')->row(); 

            if($grnResult->status == 'RETURN'){
                $grn_update[] = array(
                    "grnreport_id" => $grnResult->grnreport_id,
                    "status" => "IN_STOCK",
                    "user_id" => $this->session->userdata('user_id')
                );
            }
        }

        $this->db->trans_start();

        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id', $data['stocktransfer_id']);
        $this->db->update('tbl_stocktransfer');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if(!empty($grn_update)){
            $this->db->update_batch('tbl_grnreport', $grn_update, 'grnreport_id');
            $error = $this->db->error();
        }

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($error['code'] == 0) {
            if (!empty($data[0]['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['inward_stocktransfer_id'],
                    'reference_type' => 'stocktransfer',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data[0]['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->load->model('auditlog_model');

        $this->auditlog_model->insert_auditlog($data['stocktransfer_id'], 'stocktransfer', "INVOICED", $this->session->userdata('user_id'));

        $this->db->trans_complete(); // Complete Mysql Transaction

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function getInwardStocktransferList()
    {

        $status =  $this->input->get('status');
        if ($status == '') {
            $status = 'ADMIN_PENDING';
        }

        $result = array();
        $this->db->where('status', $status);
        $result = $this->db->where('st_type', 'INWARD')->get('STOCKTRANSFER_NOTE_LIST_VIEW')->result_array();

        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            die;
        }

        foreach ($result as $rowValue) {
            $stocktransfer_date = date("d-m-Y", strtotime($rowValue['stocktransfer_date']));
            if ($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001') {
                $stocktransfer_date = '';
            }
            $rows[] = array(
                "stocktransfer_id" => $rowValue["stocktransfer_id"],
                "website" => $rowValue["website"],
                "stocktransfer_type" => $rowValue["st_type"],
                "from_loc" => $rowValue["from_loc"],
                "to_loc" => $rowValue["to_loc"],
                "tracking_id" => $rowValue["tracking_id"],
                "removable_id" => $rowValue["removable_id"],
                "claim_required" => $rowValue["claim_required"],
                "total_quantity" => $rowValue["total_quantity"],
                "total_amount" => $rowValue["total_amount"],
                "status" => $rowValue["status"],
                "received_date" => $rowValue["received_date"],
                "stocktransfer_date" => $stocktransfer_date,
                "CREATED_BY" => $rowValue["CREATED_BY"],
                "LAST_UPDATED_BY" => $rowValue["LAST_UPDATED_BY"],
                "CREATION_DATE" => date("d-m-Y", strtotime($rowValue["CREATION_DATE"])),
                "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($rowValue["LAST_UPDATE_DATE"])),
            );
        }

        $json["data"] = $rows;
        echo json_encode($json);
        die;
    }

    public function invoicePdf()
    {

        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $type = $this->input->get('type');

        if ((int) $stocktransfer_id <= 0) {
            return false;
        }

        $download = $this->input->get('download');

        $result = $this->stocktransfer_model->getStocktransferInvoiceDetails($stocktransfer_id);
        //var_dump($result);exit;
        if (!empty($result)) {

            $total_tax = 0;

            foreach ($result as $value) {
                $invoice_rows[] = array(

                    'product_name' => $value["device_name"],
                    'deviceid' => $value["nhdin"],
                    'imei' => $value["imei1_no"],
                    'category' => $value["stock_type"],
                    'fnsku' => $value["fnsku"],
                    'price' => $value["price"],
                    'taxable_amount' => $value["taxable_amount"],
                    'exempt_amount' => $value["exempt_amount"],
                    'tax_amount' => $value["tax_amount"],
                    'tax_type' => $value["tax_type"],
                );
            }
            $data['rows'] = $invoice_rows;
        }
        $header = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('STOCKTRANSFER_INVOICE_VIEW')->row();
        if (!empty($header)) {
            $total_amount = $header->total_amount + $header->total_tax;
            $amount_words = $this->getIndianCurrency($total_amount);

            $from_wh = $this->db->where('short_code', $header->from_loc)->get('tbl_wh_loc')->row();
            $to_wh = $this->db->where('short_code', $header->to_loc)->get('tbl_wh_loc')->row();

            if (!empty($result["header"][0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($result["header"][0]["gst_no"], 0, 2))->get('tbl_states')->row();

            if ($from_wh->state_gst_code == $to_wh->state_gst_code) {
                $title = "Delivery Challan";
                $from = 'Consigner';
                $to = 'Consignee';
                $invoice_type = 'Challan Number';

                if (strtolower($type) == 'original') {
                    $type_str = 'ORIGINAL FOR CONSIGNEE';
                }
                if (strtolower($type) == 'duplicate') {
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if (strtolower($type) == 'triplicate') {
                    $type_str = 'TRIPLICATE FOR CONSIGNER';
                }

                $data['from'] = $from;
                $data["from_wh"]["gst_number"] = $from_wh->gst_number;
                $data["from_wh"]["warehouse"] = $from_wh->warehouse;
                $data["from_wh"]["business_type"] = $from_wh->business_type;
                $data["from_wh"]["state"] = $from_wh->state;
                $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
                $data["from_wh"]["city"] = $from_wh->city;
                $data["from_wh"]["short_code"] = $from_wh->short_code;
                $data["from_wh"]["address"] = $from_wh->address;
            } else {
                $title = 'Tax Invoice';
                $from = 'Bill To';
                $to = 'Ship To';
                $invoice_type = 'Invoice Number';
                if (strtolower($type) == 'original') {
                    $type_str = 'ORIGINAL FOR RECIPIENT';
                }
                if (strtolower($type) == 'duplicate') {
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if (strtolower($type) == 'triplicate') {
                    $type_str = 'TRIPLICATE FOR SUPPLIER';
                }

                $data['from'] = $from;
                $data["from_wh"]["gst_number"] = $from_wh->gst_number;
                $data["from_wh"]["warehouse"] = $from_wh->warehouse;
                $data["from_wh"]["business_type"] = $from_wh->business_type;
                $data["from_wh"]["state"] = "Karnataka";
                $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
                $data["from_wh"]["city"] = "Bangalore";
                $data["from_wh"]["short_code"] = $from_wh->short_code;
                $data["from_wh"]["address"] = '3rd Floor, 7A, 5th Cross Road, St. Thomas Main Road, Kammanahalli, Bengaluru (Bangalore) Urban, Karnataka-560084';
            }

            //From Warehouse
            /* $data['from'] = $from;
            $data["from_wh"]["gst_number"] = $from_wh->gst_number;
            $data["from_wh"]["warehouse"] = $from_wh->warehouse;
            $data["from_wh"]["business_type"] = $from_wh->business_type;
            $data["from_wh"]["state"] = $from_wh->state;
            $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
            $data["from_wh"]["city"] = $from_wh->city;
            $data["from_wh"]["short_code"] = $from_wh->short_code;
            $data["from_wh"]["address"] = $from_wh->address; */

            //To Warehouse
            $data['to'] = $to;
            $data["to_wh"]["gst_number"] = $to_wh->gst_number;
            $data["to_wh"]["warehouse"] = $to_wh->warehouse;
            $data["to_wh"]["business_type"] = $to_wh->business_type;
            $data["to_wh"]["state"] = $to_wh->state;
            $data["to_wh"]["state_id"] = $to_wh->state_gst_code;
            $data["to_wh"]["city"] = $to_wh->city;
            $data["to_wh"]["short_code"] = $to_wh->short_code;
            $data["to_wh"]["address"] = $to_wh->address;

            $data['title'] = $title;
            $data['type'] = $type_str;
            $data['invoice_type'] = $invoice_type;
            $data["st_invoice_no"] = $header->stocktransfer_no;
            $data["date"] = date("d-m-Y", strtotime($header->CREATION_DATE));
            $data["total_amount"] = $total_amount;
            $data["total_tax"] = $header->total_tax;
            $data["total_taxable"] = $header->total_taxable;
            $data["total_exempt"] = $header->total_exempt;
            $data["total_price"] = $header->total_price;
            $data["sales_channel"] = $header->website;
            $data["tracking_id"] = $header->tracking_id;
            $data["tracking_name"] = $header->tracking_name;
            $data['amount_words'] = $amount_words;
        }

        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/stocktransfer_inward/pdf_invoice', $data, TRUE);
        $header = $data["invoice_code"] . ' | ' . $data['date'];
        pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
    }

    public function getTrackingIds()
    {
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        if ((int) $stocktransfer_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $tracking_ids = $this->db->select('tracking_id, courier_name')->where('stocktransfer_id', $stocktransfer_id)->group_by('tracking_id')->get('tbl_stocktransfer_item')->result_array();
        $received_tracking_ids = $this->db->select('tracking_id')->where('stocktransfer_id', $stocktransfer_id)->group_by('tracking_id')->get('tbl_stocktransfer_invoice')->result_array();

        $received_ti = array();
        $active_ti = array();

        foreach ($received_tracking_ids as $rowValue) {
            $received_ti[] = $rowValue['tracking_id'];
        }

        foreach ($tracking_ids as $rowValue) {
            if (!in_array($rowValue['tracking_id'], $received_ti)) {
                $active_ti[] = array(
                    "tracking_id" => $rowValue['tracking_id'],
                    "courier_name" => $rowValue['courier_name']
                );
            }
        }

        $json['status'] = 1;
        $json['result'] = $active_ti;
        echo json_encode($json);
        exit;
    }

    function getIndianCurrency(float $number)
    {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(
            0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
        );
        $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str[] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ? 'Rupees ' . $Rupees : '') . $paise . 'Only';
    }

    public function cancelStocktransfer($stocktransfer_id)
    {

        if ((int) $stocktransfer_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->Common_model->getRowResult('status', 'tbl_stocktransfer', array("stocktransfer_id" => $stocktransfer_id));

        //Check Status of the Stocktransfer Order
        if ($status['status'] != 'ADMIN_PENDING') {

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $stocktransfer = array(
            'status' => "CANCELED",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),
        );

        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id', $stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error = $this->db->error();

        if ($error['code'] != 0) {

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }
}
