<?php
class Stocktransfer extends Admin_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->model('stocktransfer_model');
        $this->load->library('cliq_api');
    }

    public function manage_stocktransfer($active=0){
		
        $data['title'] = "STOCK TRANSFER";
        if($active>0){
            $data['active'] = $active;
        }else{
            $data["active"] = 1;
        }
        
        $data['subview'] = $this->load->view('admin/stocktransfer/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getStocktransferList(){

        $status =  $this->input->get('status');
        if($status == ''){
            $status = 'NEW';
        }

        $result = array();
        $this->db->where('st_type', 'OUTWARD');
        $result = $this->stocktransfer_model->getStocktransferList($status);
        
        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
        foreach($result as $rowValue){
             $stocktransfer_date = date("d-m-Y", strtotime($rowValue['stocktransfer_date']));
                if($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001'){
                    $stocktransfer_date = '';
                }
            $rows[] = array(
                        "stocktransfer_id" => $rowValue["stocktransfer_id"],
                        "website" => $rowValue["website"],
                        "stocktransfer_type" => $rowValue["st_type"],
                        "from_loc" => $rowValue["from_loc"],
                        "to_loc" => $rowValue["to_loc"],
                        "tracking_id" => $rowValue["tracking_id"],
                        "tracking_name" => $rowValue["tracking_name"],
                        "total_quantity" => $rowValue["total_quantity"],
                        "total_amount" => $rowValue["total_amount"],
                        "status" => $rowValue["status"],
                        "stocktransfer_date" =>$stocktransfer_date,    
                        "CREATED_BY" => $rowValue["CREATED_BY"],
                        "LAST_UPDATED_BY" => $rowValue["LAST_UPDATED_BY"],
                        "CREATION_DATE" => date("d-m-Y",strtotime($rowValue["CREATION_DATE"])),
                        "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($rowValue["LAST_UPDATE_DATE"])),
                    );
        }

        $json["data"] = $rows;
        echo json_encode($json);
        die;
        
    }

    public function getStocktransferInvoiceList(){
        $status =  $this->input->get('status');
        if($status == ''){
            $status = 'INVOICED';
        }

        $result = array();
        $result = $this->stocktransfer_model->getStocktransferInvoiceList($status);
        
        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
        foreach($result as $rowValue){
            
            $rows[] = array(
                        "website" => $rowValue["website"],
                        "stocktransfer_id" => $rowValue["stocktransfer_id"],
                        "invoice_no" => $rowValue["stocktransfer_no"],
                        "stocktransfer_series_no" => 'STN-'.$rowValue["stocktransfer_id"],
                        "stocktransfer_type" => $rowValue["st_type"],
                        "from_loc" => $rowValue["from_loc"],
                        "to_loc" => $rowValue["to_loc"],
                        "tracking_id" => $rowValue["tracking_id"],
                        "tracking_name" => $rowValue["tracking_name"],
                        "total_quantity" => $rowValue["total_quantity"],
                        "total_amount" => $rowValue["total_amount"],
                        "total_taxable" => $rowValue["total_taxable"],
                        "total_exempt" => $rowValue["total_exempt"],
                        "total_tax" => $rowValue["total_tax"],
                        "status" => $rowValue["status"],
                        "CREATED_BY" => $rowValue["CREATED_BY"],
                        "LAST_UPDATED_BY" => $rowValue["LAST_UPDATED_BY"],
                        "CREATION_DATE" => date("Y-m-d",strtotime($rowValue["CREATION_DATE"])),
                        "LAST_UPDATE_DATE" => date("Y-m-d", strtotime($rowValue["LAST_UPDATE_DATE"])),
                    );
        }

        $json["data"] = $rows;
        echo json_encode($json);
        die;
        
    }

    public function getStocktransferDetails(){

        $stocktransfer_id = $this->input->get('stocktransfer_id');
        if($stocktransfer_id>0){

           $result = $this->stocktransfer_model->getStocktransferDetails($stocktransfer_id);
            if(!empty($result)){

                foreach($result as $rowValue){
                    $rows[] = array(
                                "stocktransfer_item_id" => $rowValue["stocktransfer_item_id"],
                                "sku" => $rowValue["sku"],
                                "grade" => $rowValue["grade"],
                                "device_name" => $rowValue["device_name"],
                                "stock_type" => $rowValue["stock_type"],
                                "fnsku" => $rowValue["fnsku"],
                                "quantity" => $rowValue["quantity"],
                            );
                }
            }
        }

        $json['result'] = $rows;
        echo json_encode($json);
        exit;
    }

    public function createStocktransfer(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $result = $this->stocktransfer_model->createStocktransfer($data);
        
        if($result == true){
            $json['status'] = 1;
            echo json_encode($json);
            die;

        }else{

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
    }

    public function editStocktransfer(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if(empty($data) || empty($data[0]['stocktransfer_id'])){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $result = $this->stocktransfer_model->editStocktransfer($data);
        
        if($result == true){

            $json['status'] = 1;
            echo json_encode($json);
            die;

        }else{

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

    }

    public function updateStocktransferForm($stocktransfer_id){
         
        $data['title'] = "UPDATE STOCK TRANSFER";
        if($stocktransfer_id>0){
            
            $result = $this->db->select('status')->where('stocktransfer_id',$stocktransfer_id)->get('tbl_stocktransfer')->row();
            
            if($result->status == 'NEW'){
                $data['active'] = 3;
                $data["stocktransfer_id"] = $stocktransfer_id;
            }
        }

        if($data['active'] != 3){
            $data['active'] = 1;
        }

        $data['subview'] = $this->load->view('admin/stocktransfer/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function createSTInvoiceForm($stocktransfer_id){
        
        $data['title'] = "CREATE STOCK TRANSFER";
        if($stocktransfer_id>0){
            
            $result = $this->db->select('status')->where('stocktransfer_id',$stocktransfer_id)->get('tbl_stocktransfer')->row();
            
            if($result->status == 'FINANCE_APPROVED'){
                $data['active'] = 4;
                $data["stocktransfer_id"] = $stocktransfer_id;
            }
        }

        if($data['active'] != 4){
            $data['active'] = 1;
        }

        $data['subview'] = $this->load->view('admin/stocktransfer/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function editStocktransferForm($stocktransfer_id){

        $data['title'] = "EDIT STOCK TRANSFER";
        if($stocktransfer_id>0){
            
            $result = $this->db->select('status')->where('stocktransfer_id',$stocktransfer_id)->get('tbl_stocktransfer')->row();
            
            if($result->status == 'NEW' || $result->status == 'FINANCE_REJECTED'){
                $data['active'] = 6;
                $data["stocktransfer_id"] = $stocktransfer_id;
            }
        }

        if($data['active'] != 6){
            $data['active'] = 1;
        }

        $data['subview'] = $this->load->view('admin/stocktransfer/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function createDispatchForm($stocktransfer_id){
        
        $data['title'] = "DISPATCH STOCK TRANSFER";

        if($stocktransfer_id>0){
            
            $result = $this->db->select('status')->where('stocktransfer_id',$stocktransfer_id)->get('tbl_stocktransfer')->row();
            
            if($result->status == 'INVOICED'){
                $data['active'] = 7;
                $data["stocktransfer_id"] = $stocktransfer_id;
            }
        }

        if($data['active'] != 7){
            $data['active'] = 1;
        }

        $data['subview'] = $this->load->view('admin/stocktransfer/manage_stocktransfer', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function createSTInvoice(){
        
        $request =  file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $stocktransfer_id = $data[0]['stocktransfer_id'];

        if(empty($data) || empty($data[0]['stocktransfer_id'])){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $result = $this->stocktransfer_model->createSTInvoice($data);

        if(empty($result)){
           
            $json['status'] = 0;
            echo json_encode(($json));
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;


    }

    public function updateStocktransfer(){
        $request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		$status=$this->Common_model->getRowResult('status','tbl_stocktransfer',array("stocktransfer_id"=>$data['stocktransfer_id']));
		
		//Check Status of the Stocktransfer Order
		if($status['status'] !='NEW'){
			$json['status']=0;
			echo json_encode($json);
			die;
		}

		$result=$this->stocktransfer_model->updateStocktransfer($data);

		if($result=="approved"){

			$json['status']=1;
			$json['message']='approved';
			echo json_encode($json);
			die;

		}elseif($result=="rejected"){

			$json['status']=1;
			$json['message']='rejected';
			echo json_encode($json);
			die;

		}else{

			$json['status']=0;
			echo json_encode($json);
			die;
		}
    }

    public function cancelStocktransfer($stocktransfer_id){

        if( (int) $stocktransfer_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status=$this->Common_model->getRowResult('status','tbl_stocktransfer',array("stocktransfer_id"=>$stocktransfer_id));
		
		//Check Status of the Stocktransfer Order
		if($status['status'] !='NEW' && $status != 'FINANCE_REJECTED'){
            
            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $stocktransfer=array(
            'status' => "CANCELED",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();

        if($error['code'] != 0){
            
            $json['status']=0;
			echo json_encode($json);
			die;
        }
        $this->cliq_api->postStocktransferImage($stocktransfer_id);
        $json['status'] = 1;
		echo json_encode($json);
		die;

    }

    public function intransitSTN($stocktransfer_id){

        if( (int) $stocktransfer_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status=$this->Common_model->getRowResult('status','tbl_stocktransfer',array("stocktransfer_id"=>$stocktransfer_id));
		
		//Check Status of the Stocktransfer Order
		if($status['status'] !='DISPATCHED'){
            
            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $stocktransfer=array(
            'status' => "IN_TRANSIT",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();

        if($error['code'] != 0){
            
            $json['status']=0;
			echo json_encode($json);
			die;
        }

        $json['status'] = 1;
		echo json_encode($json);
		die;

    }

    public function shipSTN($stocktransfer_id){

        if( (int) $stocktransfer_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status=$this->Common_model->getRowResult('status','tbl_stocktransfer',array("stocktransfer_id"=>$stocktransfer_id));
		
		//Check Status of the Stocktransfer Order
		if($status['status'] !='DISPATCHED' && $status['status'] != 'IN_TRANSIT'){
            
            $json['status'] = 0;
			echo json_encode($json);
			die;
        }
        
        $stocktransfer=array(
            'status' => "SHIPPED",
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date("Y-m-d H:i:s"),			
        );
        
        $this->db->set($stocktransfer);
        $this->db->where('stocktransfer_id',$stocktransfer_id);
        $this->db->update('tbl_stocktransfer');
        $error=$this->db->error();

        if($error['code'] != 0){
            
            $json['status']=0;
			echo json_encode($json);
			die;
        }

        $json['status'] = 1;
		echo json_encode($json);
		die;

    }

    public function createDispatch($stocktransfer_id){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data) || (int) $stocktransfer_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $user_id = $this->session->userdata('user_id');

        foreach($data as $rowValue){

            $packages[] = array(
                "package_no" => $rowValue['package_no'],
                "quantity" => $rowValue['package_qty'],
                "stocktransfer_id" => $stocktransfer_id,
                "CREATED_BY" => $user_id
            );
        }

        if(empty($packages)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->db->insert_batch('tbl_stocktransfer_dispatch', $packages);
        $error = $this->db->error();

        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $status = array("status" => 'DISPATCHED', "LAST_UPDATED_BY" => $user_id);

        $this->db->where('stocktransfer_id', $stocktransfer_id)->update('tbl_stocktransfer', $status);
        
        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $this->cliq_api->postStocktransferImage($stocktransfer_id);
        $json['status'] = 1;
        echo json_encode($json);
        die;
    }
    public function pickListPdf(){
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $grade_required = $this->input->get('grade'); 
		if($stocktransfer_id>0){
		$data=array();
	
        $stocktransfer = $this->db->get_where('tbl_stocktransfer', array("stocktransfer_id"=>$stocktransfer_id))->row()->stocktransfer_no;
                            
        $data["stocktransfer_no"] = $stocktransfer;
        $data["date"] = date("d-m-Y", strtotime($stocktransfer->CREATION_DATE));
        if($grade_required == 'no'){
            $data["grade_required"] = 'no';
        }
        else{
            $data["grade_required"] = 'yes';
        }
			$this->db->select('sku, grade, sum(quantity) as quantity, fnsku')->where('stocktransfer_id', $stocktransfer_id);
			if($grade_required == 'no'){
				$result = $this->db->group_by('sku')->get('tbl_stocktransfer_item')->result_array();
			}else{
				$result = $this->db->group_by('sku,grade')->get('tbl_stocktransfer_item')->result_array();
			}
			if(!empty($result)){
				foreach($result as $value){
					$device_data = $this->db->select('product_brand,device_name,rom,ram,GROUP_CONCAT(distinct(bin_number)) as bin_number')->where('SKU', $value['sku'])->group_by('bin_number')->get('tbl_grnreport')->row();
					$rows[]=array(
						'device_name'=>$device_data->device_name,
						'quantity'=>$value["quantity"],
						'brand'=>$device_data->product_brand,
						'ram'=>$device_data->ram,
						'rom'=>$device_data->rom,
						'bin_number'=>$device_data->bin_number,
                        'sku'=>$value["sku"],
                        'fnsku'=>$value["fnsku"],
						'grade'=>$value['grade'],
					
					);
					$data['category'] = $value['category'];
				}
				$data["rows"] = $rows;
			}
		}
       $this->load->helper('dompdf');
		$viewfile = $this->load->view('admin/stocktransfer/picklist_stocktransfer_pdf', $data, TRUE);
		//var_dump($data);exit;
		pdf_picklist($viewfile, "PickList");

	}
    public function getStocktransferHeader($stocktransfer_id=0){

        if($stocktransfer_id>0){
            
            $result = $this->stocktransfer_model->getStocktransferheader($stocktransfer_id);
        }else{
            
            $json['data'] = array();
            echo json_encode($json);
            die;
        }

        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
            $stocktransfer_date = date("d-m-Y", strtotime($result["stocktransfer_date"]));
            if($stocktransfer_date == '01-01-1970' || $stocktransfer_date == '30-11--0001'){
                $stocktransfer_date = '';
            }
            $rows[] = array(
                        "stocktransfer_id" => $result["stocktransfer_id"],
                        "website" => $result["website"],
                        "stocktransfer_type" => $result["st_type"],
                        "from_loc" => $result["from_loc"],
                        "to_loc" => $result["to_loc"],
                        "status" => $result["status"],
                        "tracking_id" => $result["tracking_id"],
                        "tracking_name" => $result["tracking_name"],
                        "total_amount" => $result["total_amount"],
                        "total_quantity" => $result["total_quantity"],
                        "stocktransfer_date"=> $stocktransfer_date,
                        "CREATED_BY" => $result["CREATED_BY"],
                        "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
                        "CREATION_DATE" => date("d-m-Y",strtotime($result["CREATION_DATE"])),
                        "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($result["LAST_UPDATE_DATE"])),
              );

        $json["data"] = $rows;
        echo json_encode($json);
        die;
    }

    public function getStocktransferInvoiceHeader($stocktransfer_id=0){
        if($stocktransfer_id>0){
            
            $result = $this->stocktransfer_model->getStocktransferInvoiceHeader($stocktransfer_id);
        }else{
            
            $json['data'] = array();
            echo json_encode($json);
            die;
        }

        if(empty($result)){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
            $rows = array(
                        "stocktransfer_id" => $result["stocktransfer_id"],
                        "website" => $result["website"],
                        "stocktransfer_type" => $result["st_type"],
                        "from_loc" => $result["from_loc"],
                        "to_loc" => $result["to_loc"],
                        "tracking_id" => $result["tracking_id"],
                        "tracking_name" => $result["tracking_name"],
                        "total_quantity" => $result["total_quantity"],
                        "total_amount" => $result["total_amount"],
                        "total_taxable" => $result["total_taxable"],
                        "total_exempt" => $result["total_exempt"],
                        "total_tax" => $result["total_tax"],
                        "status" => $result["status"],
                        "CREATED_BY" => $result["CREATED_BY"],
                        "LAST_UPDATED_BY" => $result["LAST_UPDATED_BY"],
                        "CREATION_DATE" => date("Y-m-d",strtotime($result["CREATION_DATE"])),
                        "LAST_UPDATE_DATE" => date("Y-m-d", strtotime($result["LAST_UPDATE_DATE"])),
                    );

        $json["result"] = $rows;
        echo json_encode($json);
        die;
    }

    public function getStocktransferInvoiceDetails(){
        
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        if($stocktransfer_id>0){

            $result = $this->stocktransfer_model->getStocktransferInvoiceDetails($stocktransfer_id);
             if(!empty($result)){
 
                 foreach($result as $rowValue){
                     $rows[] = array(
                                "nhdin" => $rowValue["nhdin"],
                                "imei1_no" => $rowValue["imei1_no"],
                                "imei2_no" => $rowValue["imei2_no"],
                                "sku" => $rowValue["sku"],
                                "grade" => $rowValue["grade"],
                                "device_name" => $rowValue["device_name"],
                                "stock_type" => $rowValue["stock_type"],
                                "fnsku" => $rowValue["fnsku"],
                                "lpn_number" => $rowValue["lpn_number"],
                                "price" => $rowValue["price"],
                                "taxable_amount" => $rowValue["taxable_amount"],
                                "exempt_amount" => $rowValue["exempt_amount"],
                                "tax_amount" => $rowValue["tax_amount"],
                                "tax_type" => $rowValue["tax_type"],
                                "stn_locns" => $rowValue["stn_locns"],
                                "st_from_loc" => $rowValue["st_from_loc"],
                                "st_to_loc" => $rowValue["st_to_loc"],
                             );
                 }
             }
         }
 
         $json['result'] = $rows;
         echo json_encode($json);
         exit;

    }

    public function getDeviceinfoByNhdin(){

        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $nhdin = $this->input->get('nhdin');

        if(empty($stocktransfer_id) || $stocktransfer_id<=0){
            $json['status']='0';
            $json['msg']="No Stocktransfer Note present".$stocktransfer_id;
            echo json_encode($json);
            die;
        }

		  $grnResult=$this->db->where('nhdin',$nhdin)->where('status','RFS')->get('tbl_grnreport')->row();
			
		  // Rule1: Check valid Device Id 1
		  if(empty($grnResult)){
		       $json['status']='0';
			   $json['msg']="Enter valid Inward Device Id.";
			   echo json_encode($json);
		       die;
		  }
		  
		  // Rule 2: Check associated salesorder.	
          $st_details = $this->stocktransfer_model->getStocktransferDetails($stocktransfer_id);

          if(empty($st_details)){
			   $json['status']='0';
			   $json['msg']="Stotransfer Note Not found #".$stocktransfer_id;
			   echo json_encode($json);
		       die;
		  } 	

          // Rule 3: Check SKU First, then STOCK TYPE and finally Grade
		  $stock_type = '';
		  $sale_price = 0;
		  foreach($st_details as $item){
		       if(trim($item['sku'])==trim($grnResult->SKU)){
				  if(trim($item['stock_type'])==trim($grnResult->stock_type)){
					 if(trim($item['grade'])==trim($grnResult->certification_grade)){
					    $stock_type=trim($grnResult->stock_type);
                        $fnsku = $item['fnsku'];
						break;
				     }  
				  }
			   }
		  } 	  
		
          // Rule 4: SKU MISMATCH		
          if(empty($stock_type)){
			  $json['status']='0';
			  $json['msg']="SKU/CATEGORY/GRADE MISMATCH.";
			  echo json_encode($json);
		      die;
		  }		
	      
		  $tax=0;
      
		
            $deviceNhmod=$grnResult->nhmod;
			$typeId=0;
			$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','nhmod',$deviceNhmod);
			$taxRatio=$this->Common_model->getFieldValue('tax_ratio','tbl_device_type','type_id',$typeId);

            $this->db->select('wfrom.state_gst_code as source_gst, wto.state_gst_code as target_gst');
            $this->db->from('tbl_stocktransfer');
            $this->db->join('tbl_wh_loc as wfrom', 'wfrom.short_code = tbl_stocktransfer.from_loc');
            $this->db->join('tbl_wh_loc as wto', 'wto.short_code = tbl_stocktransfer.to_loc');
            $this->db->where('tbl_stocktransfer.stocktransfer_id', $stocktransfer_id);
            $gst_ids = $this->db->get()->row();

            $taxable_cat = TAXABLE_CATEGORY;
            if(in_array($grnResult->stock_type, $taxable_cat)){
                $item_value = $grnResult->unit_price;
                $sale_price = bcmul( $item_value, 1.10, 2 );
            }else{
                $item_value = $grnResult->unit_price + $grnResult->unit_price_tax;
                $sale_price = bcmul( $item_value, 1.10, 2 );
            }

            $roundup_amount = ceil($sale_price/50)*50;
            $diff = $roundup_amount - $sale_price;
            if($diff > 25){
                $sale_price = floor($sale_price/50)*50;
            }else{
                $sale_price = $roundup_amount;
            }

            if($gst_ids->source_gst == $gst_ids->target_gst){
                $tax_type = 'NO TAX';
                $tax_amount = 0;
            }else{
                $tax_type = 'IGST18';

                if(in_array($grnResult->stock_type, $taxable_cat)){
                    $tax_amount = $sale_price*18/100;
                }else{
                    $tax_amount = ($sale_price - $item_value)*18/100;
                }
            }

			$json['status']='1';			      
			$json['tax_ratio'] = (int) $taxRatio;
			$json['product_name'] = $grnResult->device_name;
			$json['imei'] = $grnResult->imei1_no;	
			$json['tax_type'] = $tax_type;
			$json['tax_amount'] = $tax_amount;
			$json['grnreport_id'] = $grnResult->grnreport_id;
			$json['grade'] = $grnResult->certification_grade;
			$json['category'] = $grnResult->stock_type;
			$json['sale_price'] = $sale_price;
			$json['fnsku'] = $fnsku;
			$json['unit_price'] = $grnResult->unit_price;
			$json['unit_price_tax'] = $grnResult->unit_price_tax;
			$json['sku'] = $grnResult->SKU;		
	  
			echo json_encode($json);
		    die;
    }

    public function getNewRow(){
        $sno=$this->input->post('sno');
        $trId = "trId".$sno;
        
		$html='<tr id="trId'.$sno.'" class="product_rows">';
				
		$html.= '<td><input class="form-control nhdin_cls" required onchange="getDeviceInfoBynhdin('.$sno.')" placeholder="INWARDID" id="nhdin'.$sno.'" name="nhdin[]"  value="" type="text"></td>
				<td><input class="form-control" placeholder="LPN NUMBER" id="lpn_number'.$sno.'"  name="lpn_number[]" value="" type="text"></td>
				<td><input class="form-control" required placeholder="PRODUCT NAME" id="product_name'.$sno.'"  name="product_name[]" value="" type="text" readonly></td>
				<td><input class="form-control" required placeholder="IMEI" id="imei'.$sno.'" name="imei[]"  value="" type="text" readonly></td>				
				<td><input class="form-control" required placeholder="SKU" id="sku'.$sno.'" name="sku[]"  value="" type="text" readonly></td>				
				<td><input class="form-control" required placeholder="CATEGORY" id="category'.$sno.'" name="category[]"  value="" type="text" readonly></td>			
				<td><input class="form-control" required placeholder="FNSKU" id="fnsku'.$sno.'" name="fnsku[]"  value="" type="text" readonly></td>';
		$html.=	'<td><input class="form-control input_price" required onkeypress="return isNumberKey(event)" placeholder="PRICE" id="price'.$sno.'" name="price[]" value="" type="text" readonly></td>
				<td><input class="form-control input_tax" readonly required onkeypress="return isNumberKey(event)" id="tax_amount'.$sno.'" placeholder="TAX" name="tax_amount[]" value="" type="text" readonly></td>
		
                 <td><input readonly class="form-control" required name="grade[]" id="grade'.$sno.'" placeholder="SELECT GRADE" readonly></td>
                 <td><input selected disabled="false" class="form-control" required name="tax_type[]" id="tax_type'.$sno.'"></td>
                 ';

		$html.= '<td><a onclick="deleteRow(\''.$trId.'\')" class="btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
		        <input class="form-control input_grnreport_id" name="grnreport_id[]" id="grnreport_id'.$sno.'" value=""00 type="hidden">
		        <input class="form-control" name="unit_price[]" id="unit_price'.$sno.'" type="hidden">
		        <input class="form-control" name="unit_price_tax[]" id="unit_price_tax'.$sno.'" type="hidden">
		        </tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
    }

    public function invoicePdf(){
        
        $stocktransfer_id = $this->input->get('stocktransfer_id');
        $type = $this->input->get('type');
        
        if((int) $stocktransfer_id <=0){
            return false;
        }

        $download=$this->input->get('download');
        
        $result = $this->stocktransfer_model->getStocktransferInvoiceDetails($stocktransfer_id);
        //var_dump($result);exit;
        if(!empty($result)){
        
            $total_tax=0;
         
            foreach($result as $value){
					$invoice_rows[]=array(
                        
                        'product_name' => $value["device_name"],
						'deviceid' => $value["nhdin"],
						'imei' => $value["imei1_no"],
						'category' => $value["stock_type"],
						'fnsku' => $value["fnsku"],
						'price' => $value["price"],
						'taxable_amount'=> $value["taxable_amount"],
						'exempt_amount' => $value["exempt_amount"],
						'tax_amount' => $value["tax_amount"],
                        'tax_type' => $value["tax_type"],                        
					);
			}
				$data['rows']=$invoice_rows;
        }
        $header = $this->db->where('stocktransfer_id', $stocktransfer_id)->get('STOCKTRANSFER_INVOICE_VIEW')->row();
        if(!empty($header)){
            $total_amount = $header->total_amount + $header->total_tax;
            $amount_words = $this->getIndianCurrency($total_amount);

            $from_wh = $this->db->where('short_code', $header->from_loc)->get('tbl_wh_loc')->row();
            $to_wh = $this->db->where('short_code', $header->to_loc)->get('tbl_wh_loc')->row();

            if(!empty($result["header"][0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id',substr($result["header"][0]["gst_no"],0,2))->get('tbl_states')->row();
            
            if($from_wh->state_gst_code == $to_wh->state_gst_code){
                $title = "Delivery Challan";
                $from = 'Consigner';
                $to = 'Consignee';
                $invoice_type = 'Challan Number';
                
                if(strtolower($type) == 'original'){
                    $type_str = 'ORIGINAL FOR CONSIGNEE';
                }
                if(strtolower($type) == 'duplicate'){
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if(strtolower($type) == 'triplicate'){
                    $type_str = 'TRIPLICATE FOR CONSIGNER';
                }

                $data['from'] = $from;
                $data["from_wh"]["gst_number"] = $from_wh->gst_number;
                $data["from_wh"]["warehouse"] = $from_wh->warehouse;
                $data["from_wh"]["business_type"] = $from_wh->business_type;
                $data["from_wh"]["state"] = $from_wh->state;
                $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
                $data["from_wh"]["city"] = $from_wh->city;
                $data["from_wh"]["short_code"] = $from_wh->short_code;
                $data["from_wh"]["address"] = $from_wh->address;

            }else{
                $title = 'Tax Invoice';
                $from = 'Bill To';
                $to = 'Ship To';
                $invoice_type = 'Invoice Number';
                if(strtolower($type) == 'original'){
                    $type_str = 'ORIGINAL FOR RECIPIENT';
                }
                if(strtolower($type) == 'duplicate'){
                    $type_str = 'DUPLICATE FOR TRANSPORTER';
                }
                if(strtolower($type) == 'triplicate'){
                    $type_str = 'TRIPLICATE FOR SUPPLIER';
                }

                $data['from'] = $from;
                $data["from_wh"]["gst_number"] = $from_wh->gst_number;
                $data["from_wh"]["warehouse"] = $from_wh->warehouse;
                $data["from_wh"]["business_type"] = $from_wh->business_type;
                $data["from_wh"]["state"] = "Karnataka";
                $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
                $data["from_wh"]["city"] = "Bangalore";
                $data["from_wh"]["short_code"] = $from_wh->short_code;
                $data["from_wh"]["address"] = '3rd Floor, 7A, 5th Cross Road, St. Thomas Main Road, Kammanahalli, Bengaluru (Bangalore) Urban, Karnataka-560084';

            }
           
             //From Warehouse
            /* $data['from'] = $from;
            $data["from_wh"]["gst_number"] = $from_wh->gst_number;
            $data["from_wh"]["warehouse"] = $from_wh->warehouse;
            $data["from_wh"]["business_type"] = $from_wh->business_type;
            $data["from_wh"]["state"] = $from_wh->state;
            $data["from_wh"]["state_id"] = $from_wh->state_gst_code;
            $data["from_wh"]["city"] = $from_wh->city;
            $data["from_wh"]["short_code"] = $from_wh->short_code;
            $data["from_wh"]["address"] = $from_wh->address; */

            //To Warehouse
            $data['to'] = $to;
            $data["to_wh"]["gst_number"] = $to_wh->gst_number;
            $data["to_wh"]["warehouse"] = $to_wh->warehouse;
            $data["to_wh"]["business_type"] = $to_wh->business_type;
            $data["to_wh"]["state"] = $to_wh->state;
            $data["to_wh"]["state_id"] = $to_wh->state_gst_code;
            $data["to_wh"]["city"] = $to_wh->city;
            $data["to_wh"]["short_code"] = $to_wh->short_code;
            $data["to_wh"]["address"] = $to_wh->address;

            $data['title'] = $title;
            $data['type'] = $type_str;
            $data['invoice_type'] = $invoice_type;
            $data["st_invoice_no"] = $header->stocktransfer_no;
            $data["date"] = date("d-m-Y",strtotime($header->CREATION_DATE));
            $data["total_amount"] = $total_amount;
            $data["total_tax"] = $header->total_tax;
            $data["total_taxable"] = $header->total_taxable;
            $data["total_exempt"] = $header->total_exempt;
            $data["total_price"] = $header->total_price;
            $data["sales_channel"] = $header->website;
            $data["tracking_id"] = $header->tracking_id;
            $data["tracking_name"] = $header->tracking_name;
            $data['amount_words'] = $amount_words;
            
        }
       
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/stocktransfer/pdf_invoice', $data, TRUE);
        $header=$data["invoice_code"].' | '.$data['date'];
        pdf_create($viewfile, $data["invoice_code"],TRUE,'',$download,null,$header);
       
    }

    function getIndianCurrency(float $number){
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
        $digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
        while( $i < $digits_length ) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ?'Rupees '.$Rupees: '') . $paise.'Only';
    }

    public function uploadFiles($stocktransfer_id){

        if( (int) $stocktransfer_id <= 0){
            $json['status'] = 0;
                $json['error'] = "No Stock Transfer Selected";
                echo json_encode($json);
                die;
        }

        if (!is_dir('upload_st/'.$stocktransfer_id)) {
            mkdir('./upload_st/' . $stocktransfer_id, 0777, TRUE);
        
        }
        
        $config['upload_path'] = './upload_st/'.$stocktransfer_id.'/';
        $config['allowed_types'] = 'pdf';

        $this->load->library('upload', $config);

        if ( ! $this->upload->do_upload('file'))
        {
                $error = $this->upload->display_errors();

                $json['status'] = 0;
                $json['error'] = $error;
                echo json_encode($json);
                die;
        }
                
        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function getSOFileslist(){

        $stocktransfer_id = $this->input->get('stocktransfer_id');

        if(empty($stocktransfer_id)){
            
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $files = scandir( "./upload_st/".$stocktransfer_id."/" );
        $file_names = array();
         
        foreach( $files as $file ){

            if($file != '.' && $file != '..'){

                $file_names[] = array(

                    "file_name" => $file
                );
            }
            
        }

        $json['status'] = 1;
        $json["directory"] = "upload_st/".$stocktransfer_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
    }
}