<?php

 
class Spareparts extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		
		$this->load->library('form_validation');
    }

    public function manage_spareparts($id = NULL,$activeId=NULL)
    {   
        $data['title'] = "SPARE PARTS DETAIL"; //Page title 
		
		$pendingPartCond="status='0' or status='6'";
		$data['parts_list']=$this->db->order_by('parts_id','DESC')->where($pendingPartCond)->get('tbl_spareparts_detail')->result_array();
		$data['rejectpart_list']=$this->db->order_by('parts_id','DESC')->get_where('tbl_spareparts_detail',array('status'=>'2'))->result_array();
		$data['assign_partlist']=$this->db->order_by('parts_id','DESC')->get_where('tbl_spareparts_detail',array('status'=>'5'))->result_array();
		
		$warehouseCond="status='1' or status='3' or status='7'";
		$data['warehouse_partlist']=$this->db->order_by('parts_id','DESC')->get_where('tbl_spareparts_detail',$warehouseCond)->result_array();
		
        $data['subview'] = $this->load->view('admin/spare_parts/manage_spareparts', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }	

	public function changeStatus()
	{
		$partsId=$_POST['parts_id'];
		$type=$_POST['type'];
		
		if($partsId!='')
		{
			$json['status']='1';
			if($type=='approve')
			{
				$status='1';
			}
			else
			{
				$status='2';
			}
			
			$curDate=date("Y-m-d H:i:s");
			
			$this->db->query("UPDATE tbl_spareparts_detail SET status='$status',warehouse_action_date='$curDate' where parts_id IN ($partsId)");
			$json['msg']="STATUS CHANGED SUCCESSFULLY";
		}
		else
		{
			$json['status']='0';
			$json['msg']='PLEASE SELECT AT LEAST ONE ITEM';
		}

		echo json_encode($json);
		die;
	}
	
	public function submitPartReject()
	{
		 $this->form_validation->set_rules('reason', 'REASON', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		 $this->form_validation->set_rules('parts_id', 'PARTS ITEM', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		if($this->form_validation->run() == TRUE)
		{	 
			$partId=$this->input->post('parts_id'); 
			
			 $reason=$this->input->post('reason'); 
			 $curDate=date("Y-m-d H:i:s");
			 $this->db->query("UPDATE tbl_spareparts_detail SET status='2',comment='$reason',warehouse_action_date='$curDate' WHERE parts_id IN ($partId)"); 
			 
			 $json['error']='0';
			 $this->session->set_userdata('success','STATUS CHANGED SUCCESSFULLY');
		}
		else
		{
			$json['error']='1';
			$json['msg']=validation_errors();
		}
		
		echo json_encode($json);
		die;
	}
	
	public function manage_purchaseparts($id = NULL,$activeId=NULL)
    {   
        $data['title'] = "PURCHASE PART DETAIL"; //Page title 
		$data['parts_list']=$this->db->order_by('parts_id','DESC')->get_where('tbl_spareparts_detail',array('status'=>'1'))->result_array(); 
        $data['subview'] = $this->load->view('admin/spare_parts/purchase_part/manage_purchasepart', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

	public function approvePurchasePart()
	{
		$this->form_validation->set_rules('parts_id', 'PARTS ITEM', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
		
		if($this->form_validation->run() == TRUE)
		{	 
			$partId=$this->input->post('parts_id');  
			$curDate=date("Y-m-d H:i:s");
			$this->db->query("UPDATE tbl_spareparts_detail SET status='3',purchase_action_date='$curDate',comment='' WHERE parts_id IN ($partId)"); 
			 
			 $json['error']='0';
			 $this->session->set_userdata('success','PART SUCCESSFULLY SENT TO WAREHOUSE');
		}
		else
		{
			$json['error']='1';
			$json['msg']=validation_errors();
		}
		
		echo json_encode($json);
		die;
	}
	
	public function sendToEngineerPart()
	{
		$this->form_validation->set_rules('parts_id', 'PARTS ITEM', 'trim|required',
			array(
				'required'  => '%s can not be empty.',  
			) 
		);
		
		if($this->form_validation->run() == TRUE)
		{	 
			$partId=$this->input->post('parts_id');  
			
			 $this->db->query("UPDATE tbl_spareparts_detail SET status='4',comment='' WHERE parts_id IN ($partId)"); 
			 
			 $json['error']='0';
			 $this->session->set_userdata('success','PART SUCCESSFULLY SENT TO ENGINEER');
		}
		else
		{
			$json['error']='1';
			$json['msg']=validation_errors();
		}
		
		echo json_encode($json);
		die;
	}
	
	public function submitRejectPartReason()
	{
		 $this->form_validation->set_rules('reason', 'REASON', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		 $this->form_validation->set_rules('parts_id', 'PARTS ITEM', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		if($this->form_validation->run() == TRUE)
		{	 
			$partId=$this->input->post('parts_id'); 
			
			$reason=$this->input->post('reason'); 
			$curDate=date("Y-m-d H:i:s");
			$this->db->query("UPDATE tbl_spareparts_detail SET status='6',comment='$reason',eng_action_date='$curDate' WHERE parts_id IN ($partId)"); 
			 
			 $json['error']='0';
			 $this->session->set_userdata('success','PART SUCCESSFULLY SENT TO WAREHOUSE');
		}
		else
		{
			$json['error']='1';
			$json['msg']=validation_errors();
		}
		
		echo json_encode($json);
		die;
	}
	
	public function submitPurchasePartReject()
	{
		 $this->form_validation->set_rules('reason', 'REASON', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		 $this->form_validation->set_rules('parts_id', 'PARTS ITEM', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		if($this->form_validation->run() == TRUE)
		{	 
			$partId=$this->input->post('parts_id'); 
			
			$reason=$this->input->post('reason'); 
			 $curDate=date("Y-m-d H:i:s");
			 $this->db->query("UPDATE tbl_spareparts_detail SET status='7',comment='$reason',purchase_action_date='$curDate' WHERE parts_id IN ($partId)"); 
			 
			 $json['error']='0';
			 $this->session->set_userdata('success','PARTS SUCCESSFULLY REJECTED BY PURCHASE DEPARTMENT');
		}
		else
		{
			$json['error']='1';
			$json['msg']=validation_errors();
		}
		
		echo json_encode($json);
		die;
	}
	
	function deviceQcPass()
	{
		$this->form_validation->set_rules('assessmentId', 'PARTS ITEM', 'trim|required',
				array(
					'required'  => '%s can not be empty.',  
				) 
			);
			
		if($this->form_validation->run() == TRUE)
		{
			$chkEngResult=$this->db->select('bulkstatus_id,nhdin,imei_no,eng_id')->get_where('trc_engassessment',array('assessment_id'=>$this->input->post('assessmentId'),'current_status'=>'IN QC'))->row_array();
			
			if(!empty($chkEngResult))
			{
				$grnResult=$this->db->select('nhmod,product_type,product_brand,device_name,nhdin,bin_number,warehouse')->get_where('tbl_grnreport',array('nhdin'=>$chkEngResult['nhdin']))->row_array();
				
				if(!empty($grnResult))
				{
					$this->db->where(array('assessment_id'=>$this->input->post('assessmentId'),'current_status'=>'IN QC'))->update('trc_engassessment',array('current_status'=>'IN QC PASS','status'=>'0','device_pass_status'=>$this->input->post('deviceStatus')));
				
					// INSERT DATA FOR RECEIVED ASSESSMENT STORE
				
				
					$assessmentArray=array(
						'user_id'=>$this->session->userdata('user_id'),
						'nhdin'=>$chkEngResult['nhdin'],
						'bulkstatus_id'=>$chkEngResult['bulkstatus_id'],
						'imei_no'=>$chkEngResult['imei_no'],
						'nhmod'=>$grnResult['nhdin'],
						'product_type'=>$grnResult['product_type'],
						'product_name'=>$grnResult['device_name'],
						'eng_id'=>$chkEngResult['eng_id'],
						'remark'=>'CERTIFICATION DEPARTMENT',
						'other_remark'=>'',
						'device_pass_status'=>$this->input->post('deviceStatus'),
						'bin_number'=>$chkEngResult['bin_number'],		
						'warehouse'=>$chkEngResult['warehouse'],		
					);
					
					$this->db->insert('tbl_recivedasses_stores',$assessmentArray);
					
					$json['error']='0';
					$json['msg']='DEVICE SUCCESSFULLY MOVED TO CERIFICATION DEPARTMENT';
				}
				else
				{
					$json['error']='1';
					$json['msg']='DEVICE IS NOT AVAILABLE IN GRN REPORT';
				}
			
			}			
			else
			{ 
				$json['error']='1';
				$json['msg']='DEVICE ALREADY PASSED BY ENGINEER.';
			}			
		}
		else
		{
			$json['error']='1';
			$json['msg']=validation_errors();
		}
		
		echo json_encode($json);
		die;
	}
}