<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Sellerflex extends Admin_Controller
{

    public function __constructore()
    {
        parent::__construct();
        $this->load->model('Ecom_model');
    }

    public function manage_sellerflex($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'Sellerflex';
        $data['subview'] = $this->load->view('admin/sellerflex/manage_sellerflex', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function createSalesorder()
    {
        $data = json_decode(file_get_contents("php://input"), TRUE);

        if (empty($data)) {
            $json = array('status' => 0, 'message' => 'Empty request');
            echo json_encode($json);
            exit();
        }

        $order_ids = [];
        foreach ($data as $key => $value) {
            $order_ids[] = $value['order_id'];
        }

        $result = $this->db->where_in('saleschannel_ref_id', $order_ids)->get('tbl_salesorder')->result_array();
	
        $srd = '';
        if (!empty($result)) {
            foreach ($result as $key => $value) {
                $srd .= $value['saleschannel_ref_id'] . ',';
            }

            $json['status'] = 0;
            $json['message'] = 'Order Ids already exist in Salesorder table. Order Ids: ' . $srd;
            echo json_encode($json);
            exit();
        }

        $state_result = $this->db->get('tbl_states')->result_array();
        $state_arr = [];

        foreach ($state_result as $key => $value) {
            $state_name = $value['name'];
            if ($value['name'] == 'Jammu and Kashmir') {
                $state_name = 'Jammu & Kashmir';
            }

            if ($value['name'] == 'Dadra and Nagar Haveli') {
                $state_name = 'Dadra & Nagar Haveli';
            }

            if ($value['name'] == 'Andaman and Nicobar Islands') {
                $state_name = 'Andaman & Nicobar Islands';
            }

            if ($value['name'] == 'Daman and Diu') {
                $state_name = 'Daman & Diu';
            }

            $state_arr[strtoupper($state_name)] = $value['state_id'];
        }

        /********************************Start Transaction ****************/
        //var_dump($state_arr);
        $this->db->trans_start();

        $quantity = [];
        foreach ($data as $key => $rowValue) {

            /********************Create Vendor**************************** */
            //print $rowValue['state'];
            $insert_arr = array(
                "added_userid" => $this->session->userdata('user_id'),
                "name" => "SELLERFLEX",
                "company" => "SELLERFLEX",
                "user_type" => "ONLINE",
                "email" => "ecom@sloyd.in",
                "mobile" => "9177898555",
                "address" => "",
                "city" => $rowValue['city'],
                "state" => $state_arr[strtoupper($rowValue['state'])],
                "pincode" => $rowValue['postalcode'],
                "pan_card" => '',
                "aadhar_no" => '',
                "gst_no" => '',
                "created_date" => date("Y-m-d H:i:s"),
                "modify_time" => date("Y-m-d H:i:s"),
                "country" => "INDIA",
                "used_type" => "buyer"
            );

            if ($rowValue['order_status'] == 'Cancelled') {
                $status = 'CANCELLED';
            } else {
                $status = 'PENDING';
            }

            /***********************Create Sales Order ***************************/
            $headerArray = array(
                "salesman_code" => $this->session->userdata('user_id'),
                "payment_mode" => "COD",
                "warehouse" => "TDWD",
                "sales_channel" => "SELLERFLEX",
                "saleschannel_ref_id" => $rowValue['order_id'],
                "device_sub_category" => "",
                "tcs_amount" => 0,
                "tcs_percent" => 0,
                "status" => $status,
                "CREATION_DATE" => date("Y-m-d H:i:s", strtotime($rowValue['purchase_date'])),
                "CREATED_BY" => $this->session->userdata('user_id'),
                "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
            );


            /***********************Create Sales Order Details ***************************/

            $total_amount = 0;
            $rowArray = [];
            foreach ($rowValue['order_items'] as $itemValue) {
                if ($status == 'CANCELLED') {
                    $quantity[$itemValue['sku']] += 0;
                } else {
                    $quantity[$itemValue['sku']] += $itemValue['quantity'];
                }

                $price = round($itemValue['price'] / $itemValue['quantity'], 2);

                $availableQuantity = $this->db->select('nhdin')->where(array(
                    'SKU' => $itemValue['sku'],
                    'saletype' => 'SELLERFLEX',
                    'status' => 'RFS',
                ))->get('tbl_grnreport')->num_rows();

                $reservedQuantity = $this->db->select('sum(quantity) as quantity')->where(array(
                    'SKU' => $itemValue['sku'],
                    'sales_channel' => 'SELLERFLEX',
                ))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;


                if (!empty($reservedQuantity)) {
                    if ($availableQuantity > $reservedQuantity) {
                        $netQuantity = $availableQuantity - $reservedQuantity;
                    } else {
                        $netQuantity = $reservedQuantity - $availableQuantity;
                    }
                } else {
                    $netQuantity = $availableQuantity;
                }

                $netQuantity = $availableQuantity - $reservedQuantity;

                if ($status != 'CANCELLED') {
                    if ($quantity[$itemValue['sku']] > $netQuantity) {
                        $json['status'] = 0;
                        $json['message'] = 'Order quantity greater than available quantity for ' . $itemValue['sku'];
                        echo json_encode($json);
                        die;
                    }
                }
                for ($x = 0; $x < $itemValue['quantity']; $x++) {
                    $rowArray[] = array(
                        'sku' => $itemValue['sku'],
                        'device_name' => $itemValue['product_name'],
                        'category' => "",
                        'grade' => "",
                        'sales_terms' => "",
                        'quantity' => $itemValue['quantity'],
                        'sale_price' => $price,
                        'amount' => $itemValue['price'],
                    );
                }
                $total_amount += $itemValue['price'];
            }

            $headerArray['discount_value'] = 0;
            $headerArray['discount_type'] = 'amount';
            $headerArray['discount_amount'] = 0;
            $headerArray['insurance_value'] = 0;
            $headerArray['insurance_type'] = 'amount';
            $headerArray['insurance_amount'] = 0;
            $headerArray['freight_amount'] = 0;

            if (empty($headerArray) || empty($rowArray)) {
                $json['status'] = 0;
                echo json_encode($json);
                die;
            }

            /***********Create Vendor ***********/

            $this->db->insert('tbl_vendor', $insert_arr);
            $vendor_id = $this->db->insert_id();

            if (empty($vendor_id)) {
                $json['status'] = 0;
                $json['message'] = 'Vendor not created for ' . $rowValue['order_id'];
                echo json_encode($json);
                exit;
            }
            $codeNO = $this->Common_model->getSeriesForVenBuyerCode($vendor_id);

            $code = "SLYB-H-ONL-" . $codeNO;

            $this->db->where('vendor_id', $vendor_id)->update('tbl_vendor', array('vendor_code' => $code));

            /***********Create Sales Order ***********/

            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesorder')->get()->row_array();
            $next_number = $res['max'] + 1;
            $sales_code = 'SO-TDWD-' . $next_number;

            $headerArray["salesorder_code"] = $sales_code;
            $headerArray["vendor_id"] = $vendor_id;

            $this->db->insert('tbl_salesorder', $headerArray);

            $salesorder_id = $this->db->insert_id();

            if (empty($salesorder_id)) {
                $json['status'] = 0;
                $json['message'] = 'Sales Order not created for ' . $rowValue['order_id'];
                echo json_encode($json);
                exit;
            }

            for ($i = 0; $i < sizeof($rowArray); $i++) {

                $rowArray[$i]["salesorder_id"] = $salesorder_id;
            }

            $this->db->insert_batch('tbl_salesorder_item', $rowArray);

            $error = $this->db->error();

            if ($error['code'] != 0) {
                $json['status'] = 0;
                $json['message'] = 'Sales Order not created for ' . $rowValue['order_id'];
                echo json_encode($json);
                exit;
            }
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        $json['message'] = 'Sales Order created successfully';
        echo json_encode($json);
        exit;
    }

    public function getInvoiceList()
    {
        $status = $this->input->get('status');
        if (empty($status)) {
            $status = 'PENDING';
        }

        $users = $this->db->select('username, user_id')->get('tbl_users')->result_array();
        $user_array = array();
        foreach ($users as $user) {
            $user_array[$user['user_id']] = $user['username'];
        }

        if($status == 'PENDING'){
            $this->db->where_in('status', array('FINANCE_PENDING', 'FINANCE_APPROVED', 'PENDING'));
        }else{
            $this->db->where('status', $status);

        }

        $this->db->where('sales_channel', 'SELLERFLEX');
        $result = $this->db->get('SALESORDER_LIST_VIEW')->result_array();

        $data = [];
        foreach ($result as $key => $value) {
            $data[] = array(
                'salesorder_id' => $value['salesorder_id'],
                'salesorder_no' => $value['salesorder_code'],
                'invoice_no' => $value['invoice_code'] ? $value['invoice_code'] : '',
                'order_date' => date("d-m-Y", strtotime($value['CREATION_DATE'])),
                'vendor_name' => $value['vendor_name'],
                'status' => $value['status'],
                'total_amount' => $value['total_amount'],
                'taxable_amount' => round($value['total_amount'] / GST_118, 2),
                'tax_amount' => round($value['total_amount'] - $value['total_amount'] / GST_118, 2),
                'quantity' => $value['quantity'],
                'invoice_id' => $value['invoice_id'],
                'invoice_date' => $value['invoice_date'] ? date("d-m-Y", strtotime($value['invoice_date'])) : '',
                "status" => $value['status'],
                "saleschannel_ref_id" => $value['saleschannel_ref_id'],
                "sales_channel" => $value['sales_channel'],
                "payment_mode" => $value['payment_mode'],
                "created_by" => $user_array[$value['created_by']],
                "last_updated_by" => $user_array[$value['last_updated_by']],
                'creation_date' => date("d-m-Y", strtotime($value['CREATION_DATE'])),
                'last_update_date' => $value['LAST_UPDATE_DATE'] ? date("d-m-Y", strtotime($value['LAST_UPDATE_DATE'])) : '',
            );
        }

        $json['status'] = 1;
        $json['data'] = $data;
        echo json_encode($json);
        exit;
    }

    public function getSOData()
    {
        $this->db->where('status', 'PENDING');
        $this->db->select('salesorder_code, saleschannel_ref_id, device_name, sku');
        $this->db->join('tbl_salesorder_item', 'tbl_salesorder_item.salesorder_id = tbl_salesorder.salesorder_id');
        $result = $this->db->get('tbl_salesorder')->result_array();

        $data[] = ["Salesorder No", "Order ID", "Device Name", "SKU", "TDID", "Vendor Name", "GSTIN", "Vendor Address"];
        foreach ($result as $key => $value) {
            $data[] = array(
                $value['salesorder_code'],
                $value['saleschannel_ref_id'],
                str_replace(',', '-', $value['device_name']),
                $value['sku']
            );
        }

        //Write to CSV file
        $file = fopen("salesorder.csv", "w");
        foreach ($data as $line) {
            fputcsv($file, $line);
        }
        fclose($file);
        //download csv
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename="salesorder.csv"');
        readfile("salesorder.csv");
        //destroy csv file
        unlink("salesorder.csv");
        exit;
    }

    function uploadInvoiceDevices()
    {
        $data = json_decode(file_get_contents("php://input"), TRUE);

        $device_ids = [];
        $existing_tdids = [];
        $order_nos = [];
        $existing_order_nos = [];
        $order_devices = [];
        $vendor_details = [];

        foreach ($data as $key => $rowValue) {
            $device_ids[] = $rowValue['device_id'];
            $order_nos[] = $rowValue['order_id'];
            $order_devices[$rowValue['order_id']][] = $rowValue['device_id'];
            if (strlen(trim($rowValue['vendor_name'])) > 0) {
                $vendor_details[$rowValue['order_id']] = array(
                    "company" => $rowValue['vendor_name'],
                    "gstin" => $rowValue['gstin'],
                    "address" => $rowValue['address']
                );
            }
        }

        $this->db->where('saletype', 'SELLERFLEX')->where('status', 'RFS');
        $this->db->where_in('nhdin', $device_ids);
        $result = $this->db->get('tbl_grnreport')->result_array();

        $device_details = [];
        foreach ($result as $key => $rowValue) {
            $existing_tdids[] = $rowValue['nhdin'];
            $device_details[$rowValue['nhdin']] = $rowValue;
        }
        unset($result);

        $diff_arr = array_diff($device_ids, $existing_tdids);
        if (!empty($diff_arr)) {
            $json['status'] = 0;
            $json['message'] = 'Device ID(s) ' . implode(',', $diff_arr) . ' not found in SELLERFLEX/RFS';
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where_in('saleschannel_ref_id', $order_nos)->where('status', 'PENDING')->get('tbl_salesorder')->result_array();
        $salesorder_ids_assoc = [];
        $salesorder_ids_index = [];
        foreach ($result as $key => $rowValue) {
            $existing_order_nos[] = $rowValue['saleschannel_ref_id'];
            $salesorder_ids_assoc[$rowValue['saleschannel_ref_id']] = $rowValue['salesorder_id'];
            $salesorder_ids_index[] = $rowValue['salesorder_id'];
        }

        $diff_arr = array_diff(array_unique($order_nos), $existing_order_nos);
        if (!empty($diff_arr)) {
            $json['status'] = 0;
            $json['message'] = 'Order ID(s) ' . implode(',', $diff_arr) . ' are not in PENDING Status';
            echo json_encode($json);
            exit;
        }

        $inv_result = $this->db->where_in('salesorder_id', $salesorder_ids_index)->get('tbl_invoice')->result_array();

        if (!empty($inv_result)) {
            $inv = [];
            foreach ($inv_result as $inv_res) {
                $inv[] = $inv_res['invoice_code'];
            }
            $json['status'] = 0;
            $json['message'] = 'Invoice already generated for Some orders. ' . implode(',', $inv);
            echo json_encode($json);
            exit;
        }

        $stateResult = $this->db->select('state_id, state_gst_id')->get('tbl_states')->result_array();
        $state_gst_array = [];
        foreach ($stateResult as $key => $rowValue) {
            $state_gst_array[$rowValue['state_id']] = $rowValue['state_gst_id'];
        }


        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(invoice_code,"-",-1) as UNSIGNED)) as max')->from('tbl_invoice')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }

        //Start Creating Invoices

        /***************************** Create Invoice  **************************/
        $this->db->trans_start();

        foreach ($order_devices as $key => $value) {

            $invoice_item_rows = [];
            $sold_items = [];

            $so_items_update_array = [];
            $total_amount = 0;
            $total_tax = 0;

            $salesorder = $this->db->where('saleschannel_ref_id', $key)->get('tbl_salesorder')->row();
            if (!$salesorder) {
                $json['status'] = 0;
                $json['message'] = 'Order ID ' . $key . ' not found';
                echo json_encode($json);
                exit;
            }
            $salesorder_id = $salesorder->salesorder_id;
            $vendorResult = $this->db->select('state')->where('vendor_id', $salesorder->vendor_id)->get('tbl_vendor')->row();

            $state_gst_id = $state_gst_array[$vendorResult->state];

            if ($state_gst_id == 36) {
                $tax_type = 'CGST18';
            } else {
                $tax_type = 'IGST18';
            }

            $so_items = $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder_item')->result_array();
            $device_sub_category = '';
            foreach ($so_items as $item) {
                $sku = $item['sku'];

                foreach ($order_devices[$salesorder->saleschannel_ref_id] as $key2 => $orderdeviceid) {

                    if ($device_details[$orderdeviceid]['SKU'] == $sku) {
                        if ($device_details[$orderdeviceid]['mrp'] != $item['sale_price']) {
                            $json['status'] = 0;
                            $json['message'] = 'Sale Price of ' . $device_details[$orderdeviceid]['device_name'] . ' is not matching with Approved Price for ' . $key;;
                            echo json_encode($json);
                            exit;
                        }
                        $so_items_update_array[] = array(
                            'salesorder_item_id' => $item['salesorder_item_id'],
                            'grnreport_id' => $device_details[$orderdeviceid]['grnreport_id'],
                            'device_name' => $device_details[$orderdeviceid]['device_name'],
                            'category' => $device_details[$orderdeviceid]['stock_type'],
                            'grade' => $device_details[$orderdeviceid]['certification_grade'],
                        );
                        if (in_array('SELLERFLEX', MARGINAL_NOT_ALLOWED_CHANNELS)) {
                            $tax = $item['sale_price'] - $item['sale_price'] / 1.18;
                            $taxable = $item['sale_price'] / 1.18;
                            $exempt = 0.00;
                            $margin = $item['sale_price'] - ($device_details[$orderdeviceid]['unit_price'] + $device_details[$orderdeviceid]['unit_price_tax']);
                            $margin_perc = ($margin / $item['sale_price']) * 100;
                        } else {
                            if ($device_details[$orderdeviceid]['invoice_type'] == 'exempt' || $device_details[$orderdeviceid]['invoice_type'] == 'exempted') {

                                $margin = $item['sale_price'] - ($device_details[$orderdeviceid]['unit_price'] + $device_details[$orderdeviceid]['unit_price_tax']);
                                $exempt = $device_details[$orderdeviceid]['unit_price'] + $device_details[$orderdeviceid]['unit_price_tax'];
                                $taxable = $margin / 1.18;
                                $tax = $margin - $taxable;

                                if ($margin < 0) $margin = 0;

                                if ($exempt > $item['sale_price']) {
                                    $exempt = $item['sale_price'];
                                    $tax = 0;
                                    $taxable = 0;
                                }
                                $margin_perc = ($margin / $item['sale_price']) * 100;
                            } else {
                                $tax = $item['sale_price'] - $item['sale_price'] / 1.18;
                                $taxable = $item['sale_price'] / 1.18;
                                $exempt = 0.00;
                                $margin = $item['sale_price'] - ($device_details[$orderdeviceid]['unit_price'] + $device_details[$orderdeviceid]['unit_price_tax']);
                                $margin_perc = ($margin / $item['sale_price']) * 100;
                            }
                        }


                        $total_amount += $item['sale_price'];
                        $total_tax += $tax;

                        $invoice_item_rows[] = array(
                            "grnreport_id" => $device_details[$orderdeviceid]['grnreport_id'],
                            "deviceid" => $device_details[$orderdeviceid]['nhdin'],
                            "price" => $item['sale_price'],
                            "tax_amount" => $tax,
                            "taxable_amount" => $taxable,
                            "exempt_amount" => $exempt,
                            "margin" => $margin,
                            "margin_perc" => $margin_perc,
                            "sales_terms" => $item["sales_terms"],
                            "category" => $device_details[$orderdeviceid]['stock_type'],
                            "grade" => $device_details[$orderdeviceid]['certification_grade'],
                            "tax_type" => $tax_type,
                            "bill_type" => $device_details[$orderdeviceid]['invoice_type'],
                            "CREATION_DATE" => date("Y-m-d H:i:s")
                        );
                        $device_sub_category = $device_details[$orderdeviceid]['mrp']['device_sub_category'];
                        unset($order_devices[$salesorder->saleschannel_ref_id][$key2]);
                    }
                }
            }

            if (count($so_items_update_array) != count($so_items)) {
                $json['status'] = 0;
                $json['message'] = 'Invalid TDIDs for Order ID ' . $key;
                echo json_encode($json);
                exit;
            }

            $salesman_id = $salesorder->salesman_code;

            $invoice_code = 'SLY-' . $salesorder->warehouse . '-' . $next_number;
            $next_number += 1;

            $invoice_header = array(
                "vendor_id" => $salesorder->vendor_id,
                "invoice_code" => $invoice_code,
                "salesorder_id" => $salesorder_id,
                "salesman_id" => $salesman_id,
                "sales_channel" => $salesorder->sales_channel,
                "warehouse" => $salesorder->warehouse,
                "status" => "INVOICED",
                "invoice_amount" => $total_amount,
                "tax_amount" => $total_tax,
                "payment_mode" => $salesorder->payment_mode,
                "CREATION_DATE" => date("Y-m-d H:i:s"),
                "CREATED_BY" => $this->session->userdata('user_id')
            );

            //Insert Invoice
            $this->db->insert('tbl_invoice', $invoice_header);
            $invoice_id = $this->db->insert_id();

            foreach ($invoice_item_rows as $key1 => $rowValue) {
                $invoice_item_rows[$key1]['invoice_id'] = $invoice_id;
                $sold_items[] = array(
                    "grnreport_id" => $rowValue["grnreport_id"],
                    "status" => "SOLD",
                    "remark" => $invoice_code
                );
            }

            //Insert Invoice Items
            $this->db->insert_batch('tbl_invoice_item', $invoice_item_rows);
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }

            //update SO Items
            $this->db->update_batch('tbl_salesorder_item', $so_items_update_array, 'salesorder_item_id');
            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }

            //Change Device Status
            $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }

            //Change Sales Order Status
            $this->db->where("salesorder_id", $salesorder_id);
            $this->db->update('tbl_salesorder', array("status" => "INVOICED", "device_sub_category" => $device_sub_category, "LAST_UPDATED_BY" => $this->session->userdata('user_id')));

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }
            if (!empty($vendor_details[$key]['company'])) {
                $update_vendor_arr = array(
                    "company" => $vendor_details[$key]['company'],
                    "gst_no" => $vendor_details[$key]['gstin'] ? $vendor_details[$key]['gstin'] : '',
                    "address" => $vendor_details[$key]['address'] ? $vendor_details[$key]['address'] : '',
                );

                $this->db->where("vendor_id", $salesorder->vendor_id);
                $this->db->update('tbl_vendor', $update_vendor_arr);
                if ($error['code'] != 0) {
                    $json['status'] = 0;
                    $json['message'] = 'Error in updating vendor details for ' . $key;
                    echo json_encode($json);
                    exit;
                }
            }
        }

        $this->db->trans_complete();


        /********************************Invoices Created **********************/

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getVendorNameFile()
    {
        $this->db->where('company', 'SELLERFLEX');
        $this->db->select('saleschannel_ref_id, salesorder_code');
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_salesorder.vendor_id');
        $result = $this->db->get('tbl_salesorder')->result_array();

        $data[] = ["Salesorder No", "Order ID", "Vendor Name", "GSTIN", "Address"];
        foreach ($result as $key => $value) {
            $data[] = array(
                $value['salesorder_code'],
                $value['saleschannel_ref_id'],
                '',
                '',
                ''
            );
        }

        //Write to CSV file
        $file_name = "vendor_name" . date("d-m-Y H:i") . ".csv";
        $file = fopen($file_name, "w");
        foreach ($data as $line) {
            fputcsv($file, $line);
        }
        fclose($file);
        //download csv
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename=' . $file_name);
        readfile($file_name);
        //destroy csv file
        unlink($file_name);
        exit;
    }

    public function updateVendorName()
    {
        $data = json_decode(file_get_contents('php://input'), true);

        if (empty($data)) {
            $json['status'] = 0;
            $json['message'] = 'Invalid Request';
            echo json_encode($json);
            exit;
        }

        $order_ids = [];
        $vendor_name = [];
        foreach ($data as $key => $value) {

            $order_ids[] = $value['order_id'];
            $vendor_name[$value['order_id']] = array(
                "company" => $value['vendor_name'],
                "gstin" => $value['gstin'],
                "address" => $value['address']
            );
        }

        $result = $this->db->where_in('saleschannel_ref_id', $order_ids)->get('tbl_salesorder')->result_array();

        $this->db->trans_start();
        foreach ($result as $key => $value) {
            $vendor_id = $value['vendor_id'];

            $this->db->where('vendor_id', $vendor_id);
            $this->db->update('tbl_vendor', $vendor_name[$value['saleschannel_ref_id']]);
        }
        $this->db->trans_complete();

        $json['status'] = 1;
        $json['message'] = "Vendor Names Updated Successfully";
        echo json_encode($json);
        exit;
    }

    public function downloadSampleStn()
    {
        $data[] = ["Device id"];


        //Write to CSV file
        $file_name = "stn" . date("d-m-Y H:i") . ".csv";
        $file = fopen($file_name, "w");
        foreach ($data as $line) {
            fputcsv($file, $line);
        }
        fclose($file);
        //download csv
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename=' . $file_name);
        readfile($file_name);
        //destroy csv file
        unlink($file_name);
        exit;
    }

    public function getSalesorderItems()
    {
        $salesorder_id = $this->input->get('salesorder_id');

        if (empty($salesorder_id)) {
            $json['status'] = 0;
            $json['result'] = [];
            $json['message'] = 'Invalid Request';
            echo json_encode($json);
            exit;
        }
    }

    public function uploadPickedDevices()
    {
        $data = json_decode(file_get_contents('php://input'), true);

        if (empty($data)) {
            $json['status'] = 0;
            $json['message'] = 'Invalid Request';
            echo json_encode($json);
            exit;
        }

        $devices = [];
        $device_price_data = [];
        $grnreport_ids = [];
        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(document_no,"-",-1) as UNSIGNED)) as max')->from('tbl_ecom_devices')->get()->row_array();
        $next_number = $res['max'] + 1;
        $document_no = 'SFL-' . $next_number;

        foreach ($data as $rowValue) {
            $devices[] = $rowValue['device_id'];
            $device_price_data[] = array(
                "device_id" => $rowValue['device_id'],
                "listing_amount" => $rowValue['listing_amount'],
                "remittance_amount" => $rowValue['remittance_amount'],
                "document_no" => $document_no,
            );
        }

        $device_result = $this->db->select('nhdin, grnreport_id, mrp, status, saletype')->where_in('nhdin', $devices)->get('tbl_grnreport')->result_array();

        if (empty($device_result)) {
            $json['status'] = 0;
            $json['message'] = 'Invalid Devices';
            echo json_encode($json);
            exit;
        }

        foreach ($device_result as $key => $value) {
            if ($value['status'] != 'RFS') {
                $json['status'] = 0;
                $json['message'] = 'Device ' . $value['nhdin'] . ' is not a RFS Device';
                echo json_encode($json);
                exit;
            }

            if ($value['saletype'] != 'OFFLINE') {
                $json['status'] = 0;
                $json['message'] = 'Device ' . $value['nhdin'] . ' is not a OFFLINE Device';
                echo json_encode($json);
                exit;
            }

            $grnreport_ids[$value['nhdin']] = $value['grnreport_id'];
        }

        foreach ($device_price_data as $key => $value) {

            if (!isset($grnreport_ids[$value['device_id']])) {
                $json['status'] = 0;
                $json['message'] = 'Device ID ' . $value['device_id'] . ' is not Valid';
                echo json_encode($json);
                exit;
            }

            $device_price_data[$key]['grnreport_id'] = $grnreport_ids[$value['device_id']];
            unset($device_price_data[$key]['device_id']);
        }

        //Insert price log in tbl_grnreport_price_log in batch
        $this->db->insert_batch('tbl_ecom_devices', $device_price_data);

        $error = $this->db->error();
        //if error
        if ($error['code'] != 0) {
            $this->db->trans_rollback();

            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        $json['status'] = 1;
        $json['message'] = 'Devices Listing Amount Updated Successfully';
        echo json_encode($json);
        exit;
    }

    public function downloadPrices()
    {
        $result = $this->db->select('nhdin, device_name, listing_amount, remittance_amount')
            ->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_ecom_devices.grnreport_id')
            ->where('tbl_grnreport.mrp', 0)
            ->get('tbl_ecom_devices')->result_array();

        $data[] = ["Device ID", "Device Name", "Listing Amount", "Remittance Amount", "Document No"];

        foreach ($result as $key => $value) {
            $data[] = [$value['nhdin'], $value['device_name'], $value['listing_amount'], $value['remittance_amount'], $value['document_no']];
        }

        //Write to CSV file
        $file_name = "prices" . date("d-m-Y H:i") . ".csv";
        $file = fopen($file_name, "w");
        foreach ($data as $line) {
            fputcsv($file, $line);
        }
        fclose($file);
        //download csv
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename=' . $file_name);
        readfile($file_name);
        //destroy csv file
        unlink($file_name);
        exit;
    }

    public function getDevicePriceList()
    {
        $action = $this->input->get('action');

        if ($action == 'TO_BE_PRICED') {
            $where_arr = array(
                'tbl_ecom_devices.grnreport_id>' => 0,
                'tbl_grnreport.mrp' => 0,
            );
        }

        if ($action == 'WH_PENDING') {
            $where_arr = array(
                'tbl_ecom_devices.grnreport_id>' => 0,
                'tbl_grnreport.mrp>' => 0,
                'tbl_grnreport.saletype !=' => 'SELLERFLEX',
            );
        }

        if ($action == 'SOLD') {
            $where_arr = array(
                'tbl_ecom_devices.grnreport_id>' => 0,
                'tbl_grnreport.saletype' => 'SELLERFLEX',
                'tbl_grnreport.mrp>' => 0,
                'tbl_grnreport.status' => 'SOLD',
            );
        }

        if ($action == 'AVAILABLE') {
            $where_arr = array(
                'tbl_ecom_devices.grnreport_id>' => 0,
                'tbl_grnreport.saletype' => 'SELLERFLEX',
                'tbl_grnreport.mrp>' => 0,
                'tbl_grnreport.status !=' => 'SOLD',
            );
        }

        if (empty($action)) {
            $json['status'] = 0;
            $json['message'] = 'Invalid Action';
            echo json_encode($json);
            exit;
        }


        $result = $this->db
            ->select('tbl_grnreport.*, tbl_ecom_devices.document_no, tbl_ecom_devices.grnreport_id as picked_id')
            ->where($where_arr)
            ->join('tbl_ecom_devices', 'tbl_grnreport.grnreport_id = tbl_ecom_devices.grnreport_id', 'left')
            ->get('tbl_grnreport')
            ->result();
        $json_array = [];
        if (empty($result)) {
            $json_array['status'] = 0;
            $json_array['data'] = [];
            echo json_encode($json_array);
            exit();
        }
        $data = [];
        foreach ($result as $key => $rowValue) {
            $data[] = [
                'grnreport_id' => $rowValue->grnreport_id,
                'device_id' => $rowValue->nhdin,
                'mrp' => $rowValue->mrp,
                'device_name' => $rowValue->device_name,
                'sku' => $rowValue->SKU,
                'category' => $rowValue->stock_type,
                'status' => $rowValue->status,
                'batch_no' => $rowValue->batch_no,
                'lot_no' => $rowValue->document_no,
            ];
            unset($result[$key]);
        }
        $json_array['status'] = 1;
        $json_array['data'] = $data;
        unset($data);
        echo json_encode($json_array);
        exit();
    }

    public function createSOwithDevice()
    {
        $data = json_decode(file_get_contents("php://input"), TRUE);

        if (empty($data)) {
            $json = array('status' => 0, 'message' => 'Empty request');
            echo json_encode($json);
            exit();
        }

        $order_ids = [];
        foreach ($data as $key => $value) {
            $order_ids[] = $value['order_id'];
        }

        $result = $this->db->where_in('saleschannel_ref_id', $order_ids)->where_not_in('status',array('CANCELLED', 'CANCELED', 'VOID'))->get('tbl_salesorder')->result_array();

        $srd = '';
        if (!empty($result)) {
            foreach ($result as $key => $value) {
                $srd .= $value['saleschannel_ref_id'] . ',';
            }

            $json['status'] = 0;
            $json['message'] = 'Order Ids already exist in Salesorder table. Order Ids: ' . $srd;
            echo json_encode($json);
            exit();
        }

        $state_result = $this->db->get('tbl_states')->result_array();
        $state_arr = [];

        foreach($state_result as $key => $value) {
            $state_arr[strtolower($value['name'])] = $value['state_id'];
        }

        /********************************Start Transaction ****************/
        $this->db->trans_start();

        $quantity = [];
        foreach ($data as $key => $rowValue) {
            /********************Create Vendor**************************** */
            //print $rowValue['state'];

            if(!array_key_exists(strtolower(trim($rowValue['state'])), $state_arr)) {
                $json['status'] = 0;
                $json['message'] = 'Invalid State: ' . $rowValue['state']. ' Please check state name';
                echo json_encode($json);
                exit();
            }

            $vendor_name = empty($rowValue['vendor_name']) ? "SELLERFLEX":$rowValue['vendor_name'];
            $insert_arr = array(
                "added_userid" => $this->session->userdata('user_id'),
                "name" => $vendor_name,
                "company" => $vendor_name,
                "user_type" => "ONLINE",
                "email" => "ecom@sloyd.in",
                "mobile" => "9177898555",
                "address" => "",
                "city" => $rowValue['city'],
                "state" => $state_arr[strtolower(trim($rowValue['state']))],
                "pincode" => $rowValue['pincode'],
                "pan_card" => '',
                "aadhar_no" => '',
                "gst_no" => '',
                "created_date" => date("Y-m-d H:i:s"),
                "modify_time" => date("Y-m-d H:i:s"),
                "country" => "INDIA",
                "used_type" => "buyer"
            );

            if ($rowValue['order_status'] == 'Cancelled') {
                $status = 'CANCELLED';
            } else {
                $status = 'FINANCE_APPROVED';
            }

            /***********************Create Sales Order ***************************/
            $headerArray = array(
                "salesman_code" => $this->session->userdata('user_id'),
                "payment_mode" => "COD",
                "warehouse" => "TDWD",
                "salesman_code" => $this->session->userdata('user_id'),
                "sales_channel" => "SELLERFLEX",
                "saleschannel_ref_id" => $rowValue['order_id'],
                "device_sub_category" => "",
                "tcs_amount" => 0,
                "tcs_percent" => 0,
                "status" => $status,
                "CREATION_DATE" => date("Y-m-d H:i:s", strtotime($rowValue['date'])),
                "CREATED_BY" => $this->session->userdata('user_id'),
                "LAST_UPDATE_DATE" => date("Y-m-d H:i:s"),
            );

            /***********************Create Sales Order Details ***************************/
            $total_amount = 0;
            $rowArray = [];
            $nhdin = [];
            foreach ($rowValue['order_items'] as $itemValue) {

                $where_device = array(
                    "SKU" => trim(strtoupper($itemValue['sku'])),
                    "nhdin" => $itemValue['device_id'],
                    "status" => "RFS",
                    "saletype" => "SELLERFLEX",
                );

                $check_device = $this->db->where($where_device)->get('tbl_grnreport')->row();

                if (empty($check_device)) {
                    $json['status'] = 0;
                    $json['message'] = 'Invalid Device ID: ' . $itemValue['device_id'];
                    echo json_encode($json);
                    exit();
                }

                if ($check_device->bundle_id > 0) {
                    $json['status'] = 0;
                    $json['message'] = $itemValue['device_id'] . ' is a bundle device';
                    echo json_encode($json);
                    exit();
                }
		
		if ($check_device->mrp != $itemValue['amount']) {
                    $json['status'] = 0;
                    $json['message'] = 'Sale Price of ' . $itemValue['device_id'] . ' is not matching with Approved Price. '.$itemValue['amount']. ' '. $check_device->mrp;
                    echo json_encode($json);
                    exit;
                }

                $status_arr = ["DRAFT", "FINANCE_PENDING", "FINANCE_APPROVED", "INVOICED", "FINANCE_REJECTED"];

                $this->db->select('tbl_salesorder.salesorder_code')->join('tbl_salesorder', 'tbl_salesorder.salesorder_id = tbl_salesorder_item.salesorder_id', 'Left');
                $old_so = $this->db->where('tbl_salesorder_item.grnreport_id', $check_device->grnreport_id)->where_in('tbl_salesorder.status', $status_arr)->get('tbl_salesorder_item')->row();
                if (!empty($old_so)) {
                    $json['status'] = 0;
                    $json['message'] = 'Device ' . $rowValue['device_id'] . " Already present in " . $old_so->salesorder_code;
                    echo json_encode($json);
                    die;
                }

                if ($nhdin[trim(strtoupper($itemValue['device_id']))] == true) {
                    $json['status'] = 0;
                    $json['message'] = 'Duplicate NHIN found in Order Id: ' . $rowValue['order_id'];
                    echo json_encode($json);
                    exit();
                } else {
                    $nhdin[trim(strtoupper($itemValue['device_id']))] = true;
                }

                $price = round($itemValue['price'] / $itemValue['quantity'], 2);

                $availableQuantity = $this->db->select('nhdin')->where(array(
                    'SKU' => $itemValue['sku'],
                    'saletype' => 'SELLERFLEX',
                    'status' => 'RFS',
                ))->get('tbl_grnreport')->num_rows();

                $reservedQuantity = $this->db->select('sum(quantity) as quantity')->where(array(
                    'SKU' => $itemValue['sku'],
                    'sales_channel' => 'SELLERFLEX',
                ))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;


                if (!empty($reservedQuantity)) {
                    if ($availableQuantity > $reservedQuantity) {
                        $netQuantity = $availableQuantity - $reservedQuantity;
                    } else {
                        $netQuantity = $reservedQuantity - $availableQuantity;
                    }
                } else {
                    $netQuantity = $availableQuantity;
                }

                $netQuantity = $availableQuantity - $reservedQuantity;

                if ($status != 'CANCELLED') {
                    if ($itemValue['quantity'] > $netQuantity) {
                        $json['status'] = 0;
                        $json['message'] = 'Order quantity greater than available quantity for ' . $itemValue['sku'];
                        echo json_encode($json);
                        die;
                    }
                }

                $rowArray[] = array(
                    'sku' => $itemValue['sku'],
                    'device_name' => $itemValue['device_name'],
                    'grnreport_id' => $check_device->grnreport_id,
                    'category' => $check_device->stock_type,
                    'grade' => $check_device->certification_grade,
                    'sales_terms' => "FULL QC",
                    'quantity' => $itemValue['quantity'],
                    'sale_price' => $itemValue['amount'],
                    'amount' => $itemValue['amount'],
                );
                $total_amount += $itemValue['price'];
            }

            $headerArray['discount_value'] = 0;
            $headerArray['discount_type'] = 'amount';
            $headerArray['discount_amount'] = 0;
            $headerArray['insurance_value'] = 0;
            $headerArray['insurance_type'] = 'amount';
            $headerArray['insurance_amount'] = 0;
            $headerArray['freight_amount'] = 0;

            if (empty($headerArray) || empty($rowArray)) {
                $json['status'] = 0;
                $json['empty'] = 'empty Data';
                echo json_encode($json);
                die;
            }

            /***********Create Vendor ***********/

            $this->db->insert('tbl_vendor', $insert_arr);
            $vendor_id = $this->db->insert_id();

            if (empty($vendor_id)) {
                $json['status'] = 0;
                $json['message'] = 'Vendor not created for ' . $rowValue['order_id'];
                echo json_encode($json);
                exit;
            }
            $codeNO = $this->Common_model->getSeriesForVenBuyerCode($vendor_id);

            $code = "SLYB-H-ONL-" . $codeNO;

            $this->db->where('vendor_id', $vendor_id)->update('tbl_vendor', array('vendor_code' => $code));

            /***********Create Sales Order ***********/

            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max')->from('tbl_salesorder')->get()->row_array();
            $next_number = $res['max'] + 1;
            $sales_code = 'SO-TDWD-' . $next_number;

            $headerArray["salesorder_code"] = $sales_code;
            $headerArray["vendor_id"] = $vendor_id;

            $this->db->insert('tbl_salesorder', $headerArray);

            $salesorder_id = $this->db->insert_id();

            if (empty($salesorder_id)) {
                $json['status'] = 0;
                $json['message'] = 'Sales Order not created for ' . $rowValue['order_id'];
                echo json_encode($json);
                exit;
            }

            for ($i = 0; $i < sizeof($rowArray); $i++) {

                $rowArray[$i]["salesorder_id"] = $salesorder_id;
            }

            $this->db->insert_batch('tbl_salesorder_item', $rowArray);

            $error = $this->db->error();

            if ($error['code'] != 0) {
                $json['status'] = 0;
                $json['message'] = 'Sales Order not created for ' . $rowValue['order_id'];
                echo json_encode($json);
                exit;
            }
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        $json['message'] = 'Sales Order created successfully';
        echo json_encode($json);
        exit;
    }
}
