<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Security_admin extends Admin_Controller
{

	public function __construct()
	{
		parent::__construct();
		/*load model*/
		$this->load->model('invoice_model');
		$this->load->library('hostbooks_authenticator');
	}

	public function manage_securityadmin($id = NULL, $activeId = NULL, $type = NULL) {
		if ($activeId == 10) {
			echo "Invalid Request";
			exit;
		}

		if (!empty($activeId)) {
			if (is_numeric($activeId)) {
				$data['active'] = $activeId;
			} else {
				$data['active'] = 1;
			}
		} else {
			$data['active'] = 1;
		}

		$data['title'] = "SECURITY ADMIN"; //Page title    

		$data['result'] = array();
		if ($activeId == 4 && (int) $id > 0) {

			$result = $this->invoice_model->getInvoiceSummary($id);
			$data['header_invoice'] = $result['header'];
			$data['count'] = $result['count'];
		} elseif ($activeId == 6 && $id > 0 && $type == 'normal') {

			// $result1=$this->db->where('invoice_id',$id)->get('INVOICE_EXPORT_REPORT_VIEW')->row();

			// if($result1->status == 'PACKED'){
			// 	$data['amount'] = $result1->total_amount + $result1->freight_amount + $result1->insurance_amount + $result1->tcs_amount - $result1->discount_amount;
			// 	$data["invoice_code"] = $result1->invoice_code;
			// 	$data['invoice_id']=$id;
			// 	$data['active']=6;
			// }

			$result1 = $this->Common_model->getRowResult('invoice_code,status', 'tbl_invoice', array('invoice_id' => $id));
			$result2 = $this->invoice_model->getInvoiceAmount($id);
			if (!empty($result2) && $result1['status'] == 'PACKED') {
				$data['amount'] = $result2->amount;
				$data["invoice_code"] = $result1['invoice_code'];
				$data['invoice_id'] = $id;
				$data['active'] = 6;
			}
		} elseif ((int) $id > 0) {
			$data['result'] = $this->Common_model->getRowResult('*', 'tbl_security_admin', array('admin_id' => $id));
			$data['active'] = 2;
		}

		$data['type'] = $type;

		if ($type == 'normal') {
			$data['addAction'] = 'createSecurityEnd';
		} else {
			$data['addAction'] = 'createSecurityAdminEnd';
		}

		$data['security_admin'] = $this->Common_model->getResultOrderBy('*', 'tbl_security_admin', array(), 'admin_id', 'DESC');
		$data['supplier_name'] = $this->Common_model->getAllResult('*', 'tbl_vendor', array('used_type' => 'supplier'));
		$data['subview'] = $this->load->view('admin/security_admin/manage_security_admin', $data, TRUE);
		$this->load->view('admin/_layout_main', $data); //page load
	}

	public function createSecurityEnd()
	{
		$data = array(
			'supplier_id' => $this->input->post('supplier_id'),
			'invoice_no' => $this->input->post('invoice_no'),
			'invoice_date' => date('Y-m-d', strtotime($this->input->post('invoice_date'))),
			'invoice_qty' => $this->input->post('invoice_qty'),
			'invoice_value' => $this->input->post('invoice_value'),
			'no_package' => $this->input->post('no_package'),
			'docket_no' => $this->input->post('docket_no'),
			'logistics_provider' => $this->input->post('logistics_provider'),
			'taxable_value' => $this->input->post('taxable_value'),
			'exempt_value' => $this->input->post('exempt_value'),
			'tax_amount' => $this->input->post('tax_amount'),
			'tcs' => $this->input->post('tcs'),
			'status' => 'NEW',
		);

		$id = $this->Common_model->insertData('tbl_security_admin', $data);

		//get gate pass unique no

		$this->Common_model->updateData('admin_id', $id, 'tbl_security_admin', array('gatepass_uniqueno' => 'S' . date('my') . 'INGP' . str_pad($id, 4, "0", STR_PAD_LEFT)));

		$this->session->set_userdata('success', 'SECURITY INSERTED SUCCESSFULLY');

		header("location:" . base_url() . 'admin/security');
		die;
	}

	public function createSecurityAdminEnd()
	{
		$admin_id = $this->input->post('admin_id');

		if ($admin_id > 0) {
			$status = $this->db->where('admin_id', $admin_id)->get('tbl_security_admin')->row()->status;
			if ($status != 'NEW') {
				$this->session->set_userdata('error', 'Invoice Status is not NEW');
				header("location:" . base_url() . 'admin/security');
				die;
			}
		}

		if (isset($_POST['package_no']) && isset($_POST['package_qty']) && (count($_POST['package_no']) == count($_POST['package_qty'])) && (count($_POST['package_remark']) == count($_POST['package_remark']))) {
			$short_devices = '0';
			$extra_devices = '0';

			$totalFillPackageQty = array_sum($this->input->post('package_qty'));

			if ((int) $this->input->post('invoice_qty') >= $totalFillPackageQty) {
				$short_devices = (int) $this->input->post('invoice_qty') - $totalFillPackageQty;
			} else {
				$extra_devices = $totalFillPackageQty - (int) $this->input->post('invoice_qty');
			}

			$data = array(
				'supplier_id' => $this->input->post('supplier_id'),
				'invoice_no' => $this->input->post('invoice_no'),
				'invoice_date' => date('Y-m-d', strtotime($this->input->post('invoice_date'))),
				'invoice_qty' => $this->input->post('invoice_qty'),
				'invoice_value' => $this->input->post('invoice_value'),
				'taxable_value' => $this->input->post('taxable_value'),
				'exempt_value' => $this->input->post('exempt_value'),
				'tax_amount' => $this->input->post('tax_amount'),
				'no_package' => $this->input->post('no_package'),
				'package_no' => json_encode($this->input->post('package_no')),
				'package_qty' => json_encode($this->input->post('package_qty')),
				'package_remark' => json_encode($this->input->post('package_remark')),
				'short_devices' => $short_devices,
				'extra_devices' => $extra_devices,
				'docket_no' => ($this->input->post('docket_no')),
				'logistics_provider' => ($this->input->post('logistics_provider')),
				'status' => 'NEW',
			);

			if ($this->input->post('admin_id') > 0) {
				$data['status'] = 'PENDING';
				$this->Common_model->updateData('admin_id', $this->input->post('admin_id'), 'tbl_security_admin', $data);
				$this->session->set_userdata('success', 'SECURITY ADMIN UPDATED SUCCESSFULLY');
			} else {
				$id = $this->Common_model->insertData('tbl_security_admin', $data);

				//get gate pass unique no

				$this->Common_model->updateData('admin_id', $id, 'tbl_security_admin', array('gatepass_uniqueno' => 'S' . date('ym') . 'INGP' . str_pad($id, 4, "0", STR_PAD_LEFT)));

				$this->session->set_userdata('success', 'SECURITY ADMIN INSERTED SUCCESSFULLY');
			}
		} else {
			$this->session->set_userdata('error', 'SOMETHING WENT WRONG.PLEASE TRY AGAIN.');
		}

		header("location:" . base_url() . "admin/security-admin");
		die;
	}

	public function deleteSecurityAdmin($id)
	{
		$this->Common_model->deleteData('admin_id', $id, 'tbl_security_admin');
		$this->session->set_userdata('success', 'SECURITY ADMIN DELETED SUCCESSFULLY');
		header("location:" . base_url() . "admin/security-admin");
		die;
	}

	public function createPackedList()
	{
		$invoice_id = $this->input->post('invoice_id');
		$package_no = $this->input->post('package_no');
		$package_qty = $this->input->post('package_qty');
		$package_remark = $this->input->post('package_remark');

		//count no of rows
		$no_rows = $this->db->where('(box_number is null or box_number = 0)')
			->where('invoice_id', $invoice_id)->get('tbl_invoice_item')->num_rows();
		if ($no_rows > 0) {
			$data['status'] = 0;
			$data['message'] = 'Not All the devices are packed';
			echo json_encode($data);
			die;
		}

		if (!empty($package_no)) {
			foreach ($package_no as $index => $value) {
				$package[] = array(
					"package_no" => $package_no[$index],
					"quantity" => $package_qty[$index],
					"remark" => $package_remark[$index],
					"invoice_id" => $invoice_id,
					"user_id" => $this->session->userdata('user_id')
				);
			}

			if (!empty($package) && $invoice_id > 0) {
				$result = $this->invoice_model->createPackedList($invoice_id, $package);
				if ($result) {
					$data["status"] = 1;
				} else {
					$data["status"] = 0;
				}
			} else {
				$data["status"] = 0;
			}

			echo json_encode($data);
			die;
		}
	}
	
    public function bulk_package_update() {
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = json_decode(file_get_contents(("php://input")), TRUE);
            
            $result = $this->invoice_model->bulk_package_update($data);

            echo json_encode($result);
            exit;
        }

        PREVIEW:

        $data['pageName'] = 'Bulk Package Update';
        $data['title'] = "Bulk Package Update"; //Page title 
        $data['subview'] = $this->load->view('admin/security_admin/bulk_package_update', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

	public function createShipping()
	{

		$invoice_id = $this->input->post('invoice_id');
		$delivery_mode = $this->input->post('delivery_method');
		$partner_id = $this->input->post('logistics_name');
		//$logistics_name = $this->input->post('logistics_name');
		$docket_number = $this->input->post('docket_number');
		$pickup_boy = $this->input->post('pickupboy_name');
		$employee_name = $this->input->post('employee_name');
		$transporter = $this->input->post('transporter');
		$eway_bill = $this->input->post("eway_bill");
		$gate_pass_no = $this->input->post("gate_pass_no");
		$id_type = $this->input->post('id_type');
		$id_no = $this->input->post('id_no');
		$eway_bill_date = date("Y-m-d", strtotime($this->input->post("eway_bill_date")));
		if ($eway_bill_date == '1970-01-01') {
			$eway_bill_date = '';
		}
        
		$max = $this->db->select('max(CAST(SUBSTRING_INDEX(gatepass_no,"-",-1) as UNSIGNED)) as max')->get('tbl_shipping_list')->row()->max;
		$next_number = $max + 1;
		$gatepass_no = 'GP-' . $next_number;

		$date = date("Y-m-d H:i:s");
		$user_id = $this->session->userdata('user_id');

		if ($invoice_id > 0 && $delivery_mode) {
			if ($delivery_mode == 'pickup') {
			    
			    $logistic_data = $this->db->where('partner_id', $partner_id)->get('tbl_logistic_partner')->row();
				$values = array(
					"invoice_id" => $invoice_id,
					"delivery_mode" => $delivery_mode,
					"CREATION_DATE" => $date,
					"logistics_partner_name" => $logistic_data->name,
					"tracking_url" => $logistic_data->url,
					"gate_pass_no" => $gate_pass_no,
					"docket_number" => $docket_number,
					"pickup_boy" => $pickup_boy,
					"user_id" => $user_id,
					"eway_bill" => $eway_bill,
					"id_type" => $id_type,
					"id_no" => $id_no,
					"gatepass_no" => $gatepass_no,
					"eway_bill_date" => $eway_bill_date
				);
			} elseif ($delivery_mode == 'drop-off') {
				$values = array(
					"invoice_id" => $invoice_id,
					"delivery_mode" => $delivery_mode,
					"CREATION_DATE" => $date,
					"employee_name" => $employee_name,
					"transporter" => $transporter,
					"gate_pass_no" => $gate_pass_no,
					"user_id" => $user_id,
					"eway_bill" => $eway_bill,
					"id_type" => $id_type,
					"id_no" => $id_no,
					"eway_bill_date" => $eway_bill_date,
					"gatepass_no" => $gatepass_no,
					"user_id" => $user_id
				);
			} elseif ($delivery_mode == 'byhand') {
				$values = array(
					"invoice_id" => $invoice_id,
					"delivery_mode" => $delivery_mode,
					"CREATION_DATE" => $date,
					"user_id" => $user_id,
					"gate_pass_no" => $gate_pass_no,
					"eway_bill" => $eway_bill,
					"id_type" => $id_type,
					"id_no" => $id_no,
					"eway_bill_date" => $eway_bill_date,
					"gatepass_no" => $gatepass_no,
					"user_id" => $user_id
				);
			}

			if (!empty($values)) {
				$this->load->model('invoice_model');
				$this->db->trans_start();
				$status = $this->invoice_model->createShipping($invoice_id, $values);
				if ($status) {
					$this->db->trans_complete();
					$data['status'] = 1;
					$this->hostbooks_authenticator->createInvoice($invoice_id);
				} else {
					$this->db->trans_rollback();
					$data['status'] = 0;
				}
			} else {
				$data['status'] = 0;
			}
		} else {
			$data['status'] = 0;
		}
		echo json_encode($data);
		die;
	}
	
    public function bulk_shipping() {
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = json_decode(file_get_contents(("php://input")), TRUE);
			// echo json_encode($data); exit;
			
			$crnt_date = date("Y-m-d H:i:s");
			$user_id = $this->session->userdata('user_id');

			$delivery_mode = $data['delivery_mode'];
			if ($delivery_mode != 'pickup') {
				$msg = 'Delivery Mode should be Pickup';
				GOTO ERROR;
			}

			$max_gpass_num = $this->db->select('max(CAST(SUBSTRING_INDEX(gatepass_no,"-",-1) as UNSIGNED)) as max')->get('tbl_shipping_list')->row()->max;

			$shipping_data = [];
			$inv_ids = [];

			foreach($data['csv_data'] as $arr) {
				$rs = $this->db->from('tbl_invoice')
				            ->where('invoice_code', $arr['invoice_code'])
							->select('invoice_id, invoice_amount, status')
							->get()->row();
				if (!isset($rs)) {
					$msg = 'Invalid Invoice Code - '. $arr['invoice_code'];
					GOTO ERROR;
				}
				if ($rs->status != 'PACKED') {
					$msg = 'Invoice '. $arr['invoice_code'] . ' not in PACKED status';
					GOTO ERROR;
				}

				$eway_bill = $arr['eway_bill'];
				$eway_bill_date = $arr['eway_bill_date'];

				if ((float) ($rs->invoice_amount) >= 50000  ||  ($eway_bill != 'NA' && strlen($eway_bill) > 0)) {
					if(!is_numeric($eway_bill) || strlen($eway_bill) != 12) {
						$msg = 'Invalid Eway Bill for Invoice Code - '. $arr['invoice_code'];
						GOTO ERROR;
					} else {
						$eway_bill_date = date("Y-m-d", strtotime( $eway_bill_date ));
						if ($eway_bill_date == '1970-01-01') {
							$eway_bill_date = null;
						}
					}
				} else {
					$eway_bill_date = null;
				}

				$gatepass_no = 'GP-' . (++$max_gpass_num);
				$lp_name = $arr['logistics_partner_name'];
				$lp_data = $this->db->get_where("tbl_logistic_partner", array("name" => $lp_name))->row();
				if (($lp_data) == 0 || count($lp_data) == 0) {
					$msg = $lp_name.' is not a erp listed logistic partner';
					GOTO ERROR;
				}
				$lp_url = $lp_data->url;
				$temp_arr = array(
					"invoice_id" => $rs->invoice_id,
					"delivery_mode" => $delivery_mode,
					"CREATION_DATE" => $crnt_date,
					"logistics_partner_name" => $arr['logistics_partner_name'],
					"tracking_url" => $lp_url,
					"docket_number" => $arr['docket_number'],
					"pickup_boy" => $arr['pickup_boy'],
					"user_id" => $user_id,
					"gatepass_no" => $gatepass_no,
					"eway_bill" => null,
					"eway_bill_date" => null,
				);

				if (!empty($eway_bill) && ($eway_bill != 'NA')) {
					$temp_arr['eway_bill'] = $eway_bill;
					$temp_arr['eway_bill_date'] = $eway_bill_date;
				}

				$shipping_data[] = $temp_arr;
				$inv_ids[] = $rs->invoice_id;
			}

			if (count($shipping_data) == 0 || count($inv_ids) == 0) {
				$msg = 'Please fill uploaded CSV file';
				GOTO ERROR;
			}

			$this->db->trans_start();

			$this->db->insert_batch('tbl_shipping_list', $shipping_data);
			if($this->db->error()['code'] != 0) { GOTO ERROR; }

			$this->db->where_in('invoice_id', $inv_ids)->update('tbl_invoice', array("status"=>'SHIPPED',"LAST_UPDATED_BY"=>$this->session->userdata('user_id')));
			if($this->db->error()['code'] != 0) { GOTO ERROR; }
			
			$this->db->trans_complete();

			
			foreach($inv_ids as $invoice_id) {
				$this->hostbooks_authenticator->createInvoice($invoice_id);
			}

			echo json_encode([
				"status" => true,
				'message' => count($shipping_data) . ' Invoices\'s are Shipped successfully'
			]);
            exit;

			ERROR:
			$this->db->trans_rollback();
			echo json_encode([
				'status' => false,
				'message' => isset($msg)? $msg : 'Unable to perform your request'
			]);
			exit;
        }

        PREVIEW:

        $data['pageName'] = 'Bulk Shipping';
        $data['title'] = "Bulk Shipping"; //Page title 
        $data['subview'] = $this->load->view('admin/security_admin/bulk_shipping', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

	public function updateSalesReturnForm($salesreturn_id)
	{

		$data['salesreturn_id'] = $salesreturn_id;
		$data['type'] = 'admin';
		$data['addAction'] = 'createSecurityAdminEnd';
		$data['title'] = "UPDATE SALES RETURN";
		$data["active"] = 10;
		$data['subview'] = $this->load->view('admin/security_admin/manage_security_admin', $data, TRUE);
		$this->load->view('admin/_layout_main', $data); //page load
	}

	public function getInvoiceDetails()
	{
		$awb_no = $this->input->get('awb_no');

		if (empty($awb_no)) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$result = $this->db->where('awb_no', $awb_no)->get('INVOICE_LIST_VIEW')->row();

		if (empty($result)) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json = array(
			"invoice_id" => $result->invoice_id,
			"salesorder_id" => $result->salesorder_id,
			"invoice_no" => $result->invoice_code,
			"invoice_qty" => $result->quantity,
			"saleschannel_ref_id" => $result->saleschannel_ref_id,
			"invoice_amount" => $result->amount + $result->tcs_amount,
			"invoice_status" => $result->status,
		);
		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function submitBulkPack()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if (empty($data) || empty($data['invoices'])) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$max = $this->db->select('max(CAST(SUBSTRING_INDEX(gatepass_no,"-",-1) as UNSIGNED)) as max')->get('tbl_shipping_list')->row()->max;
		$next_number = $max + 1;
		$gatepass_no = 'GP-' . $next_number;

		$eway_bill_date = date("Y-m-d", strtotime($this->input->post("eway_bill_date")));
		if ($eway_bill_date == '19070-01-01') {
			$eway_bill_date = '';
		}
		$partner_id = $data['logistics_name'];
		if((int)$partner_id > 0){
		    $logistic_data = $this->db->where('partner_id', $partner_id)->get('tbl_logistic_partner')->row();
		    $logistics_name = $logistic_data->name;
		    $tracking_url = $logistic_data->url;
		} else {
		    $logistics_name = $data['logistics_name'];
		    $tracking_url = NULL;
		}
		

		foreach ($data['invoices'] as $rowValue) {

			$packing_list[] = array(
				"invoice_id" => $rowValue['invoice_id'],
				"package_no" => $rowValue['no_pkg'],
				"quantity" => $rowValue['packed_qty'],
				"remark" => $rowValue['remark'],
				"user_id" => $this->session->userdata('user_id')
			);
			$shipping_list[] = array(
				"invoice_id" => $rowValue['invoice_id'],
				"delivery_mode" => $rowValue['delivery_mode'],
				"CREATION_DATE" => date("Y-m-d H:i:s"),
				"employee_name" => $data['employee_name'],
				"transporter" => $data['transporter'],
				"gatepass_no" => $gatepass_no,
				"user_id" => $this->session->userdata('user_id'),
				"logistics_partner_name" => $logistics_name,
				"tracking_url" => $tracking_url,
				"docket_number" => $rowValue['docket_number'],
				"pickup_boy" => $data['pickupboy_name'],
				"eway_bill_date" => $eway_bill_date
			);
			$invoice_list[] = array(
				"invoice_id" => $rowValue['invoice_id'],
				"status" => 'SHIPPED'
			);
		}

		$this->db->trans_start();

		$this->db->insert_batch('tbl_packinglist', $packing_list);
		$error = $this->db->error();

		if ($error['code'] != 0) {
			$this->db->trans_rollback();
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$this->db->insert_batch('tbl_shipping_list', $shipping_list);
		$error = $this->db->error();

		if ($error['code'] != 0) {
			$this->db->trans_rollback();
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$this->db->update_batch('tbl_invoice', $invoice_list, 'invoice_id');
		$error = $this->db->error();

		if ($error['code'] != 0) {
			$this->db->trans_rollback();
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$this->db->trans_complete();
		foreach ($invoice_list as $invoice) {
			$this->hostbooks_authenticator->createInvoice($invoice['invoice_id']);
		}
		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}
	public function gatepass_pdf($shipping_list_id = 0)
	{


		$download = $this->input->get('download');

		if ((int) $shipping_list_id <= 0) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$ship_details = $this->db->where('shipping_list_id', $shipping_list_id)->get('tbl_shipping_list')->row();

		$gatepass_no = $ship_details->gatepass_no;
		$invoice_id = $ship_details->invoice_id;
		$date = $ship_details->CREATION_DATE;

		if (empty($gatepass_no)) {

			$result = $this->db->where('shipping_list_id', $shipping_list_id)->get('INVOICE_GATEPASS_VIEW')->result_array();
		} else {
			$result = $this->db->where('gatepass_no', $gatepass_no)->get('INVOICE_GATEPASS_VIEW')->result_array();
		}

		if (empty($result)) {
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$invoice_nos = '';
		$quantity = 0;
		$package = 0;
		foreach ($result as $rowValue) {
			$invoice_nos .= $rowValue['invoice_code'];
			$invoice_nos .= ' | ';
			$quantity += $rowValue['quantity'];
			$package += $rowValue['package_no'];
			$sales_channel = $rowValue['sales_channel'];
			$vendor_name = $rowValue['vendor_name'];
			$eway_bill = $rowValue['eway_bill'];
		}

		$category = $this->db->select('category')->where('invoice_id', $invoice_id)->get('tbl_invoice_item')->row()->category;
		$data['invoice_code'] = $invoice_nos;
		$data['sales_channel'] = $sales_channel;
		$data['stock_type'] = $category;
		$data['gatepass_no'] = $gatepass_no;
		$data['quantity'] = $quantity;
		$data['package'] = $package;
		$data['ewaybill_no'] = $eway_bill;
		$data['vendor_name'] = $vendor_name;
		$data['date'] = date('d-m-Y', strtotime($date));

		$this->load->helper('dompdf');

		$viewfile = $this->load->view('admin/security_admin/gatepass_multi', $data, TRUE);

		pdf_picklist($viewfile, "gatepass#" . $shipping_list_id, TRUE, '', $download, '', '');
	}

	public function addBulkPurchaseInvoice()
	{
		$request = file_get_contents("php://input", true);
		$data = json_decode($request);
		$array = json_decode(json_encode($data), true);

		$this->db->trans_start();
		foreach ($array as $val) {
			$where = array(
				'vendor_code' => trim($val['supplier_code']),
				"used_type" => "supplier"
			);
			$supplier_id = $this->db->select('vendor_id')->where($where)->get('tbl_vendor')->row()->vendor_id;
			if (empty($supplier_id)) {
				$this->db->trans_rollback();
				$json['status'] = 2;
				$json['msg'] = 'Invalid Supplier Code- ' . $val['supplier_code'];
				echo json_encode($json);
				exit;
			}
			$invoice_date = date('Y-m-d', strtotime($val['invoice_date']));
			if ($invoice_date == '1970-01-01') {
				$this->db->trans_rollback();
				$json['status'] = 2;
				$json['msg'] = 'Invalid invoice date ' . $val['invoice_no'];
				echo json_encode($json);
				exit;
			}

			$tax_calculated = 0;
			$calculated_invoice_value = 0;
			$calculated_tcs = 0;;

			$tax_calculated = ($val['taxable_value'] * GST_018);;
			if ($tax_calculated + 5 >= $val['tax_amount'] && $tax_calculated - 5 <= $val['tax_amount']) {
			} else {
				$json['status'] = 2;
				$json['msg'] = 'Given Tax and Calculated Tax Amounts are not Matching for Invoice No. ' . $val['invoice_no'];
				echo json_encode($json);
				exit;
			}

			$calculated_invoice_value = ($val['taxable_value'] + $val['tax_amount'] + $val['exempt_value']);
			if ($calculated_invoice_value + 5 >= $val['invoice_value'] && $calculated_invoice_value - 5 <= $val['invoice_value']) {
			} else {
				$json['status'] = 2;
				$json['msg'] = 'Given Invoice Value and Calculated Invoice Amounts are not Matching for Invoice No. ' . $val['invoice_no'];
				echo json_encode($json);
				exit;
			}

			$calculated_tcs = $val['invoice_value'] * 0.1/100;
			if($val['tcs']>0){
				if ($calculated_tcs + 5 >= $val['tcs'] && $calculated_tcs - 5 <= $val['tcs']) {
				} else {
					$json['status'] = 2;
					$json['msg'] = 'Given TCS and Calculated TCS Amounts are not Matching for Invoice No. ' . $val['invoice_no'];
					echo json_encode($json);
					exit;
				}
			}

			$result = array(
				'supplier_id' => $supplier_id,
				'invoice_no' => $val['invoice_no'],
				'invoice_date' => date('Y-m-d', strtotime($val['invoice_date'])),
				'invoice_qty' => $val['invoice_qty'],
				'invoice_value' => $val['invoice_value'],
				'no_package' => $val['no_package'],
				'docket_no' => $val['docket_no'],
				'logistics_provider' => $val['logistics_provider'],
				'taxable_value' => $val['taxable_value'],
				'exempt_value' => $val['exempt_value'],
				'tax_amount' => $val['tax_amount'],
				'tcs' => $val['tcs'],
				'status' => 'NEW'
			);
			$this->db->insert('tbl_security_admin', $result);
			$id = $this->db->insert_id();
			$error = $this->db->error();

			if ($error['code'] != 0) {
				$this->db->trans_rollback();
				$json['status'] = 0;
				echo json_encode($json);
				exit;
			}
			$this->db->where('admin_id', $id)->update('tbl_security_admin', array('gatepass_uniqueno' => 'S' . date('my') . 'INGP' . str_pad($id, 4, "0", STR_PAD_LEFT)));
			$this->session->set_userdata('success', 'SECURITY INSERTED SUCCESSFULLY');
		}
		$this->db->trans_complete();
		$json['status'] = 1;
		echo json_encode($json);
		die;
	}

	public function getPurchaseInvoiceList()
	{
		$status = $this->input->get('status');

		if (empty($status)) {
			$json_arr = array(
				"data" => []
			);
			echo json_encode($json_arr);
			exit;
		}
		$data = [];
		$result = $this->db->where('status', $status)
			->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_security_admin.supplier_id')
			->get('tbl_security_admin')->result_array();

		foreach ($result as $key => $rowValue) {
			$data[] = array(
				"admin_id" => $rowValue['admin_id'],
				"supplier_code" => $rowValue['vendor_code'],
				"vendor_name" => $rowValue['company'],
				"invoice_no" => $rowValue['invoice_no'],
				"invoice_date" => date('d-m-Y', strtotime($rowValue['invoice_date'])),
				"invoice_qty" => $rowValue['invoice_qty'],
				"invoice_value" => $rowValue['invoice_value'],
				"no_package" => $rowValue['no_package'],
				"docket_no" => $rowValue['docket_no'],
				"logistics_provider" => $rowValue['logistics_provider'],
				"taxable_value" => $rowValue['taxable_value'],
				"exempt_value" => $rowValue['exempt_value'],
				"tax_amount" => $rowValue['tax_amount'],
				"tcs" => $rowValue['tcs'],
				"status" => $rowValue['status'],
				"created_date" => date('d-m-Y', strtotime($rowValue['created_date'])),
				"last_modified_date" => date('d-m-Y', strtotime($rowValue['last_modified_date'])),
				"net_amount" => round($rowValue['invoice_value'] + $rowValue['tcs'], 2),
				"short_devices" => $rowValue['short_devices'],
				"extra_devices" => $rowValue['extra_devices'],
				"entrypass_no" => $rowValue['gatepass_uniqueno'],
				"file_invoice" => $rowValue['file_invoice'],
				"file_gatepass" => $rowValue['file_gatepass'],
			);
		}

		$json_arr = array(
			"data" => $data
		);
		echo json_encode($json_arr);
		exit;
	}

	public function approveInvoice()
	{
		$json = array();
		$admin_id = $this->input->post('admin_id');
		$invoice_no = $this->db->select('invoice_no')->where('admin_id', $admin_id)->get('tbl_security_admin')->row()->invoice_no;
		$count = $this->db->select('count(grnreport_id) as count')->where('invoice_no', $invoice_no)->get('tbl_grnreport')->row()->count;
		if(empty($count)){
			$json['status'] = 0;
			$json['msg'] = 'Devices not Inwarded yet';
			echo json_encode($json);
			exit;
		}

		$this->db->where('admin_id', $admin_id)
			->update('tbl_security_admin', array('status' => 'APPROVED'));
		$error = $this->db->error();
		if ($error['code'] != 0) {
			$json['status'] = 0;
			$json['msg'] = 'Something went wrong';
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		$json['msg'] = 'Approved Successfully';
		echo json_encode($json);
		$this->hostbooks_authenticator->createPurchaseInvoice($admin_id);
		exit;
	}
	public function getLogisticPartners()
	{
		
		$result = $this->db->get('tbl_logistic_partner')->result();
		if(empty($result)){
			$json['status'] = 0;
			$json['data'] = array();
			echo json_encode($json);
			exit;
		}
		
		$json['status'] = 1;
		$json['data'] = $result;
		echo json_encode($json);
		exit;
	}
	
    public function purchase_invoice_fileuploads($admin_id) {
		$data['active'] = 10;
		
		$data['pageName'] = 'SECURITY ADMIN';
        $data['title'] = 'SECURITY ADMIN'; //Page title

		$rs = $this->db->where('admin_id', $admin_id)->get('tbl_security_admin')->row();
		if (empty($rs)) {
			echo 'Invalid Purchase Invoice';
			exit;
		}

		$data['admin_id'] = $admin_id;
		$data['purchase_inv'] = $rs;

        $data['subview'] = $this->load->view('admin/security_admin/manage_security_admin', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }
	
    public function upload_PurchaseInvoice_Files() {
		
		/** === Fetching Input Request Data === */
		
		$admin_id = $this->input->post('admin_id');

        $valid_extns_arr = ['pdf', 'xlsx'];
		$File_Paths_arr = null;

		$file_names_arr = [
			0 => 'purchase_inv',
			1 => 'purchase_gatepass'
		];
		$crnt_dt = date('YmdHis') . '_' . rand(11,99);
		
		$this->load->library('upload');

		foreach($file_names_arr as $k => $v) {

			$file_input_param = 'input_file__'. $v;

			if (!isset($_FILES[$file_input_param])) {
				$msg="No file selected. Please select a file";
				GOTO ERROR;
			}
			$file_extension = pathinfo($_FILES[$file_input_param]['name'], PATHINFO_EXTENSION);
			if (!in_array($file_extension, $valid_extns_arr)) {
				$msg="Allowed File formats are: ". implode(',', $valid_extns_arr);
				GOTO ERROR;
			}
			
			/** === Uploading the File to respective path === */
			$path_arr = ['file_uploads', 'purchase_invoice'];
			$Root_Path = '.'. DIRECTORY_SEPARATOR . 'assets';
			$Dir_Path_toSave = join(DIRECTORY_SEPARATOR, $path_arr);
			$upload_File_Path = $Root_Path . DIRECTORY_SEPARATOR . $Dir_Path_toSave;

			// echo $upload_File_Path; exit;
	
	
			$config['file_name'] = $v . '_' . $crnt_dt;
			$config['upload_path']   = $upload_File_Path;
			$config['allowed_types'] = $valid_extns_arr;
			$config['max_size']      = 8000;
			
			$this->upload->initialize($config);
			$upload_status = $this->upload->do_upload($file_input_param);
	
			if (!$upload_status) {
				$msg = $this->upload->display_errors('<p>', '</p>');
				GOTO ERROR;
			}
			$uploaded_data = $this->upload->data();
			
			$File_Paths_arr[$v] =  $Dir_Path_toSave . DIRECTORY_SEPARATOR . $uploaded_data['file_name'];
		}

		
		$upd_data = [];
        foreach($File_Paths_arr as $i => $v) {
			if (!isset($v)) {
				GOTO ERROR;
			}

			$col = '';
			if ($i == 'purchase_inv') {
				$col = 'file_invoice';
			} else if ($i == 'purchase_gatepass') {
				$col = 'file_gatepass';
			} else {
				$msg = 'File Type Error:'.$i;
				GOTO ERROR;
			}

			$upd_data[] = [
				'admin_id' => $admin_id,
				$col => $v,
			];
		}

		$this->db->trans_start();

		$upd_status = $this->db->update_batch('tbl_security_admin', $upd_data, 'admin_id');

		$this->db->trans_complete();

		// echo json_encode([
		// 	'status' => true,
		// 	'message' => 'Files uploaded Successfully',
		// ]);
		// exit;
		$type="success";
		$msg="Files uploaded Successfully";
		$this->session->set_userdata($type, $msg);  
		header("location:".$_SERVER['HTTP_REFERER']);
		exit;
        
		/** RESPONSE - ERROR */
		ERROR:
		$this->db->trans_rollback();
        foreach($File_Paths_arr as $i => $v) {
			if (isset($v)) {
				unlink($Root_Path . DIRECTORY_SEPARATOR . $v);
			}
		}

		$type="error";
		$message = isset($msg)? $msg : "Unable to perform your request";
		$this->session->set_userdata($type, $message);  
		header("location:".$_SERVER['HTTP_REFERER']);
		exit;

        // echo json_encode([
        //     'status' => false,
        //     'message' => isset($msg)? $msg : 'Something wrong'
        // ]);
		// exit;
    }
	public function getLPPaymentReferenceNo()
    	{
        $result = $this->db->select('lp.reference_id, lp.reference_no ')
		->from('tbl_salesorder AS so')
		->join('tbl_so_link_logistic_partner AS lp', 'lp.salesorder_id = so.salesorder_id')
		->join ('tbl_invoice AS in', 'in.salesorder_id = so.salesorder_id')
		->where(array('in.status' => "SHIPPED", 'lp.status' => "PENDING", 'lp.payment_by !=' => 'CUSTOMER'))->get()->result();
		//->where(array('in.status' => "SHIPPED"))->get()->result();
       //print_r($result); exit;
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
	    $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $json['data']= $result;
        echo json_encode($json);
        die;
    }
    public function getLPPaymentReferenceData()
    	{
		$reference_id = $this->input->get('reference_id');
        $result = $this->db->select('so.salesorder_code,in.invoice_code, lp.paid_amount, lp.logistic_name')
		->from('tbl_salesorder AS so')
		->join('tbl_so_link_logistic_partner AS lp', 'lp.salesorder_id = so.salesorder_id')
		->join ('tbl_invoice AS in', 'in.salesorder_id = so.salesorder_id')
		->where(array('lp.reference_id' => $reference_id))->get()->row();
       //print_r($result); exit;
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
	    $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $json['data']= $result;
        echo json_encode($json);
        die;
    }
	
    public function updateLpPayment()
    {

        $reference_id = $this->input->post('reference_id');
        $lp_invoice_no = $this->input->post('lp_invoice_no');
        $lp_invoice_amount = $this->input->post('lp_invoice_amount');
        $path = "uploads/lp_invoices/";
        $config['upload_path'] = "./uploads/lp_invoices";
        $config['allowed_types'] = 'gif|jpg|png';
        $this->load->library('upload', $config);
        $this->upload->do_upload("file_name");
        $data = array('upload_data' => $this->upload->data());
        if ($data['upload_data']['file_name'] == '') {
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            } else {
                $invoice_image = $path . $data['upload_data']['file_name'];
        }
		$update_status = array(
			'invoice_no' => $lp_invoice_no,
			'invoice_amount' => $lp_invoice_amount,
			'updated_by' => $this->session->userdata('user_id'),
			'invoice_image' => $invoice_image,
			'status ' => "APPROVED"   
        );
        $this->db->trans_start();
        $this->db->where('reference_id', $reference_id)->update('tbl_so_link_logistic_partner', $update_status);
        
        //$this->cliq_api->postTamperedDeviceInfo($deviceInfo);

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
}
