<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Searchbox extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		
		$this->load->model('Stamphistory_model');
		/*load model*/
    }

    public function manage_searchbox($id = NULL,$activeId=NULL)
    {   
		if (!empty($activeId)) {
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 2;
            }
        } else {
            $data['active'] = 1;
        }
		 
		$data['history_result']=array();
 
		if(isset($_GET['nhdin']))
		{ 
			 ;
			/*==GET RESULT FROM OLD STAMP HISTORY==*/
		
			$cond="nhdin = '".$_GET['nhdin']."' OR imei1_no = '".$_GET['nhdin']."'";
			
			$oldStampData=$this->db->where($cond)->get('tbl_oldstamphistory')->result_array();
			
			$newHistory=$this->Stamphistory_model->getRelatedNhdinHistory($_GET['nhdin']);
			
			$tempArr = array_unique(array_column(array_values(array_merge($oldStampData,$newHistory)), 'created_date'));
			
			$data['history_result']=(array_intersect_key(array_values(array_merge($oldStampData,$newHistory)), $tempArr));
 
		}
		 
        $data['title'] = lang('searchbox'); //Page title 
 
		$data['device_type'] = $this->db->order_by('name','ASC')->get('tbl_device_type')->result();
		 
		$data['bulkstatus'] = $this->db->order_by('bulkstatus_id')->get('tbl_bulkstatus')->result();
			
        $data['subview'] = $this->load->view('admin/searchbox/manage_searchbox', $data, TRUE);
  
		
        $this->load->view('admin/_layout_main', $data); //page load 
    }

	 
	public function create_order()
    {
		$data=$this->input->post();  
		 
		 if(!empty($data) && !empty($data['vendor_id']))
		 {
				$i=0;
				foreach($data['stock_type'] as $Key) 
				{ 
					$data=array(
						'location'=>$this->input->post('location'),
						'invoice_type'=>$this->input->post('invoice_type'),
						'vendor_id'=>$data['vendor_id'][$i],
						'source'=>$data['source_id'][$i],
						'nhmod'=>$data['nhmod'][$i],
						'imei1'=>$data['imei1'][$i],
						'imei2'=>$data['imei2'][$i],
						'unit_price'=>$data['unitprice'][$i],
						'tax'=>$data['taxvalue'][$i],
						'stock_type'=>$data['stock_type'][$i],
						'stock_subtype'=>$data['stock_sub_type'][$i],
						'invoice_no'=>$data['invoice_no'][$i],
						'invoice_date'=>date("Y-m-d", strtotime($data['invoice_date'][$i])),
						'tax_type'=>$data['tax_type'][$i],
					);
					$this->db->insert('tbl_bulkorder',$data);
					$i++;
				}
				 
				 /*===set message==*/ 
				 
				$type="success";
				
				$msg="ORDER ADDED SUCCESSFULLY.";  
		 }
		 else
		 {
					/*===set message==*/ 
				$type="error";
				
				$msg="SOMETHING WRONG.PLEASE TRY AGAIN.";  
		 }
		 
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']); 
	}
	
   	
	
	public function addTableRow()
	{  
	
		$stockValue=$_POST['stockType'];
		 
		 
		$trId=rand();
		$html='
			<tr id="'.$trId.'">
				<td><input class="form-control" required name="vendor_id[]" value="" type="text"></td>
				<td><input class="form-control" required name="source_id[]" value="" type="text"></td>
				<td><input class="form-control" required name="nhmod[]" value="" type="text"></td>
				<td><input class="form-control" required name="imei1[]" value="" type="text"></td>
				<td><input class="form-control" required name="imei2[]" value="" type="text"></td>
				<td><input class="form-control" required name="unitprice[]" value="" type="text"></td>
				<td><input class="form-control" required name="taxvalue[]" value="" type="text"></td>
				<td><input class="form-control stock_type" disabled required name="stock_type[]" value="'.$stockValue.'" type="text"></td>
				<td class="stockTypeHtml" ><input required    class="form-control" name="stock_sub_type[]" value="" type="text"></td>
				<td><input class="form-control" required name="invoice_no[]" value="" type="text"></td>
				<td><input class="form-control" placeholder="YYYY-mm-dd" required name="invoice_date[]" value="" type="text"></td>
				<td><input class="form-control" required name="tax_type[]" value="" type="text"></td>
				<td><a onclick="deleteRow('.$trId.')" class="dt-button buttons-print btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
			</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
	
	
	public function uploadOrderByExcel()
	{
			if (isset($_FILES["excel_file"])) 
			{ 
				$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
				
				if ($imageFileType!= "xlsx") 
				{ 
					$type="error";
				
					$msg="File is not valid format please try again."; 
				}
			 else 
			 {
					require_once 'assets/ExcelClasses/PHPExcel.php';
					if($_FILES['excel_file']['name']!="")
					{
							$ran_no=rand(1111,9999);
							$this->load->library('upload');
							$config['file_name']='excel_file'.$ran_no;
							$config['upload_path']   = './assets/upload/';
							$config['allowed_types'] = 'xlsx';
							$config['max_size']      = 8000;
							$this->load->library('image_lib', $config);
							$this->image_lib->resize();
							$this->upload->initialize($config); 
							$this->upload->do_upload('excel_file');
							$upload_data = $this->upload->data();
							$image_name = $upload_data['file_name'];
						}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
					$inputFileName =  './assets/upload/'.$image_name;
					include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
					$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
					$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
					$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
		 
					/*=check all date for stock type===*/
					$stockType=strtolower(preg_replace('/\s+/', '', $this->input->post('stock_type'))); 
					 
						$subTypeQty=1;
						for($i=2;$i<=$arrayCount;$i++)
						{
							$excelSubType=strtolower(preg_replace('/\s+/', '', trim($allDataInSheet[$i]["H"])));  
							if($stockType==$excelSubType)
							{
								$subTypeQty++;
							}
						} 
					
					/*==Upload all data in row wise form===*/ 
				 
					if($subTypeQty==$arrayCount)
					{
						
						for($i=2;$i<=$arrayCount;$i++)
							{ 
								$data=array(
									'location'=>$this->input->post('location'),
									'invoice_type'=>$this->input->post('invoice_type'),
									'vendor_id'=>trim($allDataInSheet[$i]["A"]),
									'source'=>trim($allDataInSheet[$i]["B"]),
									'nhmod'=>trim($allDataInSheet[$i]["C"]),
									'imei1'=>trim($allDataInSheet[$i]["D"]),
									'imei2'=>trim($allDataInSheet[$i]["E"]),
									'unit_price'=>trim($allDataInSheet[$i]["F"]),
									'tax'=>trim($allDataInSheet[$i]["G"]),
									'stock_type'=>trim($allDataInSheet[$i]["H"]),
									'stock_subtype'=>trim($allDataInSheet[$i]["I"]),
									'invoice_no'=>trim($allDataInSheet[$i]["J"]),
									'invoice_date'=>date("Y-m-d", strtotime(trim($allDataInSheet[$i]["K"]))),
									'tax_type'=>trim($allDataInSheet[$i]["L"]),
									'insert_by'=>'Excel',
								);
								$this->db->insert('tbl_bulkorder',$data);
							}
					
						unlink($inputFileName);		
						
						$type="success";
				
						$msg="Data Uploaded Successfully."; 
					}
					else
					{
						$type="error";
				
						$msg="Some Error in Your excel File.Please check."; 
					}
				}
		}
		 else 
		 {
			$type="error";
				
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN"; 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);
	}
}