<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class SalesOrder extends Admin_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('cliq_api');
        $this->load->model('SalesOrder_model');
    }
 
	function getSalesOrderApi()
	{ 
		$status=$this->input->get('status');
		$module_type = $this->input->get('module_type');
		
		if(empty($status)){
			$status='FINANCE_PENDING';
		}

		$totalCountResult=  $this->SalesOrder_model->get_salesorder_count($module_type);
		
		$salesOrderResult =  $this->SalesOrder_model->get_salesorder($module_type, $status);
 	    
		$totalFilteredValue=$totalCountResult['total'];
		
		
		$result['draw']=0;
		
		$result['recordsTotal']=$totalCountResult['total'];
		
		$result['recordsFiltered']=$totalFilteredValue;
 
		$data=array();

		if(!empty($salesOrderResult))
		{
			foreach($salesOrderResult as $salesOrder)
			{  
				$data[]=array(
					"salesorder_id"=>$salesOrder['salesorder_id'],
					"salesorder_code"=>$salesOrder['salesorder_code'],
                    "vendor_id"=>$salesOrder['vendor_name'],
                    "vendor_code"=>$salesOrder['vendor_code'],
                    "fullname"=>$salesOrder['fullname'],
					"status"=>$salesOrder['status'],
					"payment_mode"=>$salesOrder['payment_mode'],
					"warehouse"=>$salesOrder['warehouse'],
					"device_sub_category"=>$salesOrder['device_sub_category'],
					"sales_channel"=>$salesOrder['sales_channel'],
					"saleschannel_ref_id"=>$salesOrder['saleschannel_ref_id'],
                    "CREATION_DATE"=>date('d-m-Y', strtotime($salesOrder['CREATION_DATE'])),
                    "LAST_UPDATE_DATE"=>date('d-m-Y', strtotime($salesOrder['LAST_UPDATE_DATE'])),
                    "CREATED_BY"=>$salesOrder['CREATED_BY'],
					"LAST_UPDATED_BY"=>$salesOrder['LAST_UPDATED_BY'],
					"amount"=>$salesOrder['amount'],
					"discount_amount"=>$salesOrder['discount_amount'],
					"freight_amount"=>$salesOrder['freight_amount'],
					"insurance_amount"=>$salesOrder['insurance_amount'],
					"tcs_amount"=>$salesOrder['tcs_amount'],
					"net_invoice_amount"=>$salesOrder['net_invoice_amount'],
					"quantity"=>$salesOrder['quantity'],
                );
			}
		} 
		
		$result['data']=$data;
		
		echo json_encode($result);
 
		die;
	}
 
	function getVendorDetails(){
		
	}

	public function createSalesOrder(){
		$result=$this->input->post();
		$res=$this->SalesOrder_model->create_salesorder($result);
		if($res['code']=='0'){

			$data['message']="Sales Order Created Successfully";
			redirect("/admin/Rfs/manage_rfs?message=success");
		}
	}

	public function getSalesorderdets(){

		$salesOrderid=$this->input->get('salesorderid');
		$salesOrderResult =  $this->SalesOrder_model->get_salesorder_row($salesOrderid);
		$data=array();
		if(!empty($salesOrderResult))
		{
			foreach($salesOrderResult as $salesOrder)
			{  
				$data[]=array(
					$salesOrder['salesorder_id'],
					$salesOrder['salesorder_code'],
                    $salesOrder['vendor_name'] . '-' . $salesOrder['vendor_id'],
                    $salesOrder['fullname'],
                    $salesOrder['device_sub_category'],
					strtr($salesOrder['status'],'_',' '),
					$salesOrder['payment_mode'],
					$salesOrder['warehouse'],
					$salesOrder['sales_channel'],
					$salesOrder['saleschannel_ref_id'],
                    date('d-m-Y', strtotime($salesOrder['CREATION_DATE'])),
                    date('d-m-Y', strtotime($salesOrder['LAST_UPDATE_DATE'])),
                    $salesOrder['CREATED_BY'],
					$salesOrder['LAST_UPDATED_BY'],
					$salesOrder['vendor_id']
				);
			}
		} 
		
		$result['data']=$data;
		
		echo json_encode($result);
 
		die;
	}
	
	public function update_salesorder(){

		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		$status=$this->Common_model->getRowResult('status','tbl_salesorder',array("salesorder_id"=>$data['salesorder_id']));
		
		//Check Status of the Salaes Order
		if($status['status'] !='FINANCE_PENDING'){
			$json['status']=0;
			echo json_encode($json);
			die;
		}

		$result=$this->SalesOrder_model->update_salesorder($data);

		if($result=="approved"){

			$json['status']=1;
			$json['message']='approved';
			echo json_encode($json);
			die;

		}elseif($result=="rejected"){

			$json['status']=1;
			$json['message']='rejected';
			echo json_encode($json);
			die;

		}else{

			$json['status']=0;
			echo json_encode($json);
			die;
		}
	}

	public function getSalesOrderHeader(){
		$salesOrderid=$this->input->get('so_id');
		$salesOrderResult =  $this->SalesOrder_model->get_salesorder_row($salesOrderid);
		$data=array();
		if(!empty($salesOrderResult))
		{
			foreach($salesOrderResult as $salesOrder)
			{  
				$data=array(
					'salesorder_code'=>$salesOrder['salesorder_code'],
                    'vendor_name'=>$salesOrder['vendor_name'],
                    'vendor_id'=>$salesOrder['vendor_id'],
                    'fullname'=>$salesOrder['fullname'],
                    'salesman_id'=>$salesOrder['salesman_id'],
					'status'=>$salesOrder['status'],
					'payment_mode'=>$salesOrder['payment_mode'],
					'warehouse'=>$salesOrder['warehouse'],
					'sales_channel'=>$salesOrder['sales_channel'],
					'saleschannel_ref_id'=>$salesOrder['saleschannel_ref_id'],
                    'CREATED_BY'=>$salesOrder['CREATED_BY'],
					'LAST_UPDATED_BY'=>$salesOrder['LAST_UPDATED_BY']
				);
			}
		} 
		
		$result['data']=$data;
		
		echo json_encode($result);
 
		die;
	}

	public function editSalesOrder(){
		
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);

		if($data['salesorder_id']>0){

			$result=$this->SalesOrder_model->editSalesOrder($data);
		
		}else{
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		
		
		if($result==true){
			$json['status']=1;
			echo json_encode($json);
			die;
		}else{
			$json['status']=0;
			echo json_encode($json);
			die;
		}

	}

	public function CreateBulkSalesOrder(){

		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		$headerArray = array();
		$rowArray = array();
		$remarks='';
		$total_amount = 0;
		
		if( $data[0]['order_date'] == date('Y-m-d') || date('Y-m-d', strtotime($data[0]['order_date'])) == '1970-01-01'){
			$creation_date = date('Y-m-d H:i:s');
		}else{
			$creation_date = date('Y-m-d H:i:s', strtotime($data[0]['order_date']));
		}

		//status
		if($data[0]['status'] == 'DRAFT'){
			$status = 'DRAFT';
		}else{
			$status = 'FINANCE_PENDING';
		}
		if((int) $data[0]['tcs_amount'] <= 0){
			$tcs_amount = 0;
			$tcs_percent = 0;
		}else{
			$tcs_amount = $data[0]['tcs_amount'];
			$tcs_percent = $data[0]['tcs_percentage'];
		}
		$short_code = $data[0]['warehouse'];
		$warehouse = $this->db->select('city')->from('tbl_wh_loc')
			->where('short_code', $short_code)->get()->row()->city;
		$warehouse = strtoupper($warehouse);
		//print $tcs_amount;exit;
		$headerArray = array(
					"vendor_id"=> $data[0]['customer'],
					"salesman_code"=> $data[0]['seller'],
					"payment_mode"=>$data[0]['payment_mode'],
					"warehouse"=>$data[0]['warehouse'],
					"sales_channel"=>$data[0]['sales_channel'],
					"saleschannel_ref_id"=>$data[0]['sales_channel_id'],
					"device_sub_category"=>$data[0]['device_sub_category'],
					//"payment_method" => $data[0]['payment_method'],
					"tcs_amount" => $tcs_amount,
					"tcs_percent" => $tcs_percent,
					"status"=> $status,
					"CREATION_DATE"=>$creation_date,
					"CREATED_BY"=>$this->session->userdata('user_id')
				);
		$device_sub_category = $data[0]['device_sub_category'];
		$total_purchase_cost = 0;
		foreach ($data[0]['rows'] as $rowValue){
			$sales_channel = $data[0]['sales_channel'];
			$amount = bcmul($rowValue['quantity'],$rowValue['price'],2);
			
			 /* if($sales_channel == 'OFFLINE'){
				$availableQuantity = $this->db->select('nhdin')->where(array( 
											'SKU'=>$rowValue['sku'],
											'stock_type'=>$rowValue['category'],
											'certification_grade'=>$rowValue['grade'],
											'saletype' => 'OFFLINE',
											'status'=>'RFS',
											"device_sub_category" => $device_sub_category
										))->get('tbl_grnreport')->num_rows();
										
				$reservedQuantity = $this->db->select('sum(quantity) as quantity')->where(array( 
											'SKU'=>$rowValue['sku'],
											'stock_type'=>$rowValue['category'],
											'certification_grade'=>$rowValue['grade'],
											'sales_channel'=>'OFFLINE',
											"device_sub_category" => $device_sub_category

										))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;	
			}else{
				$availableQuantity = $this->db->select('nhdin')->where(array( 
											'SKU'=>$rowValue['sku'],
											'stock_type'=>$rowValue['category'],
											'certification_grade'=>$rowValue['grade'],
											'saletype' => 'ONLINE',
											'status'=>'RFS',
											"device_sub_category" => $device_sub_category
										))->get('tbl_grnreport')->num_rows();
										
				$reservedQuantity = $this->db->select('sum(quantity) as quantity')->where(array( 
											'SKU'=>$rowValue['sku'],
											'stock_type'=>$rowValue['category'],
											'certification_grade'=>$rowValue['grade'],
											'sales_channel != ' => 'OFFLINE',
											"device_sub_category" => $device_sub_category
										))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;	
			}*/
					
			/*if(!empty($reservedQuantity)){
				if($availableQuantity > $reservedQuantity){
					$netQuantity = $availableQuantity - $reservedQuantity;
				} else {
					$netQuantity = $reservedQuantity - $availableQuantity;
				}
			}else{
				$netQuantity = $availableQuantity;
			}*/	
			
			/*$netQuantity = $availableQuantity - $reservedQuantity;
						
			if($rowValue['quantity'] > $netQuantity ){
				$json['status'] = 0;
				$json['message'] = 'Order quantity greater than available quantity for '.$rowValue['sku'].'/'.$rowValue['grade'];				
				echo json_encode($json);
				die;
			}*/

			if((int)$rowValue['grnreport_id'] > 0){
				$status_arr = ["DRAFT", "FINANCE_PENDING", "FINANCE_APPROVED","INVOICED"];

				$this->db->select('tbl_salesorder.salesorder_code')->join('tbl_salesorder', 'tbl_salesorder.salesorder_id = tbl_salesorder_item.salesorder_id','Left');
				$old_so = $this->db->where('tbl_salesorder_item.grnreport_id', $rowValue['grnreport_id'])->where_in('tbl_salesorder.status', $status_arr)->get('tbl_salesorder_item')->row();
				if(!empty($old_so)){
					$json['status'] = 0;
					$json['message'] = 'Device '.$rowValue['nhdin_id']." Already present in ".$old_so->salesorder_code;				
					echo json_encode($json);
					die;
				}
				$device_dets = $this->db->select('saletype,unit_price, unit_price_tax, device_sub_category, bundle_id, status, warehouse')->where('grnreport_id', $rowValue['grnreport_id'])->get('tbl_grnreport')->row();
				if($sales_channel == 'OFFLINE'){
					if($device_dets->saletype != 'OFFLINE'){
						$json['status'] = 0;
						$json['message'] = 'Device '.$rowValue['nhdin_id']." Saletype Mismatched with Sales Channel";				
						echo json_encode($json);
						die;
					}
					if($device_dets->warehouse != $warehouse){
						$json['status'] = 0;
						$json['message'] = 'Device '.$rowValue['nhdin_id']." not a ". $warehouse. ' device';				
						echo json_encode($json);
						die;	
					}
					
				}else{
					if($device_dets->saletype != 'ONLINE'){
						$json['status'] = 0;
						$json['message'] = 'Device '.$rowValue['nhdin_id']." Saletype Mismatched with Sales Channel";				
						echo json_encode($json);
						die;
					}
				}

				if($device_dets->device_sub_category != $device_sub_category){
					$json['status'] = 0;
						$json['message'] = $rowValue['nhdin_id']." is not a ".$device_sub_category.' device';				
						echo json_encode($json);
						die;
				}

				if((int)$device_dets->bundle_id > 0){
					$json['status'] = 0;
					$json['message'] = $rowValue['nhdin_id']." is a Bundle device";				
					echo json_encode($json);
					die;
				}
				if($device_dets->status != "RFS"){
					$json['status'] = 0;
					$json['message'] = $rowValue['nhdin_id']." is not in RFS status";				
					echo json_encode($json);
					die;
				}
				$unit_price = $device_dets->unit_price;
				$unit_price_tax = $device_dets->unit_price_tax;
				$device_cost = $unit_price + $unit_price_tax;
				$total_purchase_cost += $device_cost;
			}
			
			$rowArray[]=array( 
				'sku'=>$rowValue['sku'],
				'grnreport_id'=>$rowValue['grnreport_id'],
				'device_name'=>$rowValue['device_name'],
				'category'=>$rowValue['category'],
				'grade'=>$rowValue['grade'],
				'sales_terms'=>$rowValue['sales_term'],
				'quantity'=>$rowValue['quantity'],
				'sale_price'=>$rowValue['price'],
				'amount'=>$amount,
			);
			$total_amount += $amount;
		}

		if($data[0]['discount'] > 0){
			$discount = $data[0]['discount'];
			
			if($data[0]['discount_type'] == 'amount'){
				$discount_amount = $discount;
			}else{
				$discount_amount = $discount*$total_amount/100;
			}
		}else{
			$discount_amount = 0;
		}

		if($data[0]['insurance_value'] > 0){
			$insurance_value = $data[0]['insurance_value'];
			
			if($data[0]['insurance_type'] == 'amount'){
				$insurance_amount = $insurance_value;
			}else{
				$insurance_amount = $insurance_value*$total_amount/100;
			}
		}else{
			$insurance_amount = 0;
		}

		$logisticArray['logistic_name'] = $data[0]['logistic_name'];
		$logisticArray['payment_by'] = $data[0]['payment_by'];
		$logisticArray['paid_amount'] = $data[0]['paid_amount'];

		$headerArray['discount_value'] = $data[0]['discount'];
		$headerArray['discount_type'] = $data[0]['discount_type'];
		$headerArray['discount_amount'] = $discount_amount;
		$headerArray['insurance_value'] = $data[0]['insurance_value'];
		$headerArray['insurance_type'] = $data[0]['insurance_type'];
		$headerArray['insurance_amount'] = $insurance_amount;
		$headerArray['freight_amount'] = $data[0]['freight_amount'];

		if(empty($headerArray) || empty($rowArray)){
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		if(!empty($data[0]['remarks_header'])){
			$remarks=$data[0]['remarks_header'];
		}
		
		$shipping_to_data = $data[0]['shipping_data'];
		$shipping_from_id = $data[0]['shipping_from_id'];
		$billing_from_id = $data[0]['billing_from_id'];
		
		$state_name = $this->db->get_where('tbl_states', array("state_id" => $shipping_to_data[0]['to_state']))->row()->name;
        $shipping_arr = array(
            "shipping_from_id"  => $shipping_from_id,
            "billing_from_id"   => $billing_from_id,
			"country"           => 'INDIA',
            "state"             => $state_name,
            "city"              => $shipping_to_data[0]['to_city'],
            "address"           => $shipping_to_data[0]['to_address'],
            "pincode"           => $shipping_to_data[0]['to_pincode'],
            );

		$result=$this->SalesOrder_model->insertBulkSalesOrder($headerArray,$rowArray,$remarks,$shipping_arr,$total_purchase_cost,[],$logisticArray);
        
		if (!($result)) {
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		
        $json['status']=1;
		echo json_encode($json);
		die;
	}
	/** Create SO for Export Devices */
	public function CreateBulkSalesOrderExport(){

		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		$headerArray = array();
		$rowArray = array();
		$device_ActvStatusUpdate_arr = [];
		$remarks='';
		$total_amount = 0;
		
		if( $data[0]['order_date'] == date('Y-m-d') || date('Y-m-d', strtotime($data[0]['order_date'])) == '1970-01-01'){
			$creation_date = date('Y-m-d H:i:s');
		}else{
			$creation_date = date('Y-m-d H:i:s', strtotime($data[0]['order_date']));
		}

		//status
		if($data[0]['status'] == 'DRAFT'){
			$status = 'DRAFT';
		}else{
			$status = 'FINANCE_PENDING';
		}
		if((int) $data[0]['tcs_amount'] <= 0){
			$tcs_amount = 0;
			$tcs_percent = 0;
		}else{
			$tcs_amount = $data[0]['tcs_amount'];
			$tcs_percent = $data[0]['tcs_percentage'];
		}
		//print $tcs_amount;exit;
		$headerArray = array(
					"vendor_id"=> $data[0]['customer'],
					"salesman_code"=> $data[0]['seller'],
					"payment_mode"=>$data[0]['payment_mode'],
					"warehouse"=>$data[0]['warehouse'],
					"sales_channel"=>$data[0]['sales_channel'],
					"saleschannel_ref_id"=>$data[0]['sales_channel_id'],
					"device_sub_category"=>$data[0]['device_sub_category'],
					//"payment_method" => $data[0]['payment_method'],
					"tcs_amount" => $tcs_amount,
					"tcs_percent" => $tcs_percent,
					"status"=> $status,
					"CREATION_DATE"=>$creation_date,
					"CREATED_BY"=>$this->session->userdata('user_id'),
					"module_type" => 2,   // As this function is separately for Export SalesOrder
					"export_currency_type" => $data[0]['export_currency_type'],
					"currencyExchangeRate_inRupee" => $data[0]['currencyExchangeRate_inRupee'],
					"terms_of_delivery" => $data[0]['terms_of_delivery'],
				);
		$device_sub_category = $data[0]['device_sub_category'];
		$total_purchase_cost = 0;
		foreach ($data[0]['rows'] as $rowValue) {
			
			$grnreport_id = $rowValue['grnreport_id'];
			
			$device_dets = $this->db->from('tbl_grnreport')
							->where('grnreport_id', $grnreport_id)
							->select('module_type, status, saletype,unit_price, unit_price_tax, device_sub_category, bundle_id')
							->get()->row();
						
			// if($device_dets->module_type != 2 ){
			// 	$json['status'] = 0;
			// 	$json['message'] = $rowValue['nhdin_id'].' device is not for Export Sale';				
			// 	echo json_encode($json);
			// 	die;
			// }
			// if($device_dets->saletype != 'EXPORT' ){
			// 	$json['status'] = 0;
			// 	$json['message'] = $rowValue['nhdin_id'].' device sale type is not "EXPORT"';				
			// 	echo json_encode($json);
			// 	die;
			// }
			if($device_dets->status != 'RFS' ){
				$json['status'] = 0;
				$json['message'] = $rowValue['nhdin_id'].' device status not in RFS';
				echo json_encode($json);
				die;
			}
			if($device_dets->device_sub_category != $device_sub_category){
				$json['status'] = 0;
				$json['message'] = $rowValue['nhdin_id']." is not a ".$device_sub_category.' device';				
				echo json_encode($json);
				die;
			}
			if((int)$device_dets->bundle_id > 0){
				$json['status'] = 0;
				$json['message'] = $rowValue['nhdin_id']." is a Bundle device";				
				echo json_encode($json);
				die;
			}

			$status_arr = ["DRAFT", "FINANCE_PENDING", "FINANCE_APPROVED", "INVOICED"];
			$old_so = $this->db->from('tbl_salesorder_item AS soi')
			         ->join('tbl_salesorder AS so', 'so.salesorder_id = soi.salesorder_id','Left')
			         ->where('soi.grnreport_id', $rowValue['grnreport_id'])
					 ->where_in('so.status', $status_arr)
			         ->select('so.salesorder_code')
					 ->get()->row();

			if(!empty($old_so)){
				$json['status'] = 0;
				$json['message'] = 'Device '.$rowValue['nhdin_id']." Already sold under the SO ".$old_so->salesorder_code;				
				echo json_encode($json);
				die;
			}

			$amount = bcmul($rowValue['quantity'],$rowValue['price'],2);
			
			$unit_price = $device_dets->unit_price;
			$unit_price_tax = $device_dets->unit_price_tax;
			$device_cost = $unit_price + $unit_price_tax;
			$total_purchase_cost += $device_cost;

			$rowArray[]=array( 
				'sku'=>$rowValue['sku'],
				'grnreport_id'=>$rowValue['grnreport_id'],
				'device_name'=>$rowValue['device_name'],
				'category'=>$rowValue['category'],
				'grade'=>$rowValue['grade'],
				'sales_terms'=>$rowValue['sales_term'],
				'quantity'=>$rowValue['quantity'],
				'sale_price'=>$rowValue['price'],
				'amount'=>$amount,
			);
			$total_amount += $amount;

			if (!empty($rowValue['updating_device_cond'])) {
				$device_ActvStatusUpdate_arr[] = [
					'grnreport_id' => $rowValue['grnreport_id'],
					'device_condition' => $rowValue['updating_device_cond']
				];
			}
			
		}

		if($data[0]['discount'] > 0){
			$discount = $data[0]['discount'];
			
			if($data[0]['discount_type'] == 'amount'){
				$discount_amount = $discount;
			}else{
				$discount_amount = $discount*$total_amount/100;
			}
		}else{
			$discount_amount = 0;
		}

		if($data[0]['insurance_value'] > 0){
			$insurance_value = $data[0]['insurance_value'];
			
			if($data[0]['insurance_type'] == 'amount'){
				$insurance_amount = $insurance_value;
			}else{
				$insurance_amount = $insurance_value*$total_amount/100;
			}
		}else{
			$insurance_amount = 0;
		}

		$logisticArray = [];
		//$logisticArray['logistic_name'] = $data[0]['logistic_name'];
		//$logisticArray['payment_by'] = $data[0]['payment_by'];
		// $logisticArray['paid_amount'] = $data[0]['paid_amount'];

		$headerArray['discount_value'] = $data[0]['discount'];
		$headerArray['discount_type'] = $data[0]['discount_type'];
		$headerArray['discount_amount'] = $discount_amount;
		$headerArray['insurance_value'] = $data[0]['insurance_value'];
		$headerArray['insurance_type'] = $data[0]['insurance_type'];
		$headerArray['insurance_amount'] = $insurance_amount;
		$headerArray['freight_amount'] = $data[0]['freight_amount'];

		if(empty($headerArray) || empty($rowArray)){
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		if(!empty($data[0]['remarks_header'])){
			$remarks=$data[0]['remarks_header'];
		}
		
		$shipping_from_id = $data[0]['shipping_from_id'];
		$shipping_to_data = $data[0]['shipping_data'];
		$billing_from_id = $data[0]['billing_from_id'];
		
		$shipping_arr = array(
            "shipping_from_id"  => $shipping_from_id,
            "billing_from_id"   => $billing_from_id,
			"shipping_to_vendor" => $shipping_to_data[0]['to_vendor_id'],
			"country"           => $shipping_to_data[0]['to_country'],
            "state"             => $shipping_to_data[0]['to_state'],
            "city"              => $shipping_to_data[0]['to_city'],
            "address"           => $shipping_to_data[0]['to_address'],
            "pincode"           => $shipping_to_data[0]['to_pincode'],
            );

		$result=$this->SalesOrder_model->insertBulkSalesOrder($headerArray,$rowArray,$remarks,$shipping_arr,$total_purchase_cost, $device_ActvStatusUpdate_arr,$logisticArray);
        
		if (!($result)) {
			$json['status']=0;
			echo json_encode($json);
			die;
		}
		
        $json['status']=1;
		echo json_encode($json);
		die;
	}

	public function unapprove($salesOrderid){
		if($salesOrderid>0){
			$status=$this->db->select('status')->where('salesorder_id',$salesOrderid)->from('tbl_salesorder')->get()->row();
			if($status->status=='FINANCE_APPROVED'){
				$salesorder=array(
					'status'=>'FINANCE_PENDING',
					'LAST_UPDATED_BY'=>$this->session->userdata('user_id'),
					'LAST_UPDATE_DATE'=>date("Y-m-d H:i:s")
				);
				$this->db->set($salesorder);
				$this->db->where('salesorder_id',$salesOrderid);
				$this->db->update('tbl_salesorder');
				$error=$this->db->error();
				if($error['code']==0){
					$data['status']=1;
					$this->cliq_api->postSalesImage($salesOrderid);
				}else{
					$data['status']=0;
				}
			}
		}else{
			$data['status']=0;
		}
		echo json_encode($data);
		die;
	}

	public function cancel(){
		
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		$salesorder_id = $data[0]["salesorder_id"];

		if(empty($salesorder_id) || (int) $salesorder_id <=0){

			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
		$orderItems = $this->db->select('tbl_grnreport.unit_price,tbl_grnreport.unit_price_tax')->from('tbl_salesorder_item')
		                ->join('tbl_grnreport','tbl_grnreport.grnreport_id = tbl_salesorder_item.grnreport_id')
		                ->where('tbl_salesorder_item.salesorder_id',$salesorder_id)->get()->result();
		
		$total_purchase_cost = 0;
        foreach($orderItems as $value){
            $device_cost = $value->unit_price + $value->unit_price_tax;
            $total_purchase_cost += $device_cost;
        }
		$soObj = $this->db->select('status, sales_channel')->where('salesorder_id',$salesorder_id)->from('tbl_salesorder')->get()->row();
		$status = $soObj->status;

		if($status != 'FINANCE_PENDING' && $status != 'FINANCE_REJECTED' && $status != 'WAREHOUSE_REJECTED' && $status != 'DRAFT'){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$salesorder = array(
						'status'=>'CANCELED',
						'LAST_UPDATED_BY'=>$this->session->userdata('user_id'),
						'LAST_UPDATE_DATE'=>date("Y-m-d H:i:s")
					);
		
		$this->db->trans_start();
		$this->db->set($salesorder);
		$this->db->where('salesorder_id',$salesorder_id);
		$this->db->update('tbl_salesorder');
		$error=$this->db->error();

		if($error['code'] != 0){
			$this->db->trans_rollback();
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		if($soObj->sales_channel == 'DEALERAPP'){
			$bundleIdsResult = $this->db->select('bundle_id')->where('order_id', $salesorder_id)->get('tbl_dealer_bundle')->result_array();

			$bundleIds = array_column($bundleIdsResult, 'bundle_id');

			if(!empty($bundleIds)){
				$this->db->where_in('bundle_id', $bundleIds);
				$this->db->update('tbl_dealer_bundle', array('status' => 'ACTIVE', 'order_id' => ''));

				$error = $this->db->error();
				if($error['code'] != 0){
					$this->db->trans_rollback();
					$json['status'] = 0;
					echo json_encode($json);
					exit;
				}
			}
		}

		$this->db->trans_complete();
		
		if(!empty($data[0]['remarks'])){
			$remark_array=array(
				'reference_id'=>$salesorder_id,
				'reference_type'=>'salesorder',
				'user_id'=>$this->session->userdata('user_id'),
				'remark'=>$data[0]['remarks'],
				"date"=>date("Y-m-d H:i:s")
			);
			$this->db->insert('tbl_remark',$remark_array);
			$error=$this->db->error();
		}
        
		$this->cliq_api->postSalesImage($salesorder_id);
		$this->cliq_api->postSalesMarginImage($salesorder_id, $total_purchase_cost);
        
		$json['status'] = 1;
		echo json_encode($json);
		die;
	}

	public function pickListPdf(){
		$salesOrderid = $this->input->get('salesorder_id');
		$grade_required = $this->input->get('grade'); 

		if($salesOrderid>0){
		$data=array();
		$this->db->select('salesorder_code,tbl_vendor.company as vendor_name,tbl_salesorder.CREATION_DATE');
		$this->db->from('tbl_salesorder');
		$this->db->join('tbl_vendor','tbl_vendor.vendor_id=tbl_salesorder.vendor_id','Left');
		$salesorder=$this->db->where('tbl_salesorder.salesorder_id',$salesOrderid)->get()->row();
		//	$data["cate"] = $salesorder->salesorder_code;
		//	$data["category"] = $salesorder->category;
			$data["salesorder_no"] = $salesorder->salesorder_code;
			$data["vendor_name"] = $salesorder->vendor_name;
			$data["date"] = date("d-m-Y", strtotime($salesorder->CREATION_DATE));
			$data["vendor_name"] = $salesorder->vendor_name;
			if($grade_required == 'no'){
				$data["grade_required"] = 'no';
			}
			else{
				$data["grade_required"] = 'yes';
			}
			$this->db->select('sku, grade, sum(quantity) as quantity, category')->where('salesorder_id', $salesOrderid);
			if($grade_required == 'no'){
				$result = $this->db->group_by('sku')->get('tbl_salesorder_item')->result_array();
			}else{
				$result = $this->db->group_by('sku,grade')->get('tbl_salesorder_item')->result_array();
			}
			if(!empty($result)){
				foreach($result as $value){
					$device_data = $this->db->select('product_brand,device_name,rom,ram,GROUP_CONCAT(distinct(bin_number)) as bin_number')->where('SKU', $value['sku'])->group_by('bin_number')->get('tbl_grnreport')->row();
					$rows[]=array(
						'device_name'=>$device_data->device_name,
						'quantity'=>$value["quantity"],
						'brand'=>$device_data->product_brand,
						'ram'=>$device_data->ram,
						'rom'=>$device_data->rom,
						'bin_number'=>$device_data->bin_number,
						'sku'=>$value["sku"],
						'grade'=>$value['grade'],
						'category'=>$value['category'],
					);
					$data['category'] = $value['category'];
				}
				$data["rows"] = $rows;
			}
		}

		$this->load->helper('dompdf');
		$viewfile = $this->load->view('admin/salesorder/picklist_pdf', $data, TRUE);
		//var_dump($data);exit;
		pdf_picklist($viewfile, "PickList");

	}

	public function warehouseReject()
	{
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request,true);
		$salesorderid = $data[0]["salesorder_id"];

		if($salesorderid>0){
			
			$status=$this->db->select('status')->where('salesorder_id',$salesorderid)->from('tbl_salesorder')->get()->row();
			if($status->status!='FINANCE_APPROVED'){
				$json['status']=0;
				echo json_encode($json);
				die;
			}
			$salesorder=array(
				'status'=>'WAREHOUSE_REJECTED',
				'LAST_UPDATED_BY'=>$this->session->userdata('user_id'),
				'LAST_UPDATE_DATE'=>date("Y-m-d H:i:s")
			);
			$this->db->set($salesorder);
			$this->db->where('salesorder_id',$salesorderid);
			$this->db->update('tbl_salesorder');
			$error=$this->db->error();
			
			if($error['code']!=0){
				
				$json['status']=0;
				echo json_encode($data);
				die;
			}

			if(!empty($data[0]['remarks'])){
				$remark_array=array(
					'reference_id'=>$salesorderid,
					'reference_type'=>'salesorder',
					'user_id'=>$this->session->userdata('user_id'),
					'remark'=>$data[0]['remarks'],
					"date"=>date("Y-m-d H:i:s")
				);
				$this->db->insert('tbl_remark',$remark_array);
				$error=$this->db->error();
			}

			$json['status']=1;
        
			$this->cliq_api->postSalesImage($salesorderid);

		}else{
			$json['status']=3;
		}
		echo json_encode($json);
		die;
	}

	public function uploadFiles($salesorder_id){

		if( (int) $salesorder_id <= 0){
			$json['status'] = 0;
			$json['error'] = "No Sales Order Selected";
			echo json_encode($json);
			die;
		}

		$awb_no = $this->input->post('awb_no');
		if(!empty($awb_no)){
			
			$awb_duplicate = $this->db->where('awb_no', $awb_no)->get('tbl_salesorder')->row();

			if(!empty($awb_duplicate)){
				
				$json['status'] = 0;
				$json['error'] = "Duplicate AWB No";
				echo json_encode($json);
				die;
			}
		}

		if (!is_dir('upload_so/'.$salesorder_id)) {
			mkdir('./upload_so/' . $salesorder_id, 0777, TRUE);
		
		}
		
		$config['upload_path'] = './upload_so/'.$salesorder_id.'/';
		$config['allowed_types'] = 'pdf';

		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('file'))
		{
				$error = $this->upload->display_errors();

				$json['status'] = 0;
				$json['error'] = $error;
				echo json_encode($json);
				die;
		}
		if(!empty($awb_no)){
		
			$this->db->set('awb_no',$awb_no);
			$this->db->where('salesorder_id',$salesorder_id);
			$this->db->update('tbl_salesorder');
		}
				
		$json['status'] = 1;
		echo json_encode($json);
		die;
	}

	public function updateAwbNo($salesorder_id){
		
		$awb_no = $this->input->post('awb_no');

		if(empty($awb_no)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$awb_duplicate = $this->db->where('awb_no', $awb_no)->get('tbl_salesorder')->row();

		if(!empty($awb_duplicate)){
			$json['status'] = 2;
			echo json_encode($json);
			exit;
		}
	
		$this->db->set('awb_no',$awb_no);
		$this->db->where('salesorder_id',$salesorder_id);
		$result = $this->db->update('tbl_salesorder');
		
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			die;
		}
		
		$json['status'] = 1;
		echo json_encode($json);
		die;
	}
	public function getAwb_no(){

		$salesorder_id = $this->input->get('salesorder_id');

		if((int) $salesorder_id <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
		$result = $this->db->select('awb_no')->from('tbl_salesorder')->where('salesorder_id',$salesorder_id)->get()->row();
		$record = array();
		if(!empty($result)){           
            $record = array(
				
				"awb_no"=> $result->awb_no
			);
        }
        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }

	public function getSOFileslist(){

        $salesorder_id = $this->input->get('salesorder_id');

        if(empty($salesorder_id)){
            
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $files = scandir( "./upload_so/".$salesorder_id."/" );
        $file_names = array();
         
        foreach( $files as $file ){

            if($file != '.' && $file != '..'){

                $file_names[] = array(

                    "file_name" => $file
                );
            }
            
        }

        $json['status'] = 1;
        $json["directory"] = "upload_so/".$salesorder_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
	}
	
	public function getGradewiseStockforSKU(){
		
		$sku = $this->input->get('sku');
		$category = $this->input->get('category');
		$device_sub_category = $this->input->get('device_sub_category');

		if($category == '' || $sku == ''){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$sku_cat = array(
						"SKU" => $sku,
						"stock_type" => $category,
						"status" => "RFS",
						"device_sub_category" => $device_sub_category
					);
		
		$this->db->select("count(grnreport_id) as stock, certification_grade as grade, device_name, saletype");
		$stock_result = $this->db->where($sku_cat)->group_by('certification_grade, saletype')->get('tbl_grnreport')->result_array();
		$stock = array();
		
		foreach($stock_result as $value){
			if($value['saletype'] == 'ONLINE'){
				$online[$value['grade']] = $value['stock'];
			}
			if($value['saletype'] == 'OFFLINE'){
				$offline[$value['grade']] = $value['stock'];
			}
			$stock[$value["grade"]] += $value["stock"];
			$device_name = $value['device_name'];
		}
//var_dump($offline);
		$status =array("FINANCE_PENDING","FINANCE_REJECTED","FINANCE_APPROVED", "WAREHOUSE_REJECTED","DRAFT");

		$this->db->select("sum(quantity) as reserved_qty,grade, sales_channel")->where('sku', $sku)->where('category', $category)->group_by('grade, category')->from('tbl_salesorder_item');
		$this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id = tbl_salesorder_item.salesorder_id','Left');
		$reserved_result = $this->db->where_in("tbl_salesorder.status",$status)->where('device_sub_category', $device_sub_category)->get()->result_array();
		
		$reserved = array();
		foreach($reserved_result as $value){
			$reserved[$value["grade"]] += $value["reserved_qty"];
			
			if($value['sales_channel'] != 'OFFLINE'){
				$online_reserved[$value['grade']] = $value['reserved_qty'];
			}
			if($value['sales_channel'] == 'OFFLINE'){
				$offline_reserved[$value['grade']] = $value['reserved_qty'];
			}
		}
		foreach($stock as $grade => $stock_val){
			$online_available[$grade] = $online[$grade] - $online_reserved[$grade];
			if((int) $online_available[$grade] <= 0){
				$online_available[$grade] = 0;
			}
			$offline_available[$grade] = $offline[$grade] - $offline_reserved[$grade];
			if((int) $offline_available <= 0){
				$offline_available[$grade] = 0;
			}
		}
		$data['stock'] = $stock;
		$data['online_available'] = $online_available;
		$data['offline_available'] = $offline_available;

		$data['reserved'] = $reserved;
		$data['device_name'] = $device_name;
		$data["status"] = 1;
	
		echo json_encode($data);
		die;
	}

	function getSalesorderCharges(){
		$salesorder_id = $this->input->get('salesorder_id');

		if(empty($salesorder_id) || (int) $salesorder_id <= 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$result = $this->db->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

		$json = array(
						"status" => 1,
						"discount_type" => $result->discount_type,
						"discount_value" => $result->discount_value,
						"discount_amount" => $result->discount_amount,
						"insurance_type" => $result->insurance_type,
						"insurance_value" => $result->insurance_value,
						"insurance_amount" => $result->insurance_amount,
						"freight_amount" => $result->freight_amount,
						"tcs_amount" => $result->tcs_amount,
						"tcs_percent" => $result->tcs_percent,
						"sales_channel" => $result->sales_channel,
					);

		echo json_encode($json);
		exit;
	}

	function getCustomerTCSValue(){
		$vendor_id = $this->input->get('customer_id');

		if((int) $vendor_id <= 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$this->db->where('vendor_id', $vendor_id)->where('is_exempted', 'Y');
		$is_exempted = $this->db->select('is_exempted')->get('tbl_tcs_exemption_list')->row()->is_exempted;
		if($is_exempted == 'Y'){
			$tcs_value = 0;
			$tcs_perc = 0;
			$json['tcs_value'] = $tcs_value;
			$json['tcs_percentage'] = $tcs_perc;
			$json['status'] = 1;
			echo json_encode($json);
			exit;
		}

		$this->db->select('sum(amount) as amount, sum(discount_amount) as discount_amount, sum(freight_amount) as freight_amount,sum(insurance_amount) as insurance_amount,sum(tcs_amount) as tcs_amount, pan_card, aadhar_no, gst_no');
		$result = $this->db->where('vendor_id', $vendor_id)->group_by('vendor_id')->get('CUSTOMER_TCS_VALUE_VIEW')->row();
		if(empty($result)){
			$tcs_value = 0;
		}else{
			$tcs_value = $result->amount - $result->discount_amount + $result->freight_amount + $result->insurance_amount + $result->tcs_amount;
		}

		$customer_obj = $this->db->select('pan_card, aadhar_no, gst_no')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

		if(empty($customer_obj->pan_card) && empty($customer_obj->aadhar_no) && empty($customer_obj->gst_no)){

			$tcs_perc = $this->db->where_in('config_key', 'tcs_percentage_without_id')->get('tbl_config')->row()->value;
			
		}else{
			$tcs_perc = $this->db->where_in('config_key', 'tcs_percentage_with_id')->get('tbl_config')->row()->value;
		}
		$json['tcs_value'] = $tcs_value;
		$json['tcs_percentage'] = $tcs_perc;
		$json['status'] = 1;
		echo json_encode($json);
		exit;

	}

	public function addtoTCSExemptionList()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data['vendor_id'])){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$insert_arr = array(
			"vendor_id" => $data['vendor_id'],
			"is_exempted" => "Y",
			"created_by" => $this->session->userdata('user_id'),
		);
		$this->db->insert('tbl_tcs_exemption_list', $insert_arr);
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function updateTCSExemptionList()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data['vendor_id'])){
			$json['status'] = 7;
			echo json_encode($json);
			exit;
		}

		if($data['type'] == 'add'){
			$is_exempted = 'Y';
		}else{
			$is_exempted = 'N';
		}
	
		$update_arr = array(
			"vendor_id" => $data['vendor_id'],
			"is_exempted" => $is_exempted,
			"last_updated_by" => $this->session->userdata('user_id'),
		);
		$this->db->where('vendor_id', $data['vendor_id']);
		$this->db->update('tbl_tcs_exemption_list', $update_arr);
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}

	public function getTCSExemptionList()
	{
		$result = $this->db->order_by('tcs_exemption_list_id', 'DESC')->get('TCS_EXEMPTION_LIST')->result_array();
		$list = [];
		foreach($result as $rowValue){
			$list[] = array(
				"vendor_name" => $rowValue['vendor_name'],
				"vendor_code" => $rowValue['vendor_code'],
				"vendor_id" => $rowValue['vendor_id'],
				"created_by" => $rowValue['created_by'],
				"last_updated_by" => $rowValue['last_updated_by'],
				"last_update_date" => date("d-m-Y",strtotime($rowValue['last_update_date'])),
				"creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
				"is_exempted" => $rowValue['is_exempted'],
				"tcs_exemption_list_id" => $rowValue['tcs_exemption_list_id'],
			);
		}

		$json['data'] = $list;
		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}
	public function fetch_state()
    {
        $result = $this->db->group_by('state_id')->order_by('name', 'asc')->get_where('tbl_states')->result();
       //print_r($result); exit;
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function getCustomerDetails()
    {
        $customer_id = $this->input->get('customer_id');
        $result = $this->db->get_where('tbl_vendor', array("vendor_id" => $customer_id))->row();
        // $state_id = $result->state;
        //$state_name = $this->db->get_where('tbl_trg_city', array("state_id" => $state_id))->row()->state_name;
       //print_r($result); exit;
       
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $customer_data = array(
            "address" => $result->address,
            "city" => $result->city,
            "pincode" => $result->pincode,
            "state" => $result->state,
            "country" => $result->country,
            );
        
        $json = $customer_data;
        echo json_encode($json);
        die;
    }
    
    public function addShippingFrom()
	{
		$request = file_get_contents("php://input");
		$data = json_decode($request, TRUE);

		if(empty($data)){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}
		
        $state_name = $this->db->get_where('tbl_states', array("state_id" => $data['state']))->row()->name;
		$insert_arr = array(
			"seller" => $data['seller'],
			"address" => $data['address'],
			"city" => $data['city'],
			"state" => $state_name,
			"pincode" => $data['pincode']
		);
		$this->db->insert('tbl_shipping_from_address', $insert_arr);
		$error = $this->db->error();

		if($error['code'] != 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$json['status'] = 1;
		echo json_encode($json);
		exit;
	}
	
	public function getShippingFromList()
    {

        $data = array();
        $rs = $this->db->from('tbl_shipping_from_address')->order_by('shipping_from_id', 'ASC')->get()->result();
        
        $json['data'] = $rs;
        echo json_encode($json);
        exit;
    }
    
    public function shippingFromAddress()
    {
        $result = $this->db->order_by('shipping_from_id', 'asc')->get_where('tbl_shipping_from_address')->result();
       //print_r($result); exit;
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

    public function billingFromAddress()
    {
        $result = $this->db->where('warehouse', 'Sloyd')->get_where('tbl_wh_loc')->result();
       //print_r($result); exit;
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $json = $result;
        echo json_encode($json);
        die;
    }

	public function getLPSloydPayments()
    {
	$status = $this->input->get('status');
        $result = $this->db->select('in.invoice_code, so.salesorder_code, lp.* ')
		->from('tbl_salesorder AS so')
		->join('tbl_so_link_logistic_partner AS lp', 'lp.salesorder_id = so.salesorder_id')
		->join ('tbl_invoice AS in', 'in.salesorder_id = so.salesorder_id')
		->where('lp.status', $status)
		->where(array('in.status' => "SHIPPED", 'lp.payment_by !=' => 'CUSTOMER'))->get()->result();
       //print_r($result); exit;
        if (!empty($result) && count($result) == 0)
        {
            $json['status'] = 0;
	    $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $json['data']= $result;
        echo json_encode($json);
        die;
    }
	
    public function updatePayment()
    {

        $reference_no = $this->input->get('reference_no');
        $updated_amount = $this->input->get('updated_amount');

        if (empty($reference_no)) {
            $json['status'] = 0;
            $json['msg'] = "Reference No is required ";
            echo json_encode($json);
            die;
        }
        $this->db->where('reference_no', $reference_no)->update('tbl_so_link_logistic_partner', array("paid_amount" => $updated_amount));

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

	
}