<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Rfs extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		/*load model*/
    }

    public function manage_rfs($id = NULL,$activeId=NULL)
    {  
		if (!empty($activeId)) 
		{
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		
		$data['pageName'] = 'RFS';
 
		/*==date wise seach work==*/
		 
		$data['from']='';
		 
		$data['to']='';
		
		 $this->session->unset_userdata('rfsform_date');
			
		$this->session->unset_userdata('rfsto_date');
		
		if($this->input->post('submit')=='Search')
		{
			
			$data['from']=$this->input->post('from_date');
		 
			$data['to']=$this->input->post('to_date');
		 
		 
			 $from=date("Y-m-d", strtotime($data['from']));
			 
			 $to=date("Y-m-d", strtotime($data['to']));
			  
			$this->session->set_userdata('rfsform_date',$from);
			
			$this->session->set_userdata('rfsto_date',$to);
		
		} 
		
        $data['title'] = "RFS"; //Page title 
        $data['subview'] = $this->load->view('admin/rfs/manage_rfs', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }
 
	function getRfsReportApi()
	{ 
		$data=$_POST;
		
		$startValue=$data['start'];
		
		$length=$data['length']; 

		$searchValue=$data['search']['value'];
		
		$fromDate=$this->session->userdata('rfsform_date');
		
		$toDate=$this->session->userdata('rfsto_date');
		
		$dateCond="sale_id!='0'";
 	 
		 if($fromDate!='')
		 { 
			$dateCond.=" and date(created_date)>='".$fromDate."'";
		 }
		 
		 if($toDate!='')
		 { 
			$dateCond.=" and date(tcreated_date)<='".$toDate."'";
		 } 
		 
		$searchCond="sale_id!='0'";
		
		if($searchValue!='')
		{
			$searchCond="( device_category LIKE '%".$searchValue."%' OR device_cond LIKE '%".$searchValue."%' OR device_type LIKE '%".$searchValue."%' OR device_brand LIKE '%".$searchValue."%' OR company_code LIKE '%".$searchValue."%' OR warehouse LIKE '%".$searchValue."%' OR stock_type LIKE '%".$searchValue."%' OR stock_subtype LIKE '%".$searchValue."%' OR product_name LIKE '%".$searchValue."%' OR imei_no LIKE '%".$searchValue."%' OR imei2_no LIKE '%".$searchValue."%' OR nhdin LIKE '%".$searchValue."%' )";
		 }
		
		$totalRfsResult=$this->db->select('COUNT(sale_id) as total')->where('status','1')->get('tbl_readyforsale')->row_array();
		
		$rfs_report=$this->db->limit($length,$startValue)->where($searchCond)->where($dateCond)->where(array('status'=>'1'))->get('tbl_readyforsale')->result_array(); 
 	    
		if($searchValue!='' || $fromDate!='' || $toDate!='')
		{
			$totalFilteredResult=$this->db->select('COUNT(sale_id) as total')->where($searchCond)->where($dateCond)->where(array('status'=>'1'))->get('tbl_readyforsale')->row_array(); 
		 
			$totalFilteredValue=$totalFilteredResult['total'];
		}
		else
		{
			$totalFilteredValue=$totalRfsResult['total'];
		}
		
		$result['draw']=0;
		
		$result['recordsTotal']=$totalRfsResult['total'];
		
		$result['recordsFiltered']=$totalFilteredValue;
 
		$data=array();
		
		if(!empty($rfs_report))
		{
			foreach($rfs_report as $rfs_reportValue)
			{  
				$data[]=array(
					'',
					$rfs_reportValue['warehouse'],
					$rfs_reportValue['rfs_type'],
					$rfs_reportValue['stock_type'],
					$rfs_reportValue['stock_subtype'],
					$rfs_reportValue['tax_type'],
					$rfs_reportValue['supplier_name'],
					'',    
					$rfs_reportValue['company_code'], 
					$rfs_reportValue['device_type'], 
					$rfs_reportValue['device_brand'], 
					$rfs_reportValue['nhmod'],
					$rfs_reportValue['product_name'],
					$rfs_reportValue['nhdin'],
					$rfs_reportValue['imei_no'],
					$rfs_reportValue['imei2_no'], 
					$rfs_reportValue['product_id'], 
					$rfs_reportValue['qc_status'],
					$rfs_reportValue['color'],
					$rfs_reportValue['ram'],
					$rfs_reportValue['rom'],			 
					$rfs_reportValue['front_camera'],			 
					$rfs_reportValue['primary_camera'],			 
					$rfs_reportValue['display'],			 
					$rfs_reportValue['processor'],			 
					$rfs_reportValue['sim_type'],			 
					$rfs_reportValue['clock_speed'],			 
					$rfs_reportValue['os'],			 
					$rfs_reportValue['battery'],			 				    
					'',
					$rfs_reportValue['network_brand'],	
					$rfs_reportValue['network_type'],	
					$rfs_reportValue['ageing_id'],	
					$rfs_reportValue['device_cond'],	
					$rfs_reportValue['device_category'],	
					$rfs_reportValue['nhpp'],						
					'',
					'',
					'',
					'',
					$rfs_reportValue['fullqc_nhdpvalue'],	
					$rfs_reportValue['nhop_value'],	
					$rfs_reportValue['nhwp_value'],						 
					'',
					$rfs_reportValue['working_cond1'],	
					$rfs_reportValue['working_cond2'],	
					$rfs_reportValue['working_cond3'],	
					$rfs_reportValue['working_cond4'],	
					$rfs_reportValue['working_cond5'],	
					$rfs_reportValue['screen_cond1'],	
					$rfs_reportValue['screen_cond2'],	
					$rfs_reportValue['housing_cond1'],	
					$rfs_reportValue['housing_cond2'],	
					$rfs_reportValue['housing_cond3'],	
					$rfs_reportValue['housing_cond4'],	
					$rfs_reportValue['housing_cond5'], 			
					$rfs_reportValue['housing_cond6'], 			
					$rfs_reportValue['housing_cond7'], 			
					$rfs_reportValue['lotbuyingproduct_no'], 			
					$rfs_reportValue['lotbuyingproduct_qty'], 			
					$rfs_reportValue['productid_status'], 			
				);
			}
		} 
		
		$result['data']=$data;
		
		echo json_encode($result);
 
		die;
	}
	
	public function manage_nhdp()
	{
		$data['active']="1";
		
		$data['title'] = "UPDATE NHDP"; //Page title 
		
        $data['subview'] = $this->load->view('admin/rfs/manage_updatenhdp', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function addTableRow()
	{  
		$sNo=$_POST['sNo'];
 
		$html='
			<tr id="tableIdr'.$sNo.'">
				<td><input placeholder="NHDIN" class="form-control"  required name="nhdin[]" value="" type="text"></td>  
				<td><input placeholder="NHDP" class="form-control" required onkeypress="return isNumberKey(event)" name="nhdp[]" value="" type="text"></td>				 
				 <td><a onclick="deleteRow('.$sNo.')" class="dt-button btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
			</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
	
	public function updateNhdpEnd()
	{
		$error=0;
		
		// CHECK ERROR FROM READY FOR SALE
		
		if(!empty($_POST))
		{
			$result=$_POST;
 
			foreach($result['nhdin'] as $value)
			{
				$chkNhdin=$this->db->where(array('nhdin'=>$value,'status'=>'1'))->get('tbl_readyforsale')->row_array();
				
				if(empty($chkNhdin))
				{
					$error++;
				} 
			}			
		}
		 
		if($error=='0' && !empty($_POST))
		{
			$data=$_POST;
			
			if(!empty($data))
			{
				$i=0;
				
				foreach($data['nhdin'] as $value)
				{
					$updateValue=array(
						'fullqc_nhdpvalue'=>$data['nhdp'][$i],
					);
					
					$this->db->where(array('nhdin'=>$value,'status'=>'1'))->update('tbl_readyforsale',$updateValue); 
					
					$i++;
				}
				
				// UPDATE VALUE OF NHWP AND NHOP
				
				foreach($data['nhdin'] as $value1)
				{ 
					$this->Common_model->getNhwpNhopValue($value1); 
				}
				
				$this->session->set_userdata('success','NHDP UPDATE SUCCESSFULLY');	
			}
			else
			{
				$this->session->set_userdata('error','DATA NOT FOUND.PLEASE CHECK.');	
			} 				
		}
		else
		{ 
			$this->session->set_userdata('error','SOME ERROR FOUND.PLEASE TRY AGAIN'); 
		}
		
		redirect($_SERVER['HTTP_REFERER']);
	}
	
	function updateNhdpByExcel()
	{
		  
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
				
			    /*===check all error===*/
				  
			    $error=0; 
				   
				for($i=2;$i<=$arrayCount;$i++)
				{  
			
					/*==CHECK NHDIN FROM RFS==*/
					
					$chkNhdin=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_readyforsale')->row_array();
				
					if(empty($chkNhdin))
					{
						$error++;
					} 
					 
				} 
				
				/*===UPDATE NHDP===*/
				 
				if($error=='0')
				{
					for($c=2;$c<=$arrayCount;$c++)
					{  
						$updateValue=array(
							'fullqc_nhdpvalue'=>trim($allDataInSheet[$c]["B"]),
						);
						
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$c]["A"]),'status'=>'1'))->update('tbl_readyforsale',$updateValue);
						
						$i++;
					
					}
					 
					// UPDATE VALUE OF NHWP AND NHOP
					
					
					for($i=2;$i<=$arrayCount;$i++)
					{  
						
						$this->Common_model->getNhwpNhopValue(trim($allDataInSheet[$i]["A"]));
						
						$i++;
					
					}
					
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="FULL-QC NHDP UPDATE SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);   
	}
	
	public function manageEditProduct()
	{
		$data['active']="1";
		
		$data['title'] = "EDIT PRODUCT DETAILS"; //Page title 
		
        $data['subview'] = $this->load->view('admin/rfs/manage_editproductdetail', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function updateRfsProduct()
	{
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet

				/*===UPDATE NHDP===*/
				
				$error=0;
				
				for($e=2;$e<=$arrayCount;$e++)
				{ 
					$deviceCategory=trim($allDataInSheet[$e]["P"]);
					
					$deviceCondition=trim($allDataInSheet[$e]["O"]);
					 
					if($deviceCategory!='REFURBISHED' && $deviceCategory!='UNBOXED' && $deviceCategory!='CERTIFIED PRE-OWNED')
					{
						$error++;
					}
					
					if($deviceCondition!='LIKE NEW' && $deviceCondition!='VERY GOOD' && $deviceCondition!='FAIR')
					{
						$error++;
					}
					
					/*==Check Nhdin in rfs==*/
					
					$nhdinResult=$this->db->where('nhdin',trim($allDataInSheet[$e]["A"]))->get('tbl_readyforsale')->row_array();
					
					if(empty($nhdinResult))
					{
						$error++;
					}
				} 
					 
				if($error=='0')
				{
					for($i=2;$i<=$arrayCount;$i++)
					{  
						
						$nhdinResult=$this->db->select('nhmod')->where('nhdin',trim($allDataInSheet[$i]["A"]))->get('tbl_readyforsale')->row_array();
						
						$getNhdinResult['nhmod']=$nhdinResult['nhmod'];
						
						$productId='';$productIdStatus=0;
						
						if(!empty($getNhdinResult))
						{
							if($getNhdinResult['nhmod']!='' && trim($allDataInSheet[$i]["AC"])!='' && trim($allDataInSheet[$i]["B"])!='' && trim($allDataInSheet[$i]["C"])!='' && trim($allDataInSheet[$i]["P"])!='' && trim($allDataInSheet[$i]["O"])!='')
							{
								$productIdStatus=1;
							}
							
							$productId=$this->Common_model->createProductId($getNhdinResult['nhmod'],trim($allDataInSheet[$i]["AC"]),trim($allDataInSheet[$i]["B"]),trim($allDataInSheet[$i]["C"]),trim($allDataInSheet[$i]["P"]),trim($allDataInSheet[$i]["O"]));
							
						}
						
						$updateValue=array( 
							'ram'=>trim($allDataInSheet[$i]["B"]),
							'rom'=>trim($allDataInSheet[$i]["C"]),
							'front_camera'=>trim($allDataInSheet[$i]["D"]),
							'primary_camera'=>trim($allDataInSheet[$i]["E"]),
							'display'=>trim($allDataInSheet[$i]["F"]),
							'processor'=>trim($allDataInSheet[$i]["G"]),
							'sim_type'=>trim($allDataInSheet[$i]["H"]),
							'clock_speed'=>trim($allDataInSheet[$i]["I"]),
							'os'=>trim($allDataInSheet[$i]["J"]),
							'battery'=>trim($allDataInSheet[$i]["K"]),
							'weight'=>trim($allDataInSheet[$i]["L"]),
							'network_brand'=>trim($allDataInSheet[$i]["M"]),
							'network_type'=>trim($allDataInSheet[$i]["N"]),
							'device_cond'=>trim($allDataInSheet[$i]["O"]),
							'device_category'=>trim($allDataInSheet[$i]["P"]),
							'nhwp_value'=>trim($allDataInSheet[$i]["Q"]),
							'hotdeals_status'=>trim($allDataInSheet[$i]["R"]),
							'newarrivals_status'=>trim($allDataInSheet[$i]["S"]),
							'trending_status'=>trim($allDataInSheet[$i]["T"]),
							'bestselling4g_status'=>trim($allDataInSheet[$i]["U"]),
							'refurbshied_status'=>trim($allDataInSheet[$i]["V"]),
							'unboxed_status'=>trim($allDataInSheet[$i]["W"]),
							'laptop_status'=>trim($allDataInSheet[$i]["X"]),
							'macbook_status'=>trim($allDataInSheet[$i]["Y"]),
							'lotbuyingproduct_no'=>trim($allDataInSheet[$i]["AA"]),
							'lotbuyingproduct_qty'=>trim($allDataInSheet[$i]["AB"]),
							'productid_status'=>$productIdStatus,
							'product_id'=>$productId,
							'color'=>trim($allDataInSheet[$i]["AC"]),
						);
						
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"])))->update('tbl_readyforsale',$updateValue);
					}
			
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="PRODUCT UPDATE SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);   
	}
	
	public function updateRfsProductColor()
	{
		
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			 
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			  
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
			
				/*===UPDATE NHDP===*/
				
				$error=0;
				
				for($e=2;$e<=$arrayCount;$e++)
				{  
					if(trim($allDataInSheet[$e]["A"])=='' || trim($allDataInSheet[$e]["B"])=='' || trim($allDataInSheet[$e]["C"])=='')
					{
						$error++;
					}
					
					$chkColor=$this->db->where('color_name',trim($allDataInSheet[$e]["C"]))->get('tbl_devicecolor')->row_array();
					
					if(empty($chkColor))
					{
						$error++;
					}
				}
				 
				if($error=='0')
				{
					for($i=2;$i<=$arrayCount;$i++)
					{  
						
						$geRfsProductResult=$this->db->where(array('nhmod'=>trim($allDataInSheet[$i]["B"]),'nhdin'=>trim($allDataInSheet[$i]["A"])))->get('tbl_readyforsale')->row_array();
						
						$productId='';$productIdStatus=0;
						
						if(!empty($geRfsProductResult))
						{
	
							if(trim($allDataInSheet[$i]["B"])!='' && trim($allDataInSheet[$i]["C"])!='' && $geRfsProductResult['ram']!='' && $geRfsProductResult['rom']!='' && $geRfsProductResult['device_category']!='' && $geRfsProductResult['device_cond']!='')
							{
								$productIdStatus=1;
							}
								
							$productId=$this->Common_model->createProductId(trim($allDataInSheet[$i]["B"]),trim($allDataInSheet[$i]["C"]),$geRfsProductResult['ram'],$geRfsProductResult['rom'],$geRfsProductResult['device_category'],$geRfsProductResult['device_cond']);
						} 
						
						$updateValue=array(
							'color'=>trim($allDataInSheet[$i]["C"]),
							'productid_status'=>$productIdStatus,
							'product_id'=>$productId
						);
						
						$this->db->where(array('nhmod'=>trim($allDataInSheet[$i]["B"]),'nhdin'=>trim($allDataInSheet[$i]["A"])))->update('tbl_readyforsale',$updateValue);						 		 
					}
			
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="PRODUCT COLOR UPDATE SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);   
	}
}