<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class Rfs extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		/*load model*/
    }

    public function manage_rfs($id = NULL,$activeId=NULL)
    {
		if($this->session->userdata('department_id')==6){
			$salesorderid=$this->input->get('salesorderid');
			$message=$this->input->get('message');
			if($salesorderid>0){
				$activeId=4;
				$data['salesorderid']=$salesorderid;
			}
			if($message=='updated' || $message=='failed' || $message=='rejected'){
				$data['message']=$message;
			}
		}
		$departmentid=$this->session->userdata('department_id');
		if($departmentid==8 || $departmentid== 13 || $departmentid == 2 || $departmentid == 17){
			$input=$this->input->post();
			if($input['action']=='edit' && $input['so_id']>0){
				$activeId=5;
				$data['so_id']=$input['so_id'];
			}
		}
		if (!empty($activeId)) 
		{
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 2;
            }
        } else {
            $data['active'] = 2;
        }
		
		$data['pageName'] = 'RFS';

		/*==date wise seach work==*/
		 
		$data['from']='';
		 
		$data['to']='';
		
		 $this->session->unset_userdata('rfsform_date');
			
		$this->session->unset_userdata('rfsto_date');
		
		if($this->input->post('submit')=='Search')
		{
			
			$data['from']=$this->input->post('from_date');
		 
			$data['to']=$this->input->post('to_date');
		 
		 
			 $from=date("Y-m-d", strtotime($data['from']));
			 
			 $to=date("Y-m-d", strtotime($data['to']));
			  
			$this->session->set_userdata('rfsform_date',$from);
			
			$this->session->set_userdata('rfsto_date',$to);
		
		} 

		if($this->input->get('message')=='success'){
			$data['message']=$this->input->get('message');
			$data['active']=2;
		}
        $data['title'] = "RFS"; //Page title 
        $data['subview'] = $this->load->view('admin/rfs/manage_rfs', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

	public function manage_rfs_menu($active = 0)
	{
		
		if (!empty($active)) 
		{
            if (is_numeric($active)) {
                $data['active'] = $active; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		$data['pageName'] = 'RFS';

		/*==date wise seach work==*/
		 
		$data['from']='';
		 
		$data['to']='';
		
		 $this->session->unset_userdata('rfsform_date');
			
		$this->session->unset_userdata('rfsto_date');
		$data['title'] = "RFS"; //Page title 
        $data['subview'] = $this->load->view('admin/rfs_menu/manage_rfs_menu', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
	}
 
	function getRfsReportApi()
	{ 

		$category_type=$this->input->get('category_type');
		$saletype=$this->input->get('sale_type');
		
		if(empty($category_type)){
			$category_type='OPEN BOX';
		}
		if($saletype == 'OTHER'){
			$saletype_arr = array('ONLINE', 'OFFLINE');
			$rfs_report = $this->db->where('stock_type', $category_type)->where_not_in('saletype', $saletype_arr)->get('RFS_VIEW')->result_array();
		}else{
			$rfs_report = $this->Common_model->getRfsView($category_type,$saletype);
		}

		//Check Rows exists or not
		if(empty($rfs_report)){
			$result['data']=array();
			echo json_encode($result);
			die;
		}

		$Reserved_View = $this->db->from('SALESORDER_RESERVED_VIEW')
						->select('SKU, stock_type, certification_grade, sales_channel, sum(quantity) as quantity')
						->group_by('SKU, stock_type, certification_grade, sales_channel')
						->get()->result_array();		
		
		foreach($rfs_report as $rfs_reportValue)
		{  		
			$reservedQuantity = 0;

                        $where_cond = [
				'SKU' => $rfs_reportValue['SKU'],
				'stock_type' => $rfs_reportValue['stock_type'],
				'certification_grade' => $rfs_reportValue['grade'],
				// 'sales_channel' => $rfs_reportValue['saletype']
			];

			foreach($Reserved_View as $obj) {
					
				$isValid = true;
				foreach($where_cond as $k => $v) {
					if ($obj[$k] != $v) {
						$isValid = false;
						break;
					}
				}
				if (!$isValid) {
					continue;
				}
				
				if($rfs_reportValue['saletype'] == 'OFFLINE') {
					if ($obj['sales_channel'] == 'OFFLINE') {
						$reservedQuantity += (int) $obj['quantity'];
					}
				} else {
					if ($obj['sales_channel'] != 'OFFLINE') {
						$reservedQuantity += (int) $obj['quantity'];
					}
				}
			}
			
			$data[]=array(
				"device_name"=>$rfs_reportValue['device_name'],
				"category"=>$rfs_reportValue['stock_type'],
				"sku"=>$rfs_reportValue['SKU'],
				"grade"=>$rfs_reportValue['grade'],
				"stock"=>$rfs_reportValue["quantity"],
				"reserved_stock"=>$reservedQuantity,
				"available_stock"=>$rfs_reportValue["quantity"] - $reservedQuantity,
				//"available_stock"=> '-',
			);
		}
		
		
		$result['data']=$data;
		
		echo json_encode($result);
 
		die;
	}
	
	public function manage_nhdp()
	{
		$data['active']="1";
		
		$data['title'] = "UPDATE NHDP"; //Page title 
		
        $data['subview'] = $this->load->view('admin/rfs/manage_updatenhdp', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function addTableRow()
	{  
		$sNo=$_POST['sNo'];
 
		$html='
			<tr id="tableIdr'.$sNo.'">
				<td><input placeholder="NHDIN" class="form-control"  required name="nhdin[]" value="" type="text"></td>  
				<td><input placeholder="NHDP" class="form-control" required onkeypress="return isNumberKey(event)" name="nhdp[]" value="" type="text"></td>				 
				 <td><a onclick="deleteRow('.$sNo.')" class="dt-button btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
			</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
	
	public function updateNhdpEnd()
	{
		$error=0;
		
		// CHECK ERROR FROM READY FOR SALE
		
		if(!empty($_POST))
		{
			$result=$_POST;
 
			foreach($result['nhdin'] as $value)
			{
				$chkNhdin=$this->db->where(array('nhdin'=>$value,'status'=>'1'))->get('tbl_readyforsale')->row_array();
				
				if(empty($chkNhdin))
				{
					$error++;
				} 
			}			
		}
		 
		if($error=='0' && !empty($_POST))
		{
			$data=$_POST;
			
			if(!empty($data))
			{
				$i=0;
				
				foreach($data['nhdin'] as $value)
				{
					$updateValue=array(
						'fullqc_nhdpvalue'=>$data['nhdp'][$i],
					);
					
					$this->db->where(array('nhdin'=>$value,'status'=>'1'))->update('tbl_readyforsale',$updateValue); 
					
					$i++;
				}
				
				// UPDATE VALUE OF NHWP AND NHOP
				
				foreach($data['nhdin'] as $value1)
				{ 
					$this->Common_model->getNhwpNhopValue($value1); 
				}
				
				$this->session->set_userdata('success','NHDP UPDATE SUCCESSFULLY');	
			}
			else
			{
				$this->session->set_userdata('error','DATA NOT FOUND.PLEASE CHECK.');	
			} 				
		}
		else
		{ 
			$this->session->set_userdata('error','SOME ERROR FOUND.PLEASE TRY AGAIN'); 
		}
		
		redirect($_SERVER['HTTP_REFERER']);
	}
	
	function updateNhdpByExcel()
	{
		  
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
				
			    /*===check all error===*/
				  
			    $error=0; 
				   
				for($i=2;$i<=$arrayCount;$i++)
				{  
			
					/*==CHECK NHDIN FROM RFS==*/
					
					$chkNhdin=$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"]),'status'=>'1'))->get('tbl_readyforsale')->row_array();
				
					if(empty($chkNhdin))
					{
						$error++;
					} 
					 
				} 
				
				/*===UPDATE NHDP===*/
				 
				if($error=='0')
				{
					for($c=2;$c<=$arrayCount;$c++)
					{  
						$updateValue=array(
							'fullqc_nhdpvalue'=>trim($allDataInSheet[$c]["B"]),
						);
						
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$c]["A"]),'status'=>'1'))->update('tbl_readyforsale',$updateValue);
						
						$i++;
					
					}
					 
					// UPDATE VALUE OF NHWP AND NHOP
					
					
					for($i=2;$i<=$arrayCount;$i++)
					{  
						
						$this->Common_model->getNhwpNhopValue(trim($allDataInSheet[$i]["A"]));
						
						$i++;
					
					}
					
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="FULL-QC NHDP UPDATE SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);   
	}
	
	public function manageEditProduct()
	{
		$data['active']="1";
		
		$data['title'] = "EDIT PRODUCT DETAILS"; //Page title 
		
        $data['subview'] = $this->load->view('admin/rfs/manage_editproductdetail', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function updateRfsProduct()
	{
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet

				/*===UPDATE NHDP===*/
				
				$error=0;
				
				for($e=2;$e<=$arrayCount;$e++)
				{ 
					$deviceCategory=trim($allDataInSheet[$e]["P"]);
					
					$deviceCondition=trim($allDataInSheet[$e]["O"]);
					 
					if($deviceCategory!='REFURBISHED' && $deviceCategory!='UNBOXED' && $deviceCategory!='CERTIFIED PRE-OWNED')
					{
						$error++;
					}
					
					if($deviceCondition!='LIKE NEW' && $deviceCondition!='VERY GOOD' && $deviceCondition!='FAIR')
					{
						$error++;
					}
					
					/*==Check Nhdin in rfs==*/
					
					$nhdinResult=$this->db->where('nhdin',trim($allDataInSheet[$e]["A"]))->get('tbl_readyforsale')->row_array();
					
					if(empty($nhdinResult))
					{
						$error++;
					}
				} 
					 
				if($error=='0')
				{
					for($i=2;$i<=$arrayCount;$i++)
					{  
						
						$nhdinResult=$this->db->select('nhmod')->where('nhdin',trim($allDataInSheet[$i]["A"]))->get('tbl_readyforsale')->row_array();
						
						$getNhdinResult['nhmod']=$nhdinResult['nhmod'];
						
						$productId='';$productIdStatus=0;
						
						if(!empty($getNhdinResult))
						{
							if($getNhdinResult['nhmod']!='' && trim($allDataInSheet[$i]["AC"])!='' && trim($allDataInSheet[$i]["B"])!='' && trim($allDataInSheet[$i]["C"])!='' && trim($allDataInSheet[$i]["P"])!='' && trim($allDataInSheet[$i]["O"])!='')
							{
								$productIdStatus=1;
							}
							
							$productId=$this->Common_model->createProductId($getNhdinResult['nhmod'],trim($allDataInSheet[$i]["AC"]),trim($allDataInSheet[$i]["B"]),trim($allDataInSheet[$i]["C"]),trim($allDataInSheet[$i]["P"]),trim($allDataInSheet[$i]["O"]));
							
						}
						
						$updateValue=array( 
							'ram'=>trim($allDataInSheet[$i]["B"]),
							'rom'=>trim($allDataInSheet[$i]["C"]),
							'front_camera'=>trim($allDataInSheet[$i]["D"]),
							'primary_camera'=>trim($allDataInSheet[$i]["E"]),
							'display'=>trim($allDataInSheet[$i]["F"]),
							'processor'=>trim($allDataInSheet[$i]["G"]),
							'sim_type'=>trim($allDataInSheet[$i]["H"]),
							'clock_speed'=>trim($allDataInSheet[$i]["I"]),
							'os'=>trim($allDataInSheet[$i]["J"]),
							'battery'=>trim($allDataInSheet[$i]["K"]),
							'weight'=>trim($allDataInSheet[$i]["L"]),
							'network_brand'=>trim($allDataInSheet[$i]["M"]),
							'network_type'=>trim($allDataInSheet[$i]["N"]),
							'device_cond'=>trim($allDataInSheet[$i]["O"]),
							'device_category'=>trim($allDataInSheet[$i]["P"]),
							'nhwp_value'=>trim($allDataInSheet[$i]["Q"]),
							'hotdeals_status'=>trim($allDataInSheet[$i]["R"]),
							'newarrivals_status'=>trim($allDataInSheet[$i]["S"]),
							'trending_status'=>trim($allDataInSheet[$i]["T"]),
							'bestselling4g_status'=>trim($allDataInSheet[$i]["U"]),
							'refurbshied_status'=>trim($allDataInSheet[$i]["V"]),
							'unboxed_status'=>trim($allDataInSheet[$i]["W"]),
							'laptop_status'=>trim($allDataInSheet[$i]["X"]),
							'macbook_status'=>trim($allDataInSheet[$i]["Y"]),
							'lotbuyingproduct_no'=>trim($allDataInSheet[$i]["AA"]),
							'lotbuyingproduct_qty'=>trim($allDataInSheet[$i]["AB"]),
							'productid_status'=>$productIdStatus,
							'product_id'=>$productId,
							'color'=>trim($allDataInSheet[$i]["AC"]),
						);
						
						$this->db->where(array('nhdin'=>trim($allDataInSheet[$i]["A"])))->update('tbl_readyforsale',$updateValue);
					}
			
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="PRODUCT UPDATE SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);   
	}
	
	public function updateRfsProductColor()
	{
		
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			 
			if ($imageFileType!= "xlsx")
			{ 
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN."; 
				 
			}
			else 
			{ 
			  
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
			
				/*===UPDATE NHDP===*/
				
				$error=0;
				
				for($e=2;$e<=$arrayCount;$e++)
				{  
					if(trim($allDataInSheet[$e]["A"])=='' || trim($allDataInSheet[$e]["B"])=='' || trim($allDataInSheet[$e]["C"])=='')
					{
						$error++;
					}
					
					$chkColor=$this->db->where('color_name',trim($allDataInSheet[$e]["C"]))->get('tbl_devicecolor')->row_array();
					
					if(empty($chkColor))
					{
						$error++;
					}
				}
				 
				if($error=='0')
				{
					for($i=2;$i<=$arrayCount;$i++)
					{  
						
						$geRfsProductResult=$this->db->where(array('nhmod'=>trim($allDataInSheet[$i]["B"]),'nhdin'=>trim($allDataInSheet[$i]["A"])))->get('tbl_readyforsale')->row_array();
						
						$productId='';$productIdStatus=0;
						
						if(!empty($geRfsProductResult))
						{
	
							if(trim($allDataInSheet[$i]["B"])!='' && trim($allDataInSheet[$i]["C"])!='' && $geRfsProductResult['ram']!='' && $geRfsProductResult['rom']!='' && $geRfsProductResult['device_category']!='' && $geRfsProductResult['device_cond']!='')
							{
								$productIdStatus=1;
							}
								
							$productId=$this->Common_model->createProductId(trim($allDataInSheet[$i]["B"]),trim($allDataInSheet[$i]["C"]),$geRfsProductResult['ram'],$geRfsProductResult['rom'],$geRfsProductResult['device_category'],$geRfsProductResult['device_cond']);
						} 
						
						$updateValue=array(
							'color'=>trim($allDataInSheet[$i]["C"]),
							'productid_status'=>$productIdStatus,
							'product_id'=>$productId
						);
						
						$this->db->where(array('nhmod'=>trim($allDataInSheet[$i]["B"]),'nhdin'=>trim($allDataInSheet[$i]["A"])))->update('tbl_readyforsale',$updateValue);						 		 
					}
			
					unlink($inputFileName);	
					
					$type="success";
				
					$msg="PRODUCT COLOR UPDATE SUCCESSFULLY.";  
					 
				}
				else
				{  
					$type="error";
				
					$msg="THERE IS SOME ERROR IN FILE"; 
				}
			}
		}
		else 
		{
			 		
			$type="error";
				
			$msg="NO FILE SELECTED."; 
						 
		}
		
		$this->session->set_userdata($type,$msg); 
		
		header("location:".$_SERVER['HTTP_REFERER']);   
	}

	public function bulkSalesorder(){
		/*==date wise seach work==*/
		$data['pageName'] = 'RFS';
		$data['from']='';
		 
		$data['to']='';
		
		 $this->session->unset_userdata('rfsform_date');
			
		$this->session->unset_userdata('rfsto_date');
		
		if($this->input->post('submit')=='Search')
		{
			
			$data['from']=$this->input->post('from_date');
		 
			$data['to']=$this->input->post('to_date');
		 
		 
			 $from=date("Y-m-d", strtotime($data['from']));
			 
			 $to=date("Y-m-d", strtotime($data['to']));
			  
			$this->session->set_userdata('rfsform_date',$from);
			
			$this->session->set_userdata('rfsto_date',$to);
		
		} 

		$data['active']=6;
        $data['title'] = "Bulk Sales Order"; //Page title 
        $data['subview'] = $this->load->view('admin/rfs/manage_rfs', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
	}

	public function downloadRfsExcel(){
		include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
		require_once('export_file_excel/Classes/PHPExcel.php');
		$objPHPExcel = new PHPExcel;
		// set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
		// set default font size
		$objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
		// create the writer
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		// currency format, € with < 0 being in red color
		$currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
		// number format, with thousands separator and two decimal points.
		$numberFormat = '#,#0.##;[Red]-#,#0.##';
		// writer already created the first sheet for us, let's get it
		$objSheet = $objPHPExcel->getActiveSheet();
		// rename the sheet
		$objSheet->setTitle('RFS List');
		
		// let's bold and size the header font and write the header
		// as you can see, we can specify a range of cells, like here: cells from A1 to A4
		$objSheet->getStyle('A1:M1')->getFont()->setBold(true)->setSize(12);

        // set Header
        // write header
		$objSheet->getCell('A1')->setValue('SKU');
		$objSheet->getCell('B1')->setValue('Model Id');
		$objSheet->getCell('C1')->setValue('Brand');
		$objSheet->getCell('D1')->setValue('Product Name');
		$objSheet->getCell('E1')->setValue('category');
		$objSheet->getCell('F1')->setValue('color');
		$objSheet->getCell('G1')->setValue('ram');
		$objSheet->getCell('H1')->setValue('rom');
		$objSheet->getCell('I1')->setValue('Available Quantity');
		$objSheet->getCell('J1')->setValue('Grade');
		$objSheet->getCell('K1')->setValue('Sales terms');
		$objSheet->getCell('L1')->setValue('Quantity');
		$objSheet->getCell('M1')->setValue('Price');

		$this->db->select(" nhmod, device_name,product_brand, ram, rom, tbl_grnreport.color,tbl_colorcode.color_code, certification_grade,  CASE WHEN stock_type ='PREXO' OR stock_type='BUY BACK' THEN 'PRE-OWNED' WHEN stock_type ='OPEN BOX' THEN 'OPEN BOX' ELSE '' END AS category,");
		$this->db->select('count(grnreport_id) as quantity');
		$this->db->from('tbl_grnreport');
		$this->db->join('tbl_colorcode','tbl_colorcode.color=tbl_grnreport.color','Left');
		$this->db->where('status','RFS');
		$this->db->group_by('nhmod,ram,rom,color,category,certification_grade');
		$rfs_report = $this->db->get()->result_array();
		if(!empty($rfs_report))
		{
			$status=array("FINANCE_PENDING","FINANCE_REJECTED","FINANCE_APPROVED");
			$rowCount = 2;
			foreach($rfs_report as $rfs_reportValue)
			{  
				$color =  $rfs_reportValue['color'];
				$ram =  $rfs_reportValue['ram'];
				$rom =$rfs_reportValue['rom'];
				$color_code =$rfs_reportValue['color_code'];
				$sku = "";
				$sku=$rfs_reportValue['nhmod'].'-'.$ram.'-'.$rom.'-'.$color_code;
				$variant=$ram.'-'.$rom.'-'.$rfs_reportValue["color"];

				$for_reserved=array(
					"color"=>$color,
					"ram"=>$ram,
					"rom"=>$rom,
					"model_id"=>$rfs_reportValue['nhmod'],
					"grade"=>$rfs_reportValue['certification_grade']
				);

				$this->db->select("sum(quantity) as reserved_qty")->where($for_reserved)->from('tbl_salesorder_item');
				$this->db->join('tbl_salesorder','tbl_salesorder.salesorder_id=tbl_salesorder_item.salesorder_id','Left');
				$query2= $this->db->where_in("tbl_salesorder.status",$status)->get();
				$reserved_result=$query2->row();

				
				$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $sku);
				$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rfs_reportValue['nhmod']);
				$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rfs_reportValue['product_brand']);
				$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $rfs_reportValue['device_name']);
				$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $rfs_reportValue['category']);
				$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $rfs_reportValue['color']);
				$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $rfs_reportValue['ram']);
				$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $rfs_reportValue['rom']);
				$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $rfs_reportValue['quantity']-$reserved_result->reserved_qty);
				$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $rfs_reportValue['certification_grade']);
				$rowCount++;
			}
		}

       
 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename="Rfs.xlsx"');
		$objWriter->save('php://output');
		die;
		// $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');		  
		// $objWriter->save('php://output');
	}
	
	public function uploadRfsDetails(){
	    $type=""; $msg=""; 
	    if (isset($_FILES["csv_file"])){ 
	      $file_name = $_FILES['csv_file']['name'];
		  $file_size =$_FILES['csv_file']['size'];
		  $file_tmp =$_FILES['csv_file']['tmp_name'];
		  $file_type=$_FILES['csv_file']['type'];
		  $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
		  
		  $extensions= array("csv");
		  
		  if(in_array($file_ext,$extensions)=== false){
			 $msg = "extension not allowed, please choose a CSV file.";
		  }
		  
		  if($file_size > 2097152){
			 $msg = 'File size must not exceed 2 MB';
		  }
		 
          if(empty($errors)==false){
			$type="error";
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN"; 
			$this->session->set_userdata($type,$msg);  
			header("location:".$_SERVER['HTTP_REFERER']); 
			die;
	      } 
		 
		  $handle = fopen($_FILES['csv_file']['tmp_name'], "r");
		  $first_line = true;
		  $rfsRecords = array();
		  while($col = fgetcsv($handle)){
			if($first_line == false){
				if($col[9] != 0){	
					$device_name = $col[0];
					$sku = $col[1];
					$stock_type=$col[2];
					$grade = $col[3];
					$quantity = $col[9];
					$sales_term = $col[7];	
					$price = $col[10];
					$rfsRecords[] = array(
					                  'device_name'=>$device_name,
					                  'sku' => $sku,
                                      'stock_type'=>$stock_type,
                                      'grade'=> $grade,
                                      'quantity'=>$quantity,
                                      'sales_term'=>$sales_term,
                                      'price'=>$price,  									  
									);
				}
		    }
		    $first_line = false;
		  } 
		
		  echo json_encode($rfsRecords); 
		  header("location:".$_SERVER['HTTP_REFERER']); 
		  die;
		}  
	}
	
	public function downloadRfsDetails(){
		$csv_output = "Brand,Product Name, SKU, Category, Grade, RAM, ROM,Available Stock, Sales Quantity,Sales Price";
	
		$stock_type = $_GET['stock_type'];
		$saletype = $_GET['sale_type'];
		
		$result;

		if($saletype == 'OTHER'){
			$saletype_arr = array( 'ONLINE', 'OFFLINE');
			if(!empty($stock_type)){
				$this->db->where('stock_type', $stock_type);
			}
			$result = $this->db->where_not_in('saletype', $saletype_arr)->get('RFS_VIEW')->result_array();
		}else{

			if(!empty($stock_type)){
				$result=$this->db->where(array('stock_type'=>$stock_type,'saletype'=>$saletype))->get('RFS_VIEW')->result_array();
			} else {
				$result=$this->db->where('saletype',$saletype)->get('RFS_VIEW')->result_array();
			}
		}
		
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				// $reservedQuantity = $this->db->select('quantity')->where(array( 
				// 							'SKU'=>$value['SKU'],
				// 							'stock_type'=>$value['stock_type'],
				// 							'certification_grade'=>$value['grade']
				// 						))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;

				if($value['saletype'] == 'OFFLINE'){
					$reservedQuantity = $this->db->select('sum(quantity) as quantity')->where(array( 
												'SKU'=>$value['SKU'],
												'stock_type'=>$value['stock_type'],
												'certification_grade'=>$value['grade'],
												'sales_channel'=>$value['saletype']
											))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;
				}elseif($value['saletype'] == 'ONLINE'){
					$reservedQuantity = $this->db->select('sum(quantity) as quantity')->where(array( 
												'SKU'=>$value['SKU'],
												'stock_type'=>$value['stock_type'],
												'certification_grade'=>$value['grade'],
												'sales_channel !=' => 'OFFLINE'
											))->get('SALESORDER_RESERVED_VIEW')->row()->quantity;
				}else{
					$reservedQuantity = 0;
				}
			
				$avblQty =  $value['quantity'] - $reservedQuantity ;
				if($avblQty>0){
					$csv_output .= $value['brand'].",";
					$csv_output .= $value['device_name'].",";
					$csv_output .= $value['SKU'].",";
					$csv_output .= $value['stock_type'].",";
					$csv_output .= $value['grade'].",";
					$csv_output .= $value['ram'].",";
					$csv_output .= $value['rom'].",";
					$csv_output .= $avblQty.",";
					$csv_output .= "0,";
					$csv_output .= "0,";
					$csv_output.="\n";
				}
			}
		}
 
		$filename = "Stock_Checklist"."_".date("Y-m-d_H-i",time());
		header("Content-type: text/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}

	public function getCustomerTCSDetails()
	{
		$vendor_id = $this->input->get('vendor_id');
		if((int) $vendor_id <= 0){
			$json['status'] = 0;
			echo json_encode($json);
			exit;
		}

		$this->db->select('sum(amount) as amount, sum(discount_amount) as discount_amount, sum(freight_amount) as freight_amount,sum(insurance_amount) as insurance_amount,sum(tcs_amount) as tcs_amount, pan_card, aadhar_no, gst_no');
		$result = $this->db->where('vendor_id', $vendor_id)->group_by('vendor_id')->get('CUSTOMER_TCS_VALUE_VIEW')->row();
		if(empty($result)){
			$tcs_value = 0;
		}else{
			$tcs_value = $result->amount - $result->discount_amount + $result->freight_amount + $result->insurance_amount + $result->tcs_amount;
		}

		$customer_obj = $this->db->select('pan_card, aadhar_no, gst_no')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

		if(empty($customer_obj->pan_card) && empty($customer_obj->aadhar_no) && empty($customer_obj->gst_no)){
			$tcs_perc = $this->db->where_in('config_key', 'tcs_percentage_without_id')->get('tbl_config')->row()->value;
			
		}else{
			$tcs_perc = $this->db->where_in('config_key', 'tcs_percentage_with_id')->get('tbl_config')->row()->value;
		}
		$json['tcs_value'] = $tcs_value;
		$json['tcs_percentage'] = $tcs_perc;
		$json['status'] = 1;
		echo json_encode($json);
		exit;

	}
}