<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
class ReturnMGT extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		/*load model*/
    }

    public function manage_return($id = NULL,$activeId=NULL)
    {  
		if (!empty($activeId)) {
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		 
		 
        $data['title'] = "RETURN MGT"; //Page title    
        $data['subview'] = $this->load->view('admin/return_mgt/manage_return', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

	 
	
	public function addTableRow()
	{   
		 
		 
		$trId=rand();
		$html='
			<tr id="'.$trId.'">
				<td><input placeholder="NHDIN"  class="form-control" required name="vendor_id[]" value="" type="text"></td>
				<td><input placeholder="INVOICE NUMBER" class="form-control" required name="source_id[]" value="" type="text"></td>
				<td><input placeholder="CUSTOMER NAME" class="form-control" required name="nhmod[]" value="" type="text"></td>
				<td><input placeholder="NHSP" class="form-control" required name="imei1[]" value="" type="text"></td>
				<td><input placeholder="SOLD DATE" class="form-control" required name="imei2[]" value="" type="text"></td>
				<td>
					<select name="return_type" required class="form-control">
						<option value="">Please select Return Type</option>
						<option value="">Return</option>
						<option value="">Sales Return</option>
					</select>
				</td>
				 <td><a onclick="deleteRow('.$trId.')" class="dt-button buttons-print btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
			</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
	
	
	public function uploadOrderByExcel()
	{
			if (isset($_FILES["excel_file"])) 
			{ 
				$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
				if ($imageFileType!= "xlsx") 
				{ 
					
					$type="error";
			
					$msg="File is not valid format please try again.";  
				}
				else
				{ 
			 
					require_once 'assets/ExcelClasses/PHPExcel.php';
					if($_FILES['excel_file']['name']!="")
					{
						$ran_no=rand(1111,9999);
						$this->load->library('upload');
						$config['file_name']='excel_file'.$ran_no;
						$config['upload_path']   = './assets/upload/';
						$config['allowed_types'] = 'xlsx';
						$config['max_size']      = 8000;
						$this->load->library('image_lib', $config);
						$this->image_lib->resize();
						$this->upload->initialize($config); 
						$this->upload->do_upload('excel_file');
						$upload_data = $this->upload->data();
						$image_name = $upload_data['file_name'];
					}
				/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
					$inputFileName =  './assets/upload/'.$image_name;
					include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
					$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
					$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
					$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
		 
					/*=check all date for stock type===*/
					$stockType=strtoupper(preg_replace('/\s+/', '', $this->input->post('stock_type'))); 
					 
						$subTypeQty=0;
						for($i=2;$i<=$arrayCount;$i++)
						{
							$excelSubType=strtoupper(preg_replace('/\s+/', '', trim($allDataInSheet[$i]["H"])));  
							  
							if($stockType==$excelSubType)
							{
								$subTypeQty++;
							}
						} 
					
					/*==Upload all data in row wise form===*/ 
			 
					if($subTypeQty==($arrayCount-1))
					{
						
						
						
						/*===GET NHDIN WORK===*/
						
						$mode=$this->input->post('stock_type');
						
						$location=$this->input->post('location');
						 
						
						if($location=='BANGLORE')
						{
							$loc='BLR';
						}
						else if($location=='LUCKNOW')
						{
							$loc='LUK';
						}
						else
						{
							$loc='DLI';
						} 
				
				
						/*===create order id===*/
					   
							$j=0;
							for($i=2;$i<=$arrayCount;$i++)
							{ 
								
								 
								$orderResult=array(
									'location'=>$this->input->post('location'),
									'invoice_type'=>$this->input->post('invoice_type'),
									'vendor_id'=>trim($allDataInSheet[$i]["A"]),
									'source'=>trim($allDataInSheet[$i]["B"]),
									'nhmod'=>trim($allDataInSheet[$i]["C"]),
									'imei1'=>trim($allDataInSheet[$i]["D"]),
									'imei2'=>trim($allDataInSheet[$i]["E"]),
									'unit_price'=>trim($allDataInSheet[$i]["F"]),
									'tax'=>trim($allDataInSheet[$i]["G"]),
									'stock_type'=>trim($allDataInSheet[$i]["H"]),
									'stock_subtype'=>trim($allDataInSheet[$i]["I"]),
									'invoice_no'=>trim($allDataInSheet[$i]["J"]),
									'invoice_date'=>date("Y-m-d", strtotime(trim($allDataInSheet[$i]["K"]))),
									'tax_type'=>trim($allDataInSheet[$i]["L"]),
									'insert_by'=>'Excel',
								);
								 
								$this->db->insert('tbl_bulkorder',$orderResult);
								 
								/*==Insert data in tbl_grnreport for create GRN REPORT===*/
				
									/*==Get vendor Name===*/
									
									$vendorCompany=$this->Common_model->getVendorCompanyNameFormVendorCode($orderResult['vendor_id']);
									$vendorState=$this->Common_model->getVendorStateFormVendorCode($orderResult['vendor_id']);
									
									
									if($i==2)
									{
										$orderId=$this->Common_model->getOrderIdForNHDIN($mode);
										 
									}
									
													
									if($i>2)
									{
										if($lastnhmod==$data['nhmod'][$i])
										{
											$j=$j;
										}
										else
										{
											$j=1;
										}
									}

					
									$nhdin=$this->Common_model->getNHDIN($orderId,$j,trim($allDataInSheet[$i]["C"]),$loc);
								
								
									$newVendorName=$vendorCompany." ( ".$vendorState." )";
									
									/*==get nhdp==*/
									
									$nhDp=round($orderResult['unit_price']/0.70);
									
									$grnResult=array
									(
									
										'vendor_code'=>$orderResult['vendor_id'],
										'invoice_date'=>date("Y-m-d", strtotime($orderResult['invoice_date'])),
										'invoice_no'=>$orderResult['invoice_no'],
										'invoice_type'=>$this->input->post('invoice_type'),
										'vendor_name'=>$newVendorName,
										'nhdin'=>$nhdin['kdin'],
										'device_name'=>$this->Common_model->getdeviceNameFromNHMOD($orderResult['nhmod']),
										'imei1_no'=>$orderResult['imei1'],
										'imei2_no'=>$orderResult['imei2'],
										'unit_price'=>$orderResult['unit_price'],
										'tax'=>$orderResult['tax'],
										'tax_type'=>$orderResult['tax_type'],
										'nhpp'=>$orderResult['unit_price'],
										'nhdp'=>$nhDp,
										'stock_type'=>$orderResult['stock_type'],
										'stock_subtype'=>$orderResult['stock_subtype'],
										'warehouse'=>$this->input->post('location'),
									);
									
									$insertId='';
									$this->db->insert('tbl_grnreport',$grnResult);
									$insertId=$this->db->insert_id();
									
									
									/*===insert activity for create bulk order in vendor code wise===*/
									 
				
									$module="bulk_order";
									$activity="activity_add_a bulk_order";
									$msg="Order created successfully which vendor code is:- ".$orderResult['vendor_code'];
									$this->Common_model->insertActivities($module,$insertId,$activity,$msg);
								
									$lastnhmod=$orderResult['nhmod'];
								$j++;
							}
					
						unlink($inputFileName);	

						$type="success";
				
						$msg="DATA UPLOADED SUCCESSFULLY.";  
					}
					else
					{
						$type="errror";
				
						$msg="SOME ERROR IN YOUR EXCEL FILE.PLEASE CHECK.";  
					}
				}
		}
		 else 
		 {
			$type="errror";
				
			$msg="NO FILE SELECTED.";  
		}
	}
	
	$this->session->set_userdata($type,$msg); 
	
	header("location:".$_SERVER['HTTP_REFERER']); 
}