<?php

if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Reports extends Admin_Controller
{

	public function __construct()
	{
		parent::__construct();
	}

	public function manage_reports($active = 0)
	{
		$data['title'] = "REPORTS";

		if ($active > 0) {
			$data['active'] = $active;
		} else {
			$data["active"] = 1;
		}

		$data['subview'] = $this->load->view('admin/reports/manage_reports', $data, TRUE);
		$this->load->view('admin/_layout_main', $data); //page load
	}

	public function downloadCsvReportsSalesOrder()
	{
		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$stock_type = $this->input->get("stock_type");

		$csv_output = "Salesorder Code, Device Id, Vendor, Sales Executive, Payment Mode, Warehouse, Sales Channel,";
		$csv_output .= "Sales Channel Ref. Id, Creation Date,Updated Date, ";
		$csv_output .= "Category, SKU, Grade, Procurement_Grade, Sales terms, Quantity, Sales Price,Sales Amount";
		if ($this->session->userdata('department_id') == 6) {
			$csv_output .= ",Procurement Price, Procurement Price Tax";
		}
		$csv_output .= "\n";
		if ($status != '' && $status != 'ALL') {
			$this->db->where("status", $status);
		}
		if ($from_date != '') {
			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}

		$result = $this->db->get('SALESORDER_EXPORT_VIEW')->result_array();

		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= $value['salesorder_code'] . ",";
				$csv_output .= $value['device_id'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['salesman'] . ",";
				$csv_output .= $value['payment_mode'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= date("d-m-Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= date("d-m-Y", strtotime($value['LAST_UPDATE_DATE'])) . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['sku'] . ",";
				$csv_output .= $value['grade'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['sales_terms'] . ",";
				$csv_output .= $value['quantity'] . ",";
				$csv_output .= $value['sale_price'] . ",";
				$csv_output .= $value['amount'] . ",";
				if ($this->session->userdata('department_id') == 6) {
					$csv_output .= $value['unit_price'] . ",";
					$csv_output .= $value['unit_price_tax'];
				}
				$csv_output .= "\n";
			}
		}
		$filename = "salesorder" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsInvoiceItem()
	{
		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Date, Invoice Code, Vendor,GSTIN, Address, State, Salesorder Code,Payment Mode, Warehouse, Sales Channel,";
		$csv_output .= "Sales Channel Ref. Id, Status, ";
		$csv_output .= "Inward Id, Category, Product Name, SKU, Procurement_Grade, Grade, Sales terms, Price, Taxable Amount, Exempt Amount, Tax Amount,";
		$csv_output .= "Tax Type, Bill Type, Gatepass no,Batch No";

		if (!empty($status) && $status != 'ALL') {

			$this->db->where("status", $status);
		}

		if ($from_date != '') {

			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('INVOICE_EXPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']) . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value["salesorder_code"] . ",";
				$csv_output .= $value['payment_mode'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['device_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value['sku'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['certification_grade'] . ",";
				$csv_output .= $value['sales_terms'] . ",";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['gatepass_no'] . ",";
				$csv_output .= $value['batch_no'] . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "invoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsDevices()
	{

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Vendor Name, Invoice No, Invoice Date, Device Id, Product Name, SKU, Stock Type, Sale Type, Warehouse, WSN, Procurement Grade, Grade, Status,";
		$csv_output .= "Invoice Type, IMEI, BIN Number, Batch NO, Inward Date, Created Date, Issued Date, Certified Date";

		if (!empty($status) && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		if ($from_date != '') {
			$this->db->where("DATE(created_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(created_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('tbl_grnreport')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['invoice_no'] . ",";
				$csv_output .= date("d-m-Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= $value['nhdin'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value["SKU"] . ",";
				$csv_output .= $value['stock_type'] . ",";
				$csv_output .= $value['saletype'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['othervendor_id'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['certification_grade'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['invoice_type'] . ",";
				$csv_output .= $value['imei1_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['bin_number']) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['batch_no']) . ",";
				$csv_output .= date("d-m-Y", strtotime($value['grn_inwarddate'])) . ",";
				$csv_output .= $value['created_date'] . ",";
				$csv_output .= $value['issued_date'] . ",";
				$csv_output .= $value['certified_date'] . ",";
				$csv_output .= "\n";
			}
		}
		$filename = "deviceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsSalesreturn()
	{

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$stock_type = $this->input->get("stock_type");

		$csv_output = "Salesreturn No, Salesreturn Type, Creditnote No, Invoice No, Sales Return Status, Invoice Status, Saleschannel, Saleschannel Ref Id,";
		$csv_output .= "Customer Name, GSTIN, State, Claim No, Warehouse, Quantity,";
		$csv_output .= "Total Amount, Taxable Amount, Exempt Amount, Tax Amount, Tax Type, Invoice Date, Credit note Date, Created Date, Returned Date, Remarks";

		if (!empty($status) && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		if ($from_date != '') {
			$this->db->where("DATE(last_modified) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(last_modified) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}
		$result = $this->db->get('CREDITNOTES_EXPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				if ($returned_date == '01-01-1970' || $returned_date == '30/11/-0001') {
					$returned_date = '';
				}

				$creditnote_date = date("d/m/Y", strtotime($value['last_modified']));
				if ($creditnote_date == '01-01-1970' || $creditnote_date == '30/11/-0001') {
					$creditnote_date = '';
				}
				$csv_output .= $value['salesreturn_no'] . ",";
				$csv_output .= $value['return_type'] . ",";
				$csv_output .= $value['creditnote_no'] . ",";
				$csv_output .= $value['invoice_no'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['invoice_status'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['claim_no'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['quantity'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= $creditnote_date . ",";
				$csv_output .= date("d/m/Y", strtotime($value['created_date'])) . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['remark']) . ",";
				$csv_output .= "\n";
			}
		}

		/*
		if ($from_date != '') {
			$this->db->where("DATE(cn_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(cn_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->where('status', $status)->get('CREDITNOTE_DISCOUNT_VIEW')->result_array();

		if(!empty($result)){
			foreach ($result as $value) {
				$csv_output .= ",";
				$csv_output .= $value['creditnote_discount_no'] . ",";
				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['invoice_status'] . ",";
				$csv_output .=  ",";
				$csv_output .= ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['claim_no'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['quantity'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= date("d/m/Y", strtotime($value['cn_date'])) . ",";
				$csv_output .= "\n";
			}
		}

		*/
		$filename = "salesreturn" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsSalesreturnItem()
	{

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$stock_type = $this->input->get("stock_type");
		
		/** These extra inputs are from Dashboard */
		$filter_element_type = $this->input->get("element_type");
		$filter_element = $this->input->get("element");
		$output_type = $this->input->get("output_type");

		$csv_header = "Salesreturn No, Creditnote No, Invoice No, Warehouse, Sales Return Status, Saleschannel, Saleschannel Ref Id,";
		$csv_header .= "Customer Name,Device Id, Category, Purchase Cost, Device Name,Certification Grade,Procurement Grade,Price, Taxable Amount, Exempt Amount, Tax Amount, Tax Type,";
		$csv_header .= "Purchase Price,Purchase Price Tax, Invoice Date, Credit note Date, Returned Date";

		if (!empty($status) && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		if ($from_date != '') {
			$this->db->where("DATE(creditnote_date) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(creditnote_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}
		
		/** This Filter is from Dashboard */
		if (!empty($filter_element_type)) {
			if ($filter_element_type == 'status' && !empty($filter_element)) {
				$this->db->where('salesreturn_status', $filter_element);
			}
		}

		$result = $this->db->get('SALESRETURN_ITEM_REPORT_VIEW')->result_array();

		$csv_output = $csv_header;
		$Res_Body = [];

		if (!empty($result)) {
			foreach ($result as $value) {
				$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				if ($returned_date == '01-01-1970' || $returned_date == '30/11/-0001') {
					$returned_date = '';
				}

				$creditnote_date = date("d/m/Y", strtotime($value['creditnote_date']));
				if ($creditnote_date == '01-01-1970' || $creditnote_date == '30/11/-0001') {
					$creditnote_date = '';
				}
				
				$temp_row = [];
				
				$temp_row[] = $value['salesreturn_code'];
				$temp_row[] = $value['creditnote_code'];
				$temp_row[] = $value['invoice_code'];
				$temp_row[] = $value['invoice_warehouse'];
				$temp_row[] = $value['salesreturn_status'];
				// $temp_row[] = $value['sales_channel'];
				$temp_row[] = $value['invoice_sales_channel'];
				$temp_row[] = $value['saleschannel_ref_id'];
				$temp_row[] = $value['vendor_name'];
				$temp_row[] = $value['nhdin'];
				$temp_row[] = $value['category'];
				$temp_row[] = $value['unit_price'];
				$temp_row[] = $value['device_name'];
				$temp_row[] = $value['grade'];
				$temp_row[] = $value['procurement_grade'];
				$temp_row[] = $value['price'];
				$temp_row[] = $value['taxable_amount'];
				$temp_row[] = $value['exempt_amount'];
				$temp_row[] = $value['tax_amount'];
				$temp_row[] = $value['bill_type'];
				$temp_row[] = $value['unit_price'];
				$temp_row[] = $value['unit_price_tax'];
				$temp_row[] = date("d/m/Y", strtotime($value['invoice_date']));
				$temp_row[] = $creditnote_date;
				$temp_row[] = $returned_date;

				$Res_Body[] = $temp_row;

				$csv_output .= "\n";
				$csv_output .= implode(',', $temp_row);
			}
		}
		
		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "salesreturnitem" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsInvoice()
	{

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Invoice Code, Vendor Code,Vendor, GSTIN, Address, State, Salesorder Code, Sales Executive, Payment Mode, Status, Warehouse, Sales Channel,";
		$csv_output .= "Sales Channel Ref. Id, Category, Stock Type, Quantity, Total Amount, Taxable Amount, Exempt Amount, Tax Amount,";
		$csv_output .= "Freight Amount, Freight Taxable Amount, Freight Tax Amount, Insurance Amount,Insurance Taxable Amount,Insurance Tax Amount,";
		$csv_output .= "Discount Amount,Discount Taxable Amount, Discount Tax Amount, Amount Excl TCS, TCS Amount,";
		$csv_output .= "Total Taxable Amount, Total Tax Amount, Net Amount, Bill Type, Tax Type, Invoice Date,Salesorder Date, Remark, Gatepass No";


		if (!empty($status) && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		if ($from_date != '') {
			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$net_amount = $value['total_amount'] + $value['freight_amount'] + $value['insurance_amount'] - $value['discount_amount'] + $value['tcs_amount'];
				$amount_excl_tcs = $value['total_amount'] + $value['freight_amount'] + $value['insurance_amount'] - $value['discount_amount'];

				$freight_taxable_amount = sprintf("%.2f", $value['freight_amount'] / 1.18);
				$freight_tax_amount = sprintf("%.2f", ($value['freight_amount'] -  $value['freight_amount'] / 1.18));

				$insurance_taxable_amount = sprintf("%.2f", $value['insurance_amount'] / 1.18);
				$insurance_tax_amount = sprintf("%.2f", ($value['insurance_amount'] -  $value['insurance_amount'] / 1.18));

				$discount_taxable_amount = sprintf("%.2f", $value['discount_amount'] / 1.18);
				$discount_tax_amount = sprintf("%.2f", ($value['discount_amount'] -  $value['discount_amount'] / 1.18));

				$total_taxable = $value['taxable_amount'] + $freight_taxable_amount + $insurance_taxable_amount  - $discount_taxable_amount;
				$total_tax = $value['tax_amount'] + $freight_tax_amount + $insurance_tax_amount - $discount_tax_amount;

				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']) . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value["salesorder_code"] . ",";
				$csv_output .= $value['salesman'] . ",";
				$csv_output .= $value['payment_mode'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['device_sub_category'] . ",";
				$csv_output .= $value['qty'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['freight_amount'] . ",";
				$csv_output .= $freight_taxable_amount . ",";
				$csv_output .= $freight_tax_amount . ",";
				$csv_output .= $value['insurance_amount'] . ",";
				$csv_output .= $insurance_taxable_amount . ",";
				$csv_output .= $insurance_tax_amount . ",";
				$csv_output .= $value['discount_amount'] . ",";
				$csv_output .= $discount_taxable_amount . ",";
				$csv_output .= $discount_tax_amount . ",";
				$csv_output .= $amount_excl_tcs . ",";
				$csv_output .= $value['tcs_amount'] . ",";
				$csv_output .= $total_taxable . ",";
				$csv_output .= $total_tax . ",";
				$csv_output .= $net_amount . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= date("d/m/Y", strtotime($value['salesorder_date'])) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['remark']) . ",";
				$csv_output .= $value['gatepass_no'] . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "invoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsPurchase()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$stock_type = $this->input->get("stock_type");

		$csv_output = "Invoice Date, Invoice Code, Vendor Code,Vendor, GSTIN, State, Quantity, Extra Devices, Short Devices, ";
		$csv_output .= "Invoice Amount, Taxable Amount, Exempt Amount, Tax Amount, TCS Amount, Total Amount, Tax Rate, Bill Type, Category, Entrypass No, RVP No, Batch No, Warehouse";

		if ($from_date != '') {
			$this->db->where("DATE(invoice_date) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(invoice_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('stock_type', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('stock_type', $stock_type);
			}
		}

		$result = $this->db->get('PURCHASE_EXPORT_REPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= date("d/m/Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= $value['invoice_no'] . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['invoice_qty'] . ",";
				$csv_output .= $value['extra_devices'] . ",";
				$csv_output .= $value['short_devices'] . ",";
				$csv_output .= $value['invoice_value'] . ",";
				$csv_output .= $value['taxable_value'] . ",";
				$csv_output .= $value['exempt_value'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['tcs'] . ",";
				$csv_output .= $value['invoice_value'] + $value['tcs'] . ",";
				$csv_output .= $value['tax_rate'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['stock_type'] . ",";
				$csv_output .= $value['gatepass_uniqueno'] . ",";
				$csv_output .= $value['lot_number'] . ",";
				$csv_output .= $value['batch_no'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "purchaseList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsCertificationTriage()
	{

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Device Id, Product Name, SKU, Stock Type, Grade, Procurement_Grade, Warehouse, Status,";
		$csv_output .= "Remark, Date";

		if (!empty($status) && $status != 'ALL') {

			$this->db->where("status", $status);
		}

		if ($from_date != '') {
			$this->db->where("DATE(certification_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(certification_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('CERTIFICATION_EXPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= $value['device_id'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value["sku"] . ",";
				$csv_output .= $value['stock_type'] . ",";
				$csv_output .= $value['grade'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['last_status'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['remark']) . ",";
				$csv_output .= date("d/m/Y", strtotime($value['certification_date'])) . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "certificationList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function getinvoicevarianttype()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Invoice No, Salesorder No, Device Name, Variant, Status, Warehouse,Vendor Name, State,";
		$csv_output .= "Salesman, Saleschannel, Saleschannel Ref id, Category, Quantity, price, Taxable Amount, Exempt Amount,Tax Amount, Bill type, Tax type, Invoice Date";
		if ($from_date != '') {
			$this->db->where("DATE(invoice_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(invoice_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('INVOICE_VARIANT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= $value['invoice_no'] . ",";
				$csv_output .= $value['salesorder_no'] . ",";
				$csv_output .= $value["device_name"] . ",";
				$csv_output .= $value['variant'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['state'] . ",";
				$csv_output .= $value["salesman"] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['quantity'] . ",";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value["taxable_amount"] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "invoicevariantList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsSO_RFS()
	{

		$module_type = $this->input->get('module_type');
		$status = $this->input->get('status');

		$csv_output = "S.NO, Date, Salesorder Code, Vendor, Category, SKU, Product Name, Grade, Quantity, Sales Channel, Sales Channel Ref. Id";

		if ($module_type == 2) {
			$this->db->where('sales_channel', 'EXPORT');
		} else {
			$this->db->where('sales_channel !=', 'EXPORT');
		}
		if ($status != '' && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		$result = $this->db->get('SALESORDER_EXPORT_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= $sno . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= $value['salesorder_code'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['sku'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value['grade'] . ",";
				$csv_output .= $value['quantity'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";

				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "salesorder" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsEcomInvoiceItem()
	{

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		
		$filter_element_type = $this->input->get("element_type");
		$filter_element = $this->input->get("element");
		$output_type = $this->input->get("output_type");

		$csv_header = "Amazon Order Date,Amazon Invoice Date, Return Date, Invoice Code, Credit Note No, Vendor Code, Vendor,GSTIN, Address, State, Payment Mode, Warehouse, Sales Channel,";
		$csv_header .= "Sales Channel Ref. Id, Invoice Ref ID, Status, ";
		$csv_header .= "FNSKU, sku, imei_1, imei_2, Procurement_Grade, Category, Price, Taxable Amount, Exempt Amount, Tax Amount,";
		$csv_header .= "Tax Type, Bill Type, Creation Date";

		if (!empty($status) && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		if ($from_date != '') {
			$this->db->where("DATE(sale_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(sale_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		
		$csv_output = $csv_header;
		$Res_Body = [];
		
		/** This Filter is from Dashboard */
		if (!empty($filter_element) && ($filter_element != 'FBA')) {
			GOTO OUTPUT;
		}

		$result = $this->db->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();
		

		if (!empty($result)) {
			foreach ($result as $value) {

				if (date("d/m/Y", strtotime($value['returned_date'])) == '01/01/1970') {
					$returned_date = '';
				} else {
					$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				}
				if (date("d/m/Y", strtotime($value['source_invoice_date'])) == '01/01/1970') {
					$source_invoice_date = '';
				} else {
					$source_invoice_date = date("d/m/Y", strtotime($value['source_invoice_date']));
				}
				
				$temp_row = [];

				$temp_row[] = date("d/m/Y", strtotime($value['sale_date']));
				$temp_row[] = $source_invoice_date;
				$temp_row[] = $returned_date;
				$temp_row[] = $value['ecom_invoice_no'];
				$temp_row[] = $value['creditnote_no'];
				$temp_row[] = $value['vendor_code'];
				$temp_row[] = str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['vendor_name']);
				$temp_row[] = $value['gst_no'];
				$temp_row[] = str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']);
				$temp_row[] = $value['location'];
				$temp_row[] = $value['payment_mode'];
				$temp_row[] = $value['warehouse'];
				$temp_row[] = $value['sales_channel'];
				$temp_row[] = $value['saleschannel_ref_id'];
				$temp_row[] = $value['invoice_ref_id'];
				$temp_row[] = $value['status'];
				$temp_row[] = $value['fnsku'];
				$temp_row[] = $value['sku'];
				$temp_row[] = $value['imei_1'];
				$temp_row[] = $value['imei_2'];
				$temp_row[] = $value['procurement_grade'];
				$temp_row[] = $value['category'];
				$temp_row[] = $value['price'];
				$temp_row[] = $value['taxable_amount'];
				$temp_row[] = $value['exempt_amount'];
				$temp_row[] = $value['tax_amount'];
				$temp_row[] = $value['tax_type'];
				$temp_row[] = $value['bill_type'];
				$temp_row[] = date("d/m/Y", strtotime($value['creation_date']));

				$Res_Body[] = $temp_row;

				$csv_output .= "\n";
				$csv_output .= implode(',', $temp_row);
			}
		}
		
		OUTPUT:
		
		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "ecominvoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}


	public function downloadCsvReportsReturnFFInvoiceItem()
	{
		//$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Amazon Sale Date, Amazon Invoice Date, Return Date,Credit Note Date, Invoice Code, Credit Note No,Vendor Code,  Vendor,GSTIN, Address, State, Payment Mode, Warehouse, Sales Channel,";
		$csv_output .= "Sales Channel Ref. Id, Invoice Ref ID, Status, Return Type, LPN Number, ";
		$csv_output .= "FNSKU, sku, imei_1, imei_2, Procurement_Grade, Category, Price, Taxable Amount, Exempt Amount, Tax Amount,";
		$csv_output .= "Tax Type, Bill Type, Invoice Date";

		$this->db->where_in("status", array('RETURN', 'CN_CREATED'));


		if ($from_date != '') {
			$this->db->where("DATE(returned_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(returned_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {

				if (date("d/m/Y", strtotime($value['returned_date'])) == '01/01/1970') {
					$returned_date = '';
				} else {
					$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				}

				if (date("d/m/Y", strtotime($value['source_invoice_date'])) == '01/01/1970') {
					$source_invoice_date = '';
				} else {
					$source_invoice_date = date("d/m/Y", strtotime($value['source_invoice_date']));
				}

				$csv_output .= date("d/m/Y", strtotime($value['sale_date'])) . ",";
				$csv_output .= $source_invoice_date . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= date("d/m/Y", strtotime($value['last_update_date'])) . ",";
				$csv_output .= $value['ecom_invoice_no'] . ",";
				$csv_output .= $value['creditnote_no'] . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['vendor_name']) . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']) . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['payment_mode'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['invoice_ref_id'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['return_type'] . ",";
				$csv_output .= $value['lpn_number'] . ",";
				$csv_output .= $value['fnsku'] . ",";
				$csv_output .= $value['sku'] . ",";
				$csv_output .= $value['imei_1'] . ",";
				$csv_output .= $value['imei_2'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['creation_date'])) . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "ecominvoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function dowloadTCSInvoices()
	{


		$csv_output = "CREATION_DATE, invoice Code,Salesorder Code, Warehouse, Status,Vendor,gst no, Address, Location, Saleschannel,Saleschannel Ref id, tcs_percent,tcs_amount,category, bill_type,	tax_type,qty,	total_amount	,taxable_amount	,exempt_amount	,tax_amount	,amount_excl_tax
		";

		$this->db->where("tcs_amount>0");

		$result = $this->db->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= $value['salesorder_code'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']) . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['tcs_percent'] . ",";
				$csv_output .= $value['tcs_amount'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= $value['qty'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['amount_excl_tax'] . ",";
				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "tcsinvoices" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function dowloadStocktransferOutward()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");


		if ($from_date != '') {
			$this->db->where("DATE(stocktransfer_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(stocktransfer_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		$csv_output = "Stocktransfer Date, Stocktransfer No, ST Type,From Loc,To Loc,Location,Gst No,Tracking Id,Tracking Name,Status,Creation Date,Last Update date,Created By,Last updated By,Website,Quantity,	Total Amount	,Total Taxable,Total tax,Total Exempt";

		$result = $this->db->get('STOCKTRANSFER_OUTWARD_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= date("d/m/Y", strtotime($value['stocktransfer_date'])) . ",";
				$csv_output .= $value['stocktransfer_no'] . ",";
				$csv_output .= $value['st_type'] . ",";
				$csv_output .= $value['from_loc'] . ",";
				$csv_output .= $value['to_loc'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['gst_number']) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['tracking_id']) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['tracking_name']) . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= date("d/m/Y", strtotime($value['LAST_UPDATE_DATE'])) . ",";
				$csv_output .= $value['CREATED_BY'] . ",";
				$csv_output .= $value['LAST_UPDATED_BY'] . ",";
				$csv_output .= $value['website'] . ",";
				$csv_output .= $value['total_quantity'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['total_taxable'] . ",";
				$csv_output .= $value['total_tax'] . ",";
				$csv_output .= $value['total_exempt'] . ",";
				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "stocktransfer Outward" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function dowloadStocktransferInward()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");


		if ($from_date != '') {
			$this->db->where("DATE(stocktransfer_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(stocktransfer_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		$csv_output = "Stocktransfer Date, Stocktransfer No, ST Type,From Loc,To Loc,Location,Gst No,Removable Id, Tracking Id,Tracking Name,Status,Creation Date,Last Update date,Created By,Last updated By,Website,Total Quantity,Received Quantity, Total Amount,Total Taxable,Total tax,Total Exempt";

		$result = $this->db->get('STOCKTRANSFER_INWARD_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= date("d/m/Y", strtotime($value['stocktransfer_date'])) . ",";
				$csv_output .= $value['stocktransfer_no'] . ",";
				$csv_output .= $value['st_type'] . ",";
				$csv_output .= $value['from_loc'] . ",";
				$csv_output .= $value['to_loc'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['gst_number']) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['removable_id']) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['tracking_id']) . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['tracking_name']) . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= date("d/m/Y", strtotime($value['LAST_UPDATE_DATE'])) . ",";
				$csv_output .= $value['CREATED_BY'] . ",";
				$csv_output .= $value['LAST_UPDATED_BY'] . ",";
				$csv_output .= $value['website'] . ",";
				$csv_output .= $value['total_quantity'] . ",";
				$csv_output .= $value['received_quantity'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['total_taxable'] . ",";
				$csv_output .= $value['total_tax'] . ",";
				$csv_output .= $value['total_exempt'] . ",";
				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "stocktransfer Inward" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}
	
	public function dowloadStocktransfer_itemwise($st_type = 'OUTWARD') {
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");


		if ($from_date != '') {
			$this->db->where("DATE(stocktransfer_date) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(stocktransfer_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		
		$csv_header = "Stocktransfer Date,Stocktransfer No,ST Type,Website,From Loc,To Loc,Tracking Id,Tracking Name,ST_Status,";
		$csv_header .= "InwardID,Imei_1,Imei_2,SKU,ProductName,Category,UnitPrice,UnitPrice_Tax,Device_Status,Grade,FNSKU,LPN_Number,ST_Price,ST_TaxableAmount,ST_Exempt_Amount,ST_TaxAmount,ST_TaxType";

		$result = $this->db->from('tbl_stocktransfer_invoice AS stin')
		               ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = stin.stocktransfer_id AND st.st_type = "'. $st_type .'"', 'INNER')
					   ->join('tbl_grnreport AS d', 'd.grnreport_id = stin.device_id')
					   ->select('st.stocktransfer_id, st.stocktransfer_no, st.st_type, st.website, st.from_loc, st.to_loc, st.to_loc_type, st.tracking_id, st.tracking_name, st.status AS st_status, st.stocktransfer_date, st.CREATION_DATE, st.LAST_UPDATE_DATE, st.claim_required,
					   stin.device_id, stin.fnsku, stin.lpn_number, stin.price, stin.taxable_amount, stin.exempt_amount, stin.tax_amount, stin.tax_type, stin.CREATION_DATE, stin.LAST_UPDATE_DATE,
					   d.nhdin, d.imei1_no, d.imei2_no, d.SKU, d.device_name, d.product_type, d.product_brand, d.unit_price, d.unit_price_tax, d.stock_type AS category, d.certification_grade, d.status AS device_status')
					   ->get()->result_array();
		
		$csv_output = $csv_header;
		$Res_Body = [];
			
		foreach ($result as $value) {
			$temp_row = [];

			$temp_row[] = date("d/m/Y", strtotime($value['stocktransfer_date']));
			$temp_row[] = $value['stocktransfer_no'];
			$temp_row[] = $value['st_type'];
			$temp_row[] = $value['website'];
			$temp_row[] = $value['from_loc'];
			$temp_row[] = $value['to_loc'];
			$temp_row[] = $value['tracking_id'];
			$temp_row[] = $value['tracking_name'];
			$temp_row[] = $value['st_status'];
			$temp_row[] = $value['nhdin'];
			$temp_row[] = $value['imei1_no'];
			$temp_row[] = $value['imei2_no'];
			$temp_row[] = $value['SKU'];
			$temp_row[] = $value['device_name'];
			$temp_row[] = $value['category'];
			$temp_row[] = $value['unit_price'];
			$temp_row[] = $value['unit_price_tax'];
			$temp_row[] = $value['device_status'];
			$temp_row[] = $value['certification_grade'];
			$temp_row[] = $value['fnsku'];
			$temp_row[] = $value['lpn_number'];
			$temp_row[] = $value['price'];
			$temp_row[] = $value['taxable_amount'];
			$temp_row[] = $value['exempt_amount'];
			$temp_row[] = $value['tax_amount'];
			$temp_row[] = $value['tax_type'];
			
			$Res_Body[] = $temp_row;

			$csv_output .= "\n";
			$csv_output .= implode(',', $temp_row);
		}
		
		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "StockTransfer_". $st_type ."_Itemwise" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadFBAInventory()
	{
		$where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];

		$inventory_date = $this->input->get('inventory_date');

		$fba_where = array(
			"tbl_grnreport.saletype" => "AMAZON",
			"tbl_grnreport.warehouse like " => "AMAZON%",
			"st_type" => "OUTWARD",
			"tbl_stocktransfer.status != " => "CANCELLED",
			"DATE(tbl_stocktransfer.stocktransfer_date) <= " => $inventory_date
		);
		//Get FBA Stock in reverse order
		$this->db->select('count(tbl_grnreport.nhdin) as total_stock, fnsku');
		$this->db->where($fba_where);
		$this->db->join('tbl_stocktransfer_invoice', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
		$this->db->join('tbl_stocktransfer', 'tbl_stocktransfer.stocktransfer_id = tbl_stocktransfer_invoice.stocktransfer_id');
		$total_array = $this->db->group_by('fnsku')->get('tbl_grnreport')->result_array();

		$this->db->select('count(tbl_ecom_invoice_item.ecom_invoice_item_id) as sold, fnsku')->where_in('status', $where_status);
		$this->db->where('DATE(sale_date) <= ', $inventory_date);
		$this->db->join('tbl_ecom_invoice_item', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
		$sold_array = $this->db->group_by('fnsku')->get('tbl_ecom_invoice')->result_array();

		foreach ($sold_array as $soldFNSKU) {
			$sold_stock[$soldFNSKU['fnsku']] = $soldFNSKU['sold'];
		}

		foreach ($total_array as $totalFnsku) {

			$sold = $sold_stock[$totalFnsku['fnsku']];

			if (empty($sold)) {
				$sold = 0;
			}
			$available_stock = $totalFnsku['total_stock'] - $sold;

			$where = array(
				"fnsku" => $totalFnsku['fnsku'],
				'tbl_grnreport.saletype' => 'AMAZON',
				"st_type" => "OUTWARD",
				"tbl_grnreport.warehouse like " => "AMAZON%",
				'tbl_grnreport.status != ' => 'SOLD',
				"tbl_stocktransfer.status != " => "CANCELLED",
				"DATE(tbl_stocktransfer.stocktransfer_date) <= " => $inventory_date
			);
			if ($available_stock > 0) {

				$this->db->select('tbl_grnreport.*');
				$this->db->where($where)->limit($available_stock);

				$this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
				$this->db->join('tbl_stocktransfer', 'tbl_stocktransfer.stocktransfer_id = tbl_stocktransfer_invoice.stocktransfer_id');
				$total_array = $this->db->group_by('grnreport_id')->order_by('tbl_stocktransfer_invoice.last_update_date', 'DESC')->get('tbl_stocktransfer_invoice')->result_array();

				foreach ($total_array as $rowValue) {
					$total_inventory[] = array(
						"grnreport_id" => $rowValue['grnreport_id'],
						"device_id" => $rowValue['nhdin'],
						"nhmod" => $rowValue['nhmod'],
						"device_name" => $rowValue['device_name'],
						"sku" => $rowValue['SKU'],
						"stock_type" => $rowValue['stock_type'],
						"certification_grade" => $rowValue['certification_grade'],
						"status" => $rowValue['status'],
						"warehouse" => $rowValue['warehouse'],
						"unit_price" => $rowValue['unit_price'],
						"unit_price_tax" => $rowValue['unit_price_tax'],
						"grn_inwarddate" => $rowValue['grn_inwarddate'],
					);
				}
			}
		}

		$csv_output = 'Device ID, Device Name, SKU, stock type, warehouse, unit price, unit price tax, inwarddate';
		$csv_output .= "\n";
		foreach ($total_inventory as $rowValue) {

			$csv_output .= $rowValue['device_id'] . ",";
			$csv_output .= $rowValue['device_name'] . ",";
			$csv_output .= $rowValue['sku'] . ",";
			$csv_output .= $rowValue['stock_type'] . ",";
			$csv_output .= $rowValue['warehouse'] . ",";
			$csv_output .= $rowValue['unit_price'] . ",";
			$csv_output .= $rowValue['unit_price_tax'] . ",";
			$csv_output .= $rowValue['grn_inwarddate'] . ",";
			$csv_output .= "\n";
		}

		$filename = "FBA Inventory" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCombinedReport()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Invoice Code,Salesreturn No, Creditnote No, Vendor Code,Vendor, GSTIN,  State, Salesorder Code,";
		$csv_output .= "Invoice Status, Return Status, Warehouse, Sales Channel,";
		$csv_output .= "Sales Channel Ref. Id, Category, Stock Type, Quantity, Total Amount, Taxable Amount, Exempt Amount, Tax Amount,";
		$csv_output .= "Freight Amount, Freight Taxable Amount, Freight Tax Amount, Insurance Amount,Insurance Taxable Amount,";
		$csv_output .= "Insurance Tax Amount,Discount Amount,Discount Taxable Amount, Discount Tax Amount, Amount Excl TCS, TCS Amount,";
		$csv_output .= "Total Taxable Amount, Total Tax Amount, Net Amount, Bill Type, Tax Type, Invoice Date/FBA Sale Date, ";
		$csv_output .= "Credit Note Date, Return Date, Gatepass No, Type";

		$invoice_status = ['INVOICED', 'PACKED', 'SHIPPED', 'PART_RETURN', 'FULL_RETURN'];

		$this->db->where_in("status", $invoice_status);

		if ($from_date != '') {

			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$net_amount = $value['total_amount'] + $value['freight_amount'] + $value['insurance_amount'] - $value['discount_amount'] + $value['tcs_amount'];
				$amount_excl_tcs = $value['total_amount'] + $value['freight_amount'] + $value['insurance_amount'] - $value['discount_amount'];

				$freight_taxable_amount = sprintf("%.2f", $value['freight_amount'] / 1.18);
				$freight_tax_amount = sprintf("%.2f", ($value['freight_amount'] -  $value['freight_amount'] / 1.18));

				$insurance_taxable_amount = sprintf("%.2f", $value['insurance_amount'] / 1.18);
				$insurance_tax_amount = sprintf("%.2f", ($value['insurance_amount'] -  $value['insurance_amount'] / 1.18));

				$discount_taxable_amount = sprintf("%.2f", $value['discount_amount'] / 1.18);
				$discount_tax_amount = sprintf("%.2f", ($value['discount_amount'] -  $value['discount_amount'] / 1.18));

				$total_taxable = $value['taxable_amount'] + $freight_taxable_amount + $insurance_taxable_amount  - $discount_taxable_amount;
				$total_tax = $value['tax_amount'] + $freight_tax_amount + $insurance_tax_amount - $discount_tax_amount;

				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['vendor_name']) . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value["salesorder_code"] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['device_sub_category'] . ",";
				$csv_output .= $value['qty'] . ",";
				$csv_output .= $value['total_amount'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['freight_amount'] . ",";
				$csv_output .= $freight_taxable_amount . ",";
				$csv_output .= $freight_tax_amount . ",";
				$csv_output .= $value['insurance_amount'] . ",";
				$csv_output .= $insurance_taxable_amount . ",";
				$csv_output .= $insurance_tax_amount . ",";
				$csv_output .= $value['discount_amount'] . ",";
				$csv_output .= $discount_taxable_amount . ",";
				$csv_output .= $discount_tax_amount . ",";
				$csv_output .= $amount_excl_tcs . ",";
				$csv_output .= $value['tcs_amount'] . ",";
				$csv_output .= $total_taxable . ",";
				$csv_output .= $total_tax . ",";
				$csv_output .= $net_amount . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= $value['gatepass_no'] . ",";
				$csv_output .= "INVOICE,";
				$csv_output .= "\n";
			}
		}

		//$csv_output = "Salesreturn No, Creditnote No, Invoice No, Sales Return Status, Invoice Status, Saleschannel, Saleschannel Ref Id,";
		//$csv_output .= "Customer Name, GSTIN, State, Claim No, Warehouse, Quantity,";
		//$csv_output .= "Total Amount, Taxable Amount, Exempt Amount, Tax Amount, Tax Type, Invoice Date, Credit note Date, Created Date, Returned Date, Remarks";

		$this->db->where("status !=", "VOID");

		if ($from_date != '') {
			$this->db->where("DATE(last_modified) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(last_modified) <=", date("Y-m-d", strtotime($to_date)));
		}
		$result = $this->db->get('CREDITNOTES_EXPORT_VIEW')->result_array();

		//$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				if ($returned_date == '01-01-1970' || $returned_date == '30/11/-0001') {
					$returned_date = '';
				}

				$creditnote_date = date("d/m/Y", strtotime($value['last_modified']));
				if ($creditnote_date == '01-01-1970' || $creditnote_date == '30/11/-0001') {
					$creditnote_date = '';
				}

				$csv_output .= $value['invoice_no'] . ",";
				$csv_output .= $value['salesreturn_no'] . ",";
				$csv_output .= $value['creditnote_no'] . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['vendor_name']) . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['invoice_status'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['stock_sub_type'] . ",";
				$csv_output .= -1 * $value['quantity'] . ",";
				$csv_output .= -1 * $value['total_amount'] . ",";
				$csv_output .= -1 * $value['taxable_amount'] . ",";
				$csv_output .= -1 * $value['exempt_amount'] . ",";
				$csv_output .= -1 * $value['tax_amount'] . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= -1 * $value['taxable_amount'] . ",";
				$csv_output .= -1 * $value['tax_amount'] . ",";
				$csv_output .= -1 * $value['total_amount'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= $creditnote_date . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= ",";
				$csv_output .= "RETURN,";
				$csv_output .= "\n";
			}
		}


		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		//$csv_output = "Date, Return Date, Invoice Code, Credit Note No, Vendor,GSTIN, Address, State, Payment Mode, Warehouse, Sales Channel,";
		//$csv_output .= "Sales Channel Ref. Id, Invoice Ref ID, Status, ";
		//$csv_output .= "FNSKU, Category, Price, Taxable Amount, Exempt Amount, Tax Amount,";
		//$csv_output .= "Tax Type, Bill Type, Creation Date";

		$fba_invoice_status = ["FINANCE_PENDING", "FINANCE_APPROVED", "RETURN", "CN_CREATED"];

		$this->db->where_in("status", $fba_invoice_status);


		if ($from_date != '') {

			$this->db->where("DATE(sale_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(sale_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();

		//$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				if (date("d/m/Y", strtotime($value['returned_date'])) == '01/01/1970') {
					$returned_date = '';
				} else {
					$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				}
				$csv_output .= $value['ecom_invoice_no'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['creditnote_no'] . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['vendor_name']) . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['stock_sub_type'] . ",";
				$csv_output .=  "1,";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['sale_date'])) . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= "FFINVOICE,";
				$csv_output .= "\n";
			}
		}

		//$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		//$csv_output = "FBA Sale Date, Return Date,Credit Note Date, Invoice Code, Credit Note No, Vendor,GSTIN, Address, State, Payment Mode, Warehouse, Sales Channel,";
		//$csv_output .= "Sales Channel Ref. Id, Invoice Ref ID, Status, ";
		//$csv_output .= "FNSKU, Category, Price, Taxable Amount, Exempt Amount, Tax Amount,";
		//$csv_output .= "Tax Type, Bill Type, Invoice Date";

		$this->db->where_in("status", array('RETURN', 'CN_CREATED'));


		if ($from_date != '') {

			$this->db->where("DATE(returned_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(returned_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();

		//$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				if (date("d/m/Y", strtotime($value['returned_date'])) == '01/01/1970') {
					$returned_date = '';
				} else {
					$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				}
				$csv_output .= $value['ecom_invoice_no'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['creditnote_no'] . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['vendor_name']) . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['stock_sub_type'] . ",";
				$csv_output .=  "-1,";
				$csv_output .= -1 * $value['price'] . ",";
				$csv_output .= -1 * $value['taxable_amount'] . ",";
				$csv_output .= -1 * $value['exempt_amount'] . ",";
				$csv_output .= -1 * $value['tax_amount'] . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= -1 * $value['taxable_amount'] . ",";
				$csv_output .= -1 * $value['tax_amount'] . ",";
				$csv_output .= -1 * $value['price'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['sale_date'])) . ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= "FFRETURN,";
				$csv_output .= "\n";
			}
		}

		$filename = "ecominvoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
	}

	public function downloadCsvReportsPurchaseItem()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		
		// $filter_element_type = $this->input->get("element_type");
		$filter_element = $this->input->get("element");
		$filter_status = $this->input->get("status");
		$output_type = $this->input->get("output_type");

		//$csv_output = "Batch No, Warehouse, Device Id, Product Name, SKU, IMEI One, IMEI Two, Procurement Grade, Unit Price, Unit Price Tax, Purchase Cost, Category, Status, Invoice Date, Invoice Code, Vendor Code,Vendor, GSTIN, State, ";
		//$csv_output .= "Invoice Amount, Taxable Amount, Exempt Amount, Tax Amount, TCS Amount, Total Amount, Tax Rate, Bill Type, Gatepass No, RVP No,";

		$csv_header = "Batch No, Warehouse, Device Id, Product Name, SKU, IMEI One, IMEI Two, Procurement Grade, Category, Unit Price, Unit Price Tax, Purchase Cost, Status, Invoice Date, Invoice Code, Vendor Code,Vendor, GSTIN, State,";
		$csv_header .= " Bill Type, Gatepass No, RVP No";

		if ($from_date != '') {
			$this->db->where("DATE(invoice_date) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(invoice_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		if (isset($filter_element) && $filter_element != '') {
			if (in_array($filter_element, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $filter_element);
			}
		}
		if (isset($filter_status) && $filter_status != '') {
			if ($filter_status == 'NON_RTV') {
				$this->db->where('status !=', 'RTV');
			} else if ($filter_status == 'RTV') {
				$this->db->where('status', 'RTV');
			}
		}

		$this->db->where('status !=', 'INWARD_CANCEL');
		$result = $this->db->get('PURCHASE_ITEM_WISE_EXPORT_VIEW')->result_array();

		$csv_output = $csv_header;
		$Res_Body = [];

		if (!empty($result)) {
			foreach ($result as $value) {
				$temp_row = [];
				
				$temp_row[] = $value['batch_no'];
				$temp_row[] = $value['warehouse'];
				$temp_row[] = $value['device_id'];
				$temp_row[] = $value['device_name'];
				$temp_row[] = $value['SKU'];
				$temp_row[] = $value['imei1_no'];
				$temp_row[] = $value['imei2_no'];
				$temp_row[] = $value['procurement_grade'];
				$temp_row[] = $value['category'];
				$temp_row[] = $value['unit_price'];
				$temp_row[] = $value['unit_price_tax'];
				$temp_row[] = $value['unit_price'] + $value['unit_price_tax'];
				$temp_row[] = $value['status'];
				$temp_row[] = date("d/m/Y", strtotime($value['invoice_date']));
				$temp_row[] = $value['invoice_no'];
				$temp_row[] = $value['vendor_code'];
				$temp_row[] = $value['vendor_name'];
				$temp_row[] = $value['gst_no'];
				$temp_row[] = $value['location'];
				//$temp_row[] = $value['invoice_qty'];
				//$temp_row[] = $value['extra_devices'];
				//$temp_row[] = $value['short_devices'];
				//$temp_row[] = $value['invoice_value'];
				//$temp_row[] = $value['taxable_value'];
				//$temp_row[] = $value['exempt_value'];
				//$temp_row[] = $value['tax_amount'];
				//$temp_row[] = $value['tcs'];
				//$temp_row[] = $value['invoice_value'] + $value['tcs'];
				//$temp_row[] = $value['tax_rate'];
				$temp_row[] = $value['bill_type'];
				$temp_row[] = $value['gatepass_uniqueno'];
				$temp_row[] = $value['lot_number'];
				
				$Res_Body[] = $temp_row;

				$csv_output .= "\n";
				$csv_output .= implode(',', $temp_row);
			}
		}
		
		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "purchaseItemList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsSalesItem()
	{
		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$stock_type = $this->input->get("stock_type");

		$csv_output = "Device ID, Product Type, Batch No, Sale Date, Return Date, Invoice Date, Credit Note Date, Invoice Code, Vendor Code,";
		$csv_output .= "Vendor,GSTIN, Address, State, Payment Mode, Warehouse, Sales Channel,";
		$csv_output .= "Sales Channel Ref. Id, Invoice Ref ID, Status, FNSKU, SKU,Procurement_Grade,Sales Grade,";
		$csv_output .= "Category, Price, Taxable Amount, Exempt Amount, Tax Amount,";
		$csv_output .= "Tax Type, Bill Type, Gatepass no, Purchase Price(Excl Tax), Purchase Price Tax, Total Purchase Price";

		if ($from_date != '') {
			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}

		$result = $this->db->get('INVOICE_EXPORT_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {

				$this->db->select('returned_date, last_modified')->where('invoice_id', $value['invoice_id'])->where_not_in('status', ['VOID', 'CANCEL']);
				$return_row = $this->db->get('tbl_salesreturn')->row();
				$returned_date = '';
				$creditnote_date = '';
				if (!empty($return_row)) {
					$returned_date = date("d-m-Y", strtotime($return_row->returned_date));
					$creditnote_date = date("d-m-Y", strtotime($return_row->last_modified));
				}

				if ($returned_date == '01-01-1970') {
					$returned_date = '';
				}
				if ($creditnote_date == '01-01-1970') {
					$creditnote_date = '';
				}
				$csv_output .= $value['device_id'] . ",";
				$csv_output .= $value['product_type'] . ",";
				$csv_output .= $value['batch_no'] . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= date("d/m/Y", strtotime($value['CREATION_DATE'])) . ",";
				$csv_output .= $creditnote_date . ",";
				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']) . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['payment_mode'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['invoice_ref_id'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .=  ",";
				$csv_output .= $value['sku'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['grade'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= $value['gatepass_no'] . ",";
				$csv_output .= $value['unit_price'] . ",";
				$csv_output .= $value['unit_price_tax'] . ",";
				$csv_output .= $value['unit_price'] + $value['unit_price_tax'] . ",";

				$csv_output .= "\n";
			}
		}

		//Ecom Sales

		if (!empty($status) && $status != 'ALL') {

			$this->db->where("status", $status);
		}

		if ($from_date != '') {

			$this->db->where("DATE(sale_date) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {

			$this->db->where("DATE(sale_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}

		$result = $this->db->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();

		if (!empty($result)) {
			foreach ($result as $value) {
				if (date("d/m/Y", strtotime($value['returned_date'])) == '01/01/1970') {
					$returned_date = '';
				} else {
					$returned_date = date("d/m/Y", strtotime($value['returned_date']));
				}
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= ",";
				$csv_output .= date("d/m/Y", strtotime($value['sale_date'])) . ",";
				$csv_output .= $returned_date . ",";
				$csv_output .= date("d/m/Y", strtotime($value['creation_date'])) . ",";
				$csv_output .= date("d/m/Y", strtotime($value['last_update_date'])) . ",";
				$csv_output .= $value['ecom_invoice_no'] . ",";
				$csv_output .= $value['vendor_code'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['gst_no'] . ",";
				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']) . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['payment_mode'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['sales_channel'] . ",";
				$csv_output .= $value['saleschannel_ref_id'] . ",";
				$csv_output .= $value['invoice_ref_id'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $value['fnsku'] . ",";
				$csv_output .= $value['sku'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .=  ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['price'] . ",";
				$csv_output .= $value['taxable_amount'] . ",";
				$csv_output .= $value['exempt_amount'] . ",";
				$csv_output .= $value['tax_amount'] . ",";
				$csv_output .= $value['tax_type'] . ",";
				$csv_output .= $value['bill_type'] . ",";
				$csv_output .= ",";
				$csv_output .= "\n";
			}
		}

		$filename = "invoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsInvoiceItemWithPurchase() {

		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$stock_type = $this->input->get("stock_type");

		$filter_sales_channel = $this->input->get("sc");
		$filter_branch = $this->input->get("branch");
		$filter_element_type = $this->input->get("element_type");
		$filter_element = $this->input->get("element");
		$output_type = $this->input->get("output_type");

		$csv_header = "Date, Invoice Code, Vendor,GSTIN, Address, State, Salesorder Code, Warehouse, Sales Channel,";
		$csv_header .= "Sales Channel Ref. Id, Status, Stock Type,";
		$csv_header .= "Inward Id, Batch Number, Category, Product Type, Product Name, SKU,Procurement_Grade,Sales Grade, Sales terms, Price, Taxable Amount, Exempt Amount, Tax Amount, TCS Amount,";
		$csv_header .= "Discount Taxable, Discount  on Tax, Freight Taxable, Freight on Tax,Total Taxable, Total Tax, Total Amount, ";
		$csv_header .= "Tax Type, Bill Type, Gatepass no, Outward Date, Purchase Invoice No, Purchase Vendor Name, Purchase Invoice Date, Purchase inward Date, Purchase Price(Excl Tax), Purchase Price Tax, Total Purchase Price";

		if (!empty($status) && $status != 'ALL') {
			$this->db->where("status", $status);
		}

		$this->db->where(array("status !=" => "VOID"));

		if ($from_date != '') {
			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}

		if (!empty($filter_branch)) {
			if ($filter_branch == 'HYD') {
				$this->db->where('warehouse !=', 'NOIDA');
			}
			if ($filter_branch == 'NOIDA') {
				$this->db->where('warehouse', 'NOIDA');
			}
		}
		if (!empty($filter_sales_channel)) {
			if ($filter_sales_channel == 'EXPORT') {
				$this->db->where('sales_channel', $filter_sales_channel);
			}
		}

		/** This Filter is from Dashboard */
		if (!empty($filter_element_type)) {
			if ($filter_element_type == 'catg' && !empty($filter_element)) {
				if (in_array($filter_element, ['BUY BACK', 'BUYBACK'])) {
					$this->db->group_start()
							 ->where('category', 'BUY BACK')
							 ->or_where('category', 'BUYBACK')
							 ->group_end();
				} else {
					$this->db->where('category', $filter_element);
				}
			}
			if ($filter_element_type == 'scw' && !empty($filter_element)) { // scw: Sales Channel Wise
				$scw_offline = ['OFFLINE', 'DEALERAPP'];
				$scw_not_online = ['OFFLINE', 'DEALERAPP', 'EXPORT'];
				$scw_export = ['EXPORT'];

				if ($filter_element == 'OFFLINE') {
					$this->db->where_in('sales_channel', $scw_offline);
				} else if ($filter_element == 'EXPORT') {
					$this->db->where_in('sales_channel', $scw_export);
				} else if ($filter_element == 'ONLINE') {
					$this->db->where_not_in('sales_channel', $scw_not_online);
				}
			}
			if ($filter_element_type == 'scw_o') { // scw: Sales Channel Online Wise
				$scw_not_online = ['OFFLINE', 'DEALERAPP', 'EXPORT'];

				$this->db->where_not_in('sales_channel', $scw_not_online);

				if (!empty($filter_element)) {
					$this->db->where('sales_channel', $filter_element);
				}
			}
			if ($filter_element_type == 'so_log' && !empty($filter_element)) { // scw: Sales Channel Online Wise
				// $status = ['FINANCE_PENDING', 'FINANCE_APPROVED', 'INVOICED'];

				// $this->db->where_not_in('sales_channel', $scw_not_online);

				// if (!empty($filter_element)) {
				// 	$this->db->where('sales_channel', $filter_element);
				// }
			}
		}

		$result = $this->db->get('INVOICE_ITEM_AUDIT_VIEW')->result_array();
		
		$csv_output = $csv_header;
		$Res_Body = [];

		if (!empty($result)) {
			foreach ($result as $value) {

				$freight_taxable_amount = sprintf("%.2f", $value['freight_amount'] / 1.18);
				$freight_tax_amount = sprintf("%.2f", ($value['freight_amount'] -  $value['freight_amount'] / 1.18));

				//$insurance_taxable_amount = sprintf("%.2f",$value['insurance_amount']/1.18);
				//$insurance_tax_amount = sprintf("%.2f",($value['insurance_amount'] -  $value['insurance_amount']/1.18));

				$discount_taxable_amount = sprintf("%.2f", $value['discount_amount'] / 1.18);
				$discount_tax_amount = sprintf("%.2f", ($value['discount_amount'] -  $value['discount_amount'] / 1.18));

				$freight_taxable_per_unit = sprintf("%.2f", ($value['freight_amount'] / $value['qty']) / 1.18);
				$freight_tax_per_unit = sprintf("%.2f", ($value['freight_amount'] / $value['qty'] -  $freight_taxable_per_unit));

				//$insurance_taxable_per_unit = sprintf("%.2f",($value['insurance_amount']/$value['qty'])/1.18);
				//$insurance_tax_per_unit = sprintf("%.2f",($value['insurance_amount']/$value['qty'] -  $insurance_taxable_per_unit));

				$discount_taxable_per_unit = sprintf("%.2f", ($value['discount_amount'] / $value['qty']) / 1.18);
				$discount_tax_per_unit = sprintf("%.2f", ($value['discount_amount'] / $value['qty'] -  $discount_taxable_per_unit));

				$total_amount = $value['price'] - $discount_taxable_per_unit - $discount_tax_per_unit + $freight_taxable_per_unit + $freight_tax_per_unit;

				$outward_date = date("d-m-Y", strtotime($value['outward_date']));
				if ($outward_date == '01-01-1970') {
					$outward_date = '';
				}
				
				$temp_row = [];

				$temp_row[] = date("d/m/Y", strtotime($value['CREATION_DATE']));
				$temp_row[] = $value['invoice_code'];
				$temp_row[] = $value['vendor_name'];
				$temp_row[] = $value['gst_no'];
				$temp_row[] = str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['address']);
				$temp_row[] = $value['location'];
				$temp_row[] = $value["salesorder_code"];
				$temp_row[] = $value['warehouse'];
				$temp_row[] = $value['sales_channel'];
				$temp_row[] = $value['saleschannel_ref_id'];
				$temp_row[] = $value['status'];
				$temp_row[] = $value['device_sub_category'];
				$temp_row[] = $value['device_id'];
				$temp_row[] = $value['batch_no'];
				$temp_row[] = $value['category'];
				$temp_row[] = $value['product_type'];
				$temp_row[] = $value['device_name'];
				$temp_row[] = $value['sku'];
				$temp_row[] = $value['procurement_grade'];
				$temp_row[] = $value['grade'];
				$temp_row[] = $value['sales_terms'];
				$temp_row[] = $value['price'];
				$temp_row[] = $value['taxable_amount'];
				$temp_row[] = $value['exempt_amount'];
				$temp_row[] = $value['tax_amount'];
				$temp_row[] = $value['tcs_amount_perunit'];
				$temp_row[] = $discount_taxable_per_unit;
				$temp_row[] = $discount_tax_per_unit;
				$temp_row[] = $freight_taxable_per_unit;
				$temp_row[] = $freight_tax_per_unit;
				$temp_row[] = $value['taxable_amount'] - $discount_taxable_per_unit + $freight_taxable_per_unit;
				$temp_row[] = $value['tax_amount'] - $discount_tax_per_unit + $freight_tax_per_unit;
				$temp_row[] = round($total_amount, 2);
				$temp_row[] = $value['tax_type'];
				$temp_row[] = $value['bill_type'];
				$temp_row[] = trim($value['gatepass_no']);
				$temp_row[] = $outward_date;
				$temp_row[] = $value['purchase_invoice_no'];
				$temp_row[] = $value['purchase_vendor_name'];
				$temp_row[] = date("d/m/Y", strtotime($value['purchase_invoice_date']));
				$temp_row[] = date("d/m/Y", strtotime($value['purchase_inward_date']));
				$temp_row[] = $value['unit_price'];
				$temp_row[] = $value['unit_price_tax'];
				$temp_row[] = $value['unit_price'] + $value['unit_price_tax'];
				
				$Res_Body[] = $temp_row;

				$csv_output .= "\n";
				$csv_output .= implode(',', $temp_row);
			}
		}
		
		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "invoiceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function downloadCsvReportsDevicesWithSales()
	{
		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$filter_element = $this->input->get("element");
		$output_type = $this->input->get("output_type");

		$csv_header = "Device Id, IMEI One, IMEI Two, Product Name, SKU,Procurement Grade, Stock Type, Sale Type, Warehouse, Device Status,";
		$csv_header .= " Batch NO,Invoice No, Vendor Name, Invoice Date, Inward Date, Purchase Price(Excl Tax), Purchase Price Tax, Purchase Price Total,";
		$csv_header .= "Sales Invoice Code, Sales Price,Exempt Amount, Taxable Amount, Tax, Sales Invoice Date, Outward Date, Sales Invoice Status";


		if ($from_date != '') {
			$this->db->where("DATE(purchase_invoice_date) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(purchase_invoice_date) <=", date("Y-m-d", strtotime($to_date)));
		}
		if (isset($filter_element) && $filter_element != '') {
			if (in_array($filter_element, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('stock_type', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('stock_type', $filter_element);
			}
		}

		$result = $this->db->get('PURCHASE_AUDIT_REPORT_VIEW')->result_array();

		$csv_output = $csv_header;
		$Res_Body = [];

		if (!empty($result)) {
			foreach ($result as $value) {
				$sale_date = date("d-m-Y", strtotime($value['sale_date']));

				if ($sale_date == '01-01-1970') {
					$sale_date = '';
				}

				$outward_date = date("d-m-Y", strtotime($value['outward_date']));

				if ($outward_date == '01-01-1970') {
					$outward_date = '';
				}

				$temp_row = [];

				$temp_row[] = $value['nhdin'];
				$temp_row[] = $value['imei1_no'];
				$temp_row[] = $value['imei2_no'];
				$temp_row[] = $value['device_name'];
				$temp_row[] = $value["SKU"];
				$temp_row[] = $value["procurement_grade"];
				$temp_row[] = $value['stock_type'];
				$temp_row[] = $value['saletype'];
				$temp_row[] = $value['warehouse'];
				$temp_row[] = $value['status'];
				$temp_row[] = str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['batch_no']);
				$temp_row[] = $value['purchase_invoice_no'];
				$temp_row[] = $value['purchase_vendor_name'];
				$temp_row[] = date("d-m-Y", strtotime($value['purchase_invoice_date']));
				$temp_row[] = date("d-m-Y", strtotime($value['grn_inwarddate']));
				$temp_row[] = $value['unit_price'];
				$temp_row[] = $value['unit_price_tax'];
				$temp_row[] = $value['unit_price'] + $value['unit_price_tax'];
				$temp_row[] = $value['invoice_code'];
				$temp_row[] = $value['sale_price'];
				$temp_row[] = $value['exempt_amount'];
				$temp_row[] = $value['taxable_amount'];
				$temp_row[] = $value['tax_amount'];
				$temp_row[] = $sale_date;
				$temp_row[] = $outward_date;
				$temp_row[] = $value['invoice_status'];

				$Res_Body[] = $temp_row;

				$csv_output .= "\n";
				$csv_output .= implode(',', $temp_row);
			}
		}
		
		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "deviceList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}


	public function downloadCsvReportsStocktransferItemWithPurchase()
	{
		$status = $this->input->get('status');
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");

		$csv_output = "Device Id, Product Name,IMEI One, IMEI Two, SKU, FNSKU,Procurement_Grade,Grade, Stock Type, Stocktransfer No, From Loc, To Loc,";
		$csv_output .= "Stock Transfer Date, Received Date, Stock Transfer Type,";
		$csv_output .= "Batch NO, Purchase Invoice No, Purchase Vendor Name, Purchase Invoice Date, Purchase Inward Date, Purchase Price(Excl Tax), Purchase Price Tax, Purchase Price Total";

		if ($from_date != '') {
			$this->db->where("DATE(stocktransfer_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(stocktransfer_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('STOCKTRANSFER_ITEM_WISE_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
				$csv_output .= $value['nhdin'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value['imei1_no'] . ",";
				$csv_output .= $value['imei2_no'] . ",";
				$csv_output .= $value["SKU"] . ",";
				$csv_output .= $value['fnsku'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['certification_grade'] . ",";
				$csv_output .= $value['stock_type'] . ",";
				$csv_output .= $value['stocktransfer_no'] . ",";
				$csv_output .= $value['from_loc'] . ",";
				$csv_output .= $value['to_loc'] . ",";
				$csv_output .= $value['stocktransfer_date'] . ",";
				$csv_output .= $value['received_date'] . ",";
				$csv_output .= $value['st_type'] . ",";
				$csv_output .= $value['batch_no'] . ",";
				$csv_output .= $value['invoice_no'] . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= date("d-m-Y", strtotime($value['invoice_date'])) . ",";
				$csv_output .= date("d-m-Y", strtotime($value['grn_inwarddate'])) . ",";
				$csv_output .= $value['unit_price'] . ",";
				$csv_output .= $value['unit_price_tax'] . ",";
				$csv_output .= $value['unit_price'] + $value['unit_price_tax'] . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "stnList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function getBatchwiseSummary()
	{
		$from_date = date("Y-m-d", strtotime($this->input->get("from_date")));
		$to_date = date("Y-m-d", strtotime($this->input->get("to_date")));

		if ($from_date !== '1970-01-01') {
			$this->db->where("DATE(invoice_date) >=", $from_date);
		}

		if ($to_date !== '1970-01-01') {
			$this->db->where("DATE(invoice_date) <=", $to_date);
		}

		$result = $this->db->select('batch_no, warehouse, count(grnreport_id) as qty, sum(unit_price+unit_price_tax) as value, stock_type as category, product_type,  DATE(invoice_date) as batch_date')->group_by('batch_no')->get('tbl_grnreport')->result_array();

		$csv = "Batch Date,Batch No,Warehouse,Category, Product Type, Qty,Value, Sold Qty, Taxable Amount, Exempt Amount, Tax Amount, Sold Amount\n";

		if (!empty($result)) {
			foreach ($result as $value) {
			    $soldData = $this->db->where('batch_no',$value['batch_no'])
				->select('batch_no, count(device_id) as sold_qty, sum(price) as sold_value, sum(taxable_amount) as taxable_amount, sum(exempt_amount) as exempt_amount, sum(tax_amount) as tax_amount')->get('BATCH_WISE_SOLD_DATA_VIEW')->row_array();
				$csv .= $value['batch_date'] . ",";
				$csv .= $value['batch_no'] . ",";
				$csv .= $value['warehouse'] . ",";
				$csv .= $value['category'] . ",";
				$csv .= $value['product_type'] . ",";
				$csv .= $value['qty'] . ",";
				$csv .= $value['value'] . ",";
				$csv .= $soldData ['sold_qty'] . ",";
				$csv .= $soldData ['taxable_amount'] . ",";
				$csv .= $soldData ['exempt_amount'] . ",";
				$csv .= $soldData ['tax_amount'] . ",";
				$csv .= $soldData ['sold_value'] . "\n";
			}
		}

		$filename = "batchwiseSummary" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv;
		exit;
	}

	public function getMasterSalesReport()
	{
		$from_date = date("Y-m-d", strtotime($this->input->get("from_date")));
		$to_date = date("Y-m-d", strtotime($this->input->get("to_date")));
		$stock_type = $this->input->get("stock_type");

		$csv_output  = "S.N.,FY,Quarter,Month,Week,Date,Partner,Contact Person,Contact No,Place,";
		// $csv_output .= "Channel Manager,Batch,Lot,Channel Category,Channel,Sales Category,Product Category,";
		$csv_output .= "Channel Manager,Channel Category,Product Category, Warehouse,";
		// $csv_output .= "Plan (Qty),Quantity (Nos),Invoice No,Invoice Amount(INR),Proc Amount(INR),Proc Tax(INR),Total Proc Amount(INR),Payment Terms,Received Cash (INR),Received Online (INR),";
		$csv_output .= "Plan (Qty),Quantity (Nos),Invoice No,Status,Invoice Amount Exclusive GST,Invoice Amount(INR),";
		$csv_output .= "Total Amount Recd (INR),Outstanding Amount (INR),Proc Amount(INR),Proc Tax(INR),Total Proc Amount(INR),Payment reference No\n";

		if ($from_date != '' && $from_date != '1970-01-01') {
			$this->db->where("DATE(CREATION_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '' && $to_date != '1970-01-01') {
			$this->db->where("DATE(CREATION_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}

		$result = $this->db->get('SALES_REPORT_VIEW')->result_array();

		if (!empty($result)) {
			$sno = 1;
			$invoice_ids = array();
			$so_ids = array();

			foreach ($result as $value) {
				$invoice_ids[] = $value['invoice_id'];
				$so_ids[] = $value['salesorder_id'];
			}

			$invoice_ids = array_unique($invoice_ids);
			$so_ids = array_unique($so_ids);

			// $batch_nos = $this->db->where_in('invoice_id', $invoice_ids)
			// 	->select('invoice_id, batch_no')
			// 	->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_invoice_item.grnreport_id')
			// 	->group_by('batch_no')
			// 	->get('tbl_invoice_item')->result_array();
			// $batch_dets = array();

			// foreach ($batch_nos as $value) {
			// 	$batch_dets[$value['invoice_id']][] = $value['batch_no'];
			// }

			$receipt_data = $this->db->where_in('salesorder_id', $so_ids)
				->join('tbl_receipt_so', 'tbl_receipt_so.receipt_id = tbl_receipt.receipt_id', 'left')
				->where_in('salesorder_id', $so_ids)->where('is_valid', 'Y')
				->get('tbl_receipt')->result_array();

			$credit_amount = array();
			$cash_amount = array();
			$online_amount = array();
			$payment_ref_no = array();

			foreach ($receipt_data as $value) {
				if ($value['receipt_type'] == 'CASH') {
					$cash_amount[$value['salesorder_id']] += $value['adjusted_amount'];
				} else if ($value['receipt_type'] == 'ONLINE' || $value['receipt_type'] == 'UPI') {
					$online_amount[$value['salesorder_id']] += $value['adjusted_amount'];
				} else {
					$credit_amount[$value['salesorder_id']] += $value['adjusted_amount'];
				}
				$payment_ref_no[$value['salesorder_id']][] = $value['reference_no'];
			}
			
			
			foreach ($result as $value) {
			    
			    $purchaseData = $this->db->where_in('invoice_id', $value['invoice_id'])
        			->select('SUM(tbl_grnreport.unit_price) as total_unit_price, SUM(tbl_grnreport.unit_price_tax) as total_unit_price_tax')
        			->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_invoice_item.grnreport_id')
        			->get('tbl_invoice_item')->row_array();
    			$total_proc_price = $purchaseData['total_unit_price'];
    			$total_proc_price_tax = $purchaseData['total_unit_price_tax'];
    			$total_proc_price_incl_tax = $total_proc_price + $total_proc_price_tax;
    			
				$date = date_create($value['CREATION_DATE']);
				if (date_format($date, "m") >= 4) {
					$financial_year = (date_format($date, "Y")) . '-' . (date_format($date, "y") + 1);
				} else {
					$financial_year = (date_format($date, "Y") - 1) . '-' . date_format($date, "y");
				}

				if (date_format($date, "m") >= 4 && date_format($date, "m") <= 6) {
					$quarter = 'Q - I';
				} else if (date_format($date, "m") >= 7 && date_format($date, "m") <= 9) {
					$quarter = 'Q - II';
				} else if (date_format($date, "m") >= 10 && date_format($date, "m") <= 12) {
					$quarter = 'Q - III';
				} else {
					$quarter = 'Q - IV';
				}
				//get week
				$week = date('W', strtotime($value['CREATION_DATE']));
				$outward_date = date("d-m-Y", strtotime($value['outward_date']));
				if ($outward_date == '01-01-1970') {
					$outward_date = '';
				}
				if ($value['sales_channel'] == 'OFFLINE') {
					$sales_channel = 'OFFLINE';
				} else if ($value['sales_channel'] == 'DEALERAPP') {
					$sales_channel = 'DEALERAPP';
				} else if ($value['sales_channel'] == 'EXPORT') {
					$sales_channel = 'EXPORT';
				} else {
					$sales_channel = 'ONLINE';
				}
				$sales_category = ($value['device_sub_category'] == 'STANDARD') ? 'Non-QC Sales' : 'QC Sales';
				// $vendor_type = ($value['vendor_type'] == 'DEALER') ? 'Bulk Vendor' : 'Retail Vendor';
				if ($value['vendor_type'] == 'EXPORT') {
					$vendor_type = 'EXPORT Vendor';
				} else if ($value['vendor_type'] == 'DEALER') {
					$vendor_type = 'Bulk Vendor';
				} else {
					$vendor_type = 'Retail Vendor';
				}
				if ($vendor_type == 'Bulk Vendor' && $vendor_type == 'Non-QC Sales') {
					$sales_category = 'Bulk Sales';
				}
				$net_amount = $value['total_amount'] + $value['freight_amount'] + $value['insurance_amount'] - $value['discount_amount'] + $value['tcs_amount'];
				$net_amount_exclusive_gst = $net_amount - $value['tax_amount'];

				$csv_output .= $sno . ",";
				$csv_output .= "FY " . $financial_year . ",";
				$csv_output .= $quarter . ",";
				$csv_output .= date_format($date, "M") . " " . date_format($date, "y") . ",";
				$csv_output .= $week . ",";
				$csv_output .= date_format($date, "d-m-Y") . ",";
				$csv_output .= str_replace(",", " ", $value['vendor_name']) . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['mobile'] . ",";
				$csv_output .= str_replace(",", " ", $value['city']) . ",";
				$csv_output .= $value['salesman'] . ",";
				// $csv_output .= implode(' | ', $batch_dets[$value['invoice_id']]) . ",";
				// $csv_output .= ",";
				$csv_output .= $sales_channel . ",";
				// $csv_output .= $vendor_type . ",";
				// $csv_output .= $sales_category . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= ",";
				$csv_output .= $value['qty'] . ",";
				$csv_output .= $value['invoice_code'] . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $net_amount_exclusive_gst . ",";
				$csv_output .= $net_amount . ",";
				// $csv_output .= $value['payment_mode'] . ",";
				// $csv_output .= $cash_amount[$value['salesorder_id']] . ",";
				// $csv_output .= $online_amount[$value['salesorder_id']] . ",";
				$csv_output .= $cash_amount[$value['salesorder_id']] +  $online_amount[$value['salesorder_id']] . ",";
				$csv_output .= $credit_amount[$value['salesorder_id']]  . ",";
				$csv_output .= $total_proc_price . ",";
				$csv_output .= $total_proc_price_tax . ",";
				$csv_output .= $total_proc_price_incl_tax . ",";
				$csv_output .= implode(' | ', $payment_ref_no[$value['salesorder_id']]) . ",";
				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "SalesReport" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}
	function internalStockMovementReport()
	{
		$from_date = date("Y-m-d", strtotime($this->input->get("from_date")));
		$to_date = date("Y-m-d", strtotime($this->input->get("to_date")));

		if ($from_date != '' && $from_date != '1970-01-01') {
			$this->db->where("DATE(last_updated) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '' && $to_date != '1970-01-01') {
			$this->db->where("DATE(last_updated) <=", date("Y-m-d", strtotime($to_date)));
		}

		$queryResult = $this->db->order_by('last_updated', 'ASC')->get('tbl_device_log')->result_array();
		$checkChange = array();
		$log = array();
		$devices = array();
		$deviceDetails = array();
		foreach ($queryResult as $rowValue) {
			
			if($rowValue['saletype'] == 'AMAZON'){
				$saletype = 'FBA';
			}else{
				$saletype = $rowValue['saletype'];
			}

			if (empty($checkChange[$rowValue['device_id']])) {
				$checkChange[$rowValue['device_id']] = $saletype;
			} else {
				if ($checkChange[$rowValue['device_id']] != $rowValue['saletype']) {
					$log[] = array(
						"device_id" => $rowValue['device_id'],
						"from" => $checkChange[$rowValue['device_id']],
						"to" => $saletype,
						"date" => date("d-m-Y", strtotime($rowValue['last_updated'])),
					);
					$checkChange[$rowValue['device_id']] = $saletype;
					$devices[] = $rowValue['device_id'];
				}
			}
		}
		
		$deviceQueryResult = $this->db->select('nhdin,device_name,batch_no,procurement_grade')->where_in('nhdin',$devices)->get('tbl_grnreport')->result_array();

		foreach($deviceQueryResult as $rowValue){
			$deviceDetails[$rowValue['nhdin']] = array(
				"device_name" => $rowValue['device_name'],
				"batch_no" => $rowValue['batch_no'],
				"procurement_grade" => $rowValue['procurement_grade']
			);
		}

		$csvRow = "Device ID,Device Name,Batch No,Procurement_Grade,From, To, Date\n";

		foreach ($log as $rowValue) {
			$csvRow .= $rowValue['device_id'] . ",";
			$csvRow .= $deviceDetails[$rowValue['device_id']]['device_name'].",";
			$csvRow .= $deviceDetails[$rowValue['device_id']]['batch_no'].",";
			$csvRow .= $deviceDetails[$rowValue['device_id']]['procurement_grade'].",";
			$csvRow .= $rowValue['from'] . ",";
			$csvRow .= $rowValue['to'] . ",";
			$csvRow .= $rowValue['date'] . "\n";

		}

		$filename = "StockTransfer" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csvRow;
		exit;
	}

	public function aftReport()
    {

        $from_date_1 = $this->input->get('from_date');
        $to_date_1 = $this->input->get('to_date');
        if ($from_date_1 == '' || $to_date_1 == '') {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_date = str_replace('/', '-', $from_date_1);
        $to_date = str_replace('/', '-', $to_date_1);
        $csv_output = "S/NO, DEVICE ID, CATEGORY, PRODUCT BRAND, DEVICE NAME, COLOR, RAM, ROM, SKU, GRADE,SUBMISSION DATE, STATUS";
        if ($from_date != '') {

            $this->db->where("DATE(UPDATED_DATE) >=", date("Y-m-d", strtotime($from_date)));
        }
        if ($to_date != '') {

            $this->db->where("DATE(UPDATED_DATE) <=", date("Y-m-d", strtotime($to_date)));
        }
        
        $result = $this->db->select('device_id, updated_date')->from('ynewco_triage.tbl_trg_worksheet')
		->where('source','INTERNAL')
		->where('sub_status', 'COMPLETE')
            	->get()->result();
        //echo "<pre>"; print_r($result); echo "</pre>"; exit;
        $report_data = array();
        $row_count = 1; 
        foreach ($result as $value) {

	    $updated_date = date("d-m-Y", strtotime($value->updated_date));
            $device_id = $value->device_id;
            $device_data = $this->db->select('*')->from('tbl_grnreport')->where('nhdin',$device_id)->get()->row();
            
            $report_data[] = array(

                "row_count" => $row_count,
                "device_id" => $value->device_id,
                "stock_type" => $device_data->stock_type,
                "product_brand" => $device_data->product_brand,
                "device_name" => $device_data->device_name,
                "color" => $device_data->color,
                "ram" => $device_data->ram,
                "rom" => $device_data->rom,
                "sku" => $device_data->SKU,
                "grade" => $device_data->certification_grade,
		"submission_date" => $updated_date,
		"status" => str_replace('_', ' ', $device_data->status)
            );
            $row_count++;
        }
        //echo "<pre>"; print_r($report_data); echo "</pre>"; exit;
        $csv_output .= "\n";
        if (!empty($report_data)) {
            foreach ($report_data as $periodic_report) {

                $csv_output .= $periodic_report['row_count'] . ",";
                $csv_output .= $periodic_report['device_id'] . ",";
                $csv_output .= $periodic_report['stock_type'] . ",";
                $csv_output .= $periodic_report['product_brand'] . ",";
                $csv_output .= $periodic_report['device_name'] . ",";
                $csv_output .= $periodic_report['color'] . ",";
                $csv_output .= $periodic_report['ram'] . ",";
                $csv_output .= $periodic_report['rom'] . ",";
                $csv_output .= $periodic_report['sku'] . ",";
                $csv_output .= $periodic_report['grade'] . ",";
		$csv_output .= $periodic_report['submission_date'] . ",";
		$csv_output .= $periodic_report['status'] . ",";

                $csv_output .= "\n";
            }
        }
        if (empty($report_data)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $filename = "AFT Report";
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;
    }

    public function dowloadServiceCenterItem()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");


		if ($from_date != '') {
			$this->db->where("DATE(CREATED_DATE) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(UPDATED_DATE) <=", date("Y-m-d", strtotime($to_date)));
		}
		$csv_output = "RMON NO, RMON STATUS, RMON DEVICE STATUS, SERVICE CENTER NAME,LOCATION,DEVICE NO,BATCH NO, DEVICE NAME, CATEGORY,PROCUREMENT_GRADE,GRADE,WAREHOUSE,STATUS,OUTWARD DATE, RECEIVED DATE,AGING";

		$result = $this->db->get('SERVICE_CENTER_DEVICE_LIST_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {

				$created_date = date("Y-m-d", strtotime($value['created_date']));
				$updated_date = date("Y-m-d", strtotime($value['updated_date']));
            			//$now = time(); // or your date as well
				$from_date = strtotime($created_date);
				$to_date = strtotime($updated_date);
				//$your_date = strtotime(date("Y-m-d", strtotime($to_date)));
				$datediff =  $to_date - $from_date;
				$aging_days = round($datediff / (60 * 60 * 24));

				$csv_output .= $value['rmon_code'] . ",";
				$csv_output .= $value['rmon_status'] . ",";
				$csv_output .= $value['rmon_device_status'] . ",";
				$csv_output .= $value['service_center'] . ",";
				$csv_output .= $value['location'] . ",";
				$csv_output .= $value['device_id'] . ",";
				$csv_output .= $value['batch_no'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $value['certification_grade'] . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $value['device_status'] . ",";
				$csv_output .= $created_date . ",";
				$csv_output .= $updated_date . ",";
				$csv_output .= $aging_days . ",";
				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "Service Center Report Item Wise" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}
	
	public function downloadCertificationReport()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");


		if ($from_date != '') {
			$this->db->where("DATE(LAST_UPDATED) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(LAST_UPDATED) <=", date("Y-m-d", strtotime($to_date)));
		}
		$csv_output = "STOCK TYPE, BATCH NUMBER,DEVICE ID,BRAND NAME, MODEL NAME, SKU,GRADE, PROCUREMENT GRADE, CERTIFICATION REMARKS, WAREHOUSE, STATUS, EXECUTIVE, LAST UPDATED";
		$result = $this->db->get('FIRST_CUT_CERTIFICATION_REPORT_VIEW')->result_array();
		//$result = $this->db->order_by('last_updated', 'ASC')->group_by('last_updated')->limit(1)->get('FIRST_CUT_CERTIFICATION_REPORT_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		$deviceid_arr = array();
		if (!empty($result)) {
			foreach ($result as $value) {

				$last_updated = date("Y-m-d", strtotime($value['last_updated']));
				$certification_remark = $value['certification_remark'];
				if(!empty($certification_remark)){
					$arr = explode("-",$certification_remark);
					$exicutive = $arr[0];
					$c_remark = $certification_remark;
				} else{
					$exicutive = "NA";
					$c_remark = "NA";
				}
				if(!in_array($value['device_id'], $deviceid_arr)){

					$csv_output .= $value['stock_type'] . ",";
					$csv_output .= $value['batch_no'] . ",";
					$csv_output .= $value['device_id'] . ",";
					$csv_output .= $value['product_brand'] . ",";
					$csv_output .= $value['device_name'] . ",";
					$csv_output .= $value['SKU'] . ",";
					$csv_output .= $value['first_cut_grade'] . ",";
					$csv_output .= $value['procurement_grade'] . ",";
					$csv_output .= $c_remark . ",";
					$csv_output .= $value['warehouse'] . ",";
					$csv_output .= $value['status'] . ",";
					$csv_output .= $exicutive . ",";
					$csv_output .= $last_updated . ",";
					$csv_output .= "\n";
					$sno++;
				}
				array_push($deviceid_arr, $value['device_id']);
				
			}
		}

		$filename = "First Cut Certification Report" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}    

	public function downloadCertificationODDReport()
	{
		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");


		if ($from_date != '') {
			$this->db->where("DATE(LAST_UPDATED) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {

			$this->db->where("DATE(LAST_UPDATED) <=", date("Y-m-d", strtotime($to_date)));
		}
		$this->db->where_in('status', array("CERTIFIED","FAULTED"));
		$csv_output = "STOCK TYPE, BATCH NUMBER,DEVICE ID,PRODUCT TYPE, BRAND NAME, MODEL NAME, SKU,GRADE, PROCUREMENT GRADE, CERTIFICATION REMARKS, PREVIOUS STATUS, CURRENT STATUS, WAREHOUSE, EXECUTIVE, QUANTITY, LAST UPDATED";

		$result = $this->db->get('CERTIFICATION_SUBMISSION_VIEW')->result_array();
		$sno = 1;
		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
			    
			    $current_status = $this->db->get_where('tbl_grnreport', array("nhdin" => $value['device_id']))->row()->status;

				$last_updated = date("Y-m-d", strtotime($value['last_updated']));
				$certification_remark = $value['certification_remark'];
				if(!empty($certification_remark)){
					$arr = explode("-",$certification_remark);
					$exicutive = $arr[0];
					$c_remark = $certification_remark;
				} else{
					$exicutive = "NA";
					$c_remark = "NA";
				}
				
				$csv_output .= $value['stock_type'] . ",";
				$csv_output .= $value['batch_no'] . ",";
				$csv_output .= $value['device_id'] . ",";
				$csv_output .= $value['product_type'] . ",";
				$csv_output .= $value['product_brand'] . ",";
				$csv_output .= $value['device_name'] . ",";
				$csv_output .= $value['SKU'] . ",";
				$csv_output .= $value['certification_grade'] . ",";
				$csv_output .= $value['procurement_grade'] . ",";
				$csv_output .= $c_remark . ",";
				$csv_output .= $value['status'] . ",";
				$csv_output .= $current_status . ",";
				$csv_output .= $value['warehouse'] . ",";
				$csv_output .= $exicutive . ",";
				$csv_output .= 1 . ",";
				$csv_output .= $last_updated . ",";
				$csv_output .= "\n";
				$sno++;
			}
		}

		$filename = "Certification Submission Report" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
    }
    
    public function downloadAllocationTriageReport()
    {
	$from_date = $this->input->get("from_date");
	$to_date = $this->input->get("to_date");


	if ($from_date != '') {
		$this->db->where("DATE(LAST_UPDATED) >=", date("Y-m-d", strtotime($from_date)));
	}

	if ($to_date != '') {

		$this->db->where("DATE(LAST_UPDATED) <=", date("Y-m-d", strtotime($to_date)));
	}
	$this->db->where_in('status', array("TRIAGE"));
	$csv_output = "STOCK TYPE, BATCH NUMBER,DEVICE ID, PRODUCT TYPE, BRAND NAME, MODEL NAME, SKU,GRADE, PROCUREMENT GRADE, ALLOCATION STATUS, ALLOCATION DATE, CURRENT STATUS, WAREHOUSE, SUBMISSION DATE, QUANTITY";

	$result = $this->db->get('CERTIFICATION_SUBMISSION_VIEW')->result_array();
	$sno = 1;
	$csv_output .= "\n";
	if (!empty($result)) {
		foreach ($result as $value) {
			    
			$current_status = $this->db->get_where('tbl_grnreport', array("nhdin" => $value['device_id']))->row()->status;
			if($current_status == "TRIAGE"){
                    
                    		$submission_date = "NA";
                	} else{
                    
                    		$submissionDate = $this->db->get_where('ynewco_triage.tbl_trg_worksheet', array("device_id" => $value['device_id'], "updated_date>" => $value['last_updated'], "sub_status" => "COMPLETE"))->row()->updated_date;
                    		$submission_date = date("Y-m-d", strtotime($submissionDate));
                	}
                	$last_updated = date("Y-m-d", strtotime($value['last_updated']));
			$csv_output .= $value['stock_type'] . ",";
			$csv_output .= $value['batch_no'] . ",";
			$csv_output .= $value['device_id'] . ",";
			$csv_output .= $value['product_type'] . ",";
			$csv_output .= $value['product_brand'] . ",";
			$csv_output .= $value['device_name'] . ",";
			$csv_output .= $value['SKU'] . ",";
			$csv_output .= $value['certification_grade'] . ",";
			$csv_output .= $value['procurement_grade'] . ",";
			$csv_output .= $value['status'] . ",";
			$csv_output .= $last_updated . ",";
			$csv_output .= $current_status . ",";
			$csv_output .= $value['warehouse'] . ",";
			$csv_output .= $submission_date . ",";
			$csv_output .= 1 . ",";
			$csv_output .= "\n";
			$sno++;
		}
	}

	$filename = "WarehouseToTriageAllocation" . "_" . date("Y-m-d_H-i", time());
	header("Content-type: application/csv");
	header("Content-disposition: csv" . date("Y-m-d") . ".csv");
	header("Content-disposition: filename=" . $filename . ".csv;");
	print $csv_output;
	exit;
    }  
	public function downloadStockAvailableReport()
	   {
    		
	    $csv_output = "Device Id, Product Type, Category, Sub Category, Is p2p, Stock Sub Type,  Warehouse, Purchase Date, PROC Cost, GST, Status, Bin Number, VRP Number, WSN No, Remark";
    		
    	    $query = "SELECT nhdin as device_id,batch_no,product_type, product_brand, device_name, imei1_no, imei2_no, SKU, stock_type as category,stock_subtype, is_p2p, device_sub_category as sub_category, warehouse, procurement_grade, certification_grade, saletype,invoice_no,DATE(invoice_date) as invoice_date, DATE(grn_inwarddate) as inward_date, DATEDIFF(CURDATE(), DATE(grn_inwarddate)) as aging, status,bin_number,othervendor_id as wsn_no, lot_number as vrp_no, unit_price, unit_price_tax, remark FROM `tbl_grnreport` WHERE status NOT IN ('SOLD','INWARD_CANCEL','RTV','FFC')";
    		$result = $this->db->query($query)->result_array();
    
            $csv_output .= "\n";
    		if (!empty($result)) {
    			foreach ($result as $value) {
    				$csv_output .= $value['device_id'] . ",";
    				//$csv_output .= $value['batch_no'] . ",";
    				$csv_output .= $value['product_type'] . ",";
    				//$csv_output .= $value['product_brand'] . ",";
    				//$csv_output .= $value['device_name'] . ",";
    				//$csv_output .= $value['imei1_no'] . ",";
    				//$csv_output .= $value['imei2_no'] . ",";
    				//$csv_output .= $value['SKU'] . ",";
    				$csv_output .= $value['category'] . ",";
				$csv_output .= $value['sub_category'] . ",";
				$csv_output .= $value['is_p2p'] . ",";
				$csv_output .= $value['stock_subtype'] . ",";
    				$csv_output .= $value['warehouse'] . ",";
    				//$csv_output .= $value['procurement_grade'] . ",";
    				//$csv_output .= $value['certification_grade'] . ",";
    				//$csv_output .= $value['saletype'] . ",";
    			    	//$csv_output .= $value['invoice_no'] . ",";
    				$csv_output .= $value['invoice_date'] . ",";
				$csv_output .= $value['unit_price'] . ",";
				$csv_output .= $value['unit_price_tax'] . ",";
    				//$csv_output .= $value['inward_date'] . ",";
    				//$csv_output .= $value['aging'] . ",";
    				$csv_output .= $value['status'] . ",";
    				$csv_output .= trim($value['bin_number']) . ",";
    				$csv_output .= $value['vrp_no'] . ",";
    				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['wsn_no']) . ",";
    				$csv_output .= str_replace(array(',', "\r\n", "\n", "\r"), ' ', $value['remark']) . ",";
    				
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "inventory_stock_available_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	public function downloadSpareAvailableReport()
	   {
    		
			$csv_output = "Spare Number, Spare Source, Spare Name, Spare Brand, Color, Device Name, Cost Price, Status, Inward Date";
    		
    	    $query = "SELECT spare_item_no, spare_source, spare_name, spare_brand, spare_color, device_model, cost_price, status, DATE(created_date) as inward_date FROM ynewco_triage.tbl_trg_spare_inventory_item WHERE status IN ('INWARD','IN_STOCK','UNUSED', 'DAMAGED','ISSUED','ALLOCATED') AND spare_source != 'ACCESSORIES'";
    		$result = $this->db->query($query)->result_array();
    
            $csv_output .= "\n";
    		if (!empty($result)) {
    			foreach ($result as $value) {
    				$csv_output .= $value['spare_item_no'] . ",";
    				$csv_output .= $value['spare_source'] . ",";
    				$csv_output .= $value['spare_name'] . ",";
    				$csv_output .= $value['spare_brand'] . ",";
    				$csv_output .= $value['spare_color'] . ",";
    				$csv_output .= $value['device_model'] . ",";
    				$csv_output .= $value['cost_price'] . ",";
    				$csv_output .= $value['status'] . ",";
    				$csv_output .= $value['inward_date'] . ",";
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "inventory_spare_available_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	public function downloadAccessoryAvailableReport()
	   {
    		
		$csv_output = "Spare Number, Spare Source, Spare Name, Spare Brand, Color, Device Name, Cost Price, Status, Inward Date";
    		
    	    $query = "SELECT spare_item_no, spare_source, spare_name, spare_brand, spare_color, device_model, cost_price, status, DATE(created_date) as inward_date FROM ynewco_triage.tbl_trg_spare_inventory_item WHERE status IN ('IN_STOCK') AND spare_source = 'ACCESSORIES'";
    		$result = $this->db->query($query)->result_array();
    
            $csv_output .= "\n";
    		if (!empty($result)) {
    			foreach ($result as $value) {
    				$csv_output .= $value['spare_item_no'] . ",";
    				$csv_output .= $value['spare_source'] . ",";
    				$csv_output .= $value['spare_name'] . ",";
    				$csv_output .= $value['spare_brand'] . ",";
    				$csv_output .= $value['spare_color'] . ",";
    				$csv_output .= $value['device_model'] . ",";
    				$csv_output .= $value['cost_price'] . ",";
    				$csv_output .= $value['status'] . ",";
    				$csv_output .= $value['inward_date'] . ",";
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "inventory_accessory_available_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	
	public function download_TaggingEfficiency_Report() {
    		
		$csv_output = "Date, Hours Worked, Device Count";

		$query = $this->db->from('tbl_device_tagging');
		
		$query = $query->group_by('date(start_date)')
		               ->order_by('date(start_date)', 'desc')
					   ->select('date(start_date) AS task_date, SUM(device_cnt) AS device_cnt, SEC_TO_TIME(SUM(TIME_TO_SEC(end_date) - TIME_TO_SEC(start_date))) AS total_time');
		$rs = $query->get()->result_array();
		// echo $query->get_compiled_select();die;
		
		// echo json_encode($rs);die;

    
            $csv_output .= "\n";
    		if (!empty($rs)) {
    			foreach ($rs as $value) {
    				$csv_output .= $value['task_date'] . ",";
    				$csv_output .= $value['total_time'] . ",";
    				$csv_output .= $value['device_cnt'] . ",";
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "Tagging_Efficiency_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	
	public function download_ChargingEfficiency_Report() {
		$task = 'CHARGING';
    		
		$csv_output = "Date, Allocated Count, Completed Count, Efficiency, Created Date, Updated Date";

		$query = $this->db->from('tbl_task_efficiency')
					->where('task', $task)
					->select('*, (completed_count * 100 / allocated_count) AS efficiency');
		
		$rs = $query->get()->result_array();
		// echo $query->get_compiled_select();die;
		
		// echo json_encode($rs);die;

    
            $csv_output .= "\n";
    		if (!empty($rs)) {
    			foreach ($rs as $value) {
    				$csv_output .= $value['task_date'] . ",";
    				$csv_output .= $value['allocated_count'] . ",";
    				$csv_output .= $value['completed_count'] . ",";
    				$csv_output .= $value['efficiency'] . ",";
    				$csv_output .= $value['created_date'] . ",";
    				$csv_output .= $value['updated_date'] . ",";
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "Charging_Efficiency_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	
	public function download_DisplayCheck_Report() {
		$task = 'DISPLAY_CHECK';
    		
		$csv_output = "Date, Allocated Count, CopyDisplay Count, Percentage of CopyDisplay, Created Date, Updated Date";

		$query = $this->db->from('tbl_task_efficiency')
					->where('task', $task)
					->select('*, (completed_count * 100 / allocated_count) AS efficiency');
		
		$rs = $query->get()->result_array();
		// echo $query->get_compiled_select();die;
		
		// echo json_encode($rs);die;

    
            $csv_output .= "\n";
    		if (!empty($rs)) {
    			foreach ($rs as $value) {
    				$csv_output .= $value['task_date'] . ",";
    				$csv_output .= $value['allocated_count'] . ",";
    				$csv_output .= $value['completed_count'] . ",";
    				$csv_output .= $value['efficiency'] . ",";
    				$csv_output .= $value['created_date'] . ",";
    				$csv_output .= $value['updated_date'] . ",";
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "DisplayCheck_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	
	public function getAmazon_Sales() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$data = [];

		/** AMAZON-TOTAL */
		$rs = $this->db->from('tbl_amazon_orders_data')
					->where('order_status', 'Shipped')
					->where('fulfillment_center_id is not null', null)
					->where('date(purchase_date) >=', $request_obj->start_date)
					->where('date(purchase_date) <=', $request_obj->end_date)
					->select('COUNT(DISTINCT amazon_order_id) AS total_invoices, SUM(quantity) AS total_qty, SUM(item_price) AS total_amount')
					->get()->result_array();
		if (count($rs) == 0) {
			GOTO ERROR;
		}
		$data['AMAZON'] = [
			'total_invoices' => $rs[0]['total_invoices'],
			'total_qty' => $rs[0]['total_qty'],
			'total_amount' => $rs[0]['total_amount'],
		];

		
		/** AMAZON-SELLERFLEX */
		$rs = $this->db->from('tbl_amazon_orders_data')
					->where('order_status', 'Shipped')
					->where('fulfillment_center_id is not null', null)
					->where('fulfillment_center_id', 'TNFB')
					->where('date(purchase_date) >=', $request_obj->start_date)
					->where('date(purchase_date) <=', $request_obj->end_date)
					->select('COUNT(DISTINCT amazon_order_id) AS total_invoices, SUM(quantity) AS total_qty, SUM(item_price) AS total_amount')
					->get()->result_array();
		if (count($rs) == 0) {
			GOTO ERROR;
		}
		$data['SELLERFLEX'] = [
			'total_invoices' => $rs[0]['total_invoices'],
			'total_qty' => $rs[0]['total_qty'],
			'total_amount' => $rs[0]['total_amount'],
		];

		
		/** AMAZON-FBA */
		$rs = $this->db->from('tbl_amazon_orders_data')
					->where('order_status', 'Shipped')
					->where('fulfillment_center_id is not null', null)
					->where('fulfillment_center_id !=', 'TNFB')
					->where('date(purchase_date) >=', $request_obj->start_date)
					->where('date(purchase_date) <=', $request_obj->end_date)
					->select('COUNT(DISTINCT amazon_order_id) AS total_invoices, SUM(quantity) AS total_qty, SUM(item_price) AS total_amount')
					->get()->result_array();
		if (count($rs) == 0) {
			GOTO ERROR;
		}
		$data['FBA'] = [
			'total_invoices' => $rs[0]['total_invoices'],
			'total_qty' => $rs[0]['total_qty'],
			'total_amount' => $rs[0]['total_amount'],
		];

		echo json_encode([
			'status' => true,
			'data' => $data
		]);
		exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something wrong'
		]);
	}
	
	public function getAmazon_Returns() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$data = [];
		
		/** AMAZON-FBA RETURNS*/
		$rs = $this->db->from('tbl_amazon_fba_returns')
					->where('date(return_date) >=', $request_obj->start_date)
					->where('date(return_date) <=', $request_obj->end_date)
					->select('COUNT(DISTINCT amazon_order_id) AS total_invoices, SUM(quantity) AS total_qty')
					->get()->result_array();
		if (count($rs) == 0) {
			GOTO ERROR;
		}
		$data['FBA'] = [
			'total_invoices' => $rs[0]['total_invoices'],
			'total_qty' => $rs[0]['total_qty'],
			'total_amount' => null,
		];

		echo json_encode([
			'status' => true,
			'data' => $data
		]);
		exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something wrong'
		]);
	}
	
	public function getExportSales_CatgWise() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$data = [];
		
		/** Exports Sales Channel Wise */
		$rs = $this->db->from('tbl_invoice_item AS ini')
					->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id')
					->where('inv.sales_channel', 'EXPORT')
					->where_in('inv.status', ['INVOICED', 'PACKED', 'SHIPPED'])
					->where('date(inv.CREATION_DATE) >=', $request_obj->start_date)
					->where('date(inv.CREATION_DATE) <=', $request_obj->end_date)
					->select('ini.category, SUM(ini.price) AS total_amount, COUNT(ini.invoice_item_id) AS total_qty, COUNT(DISTINCT ini.invoice_id) AS total_invoices')
					->group_by('ini.category')
					->get()->result_array();
					
		$data = [];
		foreach($rs as $k => $v) {
			$data[$v['category']] = $v;
		}

		echo json_encode([
			'status' => true,
			'data' => $data
		]);
		exit;

		// ERROR:
		// echo json_encode([
		// 	'status' => false,
		// 	'message' => isset($msg)? $msg : 'Something wrong'
		// ]);
	}
	
	public function getNoidaSales_CatgWise() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$data = [];
		
		/** Exports Sales Channel Wise */
		$rs = $this->db->from('tbl_invoice_item AS ini')
					->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id')
					->where('inv.warehouse', 'NOIDA')
					->where_in('inv.status', ['INVOICED', 'PACKED', 'SHIPPED'])
					->where('date(inv.CREATION_DATE) >=', $request_obj->start_date)
					->where('date(inv.CREATION_DATE) <=', $request_obj->end_date)
					->select('ini.category, SUM(ini.price) AS total_amount, COUNT(ini.invoice_item_id) AS total_qty, COUNT(DISTINCT ini.invoice_id) AS total_invoices')
					->group_by('ini.category')
					->get()->result_array();
					
		$data = [];
		foreach($rs as $k => $v) {
			$data[$v['category']] = $v;
		}

		echo json_encode([
			'status' => true,
			'data' => $data
		]);
		exit;
	}
	
	public function getTriageStatistics() {
		$request = file_get_contents('php://input', true);
		$request_obj = json_decode($request);

		$url = 'https://optimiage.sloyd.in/admin/Web_api/serviceEngineerData';

		$payload = [
			'from_date' => $request_obj->from_date,
			'to_date' => $request_obj->to_date,
		];

		/** START:: CURL Call */

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($req_data));
		curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $payload ) );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$server_output = curl_exec($ch);
		curl_close($ch);

		/** END:: CURL Call */

		echo($server_output);
		exit;
	}

	public function save_budget_data() {
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);


		$existing_data = $this->db->from('tbl_budget_targets')->where('fin_year', $data->fin_year)->select('fin_month')->get()->result_array();

		if (count($existing_data) >0) {
			$msg = 'Financial Budget for '. $data->fin_year .' already exist';
			GOTO ERROR;
		}

		$fin_yr_frm = (int) (explode('-', $data->fin_year))[0];

		$ins_data = [];
		foreach($data->budget_data as $obj) {
			$obj->fin_year = $data->fin_year;

			if ((int) $obj->fin_month < 4) {
				$obj->ref_date = ($fin_yr_frm +1) .'-'. str_pad($obj->fin_month, 2, '0', STR_PAD_LEFT) . '-01';
			} else {
				$obj->ref_date = $fin_yr_frm .'-'. str_pad($obj->fin_month, 2, '0', STR_PAD_LEFT) . '-01';
			}

			$ins_data[] = $obj;
		}

		$ins = $this->db->insert_batch('tbl_budget_targets', $ins_data);

		if ($ins) {
			echo json_encode([
				'status' => true,
				'message' => 'Budget Targets saved successfully'
			]);
			exit;
		}

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Unable to perform your request'
		]);
		exit;
	}
	
	public function get_Budget_Data() {
		$request = file_get_contents("php://input", true);  
		$data = json_decode($request);

		// echo json_encode($data);
		
		
		$Res = get_DashboardRelated_CustomResponse($data->start_date, $data->end_date);
		
		if ($Res['frm_mnth_DaysPortion'] >0) {
			$FromDate_obj = (array) $this->db->from('tbl_budget_targets')->where('ref_date', $Res['frm_mnth'] . '-01')->get()->row();
		}
		if ($Res['to_mnth_DaysPortion'] >0) {
			$ToDate_obj = (array) $this->db->from('tbl_budget_targets')->where('ref_date', $Res['to_mnth'] . '-01')->get()->row();
		}
		if (isset($Res['range'])) {
			$DtRange_obj = $this->db->from('tbl_budget_targets')->where('ref_date BETWEEN "'. $Res['range']['range_frm'] .'" AND "'. $Res['range']['range_to'] . '"')->get()->result_array();
		}

		/** Distinguishing Columns related to specific group */
		$openbox_col = [
			'_offl__amz_ob',
			'_offl__fk_rvp',
			'_online__amz_ob',
			'_online__fk_rvp',
		];
		$prexo_col = [
			'_offl__prexo_seltrue',
			'_offl__bundles',
			'_online__prexo_seltrue',
			'_offl__prexo_p2p',
			'_offl__prexo_open',
		];

		$offl_col = [
			'_offl__amz_ob',
			'_offl__fk_rvp',
			'_offl__prexo_seltrue',
			'_offl__bundles',
			'_offl__prexo_p2p',
			'_offl__prexo_open',
		];
		$online_col = [
			'_online__amz_ob',
			'_online__fk_rvp',
			'_online__prexo_seltrue',
		];


		/** Category-wise Sales Budget */

		$statistic_catg = [
			'qty',
			'rev'
		];

		$Catg_wise = [
			'qty_openbox' => 0,
			'qty_prexo' => 0,
			'rev_openbox' => 0,
			'rev_prexo' => 0
		];

		foreach($statistic_catg as $st) {

			if (isset($FromDate_obj)) {
				$temp_openbox = 0;
				$temp_prexo = 0;
	
				foreach($openbox_col as $v) {
					$temp_openbox += $FromDate_obj[$st . $v];
				}
				foreach($prexo_col as $v) {
					$temp_prexo += $FromDate_obj[$st . $v];
				}
	
				$Catg_wise[$st .'_openbox'] += round( $temp_openbox * $Res['frm_mnth_DaysPortion'] );
				$Catg_wise[$st .'_prexo'] += round( $temp_prexo * $Res['frm_mnth_DaysPortion'] );
			}
			
			if (isset($ToDate_obj)) {
				$temp_openbox = 0;
				$temp_prexo = 0;
	
				foreach($openbox_col as $v) {
					$temp_openbox += $ToDate_obj[$st . $v];
				}
				foreach($prexo_col as $v) {
					$temp_prexo += $ToDate_obj[$st . $v];
				}
	
				$Catg_wise[$st .'_openbox'] += round( $temp_openbox * $Res['to_mnth_DaysPortion'] );
				$Catg_wise[$st .'_prexo'] += round( $temp_prexo * $Res['to_mnth_DaysPortion'] );
			}
			
			if (isset($DtRange_obj)) {
				foreach($DtRange_obj as $obj) {
					$temp_openbox = 0;
					$temp_prexo = 0;
		
					foreach($openbox_col as $v) {
						$temp_openbox += $obj[$st . $v];
					}
					foreach($prexo_col as $v) {
						$temp_prexo += $obj[$st . $v];
					}
		
					$Catg_wise[$st .'_openbox'] += round( $temp_openbox );
					$Catg_wise[$st .'_prexo'] += round( $temp_prexo );
				}
			}
		}
		

		/** Sales-Channel-wise Budget */
		
		$sc_wise = [
			'qty_offline' => 0,
			'qty_online' => 0,
			'rev_offline' => 0,
			'rev_online' => 0
		];

		foreach($statistic_catg as $st) {

			if (isset($FromDate_obj)) {
				$temp_offline = 0;
				$temp_online = 0;
	
				foreach($offl_col as $v) {
					$temp_offline += $FromDate_obj[$st . $v];
				}
				foreach($online_col as $v) {
					$temp_online += $FromDate_obj[$st . $v];
				}
	
				$sc_wise[$st .'_offline'] += round( $temp_offline * $Res['frm_mnth_DaysPortion'] );
				$sc_wise[$st .'_online'] += round( $temp_online * $Res['frm_mnth_DaysPortion'] );
			}
			
			if (isset($ToDate_obj)) {
				$temp_offline = 0;
				$temp_online = 0;
	
				foreach($offl_col as $v) {
					$temp_offline += $ToDate_obj[$st . $v];
				}
				foreach($online_col as $v) {
					$temp_online += $ToDate_obj[$st . $v];
				}
	
				$sc_wise[$st .'_offline'] += round( $temp_offline * $Res['to_mnth_DaysPortion'] );
				$sc_wise[$st .'_online'] += round( $temp_online * $Res['to_mnth_DaysPortion'] );
			}
			
			if (isset($DtRange_obj)) {
				foreach($DtRange_obj as $obj) {
					$temp_offline = 0;
					$temp_online = 0;
		
					foreach($offl_col as $v) {
						$temp_offline += $obj[$st . $v];
					}
					foreach($online_col as $v) {
						$temp_online += $obj[$st . $v];
					}
		
					$sc_wise[$st .'_offline'] += round( $temp_offline );
					$sc_wise[$st .'_online'] += round( $temp_online );
					
				}
			}
		}
		
		

		// echo json_encode($Res);
		// echo json_encode($FromDate_obj);
		// echo json_encode($ToDate_obj);
		// echo json_encode($DtRange_obj);
		echo json_encode([
			'catg_wise' => $Catg_wise,
			'sc_wise' => $sc_wise
		]);
		exit;
	}

	public function dashboard_certification_report() {
		// In-Complete - Not Using yet

		$from_date = $this->input->get("from_date");
		$to_date = $this->input->get("to_date");
		$status = $this->input->get('status');
		$stock_type = $this->input->get("stock_type");

		$output_type = $this->input->get("output_type");


		if (!empty($status) && $status != 'ALL') {
			// $this->db->where("status", $status);
		}
		if ($stock_type != '') {
			if (in_array($stock_type, ['BUYBACK', 'BUY BACK'])) {
				$this->db->where_in('category', ['BUYBACK', 'BUY BACK']);
			} else {
				$this->db->where('category', $stock_type);
			}
		}
		if ($from_date != '') {
			$this->db->where("DATE(LAST_UPDATED) >=", date("Y-m-d", strtotime($from_date)));
		}
		if ($to_date != '') {
			$this->db->where("DATE(LAST_UPDATED) <=", date("Y-m-d", strtotime($to_date)));
		}

		$csv_header = "STOCK TYPE, BATCH NUMBER,DEVICE ID,BRAND NAME, MODEL NAME, SKU,GRADE, PROCUREMENT GRADE, CERTIFICATION REMARKS, STATUS, EXECUTIVE, LAST UPDATED";

		$result = $this->db->get('FIRST_CUT_CERTIFICATION_REPORT_VIEW')->result_array();
		$sno = 1;
		
		$csv_output = $csv_header;
		$Res_Body = [];
		
		foreach ($result as $value) {

			$last_updated = date("Y-m-d", strtotime($value['last_updated']));
			$certification_remark = $value['certification_remark'];
			if(!empty($certification_remark)){
				$arr = explode("-",$certification_remark);
				$exicutive = $arr[0];
				$c_remark = $certification_remark;
			} else{
				$exicutive = "NA";
				$c_remark = "NA";
			}

			$temp_row = [];

			$temp_row[] = $value['stock_type'];
			$temp_row[] = $value['batch_no'];
			$temp_row[] = $value['device_id'];
			$temp_row[] = $value['product_brand'];
			$temp_row[] = $value['device_name'];
			$temp_row[] = $value['SKU'];
			$temp_row[] = $value['certification_grade'];
			// $temp_row[] = $value['first_cut_grade'];
			$temp_row[] = $value['procurement_grade'];
			$temp_row[] = $c_remark;
			$temp_row[] = $value['status'];
			$temp_row[] = $exicutive;
			$temp_row[] = $last_updated;
			
			$Res_Body[] = $temp_row;
			
			$csv_output .= "\n";
			$csv_output .= implode(',', $temp_row);

			$sno++;
		}

		if (isset($output_type) && $output_type == 'data') {
			echo json_encode([
				'titles' => explode(',', $csv_header),
				'body' => $Res_Body
			]);
			exit;
		}

		$filename = "Dashboard_Certification_Report" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

	public function closingStockExcel2()
    {

        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if (empty($from_date) || empty($to_date)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_check_arr = explode('-', $from_date);
        $to_check_arr = explode('-', $to_date);

        if (!checkdate($from_check_arr[1], $from_check_arr[2], $from_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid From Date';
            echo json_encode($json);
            exit;
        }

        if (!checkdate($to_check_arr[1], $to_check_arr[2], $to_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid To Date';
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Date-wise Yield report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A3:G3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A4:A8')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('B1')->getFont()->setBold(true)->setSize(12);
	
		$today_date = date("Y-m-d");
		if($today_date == $from_date){
			$prev_date = $today_date;
		}

        $prev_date = date('d-m-Y', strtotime($from_date .' -1 day'));
        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('Closing Date');
        
        //Header Values
        $objSheet->getCell('B1')->setValue(date("d-m-Y", strtotime($prev_date)));
        

        // Table Header
        $objSheet->getCell('A3')->setValue('CATEGORY');
        $objSheet->getCell('B3')->setValue('TOTAL QTY');
        $objSheet->getCell('C3')->setValue('TOTAL VALUE');
        $objSheet->getCell('D3')->setValue('RFS QTY');
        $objSheet->getCell('E3')->setValue('RFS VALUE');
        $objSheet->getCell('F3')->setValue('RFS QTY %');
        $objSheet->getCell('G3')->setValue('RFS VALUE %');
        
        
        $objSheet->getCell('A4')->setValue('OPEN BOX');
        $objSheet->getCell('A5')->setValue('PREXO');
        $objSheet->getCell('A6')->setValue('BUY BACK');
        $objSheet->getCell('A7')->setValue('NEW');
        $objSheet->getCell('A8')->setValue('OTHERS');
        
		$today_date = date("Y-m-d");
		if($today_date == $from_date){
			$where_arr = array(
						"DATE(MODIFY_TIME) <=" => $from_date,
				);
			$view = "tbl_grnreport";
		} else {
			$where_arr = array(
						"DATE(LAST_UPDATED) <" => $from_date,
				);
			$view = "CLOSING_STOCK_REPORT_VIEW";
		}
        
        $result = $this->db->group_by('device_id,status')->where($where_arr)->get($view)->result_array();
        if (!empty($result)) {

            $status_arr = array("SOLD","RTV","FFC");
            $rowCount = 4;
            $openbox_qty = 0;
            $openbox_value = 0;
            $prexo_qty = 0;
            $prexo_value = 0;
            $buyback_qty = 0;
            $buyback_value = 0;
            $new_qty = 0;
            $new_value = 0;
            $others_qty = 0;
            $others_value = 0;
            
            $openbox_rfs_qty = 0;
            $openbox_rfs_value = 0;
            $prexo_rfs_qty = 0;
            $prexo_rfs_value = 0;
            $buyback_rfs_qty = 0;
            $buyback_rfs_value = 0;
            $new_rfs_qty = 0;
            $new_rfs_value = 0;
            $others_rfs_qty = 0;
            $others_rfs_value = 0;
            
            foreach ($result as $rowValue) {
                
                if(!in_array($rowValue['status'],$status_arr)){
                    
                    $device_cost = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                    if($rowValue['stock_type'] == "OPEN BOX"){
                        
                        $openbox_qty += 1;
                        $openbox_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $openbox_rfs_qty += 1;
                            $openbox_rfs_value += $device_cost;
                        }
                        
                    } else if($rowValue['stock_type'] == "PREXO"){
                        
                        $prexo_qty += 1;
                        $prexo_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $prexo_rfs_qty += 1;
                            $prexo_rfs_value += $device_cost;
                        }
                        
                    } else if($rowValue['stock_type'] == "BUYBACK" || $rowValue['stock_type'] == "BUY BACK"){
                        
                        $buyback_qty += 1;
                        $buyback_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $buyback_rfs_qty += 1;
                            $buyback_rfs_value += $device_cost;
                        }
                    } else if($rowValue['stock_type'] == "NEW"){
                        
                        $new_qty += 1;
                        $new_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $new_rfs_qty += 1;
                            $new_rfs_value += $device_cost;
                        }
                    } else{
                       
                        $others_qty += 1;
                        $others_value += $device_cost; 
                        if($rowValue['status'] == "RFS"){
                            $others_rfs_qty += 1;
                            $others_rfs_value += $device_cost;
                        }
                    }
                }
                
                $openbox_rfs_qty_percent    =  ($openbox_rfs_qty / $openbox_qty) * 100;
                $openbox_rfs_val_percent    =  ($openbox_rfs_value / $openbox_value) * 100;
                $prexo_rfs_qty_percent      =  ($prexo_rfs_qty / $prexo_qty) * 100;
                $prexo_rfs_val_percent      =  ($prexo_rfs_qty / $prexo_value) * 100;
                $buyback_rfs_qty_percent    =  ($buyback_rfs_qty / $buyback_qty) * 100;
                $buyback_rfs_val_percent    =  ($buyback_rfs_value / $buyback_value) * 100;
                $new_rfs_qty_percent        =  ($new_rfs_qty / $new_qty) * 100;
                $new_rfs_val_percent        =  ($new_rfs_value / $new_value) * 100;
                $others_rfs_qty_percent     =  ($others_rfs_qty / $others_qty) * 100;
                $others_rfs_val_percent     =  ($others_rfs_value / $others_value) * 100;

			}
        
        
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B4' ,$openbox_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C4' ,$openbox_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D4' ,$openbox_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E4' ,$openbox_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F4' ,sprintf('%.2f', $openbox_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G4' ,sprintf('%.2f', $openbox_rfs_val_percent));
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B5' ,$prexo_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C5' ,$prexo_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D5' ,$prexo_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E5' ,$prexo_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F5' ,sprintf('%.2f', $prexo_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G5' ,sprintf('%.2f', $prexo_rfs_val_percent));
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B6' ,$buyback_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C6' ,$buyback_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D6' ,$buyback_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E6' ,$buyback_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F6' ,sprintf('%.2f', $buyback_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G6' ,sprintf('%.2f', $buyback_rfs_val_percent));
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B7' ,$new_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C7' ,$new_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D7' ,$new_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E7' ,$new_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F7' ,sprintf('%.2f', $new_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G7' ,sprintf('%.2f', $new_rfs_val_percent));
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B8' ,$others_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C8' ,$others_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D8' ,$others_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E8' ,$others_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F8' ,sprintf('%.2f', $others_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G8' ,sprintf('%.2f', $others_rfs_val_percent));
			
        
			//$objSheet->getStyle('K' . $rowCount . ':O' . $rowCount)->getFont()->setBold(true)->setSize(10);
           
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Closing_stock_report_as_on ' . $prev_date;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }

	
	public function stockRegister_Excel() {
		
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if (empty($from_date) || empty($to_date)) {
			$msg = 'Date Range should be selected';
            GOTO ERROR;
        }

        $from_check_arr = explode('-', $from_date);
        $to_check_arr = explode('-', $to_date);

        if (!checkdate($from_check_arr[1], $from_check_arr[2], $from_check_arr[0])) {
            $msg = 'Invalid From Date';
            GOTO ERROR;
        }
        if (!checkdate($to_check_arr[1], $to_check_arr[2], $to_check_arr[0])) {
            $msg = 'Invalid To Date';
            GOTO ERROR;
        }

		
        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Date-wise Stock Register report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4

		$style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
			)
		);

        /* Set Header */
        $objSheet->mergeCells('A3:A4');
        $objSheet->mergeCells('B3:C3');
        $objSheet->mergeCells('D3:E3');
        $objSheet->mergeCells('F3:G3');
        $objSheet->mergeCells('H3:I3');
        $objSheet->mergeCells('J3:K3');

        $objSheet->getStyle('A3:K3')->applyFromArray($style);
        $objSheet->getStyle('A4:K4')->applyFromArray($style);
        $objSheet->getStyle('A3:K3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A4:K4')->getFont()->setBold(true)->setSize(10);
	
		$objSheet->getCell('A1')->setValue('Stock Register');
        $objSheet->getCell('C1')->setValue(date("d-m-Y", strtotime($from_date)) .' TO '. date("d-m-Y", strtotime($to_date)));

        /* Set Header */
        $objSheet->getCell('A3')->setValue('Date');
        $objSheet->getCell('B3')->setValue('Opening Stock');
        $objSheet->getCell('D3')->setValue('Inward Stock');
        $objSheet->getCell('F3')->setValue('RTV Stock');
        $objSheet->getCell('H3')->setValue('Sold Stock');
        $objSheet->getCell('J3')->setValue('Closing Stock');
		
        $objSheet->getCell('B4')->setValue('Qty');
        $objSheet->getCell('D4')->setValue('Qty');
        $objSheet->getCell('F4')->setValue('Qty');
        $objSheet->getCell('H4')->setValue('Qty');
        $objSheet->getCell('J4')->setValue('Qty');
		
        $objSheet->getCell('C4')->setValue('Value');
        $objSheet->getCell('E4')->setValue('Value');
        $objSheet->getCell('G4')->setValue('Value');
        $objSheet->getCell('I4')->setValue('Value');
        $objSheet->getCell('K4')->setValue('Value');


		$Res = $this->stock_register($from_date, $to_date);

		echo json_encode($Res);
		exit;
        

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'StockRegister_Report_for_ ' . $from_date .'_to_'. $to_date;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        exit;

		ERROR:
		echo json_encode([
			'status' => false,
			'message' => isset($msg)? $msg : 'Something wrong'
		]);
		exit;
	}

	public function stock_register($frm_date, $to_date) {
		$frm_date = '2023-08-01';
		$to_date = '2023-08-31';

		$begin = new DateTime($frm_date);
		$end = new DateTime($to_date);

		$begin->modify('-1 day');
		$end->modify('+1 day');

		$interval = DateInterval::createFromDateString('10 days');
		$period = new DatePeriod($begin, $interval, $end);

		$Closing_Stock_arr = [];
		$StatusWise_Stock = [];
		
		foreach ($period as $dt) {
			$d = $dt->format("Y-m-d");
			// echo 'start:'.$d.':end';
			// echo '<br>';

			/** Fetching CLOSING STOCK value */

			$this->db->query('SET @Fn_datetime = "'. $d .'"');

			$rs = $this->db->from('STOCK_REPORT_CLOSING_VALUE_VIEW')->get()->result_array();

			if (count($rs) == 0) {
				$msg = 'Error in fetching Closing Stock value on ' . $d;
				GOTO ERROR;
			}
			$Closing_Stock_arr[$d] =  [
				'qty' => $rs[0]['qty'],
				'price_val' => $rs[0]['price_val']
			];
			
		}
		
		/** Fetching Status Wise STOCK value */

		$Diff_StatusWise = [
			'INWARD', 'RTV', 'SOLD'
		];
		
		foreach($Diff_StatusWise as $status) {

			foreach ($period as $dt) {
				$d = $dt->format("Y-m-d");
	
				$this->db->query('SET @Fn_datetime = "'. $d .'"');
				$this->db->query('SET @Fn_str_var = "'. $status .'"');
				
				$rs = $this->db->from('STOCK_REPORT_DYNAMIC_STATUS_VALUE_VIEW')->get()->result_array();
	
				if (count($rs) == 0) {
					$msg = 'Error in fetching "'. $status .'" Stock value on ' . $d;
					GOTO ERROR;
				}
				$StatusWise_Stock[$status][$d] =  [
					'qty' => $rs[0]['qty'],
					'price_val' => $rs[0]['price_val']
				];
				
			}
		}
		
		return [
			'Closing_Stock_arr' => $Closing_Stock_arr,
			'StatusWise_Stock' => $StatusWise_Stock
		];

		ERROR:
		return [
			'status' => false,
			'message' => isset($msg)? $msg : 'Something wrong'
		];
	}

	public function closingStockExcel() {

        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');
	
        if (empty($from_date) || empty($to_date)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_check_arr = explode('-', $from_date);
        $to_check_arr = explode('-', $to_date);

        if (!checkdate($from_check_arr[1], $from_check_arr[2], $from_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid From Date';
            echo json_encode($json);
            exit;
        }

        if (!checkdate($to_check_arr[1], $to_check_arr[2], $to_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid To Date';
            echo json_encode($json);
            exit;
        }

        include './assets/ExcelClasses/PHPExcel/IOFactory.php';
        require_once('export_file_excel/Classes/PHPExcel.php');
        $objPHPExcel = new PHPExcel;
        // set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
        // set default font size
        $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
        // create the writer
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
        // currency format, € with < 0 being in red color
        $currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
        // number format, with thousands separator and two decimal points.
        $numberFormat = '#,#0.##;[Red]-#,#0.##';
        // writer already created the first sheet for us, let's get it
        $objSheet = $objPHPExcel->getActiveSheet();
        // rename the sheet
        $objSheet->setTitle('Closing Stock report');

        // let's bold and size the header font and write the header
        // as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A3:G3')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A4:A8')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('A1')->getFont()->setBold(true)->setSize(12);
        $objSheet->getStyle('B1')->getFont()->setBold(true)->setSize(12);
	
		$today_date = date("Y-m-d");
		if($today_date == $from_date){
			$prev_date = $today_date;
		}

        $prev_date = date('d-m-Y', strtotime($from_date .' -1 day'));
        // set Header
        // write header
        $objSheet->getCell('A1')->setValue('Closing Date');
        
        //Header Values
        $objSheet->getCell('B1')->setValue(date("d-m-Y", strtotime($prev_date)));
        

        // Table Header
        $objSheet->getCell('A3')->setValue('CATEGORY');
        $objSheet->getCell('B3')->setValue('TOTAL QTY');
        $objSheet->getCell('C3')->setValue('TOTAL VALUE');
        $objSheet->getCell('D3')->setValue('RFS QTY');
        $objSheet->getCell('E3')->setValue('RFS VALUE');
        $objSheet->getCell('F3')->setValue('RFS QTY %');
        $objSheet->getCell('G3')->setValue('RFS VALUE %');
        
        
        $objSheet->getCell('A4')->setValue('OPEN BOX');
        $objSheet->getCell('A5')->setValue('PREXO');
        $objSheet->getCell('A6')->setValue('BUY BACK');
        $objSheet->getCell('A7')->setValue('NEW');
        $objSheet->getCell('A8')->setValue('OTHERS');
        
		$today_date = date("Y-m-d");
		if($today_date == $from_date){
			$where_arr = array(
						"DATE(MODIFY_TIME) <=" => $from_date,
				);
			$view = "tbl_grnreport";
		} else {
			$where_arr = array(
						"DATE(LAST_UPDATED) <" => $from_date,
				);
			$view = "CLOSING_STOCK_REPORT_FROM_DEVICE_LOG";
		}
		
		$this->db->query('SET @Fn_datetime = "'. $from_date .'"');
		$result = $this->db->get($view)->result_array();
        if (!empty($result)) {

            //$status_arr = array("SOLD","RTV","FFC");
            $rowCount = 4;
            $openbox_qty = 0;
            $openbox_value = 0;
            $prexo_qty = 0;
            $prexo_value = 0;
            $buyback_qty = 0;
            $buyback_value = 0;
            $new_qty = 0;
            $new_value = 0;
            $others_qty = 0;
            $others_value = 0;
            
            $openbox_rfs_qty = 0;
            $openbox_rfs_value = 0;
            $prexo_rfs_qty = 0;
            $prexo_rfs_value = 0;
            $buyback_rfs_qty = 0;
            $buyback_rfs_value = 0;
            $new_rfs_qty = 0;
            $new_rfs_value = 0;
            $others_rfs_qty = 0;
            $others_rfs_value = 0;
            
            foreach ($result as $rowValue) {
                
                //if(!in_array($rowValue['status'],$status_arr)){
                    
                    $device_cost = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                    if($rowValue['stock_type'] == "OPEN BOX"){
                        
                        $openbox_qty += 1;
                        $openbox_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $openbox_rfs_qty += 1;
                            $openbox_rfs_value += $device_cost;
                        }
                        
                    } else if($rowValue['stock_type'] == "PREXO"){
                        
                        $prexo_qty += 1;
                        $prexo_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $prexo_rfs_qty += 1;
                            $prexo_rfs_value += $device_cost;
                        }
                        
                    } else if($rowValue['stock_type'] == "BUYBACK" || $rowValue['stock_type'] == "BUY BACK"){
                        
                        $buyback_qty += 1;
                        $buyback_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $buyback_rfs_qty += 1;
                            $buyback_rfs_value += $device_cost;
                        }
                    } else if($rowValue['stock_type'] == "NEW"){
                        
                        $new_qty += 1;
                        $new_value += $device_cost;
                        if($rowValue['status'] == "RFS"){
                            $new_rfs_qty += 1;
                            $new_rfs_value += $device_cost;
                        }
                    } else{
                       
                        $others_qty += 1;
                        $others_value += $device_cost; 
                        if($rowValue['status'] == "RFS"){
                            $others_rfs_qty += 1;
                            $others_rfs_value += $device_cost;
                        }
                    }
                //}
                
                $openbox_rfs_qty_percent    =  ($openbox_rfs_qty / $openbox_qty) * 100;
                $openbox_rfs_val_percent    =  ($openbox_rfs_value / $openbox_value) * 100;
                $prexo_rfs_qty_percent      =  ($prexo_rfs_qty / $prexo_qty) * 100;
                $prexo_rfs_val_percent      =  ($prexo_rfs_qty / $prexo_value) * 100;
                $buyback_rfs_qty_percent    =  ($buyback_rfs_qty / $buyback_qty) * 100;
                $buyback_rfs_val_percent    =  ($buyback_rfs_value / $buyback_value) * 100;
                $new_rfs_qty_percent        =  ($new_rfs_qty / $new_qty) * 100;
                $new_rfs_val_percent        =  ($new_rfs_value / $new_value) * 100;
                $others_rfs_qty_percent     =  ($others_rfs_qty / $others_qty) * 100;
                $others_rfs_val_percent     =  ($others_rfs_value / $others_value) * 100;

			}
        
        
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B4' ,$openbox_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C4' ,$openbox_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D4' ,$openbox_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E4' ,$openbox_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F4' ,sprintf('%.2f', $openbox_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G4' ,sprintf('%.2f', $openbox_rfs_val_percent));
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B5' ,$prexo_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C5' ,$prexo_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D5' ,$prexo_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E5' ,$prexo_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F5' ,sprintf('%.2f', $prexo_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G5' ,sprintf('%.2f', $prexo_rfs_val_percent));
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B6' ,$buyback_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C6' ,$buyback_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D6' ,$buyback_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E6' ,$buyback_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F6' ,sprintf('%.2f', $buyback_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G6' ,sprintf('%.2f', $buyback_rfs_val_percent));
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B7' ,$new_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C7' ,$new_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D7' ,$new_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E7' ,$new_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F7' ,sprintf('%.2f', $new_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G7' ,sprintf('%.2f', $new_rfs_val_percent));
			
			
			$objPHPExcel->getActiveSheet()->SetCellValue('B8' ,$others_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('C8' ,$others_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('D8' ,$others_rfs_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('E8' ,$others_rfs_value);
			$objPHPExcel->getActiveSheet()->SetCellValue('F8' ,sprintf('%.2f', $others_rfs_qty_percent));
			$objPHPExcel->getActiveSheet()->SetCellValue('G8' ,sprintf('%.2f', $others_rfs_val_percent));
			
        
			//$objSheet->getStyle('K' . $rowCount . ':O' . $rowCount)->getFont()->setBold(true)->setSize(10);
           
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = 'Closing_stock_report_as_on ' . $prev_date;
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $file_name . '.xlsx"');
        $objWriter->save('php://output');
        die;
    }
    
    public function createSpareAuditReport(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        
		$audit_date = date('Y-m-d');
		$data1 = $data[0];
		$rows = $data1['rows'];
        $audit_type = $data[0]['type'];
        $current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr($audit_type, 0, 3);
        $series = $string.$current_year.$next_year;

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(report_no,"-",-1) as UNSIGNED)) as max')
		->like('report_no',$series)->from('tbl_audit_reports')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }
        $report_no = $series."-".$next_number;
        $header_arr = array(
            "report_no" => $report_no,
            "report_type" => $audit_type,
            "quantity" => COUNT($rows),
            "audit_date" => $audit_date,
            "created_by" => $this->session->userdata('user_id')            
            );
        $this->db->insert('tbl_audit_reports', $header_arr);
        $insert_id = $this->db->insert_id();
        $error = $this->db->error();
        
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }
        $row_arr = [];
        foreach($rows as $row_val){
            $row_arr[] = array(
                "report_id" => $insert_id,
                "spare_item_no" => $row_val['spare_item_no'],
                "spare_source" => $row_val['spare_source'],
		"spare_name" => $row_val['spare_name'],
                "spare_brand" => $row_val['spare_brand'],
                "spare_color" => $row_val['spare_color'],
                "device_model" => $row_val['device_model'],
                "cost_price" => $row_val['cost_price'],
		"status" => $row_val['status'],
                "inward_date" => $row_val['inward_date']
                );
        }
        $this->db->insert_batch('tbl_audit_report_items', $row_arr);
        
        $error = $this->db->error();
        
        if($error['code']==0){
				$data['status']=1;
			}else{
				$data['status']=0;
			}
        
        echo json_encode($data);
		
        //$this->db->trans_complete();
        exit;
    }

	public function getAuditReportList() {

        $report_type = $this->input->get('report_type');
		$report_data = $this->db->get_where('tbl_audit_reports', array("report_type" => $report_type))->result();
        
        if (empty($report_data)) {
            $json['status'] = 0;
	    $json['data'] =array();
            echo json_encode($json);
            die;
        }
        $json['data'] = $report_data;
		$json['status'] = 0;
		echo json_encode($json);
        exit;
    }

    public function dowloadAuditReportItems()
    {

        $report_id = $this->input->get('report_id');
        
        if( (int) $report_id <=0){

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
		$report_data = $this->db->get_where('tbl_audit_reports', array("report_id" => $report_id))->row();
		$report_no = $report_data->report_no;
		$report_type = $report_data->report_type;
		if($report_type == "STOCK"){
			$tbl_name = "tbl_stock_audit_report_items";
			$csv_output = "DEVICE ID, PRODUCT TYPE, CATEGORY, SUB CATEGORY, IS P2P, STOCK SUB TYPE, WAREHOUSE, PURCHASE DATE, PROC COST, GST, STATUS, BIN NO, VRP NO, WSN NO, REMARK";
			
		} else if($report_type == "JOBSHEET"){
			$tbl_name = "tbl_jobsheet_audit_report_items";
			$csv_output = "JOBSHEET NO, SERVICE TYPE, REFERENCE BY, BRAND, DEVICE NAME, RAM, ROM, STATUS, CREATED DATE";
		}
		else{
			$tbl_name = "tbl_audit_report_items";
			$csv_output = "SPARE ITEM NO, SPARE SOURCE, SPARE NAME, SPARE BRAND, SPARE COLOR, DEVICE MODEL, COST PRICE, STATUS, INWARD DATE";
		}
        
        $result = $this->db->get_where($tbl_name, array("report_id" => $report_id))->result_array();
		//print_r($result); exit;
        $csv_output .= "\n";

        if (!empty($result)) {
			if($report_type == "STOCK"){
				foreach ($result as $periodic_report) {

							$csv_output .= $periodic_report['device_id'] . ",";
							$csv_output .= $periodic_report['product_type'] . ",";
							$csv_output .= $periodic_report['category'] . ",";
							$csv_output .= $periodic_report['sub_category'] . ",";
							$csv_output .= $periodic_report['is_p2p'] . ",";
							$csv_output .= $periodic_report['stock_subtype'] . ",";
							$csv_output .= $periodic_report['warehouse'] . ",";
							$csv_output .= $periodic_report['purchase_date'] . ",";
							$csv_output .= $periodic_report['proc_cost'] . ",";
					$csv_output .= $periodic_report['gst'] . ",";
							$csv_output .= $periodic_report['status'] . ",";
							$csv_output .= $periodic_report['bin_no'] . ",";
							$csv_output .= $periodic_report['vrp_no'] . ",";
							$csv_output .= $periodic_report['wsn_no'] . ",";
					$csv_output .= $periodic_report['remark'] . ",";
					
							$csv_output .= "\n";
						}
			}else if($report_type == "JOBSHEET"){

				foreach ($result as $periodic_report) {

							$csv_output .= $periodic_report['jobsheet_no'] . ",";
							$csv_output .= $periodic_report['service_type'] . ",";
							$csv_output .= $periodic_report['reference_by'] . ",";
							$csv_output .= $periodic_report['brand'] . ",";
							$csv_output .= $periodic_report['device_name'] . ",";
							$csv_output .= $periodic_report['ram'] . ",";
							$csv_output .= $periodic_report['rom'] . ",";
							$csv_output .= $periodic_report['status'] . ",";
							$csv_output .= $periodic_report['created_date'] . ",";
					
							$csv_output .= "\n";
						}	
			}else{
				foreach ($result as $periodic_report) {

							$csv_output .= $periodic_report['spare_item_no'] . ",";
							$csv_output .= $periodic_report['spare_source'] . ",";
							$csv_output .= $periodic_report['spare_name'] . ",";
							$csv_output .= $periodic_report['spare_brand'] . ",";
							$csv_output .= $periodic_report['spare_color'] . ",";
							$csv_output .= $periodic_report['device_model'] . ",";
							$csv_output .= $periodic_report['cost_price'] . ",";
							$csv_output .= $periodic_report['status'] . ",";
							$csv_output .= $periodic_report['inward_date'] . ",";
					
							$csv_output .= "\n";
						}
			}
        }
	
        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $filename = $report_no."_items_list";
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;
    }

    public function createStockAuditReport(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        
		$audit_date = date('Y-m-d');
		$data1 = $data[0];
		$rows = $data1['rows'];
        $audit_type = $data[0]['type'];
        $current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr($audit_type, 0, 3);
        $series = $string.$current_year.$next_year;

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(report_no,"-",-1) as UNSIGNED)) as max')
				->like('report_no',$series)->from('tbl_audit_reports')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }
        $report_no = $series."-".$next_number;
        $header_arr = array(
            "report_no" => $report_no,
            "report_type" => $audit_type,
            "quantity" => COUNT($rows),
            "audit_date" => $audit_date,
            "created_by" => $this->session->userdata('user_id')            
            );
        $this->db->insert('tbl_audit_reports', $header_arr);
        $insert_id = $this->db->insert_id();
        $error = $this->db->error();
        
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }
        $row_arr = [];
        foreach($rows as $row_val){
            $row_arr[] = array(
                "report_id" => $insert_id,
                "device_id" => $row_val['device_id'],
                "product_type" => $row_val['product_type'],
		"category" => $row_val['category'],
                "sub_category" => $row_val['sub_category'],
                "is_p2p" => $row_val['is_p2p'],
                "stock_subtype" => $row_val['stock_subtype'],
                "warehouse" => $row_val['warehouse'],
		"purchase_date" => $row_val['purchase_date'],
                "proc_cost" => $row_val['proc_cost'],
		"gst" => $row_val['gst'],
                "status" => $row_val['status'],
                "bin_no" => $row_val['bin_no'],
                "vrp_no" => $row_val['vrp_no'],
		"wsn_no" => $row_val['wsn_no'],
                "remark" => $row_val['remark']
                );
        }
        $this->db->insert_batch('tbl_stock_audit_report_items', $row_arr);
        
        $error = $this->db->error();
        
        if($error['code']==0){
				$data['status']=1;
			}else{
				$data['status']=0;
			}
        
        echo json_encode($data);
		
        //$this->db->trans_complete();
        exit;
    }
	
    public function downloadJobsheetAvailableReport()
	{
    		
	   $csv_output = "Jobsheet No, Service Type, Reference By, Brand, Device Name, RAM, ROM, Status, Created Date";
    		
    	    $query = "SELECT jobsheet_no, service_type, reference_by, brand_name, model_name, ram, rom, status, DATE(created_date) as created_date FROM ynewco_triage.`JOBSHEET_LIST_VIEW` WHERE status NOT IN ('RWR','INVOICED') GROUP BY jobsheet_id";
    		$result = $this->db->query($query)->result_array();
    
            $csv_output .= "\n";
    		if (!empty($result)) {
    			foreach ($result as $value) {
    				$csv_output .= $value['jobsheet_no'] . ",";
    				$csv_output .= $value['service_type'] . ",";
    				$csv_output .= $value['reference_by'] . ",";
    				$csv_output .= $value['brand_name'] . ",";
    				$csv_output .= $value['model_name'] . ",";
    				$csv_output .= $value['ram'] . ",";
    				$csv_output .= $value['rom'] . ",";
    				$csv_output .= $value['status'] . ",";
    				$csv_output .= $value['created_date'] . ",";
    				$csv_output .= "\n";
    			}
    		}
    		$filename = "jobsheet_available_report_as_on" . "_" . date("Y-m-d_H-i", time());
    		header("Content-type: application/csv");
    		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
    		header("Content-disposition: filename=" . $filename . ".csv;");
    		print $csv_output;
    		exit;
    }
	
    public function createJobsheetAuditReport(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        
		$audit_date = date('Y-m-d');
		$data1 = $data[0];
		$rows = $data1['rows'];
        $audit_type = $data[0]['type'];
        $current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr($audit_type, 0, 3);
        $series = $string.$current_year.$next_year;

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(report_no,"-",-1) as UNSIGNED)) as max')
				->like('report_no',$series)->from('tbl_audit_reports')->get()->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }
        $report_no = $series."-".$next_number;
        $header_arr = array(
            "report_no" => $report_no,
            "report_type" => $audit_type,
            "quantity" => COUNT($rows),
            "audit_date" => $audit_date,
            "created_by" => $this->session->userdata('user_id')            
            );
        $this->db->insert('tbl_audit_reports', $header_arr);
        $insert_id = $this->db->insert_id();
        $error = $this->db->error();
        
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json_arr['status'] = 0;
            $json_arr['message'] = $error['message'];
            echo json_encode($json_arr);
            exit;
        }
        $row_arr = [];
        foreach($rows as $row_val){
            $row_arr[] = array(
                "report_id" => $insert_id,
                "jobsheet_no" => $row_val['jobsheet_no'],
                "service_type" => $row_val['service_type'],
		"reference_by" => $row_val['reference_by'],
                "brand" => $row_val['brand'],
                "device_name" => $row_val['device_name'],
                "ram" => $row_val['ram'],
                "rom" => $row_val['rom'],
		"status" => $row_val['status'],
                "created_date" => $row_val['created_date']
                );
        }
        $this->db->insert_batch('tbl_jobsheet_audit_report_items', $row_arr);
        
        $error = $this->db->error();
        
        if($error['code']==0){
				$data['status']=1;
			}else{
				$data['status']=0;
			}
        
        echo json_encode($data);
		
        //$this->db->trans_complete();
        exit;
    }
	
}
