<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Receipt extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('auditlog_model');
    }

    public function manage_receipt($active = 0){
        $data['active'] = 1;

        if($active > 0){
            $data['active'] = $active;
        }

        $data['title'] = 'RECEIPT';
        $data['subview'] = $this->load->view('admin/receipt/manage_receipt', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function addReceipt(){
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $receipt_data = $data['receipt_data'];
        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
	    $vendor_code = trim($data["vendor_id"]);
        $checkVendor = $this->db->select('vendor_id')->from('tbl_vendor')->where('vendor_code', $vendor_code)->get();
        if($checkVendor->num_rows() < 1){
            $json['status'] = 2;
            echo json_encode($json);
            exit;
        }
        $vendor_id = $checkVendor->row()->vendor_id;
        $this-$this->db->trans_start();
        foreach($receipt_data as $key => $receiptData){
            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(receipt_no,"-",-1) as UNSIGNED)) as max')->from('tbl_receipt')->get()->row_array();
            $next_number = $res['max']+1;
            $receipt_no = 'RCPT-'.$next_number;
            $insert_arr = array(
                        "receipt_no" => $receipt_no,
                        //"vendor_id"  => $data["vendor_id"],
    		            "vendor_id"  => $vendor_id,
                        "receipt_type" => $receiptData["receipt_type"],
                        "account_no" => $receiptData["account_no"],
                        "received_or_verified_by" => $receiptData["received_by"],
                        "reference_no" => $receiptData["reference_no"],
                        "received_amount" => $receiptData["received_amount"],
                        "received_date" => $receiptData["received_date"],
                        "CREATED_BY" => $this->session->userdata('user_id'),
                        "CREATION_DATE" => date("Y-m-d H:i:s")
                    );
                    $this->db->insert('tbl_receipt', $insert_arr);
                    $receipt_id = $this->db->insert_id();
                //echo "ID - ".$receipt_id; exit;
                if($receiptData['generate_voucher'] == 'yes'){
                    
                    // Generate 8 character random string and add it to the UNIX timestamp
                    $random_string = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 8).time();
                    $voucher_no = strtoupper(substr(md5($random_string),0,8));
                    $voucher_valid = 'Y';
                    $update_arr = array(
                        "voucher_no" => $voucher_no,
                        "voucher_valid" => $voucher_valid
                        );
                        $this->db->where('receipt_id', $receipt_id)->update('tbl_receipt',$update_arr);
                }
                // Insert audit log for Receipt
                $insert_array=array(
                    "reference_id"=>$receipt_id,
                    "user_id"=>$this->session->userdata('user_id'),
                    "reference_type"=>'receipt',
                    "status"=>'CREATED',
                    "date"=>date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_audit_log',$insert_array);
                $error = $this->db->error();
                //print_r($error); exit;
                if($error['code'] != 0){
                    $this->db->trans_rollback();
                    $json['status'] = 0;
                    echo json_encode($json);
                    exit;
                }
            }
            $this->db->trans_complete();
            $json['status'] = 1;
            echo json_encode($json);
            exit;
        
    }

    public function addMultipleReceipt(){
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data) || empty($data['receipt_details']) || empty($data['salesorder_id'])){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $salesorder_id = $data['salesorder_id'];

        if( (int) $salesorder_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $receipt_detals = $data['receipt_details'];
        $receipts = [];
        
        foreach($receipt_detals as $receipt_row){
            $receipts[] = array(                 
                            'receipt_id' => $receipt_row['receipt_id'],
                            'vendor_id' => $receipt_row['vendor_id'],
                            'salesorder_id' => $salesorder_id,
                            'receipt_amount' => $receipt_row['receipt_amount'],
                            'salesorder_amount' => $receipt_row['salesorder_amount'],
                            'adjusted_amount' => $receipt_row['adjusted_amount'],
                            'CREATED_BY' => $this->session->userdata('user_id')
                        );
        }
                    
        $this->db->insert_batch('tbl_receipt_so', $receipts);
        $error = $this->db->error();

        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getReceiptList(){
        $result = $this->db->get('RECEIPT_LIST_VIEW')->result_array();
        $records = array();

        foreach ($result as $rowValue){
            $this->db->where('receipt_id', $rowValue['receipt_id']);
            $so_det = $this->db->get('tbl_receipt_so')->result_array();
            $salesorder_no = '';
            $invoice_no = '';
            
            foreach($so_det as $row){
                $this->db->select('tbl_salesorder.salesorder_code, tbl_invoice.invoice_code');
                $this->db->where('tbl_salesorder.salesorder_id', $row['salesorder_id']);
                $this->db->join('tbl_invoice', 'tbl_invoice.salesorder_id = tbl_salesorder.salesorder_id');
                $codes = $this->db->get('tbl_salesorder')->row();
                $salesorder_no = $codes->salesorder_code;  
                $invoice_no = $codes->invoice_code;  
            }
            
            $records[] = array(
                "receipt_id" => $rowValue["receipt_id"],
                "receipt_no" => $rowValue['receipt_no'],
                "salesorder_code" => $salesorder_no,
                "invoice_code" => $invoice_no,
                "vendor_id"  => $rowValue["vendor_id"],
                "vendor_name"  => $rowValue["vendor_name"],
                "receipt_type" => $rowValue["receipt_type"],
                "account_no" => $rowValue["account_no"],
                "voucher_no" => $rowValue["voucher_no"],
                "voucher_valid" => (!empty($rowValue['voucher_no']))?(($rowValue["voucher_valid"] == 'Y') ? 'Yes' : 'No'):'',
                "received_by" => $rowValue["received_or_verified_by"],
                "reference_no" => $rowValue["reference_no"],
                "received_amount" => $rowValue["received_amount"],
                "adjusted_amount" => $rowValue["adjusted_amount"],
                "adjusted_count" => $rowValue["adjusted_count"],
                "received_date" => $rowValue["received_date"],
                "CREATED_BY" => $rowValue['created_by'],
                "LAST_UPDATED_BY" => $rowValue['last_updated_by'],
                "CREATION_DATE" => date("d-m-Y", strtotime($rowValue['CREATION_DATE'])),
                "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($rowValue['LAST_UPDATE_DATE'])),
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    function editReceiptForm($receipt_id){
        $data['title'] = "Edit Receipt";
        
        if(empty($receipt_id) || (int) $receipt_id <= 0){
            $data['active'] = 1;
        }else{
            $data['active'] = 7;
        }

        $data['edit_receipt_id'] = $receipt_id;
        $data['subview'] = $this->load->view('admin/receipt/manage_receipt', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function getEditReceiptData()
    {
        $receipt_id = $this->input->get('receipt_id');

        if(empty($receipt_id) || (int) $receipt_id <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $data = $this->db->get_where('tbl_receipt', array('receipt_id' => $receipt_id))->row_array();
        $json['status'] = 1;
        $json['result'] = $data;
        echo json_encode($json);
        exit;
    }


    public function getSalesorderVendorId(){
        $salesorder_id = $this->input->get('salesorder_id');

        if(empty($salesorder_id) || (int) $salesorder_id <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->select('vendor_id')->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

        if(empty($result)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        $json['vendor_id'] = $result->vendor_id;
        echo json_encode($json);
        exit;
    }

    public function getReceiptDataByVendor(){
        $vendor_id = $this->input->get('vendor_id');

        if(empty($vendor_id) || (int) $vendor_id <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('vendor_id', $vendor_id)->order_by('received_date','DESC')->get('RECEIPT_LIST_VIEW')->result_array();

        if(empty($result)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach($result as $rowValue){
            $records[] = array(
                            "receipt_id" => $rowValue['receipt_id'],
                            "receipt_no" => $rowValue['receipt_no'],
                            "received_amount" => $rowValue['received_amount'],
                            "adjusted_amount" => $rowValue['adjusted_amount'],
                            "received_date" => date("d-m-Y", strtotime($rowValue['received_date']))
                        );
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getReceiptHeader(){
        $receipt_id = $this->input->get('receipt_id');

        if(empty($receipt_id)){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $result = $this->db->where('receipt_id', $receipt_id)->get('RECEIPT_LIST_VIEW')->row();
        $records = array(
                    "receipt_id" => $result->receipt_id,
                    "receipt_no" => $result->receipt_no,
                    "vendor_id"  => $result->vendor_id,
                    "vendor_name"  => $result->vendor_name,
                    "receipt_type" => $result->receipt_type,
                    "account_no" => $result->account_no,
                    "received_by" => $result->received_or_verified_by,
                    "reference_no" => $result->reference_no,
                    "voucher_no" => $result->voucher_no,
                    "voucher_valid" => $result->voucher_valid,
                    "received_amount" => $result->received_amount,
                    "adjusted_amount" => $result->adjusted_amount,
                    "received_date" => date("d-m-Y", strtotime($result->received_date)),
                    "CREATED_BY" => $result->created_by,
                    "LAST_UPDATED_BY" => $result->last_updated_by,
                    "CREATION_DATE" => date("d-m-Y", strtotime($result->CREATION_DATE)),
                    "LAST_UPDATE_DATE" => date("d-m-Y", strtotime($result->LAST_UPDATE_DATE)),
                );

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function viewReceiptsVendorwise(){
        $vendor_id = $this->input->get('vendor_id');

        if( (int) $vendor_id <= 0){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }

        $this->db->where('SALESORDER_RECEIPT_VIEW.vendor_id', $vendor_id);
        $this->db->from('SALESORDER_RECEIPT_VIEW');
        
        $result = $this->db->get()->result_array();
        $rows = array();

        if(!empty($result)){
            foreach($result as $rowValue){
                $received_date = date("d-m-Y", strtotime($rowValue["received_date"]));
                
                if($received_date == '01-01-1970'){
                    $received_date = '';
                }

                $rows[] = array(
                    "salesorder_id" => $rowValue["salesorder_id"],
                    "salesorder_code" => $rowValue["salesorder_code"],
                    "receipt_type" => $rowValue["receipt_type"],
                    "receipt_no" => $rowValue["receipt_no"],
                    "status" => str_replace('_',' ',$rowValue["status"]),
                    "account_no" => $rowValue["account_no"],
                    "received_by" => $rowValue["received_or_verified_by"],
                    "reference_no" => $rowValue["reference_no"],
                    "received_date" => $received_date,
                    "received_amount" => $rowValue["received_amount"],
                    "adjusted_amount" => $rowValue["adjusted_amount"],
                    "total_amount" => $rowValue["total_amount"],
                    "creation_date" => date("d-m-Y", strtotime($rowValue["CREATION_DATE"])),
                );
            }
        }

        $json["data"] = $rows;
        echo json_encode($json);
        exit;
    }

    public function getSalesorderList(){
        $status = $this->input->get('status');
        $saletype = $this->input->get('saletype');

        if($saletype == 'OFFLINE'){
            $this->db->where('sales_channel', 'OFFLINE');
        }

        if($saletype == 'ONLINE'){
            $this->db->where('sales_channel !=', 'OFFLINE');
        }

        if($status != ''){
            $this->db->where('status', $status);
        }

        $result = $this->db->get('PAYMENT_SALESORDER_LIST_VIEW')->result_array();
        $rows = array();

        if(!empty($result)){
            foreach($result as $rowValue){
                $rows[] = array(
                    "salesorder_id" => $rowValue["salesorder_id"],
                    "salesorder_code" => $rowValue["salesorder_code"],
                    "payment_mode" => $rowValue["payment_mode"],
                    "vendor_name" => $rowValue["vendor_name"],
                    "status" => str_replace('_',' ',$rowValue["status"]),
                    "sales_channel" => $rowValue["sales_channel"],
                    "saleschannel_ref_id" => $rowValue["saleschannel_ref_id"],
                    "creation_date" => date("d-m-Y", strtotime($rowValue["CREATION_DATE"])),
                    "total_amount" => $rowValue["total_amount"],
                );
            }
        }

        $json["data"] = $rows;
        echo json_encode($json);
        exit;
    }

    public function getSalesordersByVendor($vendor_id = 0){
		if((int) $vendor_id <= 0){
			$json["result"] = array();
			echo json_encode($json);
			die;
        }
        
        $this->db->select('SALESORDER_RECEIPT_VIEW.*, tbl_invoice.invoice_code, sum(adjusted_amount) as paid_amount');
		$this->db->join('tbl_invoice', 'tbl_invoice.salesorder_id = SALESORDER_RECEIPT_VIEW.salesorder_id', 'Left');
		$this->db->where('SALESORDER_RECEIPT_VIEW.vendor_id', $vendor_id);
        $result = $this->db->group_by('SALESORDER_RECEIPT_VIEW.salesorder_id')->get('SALESORDER_RECEIPT_VIEW')->result_array();
		
        $status_arr = ["CANCELED", "VOID","FINANCE_PENDING", "FINANCE_REJECTED", "WAREHOUSE_REJECTED","DRAFT"];
		$rows = array();

		if(!empty($result)){
			foreach($result as $rowValue){
				//SKIP if salesorder is in status_arr 
				if(in_array($rowValue['status'], $status_arr)){
					continue;
                }
                
				if(empty($rowValue['invoice_code'])){
					$invoice_code = '';
				}else{
					$invoice_code = $rowValue['invoice_code'];
                }

                $total_amount = $rowValue['total_amount'] - $rowValue['discount_amount'] + $rowValue['freight_amount'] + $rowValue['insurance_amount'] + $rowValue['tcs_amount'];

                // SKIP if SO was already paid
                if($total_amount <= $rowValue['paid_amount']){
                    continue;
                }

				$rows[] = array(
					"salesorder_id" => $rowValue["salesorder_id"],
					"salesorder_code" => $rowValue["salesorder_code"],
					"total_amount" => $total_amount,
					"status" => str_replace('_', ' ', $rowValue['status']),
					"invoice_no" => $invoice_code,
					"salesorder_date" => date("d-m-Y", strtotime($rowValue['CREATION_DATE']))
				);
			}
		}

		$json['result'] = $rows;
		echo json_encode($json);
		die;
	}

    public function getReceiptDetailsBySalesorder(){
        $salesorder_id = $this->input->get('salesorder_id');
        
        if( (int) $salesorder_id <= 0){
            $json['result'] = array();
            echo json_encode($json);
            exit;
        }

        $where = array(
                    "salesorder_id" => $salesorder_id,
                    "tbl_receipt_so.is_valid" => "Y"
                );
        $this->db->select('tbl_receipt.*, tbl_receipt_so.adjusted_amount');
        $this->db->where($where);
        $this->db->join('tbl_receipt_so', 'tbl_receipt.receipt_id = tbl_receipt_so.receipt_id', 'Left');
        $result = $this->db->get('tbl_receipt')->result_array();
        $records = array();

        foreach ($result as $rowValue){
            $records[] = array(
                "receipt_id" => $rowValue["receipt_id"],
                "receipt_no" => $rowValue['receipt_no'],
                "receipt_type" => $rowValue["receipt_type"],
                "account_no" => $rowValue["account_no"],
                "received_by" => $rowValue["received_or_verified_by"],
                "reference_no" => $rowValue["reference_no"],
                "received_amount" => $rowValue["received_amount"],
                "adjusted_amount" => $rowValue["adjusted_amount"],
                "received_date" => $rowValue["received_date"],
            );
        }

        $json["result"] = $records;
        echo json_encode($json);
        die;
    }

    public function getSalesordersByReceipt(){
        $receipt_id = $this->input->get('receipt_id');

        if( (int) $receipt_id <= 0){
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
        $this->db->where('SALESORDER_RECEIPT_VIEW.receipt_id', $receipt_id);
        $this->db->from('SALESORDER_RECEIPT_VIEW');
        $result = $this->db->get()->result_array();
        $rows = array();

        if(!empty($result)){
            foreach($result as $rowValue){
                $received_date = date("d-m-Y", strtotime($rowValue["received_date"]));
                
                if($received_date == '01-01-1970'){
                    $received_date = '';
                }

                $rows[] = array(
                    "salesorder_id" => $rowValue["salesorder_id"],
                    "salesorder_code" => $rowValue["salesorder_code"],
                    "vendor_name" => $rowValue["vendor_name"],
                    "receipt_type" => $rowValue["receipt_type"],
                    "receipt_no" => $rowValue["receipt_no"],
                    "status" => str_replace('_',' ',$rowValue["status"]),
                    "account_no" => $rowValue["account_no"],
                    "received_by" => $rowValue["received_or_verified_by"],
                    "reference_no" => $rowValue["reference_no"],
                    "received_date" => $received_date,
                    "received_amount" => $rowValue["received_amount"],
                    "adjusted_amount" => $rowValue["adjusted_amount"],
                    "total_amount" => $rowValue["total_amount"],
                    "creation_date" => date("d-m-Y", strtotime($rowValue["CREATION_DATE"])),
                );
            }
        }

        $json["result"] = $rows;
        echo json_encode($json);
        exit;
    }

    public function getSalesorderDetails_ecom(){
        $saleschannel_ref_id = $this->input->get('saleschannel_ref_id');

        if(empty($saleschannel_ref_id)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $where = array(
                    "saleschannel_ref_id" => $saleschannel_ref_id
                );
        $this->db->where($where);
        $rowValue = $this->db->get('SALESORDER_LIST_VIEW')->row_array();
        $rows = array();

        if(!empty($rowValue)){
            $rows = array(
                "salesorder_id" => $rowValue["salesorder_id"],
                "salesorder_code" => $rowValue["salesorder_code"],
                "payment_mode" => $rowValue["payment_mode"],
                "invoice_code" => $rowValue['invoice_code'],
                "vendor_name" => $rowValue["vendor_name"],
                "vendor_id" => $rowValue["vendor_id"],
                "status" => str_replace('_',' ',$rowValue["status"]),
                "sales_channel" => $rowValue["sales_channel"],
                "saleschannel_ref_id" => $rowValue["saleschannel_ref_id"],
                "creation_date" => date("d-m-Y", strtotime($rowValue["CREATION_DATE"])),
                "total_amount" => $rowValue["total_amount"],
            );

            $result = $this->db->select('receipt_so_id')->where('salesorder_id', $rowValue['salesorder_id'])->get('tbl_receipt_so')->row();

            if($result->receipt_so_id > 0){
                $json['status'] = 0;
                $json['message'] = 'Receipt Already Exists for '.$rowValue['salesorder_code'];
                echo json_encode($json);
                exit;
            }
        }
        $json['status'] = 1;
        $json["result"] = $rows;
        echo json_encode($json);
        exit;
    }

    public function addReceiptEcom(){
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(receipt_no,"-",-1) as UNSIGNED)) as max')->from('tbl_receipt')->get()->row_array();
        $next_number = $res['max']+1;
        $receipt_no = 'RCPT-'.$next_number;

        $record = array(
                    "receipt_no" => $receipt_no,
                    "vendor_id"  => $data["vendor_id"],
                    "receipt_type" => $data["receipt_type"],
                    "account_no" => $data["account_no"],
                    "received_or_verified_by" => $data["received_by"],
                    "reference_no" => $data["reference_no"],
                    "received_amount" => $data["received_amount"],
                    "received_date" => $data["received_date"],
                    "CREATED_BY" => $this->session->userdata('user_id'),
                    "CREATION_DATE" => date("Y-m-d H:i:s")
                );
        
        $this->db->trans_start();

        $this->db->insert( 'tbl_receipt', $record);
        $receipt_id = $this->db->insert_id();
        $error = $this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $salesorder_id = $data['salesorder_id'];

        if( (int) $salesorder_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $receipts = array(                 
                        'receipt_id' => $receipt_id,
                        'vendor_id' => $data['vendor_id'],
                        'salesorder_id' => $salesorder_id,
                        'receipt_amount' => $data['received_amount'],
                        'salesorder_amount' => $data['remittance_amount'],
                        'adjusted_amount' => $data['received_amount'],
                        'CREATED_BY' => $this->session->userdata('user_id')                    
                    );
                    
        $this->db->insert('tbl_receipt_so', $receipts);
        $error = $this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $breakdown_array = array(
                            'receipt_id' => $receipt_id,
                            "commission_fee" => $data["commission_fee"],
                            "commission_fee_tax" => $data["commission_fee_tax"],
                            "commission_fee_total_amount" => $data["commission_fee_total_amount"],
                            "fixed_closing_fee" => $data["fixed_closing_fee"],
                            "fixed_closing_fee_tax" => $data["fixed_closing_fee_tax"],
                            "fixed_closing_fee_total_amount" => $data["fixed_closing_fee_total_amount"],
                            "collection_fee" => $data["collection_fee"],
                            "collection_fee_tax" => $data["collection_fee_tax"],
                            "collection_fee_total_amount" => $data["collection_fee_total_amount"],
                            "pick_pack_fee" => $data["pick_pack_fee"],
                            "pick_pack_fee_tax" => $data["pick_pack_fee_tax"],
                            "pick_pack_fee_total_amount" => $data["pick_pack_fee_total_amount"],
                            "weight_handling_fee" => $data["weight_handling_fee"],
                            "weight_handling_fee_tax" => $data["weight_handling_fee_tax"],
                            "weight_handling_fee_total_amount" => $data["weight_handling_fee_total_amount"],
                            "courier_fee" => $data["courier_fee"],
                            "courier_fee_tax" => $data["courier_fee_tax"],
                            "courier_fee_total_amount" => $data["courier_fee_total_amount"],
                            "f1_services_fee" => $data["f1_services_fee"],
                            "f1_services_fee_tax" => $data["f1_services_fee_tax"],
                            "f1_services_fee_total_amount" => $data["f1_services_fee_total_amount"],
                            "tcs_fee" => $data["tcs_fee"],
                            "remittance_amount" => $data["remittance_amount"],
                            "created_by" => $this->session->userdata('user_id'),
                            "creation_date" => date("Y-m-d H:i:s")
                        );

        $this->db->insert('tbl_receipt_breakdown', $breakdown_array);
        $error = $this->db->error();

        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        // Insert audit log for Receipt
        $this->auditlog_model->insert_auditlog($receipt_id,'receipt','CREATED',$this->session->userdata('user_id'));

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getEcomBreakdown(){
        $receipt_id = $this->input->get('receipt_id');

        if(empty($receipt_id) || (int)$receipt_id <=0 ){
            $json['status'] = 0;
            json_encode($json);
            exit;
        }

        $result = $this->db->where('receipt_id', $receipt_id)->get('tbl_receipt_breakdown')->row();
        $error = $this->db->error();

        if(empty($result) || $error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $record = array(
                "commission_fee" => number_format($result->commission_fee,2),
                "commission_fee_tax" => number_format($result->commission_fee_tax,2),
                "commission_fee_total" => $result->commission_fee_total_amount,
                
                "fixed_closing_fee" => number_format($result->fixed_closing_fee,2),
                "fixed_closing_fee_tax" => number_format($result->fixed_closing_fee_tax,2),
                "fixed_closing_fee_total" => number_format($result->fixed_closing_fee_total_amount,2),
                
                "collection_fee" => number_format($result->collection_fee,2),
                "collection_fee_tax" => number_format($result->collection_fee_tax,2),
                "collection_fee_total" => number_format($result->collection_fee_total_amount,2),
                
                "pick_pack_fee" => number_format($result->pick_pack_fee,2),
                "pick_pack_fee_tax" => number_format($result->pick_pack_fee_tax,2),
                "pick_pack_fee_total" => number_format($result->pick_pack_fee_total_amount,2),
                
                "weight_handling_fee" => number_format($result->weight_handling_fee,2),
                "weight_handling_fee_tax" => number_format($result->weight_handling_fee_tax,2),
                "weight_handling_fee_total" => number_format($result->weight_handling_fee_total_amount,2),
                
                "courier_fee" => number_format($result->courier_fee,2),
                "courier_fee_tax" => number_format($result->courier_fee_tax,2),
                "courier_fee_total" => number_format($result->courier_fee_total_amount,2),
                
                "f1_services_fee" => number_format($result->f1_services_fee,2),
                "f1_services_fee_tax" => number_format($result->f1_services_fee_tax,2),
                "f1_services_fee_total" => number_format($result->f1_services_fee_total_amount,2),

                "tcs_fee"=> number_format($result->tcs_fee,2),
                "tcs_fee_tax" => number_format(0,2),
                "tcs_fee_total" => number_format($result->tcs_fee,2),
                "remittance_amount" => number_format($result->remittance_amount, 2)
            );

        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }


    public function downloadCsvgetReceiptList()
	{
        $from_date = $this->input->get('from_date');
        $to_date = $this->input->get('to_date');

        if (empty($from_date) || empty($to_date)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_check_arr = explode('-', $from_date);
        $to_check_arr = explode('-', $to_date);

        if (!checkdate($from_check_arr[1], $from_check_arr[2], $from_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid From Date';
            echo json_encode($json);
            exit;
        }

        if (!checkdate($to_check_arr[1], $to_check_arr[2], $to_check_arr[0])) {
            $json['status'] = 0;
            $json['message'] = 'Invalid To Date';
            echo json_encode($json);
            exit;
        }
 
		$csv_output = "Receipt No, Receipt Type, Invoice No, SalesOrder no, Customer Name, Account Number, Verified By,";
		$csv_output .= "Reference Number, Recevied Amount, Adjusted Amount, Recevied Date, Created By, Created Date";

		if ($from_date != '') {
			$this->db->where("DATE(received_date) >=", date("Y-m-d", strtotime($from_date)));
		}

		if ($to_date != '') {
			$this->db->where("DATE(received_date) <=", date("Y-m-d", strtotime($to_date)));
		}

		$result = $this->db->get('RECEIPT_LIST_VIEW')->result_array();

		$csv_output .= "\n";
		if (!empty($result)) {
			foreach ($result as $value) {
                $this->db->where('receipt_id', $value['receipt_id']);
                $so_det = $this->db->get('tbl_receipt_so')->result_array();
                $salesorder_no = '';
                $invoice_no = '';

                foreach($so_det as $row){
                    $this->db->select('tbl_salesorder.salesorder_code, tbl_invoice.invoice_code');
                    $this->db->where('tbl_salesorder.salesorder_id', $row['salesorder_id']);
                    $this->db->join('tbl_invoice', 'tbl_invoice.salesorder_id = tbl_salesorder.salesorder_id');
                    $codes = $this->db->get('tbl_salesorder')->row();
                    $salesorder_no = $codes->salesorder_code;  
                    $invoice_no = $codes->invoice_code;  
                }
    
				$csv_output .= $value['receipt_no'] . ",";
				$csv_output .= $value['receipt_type'] . ",";
				$csv_output .= $invoice_no .",";
				$csv_output .= $salesorder_no . ",";
				$csv_output .= $value['vendor_name'] . ",";
				$csv_output .= $value['account_no'] . ",";
				$csv_output .= $value['received_or_verified_by'] . ",";
				$csv_output .= $value['reference_no'] . ",";
				$csv_output .= $value['received_amount'] . ",";
				$csv_output .= $value['adjusted_amount'] . ",";
				$csv_output .= $value['received_date'] . ",";
				$csv_output .= $value['created_by'] . ",";
				$csv_output .= $value['CREATION_DATE'] . ",";
				$csv_output .= "\n";
			}
		}

		$filename = "receiptList" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csv_output;
		exit;
	}

    function editReceipt(){
        $data = json_decode(file_get_contents('php://input'), true);
        $receipt_id = $data['receipt_id'];

        if(empty($receipt_id) || $receipt_id<=0){
            $json['status'] = 0;
            $json['message'] = 'Invalid Receipt Id';
        }

        $receipt_details = $this->db->select('adjusted_amount, voucher_no')->where('receipt_id', $receipt_id)->get('RECEIPT_LIST_VIEW')->row();

        if($receipt_details->adjusted_amount > 0){
            $json['status'] = 0;
            $json['message'] = 'Adjusted Receipt cannot be edited';
        }

        $update_array = array(
            'vendor_id' => $data['vendor_id'],
            'receipt_type' => $data['receipt_type'],
            'account_no' => $data['bank_account_id'],
            'received_amount' => $data['receipt_amount'],
            'received_or_verified_by' => $data['received_or_verified_by'],
            'reference_no' => $data['reference_no'],
            'received_date' => $data['receipt_date'],
            'LAST_UPDATED_BY' => $this->session->userdata('user_id'),
            'LAST_UPDATE_DATE' => date('Y-m-d H:i:s')
        );

        if($data['generate_voucher'] == 'yes' && empty($receipt_details->voucher_no)){
            // Generate 8 character random string and add it to the UNIX timestamp
            $random_string = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 8).time();
            $update_array['voucher_no'] = strtoupper(substr(md5($random_string),0,8));
            $update_array['voucher_valid'] = 'Y';
        }
        $this->db->where('receipt_id', $receipt_id)->update('tbl_receipt', $update_array);

        $error = $this->db->error();
        if($error['code'] != 0){
            $json['status'] = 0;
            $json['message'] = $error['message'];
        }

        $json['status'] = 1;
        $json['message'] = 'Receipt Updated Successfully';
        echo json_encode($json);
        exit;
    }
}