<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Purchase_return extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
	$this->load->library('hostbooks_authenticator');
    }

    public function manage_purchase_return($active = 0)
    {

        $data['active'] = 1;

        if ($active > 0) {
            $data['active'] = $active;
        }

        $data['title'] = 'PURCHASE RETURN';

        $data['subview'] = $this->load->view('admin/purchase_return/manage_purchase_return', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getPurchaseReturnList()
    {
        $status = $this->input->get('status');
        $purchase_return_id = $this->input->get('purchase_return_id');
        $records = array();

        if (empty($status) && empty($purchase_return_id)) {
            $json['status'] = 0;
            $json['data'] = $records;
            echo json_encode($json);
        }

        $this->db->where('status', $status);

        if (!empty($purchase_return_id)) {
            $this->db->where('purchase_return_id', $purchase_return_id);
        }

        $result = $this->db->get('PURCHASE_RETURN_VIEW')->result_array();
        foreach ($result as $rowValue) {
            $records[] = array(
                "purchase_return_id" => $rowValue['purchase_return_id'],
                "purchase_return_no" => $rowValue['purchase_return_no'],
                "status" => $rowValue['status'],
                "invoice_no" => $rowValue['invoice_no'],
                "vendor_id" => $rowValue['vendor_id'],
                "vendor_name" => $rowValue['vendor_name'],
                "invoice_id" => $rowValue['invoice_id'],
                "creditnote_no" => $rowValue['creditnote_no'],
                "creditnote_date" => date("d-m-Y", strtotime($rowValue['creditnote_date'])),
                "invoice_date" => date("d-m-Y", strtotime($rowValue['invoice_date'])),
                "return_type" => $rowValue['return_type'],
                "taxable_amount" => $rowValue['taxable_amount'],
                "exempt_amount" => $rowValue['exempt_amount'],
                "tax_amount" => $rowValue['tax_amount'],
                "total_amount" => $rowValue['total_amount'],
                "quantity" => $rowValue['quantity'],
                "created_by" => $rowValue['created_by'],
                "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
                "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date'])),
                "last_updated_by" => $rowValue['last_updated_by'],
            );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getPurchaseReturnItems()
    {

        $purchase_return_id = $this->input->get('purchase_return_id');

        $records = array();
        if ((int) $purchase_return_id <= 0) {
            $json['status'] = 0;
            $json['data'] = $records;
            echo json_encode($json);
            exit;
        }

        $this->db->where('purchase_return_id', $purchase_return_id);
        $result = $this->db->get('PURCHASE_RETURN_ITEM_VIEW')->result_array();

        foreach ($result as $rowValue) {
            $records[] = array(
                "purchase_return_item_id" => $rowValue['purchase_return_item_id'],
                "grnreport_id" => $rowValue['grnreport_id'],
                "nhdin" => $rowValue['nhdin'],
                "device_name" => $rowValue['device_name'] ? $rowValue['device_name'] : $rowValue['model_name'],
                "sku" => $rowValue['SKU'] ? $rowValue['SKU'] : $rowValue['sf_ram'] . '-' . $rowValue['sf_rom'].'-'.$rowValue['color'],
                "ram" => $rowValue['ram'] ? $rowValue['ram'] : $rowValue['sf_ram'],
                "rom" => $rowValue['rom'] ? $rowValue['rom'] : $rowValue['sf_rom'],
                "color" => $rowValue['color'] ? $rowValue['color'] : '',
                "ref_no" => $rowValue['ref_no'] ? $rowValue['ref_no'] : '',
                "status" => $rowValue['status'],
                "stock_type" => $rowValue['stock_type'],
                "taxable_amount" => $rowValue['taxable_amount'],
                "exempt_amount" => $rowValue['exempt_amount'],
                "tax_amount" => $rowValue['tax_amount'],
                "price" => $rowValue['price'],
                "quantity" => $rowValue['quantity'],
                "certification_remark" => $rowValue['certification_remark'],
                "remarks" => $rowValue['remarks'],
            );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function createPurchaseReturn()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if (empty($data['procurement_channel'])) {
            $json['status'] = 0;
            $json['message'] = 'Procurement channel is required';
            echo json_encode($json);
            exit;
        }

        if (empty($data['vendor_id'])) {
            $json['status'] = 0;
            $json['message'] = 'Vendor is required';
            echo json_encode($json);
            exit;
        }

        if (empty($data['invoice_id'])) {
            $json['status'] = 0;
            $json['message'] = 'Invoice is required';
            echo json_encode($json);
            exit;
        }

        $creditnote_date = date("Y-m-d", strtotime($data['creditnote_date']));

        if ($creditnote_date == '1970-01-01') {
            $json['status'] = 0;
            $json['message'] = 'Credit Note Date is Required';
            echo json_encode($json);
            exit;
        }

	$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr("HYD", 0, 1);
        $series = "DB".$string.$current_year.$next_year;

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(purchase_return_no,"-",-1) as UNSIGNED)) as max')->from('tbl_purchase_return')
        ->like('purchase_return_no',$series)
        ->get()->row_array();
        $next_number = $res['max'] + 1;
        //$purchase_return_no = 'DB-HYD-' . $next_number;
        $purchase_return_no=$series.'-'.$next_number;

        $headerArray = array(
            "purchase_return_no" => $purchase_return_no,
            "status" => "FINANCE_PENDING",
            "return_type" => $data['return_type'],
            "created_by" => $this->session->userdata('user_id'),
            "creation_date" => date("Y-m-d H:i:s"),
            "procurement_channel" => $data['procurement_channel'],
            "vendor_id" => $data['vendor_id'],
            "invoice_id" => $data['invoice_id'],
            "creditnote_no" => $data['creditnote_no'],
            "creditnote_date" => $data['creditnote_date'],
            "category" => $data['category'],
        );
        $this->db->trans_start();

        $this->db->insert('tbl_purchase_return', $headerArray);
        $error = $this->db->error();
        $purchase_return_id = $this->db->insert_id();

        if ($error['code'] != 0 || $purchase_return_id <= 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        foreach ($data['devices'] as $rowValue) {

            $item_array[] = array(
                "purchase_return_id" => $purchase_return_id,
                "device_id" => $rowValue['device_id'],
                "remarks" => $rowValue['remarks'],
                "quantity" => $rowValue['quantity']?$rowValue['quantity']:1,
                "color" => $rowValue['color']?$rowValue['color']:'',
                "ref_no" => $rowValue['ref_no']?$rowValue['ref_no']:'',
                "model_name" => $rowValue['model_name'],
                "ram" => $rowValue['ram'],
                "rom" => $rowValue['rom'],
            );
        }

        if (empty($item_array)) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->insert_batch('tbl_purchase_return_item', $item_array);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updatePurchaseReturnFinanceForm($purchase_return_id = 0)
    {
        $data['active'] = 1;
        if ((int) $purchase_return_id > 0) {
            $data['active'] = 3;
            $data['purchase_return_id_fin'] = $purchase_return_id;
        }

        $data['title'] = 'UPDATE PURCHASE RETURN';

        $data['subview'] = $this->load->view('admin/purchase_return/manage_purchase_return', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updatePurchaseReturnAdminForm($purchase_return_id = 0)
    {
        $data['active'] = 1;
        if ((int) $purchase_return_id > 0) {
            $data['active'] = 4;
            $data['purchase_return_id_admin'] = $purchase_return_id;
        }

        $data['title'] = 'UPDATE PURCHASE RETURN';

        $data['subview'] = $this->load->view('admin/purchase_return/manage_purchase_return', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updatePurchaseReturnFinance()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data['purchase_return_id'] <= 0 || empty($data['devices'])) {
            $json['message'] = 'Invalid data';
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('purchase_return_id', $data['purchase_return_id'])->get('tbl_purchase_return')->row();

        if ($result->status != 'FINANCE_PENDING') {
            $json['status'] = 0;
            $json['message'] = 'Purchase Return is not in Pending status';
            echo json_encode($json);
            exit;
        }

        if ($result->return_type == 'shortfall') {
            $status = 'CN_CREATED';
        } else {
            $status = 'ADMIN_PENDING';
        }


        if ($data['action'] == 'reject') {
            $status = 'FINANCE_REJECTED';
        }

        $headerArray = array(
            "status" => $status,
            "last_update_date" => date("Y-m-d H:i:s"),
            "last_updated_by" => $this->session->userdata('user_id')
        );

        $result = $this->db->where('purchase_return_id', $data['purchase_return_id'])->select('purchase_return_item_id')
            ->get('tbl_purchase_return_item')->result_array();
        $existing_ids = array();
        foreach ($result as $row) {
            $existing_ids[] = $row['purchase_return_item_id'];
        }
        $uploaded_ids = array();
        foreach($data['devices'] as $rowValue) {
            $item_array[] = array(
                "purchase_return_item_id" => $rowValue['item_id'],
                "price" => $rowValue['total_amount'],
                "taxable_amount" => $rowValue['taxable_amount'],
                "tax_amount" => $rowValue['tax_amount'],
                "exempt_amount" => $rowValue['exempt_amount'],
            );
            $uploaded_ids[] = $rowValue['item_id'];
        }

        $missing_ids = array_diff($existing_ids, $uploaded_ids);
        $non_existing_ids = array_diff($uploaded_ids, $existing_ids);

        if(!empty($missing_ids)) {
            $json['status'] = 0;
            $json['message'] = 'Some items are missing';
            echo json_encode($json);
            exit;
        }

        if(!empty($non_existing_ids)) {
            $json['status'] = 0;
            $json['message'] = 'Some extra items are uploaded';
            echo json_encode($json);
            exit;
        }

        $this->db->trans_start();

        $this->db->where('purchase_return_id', $data['purchase_return_id']);
        $this->db->update('tbl_purchase_return', $headerArray);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['message'] = 'Error in updating purchase return';
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->update_batch('tbl_purchase_return_item', $item_array, 'purchase_return_item_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['message'] = 'Error in updating purchase return items';
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
	
	$this->hostbooks_authenticator->postPurchaseReturn($data['purchase_return_id']);

        $this->db->trans_complete();

        if (!empty($data['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $data['purchase_return_id'],
                'reference_type' => 'purchase_return',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
        }
        $json['message'] = 'Successfully Updated Purchase Return';
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updatePurchaseReturnAdmin()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data['purchase_return_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('purchase_return_id', $data['purchase_return_id'])->get('tbl_purchase_return')->row();

        if ($result->status != 'ADMIN_PENDING') {
            $json['status'] = 0;
            $json['message'] = 'Purchase Return is not in Pending status';
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('purchase_return_id', $data['purchase_return_id'])->get('tbl_purchase_return_item')->result_array();

        foreach ($result as $rowValue) {
            $grnArray[] = array(
                "grnreport_id" => $rowValue['device_id'],
                "status" => 'RTV',
                "remark" => $rowValue['remarks'],
                "user_id" => $this->session->userdata('user_id'),
            );
        }

        if (empty($grnArray)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $headerArray = array(
            "status" => "CN_CREATED",
            "last_update_date" => date("Y-m-d H:i:s"),
            "last_updated_by" => $this->session->userdata('user_id')
        );

        $this->db->trans_start();

        $this->db->where('purchase_return_id', $data['purchase_return_id']);
        $this->db->update('tbl_purchase_return', $headerArray);

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->update_batch('tbl_grnreport', $grnArray, 'grnreport_id');

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        if (!empty($data['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $data['purchase_return_id'],
                'reference_type' => 'purchase_return',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
        }
        $json['status'] = 1;
        $json['message'] = 'Successfully Updated Purchase Return';
        echo json_encode($json);
        exit;
    }

    public function getVendorInvoices()
    {
        $supplier_id = $this->input->get('supplier_id');

        $result = $this->db->where('supplier_id', $supplier_id)->get('tbl_security_admin')->result_array();
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            $json['message'] = $error['message'];
            echo json_encode($json);
            exit;
        }

        $data = array();
        foreach ($result as $rowValue) {
            $data[] = array(
                "invoice_id" => $rowValue['admin_id'],
                "invoice_no" => $rowValue['invoice_no']
            );
        }

        $json['status'] = 1;
        $json['result'] = $data;
        echo json_encode($json);
        exit;
    }

    public function getProductDetails()
    {
        $result = $this->db->select('product_name')->get('tbl_product_details')->result_array();
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            $json['message'] = $error['message'];
            echo json_encode($json);
            exit;
        }

        $data = array();
        foreach ($result as $rowValue) {
            $data[] = array(
                "product_name" => $rowValue['product_name']
            );
        }

        $json['status'] = 1;
        $json['data'] = $data;
        echo json_encode($json);
        exit;
    }

    public function purchaseReturnPdf($purchase_return_id)
    {
        if ((int)$purchase_return_id <= 0) {
            return true;
        }

        $this->db->where('purchase_return_id', $purchase_return_id);

        $rowValue = $this->db->get('PURCHASE_RETURN_VIEW')->row_array();
        

        $vendor_details = $this->db->select('address, vendor_code, pincode,city, tbl_states.name as state_name, gst_no, state_gst_id')
        ->where('vendor_id', $rowValue['vendor_id'])
        ->join('tbl_states', 'tbl_states.state_id = tbl_vendor.state', 'left')
        ->get('tbl_vendor')->row_array();
        $records = array(
            "purchase_return_id" => $rowValue['purchase_return_id'],
            "purchase_return_no" => $rowValue['purchase_return_no'],
            "status" => $rowValue['status'],
            "invoice_no" => $rowValue['invoice_no'],
            "vendor_id" => $rowValue['vendor_id'],
            "company" => $rowValue['vendor_name'],
            "invoice_id" => $rowValue['invoice_id'],
            "creditnote_no" => $rowValue['creditnote_no'],
            "creditnote_date" => date("d-m-Y", strtotime($rowValue['creditnote_date'])),
            "invoice_date" => date("d-m-Y", strtotime($rowValue['invoice_date'])),
            "return_type" => $rowValue['return_type'],
            "taxable_amount" => $rowValue['taxable_amount'],
            "exempt_amount" => $rowValue['exempt_amount'],
            "tax_amount" => $rowValue['tax_amount'],
            "total_amount" => $rowValue['total_amount'],
            "quantity" => $rowValue['quantity'],
            "created_by" => $rowValue['created_by'],
            "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
            "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date'])),
            "last_updated_by" => $rowValue['last_updated_by'],
            "address" => $vendor_details['address'],
            "city" => $vendor_details['city'],
            "state" => $vendor_details['state_name'],
            "gst_no" => $vendor_details['gst_no'],
            "placeofsupply" => sprintf("%2d", $vendor_details['state_gst_id']).'-'.$vendor_details['state_name'],
            "vendor_code" => $vendor_details['vendor_code'],
            "pincode" => $vendor_details['pincode'],
        );

        $this->db->where('purchase_return_id', $purchase_return_id);
        $result = $this->db->get('PURCHASE_RETURN_ITEM_VIEW')->result_array();

        foreach ($result as $rowValue) {
            $devices[] = array(
                "grnreport_id" => $rowValue['grnreport_id'],
                "nhdin" => $rowValue['nhdin'],
                "device_name" => $rowValue['device_name'] ? $rowValue['device_name'] : $rowValue['model_name'],
                "sku" => $rowValue['SKU'] ? $rowValue['SKU'] : $rowValue['sf_ram'] . '-' . $rowValue['sf_rom'],
                "ram" => $rowValue['ram'] ? $rowValue['ram'] : $rowValue['sf_ram'],
                "rom" => $rowValue['rom'] ? $rowValue['rom'] : $rowValue['sf_rom'],
                "quantity" => $rowValue['quantity'],
                "status" => $rowValue['status'],
                "stock_type" => $rowValue['stock_type'],
                "taxable_amount" => $rowValue['taxable_amount'],
                "exempt_amount" => $rowValue['exempt_amount'],
                "tax_amount" => $rowValue['tax_amount'],
                "price" => $rowValue['price'],
                "certification_remark" => $rowValue['certification_remark'],
                "remarks" => $rowValue['remarks'],
            );
        }

        $records['devices'] = $devices;

        $this->load->helper('dompdf');
		$viewfile = $this->load->view('admin/purchase_return/purchase_return_pdf', $records, TRUE);
		pdf_picklist($viewfile, "PickList");
    }

    public function cancelPurchaseReturn()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data['purchase_return_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('purchase_return_id', $data['purchase_return_id'])->get('tbl_purchase_return')->row();

        if ($result->status == 'CN_CREATED') {
            $json['status'] = 0;
            $json['message'] = 'Debit Note Already Created';
            echo json_encode($json);
            exit;
        }

        
        $headerArray = array(
            "status" => "CANCELLED",
            "last_update_date" => date("Y-m-d H:i:s"),
            "last_updated_by" => $this->session->userdata('user_id')
        );

        $this->db->trans_start();

        $this->db->where('purchase_return_id', $data['purchase_return_id']);
        $this->db->update('tbl_purchase_return', $headerArray);

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        if (!empty($data['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $data['purchase_return_id'],
                'reference_type' => 'purchase_return',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
        }
        $json['message'] = 'Debit Note Cancelled Successfully';
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    
}
