<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procurement_grade extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function manage_procurement_grade($active = 0)
    {
        if($active > 0){
            $data['active'] = $active;
        }else{
            $data['active'] = 1;
        }

        $data['title'] = 'PROCUREMENT GRADE';
        $data['subview'] = $this->load->view('admin/procurement_grade/manage_procurement_grade', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function downloadCsvReportsModelWise(){
        
        $from_date_1 = $this->input->get('from_date');
        $to_date_1 = $this->input->get('to_date');
        if ($from_date_1 == '' || $to_date_1 == '') {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_date = str_replace('/', '-', $from_date_1);
        $to_date = str_replace('/', '-', $to_date_1);
        
        $csv_output = "Invoice Date, Product Brand, Device Name, Grade A QTY,Grade A price , Grade B qty, Grade B price,";
        $csv_output .= "Grade C qty,Grade C price,Grade D qty, Grade D price,Total QTY,Total Amount,Model Average Price";
       
        if ($from_date != '') {

            $this->db->where("DATE(INVOICE_DATE) >=", date("Y-m-d", strtotime($from_date)));
        }
        if ($to_date != '') {

            $this->db->where("DATE(INVOICE_DATE) <=", date("Y-m-d", strtotime($to_date)));
        }
        $result = $this->db->order_by('product_brand, device_name')->get('PROCUREMENT_GRADE_MODEL_WISE')->result_array();
       
        $csv_output.="\n";
        
		if(!empty($result))
		{
			foreach($result as $value)
			{  
                $result_A_price = new stdClass();
                $result_B_price = new stdClass();
                $result_C_price = new stdClass();
                $result_D_price = new stdClass();
                $invoice_date = date("d-m-Y", strtotime($value['invoice_date']));
                $device_name = $value['device_name'];
                $product_brand = $value['product_brand'];
                $Grade_A_qty = $value['Grade_A_qty'];
                $Grade_B_qty = $value['Grade_B_qty'];
                $Grade_C_qty = $value['Grade_C_qty'];
                $Grade_D_qty = $value['Grade_D_qty'];
    
                $whereAGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'A','status'=>'RFS');
                $whereBGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'B','status'=>'RFS');
                $whereCGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'C','status'=>'RFS');
                $whereDGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'D','status'=>'RFS');
                
             
             if($Grade_A_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_A_price = $this->db->where($whereAGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();
             }
             if($Grade_B_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_B_price = $this->db->where($whereBGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();  
             }
             if($Grade_C_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_C_price = $this->db->where($whereCGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();  
             }
             if($Grade_D_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_D_price = $this->db->where($whereDGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();  
             }

             if($result_A_price->unit_price == ''||$result_A_price->unit_price == 'NAN'){
                 $result_A_price->unit_price= 0;
             }
             if($result_B_price->unit_price == ''||$result_B_price->unit_price == 'NAN'){
                $result_B_price->unit_price= 0;
            }
            if($result_C_price->unit_price == ''||$result_C_price->unit_price == 'NAN'){
                $result_C_price->unit_price= 0;
            }
            if($result_D_price->unit_price == ''||$result_D_price->unit_price == 'NAN'){
                $result_D_price->unit_price= 0;
            }
            $csv_output .= $invoice_date.",";
            $csv_output .= $product_brand.",";
            $csv_output .= $device_name.",";
            $csv_output .= $Grade_A_qty.",";
            $csv_output .= $result_A_price->unit_price.",";
            $csv_output .= $Grade_B_qty.",";
            $csv_output .= $result_B_price->unit_price.",";
            $csv_output .= $Grade_C_qty.",";
            $csv_output .=  $result_C_price->unit_price.",";
            $csv_output .= $Grade_D_qty.",";
            $csv_output .=  $result_D_price->unit_price.",";
            $total_qty =  $Grade_A_qty+ $Grade_B_qty+ $Grade_C_qty+ $Grade_D_qty;
            $csv_output .= $total_qty.",";
            $total_price =($result_A_price->unit_price*$Grade_A_qty)+( $result_B_price->unit_price*$Grade_B_qty)+($result_C_price->unit_price*$Grade_C_qty)+($result_D_price->unit_price*$Grade_C_qty);
            $csv_output .= $total_price.",";
            $total_average = $total_price/$total_qty;
           
            if(is_nan($total_average)){
               $total_average = 0;
            }
            $csv_output .= $total_average.",";     
            $csv_output.="\n";
           
            }
        }

        $filename = "procurement grade model wise"."_".date("Y-m-d_H-i",time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=".$filename.".csv;");
        print $csv_output;
		exit;
    }

    public function downloadCsvReportsDeviceIdWise(){

        $from_date_1 = $this->input->get('from_date');
        $to_date_1 = $this->input->get('to_date');
        if ($from_date_1 == '' || $to_date_1 == '') {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $from_date = str_replace('/', '-', $from_date_1);
        $to_date = str_replace('/', '-', $to_date_1);
        
        $csv_output = "Device ID, Product Brand, Device Name, Other Vendor ID,Batch No, Category, Status,RAM,ROM,SKU, IMEI One, IMEI Two, Vendor Name, Invoice No,Invoice date,Inward Date,Procurement Grade, Sold to Customer, Sales Invoice No, Sales Invoice Date,Unit Price, Unit Price Tax";
        
        if ($from_date != '') {

            $this->db->where("DATE(INVOICE_DATE) >=", date("Y-m-d", strtotime($from_date)));
        }
        if ($to_date != '') {

            $this->db->where("DATE(INVOICE_DATE) <=", date("Y-m-d", strtotime($to_date)));
        }
        $result = $this->db->order_by('product_brand,device_name')->get('tbl_grnreport')->result_array();
       
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{ 
			    $invoice_data = $this->db->get_where('INVOICE_VENDOR_DEVICE_VIEW', array("nhdin" => $value['nhdin']))->row();
			    If(!empty($invoice_data)){
			        $vendor_name = $invoice_data->vendor_name;
			        $invoice_no = $invoice_data->invoice_code;
			        $invoice_date = date("d-m-Y", strtotime($invoice_data->CREATION_DATE));;
			        
			    } else{
			        $vendor_name = "NA";
			        $invoice_no = "NA";
			        $invoice_date = "NA";
			    }
			    $csv_output .= $value['nhdin'].",";
				$csv_output .= $value['product_brand'].",";
				$csv_output .= $value['device_name'].",";
				$csv_output .= $value['othervendor_id'].",";
				$csv_output .= $value['batch_no'].",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['status'].",";
				$csv_output .= $value['ram'].",";
				$csv_output .= $value['rom'].",";
				$csv_output .= $value['SKU'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= $value['vendor_name'].",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= $value['invoice_date'].",";
				$csv_output .= date("Y-m-d", strtotime($value['grn_inwarddate'])).",";
				$csv_output .= $value['procurement_grade'].",";
				$csv_output .= $vendor_name.",";
				$csv_output .= $invoice_no.",";
				$csv_output .= $invoice_date.",";
				$csv_output .= $value['unit_price'].",";
				$csv_output .= $value['unit_price_tax'].",";
			    $csv_output.="\n";
            }
        }

		$filename = "procurement grade device wise"."_".date("Y-m-d_H-i",time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=".$filename.".csv;");
        print $csv_output;
        exit;
  }

public function downloadCsvReportsTotalDeviceIdWise(){

        $csv_output = "Device ID, Product Brand, Device Name, Other Vendor ID,Batch No, Category, Status,RAM,ROM,SKU, IMEI One, IMEI Two, Vendor Name, Invoice No,Invoice date,Inward Date,Procurement Grade,Unit Price, Unit Price Tax";
        
        $result = $this->db->order_by('product_brand,device_name')->get('tbl_grnreport')->result_array();
       
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{ 
			    //$invoice_data = $this->db->get_where('INVOICE_VENDOR_DEVICE_VIEW', array("nhdin" => $value['nhdin']))->row();
			    // If(!empty($invoice_data)){
			    //     $vendor_name = $invoice_data->vendor_name;
			    //     $invoice_no = $invoice_data->invoice_code;
			    //     $invoice_date = date("d-m-Y", strtotime($invoice_data->CREATION_DATE));;
			        
			    // } else{
			    //     $vendor_name = "NA";
			    //     $invoice_no = "NA";
			    //     $invoice_date = "NA";
			    // }
			    	$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['product_brand'].",";
				$csv_output .= $value['device_name'].",";
				$csv_output .= $value['othervendor_id'].",";
				$csv_output .= $value['batch_no'].",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['status'].",";
				$csv_output .= $value['ram'].",";
				$csv_output .= $value['rom'].",";
				$csv_output .= $value['SKU'].",";
				$csv_output .= $value['imei1_no'].",";
				$csv_output .= $value['imei2_no'].",";
				$csv_output .= $value['vendor_name'].",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= $value['invoice_date'].",";
				$csv_output .= date("Y-m-d", strtotime($value['grn_inwarddate'])).",";
				$csv_output .= $value['procurement_grade'].",";
				//$csv_output .= $vendor_name.",";
				//$csv_output .= $invoice_no.",";
				//$csv_output .= $invoice_date.",";
				$csv_output .= $value['unit_price'].",";
				$csv_output .= $value['unit_price_tax'].",";
			    $csv_output.="\n";
            }
        }

	$filename = "procurement grade device wise"."_".date("Y-m-d_H-i",time());
	header("Content-type: application/csv");
	header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=".$filename.".csv;");
        print $csv_output;
        exit;
  }

public function downloadCsvReportsTotalModelWise(){
        
        $csv_output = "Invoice Date, Product Brand, Device Name, Grade A QTY,Grade A price , Grade B qty, Grade B price,";
        $csv_output .= "Grade C qty,Grade C price,Grade D qty, Grade D price,Total QTY,Total Amount,Model Average Price";
       
        $result = $this->db->order_by('product_brand, device_name')->get('PROCUREMENT_GRADE_MODEL_WISE')->result_array();
       
        $csv_output.="\n";
        
		if(!empty($result))
		{
		foreach($result as $value)
		{  
                $result_A_price = new stdClass();
                $result_B_price = new stdClass();
                $result_C_price = new stdClass();
                $result_D_price = new stdClass();
                $invoice_date = date("d-m-Y", strtotime($value['invoice_date']));
                $device_name = $value['device_name'];
                $product_brand = $value['product_brand'];
                $Grade_A_qty = $value['Grade_A_qty'];
                $Grade_B_qty = $value['Grade_B_qty'];
                $Grade_C_qty = $value['Grade_C_qty'];
                $Grade_D_qty = $value['Grade_D_qty'];
    
                $whereAGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'A','status'=>'RFS');
                $whereBGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'B','status'=>'RFS');
                $whereCGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'C','status'=>'RFS');
                $whereDGrade = array('device_name'=>$device_name,'stock_type'=>'PREXO','procurement_grade'=>'D','status'=>'RFS');
                
             
             if($Grade_A_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_A_price = $this->db->where($whereAGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();
             }
             if($Grade_B_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_B_price = $this->db->where($whereBGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();  
             }
             if($Grade_C_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_C_price = $this->db->where($whereCGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();  
             }
             if($Grade_D_qty>0){
                $this->db->select('invoice_no,grn_inwarddate,unit_price');
                $result_D_price = $this->db->where($whereDGrade)->order_by('grn_inwarddate','DESC')->get('tbl_grnreport')->row();  
             }

             if($result_A_price->unit_price == ''||$result_A_price->unit_price == 'NAN'){
                 $result_A_price->unit_price= 0;
             }
             if($result_B_price->unit_price == ''||$result_B_price->unit_price == 'NAN'){
                $result_B_price->unit_price= 0;
            }
            if($result_C_price->unit_price == ''||$result_C_price->unit_price == 'NAN'){
                $result_C_price->unit_price= 0;
            }
            if($result_D_price->unit_price == ''||$result_D_price->unit_price == 'NAN'){
                $result_D_price->unit_price= 0;
            }
            $csv_output .= $invoice_date.",";
            $csv_output .= $product_brand.",";
            $csv_output .= $device_name.",";
            $csv_output .= $Grade_A_qty.",";
            $csv_output .= $result_A_price->unit_price.",";
            $csv_output .= $Grade_B_qty.",";
            $csv_output .= $result_B_price->unit_price.",";
            $csv_output .= $Grade_C_qty.",";
            $csv_output .=  $result_C_price->unit_price.",";
            $csv_output .= $Grade_D_qty.",";
            $csv_output .=  $result_D_price->unit_price.",";
            $total_qty =  $Grade_A_qty+ $Grade_B_qty+ $Grade_C_qty+ $Grade_D_qty;
            $csv_output .= $total_qty.",";
            $total_price =($result_A_price->unit_price*$Grade_A_qty)+( $result_B_price->unit_price*$Grade_B_qty)+($result_C_price->unit_price*$Grade_C_qty)+($result_D_price->unit_price*$Grade_C_qty);
            $csv_output .= $total_price.",";
            $total_average = $total_price/$total_qty;
           
            if(is_nan($total_average)){
               $total_average = 0;
            }
            $csv_output .= $total_average.",";     
            $csv_output.="\n";
           
            }
        }

        $filename = "procurement grade model wise"."_".date("Y-m-d_H-i",time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=".$filename.".csv;");
        print $csv_output;
		exit;
    }



}
?>