<?php

class Procurement extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function manage_procurement($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'PROCUREMENT';
        $data['subview'] = $this->load->view('admin/procurement/manage_procurement', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function manage_procurement_oth($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'PROCUREMENT';
        $data['subview'] = $this->load->view('admin/procurement_oth/manage_procurement_oth', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function getProcurementList()
    {
        $status = $this->input->get('status');
        $data = [];

        if (empty($status)) {
            $status = 'ACCEPTED';
        }

        $result = $this->db->where('status', $status)->get('PROCUREMENT_LIST_VIEW')->result_array();

        foreach ($result as $rowValue) {
            $data[] = array(
                "procurement_id" => $rowValue['procurement_id'],
                "procurement_no" => $rowValue['procurement_no'],
                "batch_no" => $rowValue['batch_no'],
                "accepted_qty" => $rowValue['accepted_qty'],
                "offered_qty" => $rowValue['offered_qty'],
                "raised_qty" => $rowValue['raised_qty'],
                "invoiced_qty" => $rowValue['invoiced_qty'],
                "source" => $rowValue['source'],
                "category" => $rowValue['category'],
                "status" => $rowValue['status'],
                "warehouse" => $rowValue['warehouse'],
                "amount" => $rowValue['amount'],
                "ref_no" => $rowValue['ref_no'],
                "logistics_partner_name" => $rowValue['logistics_partner_name'],
                "docket_no" => $rowValue['docket_no'],
                "payment_date" => $rowValue['payment_date'],
                "lot_accepted_date" => date("d-m-Y", strtotime($rowValue['lot_accepted_date'])),
                "lot_raised_date" => date("d-m-Y", strtotime($rowValue['lot_raised_date'])),
                "lot_invoiced_date" => date("d-m-Y", strtotime($rowValue['lot_invoiced_date'])),
                "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
                "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date'])),
                "created_by" => $rowValue['created_by'],
                "last_updated_by" => $rowValue['last_updated_by']
            );
        }

        $json['data'] = $data;
        echo json_encode($json);
        exit;
    }

    public function addNewProcurement()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || empty($data['items'])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(procurement_no,"-",-1) as UNSIGNED)) as max')->from('tbl_procurement')->get()->row_array();
        $next_number = $res['max'] + 1;
        $procurement_no = 'PRC-' . $next_number;

        $header = array(
            "procurement_no" => $procurement_no,
            "accepted_qty" => $data['accepted_qty'],
            "lot_accepted_date" => $data['accepted_date'],
            "source" => $data['source'],
            "category" => $data['category'],
            "warehouse" => $data['warehouse'],
            "status" => 'ACCEPTED',
            "amount" => $data['amount'],
            "ref_no" => $data['reference_no'],
            "payment_date" => $data['payment_date'],
            "batch_no" => $data['batch_no'],
            "created_by" => $this->session->userdata('user_id'),
            "creation_date" => date('Y-m-d H:i:s'),
            "last_update_date" => date('Y-m-d H:i:s')
        );

        $this->db->trans_start();

        $this->db->insert('tbl_procurement', $header);
        $error = $this->db->error();

        $procurement_id = $this->db->insert_id();

        if ($error['code'] != 0 || $procurement_id <= 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach ($data['items'] as $rowValue) {
            $discount = str_replace('%', '', $rowValue['discount']);

            $items[] = array(
                "procurement_id" => $procurement_id,
                "fsn" => $rowValue['fsn'],
                "wid" => $rowValue['wid'],
                "quantity" => $rowValue['quantity'],
                "grade" => $rowValue['grade'],
                "brand" => $rowValue['brand'],
                "device_name" => $rowValue['device_name'],
                "rate" => $rowValue['rate'],
                "discount" => $discount,
                "discounted_rate" => $rowValue['discounted_rate']
            );
        }

        $this->db->insert_batch('tbl_procurement_accepted', $items);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }


    public function getProcurementHeader()
    {
        $procurement_id = $this->input->get('procurement_id');
        $data = [];

        $result = $this->db->where('procurement_id', $procurement_id)->get('PROCUREMENT_LIST_VIEW')->row();

        if (empty($result)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $data = array(
            "procurement_id" => $result->procurement_id,
            "procurement_no" => $result->procurement_no,
            "batch_no" => $result->batch_no,
            "accepted_qty" => $result->accepted_qty,
            "offered_qty" => $result->offered_qty,
            "raised_qty" => $result->raised_qty,
            "invoiced_qty" => $result->invoiced_qty,
            "source" => $result->source,
            "category" => $result->category,
            "status" => $result->status,
            "warehouse" => $result->warehouse,
            "amount" => $result->amount,
            "ref_no" => $result->ref_no,
            "payment_date" => $result->payment_date,
            "lot_accepted_date" => date("d-m-Y", strtotime($result->lot_accepted_date)),
            "lot_raised_date" => date("d-m-Y", strtotime($result->lot_raised_date)),
            "lot_invoiced_date" => date("d-m-Y", strtotime($result->lot_invoiced_date)),
            "creation_date" => date("d-m-Y", strtotime($result->creation_date)),
            "last_update_date" => date("d-m-Y", strtotime($result->last_update_date)),
            "created_by" => $result->created_by,
            "last_updated_by" => $result->last_updated_by
        );

        $json['status'] = 1;
        $json['result'] = $data;
        echo json_encode($json);
        exit;
    }


    public function updateRaisedLotForm($procurement_id = 0)
    {
        if ((int) $procurement_id <= 0) {
            return false;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status == 'ACCEPTED') {
            $data['active'] = 3;
            $data['raised_procurement_id'] = $procurement_id;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'UPDATE RAISED PROCUREMNT';
        $data['subview'] = $this->load->view('admin/procurement/manage_procurement', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function updateRaisedLot()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || empty($data['items'])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ((int) $data['procurement_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $procurement_id = $data['procurement_id'];
        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'ACCEPTED') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => 'RAISED',
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
            "lot_raised_date" => $data['raised_date']
        );

        $this->db->trans_start();

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach ($data['items'] as $rowValue) {
            $items[] = array(
                "procurement_id" => $procurement_id,
                "fsn" => $rowValue['fsn'],
                "hsn" => $rowValue['hsn'],
                "wid" => $rowValue['wid'],
                "sku" => $rowValue['sku'],
                //"warehouse" => $rowValue['warehouse'],
                "storage_location" => $rowValue['storage_location'],
                "seller_id" => $rowValue['seller_id'],
                "seller_name" => $rowValue['seller_name'],
                "super_category" => $rowValue['super_category'],
                "cms_vertical" => $rowValue['cms_vertical'],
                "listing_id" => $rowValue['listing_id'],
                "quantity" => $rowValue['quantity'],
                "fsp" => (float)$rowValue['fsp'],
                "node_id" => $rowValue['node_id'],
                "supply_chain" => $rowValue['supply_chain'],
                "grade" => $rowValue['grade'],
                "rate" => (float)$rowValue['rate'],
                "tentative_value" => (float)$rowValue['tentative_value'],
                "tcs" => (float)$rowValue['tcs'],
                "final_tentative_value" => (float)$rowValue['final_tentative_value'],
                "lot_id" => $rowValue['lot_id'],
                "lot_subject" => $rowValue['lot_subject'],
            );
        }

        $this->db->insert_batch('tbl_procurement_raised', $items);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateInvoicedLotForm($procurement_id = 0)
    {
        if ((int) $procurement_id <= 0) {
            return false;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status == 'RAISED') {
            $data['active'] = 4;
            $data['invoiced_procurement_id'] = $procurement_id;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'UPDATE INVOICED PROCUREMNT';
        $data['subview'] = $this->load->view('admin/procurement/manage_procurement', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function updateInvoiceNoForm($procurement_id = 0)
    {
        if ((int) $procurement_id <= 0) {
            return false;
        }

        $result = $this->db->select('status, procurement_no')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row();

        if ($result->status == 'INVOICE_PENDING') {
            $data['active'] = 6;
            $data['update_invoice_procurement_id'] = $procurement_id;
            $data['update_invoice_procurement_no'] = $result->procurement_no;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'UPDATE INVOICED PROCUREMNT';
        $data['subview'] = $this->load->view('admin/procurement/manage_procurement', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function validateInvoiceForm($procurement_id = 0)
    {
        if ((int) $procurement_id <= 0) {
            return false;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status == 'PENDING') {
            $data['active'] = 5;
            $data['validation_procurement_id'] = $procurement_id;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'UPDATE INVOICED PROCUREMNT';
        $data['subview'] = $this->load->view('admin/procurement/manage_procurement', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function updateInvoicedLot()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || empty($data['invoice_items']) || empty($data['wsn_items'])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ((int) $data['procurement_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $procurement_id = $data['procurement_id'];

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'RAISED') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => 'PENDING',
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
            "lot_raised_date" => $data['raised_date']
        );

        $this->db->trans_start();

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach ($data['invoice_items'] as $rowValue) {
            $invoice_items[] = array(
                "procurement_id" => $procurement_id,
                "fsn" => $rowValue['fsn'],
                "grade" => $rowValue['grade'],
                "quantity" => $rowValue['quantity'],
                "fsp" => $rowValue['fsp'],
                "mrp" => $rowValue['mrp'],
                "ca_grade" => $rowValue['ca_grade'],
                "brand_group" => $rowValue['brand_group'],
                "qc_remarks" => $rowValue['qc_remark'],
                "hsn_sac" => $rowValue['hsn_sac'],
                "yield_per_unit" => $rowValue['yield_per_unit'],
                "total_exempted" => $rowValue['total_exempted_value'],
                "taxable_value" => $rowValue['taxable_value'],
                "sgst_utgst_rate" => $rowValue['sgst_utgst_rate'],
                "sgst_utgst" => $rowValue['sgst_utgst'],
                "cgst_rate" => $rowValue['cgst_rate'],
                "cgst" => $rowValue['cgst'],
                "igst_rate" => $rowValue['igst_rate'],
                "igst" => $rowValue['igst'],
                "tcs" => $rowValue['tcs'],
                "total_yield" => $rowValue['total_yield'],
                "sku" => $rowValue['sku'],
                "expiry_date" => $rowValue['expiry_date'],
                "lot_id" => $rowValue['lot_id'],
            );
        }

        $this->db->insert_batch('tbl_procurement_invoiced', $invoice_items);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach ($data['wsn_items'] as $rowValue) {
            $wsn_items[] = array(
                "procurement_id" => $procurement_id,
                "wsn" => $rowValue['wsn'],
                "wid" => $rowValue['wid'],
                "fsn" => $rowValue['fsn'],
                "sku" => $rowValue['sku'],
                "listing_id" => $rowValue['listing_id'],
                "tracking_id" => $rowValue['tracking_id'],
                "external_order_id" => $rowValue['external_order_id'],
                "order_item_id" => $rowValue['order_item_id'],
                "dpv_comments" => $rowValue['dpv_comments'],
                "condition" => $rowValue['condition'],
                "serial_no" => $rowValue['serial_no'],
                "qc_remark" => $rowValue['qc_remarks'],
                "grade_in_system" => $rowValue['grade_in_system'],
                "lot_id" => $rowValue['lot_id'],

            );
        }

        $this->db->insert_batch('tbl_procurement_wsn', $wsn_items);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateInvoiceNo()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || empty($data['items'])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if ((int) $data['procurement_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $procurement_id = $data['procurement_id'];
        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'INVOICE_PENDING') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => 'INVOICED',
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->trans_start();

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach ($data['items'] as $rowValue) {
            $items[] = array(
                "lot_id" => $rowValue['lot_id'],
                "invoice_no" => $rowValue['invoice_no']
            );
        }

        foreach ($data['items'] as $rowValue) {
            $lot_invoice_items[] = array(
                "lot_id" => $rowValue['lot_id'],
                "invoice_no" => $rowValue['invoice_no'],
                "eway_bill_no" => $rowValue['eway_bill_no'],
                "procurement_id" => $data['procurement_id']
            );
        }

        $this->db->insert_batch('tbl_procurement_lot_invoice', $lot_invoice_items);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update_batch('tbl_procurement_invoiced', $items, 'lot_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update_batch('tbl_procurement_wsn', $items, 'lot_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getProformaDetails()
    {
        $procurement_id = $this->input->get('procurement_id');
        $records = [];
        if ((int) $procurement_id <= 0) {
            $json['data'] = [];
            echo json_encode($json);
            exit;
        }

        $procurement_no = $this->db->select('procurement_no')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->procurement_no;

        if (empty($procurement_no)) {
            $json['data'] = [];
            echo json_encode($json);
            exit;
        }

        $this->db->select('sum(quantity) as quantity, sum(quantity*yield_per_unit) as amount, lot_id');
        $result =  $this->db->where('procurement_id', $procurement_id)->group_by('lot_id')->get('tbl_procurement_invoiced')->result_array();

        foreach ($result as $rowValue) {
            $records[] = array(
                "procurement_no" => $procurement_no,
                "lot_id" => $rowValue['lot_id'],
                "quantity" => $rowValue['quantity'],
                "amount" => round($rowValue['amount'],2),
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getWSNDetails()
    {
        $procurement_id = $this->input->get('procurement_id');
        $records = [];
        
        if ((int) $procurement_id <= 0) {
            $json['data'] = [];
            echo json_encode($json);
            exit;
        }

        $procurement_no = $this->db->select('procurement_no')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->procurement_no;

        if (empty($procurement_no)) {
            $json['data'] = [];
            echo json_encode($json);
            exit;
        }

        $this->db->select('count(procurement_wsn_id) as quantity, lot_id');
        $result =  $this->db->where('procurement_id', $procurement_id)->group_by('lot_id')->get('tbl_procurement_wsn')->result_array();

        foreach ($result as $rowValue) {
            $records[] = array(
                "procurement_no" => $procurement_no,
                "lot_id" => $rowValue['lot_id'],
                "quantity" => $rowValue['quantity'],
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function approveValidateProcurement()
    {
        $procurement_id = $this->input->get('procurement_id');

        if ((int)$procurement_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'PENDING') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => 'INVOICE_PENDING',
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function rejectValidateProcurement()
    {
        $procurement_id = $this->input->get('procurement_id');

        if ((int)$procurement_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'PENDING') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => 'RAISED',
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->trans_start();
        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->where('procurement_id', $procurement_id);
        $this->db->delete('tbl_procurement_invoiced');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->where('procurement_id', $procurement_id);
        $this->db->delete('tbl_procurement_wsn');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateLogisticsDetails()
    {
        $data = $this->input->get('data');
        $procurement_id = $data['procurement_id'];
        $logistics_partner_name = $data['logistics_partner_name'];
        $docket_no = $data['docket_no'];     

        if ((int)$procurement_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'INVOICED') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "logistics_partner_name" => $logistics_partner_name,
            "docket_no" => $docket_no,
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateDispatchDetails()
    {
        $data = $this->input->get('data');
        $procurement_id = $data['procurement_id'];
        $remarks = $data['remarks'];

        if ((int)$procurement_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'INVOICED') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => "DISPATCHED",
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ($error['code'] == 0) {
            if (!empty($remarks)) {
                $remark_array = array(
                    'reference_id' => $procurement_id,
                    'reference_type' => 'procurement',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $remarks,
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateInTransitDetails()
    {
        $data = $this->input->get('data');
        $procurement_id = $data['procurement_id'];
        $remarks = $data['remarks'];

        if ((int)$procurement_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'DISPATCHED') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => "IN_TRANSIT",
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ($error['code'] == 0) {
            if (!empty($remarks)) {
                $remark_array = array(
                    'reference_id' => $procurement_id,
                    'reference_type' => 'procurement',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $remarks,
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateReceivedDetails()
    {
        $data = $this->input->get('data');
        $procurement_id = $data['procurement_id'];
        $remarks = $data['remarks'];

        if ((int)$procurement_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->select('status')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if ($status != 'IN_TRANSIT') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $header = array(
            "status" => "RECEIVED",
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s"),
        );

        $this->db->where('procurement_id', $procurement_id);
        $this->db->update('tbl_procurement', $header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ($error['code'] == 0) {
            if (!empty($remarks)) {
                $remark_array = array(
                    'reference_id' => $procurement_id,
                    'reference_type' => 'procurement',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $remarks,
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function newDispatchOth()
    {
        $request = file_get_contents('php://input');
        $data = json_decode($request, TRUE);
        $invoiceData = $data['invoice_data'];
        $items = $data['items'];

        if(empty($data)){
            $json['status'] = 0;
            $json['message'] = "No data found";
            echo json_encode($json);
            exit;
        }

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(procurement_no,"-",-1) as UNSIGNED)) as max')->from('tbl_procurement')->get()->row_array();
        $next_number = $res['max'] + 1;
        $procurement_no = 'PRC-' . $next_number;
        $headerArray = array(
            "procurement_no" => $procurement_no,
            "source" => $data['source'],
            "category" => $data['category'],
            "sub_category" => $data['sub_category'],
            "warehouse" => $data['warehouse'],
            "ref_no" => $data['payment_ref_no'],
            "payment_date" => $data['payment_date'],
            "amount" => $data["payment_amount"],
            "batch_no" => $data['batch_no'],
            "lot_accepted_date" => $data['accepted_date'],
            "accepted_qty" => $data['accepted_qty'],
            "status" => "PENDING",
            "last_updated_by" => $this->session->userdata('user_id'),
            "created_by" => $this->session->userdata('user_id'),
        );

        $total_amount = 0;

        foreach ($invoiceData as $key => $value) {
            $invoiceHeader[] = array(
                "invoice_no" => $value['invoice_no'],
                "invoice_date" => date("Y-m-d", strtotime($value['invoice_date'])),
                "sub_category" => $data['sub_category'],
                "invoice_value" => $value['invoice_value'],
                "quantity" => $value['quantity'],
                "seller" => $value['seller'],
                "gatepass_no" => '',
            );
            $total_amount += $value['invoice_value'];
        }

        $headerArray['amount'] = $total_amount;

        foreach ($items as $key => $value) {
            $invoiceItems[] = array(
                "invoice_no" => $value['invoice_no'],
                "brand" => $value['brand'],
                "vendor_unique_id" => $value['vendor_unique_id'],
                "model" => $value['model'],
                "model_sku" => $value['model_sku'],
                "ram" => $value['ram'],
                "rom" => $value['rom'],
                "variant_sku" => $value['variant_sku'],
                "color" => $value['color'],
                "color_sku" => $value['color_sku'],
                "order_id" => $value['order_id'],
                "grade" => $value['procurement_grade'],
                "description" => $value['product_description'],
                "qty" => $value['quantity'],
                "price" => $value['price'],
                "taxable_amount" => $value['taxable_amount'],
                "exempt_amount" => $value['exempt_amount'],
                "tax_amount" => $value['tax_amount'],
                "tcs_amount" => $value['tcs_amount'],
                "box_no" => $value['box_no'],
                "vrp_no" => $value['vrp_no'],
                "imei_no" => $value['imei_no']
            );
        }

        //Start the transaction
        $this->db->trans_start();
        //Insert Procurement
        $this->db->insert('tbl_procurement', $headerArray);
        $procurement_id = $this->db->insert_id();

        if($procurement_id <=0){
            $json['status'] = 0;
            $json['message'] = "Error in inserting procurement";
            echo json_encode($json);
            exit;
        }

        foreach($invoiceHeader as $key => $value){
            $invoiceHeader[$key]['procurement_id'] = $procurement_id;
        }

        //Insert Invoice
        $this->db->insert_batch('tbl_proc_o_invoice', $invoiceHeader);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            $json['message'] = "Error in inserting invoice";
            echo json_encode($json);
            exit;
        }

        $invoiceDetails = $this->db->select('procurement_invoice_id, invoice_no')->where('procurement_id', $procurement_id)->get('tbl_proc_o_invoice')->result_array();
        $invoiceIdsArr = array();
        
        foreach($invoiceDetails as $key => $value){
            $invoiceIdsArr[$value['invoice_no']] = $value['procurement_invoice_id'];
        }

        foreach ($invoiceItems as $key => $value) {
            $invoiceItems[$key]['procurement_invoice_id'] = $invoiceIdsArr[$value['invoice_no']];
            unset($invoiceItems[$key]['invoice_no']);
        }

        //Insert Items
        $this->db->insert_batch('tbl_proc_o_invoice_detail', $invoiceItems);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            $json['message'] = "Error in inserting items";
            echo json_encode($json);
            exit;
        }
        
        try{
            $audit_log = array(
                "reference_type" => "procurement",
                "reference_id" => $procurement_id,
                "status" => "PENDING",
                "remark" => "New Dispatch",
                "date" => date("Y-m-d H:i:s"),
                "user_id" => $this->session->userdata('user_id')
            );
            $this->db->insert('tbl_audit_log', $audit_log);
        }catch(Exception $e){

        }

        $this->db->trans_complete();
        $json['status'] = 1;
        $json['message'] = "Dispatch Details Added Successfully";
        echo json_encode($json);
        exit;
    }

    public function getProcurementOthList()
    {
        $status = $this->input->post('status');
        $result = array();

        if(empty($status)){
            $json['status'] = 0;
            $json['message'] = "No data found";
            echo json_encode($json);
            exit;
        }

        $procQueryResult = $this->db->select('*')->where('status', $status)->where('category !=', 'FLIPKART')->get('PROCUREMENT_OTH_LIST_VIEW')->result_array();

        if(empty($procQueryResult)){
            $json['status'] = 0;
            $json['data'] = array();
            $json['message'] = "No data found";
            echo json_encode($json);
            exit;
        }

        foreach($procQueryResult as $key => $value){
           $result[] = array(
                "procurement_id" => $value['procurement_id'],
                "procurement_no" => $value['procurement_no'],
                "accepted_qty" => $value['accepted_qty'],
                "source" => $value['source'],
                "category" => $value['category'],
                "status" => $value['status'],
                "warehouse" => $value['warehouse'],
                "total_amount" => $value['total_amount'],
                "payment_amount" => $value['amount'],
                "payment_ref_no" => $value['payment_ref_no'],
                "payment_date" => date("d-m-Y", strtotime($value['payment_date'])),
                "lot_accepted_date" => date("d-m-Y", strtotime($value['lot_accepted_date'])),
                "batch_no" => $value['batch_no'],
                "sub_category" => $value['sub_category'],
                "invoice_count" => $value['invoice_count'],
                "invoice_qty" => $value['invoice_qty'],
                "creation_date" => date("d-m-Y", strtotime($value['creation_date'])),
                "created_by" => $value['created_by'],
            );
        }

        $json['status'] = 1;
        $json['data'] = $result;
        $json['message'] = "Data found";
        echo json_encode($json);
        exit;
    }

    public function updateProcurementOthDispatchForm($procurement_id)
    {
        if($procurement_id <= 0){
            $json['status'] = 0;
            $json['message'] = "Invalid procurement id";
            echo json_encode($json);
            exit;
        }

        $queryData = $this->db->select('status, procurement_no')->where('procurement_id', $procurement_id)->get('tbl_procurement')->row();

        if($queryData->status != 'PENDING'){
            $json['status'] = 0;
            $json['message'] = "Procurement is Not Pending";
            echo json_encode($json);
            exit;
        }

        $data['active'] = 3;
        $data['update_dispatch_procurement_id'] = $procurement_id;
        $data['update_dispatch_procurement_no'] = $queryData->procurement_no;
        $data['title'] = "Update Procurement";
        $data['subview'] = $this->load->view('admin/procurement_oth/manage_procurement_oth', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function exportPendingInvoiceCsv()
    {
        $procurement_id = $this->input->get('procurement_id');

        if(empty($procurement_id) || $procurement_id <= 0){
            $json['status'] = 0;
            $json['message'] = 'Invalid Procurement Id';
            echo json_encode($json);
            exit;
        }

        $status = $this->db->where('procurement_id', $procurement_id)->get('tbl_procurement')->row()->status;

        if($status != 'PENDING'){
            $json['status'] = 0;
            $json['message'] = 'Procurement is not in Pending Status';
            echo json_encode($json);
            exit;
        }

        $invoiceQueryResult = $this->db->where('procurement_id', $procurement_id)->get('tbl_proc_o_invoice')->result_array();

        $csvRow = "Invoice No, Seller Name, Invoice Value,Taxable Amount,Exempt amount,Tax Amount,TCS Amount,Total Amount,Eway Bill No";
        $csvRow .= "\n";

        foreach($invoiceQueryResult as $key => $value){
            $csvRow .= $value['invoice_no'].",";
            $csvRow .= $value["seller"].",";
            $csvRow .= $value["invoice_value"].",";
            $csvRow .= ",";
            $csvRow .= ",";
            $csvRow .= ",";
            $csvRow .= ",";
            $csvRow .= ",";
            $csvRow .= ",";
            $csvRow .="\n";
        }

        $file="pending_dispatch";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csvRow;
		exit;
    }

    public function updateProcurementOthDispatch()
    {
        $data = json_decode(file_get_contents("php://input"), TRUE);
        $insertArray = array();

        if(empty($data) || empty($data['procurement_id']) || empty($data['items'])){
            $json['status'] = 0;
            $json['message'] = "No data Found";
            echo json_encode($json);
            exit;
        }

        foreach($data['items'] as $value){
            $insertArray[] = array(
                "invoice_no" => $value['invoice_no'],
                "taxable_amount" => $value['taxable_amount'],
                "exempt_amount" => $value['exempt_amount'],
                "tax_amount" => $value['tax_amount'],
                "tcs_amount" => $value['tcs_amount'],
                "eway_bill_no" => $value['eway_bill'],
            );    
        }

        $headerArray = array(
            "status" => "DISPATCHED",
            "last_updated_by" => $this->session->userdata('user_id'),
        );

        $this->db->trans_start();

        $this->db->where('procurement_id', $data['procurement_id'])->update_batch('tbl_proc_o_invoice', $insertArray, 'invoice_no');
        $error = $this->db->error();
        
        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            $json['message'] = "Error in updating data";
            echo json_encode($json);
            exit;
        }

        $this->db->where('procurement_id', $data['procurement_id'])->update('tbl_procurement', $headerArray);
        $error = $this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            $json['message'] = "Error in updating data";
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        $json['message'] = "Data updated successfully";
        echo json_encode($json);
        exit;
    }

    public function getInvoiceDataProcOth($procurement_id)
    {
        if($procurement_id <= 0){
            $json['status'] = 0;
            $json['message'] = "Invalid procurement id";
            echo json_encode($json);
            exit;
        }

        $invoiceQueryResult = $this->db->where('procurement_id', $procurement_id)->get('tbl_proc_o_invoice')->result_array();
        $result = array();

        foreach($invoiceQueryResult as $key => $value){
            $result[] = array(
                "invoice_no" => $value['invoice_no'],
                "seller" => $value['seller'],
                "invoice_value" => $value['invoice_value'],
                "taxable_amount" => $value['taxable_amount'],
                "exempt_amount" => $value['exempt_amount'],
                "tax_amount" => $value['tax_amount'],
                "tcs_amount" => $value['tcs_amount'],
                "eway_bill_no" => $value['eway_bill_no'],
            );
        }

        $json['status'] = 1;
        $json['message'] = "Data fetched successfully";
        $json['result'] = $result;
        echo json_encode($json);
        exit;
    }

    public function getProcurementOthData($procurement_id)
    {
        if($procurement_id <= 0){
            $json['status'] = 0;
            $json['message'] = "Invalid procurement id";
            echo json_encode($json);
            exit;
        }

        $procurementQueryResult = $this->db->where('procurement_id', $procurement_id)->get('PROCUREMENT_OTH_REPORT_VIEW')->result_array();

        $csvRow = "brand,vendor_unique_id,vrp_no,imei_no,model,ram,rom,color,variant_sku,color_sku,grade,description,qty,taxable_amount,exempt_amount,tax_amount,tcs_amount,box_no,procurement_id,procurement_no,accepted_qty,source,category,status,warehouse,amount,payment_ref_no,payment_date,lot_accepted_date,batch_no,sub_category,invoice_no,seller,invoice_value,eway_bill_no\n";

        foreach($procurementQueryResult as $value){
            $csvRow .= $value['brand'].",";
            $csvRow .= $value['vendor_unique_id'].",";
            $csvRow .= $value['vrp_no'].",";
            $csvRow .= $value['imei_no'].",";
            $csvRow .= $value['model'].",";
            $csvRow .= $value['ram'].",";
            $csvRow .= $value['rom'].",";
            $csvRow .= $value['color'].",";
            $csvRow .= $value['variant_sku'].",";
            $csvRow .= $value['color_sku'].",";
            $csvRow .= $value['grade'].",";
            $csvRow .= $value['description'].",";
            $csvRow .= $value['qty'].",";
            $csvRow .= $value['taxable_amount'].",";
            $csvRow .= $value['exempt_amount'].",";
            $csvRow .= $value['tax_amount'].",";
            $csvRow .= $value['tcs_amount'].",";
            $csvRow .= $value['box_no'].",";
            $csvRow .= $value['procurement_id'].",";
            $csvRow .= $value['procurement_no'].",";
            $csvRow .= $value['accepted_qty'].",";
            $csvRow .= $value['source'].",";
            $csvRow .= $value['category'].",";
            $csvRow .= $value['status'].",";
            $csvRow .= $value['warehouse'].",";
            $csvRow .= $value['amount'].",";
            $csvRow .= $value['payment_ref_no'].",";
            $csvRow .= $value['payment_date'].",";
            $csvRow .= $value['lot_accepted_date'].",";
            $csvRow .= $value['batch_no'].",";
            $csvRow .= $value['sub_category'].",";
            $csvRow .= $value['invoice_no'].",";
            $csvRow .= $value['seller'].",";
            $csvRow .= $value['invoice_value'].",";
            $csvRow .= $value['eway_bill_no']."\n";
        }

        $file="pending_dispatch";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csvRow;
		exit;
    }

    public function getProcurementOthReport()
    {
        $status = $this->input->get('status');
        $FKProcurements = []; // Enetered in Flipkart Module, these details are not available in procurement oth
        if(empty($status)){
            $json['status'] = 0;
            $json['message'] = "Invalid status";
            echo json_encode($json);
            exit;
        }

        if($status == 'ALL'){
            $this->db->where('status !=', "CANCELLED");
        }else{
            $this->db->where('status', $status);
        }

        $procurementQueryResult = $this->db->get('PROCUREMENT_OTH_REPORT_VIEW')->result_array();

        $csvRow = "procurement_id,procurement_no, accepted_qty,source,category,status,warehouse,amount,payment_ref_no,payment_date,";
        $csvRow .= "lot_accepted_date,batch_no,sub_category,invoice_no,seller,invoice_value,eway_bill_no,";
        $csvRow .= "brand,vendor_unique_id,vrp_no,imei_no,model,ram,rom,color,variant_sku,color_sku,grade,";
        $csvRow .= "description,qty,taxable_amount,exempt_amount,tax_amount,tcs_amount,box_no\n";

        foreach($procurementQueryResult as $value){
            if(empty($value['procurement_invoice_id'])){
             continue;   
            }
            $csvRow .= $value['procurement_id'].",";
            $csvRow .= $value['procurement_no'].",";
            $csvRow .= $value['accepted_qty'].",";
            $csvRow .= $value['source'].",";
            $csvRow .= $value['category'].",";
            $csvRow .= $value['status'].",";
            $csvRow .= $value['warehouse'].",";
            $csvRow .= $value['amount'].",";
            $csvRow .= $value['payment_ref_no'].",";
            $csvRow .= $value['payment_date'].",";
            $csvRow .= $value['lot_accepted_date'].",";
            $csvRow .= $value['batch_no'].",";
            $csvRow .= $value['sub_category'].",";
            $csvRow .= trim($value['invoice_no']).",";
            $csvRow .= $value['seller'].",";
            $csvRow .= $value['invoice_value'].",";
            $csvRow .= $value['eway_bill_no'].",";
            $csvRow .= $value['brand'].",";
            $csvRow .= $value['vendor_unique_id'].",";
            $csvRow .= $value['vrp_no'].",";
            $csvRow .= $value['imei_no'].",";
            $csvRow .= $value['model'].",";
            $csvRow .= $value['ram'].",";
            $csvRow .= $value['rom'].",";
            $csvRow .= $value['color'].",";
            $csvRow .= $value['variant_sku'].",";
            $csvRow .= $value['color_sku'].",";
            $csvRow .= $value['grade'].",";
            $csvRow .= trim($value['description']).",";
            $csvRow .= $value['qty'].",";
            $csvRow .= $value['taxable_amount'].",";
            $csvRow .= $value['exempt_amount'].",";
            $csvRow .= $value['tax_amount'].",";
            $csvRow .= $value['tcs_amount'].",";
            $csvRow .= $value['box_no']."\n";
        }

        $file="procurement_oth_report";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csvRow;
		exit;
    }

    public function getProcurementFKReport()
    {
        $status = $this->input->get('status');
        if(empty($status)){
            $json['status'] = 0;
            $json['message'] = "Invalid status";
            echo json_encode($json);
            exit;
        }

        if($status == 'ALL'){
            $this->db->where('status !=', "CANCELLED");
        }else{
            $this->db->where('status', $status);
        }

        $procurementQueryResult = $this->db->get('PROCUREMENT_FK_WSN_VIEW')->result_array();

        $csvRow = "procurement_no, accepted_qty,source,category,status,warehouse,amount,payment_ref_no,payment_date,";
        $csvRow .= "lot_accepted_date,batch_no,sub_category,invoice_no,lot_id,vendor_unique_id,";
        $csvRow .= "imei_no,fsn,product_brand,device_name,qc_remark\n";

        foreach($procurementQueryResult as $value){
            
            $csvRow .= $value['procurement_no'].",";
            $csvRow .= $value['accepted_qty'].",";
            $csvRow .= $value['source'].",";
            $csvRow .= $value['category'].",";
            $csvRow .= $value['status'].",";
            $csvRow .= $value['warehouse'].",";
            $csvRow .= $value['amount'].",";
            $csvRow .= $value['payment_ref_no'].",";
            $csvRow .= $value['payment_date'].",";
            $csvRow .= $value['lot_accepted_date'].",";
            $csvRow .= $value['batch_no'].",";
            $csvRow .= $value['sub_category'].",";
            $csvRow .= trim($value['invoice_no']).",";
            $csvRow .= $value['lot_id'].",";
            $csvRow .= $value['vendor_unique_id'].",";
            $csvRow .= str_replace(',',"",$value['imei_no']).",";
            $csvRow .= trim($value['fsn']).",";
            $csvRow .= $value['product_brand'].",";
            $csvRow .= $value['device_name'].",";
            $csvRow .= $value['qc_remark']."\n";

        }

        $file="procurement_report";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csvRow;
		exit;
    }
}
