<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Prexo_pricing extends Admin_Controller
{

    public function __construct(){
        parent::__construct(); 
    }

    public function manage_prexo_pricing($active = 0){

        if($active > 0){
            $data['active'] = $active;
        }else{
            $data['active'] = 1;
        }

        $data['title'] = 'PREXO PRICING';
        $data['subview'] = $this->load->view('admin/prexo_pricing/manage_prexo_pricing', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getPrexoPriceList()
    {
        $result = $this->db->get('tbl_prexo_ratecard')->result_array();
        $records = array();

        if(!empty($result)){
            foreach($result as $rowValue){
            
                $records[] = array(
                                "prexo_ratecard_id" => $rowValue['prexo_ratecard_id'],
                                "brand" => $rowValue['brand'],
                                "model_name" => $rowValue['model_name'],
                                "b_grade" => $rowValue['b_grade'],
                                "c_grade" => $rowValue['c_grade'],
                                "d_grade" => $rowValue['d_grade'],
                            );
            }
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function exportPrexoPrice(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data) || count($data) <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach($data as $rowValue){

            $prexo_ratecard_id = $this->db->where('model_name', $rowValue['model_name'])->get('tbl_prexo_ratecard')->row()->prexo_ratecard_id;

            if($prexo_ratecard_id > 0){
                $update_array[] = array(
                                    "prexo_ratecard_id"=> $prexo_ratecard_id,
                                    "b_grade" => $rowValue['b_grade'],
                                    "c_grade" => $rowValue['c_grade'],
                                    "d_grade" => $rowValue['d_grade'],
                                    "last_updated_by" => $this->session->userdata('user_id'),
                                    "last_update_date" => date("Y-m-d H:i:s")
                                );
            }else{
                $insert_array[] = array(
                                    "brand" => $rowValue['brand'],
                                    "model_name" => $rowValue['model_name'],
                                    "b_grade" => $rowValue['b_grade'],
                                    "c_grade" => $rowValue['c_grade'],
                                    "d_grade" => $rowValue['d_grade'],
                                    "created_by" => $this->session->userdata('user_id'),
                                    "creation_date" => date("Y-m-d H:i:s")
                                ); 
            }
        }

        $this->db->trans_start();

        if(sizeof($update_array)>0){
            
            $this->db->update_batch('tbl_prexo_ratecard', $update_array, 'prexo_ratecard_id');
            $error = $this->db->error();

            if($error['code'] != 0 ){
                $this->db->trans_rollback();
                $json['statud'] = 0;
                echo json_encode($json);
                exit;
            }
        }

        if(sizeof($insert_array)>0){
            
            $this->db->insert_batch('tbl_prexo_ratecard', $insert_array);
            $error = $this->db->error();

            if($error['code'] != 0 ){
                $this->db->trans_rollback();
                $json['statud'] = 0;
                echo json_encode($json);
                exit;
            }
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
}