<?php

class Payments extends Admin_Controller{

    public function __construct()
    {
        parent::__construct();
    }

    public function manage_payments($active = 0){

        $data["title"] = "PAYMENTS";

        if($active>0){

            $data['active'] = $active;
        }else{

            $data['active'] = 1;
        }

        $data['title'] = 'PAYMENTS';

        $data['subview'] = $this->load->view('admin/payments/manage_payments', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }

    public function getPaymentsList(){

        $status = $this->input->get('status');
        $saletype = $this->input->get('saletype');

        if($saletype == 'OFFLINE'){
            $this->db->where('sales_channel', 'OFFLINE');
        }

        if($saletype == 'ONLINE'){
            $this->db->where('sales_channel !=', 'OFFLINE');
        }

        if($status != ''){
            $this->db->where('status', $status);
        }

        $result = $this->db->get('SUPPLIER_PAYMENT_VIEW')->result_array();
        $rows = array();

        if(!empty($result)){

            foreach($result as $rowValue){

                $rows[] = array(
				     "supplier_payment_id"=>$rowValue['supplier_payment_id'],
                    "payment_no"=>$rowValue['payment_no'],
                    "invoice_no" => $rowValue["invoice_no"],
                    "company" => $rowValue["company"],
                    "invoice_date" => date('d-m-Y',strtotime($rowValue["invoice_date"])),
                    "invoice_qty" => $rowValue["invoice_qty"],
                    "invoice_value" => $rowValue["invoice_value"],
                    "bank_account" => $rowValue["bank_account"],
                    "reference_no" => $rowValue["reference_no"],
                    "amount" => $rowValue["amount"],
				    "created_date" => date('d-m-Y',strtotime($rowValue["created_date"])),
                );
            }
        }

        $json["data"] = $rows;
        echo json_encode($json);
        exit;
    }

    public function getPaymentDetails(){

        $salesorder_id = $this->input->get('salesorder_id');
        
        if( (int) $salesorder_id <= 0){
            
            $json['result'] = array();
            echo json_encode($json);
            exit;
        }

        $this->db->select('bank_account, reference_no, payment_date, amount');
        $this->db->from('tbl_payments_so');
        $this->db->where('salesorder_id', $salesorder_id);

        $result = $this->db->get()->result_array();

        if(!empty($result)){

            foreach ($result as $rowValue){

                $rows[] = array(
                    "bank_account" => $rowValue['bank_account'],
                    "reference_number" => $rowValue['reference_no'],
                    "payment_date" => date("d-m-Y", strtotime($rowValue["payment_date"])),
                    "amount" => $rowValue["amount"]
                );
            }
        }
        $json["result"] = $rows;
        echo json_encode($json);
        die;
    }

    public function getinvoicelist($vendor_id = 0)
	{    

		if((int) $vendor_id <= 0){
			
			$json["result"] = array();
			echo json_encode($json);
			die;
		}
		$start_date = $this->db->select('value')->where('config_key', 'insight_purchase_start_date')->get('tbl_config')->row()->value;
        
        $this->db->where("DATE(invoice_date) >=", $start_date);
		$result = $this->db->where('supplier_id', $vendor_id)->get('SUPPLIER_PAYMENT_INVOICE_LIST_VIEW')->result_array();
		$rows = array();
		
		if(!empty($result)){

			foreach($result as $rowValue){
                if($rowValue['paid_amount'] < $rowValue['invoice_value']){
                    $rows[] = array(
                        "admin_id"=> $rowValue["admin_id"],
                        "invoice_no" => $rowValue["invoice_no"],
                        "invoice_amount" => $rowValue["invoice_value"],
                        "invoice_date" => date("d-m-Y", strtotime($rowValue["invoice_date"]))
                    );
                }
			}
		}

		$json['result'] = $rows;
		
		echo json_encode($json);
		die;
	}

    public function getPaymentDetailsByInvoice(){

        $invoice_id = $this->input->get('invoice_id');
        
        if( (int) $invoice_id <= 0){
            
            $json['result'] = array();
            echo json_encode($json);
            exit;
        }

        $this->db->where('admin_id', $invoice_id);
        $result = $this->db->get('tbl_supplier_payment')->result_array();

        if(!empty($result)){

            foreach ($result as $rowValue){

                $rows[] = array(
                    "bank_account" => $rowValue['bank_account'],
                    "reference_no" => $rowValue['reference_no'],
                    "created_date" => date("d-m-Y", strtotime($rowValue["created_date"])),
                    "amount" => $rowValue["amount"]
                );
            }
        }

        $json["result"] = $rows;
        echo json_encode($json);
        die;
    }

    public function createPayment(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $salesorder_id = $data["salesorder_id"];

        if(empty($data) || (int) $salesorder_id <= 0){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $bank_account=$data['payment_details'];
        $payments = [];

        foreach($bank_account as $payment_row){

            $received_date = $payment_row['received_date'];
            if(!empty($received_date)){
                $received_date = str_replace("/", "-",$received_date);
                $received_date = date('Y-m-d', strtotime($received_date));
                if($received_date=='1970-01-01'){
                    $received_date='';
                }
    
                $payments[] = array(
                        'salesorder_id'=>$salesorder_id,
                        'bank_account'=>$payment_row['bank_account'],
                        'reference_no'=>$payment_row['payment_ref'],
                        'payment_date'=>$received_date,
                        'amount'=>$payment_row['received_amount'],
                );
            }	
        }

        if(empty($payments)){
            
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $this->db->insert_batch('tbl_payments_so', $payments);
        $error = $this->db->error();

        if($error['code'] != 0){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
		
    }
	
	public function createSupplierPayment(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
         
		 $user_id = $this->session->userdata('user_id');

        $supplier_id = $data["supplier_id"];
        $admin_id = $data["admin_id"];
		
		

        if(empty($data) || (int) $supplier_id <= 0){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
           
		$res = $this->db->select('max(CAST(SUBSTRING_INDEX(payment_no,"-",-1) as UNSIGNED)) as max')->from('tbl_supplier_payment')->get()->row_array();
        $next_number = $res['max']+1;
        $payment_no = 'PYMT-'.$next_number;
   
        $bank_account=$data['payment_details'];
        $payments = [];

        foreach($bank_account as $payment_row){

            $received_date = $payment_row['received_date'];
            if(!empty($received_date)){
                $received_date = str_replace("/", "-",$received_date);
                $received_date = date('Y-m-d', strtotime($received_date));
                if($received_date=='1970-01-01'){
                    $received_date='';
                }
    
                $Supplierpayments[] = array(
				        'payment_no'=>$payment_no,
						'admin_id'=>$admin_id,
						'vendor_id'=>$supplier_id,
                        'bank_account'=>$payment_row['bank_account'],
                        'reference_no'=>$payment_row['payment_ref'],
						'amount'=>$payment_row['received_amount'],
                        'created_date'=>$received_date,
                        "created_by" => $user_id
                );
            }	
        }

        if(empty($Supplierpayments)){
            
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
         
		
        $this->db->insert_batch('tbl_supplier_payment', $Supplierpayments);
        $error = $this->db->error();

        if($error['code'] != 0){

            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function viewPaymentsVendorwise(){

        $vendor_id = $this->input->get('vendor_id');

        if( (int) $vendor_id <= 0){
            
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        
        $this->db->where('vendor_id', $vendor_id);
        $this->db->from('PAYMENT_SALESORDER_LIST_VIEW');
        $this->db->join('tbl_payments_so', 'PAYMENT_SALESORDER_LIST_VIEW.salesorder_id = tbl_payments_so.salesorder_id','Left');
        
        $result = $this->db->get()->result_array();
        $rows = array();

        if(!empty($result)){

            foreach($result as $rowValue){
                
                $payment_date = date("d-m-Y", strtotime($rowValue["payment_date"]));
                if($payment_date == '01-01-1970'){
                    $payment_date = '';
                }

                $rows[] = array(
                    "salesorder_id" => $rowValue["salesorder_id"],
                    "salesorder_code" => $rowValue["salesorder_code"],
                    "payment_mode" => $rowValue["payment_mode"],
                    "status" => str_replace('_',' ',$rowValue["status"]),
                    "bank_account" => $rowValue["bank_account"],
                    "reference_no" => $rowValue["reference_no"],
                    "payment_date" => $payment_date,
                    "payment_amount" => $rowValue["amount"],
                    "creation_date" => date("d-m-Y", strtotime($rowValue["CREATION_DATE"])),
                    "total_amount" => $rowValue["total_amount"],
                );
            }
        }

        $json["data"] = $rows;
        echo json_encode($json);
        exit;
    }
	public function editsupplierpayments($payment_id){
		
		$data['payment_id'] = $payment_id;
		$data['title'] = "EDIT SUPPLIER PAYMENT";
		$data["active"] = 5;
		$data['subview'] = $this->load->view('admin/payments/manage_payments', $data, TRUE); 
        $this->load->view('admin/_layout_main', $data); //page load
    }
    
	public function getsupplierdetails(){

        $supplier_payment_id = $this->input->get('payment_id');

        $result = $this->db->where('supplier_payment_id', $supplier_payment_id)->get('SUPPLIER_PAYMENT_VIEW')->row();
        
        $result_admin = $this->db->where('supplier_payment_id', $supplier_payment_id)->get('tbl_supplier_payment')->row();
        if(empty($result)){
        
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['data'] = array(
                            "admin_id"=>$result_admin->admin_id,
                            "invoice_no" => $result->invoice_no,
                            "company" => $result->company,
                            "invoice_date" => date("Y-m-d", strtotime($result->invoice_date)),
                            "invoice_qty" => $result->invoice_qty,
                            "invoice_value" => $result->invoice_value,
                            "bank_account" => $result->bank_account,
                            "reference_no" => $result->reference_no,
                            "amount" => $result->amount,
                            "quantity" => $result->invoice_qty,
                            "created_date" =>  date("Y-m-d", strtotime($result->created_date)),

                         );

        $json['status'] = 1;
        echo json_encode($json);
        exit;
  }

    public function updateSupplierPayment(){
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);  
        
        if(empty($data)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }       

        $update_supplier_payment = array( 
                        'supplier_payment_id'=>$data['payment_id'],
                        'bank_account'=>$data['bank_account'],      
                        'reference_no' => $data['reference_no'],              
                        'amount' => $data['paid_amount'],
                        'created_date' =>  date("Y-m-d", strtotime($data['paid_date'])),
                    );
                    

        $this->db->update('tbl_supplier_payment',$update_supplier_payment,array('supplier_payment_id'=>$update_supplier_payment['supplier_payment_id']));
        $error = $this->db->error();

        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        
        
        // $update_security_admin = array( 
        //     'admin_id' =>$data['admin_id'],
        //     'invoice_qty'=>$data['invoice_qty'],
            
        // );
        
        // $this->db->update('tbl_security_admin',$update_security_admin,array('admin_id'=>$update_security_admin['admin_id']));
            
        // $error = $this->db->error();

        // if($error['code'] != 0){
        // $json['status'] = 0;
        // echo json_encode($json);
        // die;
        // }

        $json['status'] = 1;
        echo json_encode($json);
        die;
        
    }

}