<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Model_mismatch extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('cliq_api');
    }

    public function manage_model_mismatch($active = 0)
    {
        if($active > 0){
            $data['active'] = $active;
        }else{
            $data['active'] = 1;
        }

        $data['title'] = 'MODEL MISMATCH';
        $data['subview'] = $this->load->view('admin/model_mismatch/manage_model_mismatch', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getModelMismatchList()
    {   
        $status = $this->input->get('status');
        $records = array();
        $result = $this->db->where('status',$status)->get('MODEL_MISMATCH_LIST_VIEW')->result_array();
        if(!empty($result)){

            foreach($result as $rowValue){
                $records[] = array(
                                "model_mismatch_id" => $rowValue['model_mismatch_id'],
                                "grnreport_id" => $rowValue['grnreport_id'],
                                "device_id" => $rowValue['device_id'],
                                "status" => $rowValue['status'],
                                "mismatch_type" => $rowValue["mismatch_type"],
                                "expected_ram" => $rowValue["expected_ram"],
                                "expected_rom" => $rowValue["expected_rom"],
                                "expected_device_name" => $rowValue["expected_device_name"],
                                "expected_unit_price" => $rowValue["expected_unit_price"],
                                "expected_unit_price_tax" => $rowValue["expected_unit_price_tax"],
                                "received_ram" => $rowValue["received_ram"],
                                "received_rom" => $rowValue["received_rom"],
                                "received_device_name" => $rowValue["received_device_name"],
                                "received_unit_price" => $rowValue["received_unit_price"],
                                "received_unit_price_tax" => $rowValue["received_unit_price_tax"],
                                "creation_date" => date("d-m-Y", strtotime($rowValue['date'])),
                                "created_by" => $rowValue["created_by"]
                        );
            }
        }

        $json['data'] = $records;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getModelMismatchHeader()
    {
        $model_mismatch_id = $this->input->get('model_mismatch_id');
        if((int) $model_mismatch_id <= 0){
            $json['status'] = 0;
            $json['result'] = array();
            echo json_encode($json);
            exit;
        }
        $records = array();
        $result = $this->db->where('model_mismatch_id', $model_mismatch_id)->get('MODEL_MISMATCH_LIST_VIEW')->row();
        if(!empty($result)){

            $records = array(
                            "model_mismatch_id" => $result->model_mismatch_id,
                            "grnreport_id" => $result->grnreport_id,
                            "device_id" => $result->device_id,
                            "mismatch_type" => $result->mismatch_type,
                            "expected_ram" => $result->expected_ram,
                            "expected_rom" => $result->expected_rom,
                            "expected_device_name" => $result->expected_device_name,
                            "expected_unit_price" => $result->expected_unit_price,
                            "expected_unit_price_tax" => $result->expected_unit_price_tax,
                            "received_ram" => $result->received_ram,
                            "received_rom" => $result->received_rom,
                            "received_device_name" => $result->received_device_name,
                            "received_unit_price" => $result->received_unit_price,
                            "received_unit_price_tax" => $result->received_unit_price_tax,
                            "creation_date" => date("d-m-Y", strtotime($result->date)),
                            "created_by" => $result->created_by
                    );
        }

        $json['result'] = $records;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getDeviceDetails()
    {
        $device_id = $this->input->get('device_id');

        if(empty($device_id)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('nhdin', $device_id)->get('tbl_grnreport')->row();
        $error = $this->db->error();
        if(empty($result) || $error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $record = array(
                    "grnreport_id" => $result->grnreport_id,
                    "ram" => $result->ram,
                    "rom" => $result->rom,
                    "device_name" => $result->device_name,
                    "unit_price" => $result->unit_price,
                    "unit_price_tax" => $result->unit_price_tax,
                );

        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }

    public function getDeviceNamesList()
    {
        $result = $this->db->select('nhmod, product_name')->order_by('product_name','asc')->get('tbl_product_details')->result_array();
        $records = array();

        if(!empty($result)){
            foreach($result as $rowValue){
                $records[] = array(
                                "product_name" => $rowValue['product_name'],
                                "nhmod" => $rowValue['nhmod']
                            );
            }
        }

        $json['status'] = 1;
        $json['result'] = $records;
        echo json_encode($json);
        exit;
    }
    
    public function newModelMismatch()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        $grnreport_id = $data['grnreport_id'];
        if(empty($data['grnreport_id'])){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $check = $this->db->where('grnreport_id', $grnreport_id)->get('tbl_model_mismatch')->num_rows();

        if($check > 0){
            $json['status'] = 2; // Record Already Exists
            echo json_encode($json);
            exit;
        }

        $grade_result = $this->db->where(array('value'=>trim($data["received_ram"]),'type'=>'RAM'))->get('tbl_device_memory')->row();
        if(empty($grade_result)){
            $msg="Invalid RAM - #".$data["received_ram"];	
            $json['status'] = 0;
            $json['message'] = $msg;
            echo json_encode($json);
            exit;
        }

        $grade_result = $this->db->where(array('value'=>trim($data["received_rom"]),'type'=>'ROM'))->get('tbl_device_memory')->row();
        if(empty($grade_result)){
            $msg="Invalid ROM - #".$data["received_rom"];	
            $json['status'] = 0;
            $json['message'] = $msg;
            echo json_encode($json);
            exit;
        }

        $record = array(
            "grnreport_id" => $data["grnreport_id"],
            "mismatch_type" => $data["mismatch_type"],
            "expected_ram" => $data["expected_ram"],
            "expected_rom" => $data["expected_rom"],
            "expected_device_name" => $data["expected_device_name"],
            "received_model" => $data["received_model"],
            "received_rom" => strtoupper($data["received_rom"]),
            "received_ram" => strtoupper($data["received_ram"]),
            "status" => 'FINANCE_PENDING',
            "created_by" => $this->session->userdata('user_id')
        );

        $this->db->insert('tbl_model_mismatch', $record);
        
        $error = $this->db->error();
        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $mismatch_id = $this->db->insert_id();

        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$mismatch_id,
                'reference_type'=>'model_mismatch',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark',$remark_array);
        }
        $this->cliq_api->postModelMismtachImage($mismatch_id);
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateModelMismatch()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);
        $model_mismatch_id = $data['model_mismatch_id'];
        if(empty($data['model_mismatch_id'])){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $model_det = $this->db->where('model_mismatch_id', $model_mismatch_id)->get('tbl_model_mismatch')->row();

        if(empty($model_det)){
            $json['status'] = 0; 
            $json['message'] = "Invalid Model Mismatch ID";
            echo json_encode($json);
            exit;
        }

        if($data['received_unit_price'] <= 0){
            $json['status'] = 0;
            $json['message'] = "Invalid Received Unit Price";
            echo json_encode($json);
            exit;
        }

        if($data['received_unit_price_tax'] < 0){
            $json['status'] = 0;
            $json['message'] = "Invalid Received Unit Price Tax";
            echo json_encode($json);
            exit;
        }

        $color = $this->db->select('color')->where('grnreport_id', $model_det->grnreport_id)->get('tbl_grnreport')->row()->color;

        $record = array(
            "mismatch_type" => $data["mismatch_type"],
            "received_unit_price" => $data["received_unit_price"],
            "received_unit_price_tax" => $data["received_unit_price_tax"],
            "status" =>'FINANCE_APPROVED',
            "last_updated_by" => $this->session->userdata('user_id')
        );

        $sku = $this->Common_model->getSKU($model_det->received_model,$model_det->received_ram,$model_det->received_rom,$color);

        $grnreport_update = array(
            "sku" => $sku,
            "ram" => $model_det->received_ram,
            "rom" => $model_det->received_rom,
            "nhmod" => $model_det->received_model,
            "user_id" => $this->session->userdata('user_id'),
            "remark" => "MODEL MISMATCH UPDATE",
        );

        $this->db->trans_start();

        $this->db->where("model_mismatch_id", $model_mismatch_id);
        $result = $this->db->update('tbl_model_mismatch', $record);
        
        $error = $this->db->error();
        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            $json['message'] = $error['message'];
            echo json_encode($json);
            exit;
        }

        $this->db->where("grnreport_id", $model_det->grnreport_id);
        $this->db->update('tbl_grnreport', $grnreport_update);

        $error = $this->db->error();
        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            $json['message'] = $error['message'];
            echo json_encode($json);
            exit;
        }

        $this->db->trans_complete();
        
        if(!empty($data['remarks_header'])){
            
            $remark_array=array(
                'reference_id'=>$model_mismatch_id,
                'reference_type'=>'model_mismatch',
                'user_id'=>$this->session->userdata('user_id'),
                'remark'=>$data['remarks_header'],
                "date"=>date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark',$remark_array);
        }
        $this->cliq_api->postModelMismtachImage($model_mismatch_id);
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function editModelMismatchForm($model_mismatch_id = 0) 
    {
        if( $model_mismatch_id > 0){
            $data['active'] = 3;
            $data['title'] = 'EDIT MODEL MISMATCH';
            $data['edit_model_mismatch_id'] = $model_mismatch_id;
        }else{
            $data['active'] = 1;
            $data['title'] = 'MODEL MISMATCH';
        }
        $data['subview'] = $this->load->view('admin/model_mismatch/manage_model_mismatch', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }
}
