<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Marketplace_charges extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('auditlog_model');

    }

    public function manage_marketplace_charges($active = 0){

        $data['active'] = 1;

        if($active > 0){

            $data['active'] = $active;
        }

        $data['title'] = 'MARKETPLACE CHARGES';

        $data['subview'] = $this->load->view('admin/marketplace_charges/manage_marketplace_charges', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function updateMarketplaceChargesForm($marketplace_receipt_matrix_id = 0){


        if($marketplace_receipt_matrix_id > 0){

            $data['marketplace_receipt_matrix_id'] = $marketplace_receipt_matrix_id;
            $data['active'] = 3;
            $data['title'] = 'UPDATE MARKETPLACE CHARGES';
        }else{
            $data['active'] = 1;
            $data['title'] = 'MARKETPLACE CHARGES';

        }

        $data['subview'] = $this->load->view('admin/marketplace_charges/manage_marketplace_charges', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }


    public function newMarketplaceCharges(){
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data['saleschannel']) || empty($data['stock_type'])){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $check_where = array(
                        "saleschannel" => $data['saleschannel'],
                        "stock_type" => $data['stock_type']
                    );
        $check = $this->db->where($check_where)->from('tbl_marketplace_receipt_matrix')->count_all_results();
        if($check>0){
            $json['status'] = 0;
            $json['message'] = 'Charges for '.$data['saleschannel'].'-'.$data['stock_type'].' Already Exists';
            echo json_encode($json);
            exit;
        }

        $record = array(
                    "saleschannel" => $data['saleschannel'],
                    "stock_type" => $data['stock_type'],
                    "commission_fee" => $data['commission_fee'],
                    "commission_fee_tax" => $data['commission_fee_tax'],
                    "fixed_closing_fee" => $data['fixed_closing_fee'],
                    "fixed_closing_fee_tax" => $data['fixed_closing_fee_tax'],
                    "collection_fee" => $data['collection_fee'],
                    "collection_fee_tax" => $data['collection_fee_tax'],
                    "pick_pack_fee" => $data['pick_pack_fee'],
                    "pick_pack_fee_tax" => $data['pick_pack_fee_tax'],
                    "weight_handling_fee" => $data['weight_handling_fee'],
                    "weight_handling_fee_tax" => $data['weight_handling_fee_tax'],
                    "courier_local_fee" => $data['courier_local_fee'],
                    "courier_local_fee_tax" => $data['courier_local_fee_tax'],
                    "courier_regional_fee" => $data['courier_regional_fee'],
                    "courier_regional_fee_tax" => $data['courier_regional_fee_tax'],
                    "courier_national_fee" => $data['courier_national_fee'],
                    "courier_national_fee_tax" => $data['courier_national_fee_tax'],
                    "f1_services_fee" => $data['f1_services_fee'],
                    "f1_services_fee_tax" => $data['f1_services_fee_tax'],
                    "tcs_fee" => $data['tcs_fee'],
                    "created_by" => $this->session->userdata('user_id'),
                    "creation_date" => date("Y-m-d H:i:s")
                );

        $result = $this->db->insert('tbl_marketplace_receipt_matrix', $record);
        $error = $this->db->error();

        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;

    }

    public function updateMarketplaceCharges(){
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data['marketplace_receipt_matrix_id']) || (int) $data['marketplace_receipt_matrix_id'] <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
       
        $record = array(
                    "marketplace_receipt_matrix_id" => $data["marketplace_receipt_matrix_id"],
                    "commission_fee" => $data['commission_fee'],
                    "commission_fee_tax" => $data['commission_fee_tax'],
                    "fixed_closing_fee" => $data['fixed_closing_fee'],
                    "fixed_closing_fee_tax" => $data['fixed_closing_fee_tax'],
                    "collection_fee" => $data['collection_fee'],
                    "collection_fee_tax" => $data['collection_fee_tax'],
                    "pick_pack_fee" => $data['pick_pack_fee'],
                    "pick_pack_fee_tax" => $data['pick_pack_fee_tax'],
                    "weight_handling_fee" => $data['weight_handling_fee'],
                    "weight_handling_fee_tax" => $data['weight_handling_fee_tax'],
                    "courier_local_fee" => $data['courier_local_fee'],
                    "courier_local_fee_tax" => $data['courier_local_fee_tax'],
                    "courier_regional_fee" => $data['courier_regional_fee'],
                    "courier_regional_fee_tax" => $data['courier_regional_fee_tax'],
                    "courier_national_fee" => $data['courier_national_fee'],
                    "courier_national_fee_tax" => $data['courier_national_fee_tax'],
                    "f1_services_fee" => $data['f1_services_fee'],
                    "f1_services_fee_tax" => $data['f1_services_fee_tax'],
                    "tcs_fee" => $data['tcs_fee'],
                    "last_updated_by" => $this->session->userdata('user_id'),
                    "last_update_date" => date("Y-m-d H:i:s")
                );
            
        $this->db->where('marketplace_receipt_matrix_id', $data['marketplace_receipt_matrix_id']);
        $result = $this->db->update('tbl_marketplace_receipt_matrix', $record);
        $error = $this->db->error();
//print $this->db->last_query();exit;
        if($error['code'] != 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;

    }

    public function getMarketplaceChargesList(){

        $result = $this->db->get('tbl_marketplace_receipt_matrix')->result_array();
        $records = array();
        
        foreach($result as $rowValue){
            
            $records[] = array(
                "marketplace_receipt_matrix_id" => $rowValue['marketplace_receipt_matrix_id'],
                "saleschannel" => $rowValue['saleschannel'],
                "stock_type" => $rowValue['stock_type'],
                "commission_fee" => $rowValue['commission_fee'],
                "commission_fee_tax" => $rowValue['commission_fee_tax'],
                "fixed_closing_fee" => $rowValue['fixed_closing_fee'],
                "fixed_closing_fee_tax" => $rowValue['fixed_closing_fee_tax'],
                "collection_fee" => $rowValue['collection_fee'],
                "collection_fee_tax" => $rowValue['collection_fee_tax'],
                "pick_pack_fee" => $rowValue['pick_pack_fee'],
                "pick_pack_fee_tax" => $rowValue['pick_pack_fee_tax'],
                "weight_handling_fee" => $rowValue['weight_handling_fee'],
                "weight_handling_fee_tax" => $rowValue['weight_handling_fee_tax'],
                "courier_local_fee" => $rowValue['courier_local_fee'],
                "courier_local_fee_tax" => $rowValue['courier_local_fee_tax'],
                "courier_regional_fee" => $rowValue['courier_regional_fee'],
                "courier_regional_fee_tax" => $rowValue['courier_regional_fee_tax'],
                "courier_national_fee" => $rowValue['courier_national_fee'],
                "courier_national_fee_tax" => $rowValue['courier_national_fee_tax'],
                "f1_services_fee" => $rowValue['f1_services_fee'],
                "f1_services_fee_tax" => $rowValue['f1_services_fee_tax'],
                "tcs_fee" => $rowValue['tcs_fee'],
                "created_by" => $rowValue['created_by'],
                "last_updated_by" => $rowValue['last_updated_by'],
                "creation_date" => date("d-m-Y", $rowValue['creation_date']),
                "last_update_date" => date("d-m-Y", $rowValue['last_update_date']),
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getMarketplaceChargesHeader(){

        $marketplace_receipt_matrix_id = $this->input->get('marketplace_receipt_matrix_id');

        if((int) $marketplace_receipt_matrix_id <= 0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('marketplace_receipt_matrix_id', $marketplace_receipt_matrix_id)->get('tbl_marketplace_receipt_matrix')->row();
        $record = array();
        if(!empty($result)){           
            $record = array(
                "marketplace_receipt_matrix_id" => $result->marketplace_receipt_matrix_id,
                "saleschannel" => $result->saleschannel,
                "stock_type" => $result->stock_type,
                "commission_fee" => $result->commission_fee,
                "commission_fee_tax" => $result->commission_fee_tax,
                "fixed_closing_fee" => $result->fixed_closing_fee,
                "fixed_closing_fee_tax" => $result->fixed_closing_fee_tax,
                "collection_fee" => $result->collection_fee,
                "collection_fee_tax" => $result->collection_fee_tax,
                "pick_pack_fee" => $result->pick_pack_fee,
                "pick_pack_fee_tax" => $result->pick_pack_fee_tax,
                "weight_handling_fee" => $result->weight_handling_fee,
                "weight_handling_fee_tax" => $result->weight_handling_fee_tax,
                "courier_local_fee" => $result->courier_local_fee,
                "courier_local_fee_tax" => $result->courier_local_fee_tax,
                "courier_regional_fee" => $result->courier_regional_fee,
                "courier_regional_fee_tax" => $result->courier_regional_fee_tax,
                "courier_national_fee" => $result->courier_national_fee,
                "courier_national_fee_tax" => $result->courier_national_fee_tax,
                "f1_services_fee" => $result->f1_services_fee,
                "f1_services_fee_tax" => $result->f1_services_fee_tax,
                "tcs_fee" => $result->tcs_fee,
                "created_by" => $result->created_by,
                "last_updated_by" => $result->last_updated_by,
                "creation_date" => date("d-m-Y", $result->creation_date),
                "last_update_date" => date("d-m-Y", $result->last_update_date),
            );
        }
        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }

    public function getEcomBreakdown(){

        $salesorder_id = $this->input->get('salesorder_id');

        if((int) $salesorder_id <= 0 || empty($salesorder_id)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $saleschannel_obj = $this->db->select('sales_channel')->where('salesorder_id', $salesorder_id)->get('tbl_salesorder')->row();

        $this->db->select('sum(amount) as total_amount, category')->where('salesorder_id', $salesorder_id);
        $result = $this->db->group_by('category')->get('tbl_salesorder_item')->result_array();
        
        $openbox_cat = ["OPEN BOX", "DEMO"];
        $openbox_amount = 0;
        $preowned_amount = 0;
        
        foreach($result as $rowValue){

            if(in_array($rowValue['category'], $openbox_cat)){
                $openbox_amount += $rowValue['total_amount'];
            }else{
                $preowned_amount += $rowValue['total_amount'];
            }
        }
        $openbox_amount_excl_tax = $openbox_amount/1.18;
        $preowned_amount_excl_tax = $preowned_amount/1.18;

        $breakdown_values = $this->db->where('saleschannel', $saleschannel_obj->sales_channel)->get('tbl_marketplace_receipt_matrix')->result_array();

        if(empty($breakdown_values)){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $commission_fee = 0;
        $commission_fee_tax = 0;

        $fixed_closing_fee = 0;
        $fixed_closing_fee_tax = 0;

        $collection_fee = 0;
        $collection_fee_tax = 0;

        $pick_pack_fee = 0;
        $pick_pack_fee_tax = 0;

        $weight_handling_fee = 0;
        $weight_handling_fee_tax = 0;

        $courier_local_fee = 0;
        $courier_local_fee_tax = 0;

        $courier_regional_fee = 0;
        $courier_regional_fee_tax = 0;

        $courier_national_fee = 0;
        $courier_national_fee_tax = 0;

        $f1_services_fee = 0;
        $f1_services_fee_tax = 0;

        $tcs_fee = 0;

        foreach($breakdown_values as $row){
            $total_amount = 0;
            $total_amount_excl_tax = 0;
            
            if($row['stock_type'] == 'OPEN BOX'){
                $total_amount = $openbox_amount;
                $total_amount_excl_tax = $openbox_amount_excl_tax;
            }

            if($row['stock_type'] == 'PRE-OWNED'){
                $total_amount = $preowned_amount;
                $total_amount_excl_tax = $preowned_amount_excl_tax;

            }
            
            if($total_amount == 0){
                continue;
            }
            $commission_fee_row = $total_amount*$row['commission_fee']/100;
            $commission_fee += $commission_fee_row;
            $commission_fee_tax += $commission_fee_row*$row['commission_fee_tax']/100;

            $fixed_closing_fee += $row['fixed_closing_fee'];
            $fixed_closing_fee_tax += $row['fixed_closing_fee']*$row['fixed_closing_fee_tax']/100;

            $collection_fee_row = $total_amount*$row['collection_fee']/100;
            $collection_fee += $collection_fee_row;
            $collection_fee_tax += $collection_fee_row*$row['collection_fee_tax']/100;

            $pick_pack_fee += $row['pick_pack_fee'];
            $pick_pack_fee_tax += $row['pick_pack_fee']*$row['pick_pack_fee_tax']/100;

            $weight_handling_fee += $row['weight_handling_fee'];
            $weight_handling_fee_tax += $row['weight_handling_fee']*$row['weight_handling_fee_tax']/100;

            $courier_local_fee += $row['courier_local_fee'];
            $courier_local_fee_tax += $row['courier_local_fee']*$row['courier_local_fee_tax']/100;

            $courier_regional_fee += $row['courier_regional_fee'];
            $courier_regional_fee_tax += $row['courier_regional_fee']*$row['courier_regional_fee_tax']/100;

            $courier_national_fee += $row['courier_national_fee'];
            $courier_national_fee_tax += $row['courier_national_fee']*$row['courier_national_fee_tax']/100;

            $f1_services_fee_row = $total_amount*$row['f1_services_fee']/100;
            $f1_services_fee += $f1_services_fee_row;
            $f1_services_fee_tax += $f1_services_fee_row*$row['f1_services_fee_tax']/100;

            $tcs_fee += $total_amount_excl_tax*$row['tcs_fee']/100;
        }

        $record = array(
                    
                    "commission_fee" => number_format($commission_fee,2),
                    "commission_fee_tax" => number_format($commission_fee_tax,2),
                    "commission_fee_total" => $commission_fee + $commission_fee_tax,
                    
                    "fixed_closing_fee" => number_format($fixed_closing_fee,2),
                    "fixed_closing_fee_tax" => number_format($fixed_closing_fee_tax,2),
                    "fixed_closing_fee_total" => number_format($fixed_closing_fee + $fixed_closing_fee_tax,2),
                    
                    "collection_fee" => number_format($collection_fee,2),
                    "collection_fee_tax" => number_format($collection_fee_tax,2),
                    "collection_fee_total" => number_format($collection_fee + $collection_fee_tax,2),
                    
                    "pick_pack_fee" => number_format($pick_pack_fee,2),
                    "pick_pack_fee_tax" => number_format($pick_pack_fee_tax,2),
                    "pick_pack_fee_total" => number_format($pick_pack_fee + $pick_pack_fee_tax,2),
                    
                    "weight_handling_fee" => number_format($weight_handling_fee,2),
                    "weight_handling_fee_tax" => number_format($weight_handling_fee_tax,2),
                    "weight_handling_fee_total" => number_format($weight_handling_fee + $weight_handling_fee_tax,2),
                    
                    "courier_local_fee" => number_format($courier_local_fee,2),
                    "courier_local_fee_tax" => number_format($courier_local_fee_tax,2),
                    "courier_local_fee_total" => number_format($courier_local_fee + $courier_local_fee_tax,2),

                    "courier_regional_fee" => number_format($courier_regional_fee,2),
                    "courier_regional_fee_tax" => number_format($courier_regional_fee_tax,2),
                    "courier_regional_fee_total" => number_format($courier_regional_fee + $courier_regional_fee_tax,2),

                    "courier_national_fee" => number_format($courier_national_fee,2),
                    "courier_national_fee_tax" => number_format($courier_national_fee_tax,2),
                    "courier_national_fee_total" => number_format($courier_national_fee + $courier_national_fee_tax,2),
                    
                    "f1_services_fee" => number_format($f1_services_fee,2),
                    "f1_services_fee_tax" => number_format($f1_services_fee_tax,2),
                    "f1_services_fee_total" => number_format($f1_services_fee + $f1_services_fee_tax,2),

                    "tcs_fee"=> number_format($tcs_fee,2),
                    "tcs_fee_tax" => number_format(0,2),
                    "tcs_fee_total" => number_format($tcs_fee,2)

                );

        $json['status'] = 1;
        $json['result'] = $record;
        echo json_encode($json);
        exit;
    }
}