<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Logistic_partner extends Admin_Controller
{

    function __construct()
    {
        parent::__construct();
        
    }

    public function manage_logistic($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }
        $data['title'] = 'LOGISTICS';
        $data['subview'] = $this->load->view('admin/logistic_partner/manage_logistic', $data, TRUE);
        $this->load->view('admin/_layout_main', $data);
    }
    
    //LOGISTIC MANAGEMENT PART START
    
    public function getLogisticList()
    {
        
        $result = $this->db->get('tbl_logistic_partner')->result_array();
        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $result_arr = [];
        $serial_no = 1;
        foreach ($result as $rowValue) {
            
            $updated_by = $this->db->get_where('tbl_account_details', array("user_id" => $rowValue['updated_by']))->row()->fullname;
            if($rowValue['active'] == 1){
                $status = "ACTIVE";
            } else{
                $status = "IN-ACTIVE";
            }
            $result_arr[] = array(
                'serial_no' => $serial_no,
                'partner_id' => $rowValue['partner_id'],
                'name' => $rowValue['name'],
                'url' => $rowValue['url'],
                'active' => $rowValue['active'],
                'status' => $status,
                'updated_by' => $updated_by,
                'created_date' => date("d-m-Y", strtotime($rowValue['created_date'])),
                'updated_date' => date("d-m-Y", strtotime($rowValue['updated_date']))
            );
            $serial_no += 1;
        }

        $response = array(
            'status' => 1,
            'message' => 'Logistic Partners',
            'data' => $result_arr
        );
        echo json_encode($response);
        exit;
    }
    public function addlogistic()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data)) {
            $json['status'] = 0;
            $json['msg'] = "Your not posted any data ";
            echo json_encode($json);
            die;
        }
        $check_count = $this->db->get_where('tbl_logistic_partner', array("name" => $data['logistic_name']))->num_rows();
        if($check_count > 0){
            $json['status'] = 0;
            $json['msg'] = "Your Adding partner is already exist ";
            echo json_encode($json);
            die;
        }
        $add_partner_arr = array(
                "name" => $data['logistic_name'],
                "url" => $data['url'],
                "updated_by" => $this->session->userdata('user_id'),
            );
        
        $this->db->insert('tbl_logistic_partner', $add_partner_arr);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    public function updateActiveStatus()
    {

        $partner_id = $this->input->get('partner_id');
        $active_value = $this->input->get('active_value');

        if (empty($partner_id) || (int)$partner_id <= 0) {
            $json['status'] = 0;
            $json['msg'] = "Logistic Partner is required ";
            echo json_encode($json);
            die;
        }
        $this->db->where('partner_id', $partner_id)->update('tbl_logistic_partner', array("active" => $active_value));

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->trans_complete(); // Complete Mysql Transaction
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    
    public function getLogisticPartners()
    {
        
        $result = $this->db->get('tbl_logistic_partner')->result_array();
        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            die;
        }
        $result_arr = [];
        foreach ($result as $rowValue) {
            
            $result_arr[] = array(
                'partner_id' => $rowValue['partner_id'],
                'name' => $rowValue['name']
            );
        }

        $response = array(
            'status' => 1,
            'result' => $result_arr
        );
        echo json_encode($response);
        exit;
    }
    

}

    
