<?php

class Ledger extends Admin_Controller {

    public function __construct(){
            
        parent::__construct(); 
                        
    }

    public function manage_ledger($active = 0){
        
        if($active <=0){
            
            $data['active'] = 1;
        }else{

            $data['active'] = $active;
        }

        $data['title'] = 'Ledger Reports';

        $data['subview'] = $this->load->view('admin/ledger/manage_ledger', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function getCustomerLedgerList(){

        $vendor_id = $this->input->get('customer_id');

        if(empty($vendor_id) || (int)$vendor_id <= 0){

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        //Get Vendor Name 

        $vendor_obj = $this->db->select('company as vendor_name')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

       //Get Opening Balance
       $where_ob = array(
                        "vendor_id" => $vendor_id,
                        "DATE(balance_date)" => '2020-04-01'
                    );
        $ob_obj = $this->db->select('balance_amount, balance_date')->where($where_ob)->get('tbl_opening_balance')->row();

        //Get Credit

        $credit_arr = $this->db->where('vendor_id', $vendor_id)->get('tbl_receipt')->result_array();

        // Get Debt
        $this->db->select('invoice_code, CREATION_DATE, (total_amount + tcs_amount + freight_amount + insurance_amount - discount_amount) as debit');
        $debt_arr = $this->db->where('vendor_id', $vendor_id)->where('status !=', 'VOID')->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();

        $ledger_arr = array();

        foreach($credit_arr as $creditRow){

            $ledger_arr[] = array(
                                "date" => $creditRow['received_date'],
                                "credit" => $creditRow['received_amount'],
                                "invoice_no" => $creditRow['receipt_no'],
                                "bill_type" => "RECEIPT",
                                "debit" => 0
                            );
        }

        
        foreach($debt_arr as $debitRow){

            $ledger_arr[] = array(
                                "date" => $debitRow['CREATION_DATE'],
                                "credit" => 0,
                                "invoice_no" => $debitRow['invoice_code'],
                                "bill_type" => "INVOICE",
                                "debit" => $debitRow['debit']
                            );
        }

        //sort by date
        usort($ledger_arr,function($a,$b){
            return strtotime($a['date']) > strtotime($b['date']);
        });

        $records = array();
        $balance = 0;

        //Add Opening Balance as First to record

        if(!empty($ob_obj)){

            if($ob_obj->balance_amount >= 0){
                $credit = $ob_obj->balance_amount;
                $debit = '';
            }else{
                $credit = '';
                $debit = -1*$ob_obj->balance_amount;

            }
            $balance = $balance + $credit - $debit;
            
            $records[] = array(
                "customer_name" => $vendor_obj->vendor_name,
                "invoice_no" => '',
                "bill_type" => 'OPENING BALANCE',
                "date" => date('d-m-Y',strtotime($ob_obj->balance_date)),
                "credit" => $credit,
                "debit" => $debit,
                "balance" => $balance
            );


        }

        foreach($ledger_arr as $rowValue){

            if($rowValue['credit']>0){
                $credit = $rowValue['credit'];
            }else{
                $credit = '';
            }

            if($rowValue['debit']>0){
                $debit = $rowValue['debit'];
            }else{
                $debit = '';
            }

            $balance = $balance + $credit - $debit;
            $records[] = array(
                            "customer_name" => $vendor_obj->vendor_name,
                            "invoice_no" => $rowValue['invoice_no'],
                            "bill_type" => $rowValue['bill_type'],
                            "date" => date('d-m-Y',strtotime($rowValue['date'])),
                            "credit" => $credit,
                            "debit" => $debit,
                            "balance" => $balance
                        );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;

    }

    public function getSupplierLedgerList(){

        $vendor_id = $this->input->get('supplier_id');

        if(empty($vendor_id) || (int)$vendor_id <= 0){

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        //Get Vendor Name 

        $vendor_obj = $this->db->select('company as vendor_name')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

        //Get Credit

        $credit_arr = $this->db->where('supplier_id', $vendor_id)->get('tbl_security_admin')->result_array();

        // Get Payment
        $debt_arr = $this->db->where('vendor_id', $vendor_id)->get('tbl_supplier_payment')->result_array();

        $ledger_arr = array();

        foreach($credit_arr as $creditRow){

            $ledger_arr[] = array(
                                "date" => $creditRow['invoice_date'],
                                "credit" => $creditRow['invoice_value'],
                                "invoice_no" => $creditRow['invoice_no'],
                                "bill_type" => "INVOICE",
                                "debit" => 0
                            );
        }

        
        foreach($debt_arr as $debitRow){

            $ledger_arr[] = array(
                                "date" => $debitRow['created_date'],
                                "credit" => 0,
                                "invoice_no" => $debitRow['supplier_payment_id'],
                                "bill_type" => "PAYMENT",
                                "debit" => $debitRow['amount']
                            );
        }

        //sort by date
        usort($ledger_arr,function($a,$b){
            return strtotime($a['date']) > strtotime($b['date']);
        });

        $records = array();
        $balance = 0;
        foreach($ledger_arr as $rowValue){

            if($rowValue['credit']>0){
                $credit = $rowValue['credit'];
            }else{
                $credit = '';
            }

            if($rowValue['debit']>0){
                $debit = $rowValue['debit'];
            }else{
                $debit = '';
            }

            $balance = $balance + $rowValue['credit'] - $rowValue['debit'];

            $records[] = array(
                            "supplier_name" => $vendor_obj->vendor_name,
                            "invoice_no" => $rowValue['invoice_no'],
                            "bill_type" => $rowValue['bill_type'],
                            "date" => date('d-m-Y',strtotime($rowValue['date'])),
                            "credit" => $credit,
                            "debit" => $debit,
                            "balance" => $balance
                        );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;

    }

    
    public function getCustomerLedgerExcel(){
        $vendor_id = $this->input->get('customer_id');

        if(empty($vendor_id) || (int)$vendor_id <= 0){

            $json['message'] = "No Customer Selected";
            echo json_encode($json);
            exit;
        }

        //Get Vendor Name 

        $vendor_obj = $this->db->select('company as vendor_name, vendor_code')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

        //Get Credit

        $credit_arr = $this->db->where('vendor_id', $vendor_id)->get('tbl_receipt')->result_array();

        
        // Get Debt
        $this->db->select('invoice_code, CREATION_DATE, (total_amount + tcs_amount + freight_amount + insurance_amount - discount_amount) as debit');
        $debt_arr = $this->db->where('vendor_id', $vendor_id)->where('status !=', 'VOID')->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();

        $ledger_arr = array();

        foreach($credit_arr as $creditRow){

            $ledger_arr[] = array(
                                "date" => $creditRow['received_date'],
                                "credit" => $creditRow['received_amount'],
                                "invoice_no" => $creditRow['receipt_no'],
                                "bill_type" => "RECEIPT",
                                "debit" => 0
                            );
        }

        
        foreach($debt_arr as $debitRow){

            $ledger_arr[] = array(
                                "date" => $debitRow['CREATION_DATE'],
                                "credit" => 0,
                                "bill_type" => "INVOICE",
                                "invoice_no" => $debitRow['invoice_code'],
                                "debit" => $debitRow['debit']
                            );
        }

        //sort by date
        usort($ledger_arr,function($a,$b){
            return strtotime($a['date']) > strtotime($b['date']);
        });

        include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
		require_once('export_file_excel/Classes/PHPExcel.php');
		$objPHPExcel = new PHPExcel;
		// set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
		// set default font size
		$objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
		// create the writer
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		// currency format, € with < 0 being in red color
		$currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
		// number format, with thousands separator and two decimal points.
		$numberFormat = '#,#0.##;[Red]-#,#0.##';
		// writer already created the first sheet for us, let's get it
		$objSheet = $objPHPExcel->getActiveSheet();
        
        // rename the sheet
        $vendor_name = $vendor_obj->vendor_name;
        if(strlen($vendor_name)>25){
            $vendor_name = substr($vendor_name,0, 25);
        }
		$objSheet->setTitle($vendor_name);
		
		// let's bold and size the header font and write the header
		// as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);
        //$objSheet->getStyle('A1:B1')->getFont()->setBold(true)->setSize(12);
        
        // set Header
        // write header
		//$objSheet->getCell('A1')->setValue('Customer Name');
        
        //Header Values
        //$objSheet->getCell('B1')->setValue($vendor_obj->vendor_name);
        //$objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A1')->setValue('Date');
        $objSheet->getCell('B1')->setValue('BILL TYPE');
		$objSheet->getCell('C1')->setValue('Reference No');
		$objSheet->getCell('D1')->setValue('Credit Amount');
		$objSheet->getCell('E1')->setValue('Debit Amount');
        $objSheet->getCell('F1')->setValue('Balance');
        
        $balance = 0;
        $total_debit = 0;
        $total_credit = 0;

        $rowCount = 2;

        foreach($ledger_arr as $rowValue){

            if($rowValue['credit']>0){
                $credit = $rowValue['credit'];
                $total_credit = $total_credit + $credit;
            }else{
                $credit = '';
            }

            if($rowValue['debit']>0){
                $debit = $rowValue['debit'];
                $total_debit = $total_debit + $debit;
            }else{
                $debit = '';
            }

            $balance = $balance + $rowValue['credit'] - $rowValue['debit'];

            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, date('d-m-Y',strtotime($rowValue['date'])));
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['bill_type']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['invoice_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $credit);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $debit);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $balance);
            
            $rowCount++;

        }

        $objSheet->getStyle('D'.$rowCount.':F'.$rowCount)->getFont()->setBold(true)->setSize(10);

        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $total_credit);
        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $total_debit);
        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $balance);

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = $vendor_obj->vendor_name.'_'.$vendor_obj->vendor_code;
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename="'.$file_name.'.xlsx"');
		$objWriter->save('php://output');
		die;
    }


    public function getSupplierLedgerExcel(){
        $vendor_id = $this->input->get('supplier_id');

        if(empty($vendor_id) || (int)$vendor_id <= 0){

            $json['data'] = array();
            echo json_encode($json);
            exit;
        }

        //Get Vendor Name 

        $vendor_obj = $this->db->select('company as vendor_name, vendor_code')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();

        //Get Credit

        $credit_arr = $this->db->where('supplier_id', $vendor_id)->get('tbl_security_admin')->result_array();

        // Get Payment
        $debt_arr = $this->db->where('vendor_id', $vendor_id)->get('tbl_supplier_payment')->result_array();

        $ledger_arr = array();

        foreach($credit_arr as $creditRow){

            $ledger_arr[] = array(
                                "date" => $creditRow['invoice_date'],
                                "credit" => $creditRow['invoice_value'],
                                "invoice_no" => $creditRow['invoice_no'],
                                "bill_type" => "INVOCIE",
                                "debit" => 0
                            );
        }

        
        foreach($debt_arr as $debitRow){

            $ledger_arr[] = array(
                                "date" => $debitRow['created_date'],
                                "credit" => 0,
                                "invoice_no" => $debitRow['supplier_payment_id'],
                                "bill_type" => "PAYMENT",
                                "debit" => $debitRow['amount']
                            );
        }

        //sort by date
        usort($ledger_arr,function($a,$b){
            return strtotime($a['date']) > strtotime($b['date']);
        });

        include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
		require_once('export_file_excel/Classes/PHPExcel.php');
		$objPHPExcel = new PHPExcel;
		// set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
		// set default font size
		$objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
		// create the writer
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		// currency format, € with < 0 being in red color
		$currencyFormat = '#,#0.## \€;[Red]-#,#0.## \€';
		// number format, with thousands separator and two decimal points.
		$numberFormat = '#,#0.##;[Red]-#,#0.##';
		// writer already created the first sheet for us, let's get it
		$objSheet = $objPHPExcel->getActiveSheet();
        
        // rename the sheet
        $vendor_name = $vendor_obj->vendor_name;
        if(strlen($vendor_name)>25){
            $vendor_name = substr($vendor_name,0, 25);
        }
		$objSheet->setTitle($vendor_name);
		
		// let's bold and size the header font and write the header
		// as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);
        //$objSheet->getStyle('A1:B1')->getFont()->setBold(true)->setSize(12);
        
        // set Header
        // write header
		$objSheet->getCell('A1')->setValue('Supplier Name');
        
        //Header Values
        //$objSheet->getCell('B1')->setValue($vendor_obj->vendor_name);
        //$objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A1')->setValue('Date');
		$objSheet->getCell('B1')->setValue('Bill Type');
		$objSheet->getCell('C1')->setValue('Reference No');
		$objSheet->getCell('D1')->setValue('Purchase Amount');
		$objSheet->getCell('E1')->setValue('Payment Amount');
        $objSheet->getCell('F1')->setValue('Balance Amount');
        
        $balance = 0;
        $total_debit = 0;
        $total_credit = 0;

        $rowCount = 2;

        foreach($ledger_arr as $rowValue){

            if($rowValue['credit']>0){
                $credit = $rowValue['credit'];
                $total_credit = $total_credit + $credit;
            }else{
                $credit = '';
            }

            if($rowValue['debit']>0){
                $debit = $rowValue['debit'];
                $total_debit = $total_debit + $debit;
            }else{
                $debit = '';
            }

            $balance = $balance + $rowValue['credit'] - $rowValue['debit'];

            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, date('d-m-Y',strtotime($rowValue['date'])));
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['bill_type']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['invoice_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $credit);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $debit);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $balance);
            
            $rowCount++;

        }

        $objSheet->getStyle('D'.$rowCount.':F'.$rowCount)->getFont()->setBold(true)->setSize(10);

        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $total_credit);
        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $total_debit);
        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $balance);

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = $vendor_obj->vendor_name.'_'.$vendor_obj->vendor_code;
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename="'.$file_name.'.xlsx"');
		$objWriter->save('php://output');
		die;
    }

    public function getOpeningBalanceList(){

        $this->db->select('tbl_vendor.company as vendor_name, tbl_vendor.vendor_id, tbl_opening_balance.opening_balance_id,tbl_opening_balance.balance_amount, tbl_opening_balance.balance_date');
        $this->db->where('DATE(balance_date) >=', '2020-04-01' );
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_opening_balance.vendor_id', 'Left');
        $result = $this->db->get('tbl_opening_balance')->result_array();

        $records = array();
        foreach($result as $rowValue){
            $records[] = array(
                            "opening_balance_id" => $rowValue["opening_balance_id"],
                            "vendor_name" => $rowValue["vendor_name"],
                            "vendor_id" => $rowValue["vendor_id"],
                            "balance_amount" => $rowValue['balance_amount'],
                            "balance_date" => date("d-m-Y", strtotime($rowValue['balance_date'])),
                        );
        }

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function newOB(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data) || (int) $data['vendor_id']<=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $where = array(
                    "vendor_id" => $data['vendor_id'],
                    "balance_date" => $data['balance_date']
                );

        $count = $this->db->where($where)->get('tbl_opening_balance')->num_rows();

        if($count > 0){
            $json['status'] = 0;
            $json['message'] = "Opening Balance Already Exists";
            echo json_encode($json);
            exit;
        }

        $record = array(
                    "vendor_id" => $data['vendor_id'],
                    "balance_amount" => $data['balance_amount'],
                    "balance_date" => $data['balance_date'],
                    "created_by" => $this->session->userdata('user_id'),
                    "creation_date" => date("Y-m-d H:i:s")
                );

        $result = $this->db->insert('tbl_opening_balance', $record);
        $error = $this->db->error();
        
        if($error['code'] !=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getOBHeader(){
        $opening_balance_id = $this->input->get('opening_balance_id');

        if(empty($opening_balance_id) || (int) $opening_balance_id <=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->select('tbl_vendor.company as vendor_name, tbl_vendor.vendor_id, tbl_opening_balance.opening_balance_id,tbl_opening_balance.balance_amount, tbl_opening_balance.balance_date');
        $this->db->where('opening_balance_id', $opening_balance_id );
        $this->db->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_opening_balance.vendor_id', 'Left');
        $result = $this->db->get('tbl_opening_balance')->row();

        $records[] = array(
                        "opening_balance_id" => $result->opening_balance_id,
                        "vendor_name" => $result->vendor_name,
                        "vendor_id" => $result->vendor_id,
                        "balance_amount" => $result->balance_amount,
                        "balance_date" => $result->balance_date,
                    );
    

        $json['status'] = 1;
        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function updateOB(){

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if(empty($data) || (int) $data['opening_balance_id']<=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $record = array(
                    "opening_balance_id" => $data['opening_balance_id'],
                    "balance_amount" => $data['balance_amount'],
                    "last_updated_by" => $this->session->userdata('user_id'),
                    "last_update_date" => date("Y-m-d H:i:s")
                );

        $this->db->where('opening_balance_id', $data['opening_balance_id']);
        $result = $this->db->update('tbl_opening_balance', $record);
        $error = $this->db->error();
        
        if($error['code'] !=0){
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateOBForm($opening_balance_id = 0){
        
        if($opening_balance_id >0){
            $data['active'] = 5;
            $data['opening_balance_id'] = $opening_balance_id;
            $data['title'] = 'UPDATE OPENING BALANCE';
        
        }else{
            $data['active'] = 1;
            $data['title'] = 'Ledger Reports';
        }

        $data['subview'] = $this->load->view('admin/ledger/manage_ledger', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load

    }

    public function getParentCustomerLedgerExcel(){
        $vendor_id = $this->input->get('customer_id');

        if(empty($vendor_id) || (int)$vendor_id <= 0){

            $json['message'] = "No Customer Selected";
            echo json_encode($json);
            exit;
        }

        //Get Vendor Name 

        $vendor_obj = $this->db->select('company as vendor_name, vendor_code, business_role, alias')->where('vendor_id', $vendor_id)->get('tbl_vendor')->row();
        
        if($vendor_obj->business_role == "PARENT"){
            $vendor_ids = $this->db->select('vendor_id')->where('alias', $vendor_obj->alias)->get('tbl_vendor')->result_array();
            
        } else {
            $vendor_ids = array($vendor_id);
        }
        //Get Credit

        $credit_arr = $this->db->where_in('vendor_id', $vendor_ids)->get('tbl_receipt')->result_array();

        
        // Get Debt
        $this->db->select('invoice_code, CREATION_DATE, (total_amount + tcs_amount + freight_amount + insurance_amount - discount_amount) as debit');
        $debt_arr = $this->db->where_in('vendor_id', $vendor_ids)->where('status !=', 'VOID')->get('INVOICE_EXPORT_REPORT_VIEW')->result_array();

        $ledger_arr = array();

        foreach($credit_arr as $creditRow){

            $ledger_arr[] = array(
                                "date" => $creditRow['received_date'],
                                "credit" => $creditRow['received_amount'],
                                "invoice_no" => $creditRow['receipt_no'],
                                "bill_type" => "RECEIPT",
                                "debit" => 0
                            );
        }

        
        foreach($debt_arr as $debitRow){

            $ledger_arr[] = array(
                                "date" => $debitRow['CREATION_DATE'],
                                "credit" => 0,
                                "bill_type" => "INVOICE",
                                "invoice_no" => $debitRow['invoice_code'],
                                "debit" => $debitRow['debit']
                            );
        }

        //sort by date
        usort($ledger_arr,function($a,$b){
            return strtotime($a['date']) > strtotime($b['date']);
        });

        include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
		require_once('export_file_excel/Classes/PHPExcel.php');
		$objPHPExcel = new PHPExcel;
		// set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Calibri');
		// set default font size
		$objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
		// create the writer
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		// currency format,  with < 0 being in red color
		$currencyFormat = '#,#0.## \;[Red]-#,#0.## \';
		// number format, with thousands separator and two decimal points.
		$numberFormat = '#,#0.##;[Red]-#,#0.##';
		// writer already created the first sheet for us, let's get it
		$objSheet = $objPHPExcel->getActiveSheet();
        
        // rename the sheet
        $vendor_name = $vendor_obj->vendor_name;
        if(strlen($vendor_name)>25){
            $vendor_name = substr($vendor_name,0, 25);
        }
		$objSheet->setTitle($vendor_name);
		
		// let's bold and size the header font and write the header
		// as you can see, we can specify a range of cells, like here: cells from A1 to A4
        $objSheet->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);
        //$objSheet->getStyle('A1:B1')->getFont()->setBold(true)->setSize(12);
        
        // set Header
        // write header
		//$objSheet->getCell('A1')->setValue('Customer Name');
        
        //Header Values
        //$objSheet->getCell('B1')->setValue($vendor_obj->vendor_name);
        //$objSheet->getCell('B3')->setValue(date('d-m-Y', strtotime($header->CREATION_DATE)));

        // Table Header
        $objSheet->getCell('A1')->setValue('Date');
        $objSheet->getCell('B1')->setValue('BILL TYPE');
		$objSheet->getCell('C1')->setValue('Reference No');
		$objSheet->getCell('D1')->setValue('Credit Amount');
		$objSheet->getCell('E1')->setValue('Debit Amount');
        $objSheet->getCell('F1')->setValue('Balance');
        
        $balance = 0;
        $total_debit = 0;
        $total_credit = 0;

        $rowCount = 2;

        foreach($ledger_arr as $rowValue){

            if($rowValue['credit']>0){
                $credit = $rowValue['credit'];
                $total_credit = $total_credit + $credit;
            }else{
                $credit = '';
            }

            if($rowValue['debit']>0){
                $debit = $rowValue['debit'];
                $total_debit = $total_debit + $debit;
            }else{
                $debit = '';
            }

            $balance = $balance + $rowValue['credit'] - $rowValue['debit'];

            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, date('d-m-Y',strtotime($rowValue['date'])));
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $rowValue['bill_type']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $rowValue['invoice_no']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $credit);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $debit);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $balance);
            
            $rowCount++;

        }

        $objSheet->getStyle('D'.$rowCount.':F'.$rowCount)->getFont()->setBold(true)->setSize(10);

        $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $total_credit);
        $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $total_debit);
        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $balance);

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        ob_end_clean();
        $file_name = $vendor_obj->vendor_name.'_'.$vendor_obj->vendor_code;
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename="'.$file_name.'.xlsx"');
		$objWriter->save('php://output');
		die;
    }
    
}