<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Invoice extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('invoice_model');
        $this->load->library('gst');
        $this->load->library('hostbooks_authenticator');
        $this->load->library('cliq_api');
        $this->load->library('infiQr');
        $this->load->library('einvoice');
        $this->load->model('auditlog_model');

        $this->load->helper('ckeditor');
        $this->data['ckeditor'] = array(
            'id' => 'ck_editor',
            'path' => 'asset/js/ckeditor',
            'config' => array(
                'toolbar' => "Full",
                'width' => "99.8%",
                'height' => "400px"
            )
        );
    }
	
public function updateInvoice(){

$array = array(32309,32310,32311,32312,32313,32314,32315,32316,32317,32318,32319,32320,32321,32322,32323,32324,32325,32326,32327,32328,32329,32330,32331,32332,32333,32334,32335,32336,32337,32338,32339,32340,32341,32342,32343,32344,32345,32346,32347,32348,32349,32350,32351,32352,32353,32354,32355,32356,32357,32358,32359,32360,32361,32362,32363,32364,32365,32366,32367,32368,32369,32370,32371,32372);
$series = "SLT2425";
$next_no = 1;
foreach($array  as $key => $id){
	
	  $new_no = $series."-".$next_no;
	
          $this->db->where('invoice_id',$id)->update('tbl_invoice', array("invoice_code" => $new_no));
	  $next_no++;

	}
}
    public function manage_invoice($action = NULL, $id = NULL, $item_id = NULL)
    {
        $data['page'] = lang('sales');
        if ($action == 'all_payments') {
            $data['sub_active'] = lang('payments_received');
        } else {
            $data['sub_active'] = lang('invoice');
        }
        if (!empty($item_id)) {
            $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $id));

            if (!empty($can_edit)) {
                $data['item_info'] = $this->invoice_model->check_by(array('items_id' => $item_id), 'tbl_items');
            }
        }
        if (!empty($id)) {
            // get all invoice info by id
            $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $id));

            if (!empty($can_edit)) {
                $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
                if (!empty($data['invoice_info']->client_id)) {
                    $data['invoices_to_merge'] = $this->invoice_model->check_for_merge_invoice($data['invoice_info']->client_id, $id);
                }
            }
        }
        if ($action == 'create_invoice') {
            $data['active'] = 2;
        } else {
            $data['active'] = 1;
        }
        // get all client
        $this->invoice_model->_table_name = 'tbl_client';
        $this->invoice_model->_order_by = 'client_id';
        $data['all_client'] = $this->invoice_model->get();

        // get permission user
        $data['permission_user'] = $this->invoice_model->all_permission_user('13');
        $type = $this->uri->segment(5);
        if (empty($type)) {
            $type = '_' . date('Y');
        }
        $filterBy = null;
        if (!empty($type) && !is_numeric($type)) {
            $ex = explode('_', $type);
            if ($ex[0] != 'c') {
                $filterBy = $type;
            }
        }
        // get all invoice
        $data['all_invoices_info'] = $this->invoice_model->get_invoices($filterBy);

        if ($action == 'invoice_details') {
            $data['title'] = "Invoice Details"; //Page title
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
            if (!empty($data['invoice_info'])) {
                $data['client_info'] = $this->invoice_model->check_by(array('client_id' => $data['invoice_info']->client_id), 'tbl_client');

                $lang = $this->invoice_model->all_files();
                foreach ($lang as $file => $altpath) {
                    $shortfile = str_replace("_lang.php", "", $file);
                    //CI will record your lang file is loaded, unset it and then you will able to load another
                    //unset the lang file to allow the loading of another file
                    if (isset($this->lang->is_loaded)) {
                        $loaded = sizeof($this->lang->is_loaded);
                        if ($loaded < 3) {
                            for ($i = 3; $i <= $loaded; $i++) {
                                unset($this->lang->is_loaded[$i]);
                            }
                        } else {
                            for ($i = 0; $i <= $loaded; $i++) {
                                unset($this->lang->is_loaded[$i]);
                            }
                        }
                    }
                    if (!empty($data['client_info']->language)) {
                        $language = $data['client_info']->language;
                    } else {
                        $language = 'english';
                    }
                    $data['language_info'] = $this->lang->load($shortfile, $language, TRUE, TRUE, $altpath);
                }
                $subview = 'invoice_details';
                // get payment info by id
                $this->invoice_model->_table_name = 'tbl_payments';
                $this->invoice_model->_order_by = 'payments_id';
                $data['all_payments_history'] = $this->invoice_model->get_by(array('invoices_id' => $id), FALSE);
            } else {
                set_message('error', 'No data Found');
                redirect('admin/invoice/manage_invoice');
            }
        } elseif ($action == 'payment' || $action == 'payment_history') {
            $data['title'] = lang($action); //Page title
            // get payment info by id
            $this->invoice_model->_table_name = 'tbl_payments';
            $this->invoice_model->_order_by = 'payments_id';
            $data['all_payments_history'] = $this->invoice_model->get_by(array('invoices_id' => $id), FALSE);

            $subview = $action;
        } elseif ($action == 'payments_details') {
            $data['title'] = "Payments Details"; //Page title
            $subview = 'payments_details';
            // get payment info by id
            $this->invoice_model->_table_name = 'tbl_payments';
            $this->invoice_model->_order_by = 'payments_id';
            $data['payments_info'] = $this->invoice_model->get_by(array('payments_id' => $id), TRUE);
        } elseif ($action == 'invoice_history') {
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
            $data['title'] = "Invoice History"; //Page title
            $subview = 'invoice_history';
        } elseif ($action == 'email_invoice') {
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
            $data['title'] = "Email Invoice"; //Page title
            $subview = 'email_invoice';
            $data['editor'] = $this->data;
        } elseif ($action == 'send_reminder') {
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
            $data['title'] = "Send Remainder"; //Page title
            $subview = 'send_reminder';
            $data['editor'] = $this->data;
        } elseif ($action == 'send_overdue') {
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
            $data['title'] = lang('send_invoice_overdue'); //Page title
            $subview = 'send_overdue';
            $data['editor'] = $this->data;
        } elseif ($action == 'make_payment') {
            $data['all_invoices'] = $this->invoice_model->get_permission('tbl_invoices');
            $data['title'] = lang('make_payment'); //Page title
            $subview = 'make_payment';
        } else {
            $data['title'] = "Manage Invoice"; //Page title
            $subview = 'manage_invoice';
        }
        $data['subview'] = $this->load->view('admin/invoice/' . $subview, $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public
    function make_payment()
    {
        $edited = can_action('13', 'edited');
        if (!empty($edited)) {
            $data['all_invoices'] = $this->invoice_model->get_client_wise_invoice();
            $data['modal_subview'] = $this->load->view('admin/invoice/make_payment', $data, FALSE);
            $this->load->view('admin/_layout_modal', $data);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function client_change_data($customer_id, $current_invoice = 'undefined')
    {
        if ($this->input->is_ajax_request()) {
            $data = array();
            $data['client_currency'] = $this->invoice_model->client_currency_sambol($customer_id);
            $_data['invoices_to_merge'] = $this->invoice_model->check_for_merge_invoice($customer_id, $current_invoice);
            $data['merge_info'] = $this->load->view('admin/invoice/merge_invoice', $_data, true);
            echo json_encode($data);
        }
    }

    public function get_merge_data($id)
    {
        $invoice_items = $this->invoice_model->ordered_items_by_id($id);
        $i = 0;
        foreach ($invoice_items as $item) {
            $invoice_items[$i]->taxname = $this->invoice_model->get_invoice_item_taxes($item->items_id);
            //            $invoice_items[$i]->new_itmes_id = $item->saved_items_id;
            $invoice_items[$i]->qty = $item->quantity;
            $invoice_items[$i]->rate = $item->unit_cost;
            $i++;
        }
        echo json_encode($invoice_items);
    }

    public function payments_pdf($id)
    {
        $data['title'] = "Payments PDF"; //Page title
        // get payment info by id
        $this->invoice_model->_table_name = 'tbl_payments';
        $this->invoice_model->_order_by = 'payments_id';
        $data['payments_info'] = $this->invoice_model->get_by(array('payments_id' => $id), TRUE);
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/invoice/payments_pdf', $data, TRUE);
        pdf_create($viewfile, 'Payment  # ' . $data['payments_info']->trans_id);
    }

    public function pdf_invoice($id)
    {
        $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
        $data['title'] = "Invoice PDF"; //Page title
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/invoice/invoice_pdf', $data, TRUE);
        pdf_create($viewfile, 'Invoice# ' . $data['invoice_info']->reference_no);
    }

    public function project_invoice($id)
    {
        $data['title'] = lang('project') . ' ' . lang('invoice'); //Page title
        $data['active'] = 2;

        $data['project_id'] = $id;

        $data['project_info'] = $this->invoice_model->check_by(array('project_id' => $id), 'tbl_project');

        // get all client
        $this->invoice_model->_table_name = 'tbl_client';
        $this->invoice_model->_order_by = 'client_id';
        $data['all_client'] = $this->invoice_model->get();

        // get permission user
        $data['permission_user'] = $this->invoice_model->all_permission_user('13');

        // get all invoice
        $data['all_invoices_info'] = $this->invoice_model->get_permission('tbl_invoices');

        $data['subview'] = $this->load->view('admin/invoice/manage_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function all_payments($id = NULL)
    {
        if (!empty($id)) {
            $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $id));
            if (!empty($can_edit)) {
                $payments_info = $this->invoice_model->check_by(array('payments_id' => $id), 'tbl_payments');
                $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $payments_info->invoices_id), 'tbl_invoices');
            }
            $data['title'] = "Edit Payments"; //Page title
            $subview = 'edit_payments';
        } else {
            $data['title'] = "All Payments"; //Page title
            $subview = 'all_payments';
        }
        $data['all_invoice_info'] = $this->invoice_model->get_permission('tbl_invoices');

        // get payment info by id

        if (!empty($id)) {
            $can_edit = $this->invoice_model->can_action('tbl_payments', 'edit', array('payments_id' => $id));
            if (!empty($can_edit)) {
                $this->invoice_model->_table_name = 'tbl_payments';
                $this->invoice_model->_order_by = 'payments_id';
                $data['payments_info'] = $this->invoice_model->get_by(array('payments_id' => $id), TRUE);
            } else {
                set_message('error', lang('no_permission_to_access'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        $data['subview'] = $this->load->view('admin/invoice/' . $subview, $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function save_invoice($id = NULL)
    {

        $data = $this->invoice_model->array_from_post(array('reference_no', 'client_id', 'project_id', 'discount_type', 'discount_percent', 'user_id', 'adjustment', 'discount_total', 'show_quantity_as'));

        $data['allow_paypal'] = ($this->input->post('allow_paypal') == 'Yes') ? 'Yes' : 'No';
        $data['allow_stripe'] = ($this->input->post('allow_stripe') == 'Yes') ? 'Yes' : 'No';
        $data['allow_2checkout'] = ($this->input->post('allow_2checkout') == 'Yes') ? 'Yes' : 'No';
        $data['allow_authorize'] = ($this->input->post('allow_authorize') == 'Yes') ? 'Yes' : 'No';
        $data['allow_ccavenue'] = ($this->input->post('allow_ccavenue') == 'Yes') ? 'Yes' : 'No';
        $data['allow_braintree'] = ($this->input->post('allow_braintree') == 'Yes') ? 'Yes' : 'No';
        $data['allow_mollie'] = ($this->input->post('allow_mollie') == 'Yes') ? 'Yes' : 'No';
        $data['allow_payumoney'] = ($this->input->post('allow_payumoney') == 'Yes') ? 'Yes' : 'No';
        $data['client_visible'] = ($this->input->post('client_visible') == 'Yes') ? 'Yes' : 'No';
        $data['invoice_date'] = date('Y-m-d', strtotime($this->input->post('invoice_date', TRUE)));
        if (empty($data['invoice_date'])) {
            $data['invoice_date'] = date('Y-m-d');
        }
        $data['invoice_year'] = date('Y', strtotime($this->input->post('invoice_date', TRUE)));
        $data['invoice_month'] = date('Y-m', strtotime($this->input->post('invoice_date', TRUE)));
        $data['due_date'] = date('Y-m-d', strtotime($this->input->post('due_date', TRUE)));
        $data['notes'] = $this->input->post('notes', TRUE);
        $tax['tax_name'] = $this->input->post('total_tax_name', TRUE);
        $tax['total_tax'] = $this->input->post('total_tax', TRUE);
        $data['total_tax'] = json_encode($tax);
        $i_tax = 0;
        if (!empty($tax['total_tax'])) {
            foreach ($tax['total_tax'] as $v_tax) {
                $i_tax += $v_tax;
            }
        }
        $data['tax'] = $i_tax;
        $save_as_draft = $this->input->post('save_as_draft', TRUE);
        if (!empty($save_as_draft)) {
            $data['status'] = 'draft';
        }

        $currency = $this->invoice_model->client_currency_sambol($data['client_id']);
        if (!empty($currency->code)) {
            $curren = $currency->code;
        } else {
            $curren = config_item('default_currency');
        }
        $data['currency'] = $curren;

        $permission = $this->input->post('permission', true);
        if (!empty($permission)) {
            if ($permission == 'everyone') {
                $assigned = 'all';
            } else {
                $assigned_to = $this->invoice_model->array_from_post(array('assigned_to'));
                if (!empty($assigned_to['assigned_to'])) {
                    foreach ($assigned_to['assigned_to'] as $assign_user) {
                        $assigned[$assign_user] = $this->input->post('action_' . $assign_user, true);
                    }
                }
            }
            if (!empty($assigned)) {
                if ($assigned != 'all') {
                    $assigned = json_encode($assigned);
                }
            } else {
                $assigned = 'all';
            }
            $data['permission'] = $assigned;
        } else {
            set_message('error', lang('assigned_to') . ' Field is required');
            redirect($_SERVER['HTTP_REFERER']);
        }
        // get all client
        $this->invoice_model->_table_name = 'tbl_invoices';
        $this->invoice_model->_primary_key = 'invoices_id';
        if (!empty($id)) {
            $invoice_id = $id;
            $this->invoice_model->save($data, $id);
            $action = ('activity_invoice_updated');
            $description = 'not_invoice_updated';
            $msg = lang('invoice_updated');
        } else {
            $invoice_id = $this->invoice_model->save($data);
            $action = ('activity_invoice_created');
            $description = 'not_invoice_created';
            $msg = lang('invoice_created');
        }
        save_custom_field(9, $invoice_id);

        $recuring_frequency = $this->input->post('recuring_frequency', TRUE);

        if (!empty($recuring_frequency) && $recuring_frequency != 'none') {
            $recur_data = $this->invoice_model->array_from_post(array('recur_start_date', 'recur_end_date'));
            $recur_data['recuring_frequency'] = $recuring_frequency;
            $this->get_recuring_frequency($invoice_id, $recur_data); // set recurring
        }

        $qty_calculation = config_item('qty_calculation_from_items');
        // save items
        $invoices_to_merge = $this->input->post('invoices_to_merge', TRUE);
        $cancel_merged_invoices = $this->input->post('cancel_merged_invoices', TRUE);
        if (!empty($invoices_to_merge)) {
            foreach ($invoices_to_merge as $inv_id) {
                if (empty($cancel_merged_invoices)) {
                    if (!empty($qty_calculation) && $qty_calculation == 'Yes') {
                        $all_items_info = $this->db->where('invoices_id', $inv_id)->get('tbl_items')->result();
                        if (!empty($all_items_info)) {
                            foreach ($all_items_info as $v_items) {
                                $this->return_items($v_items->items_id);
                            }
                        }
                    }
                    $this->db->where('invoices_id', $inv_id);
                    $this->db->delete('tbl_invoices');

                    $this->db->where('invoices_id', $inv_id);
                    $this->db->delete('tbl_items');
                } else {
                    $mdata = array('status' => 'Cancelled');
                    $this->invoice_model->_table_name = 'tbl_invoices';
                    $this->invoice_model->_primary_key = 'invoices_id';
                    $this->invoice_model->save($mdata, $inv_id);
                }
            }
        }

        $removed_items = $this->input->post('removed_items', TRUE);
        if (!empty($removed_items)) {
            foreach ($removed_items as $r_id) {
                if ($r_id != 'undefined') {
                    if (!empty($qty_calculation) && $qty_calculation == 'Yes') {
                        $this->return_items($r_id);
                    }

                    $this->db->where('items_id', $r_id);
                    $this->db->delete('tbl_items');
                }
            }
        }

        $itemsid = $this->input->post('items_id', TRUE);
        $items_data = $this->input->post('items', true);

        if (!empty($items_data)) {
            $index = 0;
            foreach ($items_data as $items) {
                $items['invoices_id'] = $invoice_id;
                $tax = 0;
                if (!empty($items['taxname'])) {
                    foreach ($items['taxname'] as $tax_name) {
                        $tax_rate = explode("|", $tax_name);
                        $tax += $tax_rate[1];
                    }
                    $items['item_tax_name'] = $items['taxname'];
                    unset($items['taxname']);
                    $items['item_tax_name'] = json_encode($items['item_tax_name']);
                }
                if (empty($items['saved_items_id'])) {
                    $items['saved_items_id'] = 0;
                }
                if (!empty($qty_calculation) && $qty_calculation == 'Yes') {
                    if (!empty($items['saved_items_id']) && $items['saved_items_id'] != 'undefined') {
                        $this->invoice_model->reduce_items($items['saved_items_id'], $items['quantity']);
                    }
                }
                $price = $items['quantity'] * $items['unit_cost'];
                $items['item_tax_total'] = ($price / 100 * $tax);
                $items['total_cost'] = $price;
                // get all client
                $this->invoice_model->_table_name = 'tbl_items';
                $this->invoice_model->_primary_key = 'items_id';
                if (!empty($items['items_id'])) {
                    $items_id = $items['items_id'];
                    $this->invoice_model->save($items, $items_id);

                    if (!empty($qty_calculation) && $qty_calculation == 'Yes') {
                        $this->check_existing_qty($items_id, $items['quantity']);
                    }
                } else {
                    $items_id = $this->invoice_model->save($items);
                }
                $index++;
            }
        }
        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $invoice_id,
            'activity' => $action,
            'icon' => 'fa-shopping-cart',
            'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoice_id,
            'value1' => $data['reference_no']
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);


        // send notification to client
        if (!empty($data['client_id'])) {
            $client_info = $this->invoice_model->check_by(array('client_id' => $data['client_id']), 'tbl_client');
            if (!empty($client_info->primary_contact)) {
                $notifyUser = array($client_info->primary_contact);
            } else {
                $user_info = $this->invoice_model->check_by(array('company' => $data['client_id']), 'tbl_account_details');
                if (!empty($user_info)) {
                    $notifyUser = array($user_info->user_id);
                }
            }
        }
        if (!empty($notifyUser)) {
            foreach ($notifyUser as $v_user) {
                if ($v_user != $this->session->userdata('user_id')) {
                    add_notification(array(
                        'to_user_id' => $v_user,
                        'icon' => 'shopping-cart',
                        'description' => $description,
                        'link' => 'client/invoice/manage_invoice/invoice_details/' . $invoice_id,
                        'value' => $data['reference_no'],
                    ));
                }
            }
            show_notification($notifyUser);
        }
        // messages for user
        $type = "success";
        $message = $msg;
        set_message($type, $message);
        redirect('admin/invoice/manage_invoice/invoice_details/' . $invoice_id);
    }

    function return_items($items_id)
    {
        $items_info = $this->db->where('items_id', $items_id)->get('tbl_items')->row();
        if (!empty($items_info->saved_items_id)) {
            $this->invoice_model->return_items($items_info->saved_items_id, $items_info->quantity);
        }
        return true;
    }

    function check_existing_qty($items_id, $qty)
    {
        $items_info = $this->db->where('items_id', $items_id)->get('tbl_items')->row();
        if ($items_info->quantity != $qty) {
            if ($qty > $items_info->quantity) {
                $reduce_qty = $qty - $items_info->quantity;
                if (!empty($items_info->saved_items_id)) {
                    $this->invoice_model->reduce_items($items_info->saved_items_id, $reduce_qty);
                }
            }
            if ($qty < $items_info->quantity) {
                $return_qty = $items_info->quantity - $qty;
                if (!empty($items_info->saved_items_id)) {
                    $this->invoice_model->return_items($items_info->saved_items_id, $return_qty);
                }
            }
        }
        return true;
    }

    public
    function recurring_invoice($id = NULL)
    {
        $data['title'] = lang('recurring_invoice');
        if (!empty($id)) {
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
            $data['active'] = 2;
        } else {
            $data['active'] = 1;
        }
        // get all client
        $this->invoice_model->_table_name = 'tbl_client';
        $this->invoice_model->_order_by = 'client_id';
        $data['all_client'] = $this->invoice_model->get();
        // get permission user
        $data['permission_user'] = $this->invoice_model->all_permission_user('51');

        // get all invoice
        $data['all_invoices_info'] = $this->invoice_model->get_permission('tbl_invoices');

        $data['subview'] = $this->load->view('admin/invoice/recurring_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    function get_recuring_frequency($invoices_id, $recur_data)
    {
        $recur_days = $this->get_calculate_recurring_days($recur_data['recuring_frequency']);
        $due_date = $this->invoice_model->get_table_field('tbl_invoices', array('invoices_id' => $invoices_id), 'due_date');

        $next_date = date("Y-m-d", strtotime($due_date . "+ " . $recur_days . " days"));

        if ($recur_data['recur_end_date'] == '') {
            $recur_end_date = '0000-00-00';
        } else {
            $recur_end_date = date('Y-m-d', strtotime($recur_data['recur_end_date']));
        }
        $update_invoice = array(
            'recurring' => 'Yes',
            'recuring_frequency' => $recur_days,
            'recur_frequency' => $recur_data['recuring_frequency'],
            'recur_start_date' => date('Y-m-d', strtotime($recur_data['recur_start_date'])),
            'recur_end_date' => $recur_end_date,
            'recur_next_date' => $next_date
        );
        $this->invoice_model->_table_name = 'tbl_invoices';
        $this->invoice_model->_primary_key = 'invoices_id';
        $this->invoice_model->save($update_invoice, $invoices_id);
        return TRUE;
    }

    function get_calculate_recurring_days($recuring_frequency)
    {
        switch ($recuring_frequency) {
            case '7D':
                return 7;
                break;
            case '1M':
                return 31;
                break;
            case '3M':
                return 90;
                break;
            case '6M':
                return 182;
                break;
            case '1Y':
                return 365;
                break;
        }
    }

    public
    function stop_recurring($invoices_id)
    {
        $update_recur = array(
            'recurring' => 'No',
            'recur_end_date' => date('Y-m-d'),
            'recur_next_date' => '0000-00-00'
        );
        $this->invoice_model->_table_name = 'tbl_invoices';
        $this->invoice_model->_primary_key = 'invoices_id';
        $this->invoice_model->save($update_recur, $invoices_id);
        // Log Activity
        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $invoices_id,
            'activity' => 'activity_recurring_stopped',
            'icon' => 'fa-shopping-cart',
            'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoices_id,
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);
        // messages for user
        $type = "success";
        $message = lang('recurring_invoice_stopped');
        set_message($type, $message);
        redirect('admin/invoice/manage_invoice');
    }

    public
    function insert_items($invoices_id)
    {
        $edited = can_action('13', 'edited');
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $invoices_id));
        if (!empty($can_edit) && !empty($edited)) {
            $data['invoices_id'] = $invoices_id;
            $data['modal_subview'] = $this->load->view('admin/invoice/_modal_insert_items', $data, FALSE);
            $this->load->view('admin/_layout_modal', $data);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function clone_invoice($invoices_id)
    {
        $edited = can_action('13', 'edited');
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $invoices_id));
        if (!empty($can_edit) && !empty($edited)) {
            $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $invoices_id), 'tbl_invoices');
            // get all client
            $this->invoice_model->_table_name = 'tbl_client';
            $this->invoice_model->_order_by = 'client_id';
            $data['all_client'] = $this->invoice_model->get();

            $data['modal_subview'] = $this->load->view('admin/invoice/_modal_clone_invoice', $data, FALSE);
            $this->load->view('admin/_layout_modal', $data);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function cloned_invoice($id)
    {
        $edited = can_action('13', 'edited');
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $id));
        if (!empty($can_edit) && !empty($edited)) {
            if (config_item('increment_invoice_number') == 'FALSE') {
                $this->load->helper('string');
                $reference_no = config_item('invoice_prefix') . ' ' . random_string('nozero', 6);
            } else {
                $reference_no = config_item('invoice_prefix') . ' ' . $this->invoice_model->generate_invoice_number();
            }
            $invoice_info = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');

            // save into invoice table
            $new_invoice = array(
                'reference_no' => $reference_no,
                'recur_start_date' => $invoice_info->recur_start_date,
                'recur_end_date' => $invoice_info->recur_end_date,
                'client_id' => $this->input->post('client_id', true),
                'project_id' => $invoice_info->project_id,
                'invoice_date' => $this->input->post('invoice_date', true),
                'invoice_year' => date('Y', strtotime($this->input->post('invoice_date', true))),
                'invoice_month' => date('Y-m', strtotime($this->input->post('invoice_date', true))),
                'due_date' => $this->input->post('due_date', true),
                'notes' => $invoice_info->notes,
                'total_tax' => $invoice_info->total_tax,
                'tax' => $invoice_info->tax,
                'discount_type' => $invoice_info->discount_type,
                'discount_percent' => $invoice_info->discount_percent,
                'user_id' => $invoice_info->user_id,
                'adjustment' => $invoice_info->adjustment,
                'discount_total' => $invoice_info->discount_total,
                'show_quantity_as' => $invoice_info->show_quantity_as,
                'recurring' => $invoice_info->recurring,
                'recuring_frequency' => $invoice_info->recuring_frequency,
                'recur_frequency' => $invoice_info->recur_frequency,
                'recur_next_date' => $invoice_info->recur_next_date,
                'currency' => $invoice_info->currency,
                'status' => $invoice_info->status,
                'date_saved' => $invoice_info->date_saved,
                'emailed' => $invoice_info->emailed,
                'show_client' => $invoice_info->show_client,
                'viewed' => $invoice_info->viewed,
                'allow_paypal' => $invoice_info->allow_paypal,
                'allow_stripe' => $invoice_info->allow_stripe,
                'allow_2checkout' => $invoice_info->allow_2checkout,
                'allow_authorize' => $invoice_info->allow_authorize,
                'allow_ccavenue' => $invoice_info->allow_ccavenue,
                'allow_braintree' => $invoice_info->allow_braintree,
                'permission' => $invoice_info->permission,
            );

            $this->invoice_model->_table_name = "tbl_invoices"; //table name
            $this->invoice_model->_primary_key = "invoices_id";
            $new_invoice_id = $this->invoice_model->save($new_invoice);

            $invoice_items = $this->db->where('invoices_id', $id)->get('tbl_items')->result();
            if (!empty($invoice_items)) {
                foreach ($invoice_items as $new_item) {
                    $this->invoice_model->reduce_items($new_item->saved_items_id, $new_item->quantity);
                    $items = array(
                        'invoices_id' => $new_invoice_id,
                        'saved_items_id' => $new_item->saved_items_id,
                        'item_name' => $new_item->item_name,
                        'item_desc' => $new_item->item_desc,
                        'unit_cost' => $new_item->unit_cost,
                        'quantity' => $new_item->quantity,
                        'item_tax_rate' => $new_item->item_tax_rate,
                        'item_tax_name' => $new_item->item_tax_name,
                        'item_tax_total' => $new_item->item_tax_total,
                        'total_cost' => $new_item->total_cost,
                        'unit' => $new_item->unit,
                        'order' => $new_item->order,
                        'date_saved' => $new_item->date_saved,
                    );
                    $this->invoice_model->_table_name = "tbl_items"; //table name
                    $this->invoice_model->_primary_key = "items_id";
                    $this->invoice_model->save($items);
                }
            }
            // save into activities
            $activities = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'invoice',
                'module_field_id' => $new_invoice_id,
                'activity' => ('activity_cloned_invoice'),
                'icon' => 'fa-shopping-cart',
                'link' => 'admin/invoice/manage_invoice/invoice_details/' . $new_invoice_id,
                'value1' => ' from ' . $invoice_info->reference_no . ' to ' . $reference_no,
            );
            // Update into tbl_project
            $this->invoice_model->_table_name = "tbl_activities"; //table name
            $this->invoice_model->_primary_key = "activities_id";
            $this->invoice_model->save($activities);

            // messages for user
            $type = "success";
            $message = lang('invoice_created');
            set_message($type, $message);
            redirect('admin/invoice/manage_invoice/invoice_details/' . $new_invoice_id);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function add_insert_items($invoices_id)
    {

        $edited = can_action('13', 'edited');
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $invoices_id));
        if (!empty($can_edit) && !empty($edited)) {
            $saved_items_id = $this->input->post('saved_items_id', TRUE);
            if (!empty($saved_items_id)) {

                foreach ($saved_items_id as $v_items_id) {
                    $this->invoice_model->reduce_items($v_items_id, 1);
                    $items_info = $this->invoice_model->check_by(array('saved_items_id' => $v_items_id), 'tbl_saved_items');

                    $tax_info = json_decode($items_info->tax_rates_id);
                    $tax_name = array();
                    if (!empty($tax_info)) {
                        foreach ($tax_info as $v_tax) {
                            $all_tax = $this->db->where('tax_rates_id', $v_tax)->get('tbl_tax_rates')->row();
                            $tax_name[] = $all_tax->tax_rate_name . '|' . $all_tax->tax_rate_percent;
                        }
                    }
                    if (!empty($tax_name)) {
                        $tax_name = $tax_name;
                    } else {
                        $tax_name = array();
                    }

                    $data['quantity'] = 1;
                    $data['invoices_id'] = $invoices_id;
                    $data['item_name'] = $items_info->item_name;
                    $data['item_desc'] = $items_info->item_desc;
                    $data['hsn_code'] = $items_info->hsn_code;
                    $data['unit_cost'] = $items_info->unit_cost;
                    $data['item_tax_rate'] = '0.00';
                    $data['item_tax_name'] = json_encode($tax_name);
                    $data['item_tax_total'] = $items_info->item_tax_total;
                    $data['total_cost'] = $items_info->unit_cost;
                    // get all client
                    $this->invoice_model->_table_name = 'tbl_items';
                    $this->invoice_model->_primary_key = 'items_id';
                    $items_id = $this->invoice_model->save($data);

                    $action = ('activity_invoice_items_added');
                    $activity = array(
                        'user' => $this->session->userdata('user_id'),
                        'module' => 'invoice',
                        'module_field_id' => $items_id,
                        'activity' => $action,
                        'icon' => 'fa-circle-o',
                        'value1' => $items_info->item_name
                    );
                    $this->invoice_model->_table_name = 'tbl_activities';
                    $this->invoice_model->_primary_key = 'activities_id';
                    $this->invoice_model->save($activity);
                }

                $this->update_invoice_tax($saved_items_id, $invoices_id);

                $type = "success";
                $msg = lang('invoice_item_added');
            } else {
                $type = "error";
                $msg = 'please Select an items';
            }
            $message = $msg;
            set_message($type, $message);
            redirect('admin/invoice/manage_invoice/invoice_details/' . $invoices_id);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    function update_invoice_tax($saved_items_id, $invoices_id)
    {

        $invoice_info = $this->invoice_model->check_by(array('invoices_id' => $invoices_id), 'tbl_invoices');
        $tax_info = json_decode($invoice_info->total_tax);

        $tax_name = $tax_info->tax_name;
        $total_tax = $tax_info->total_tax;
        $invoice_tax = array();
        if (!empty($tax_name)) {
            foreach ($tax_name as $t_key => $v_tax_info) {
                array_push($invoice_tax, array('tax_name' => $v_tax_info, 'total_tax' => $total_tax[$t_key]));
            }
        }
        $all_tax_info = array();
        if (!empty($saved_items_id)) {
            foreach ($saved_items_id as $v_items_id) {
                $items_info = $this->invoice_model->check_by(array('saved_items_id' => $v_items_id), 'tbl_saved_items');

                $tax_info = json_decode($items_info->tax_rates_id);
                if (!empty($tax_info)) {
                    foreach ($tax_info as $v_tax) {
                        $all_tax = $this->db->where('tax_rates_id', $v_tax)->get('tbl_tax_rates')->row();
                        array_push($all_tax_info, array('tax_name' => $all_tax->tax_rate_name . '|' . $all_tax->tax_rate_percent, 'total_tax' => $items_info->unit_cost / 100 * $all_tax->tax_rate_percent));
                    }
                }
            }
        }
        if (!empty($invoice_tax) && is_array($invoice_tax) && !empty($all_tax_info)) {
            $all_tax_info = array_merge($all_tax_info, $invoice_tax);
        }

        $results = array();
        foreach ($all_tax_info as $value) {
            if (!isset($results[$value['tax_name']])) {
                $results[$value['tax_name']] = 0;
            }
            $results[$value['tax_name']] += $value['total_tax'];
        }
        if (!empty($results)) {

            foreach ($results as $key => $value) {
                $structured_results['tax_name'][] = $key;
                $structured_results['total_tax'][] = $value;
            }
            $invoice_data['tax'] = array_sum($structured_results['total_tax']);
            $invoice_data['total_tax'] = json_encode($structured_results);

            $this->invoice_model->_table_name = 'tbl_invoices';
            $this->invoice_model->_primary_key = 'invoices_id';
            $this->invoice_model->save($invoice_data, $invoices_id);
        }
        return true;
    }

    public
    function add_item($id = NULL)
    {
        $edited = can_action('13', 'edited');
        $data = $this->invoice_model->array_from_post(array('invoices_id', 'item_order'));
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $data['invoices_id']));
        if (!empty($can_edit) && !empty($edited)) {
            $quantity = $this->input->post('quantity', TRUE);
            $array_data = $this->invoice_model->array_from_post(array('item_name', 'item_desc', 'item_tax_rate', 'unit_cost'));
            if (!empty($quantity)) {
                foreach ($quantity as $key => $value) {
                    if (!empty($array_data['item_name'][$key])) {
                        $data['quantity'] = $value;
                        $data['item_name'] = $array_data['item_name'][$key];
                        $data['item_desc'] = $array_data['item_desc'][$key];
                        $data['unit_cost'] = $array_data['unit_cost'][$key];
                        $data['item_tax_rate'] = $array_data['item_tax_rate'][$key];
                        $sub_total = $data['unit_cost'] * $data['quantity'];

                        $data['item_tax_total'] = ($data['item_tax_rate'] / 100) * $sub_total;
                        $data['total_cost'] = $sub_total + $data['item_tax_total'];

                        // get all client
                        $this->invoice_model->_table_name = 'tbl_items';
                        $this->invoice_model->_primary_key = 'items_id';
                        if (!empty($id)) {
                            $items_id = $id;
                            $this->invoice_model->save($data, $id);
                            $action = ('activity_invoice_items_updated');
                            $msg = lang('invoice_item_updated');
                        } else {
                            $items_id = $this->invoice_model->save($data);
                            $action = ('activity_invoice_items_added');
                            $msg = lang('invoice_item_added');
                        }
                        $activity = array(
                            'user' => $this->session->userdata('user_id'),
                            'module' => 'invoice',
                            'module_field_id' => $items_id,
                            'activity' => $action,
                            'icon' => 'fa-circle-o',
                            'value1' => $data['item_name']
                        );
                        $this->invoice_model->_table_name = 'tbl_activities';
                        $this->invoice_model->_primary_key = 'activities_id';
                        $this->invoice_model->save($activity);
                    }
                }
            }
            $type = "success";
            $message = $msg;
            set_message($type, $message);
            redirect('admin/invoice/manage_invoice/invoice_details/' . $data['invoices_id']);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function change_status($action, $id)
    {
        $edited = can_action('13', 'edited');
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $id));
        if (!empty($can_edit) && !empty($edited)) {
            $where = array('invoices_id' => $id);
            if ($action == 'hide') {
                $data = array('show_client' => 'No');
            } else {
                $data = array('show_client' => 'Yes');
            }
            $this->invoice_model->set_action($where, $data, 'tbl_invoices');
            // messages for user
            $type = "success";
            $message = lang('invoice_status_changed', $action);
            set_message($type, $message);
            redirect('admin/invoice/manage_invoice/invoice_details/' . $id);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function delete($action, $invoices_id, $item_id = NULL)
    {
        $deleted = can_action('13', 'deleted');
        $can_delete = $this->invoice_model->can_action('tbl_invoices', 'delete', array('invoices_id' => $invoices_id));
        if (!empty($can_delete) && !empty($deleted)) {
            $invoices_info = $this->invoice_model->check_by(array('invoices_id' => $invoices_id), 'tbl_invoices');

            if ($action == 'delete_item') {
                $this->invoice_model->_table_name = 'tbl_items';
                $this->invoice_model->_primary_key = 'items_id';
                $this->invoice_model->delete($item_id);
            } elseif ($action == 'delete_invoice') {
                $this->invoice_model->_table_name = 'tbl_items';
                $this->invoice_model->delete_multiple(array('invoices_id' => $invoices_id));

                $this->invoice_model->_table_name = 'tbl_payments';
                $this->invoice_model->delete_multiple(array('invoices_id' => $invoices_id));

                $this->invoice_model->_table_name = 'tbl_reminders';
                $this->invoice_model->delete_multiple(array('module' => 'invoice', 'module_id' => $invoices_id));

                $this->invoice_model->_table_name = 'tbl_pinaction';
                $this->invoice_model->delete_multiple(array('module_name' => 'invoice', 'module_id' => $invoices_id));

                $this->invoice_model->_table_name = 'tbl_invoices';
                $this->invoice_model->_primary_key = 'invoices_id';
                $this->invoice_model->delete($invoices_id);
            } elseif ($action == 'delete_payment') {
                $this->invoice_model->_table_name = 'tbl_payments';
                $this->invoice_model->_primary_key = 'payments_id';
                $this->invoice_model->delete($invoices_id);
            }
            $type = "success";
            if (!empty($invoices_info->reference_no)) {
                $val = $invoices_info->reference_no;
            } else {
                $val = NULL;
            }
            $activity = array(
                'user' => $this->session->userdata('user_id'),
                'module' => 'invoice',
                'module_field_id' => $invoices_id,
                'activity' => ('activity_invoice' . $action),
                'icon' => 'fa-shopping-cart',
                'value1' => $val,

            );
            $this->invoice_model->_table_name = 'tbl_activities';
            $this->invoice_model->_primary_key = 'activities_id';
            $this->invoice_model->save($activity);

            if ($action == 'delete_item') {
                $text = lang('invoice_item_deleted');
                //                set_message($type, $text);
                //                redirect('admin/invoice/manage_invoice/invoice_details/' . $invoices_id);
            } elseif ($action == 'delete_payment') {
                $text = lang('payment_deleted');
                //                set_message($type, $text);
                //                redirect('admin/invoice/manage_invoice/all_payments');
            } else {
                $text = lang('deleted_invoice');
                //                set_message($type, $text);
                //                redirect('admin/invoice/manage_invoice');
            }
            echo json_encode(array("status" => $type, 'message' => $text));
        } else {
            echo json_encode(array("status" => 'error', 'message' => lang('there_in_no_value')));
            //            set_message('error', lang('there_in_no_value'));
            //            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function get_payemnt($invoices_id)
    {
        $edited = can_action('13', 'edited');
        $can_edit = $this->invoice_model->can_action('tbl_invoices', 'edit', array('invoices_id' => $invoices_id));
        if (!empty($can_edit) && !empty($edited)) {
            $due = round($this->invoice_model->calculate_to('invoice_due', $invoices_id), 2);

            $paid_amount = $this->input->post('amount', TRUE);

            if ($paid_amount != 0) {
                if ($paid_amount > $due) {
                    // messages for user
                    $type = "error";
                    $message = lang('overpaid_amount');
                    set_message($type, $message);
                    redirect('admin/invoice/manage_invoice/payment/' . $invoices_id);
                } else {
                    $inv_info = $this->invoice_model->check_by(array('invoices_id' => $invoices_id), 'tbl_invoices');
                    $data = array(
                        'invoices_id' => $invoices_id,
                        'paid_by' => $inv_info->client_id,
                        'payment_method' => $this->input->post('payment_methods_id', TRUE),
                        'currency' => $this->input->post('currency', TRUE),
                        'amount' => $paid_amount,
                        'payment_date' => date('Y-m-d', strtotime($this->input->post('payment_date', TRUE))),
                        'trans_id' => $this->input->post('trans_id'),
                        'notes' => $this->input->post('notes'),
                        'month_paid' => date("m", strtotime($this->input->post('payment_date', TRUE))),
                        'year_paid' => date("Y", strtotime($this->input->post('payment_date', TRUE))),
                    );

                    $this->invoice_model->_table_name = 'tbl_payments';
                    $this->invoice_model->_primary_key = 'payments_id';
                    $payments_id = $this->invoice_model->save($data);

                    if ($paid_amount < $due) {
                        $status = 'partially_paid';
                    }
                    if ($paid_amount == $due) {
                        $status = 'Paid';
                    }

                    $invoice_data['status'] = $status;
                    update('tbl_invoices', array('invoices_id' => $invoices_id), $invoice_data);

                    $currency = $this->invoice_model->client_currency_sambol($inv_info->client_id);
                    $activity = array(
                        'user' => $this->session->userdata('user_id'),
                        'module' => 'invoice',
                        'module_field_id' => $invoices_id,
                        'activity' => ('activity_new_payment'),
                        'icon' => 'fa-shopping-cart',
                        'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoices_id,
                        'value1' => display_money($paid_amount, $currency->symbol),
                        'value2' => $inv_info->reference_no,
                    );
                    $this->invoice_model->_table_name = 'tbl_activities';
                    $this->invoice_model->_primary_key = 'activities_id';
                    $this->invoice_model->save($activity);

                    if (!empty($inv_info->user_id)) {
                        $notifiedUsers = array($inv_info->user_id);
                        foreach ($notifiedUsers as $users) {
                            if ($users != $this->session->userdata('user_id')) {
                                add_notification(array(
                                    'to_user_id' => $users,
                                    'description' => 'not_new_invoice_payment',
                                    'icon' => 'shopping-cart',
                                    'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoices_id,
                                    'value' => lang('invoice') . ' ' . $inv_info->reference_no . ' ' . lang('amount') . display_money($paid_amount, $currency->symbol),
                                ));
                            }
                        }
                        show_notification($notifiedUsers);
                    }

                    if ($this->input->post('save_into_account') == 'on') {
                        $account_id = $this->input->post('account_id', true);
                        if (empty($account_id)) {
                            $account_id = config_item('default_account');
                        }
                        if (!empty($account_id)) {
                            $reference = lang('invoice') . ' ' . lang('reference_no') . ": <a href='" . base_url('admin/invoice/manage_invoice/invoice_details/' . $inv_info->invoices_id) . "' >" . $inv_info->reference_no . "</a> and " . lang('trans_id') . ": <a href='" . base_url('admin/invoice/manage_invoice/payments_details/' . $payments_id) . "'>" . $this->input->post('trans_id', true) . "</a>";
                            $trans_id = $this->input->post('trans_id', true);
                            // save into tbl_transaction
                            $tr_data = array(
                                'name' => lang('invoice_payment', lang('trans_id') . '# ' . $trans_id),
                                'type' => 'Income',
                                'amount' => $paid_amount,
                                'credit' => $paid_amount,
                                'date' => date('Y-m-d', strtotime($this->input->post('payment_date', TRUE))),
                                'paid_by' => $inv_info->client_id,
                                'payment_methods_id' => $this->input->post('payment_methods_id', TRUE),
                                'reference' => $trans_id,
                                'notes' => lang('this_deposit_from_invoice_payment', $reference),
                                'permission' => 'all',
                            );


                            $account_info = $this->invoice_model->check_by(array('account_id' => $account_id), 'tbl_accounts');
                            if (!empty($account_info)) {
                                $ac_data['balance'] = $account_info->balance + $tr_data['amount'];
                                $this->invoice_model->_table_name = "tbl_accounts"; //table name
                                $this->invoice_model->_primary_key = "account_id";
                                $this->invoice_model->save($ac_data, $account_info->account_id);

                                $aaccount_info = $this->invoice_model->check_by(array('account_id' => $account_id), 'tbl_accounts');

                                $tr_data['total_balance'] = $aaccount_info->balance;
                                $tr_data['account_id'] = $account_id;

                                // save into tbl_transaction
                                $this->invoice_model->_table_name = "tbl_transactions"; //table name
                                $this->invoice_model->_primary_key = "transactions_id";
                                $return_id = $this->invoice_model->save($tr_data);

                                $deduct_account['account_id'] = $account_id;
                                $this->invoice_model->_table_name = 'tbl_payments';
                                $this->invoice_model->_primary_key = 'payments_id';
                                $this->invoice_model->save($deduct_account, $payments_id);

                                // save into activities
                                $activities = array(
                                    'user' => $this->session->userdata('user_id'),
                                    'module' => 'transactions',
                                    'module_field_id' => $return_id,
                                    'activity' => 'activity_new_deposit',
                                    'icon' => 'fa-building-o',
                                    'link' => 'admin/transactions/deposit',
                                    'value1' => $account_info->account_name,
                                    'value2' => $paid_amount,
                                );
                                // Update into tbl_project
                                $this->invoice_model->_table_name = "tbl_activities"; //table name
                                $this->invoice_model->_primary_key = "activities_id";
                                $this->invoice_model->save($activities);
                            }
                        }
                    }
                    if ($this->input->post('send_thank_you') == 'on') {
                        $this->send_payment_email($invoices_id, $paid_amount); //send thank you email
                    }
                }
            }
            // messages for user
            $type = "success";
            $message = lang('generate_payment');
            set_message($type, $message);
            redirect('admin/invoice/manage_invoice/invoice_details/' . $invoices_id);
        } else {
            set_message('error', lang('there_in_no_value'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public
    function update_payemnt($payments_id)
    {
        $data = array(
            'amount' => $this->input->post('amount', TRUE),
            'payment_method' => $this->input->post('payment_methods_id', TRUE),
            'payment_date' => date('Y-m-d', strtotime($this->input->post('payment_date', TRUE))),
            'notes' => $this->input->post('notes', TRUE),
            'month_paid' => date("m", strtotime($this->input->post('payment_date', TRUE))),
            'year_paid' => date("Y", strtotime($this->input->post('payment_date', TRUE))),
        );

        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $payments_id,
            'activity' => ('activity_update_payment'),
            'icon' => 'fa-shopping-cart',
            'link' => 'admin/invoice/manage_invoice/payments_details/' . $payments_id,
            'value1' => $data['amount'],
            'value2' => $data['payment_date'],
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);


        $payments_info = $this->invoice_model->check_by(array('payments_id' => $payments_id), 'tbl_payments');
        if ($payments_info->amount != $data['amount']) {
            // send notification to client
            if (!empty($payments_info)) {
                $client_info = $this->invoice_model->check_by(array('client_id' => $payments_info->paid_by), 'tbl_client');
                if (!empty($client_info->primary_contact)) {
                    $notifyUser = array($client_info->primary_contact);
                } else {
                    $user_info = $this->invoice_model->check_by(array('company' => $client_info->client_id), 'tbl_account_details');
                    if (!empty($user_info)) {
                        $notifyUser = array($user_info->user_id);
                    }
                }
            }
            if (!empty($notifyUser)) {
                foreach ($notifyUser as $v_user) {
                    if ($v_user != $this->session->userdata('user_id')) {
                        add_notification(array(
                            'to_user_id' => $v_user,
                            'icon' => 'shopping-cart',
                            'description' => 'not_payment_update',
                            'link' => 'client/invoice/manage_invoice/payments_details/' . $payments_id,
                            'value' => lang('trans_id') . ' ' . $payments_info->trans_id . ' ' . lang('new') . ' ' . lang('amount') . ' ' . display_money($data['amount'], $payments_info->currency),
                        ));
                    }
                }
                show_notification($notifyUser);
            }
        }
        $this->invoice_model->_table_name = 'tbl_payments';
        $this->invoice_model->_primary_key = 'payments_id';
        $this->invoice_model->save($data, $payments_id);


        // messages for user
        $type = "success";
        $message = lang('generate_payment');
        set_message($type, $message);
        redirect('admin/invoice/all_payments');
    }

    public
    function send_payment($invoices_id, $paid_amount)
    {
        $this->send_payment_email($invoices_id, $paid_amount); //send email
        $type = "success";
        $message = lang('payment_information_send');
        set_message($type, $message);
        redirect($_SERVER['HTTP_REFERER']);
    }

    function send_payment_email($invoices_id, $paid_amount)
    {
        $email_template = $this->invoice_model->check_by(array('email_group' => 'payment_email'), 'tbl_email_templates');
        $message = $email_template->template_body;
        $subject = $email_template->subject;

        $inv_info = $this->invoice_model->check_by(array('invoices_id' => $invoices_id), 'tbl_invoices');
        $currency = $inv_info->currency;
        $reference = $inv_info->reference_no;

        $invoice_currency = str_replace("{INVOICE_CURRENCY}", $currency, $message);
        $reference = str_replace("{INVOICE_REF}", $reference, $invoice_currency);
        $amount = str_replace("{PAID_AMOUNT}", $paid_amount, $reference);
        $message = str_replace("{SITE_NAME}", config_item('company_name'), $amount);

        $data['message'] = $message;
        $message = $this->load->view('email_template', $data, TRUE);
        $client_info = $this->invoice_model->check_by(array('client_id' => $inv_info->client_id), 'tbl_client');

        // send notification to client
        if (!empty($client_info)) {
            $client_info = $this->invoice_model->check_by(array('client_id' => $client_info->client_id), 'tbl_client');
            if (!empty($client_info->primary_contact)) {
                $notifyUser = array($client_info->primary_contact);
            } else {
                $user_info = $this->invoice_model->check_by(array('company' => $client_info->client_id), 'tbl_account_details');
                if (!empty($user_info)) {
                    $notifyUser = array($user_info->user_id);
                }
            }
        }
        if (!empty($notifyUser)) {
            foreach ($notifyUser as $v_user) {
                if ($v_user != $this->session->userdata('user_id')) {
                    add_notification(array(
                        'to_user_id' => $v_user,
                        'icon' => 'shopping-cart',
                        'description' => 'not_payment_received',
                        'link' => 'client/invoice/manage_invoice/invoice_details/' . $invoices_id,
                        'value' => lang('invoice') . ' ' . $inv_info->reference_no . ' ' . lang('amount') . display_money($paid_amount, $inv_info->currency),
                    ));
                }
            }
            show_notification($notifyUser);
        }

        $address = $client_info->email;

        $params['recipient'] = $address;

        $params['subject'] = '[ ' . config_item('company_name') . ' ]' . ' ' . $subject;
        $params['message'] = $message;
        $params['resourceed_file'] = '';

        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $invoices_id,
            'activity' => ('activity_send_payment'),
            'icon' => 'fa-shopping-cart',
            'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoices_id,
            'value1' => $reference,
            'value2' => $currency . ' ' . $amount,
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);
        $this->invoice_model->send_email($params);
    }

    public
    function change_invoice_status($action, $id)
    {
        if ($action == 'mark_as_sent') {
            $data = array('emailed' => 'Yes', 'date_sent' => date("Y-m-d H:i:s", time()), 'status' => 'Unpaid');
        }
        if ($action == 'mark_as_cancelled') {
            $data = array('status' => 'Cancelled');
        }
        if ($action == 'unmark_as_cancelled') {
            $data = array('status' => 'Unpaid');
        }
        $this->invoice_model->_table_name = 'tbl_invoices';
        $this->invoice_model->_primary_key = 'invoices_id';
        $this->invoice_model->save($data, $id);

        // messages for user
        $type = "success";
        $imessage = lang('invoice_update');
        set_message($type, $imessage);
        redirect('admin/invoice/manage_invoice/invoice_details/' . $id);
    }

    public
    function send_invoice_email($invoice_id, $row = null)
    {
        if (!empty($row)) {
            $invoice_info = $this->invoice_model->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
            $client_info = $this->invoice_model->check_by(array('client_id' => $invoice_info->client_id), 'tbl_client');
            if (!empty($client_info)) {
                $client = $client_info->name;
                $currency = $this->invoice_model->client_currency_sambol($client_info->client_id);;
            } else {
                $client = '-';
                $currency = $this->invoice_model->check_by(array('code' => config_item('default_currency')), 'tbl_currencies');
            }

            $amount = $this->invoice_model->calculate_to('invoice_due', $invoice_info->invoices_id);
            $currency = $currency->code;
            $email_template = $this->invoice_model->check_by(array('email_group' => 'invoice_message'), 'tbl_email_templates');
            $message = $email_template->template_body;
            $ref = $invoice_info->reference_no;
            $subject = $email_template->subject;
            $due_date = $invoice_info->due_date;
        } else {
            $message = $this->input->post('message', TRUE);
            $ref = $this->input->post('ref', TRUE);
            $subject = $this->input->post('subject', TRUE);
            $client = $this->input->post('client_name', TRUE);
            $amount = $this->input->post('amount', true);
            $currency = $this->input->post('currency', TRUE);
            $due_date = $this->input->post('due_date', TRUE);
        }
        $client_name = str_replace("{CLIENT}", $client, $message);
        $Ref = str_replace("{REF}", $ref, $client_name);
        $Amount = str_replace("{AMOUNT}", $amount, $Ref);
        $Currency = str_replace("{CURRENCY}", $currency, $Amount);
        $Due_date = str_replace("{DUE_DATE}", $due_date, $Currency);

        $link = str_replace("{INVOICE_LINK}", base_url() . 'client/invoice/manage_invoice/invoice_details/' . $invoice_id, $Due_date);
        $message = str_replace("{SITE_NAME}", config_item('company_name'), $link);

        $this->send_email_invoice($invoice_id, $message, $subject); // Email Invoice

        $data = array('status' => 'sent', 'emailed' => 'Yes', 'date_sent' => date("Y-m-d H:i:s", time()));

        $this->invoice_model->_table_name = 'tbl_invoices';
        $this->invoice_model->_primary_key = 'invoices_id';
        $this->invoice_model->save($data, $invoice_id);

        // Log Activity
        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $invoice_id,
            'activity' => ('activity_invoice_sent'),
            'icon' => 'fa-shopping-cart',
            'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoice_id,
            'value1' => $ref,
            'value2' => $this->input->post('currency', TRUE) . ' ' . $this->input->post('amount'),
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);
        // messages for user
        $type = "success";
        $imessage = lang('invoice_sent');
        set_message($type, $imessage);
        redirect('admin/invoice/manage_invoice/invoice_details/' . $invoice_id);
    }

    function send_email_invoice($invoice_id, $message, $subject)
    {
        $invoice_info = $this->invoice_model->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        $client_info = $this->invoice_model->check_by(array('client_id' => $invoice_info->client_id), 'tbl_client');

        $recipient = $client_info->email;

        $data['message'] = $message;

        $message = $this->load->view('email_template', $data, TRUE);
        $params = array(
            'recipient' => $recipient,
            'subject' => $subject,
            'message' => $message
        );
        $params['resourceed_file'] = 'uploads/' . lang('invoice') . '_' . $invoice_info->reference_no . '.pdf';
        $params['resourcement_url'] = base_url() . 'uploads/' . lang('invoice') . '_' . $invoice_info->reference_no . '.pdf';

        $this->attach_pdf($invoice_id);

        $this->invoice_model->send_email($params);
        //Delete invoice in tmp folder
        if (is_file('uploads/' . lang('invoice') . '_' . $invoice_info->reference_no . '.pdf')) {
            unlink('uploads/' . lang('invoice') . '_' . $invoice_info->reference_no . '.pdf');
        }
        // send notification to client
        if (!empty($client_info->primary_contact)) {
            $notifyUser = array($client_info->primary_contact);
        } else {
            $user_info = $this->invoice_model->check_by(array('company' => $invoice_info->client_id), 'tbl_account_details');
            if (!empty($user_info)) {
                $notifyUser = array($user_info->user_id);
            }
        }
        if (!empty($notifyUser)) {
            foreach ($notifyUser as $v_user) {
                if ($v_user != $this->session->userdata('user_id')) {
                    add_notification(array(
                        'to_user_id' => $v_user,
                        'icon' => 'shopping-cart',
                        'description' => 'not_email_send_alert',
                        'link' => 'client/invoice/manage_invoice/invoice_details/' . $invoice_id,
                        'value' => lang('invoice') . ' ' . $invoice_info->reference_no,
                    ));
                }
            }
            show_notification($notifyUser);
        }
    }

    public function attach_pdf($id)
    {
        $data['page'] = lang('invoices');
        $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $id), 'tbl_invoices');
        $data['title'] = lang('invoices'); //Page title
        $this->load->helper('dompdf');
        $html = $this->load->view('admin/invoice/invoice_pdf', $data, TRUE);
        $result = pdf_create($html, lang('invoice') . '_' . $data['invoice_info']->reference_no, 1, null, true);
        return $result;
    }

    function invoice_email($invoice_id)
    {
        $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        $data['title'] = "Invoice PDF"; //Page title
        $message = $this->load->view('admin/invoice/invoice_pdf', $data, TRUE);

        $client_info = $this->invoice_model->check_by(array('client_id' => $data['invoice_info']->client_id), 'tbl_client');

        $recipient = $client_info->email;

        $data['message'] = $message;

        $message = $this->load->view('email_template', $data, TRUE);

        $params = array(
            'recipient' => $recipient,
            'subject' => '[ ' . config_item('company_name') . ' ]' . ' New Invoice' . ' ' . $data['invoice_info']->reference_no,
            'message' => $message
        );
        $params['resourceed_file'] = '';

        $this->invoice_model->send_email($params);

        $data = array('emailed' => 'Yes', 'date_sent' => date("Y-m-d H:i:s", time()));

        $this->invoice_model->_table_name = 'tbl_invoices';
        $this->invoice_model->_primary_key = 'invoices_id';
        $invoice_id = $this->invoice_model->save($data, $invoice_id);

        $data['invoice_info'] = $this->invoice_model->check_by(array('invoices_id' => $invoice_id), 'tbl_invoices');
        // Log Activity
        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $invoice_id,
            'activity' => ('activity_invoice_sent'),
            'icon' => 'fa-shopping-cart',
            'link' => 'admin/invoice/manage_invoice/invoice_details/' . $invoice_id,
            'value1' => $data['invoice_info']->reference_no,
        );

        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);

        // send notification to client
        if (!empty($client_info->primary_contact)) {
            $notifyUser = array($client_info->primary_contact);
        } else {
            $user_info = $this->invoice_model->check_by(array('company' => $data['invoice_info']->client_id), 'tbl_account_details');
            if (!empty($user_info)) {
                $notifyUser = array($user_info->user_id);
            }
        }
        if (!empty($notifyUser)) {
            foreach ($notifyUser as $v_user) {
                if ($v_user != $this->session->userdata('user_id')) {
                    add_notification(array(
                        'to_user_id' => $v_user,
                        'icon' => 'shopping-cart',
                        'description' => 'not_email_send_alert',
                        'link' => 'client/invoice/manage_invoice/invoice_details/' . $invoice_id,
                        'value' => lang('invoice') . ' ' . $data['invoice_info']->reference_no,
                    ));
                }
            }
            show_notification($notifyUser);
        }
        // messages for user
        $type = "success";
        $imessage = lang('invoice_sent');
        set_message($type, $imessage);
        redirect('admin/invoice/manage_invoice/invoice_details/' . $invoice_id);
    }

    public
    function tax_rates($action = NULL, $id = NULL)
    {
        $edited = can_action('16', 'edited');
        $deleted = can_action('16', 'deleted');
        $data['page'] = lang('sales');
        $data['sub_active'] = lang('tax_rates');
        if ($action == 'edit_tax_rates') {
            $data['active'] = 2;
            if (!empty($id)) {
                $can_edit = $this->invoice_model->can_action('tbl_tax_rates', 'edit', array('tax_rates_id' => $id));
                if (!empty($can_edit) && !empty($edited)) {
                    $data['tax_rates_info'] = $this->invoice_model->check_by(array('tax_rates_id' => $id), 'tbl_tax_rates');
                }
            }
        } else {
            $data['active'] = 1;
        }
        if ($action == 'delete_tax_rates') {
            $can_delete = $this->invoice_model->can_action('tbl_tax_rates', 'delete', array('tax_rates_id' => $id));
            if (!empty($can_delete) && !empty($deleted)) {
                $tax_rates_info = $this->invoice_model->check_by(array('tax_rates_id' => $id), 'tbl_tax_rates');
                // Log Activity
                $activity = array(
                    'user' => $this->session->userdata('user_id'),
                    'module' => 'invoice',
                    'module_field_id' => $id,
                    'activity' => ('activity_taxt_rate_deleted'),
                    'icon' => 'fa-shopping-cart',
                    'value1' => $tax_rates_info->tax_rate_name,
                );
                $this->invoice_model->_table_name = 'tbl_activities';
                $this->invoice_model->_primary_key = 'activities_id';
                $this->invoice_model->save($activity);

                $this->invoice_model->_table_name = 'tbl_tax_rates';
                $this->invoice_model->_primary_key = 'tax_rates_id';
                $this->invoice_model->delete($id);
                // messages for user
                $type = "success";
                $message = lang('tax_deleted');
            } else {
                $type = "error";
                $message = lang('there_in_no_value');
            }
            echo json_encode(array("status" => $type, 'message' => $message));
        } else {
            $data['title'] = "Tax Rates Info"; //Page title
            $subview = 'tax_rates';
            // get permission user
            $data['permission_user'] = $this->invoice_model->all_permission_user('16');
            // get all invoice
            $data['all_tax_rates'] = $this->invoice_model->get_permission('tbl_tax_rates');

            $data['subview'] = $this->load->view('admin/invoice/' . $subview, $data, TRUE);
            $this->load->view('admin/_layout_main', $data); //page load
        }
    }

    public
    function save_tax_rate($id = NULL)
    {
        $data = $this->invoice_model->array_from_post(array('tax_rate_name', 'tax_rate_percent'));
        $permission = $this->input->post('permission', true);
        if (!empty($permission)) {
            if ($permission == 'everyone') {
                $assigned = 'all';
            } else {
                $assigned_to = $this->invoice_model->array_from_post(array('assigned_to'));
                if (!empty($assigned_to['assigned_to'])) {
                    foreach ($assigned_to['assigned_to'] as $assign_user) {
                        $assigned[$assign_user] = $this->input->post('action_' . $assign_user, true);
                    }
                }
            }
            if (!empty($assigned)) {
                if ($assigned != 'all') {
                    $assigned = json_encode($assigned);
                }
            } else {
                $assigned = 'all';
            }
            $data['permission'] = $assigned;
        } else {
            set_message('error', lang('assigned_to') . ' Field is required');
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->invoice_model->_table_name = 'tbl_tax_rates';
        $this->invoice_model->_primary_key = 'tax_rates_id';
        $id = $this->invoice_model->save($data, $id);

        // Log Activity
        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => 'invoice',
            'module_field_id' => $id,
            'activity' => ('activity_taxt_rate_add'),
            'icon' => 'fa-shopping-cart',
            'value1' => $data['tax_rate_name'],
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);

        // messages for user
        $type = "success";
        $message = lang('tax_added');
        set_message($type, $message);
        $save = $this->input->post('save', true);
        if ($save == 2) {
            redirect('admin/invoice/tax_rates/edit_tax_rates');
        } else {
            redirect('admin/invoice/tax_rates');
        }
    }

    public function zipped($module, $client_id = null, $id = null)
    {
        $this->load->helper('dompdf');
        if ($module == 'estimate') {
            $this->load->model('estimates_model');
        } elseif ($module == 'proposal') {
            $this->load->model('proposal_model');
        }
        if ($this->input->post()) {
            if ($module == 'invoice') {
                $view = can_action('13', 'view');
                if (!$view) {
                    access_denied('Zip Invoices');
                }

                $status = $this->input->post('invoice_status');
                $ex = explode('_', $status);
                if (!empty($ex)) {
                    if (!empty($ex[1]) && is_numeric($ex[1])) {
                        $ex = 'year';
                    } else {
                        $ex = 'no';
                    }
                }

                $client_id = $this->input->post('client_id');
                if (!empty($client_id)) {
                    $client_info = $this->db->where('client_id', $client_id)->get('tbl_client')->row();
                    $file_name = slug_it($client_info->name);
                } else {
                    $file_name = slug_it($status);
                    $client_id = null;
                }

                if ($this->input->post('from_date') && $this->input->post('to_date') && $status != 'last_month' && $status != 'this_months' && $ex != 'year') {
                    $from_date = $this->input->post('from_date');
                    $to_date = $this->input->post('to_date');
                    if (!empty($client_id)) {
                        $this->db->where('client_id', $client_id);
                    }
                    $this->db->where('invoice_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
                    $all_invoice = $this->db->get('tbl_invoices')->result();
                } else {
                    $from_date = null;
                    $to_date = null;
                    $all_invoice = $this->invoice_model->get_invoices($status, $client_id);
                }

                $this->load->helper('file');
                if (!is_really_writable(TEMP_FOLDER)) {
                    show_error('uploads folder is not writable. You need to change the permissions to 755');
                }
                $dir = TEMP_FOLDER . $file_name;

                if (is_dir($dir)) {
                    delete_dir($dir);
                }
                if (empty($all_invoice)) {
                    set_message('error', lang('no_record_available'));
                    if (!empty($client_id)) {
                        redirect('admin/client/client_details/' . $client_id . '/invoice');
                    } else {
                        redirect('admin/invoice/manage_invoice');
                    }
                }

                mkdir($dir, 0777);
                foreach ($all_invoice as $v_invoice) {
                    $data['invoice_info'] = $v_invoice;
                    $pdf_file = $this->load->view('admin/invoice/invoice_pdf', $data, TRUE);
                    $_temp_file_name = slug_it($data['invoice_info']->reference_no);
                    $file_name = $dir . strtoupper($_temp_file_name);
                    if (!empty($client_info->name)) {
                        $cl_name = slug_it($client_info->name);
                    } else {
                        $cl_name = slug_it($status);
                    }
                    pdf_create($pdf_file, $data['invoice_info']->reference_no, 1, null, true, $cl_name);
                }
            } else if ($module == 'estimate') {
                $view = can_action('14', 'view');
                if (!$view) {
                    access_denied('Zip Estimate');
                }

                $status = $this->input->post('invoice_status');
                $ex = explode('_', $status);
                if (!empty($ex)) {
                    if (!empty($ex[1]) && is_numeric($ex[1])) {
                        $ex = 'year';
                    } else {
                        $ex = 'no';
                    }
                }

                $client_id = $this->input->post('client_id');
                if (!empty($client_id)) {
                    $client_info = $this->db->where('client_id', $client_id)->get('tbl_client')->row();
                    $file_name = slug_it($client_info->name);
                } else {
                    $file_name = lang($status);
                    $client_id = null;
                }
                if ($this->input->post('from_date') && $this->input->post('to_date') && $status != 'last_month' && $status != 'this_months' && $ex != 'year') {
                    $from_date = $this->input->post('from_date');
                    $to_date = $this->input->post('to_date');
                    if (!empty($client_id)) {
                        $this->db->where('client_id', $client_id);
                    }
                    $this->db->where('estimate_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
                    $all_estimate = $this->db->get('tbl_estimates')->result();
                } else {
                    $from_date = null;
                    $to_date = null;
                    $this->load->model('estimates_model');
                    $all_estimate = $this->estimates_model->get_estimates($status, $client_id);
                }

                $this->load->helper('file');
                if (!is_really_writable(TEMP_FOLDER)) {
                    show_error('uploads folder is not writable. You need to change the permissions to 755');
                }
                $dir = TEMP_FOLDER . $file_name;

                if (is_dir($dir)) {
                    delete_dir($dir);
                }
                if (empty($all_estimate)) {
                    set_message('error', lang('no_record_available'));
                    if (!empty($client_id)) {
                        redirect('admin/client/client_details/' . $client_id . '/estimate');
                    } else {
                        redirect('admin/estimates');
                    }
                }
                mkdir($dir, 0777);
                foreach ($all_estimate as $v_estimate) {
                    $data['estimates_info'] = $v_estimate;
                    $pdf_file = $this->load->view('admin/estimates/estimates_pdf', $data, TRUE);
                    $_temp_file_name = slug_it($data['estimates_info']->reference_no);
                    $file_name = $dir . strtoupper($_temp_file_name);
                    if (!empty($client_info->name)) {
                        $cl_name = slug_it($client_info->name);
                    } else {
                        $cl_name = slug_it($status);
                    }
                    pdf_create($pdf_file, $data['estimates_info']->reference_no, 1, null, true, $cl_name);
                }
            } else if ($module == 'proposal') {
                $view = can_action('140', 'view');
                if (!$view) {
                    access_denied('Zip Proposal');
                }

                $status = $this->input->post('invoice_status');
                $ex = explode('_', $status);
                if (!empty($ex)) {
                    if (!empty($ex[1]) && is_numeric($ex[1])) {
                        $ex = 'year';
                    } else {
                        $ex = 'no';
                    }
                }
                $client_id = $this->input->post('client_id');
                if (!empty($client_id)) {
                    $client_info = $this->db->where('client_id', $client_id)->get('tbl_client')->row();
                    $file_name = slug_it($client_info->name);
                } else {
                    $file_name = slug_it($status);
                    $client_id = null;
                }
                if ($this->input->post('from_date') && $this->input->post('to_date') && $status != 'last_month' && $status != 'this_months' && $ex != 'year') {
                    $from_date = $this->input->post('from_date');
                    $to_date = $this->input->post('to_date');
                    if (!empty($client_id)) {
                        $this->db->where('module', 'client');
                        $this->db->where('module_id', $client_id);
                    }
                    $this->db->where('proposal_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
                    $all_proposal = $this->db->get('tbl_proposals')->result();
                } else {
                    $from_date = null;
                    $to_date = null;
                    $this->load->model('proposal_model');
                    $all_proposal = $this->proposal_model->get_proposals($status, $client_id);
                }

                $this->load->helper('file');
                if (!is_really_writable(TEMP_FOLDER)) {
                    show_error('uploads folder is not writable. You need to change the permissions to 755');
                }
                $dir = TEMP_FOLDER . $file_name;
                if (is_dir($dir)) {
                    delete_dir($dir);
                }
                if (empty($all_proposal)) {
                    set_message('error', lang('no_record_available'));
                    if (!empty($client_id)) {
                        redirect('admin/client/client_details/' . $client_id . '/proposal');
                    } else {
                        redirect('admin/proposals');
                    }
                }
                mkdir($dir, 0777);
                foreach ($all_proposal as $v_proposal) {
                    $data['proposals_info'] = $v_proposal;
                    $pdf_file = $this->load->view('admin/proposals/proposals_pdf', $data, TRUE);
                    $_temp_file_name = slug_it($data['proposals_info']->reference_no);
                    $file_name = $dir . strtoupper($_temp_file_name);
                    if (!empty($client_info->name)) {
                        $cl_name = slug_it($client_info->name);
                    } else {
                        $cl_name = slug_it($status);
                    }
                    pdf_create($pdf_file, $data['proposals_info']->reference_no, 1, null, true, $cl_name);
                }
            } else if ($module == 'payment') {
                $view = can_action('15', 'view');
                if (!$view) {
                    access_denied('Zip Payment');
                }

                $status = $this->input->post('invoice_status');
                $ex = explode('_', $status);
                if (!empty($ex)) {
                    if (!empty($ex[1]) && is_numeric($ex[1])) {
                        $ex = 'year';
                    } else {
                        $ex = 'no';
                    }
                }
                $client_id = $this->input->post('client_id');
                if (!empty($client_id)) {
                    $client_info = $this->db->where('client_id', $client_id)->get('tbl_client')->row();
                    $file_name = slug_it($client_info->name);
                } else {
                    $file_name = slug_it($status);
                    $client_id = null;
                }
                if ($this->input->post('from_date') && $this->input->post('to_date') && $status != 'last_month' && $status != 'this_months' && $ex != 'year') {
                    $from_date = $this->input->post('from_date');
                    $to_date = $this->input->post('to_date');
                    if (!empty($client_id)) {
                        $this->db->where('paid_by', $client_id);
                    }
                    $this->db->where('payment_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"');
                    $all_payments = $this->db->get('tbl_payments')->result();
                } else {
                    $from_date = null;
                    $to_date = null;
                    $all_payments = $this->invoice_model->get_payments($status, $client_id);
                }
                $this->load->helper('file');
                if (!is_really_writable(TEMP_FOLDER)) {
                    show_error('uploads folder is not writable. You need to change the permissions to 755');
                }
                $dir = TEMP_FOLDER . $file_name;

                if (is_dir($dir)) {
                    delete_dir($dir);
                }
                if (empty($all_payments)) {
                    set_message('error', lang('no_record_available'));
                    if (!empty($client_id)) {
                        redirect('admin/client/client_details/' . $client_id . '/payment');
                    } else {
                        redirect('admin/invoice/all_payments');
                    }
                }
                mkdir($dir, 0777);
                foreach ($all_payments as $v_payment) {
                    $data['payments_info'] = $v_payment;
                    $pdf_file = $this->load->view('admin/invoice/payments_pdf', $data, TRUE);
                    $_temp_file_name = slug_it($data['payments_info']->trans_id);
                    $file_name = $dir . strtoupper($_temp_file_name);
                    if (!empty($client_info->name)) {
                        $cl_name = slug_it($client_info->name);
                    } else {
                        $cl_name = slug_it($status);
                    }
                    pdf_create($pdf_file, $data['payments_info']->trans_id, 1, null, true, $cl_name);
                }
            }

            $this->load->library('zip');
            // Read the invoices
            $this->zip->read_dir($dir, false);
            // Delete the temp directory for the client
            delete_dir($dir);
            if (!empty($client_info->name)) {
                $cl_name = slug_it($client_info->name);
            } else {
                $cl_name = slug_it($status);
            }
            $this->zip->download($module . '-' . $cl_name . '.zip');
            $this->zip->clear_data();
        } else {
            $data['title'] = lang('zip_' . $module);
            $data['client_id'] = $client_id;
            $data['module'] = $module;
            $data['subview'] = $this->load->view('admin/invoice/zipped', $data, FALSE);
            $this->load->view('admin/_layout_modal', $data);
        }
    }

    public function reminder($module, $module_id, $id = null)
    {
        $data['title'] = lang('reminder') . ' ' . lang('list');
        if ($this->input->post()) {

            $r_data['date'] = $this->input->post('date', true);
            $r_data['module'] = $module;
            $r_data['module_id'] = $module_id;
            $r_data['user_id'] = $this->input->post('user_id', true);
            $r_data['description'] = $this->input->post('description', true);
            $notify_by_email = $this->input->post('notify_by_email', true);
            if (empty($notify_by_email)) {
                $notify_by_email = 'No';
            } else {
                $notify_by_email = 'Yes';
            }
            $r_data['notify_by_email'] = $notify_by_email;
            $r_data['created_by'] = $this->session->userdata('user_id');
            $this->invoice_model->_table_name = 'tbl_reminders';
            $this->invoice_model->_primary_key = 'reminder_id';
            $this->invoice_model->save($r_data, $id);
            if ($module == 'client') {
                $url = 'admin/client/client_details/' . $module_id;
            } elseif ($module == 'invoice') {
                $url = 'admin/invoice/manage_invoice/invoice_details/' . $module_id;
            } elseif ($module == 'estimate') {
                $url = 'admin/estimates/index/estimates_details/' . $module_id;
            } elseif ($module == 'proposal') {
                $url = 'admin/proposals/index/proposals_details/' . $module_id;
            } else if ($module == 'leads') {
                $url = 'admin/leads/leads_details/' . $module_id;
            } else {
                $url = '#';
            }

            // Log Activity
            $activity = array(
                'user' => $this->session->userdata('user_id'),
                'module' => $module,
                'module_field_id' => $module_id,
                'activity' => ('activity_added_reminder'),
                'icon' => 'fa-shopping-cart',
                'link' => $url,
                'value1' => $r_data['description'],
            );
            $this->invoice_model->_table_name = 'tbl_activities';
            $this->invoice_model->_primary_key = 'activities_id';
            $this->invoice_model->save($activity);

            $type = "success";
            $message = lang('update_reminder');
            set_message($type, $message);

            if ($module == 'invoice') {
                redirect('admin/invoice/manage_invoice/invoice_details/' . $module_id);
            } else if ($module == 'estimate') {
                redirect('admin/estimates/index/estimates_details/' . $module_id);
            } else if ($module == 'proposal') {
                redirect('admin/proposals/index/proposals_details/' . $module_id);
            } else if ($module == 'client') {
                redirect('admin/client/client_details/' . $module_id);
            } else if ($module == 'leads') {
                redirect('admin/leads/leads_details/' . $module_id);
            } else {
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            if (!empty($id)) {
                $data['active'] = 2;
                $data['reminder_info'] = $this->db->where('reminder_id', $id)->get('tbl_reminders')->row();
            } else {
                $data['active'] = 1;
            }
            $data['all_reminder'] = $this->db->where(array('module' => $module, 'module_id' => $module_id))->get('tbl_reminders')->result();

            $data['module_id'] = $module_id;
            $data['module'] = $module;
            $data['subview'] = $this->load->view('admin/invoice/reminder', $data, FALSE);
            $this->load->view('admin/_layout_modal', $data);
        }
    }

    public function delete_reminder($module, $module_id, $id = null)
    {
        $reminder_info = $this->db->where('reminder_id', $id)->get('tbl_reminders')->row();

        if ($module == 'client') {
            $url = 'admin/client/client_details/' . $module_id;
        } elseif ($module == 'invoice') {
            $url = 'admin/invoice/manage_invoice/invoice_details/' . $module_id;
        } elseif ($module == 'estimate') {
            $url = 'admin/estimates/index/estimates_details/' . $module_id;
        } elseif ($module == 'proposal') {
            $url = 'admin/proposals/index/proposals_details/' . $module_id;
        } else if ($module == 'leads') {
            $url = 'admin/leads/leads_details/' . $module_id;
        } else {
            $url = '#';
        }
        // Log Activity
        $activity = array(
            'user' => $this->session->userdata('user_id'),
            'module' => $module,
            'module_field_id' => $module_id,
            'activity' => ('activity_delete_reminder'),
            'icon' => 'fa-shopping-cart',
            'link' => $url,
            'value1' => $reminder_info->description,
        );
        $this->invoice_model->_table_name = 'tbl_activities';
        $this->invoice_model->_primary_key = 'activities_id';
        $this->invoice_model->save($activity);

        $this->invoice_model->_table_name = 'tbl_reminders';
        $this->invoice_model->_primary_key = 'reminder_id';
        $this->invoice_model->delete($id);

        echo json_encode(array("status" => 'success', 'message' => lang('delete_reminder')));

        //        $type = "success";
        //        $message = lang('delete_reminder');
        //        set_message($type, $message);
        //
        //        if ($module == 'invoice') {
        //            redirect('admin/invoice/manage_invoice/invoice_details/' . $module_id);
        //        } else if ($module == 'estimate') {
        //            redirect('admin/estimates/index/estimates_details/' . $module_id);
        //        } else if ($module == 'proposal') {
        //            redirect('admin/proposals/index/proposals_details/' . $module_id);
        //        } else {
        //            redirect($_SERVER['HTTP_REFERER']);
        //        }
    }

    public function createInvoice()
    {
        $invoicedets = json_decode(file_get_contents(("php://input")), TRUE);
        if (!empty($invoicedets) && count($invoicedets['rows']) > 0) {
            $param = $invoicedets;
            $result = $this->invoice_model->createinvoice($param);

            echo json_encode($result);
            exit;
        }

        if ($result["code"] == 0) {

            //$this->hostbooks_authenticator->createInvoice($result['invoice_id']);

            $message["code"] = 1;
            $message["message"] = "Invoice Successfully Created";
            echo json_encode($message);
            die;
        } else {
            http_response_code(500);
            $message = $result["message"];
            echo json_encode($message);
            die;
        }
    }
    
    public function bulk_so_invoice_creation() {
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = json_decode(file_get_contents(("php://input")), TRUE);
            
            $result = $this->invoice_model->bulk_so_invoice_creation($data);

            echo json_encode($result);
            exit;
        }

        PREVIEW:

        $data['pageName'] = 'Bulk SO Invoice Creation';
        $data['title'] = "Bulk SO Invoice Creation"; //Page title 
        $data['subview'] = $this->load->view('admin/invoice/bulk_so_invoice_creation', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getInvoiceApi($status = null)
    {
        // $data=$this->input->post();
        if ($status != '') {
            $invoiceList = $this->db->where('status', $status)->get('INVOICE_LIST_VIEW')->result_array();
        } else {
            $invoiceList = $this->db->get('INVOICE_LIST_VIEW')->result_array();
        }
        $data = array();

        if (!empty($invoiceList)) {
            foreach ($invoiceList as $invoice) {
                $net_invoice_amount = $invoice['amount'] - $invoice['discount_amount'] + $invoice['insurance_amount'] + $invoice['freight_amount'] + $invoice['tcs_amount'];
                $data[] = array(
                    "invoice_id" => $invoice['invoice_id'],
                    "invoice_code" => $invoice['invoice_code'],
                    "vendor_name" => $invoice['vendor_name'],
		    "vendor_code" => $invoice['vendor_code'],
                    "salesman" => $invoice['salesman'],
                    "status" => $invoice['status'],
                    "CREATION_DATE" => date('d-m-Y', strtotime($invoice['CREATION_DATE'])),
                    "LAST_UPDATE_DATE" => date('d-m-Y', strtotime($invoice['LAST_UPDATE_DATE'])),
                    "CREATED_BY" => $invoice['CREATED_BY'],
                    "LAST_UPDATED_BY" => $invoice['LAST_UPDATED_BY'],
                    "amount" => $invoice['amount'],
                    "tax" => $invoice['tax'],
                    "discount_amount" => $invoice['discount_amount'],
                    "freight_amount" => $invoice['freight_amount'],
                    "insurance_amount" => $invoice['insurance_amount'],
                    "tcs_amount" => $invoice['tcs_amount'],
                    "net_invoice_amount" => $net_invoice_amount,
                    "amount_ex_tax" => round($invoice['amount'] - $invoice['tax'], 2),
                    "sales_code" => $invoice['sales_code'],
                    "sales_channel" => $invoice['sales_channel'],
                    "saleschannel_ref_id" => $invoice['saleschannel_ref_id'],
                    "payment_mode" => $invoice['payment_mode'],
                    "quantity" => $invoice['quantity'],
                );
            }
        }

        $result['data'] = $data;

        echo json_encode($result);

        die;
    }

    public function get_invoicedetails()
    {

        $data = $this->input->get('invoice_id');
        $result = $this->invoice_model->getinvoicedetails($data);
        $json['status'] = '1';
        $taxable_cat = TAXABLE_CATEGORY;
        if (!empty($result)) {
            foreach ($result as $value) {
                if ($value["bill_type"] == 'TAXABLE') {
                    $category = $value["category"];
                    $unit_price = 0;
                    $unit_price_tax = 0;
                    $exempt = 0;
                    $taxable = round(($value["price"] - ($unit_price + $unit_price_tax)) / 1.18, 2);
                } else {
                    $category = 'PRE-OWNED';
                    $unit_price = $value['unit_price'];
                    $unit_price_tax = $value['unit_price_tax'];
                    $exempt = $value['unit_price'] + $value['unit_price_tax'];
                    $taxable = round(($value["price"] - ($unit_price + $unit_price_tax)) / 1.18, 2);
                    if ($exempt > $value['price']) {
                        $taxable = 0.00;
                        $exempt = $value['price'];
                    }
                }
                $invoice[] = array(
                    'product_name' => $value["device_name"],
                    'inward_id' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'margin' => $value["margin"],
                    'sales_terms' => $value["sales_terms"],
                    'grade' => $value["grade"],
                    'price' => $value["price"],
                    'taxable' => $taxable,
                    'unit_price' => $exempt,
                    'tax_amount' => $value['tax_amount'],
                    'color' => $value["color"],
                    'ram' => $value["ram"],
                    'grade' => $value["grade"],
                    'rom' => $value["rom"],
                    'category' => $category,
                    'tax_type' => $value["tax_type"],
                    'bill_type' => $value["bill_type"],
                    'color_code' => $value["color_code"]
                );
            }
            $json['result'] = $invoice;
        }
        echo json_encode($json);
        die;
    }

    public function open_invoicepdf($invoice = null, $pdf = '')
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();

        $rows = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_PDF_ROWS_VIEW')->result_array();

        //$result = $this->invoice_model->getInvoiceRows_pdf($invoice_id);

        $this->db->where('tbl_invoice_item.invoice_id', $invoice_id);
        $this->db->select('tbl_grnreport.device_name, tbl_grnreport.ram, tbl_grnreport.rom, count(tbl_grnreport.grnreport_id) as count');
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_invoice_item.grnreport_id', 'Left');
        $modelwise = $this->db->group_by('tbl_grnreport.nhmod, tbl_grnreport.ram, tbl_grnreport.rom')->order_by('device_name')->get("tbl_invoice_item")->result_array();

        if (!empty($rows)) {
            $product_type = $rows[0]['product_type'];
            $hsn_code = $this->db->get_where('tbl_device_type',array("name"=>$product_type))->row()->hsn_code;
            $total_tax = 0;
            $bundles = [];
            foreach ($rows as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'product_type' => $value["product_type"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'imei' => $value["imei"],
                    'ram' => $value["ram"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'sku' => $value["SKU"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'tax_amount' => $value["tax_amount"],
                    'price' => $value["price"],
                    'tax_type' => $value["tax_type"],
                    'unit_price' => $value['unit_price'],
                    'unit_price_tax' => $value['unit_price_tax'],
                    'sales_terms' => $value['sales_terms'],
                    'bill_type' => $value['bill_type'],
                );
                if($value['bundle_id']>0){
                    $bundles[] = $value['bundle_id'];
                }
            }
            $data['rows'] = $invoice_rows;
        }

        foreach ($modelwise as $models) {
            $variant_count[] = array(
                "product_name" => $models['device_name'],
                "ram" => $models['ram'],
                "rom" => $models['rom'],
                "quantity" => $models['count']
            );
        }

        $data['variant_count'] = $variant_count;

        if (!empty($invoice_header)) {

            if (!empty($invoice_header[0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($invoice_header[0]["gst_no"], 0, 2))->get('tbl_states')->row();

            $discount = $invoice_header[0]['discount_amount'] / 1.18;
            $discount_tax =  $invoice_header[0]['discount_amount'] - $discount;

            $freight = $invoice_header[0]['freight_amount'] / 1.18;
            $freight_tax =  $invoice_header[0]['freight_amount'] - $freight;

            $insurance = $invoice_header[0]['insurance_amount'] / 1.18;
            $insurance_tax =  $invoice_header[0]['insurance_amount'] - $insurance;

            $tcs = $invoice_header[0]['tcs_amount'] / 1.18;
            $tcs_tax =  $invoice_header[0]['tcs_amount'] - $tcs;

            $total_amount = $invoice_header[0]["amount"] - $invoice_header[0]['discount_amount'] + $invoice_header[0]['freight_amount'] + $invoice_header[0]['insurance_amount'] + $invoice_header[0]['tcs_amount'];

            $total_amount = round($total_amount, 0);
            $amount_words = $this->getIndianCurrency($total_amount);
            $get_type = strtolower($this->input->get('type'));
            if ($get_type == 'original') {
                $type = 'Original for recipient';
            }
            if ($get_type == 'duplicate') {
                $type = 'Duplicate for transporter';
            }
            if ($get_type == 'triplicate') {
                $type = 'Triplicate for supplier';
            }
	    $so_id = $invoice_header[0]['salesorder_id'];
	    $lp_payments = $this->db->select('reference_no')->where('salesorder_id', $so_id)->get('tbl_so_link_logistic_partner')->row();
	    if(!empty($lp_payments)){
			$data["lp_reference"] = $lp_payments->reference_no;
		}
            $data["gst_no"] = $invoice_header[0]["gst_no"];
            $data["company"] = $invoice_header[0]["company"];
            $data["vendor_code"] = $invoice_header[0]["vendor_code"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["mobile"] = $invoice_header[0]["mobile"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['device_sub_category'] = $invoice_header[0]["device_sub_category"];
            $data['place_supply'] = $supply_place->name;
            $data['hsn_code'] = $hsn_code;
            $data['product_type'] = $product_type;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
            $data["amount"] = $invoice_header[0]["amount"];
            $data["total_amount"] = $total_amount;
            $data["tax"] = $invoice_header[0]["tax"];

            $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];
            $data['amount_words'] = $amount_words;

            $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];
            $data['type'] = $type;
            $data['no_grade'] = $this->input->get('no_grade');

            $data['discount_total'] = $invoice_header[0]['discount_amount'];
            $data['discount_amount'] = $discount;
            $data['discount_tax'] = $discount_tax;

            $data['freight_total'] = $invoice_header[0]['freight_amount'];
            $data['freight_amount'] = $freight;
            $data['freight_tax'] = $freight_tax;

            $data['insurance_total'] = $invoice_header[0]['insurance_amount'];
            $data['insurance_amount'] = $insurance;
            $data['insurance_tax'] = $insurance_tax;

            $data['tcs_total'] = round($invoice_header[0]['tcs_amount'], 0);
            $data['tcs_percent'] = $invoice_header[0]['tcs_percent'];

            $gross_tax = $invoice_header[0]["tax"] - $discount_tax + $freight_tax + $insurance_tax;
            $data['gross_tax'] = $gross_tax;
            $data['irn'] = $invoice_header[0]["irn"];
            $data['qr_code'] = $invoice_header[0]["qr_code"];

            if(!empty($bundles)){
                $bundle_nos_arr = $this->db->select('bundle_no')->where_in('bundle_id', $bundles)->get('tbl_dealer_bundle')->result_array();
                $data['bundle_nos'] = implode(',', array_column($bundle_nos_arr, 'bundle_no'));
            }

            if($invoice_header[0]["sales_channel"] === 'DEALERAPP'){
                $shipping_address = $this->db->select('dispatch_address, city, state, pincode')
                ->where('salesorder_id', $invoice_header[0]["salesorder_id"])->get('tbl_dealer_order_dispatch_address')->row();
                if(!empty($shipping_address)){
                    $data['shipping_address'] = array(
                        "dispatch_address" => $shipping_address->dispatch_address,
                        "city" => $shipping_address->city,
                        "state" => $shipping_address->state,
                        "pincode" => $shipping_address->pincode
                    );
                }
                
                $data['shipping_from_address'] = array(
                        "address" => "1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet",
                        "city" => "Hyderabad",
                        "state" => "Telangana",
                        "pincode" => "INDIA 500016"
                    );
                $data['billing_from_address'] = array(
                        "address" => "4th Floor, 1-11-251/19/A, Jayalakshmi Towers, Motilal Nehru Nagar,
                        Begumpet, Hyderabad, Telangana, 500016",
                        // "city" => "Hyderabad",
                        // "state" => "Telangana",
                        "gst_no" => "36AASCS2801C1ZI"
                    );
                
            } else{
                $salesorderid = $invoice_header[0]["salesorder_id"];
                
                $shipping_from_data = $this->db->get_where('SHIPPING_FROM_AND_TO_LIST_VIEW',array("salesorder_id" => $salesorderid))->row();
                
                if(count($shipping_from_data) < 1){
                   $data['shipping_from_address'] = array(
                        "address" => "1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet",
                        "city" => "Hyderabad",
                        "state" => "Telangana",
                        "pincode" => "INDIA 500016"
                    );
                    $data['shipping_address'] = array(
                        "address" => $invoice_header[0]["address"],
                        "city" => $invoice_header[0]["city"],
                        "state" => $invoice_header[0]["state"],
                        "pincode" => $invoice_header[0]["pincode"]
                    );
                    $data['billing_from_address'] = array(
                        "address" => "4th Floor, 1-11-251/19/A, Jayalakshmi Towers, Motilal Nehru Nagar,
                        Begumpet, Hyderabad, Telangana, 500016",
                        // "city" => "Hyderabad",
                        // "state" => "Telangana",
                        "gst_no" => "36AASCS2801C1ZI"
                    );
                    
                } else{
                    
                   $billing_from_id = $shipping_from_data->billing_from_id;
                   $billing_from_data = $this->db->get_where('tbl_wh_loc',array("wh_id" => $billing_from_id))->row();
                   
                   $data['shipping_from_address'] = array(
                        "address" => $shipping_from_data->from_address,
                        "city" => $shipping_from_data->from_city,
                        "state" => $shipping_from_data->from_state,
                        "pincode" => $shipping_from_data->from_pincode
                    );
                    $data['shipping_address'] = array(
                        "address" => $shipping_from_data->to_address,
                        "city" => $shipping_from_data->to_city,
                        "state" => $shipping_from_data->to_state,
                        "pincode" => $shipping_from_data->to_pincode
                    );
                    $data['billing_from_address'] = array(
                        "address" => $billing_from_data->address,
                        // "city" => $billing_from_data->city,
                        // "state" => $billing_from_data->state,
                        "gst_no" => $billing_from_data->gst_number
                    );
                }
                
            }

        }
        $path = '';
        if (!empty($data['qr_code'])) {
            $path = "./uploads/qr_code/" . $invoice_id . ".png";
            $this->infiqr->generate($invoice_header[0]['qr_code'], 'png', $path);
        }

        $data['filename'] = $path;


        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_invoice', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    public function open_device_detailspdf($invoice = null, $pdf = '')
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();

        $rows = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_PDF_ROWS_VIEW')->result_array();

        //$result = $this->invoice_model->getInvoiceRows_pdf($invoice_id);

        $this->db->where('tbl_invoice_item.invoice_id', $invoice_id);
        $this->db->select('tbl_grnreport.device_name, tbl_grnreport.ram, tbl_grnreport.rom, count(tbl_grnreport.grnreport_id) as count');
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_invoice_item.grnreport_id', 'Left');
        $modelwise = $this->db->group_by('tbl_grnreport.nhmod, tbl_grnreport.ram, tbl_grnreport.rom')->order_by('device_name')->get("tbl_invoice_item")->result_array();

        if (!empty($rows)) {
            $total_tax = 0;
            foreach ($rows as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'imei' => $value["imei"],
                    'ram' => $value["ram"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'sku' => $value["SKU"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'tax_amount' => $value["tax_amount"],
                    'price' => $value["price"],
                    'tax_type' => $value["tax_type"],
                    'unit_price' => $value['unit_price'],
                    'unit_price_tax' => $value['unit_price_tax'],
                    'sales_terms' => $value['sales_terms'],
                    'bill_type' => $value['bill_type'],

                );
            }
            $data['rows'] = $invoice_rows;
        }

        foreach ($modelwise as $models) {
            $variant_count[] = array(
                "product_name" => $models['device_name'],
                "ram" => $models['ram'],
                "rom" => $models['rom'],
                "quantity" => $models['count']
            );
        }

        $data['variant_count'] = $variant_count;

        if (!empty($invoice_header)) {
            if (!empty($invoice_header[0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($invoice_header[0]["gst_no"], 0, 2))->get('tbl_states')->row();

            $discount = $invoice_header[0]['discount_amount'] / 1.18;
            $discount_tax =  $invoice_header[0]['discount_amount'] - $discount;

            $freight = $invoice_header[0]['freight_amount'] / 1.18;
            $freight_tax =  $invoice_header[0]['freight_amount'] - $freight;

            $insurance = $invoice_header[0]['insurance_amount'] / 1.18;
            $insurance_tax =  $invoice_header[0]['insurance_amount'] - $insurance;

            $tcs = $invoice_header[0]['tcs_amount'] / 1.18;
            $tcs_tax =  $invoice_header[0]['tcs_amount'] - $tcs;

            $total_amount = $invoice_header[0]["amount"] - $invoice_header[0]['discount_amount'] + $invoice_header[0]['freight_amount'] + $invoice_header[0]['insurance_amount'] + $invoice_header[0]['tcs_amount'];

            $total_amount = round($total_amount, 0);
            $amount_words = $this->getIndianCurrency($total_amount);
            $get_type = strtolower($this->input->get('type'));
            if ($get_type == 'original') {
                $type = 'Original for recipient';
            }
            if ($get_type == 'duplicate') {
                $type = 'Duplicate for transporter';
            }
            if ($get_type == 'triplicate') {
                $type = 'Triplicate for supplier';
            }

            $data["gst_no"] = $invoice_header[0]["gst_no"];
            $data["company"] = $invoice_header[0]["company"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['place_supply'] = $supply_place->name;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
            $data["amount"] = $invoice_header[0]["amount"];
            $data["total_amount"] = $total_amount;
            $data["tax"] = $invoice_header[0]["tax"];

            $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];
            $data['amount_words'] = $amount_words;

            $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];
            $data['type'] = $type;
            $data['no_grade'] = $this->input->get('no_grade');
        }

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_device_details', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    public function open_modelwisepdf($invoice = null, $pdf = '')
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();


        $this->db->where('tbl_invoice_item.invoice_id', $invoice_id);
        $this->db->select('tbl_grnreport.device_name, tbl_grnreport.ram, tbl_grnreport.rom, count(tbl_grnreport.grnreport_id) as count');
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_invoice_item.grnreport_id', 'Left');
        $modelwise = $this->db->group_by('tbl_grnreport.nhmod, tbl_grnreport.ram, tbl_grnreport.rom')->order_by('device_name')->get("tbl_invoice_item")->result_array();

        foreach ($modelwise as $models) {
            $variant_count[] = array(
                "product_name" => $models['device_name'],
                "ram" => $models['ram'],
                "rom" => $models['rom'],
                "quantity" => $models['count']
            );
        }

        $data['variant_count'] = $variant_count;

        if (!empty($invoice_header)) {

            $data["company"] = $invoice_header[0]["company"];

            $data["date"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
        }

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/modelwise_list_pdf', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    public function packedlist_pdf($invoice_id = 0)
    {


        $download = $this->input->get('download');
        if ($invoice_id > 0)
            $result = $this->invoice_model->getPackedList($invoice_id);
        if (!empty($result["rows"])) {
            foreach ($result["rows"] as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'ram' => $value["ram"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'bin_number' => $value["bin_number"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'color' => $value["color"],
                    'quantity' => $value["quantity"]
                );
            }
            $data['rows'] = $invoice_rows;
        }
        if (!empty($result["header"])) {
            $data["company"] = $result["header"][0]["company"];
            $data["salesorder_code"] = $result["header"][0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($result["header"][0]["CREATION_DATE"]));
            $data["invoice_code"] = $result["header"][0]["invoice_code"];
        }
        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/invoice/packedlist_pdf', $data, TRUE);
        pdf_create($viewfile, "PackedList#" . $invoice_id, TRUE, '', $download, '', '');
    }

    function getIndianCurrency(float $number) {
        $this->getCurrencyInWords($number, 'Rupees');
    }
    function getCurrencyInWords(float $number, $currency_type) {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(
            0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
            13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
            16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
            19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
            40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
            70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
        );
        $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str[] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 0) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ? $currency_type .': ' . $Rupees : '') . $paise . 'Only';
    }

    public function editInvoiceForm($invoice_id)
    {

        if ($invoice_id > 0)
            $header = $this->invoice_model->getInvoiceHeader($invoice_id);
        $rows = $this->invoice_model->getinvoicedetails($invoice_id);
        $salesorderdets = $this->db->select('salesorder_id')->where('invoice_id', $invoice_id)->from('tbl_invoice')->get()->row();
        if ($salesorderdets->salesorder_id > 0) {
            $this->load->model('SalesOrder_model');
            $quantity = $this->SalesOrder_model->get_salesorder_quantity($salesorderdets->salesorder_id);
            $data['quantity'] = $quantity;
        }
        if (!empty($header)) {
            $stateResult = $this->db->select('name,state_gst_id')->where('state_id', $header[0]["state"])->get('tbl_states')->row();
            if (!empty($header[0]["gst_no"]))
                $supply_place = $this->db->select('state_gst_id')->where('state_gst_id', substr($header[0]["gst_no"], 0, 2))->get('tbl_states')->row();
            if ($supply_place->state_gst_id > 0) {
                $state_gst = $supply_place->state_gst_id;
            } else {
                $state_gst = $stateResult->state_gst_id;
            }
            $data["invoice_id"] = $invoice_id;
            $data["gst_no"] = $header[0]["gst_no"];
            $data["vendor_name"] = $header[0]["vendor_name"];
            $data["vendor_code"] = $header[0]["vendor_code"];
            $data["mobile"] = $header[0]["mobile"];
            $data["address"] = $header[0]["address"];
            $data["state"] = $header[0]["state"];
            $data["city"] = $header[0]["city"];
            $data["pincode"] = $header[0]["pincode"];
            $data["payment_mode"] = $header[0]["payment_mode"];
            $data["salesorder_code"] = $header[0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $header[0]["invoice_code"];
            $data["amount"] = $header[0]["amount"];
            $data["tax"] = $header[0]["tax"];
            $data["salesman"] = $header[0]["salesman"];
            $data["sales_channel"] = $header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $header[0]["saleschannel_ref_id"];
            $data['pan_no'] = $header[0]["pan_card"];
            $data['warehouse'] = $header[0]["warehouse"];
            $data['invoice_id'] = $header[0]["invoice_id"];
            $data['state_gst_no'] = $state_gst;
            $data['salesorder_id'] = $salesorderdets->salesorder_id;
        }

        if (!empty($rows)) {
            foreach ($rows as $value) {
                $invoice_rows[] = array(
                    'invoice_item_id' => $value["invoice_item_id"],
                    'product_name' => $value["device_name"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'imei' => $value["imei"],
                    'ram' => $value["ram"],
                    'color' => $value["color"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'tax_amount' => $value["tax_amount"],
                    'margin_perc' => $value["margin_perc"],
                    'price' => $value["price"],
                    'tax_type' => $value["tax_type"],
                    'unit_price' => $value['unit_price'],
                    'sales_terms' => $value['sales_terms'],
                    'bill_type' => $value['bill_type'],
                );
            }
            $data['rows'] = $invoice_rows;
        }

        if (!empty($data)) {
            $data['page'] = "manage_finance";
            $data['active'] = 5;
            $data['title'] = 'Update Invoice';
            $data['subview'] = $this->load->view('admin/finance/manage_finance', $data, TRUE);
            $this->load->view('admin/_layout_main', $data); //page load
        }
    }

    public function getInvoiceSummary($invoice_id = 0)
    {
        if ($invoice_id > 0)
            $result = $this->invoice_model->getPackedList($invoice_id);
        if (!empty($result["rows"])) {
            foreach ($result["rows"] as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'ram' => $value["ram"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'quantity' => $value["quantity"]
                );
            }
            $data['rows'] = $invoice_rows;
            $data['status'] = 1;
        }
        echo json_encode($data);
        die;
    }

    public function getInvoicePackageList($type = '')
    {

        $rows = array();
        if ($type == 'PACKED') {
            $result = $this->invoice_model->getInvoicePackages();
            if (!empty($result)) {
                foreach ($result as $rowValue) {
                    $rows[] = array(
                        "invoice_id" => $rowValue['invoice_id'],
                        "invoice_code" => $rowValue['invoice_code'],
                        "vendor_name" => $rowValue['vendor_name'],
                        "no_packages" => $rowValue['no_packages'],
                        "quantity" => $rowValue['quantity'],
                        "date" => $rowValue['date'],
                    );
                }
            }
        }
        $data['status'] = 1;
        $data['data'] = $rows;

        echo json_encode($data);
        die;
    }

    public function getInvoiceShippingList()
    {

        $rows = array();
        $result = $this->invoice_model->getShippingList();
        if (!empty($result)) {
            foreach ($result as $rowValue) {
                if ($rowValue['eway_bill_date'] == '0000-00-00 00:00:00') {
                    $eway_bill_date = '';
                } else {
                    $eway_bill_date = date("d-m-Y", strtotime($rowValue['eway_bill_date']));
                }
                $rows[] = array(
                    "shipping_list_id" => $rowValue['shipping_list_id'],
                    "invoice_code" => $rowValue['invoice_code'],
                    "vendor_name" => $rowValue['vendor_name'],
                    "delivery_mode" => $rowValue['delivery_mode'],
                    "logistics_partner_name" => $rowValue['logistics_partner_name'],
                    "docket_number" => $rowValue['docket_number'],
                    "pickup_boy" => $rowValue['pickup_boy'],
                    "employee_name" => $rowValue['employee_name'],
                    "transporter" => $rowValue['transporter'],
                    "eway_bill" => $rowValue['eway_bill'],
                    "eway_bill_date" => $eway_bill_date,
                    "CREATION_DATE" => date("d-m-Y", strtotime($rowValue['CREATION_DATE'])),
                );
            }
        }
        $data['status'] = 1;
        $data['data'] = $rows;

        echo json_encode($data);
        die;
    }

    public function rejectInvoice()
    {

        $invoice_id = $this->input->post('invoice_id');
        $remark = $this->input->post('remark');
        if ($invoice_id > 0) {
            $result = $this->invoice_model->rejectInvoice($invoice_id, $remark);
            if ($result) {
                $data['status'] = 1;
            } else {
                $data["status"] = 0;
            }
        } else {
            $data["status"] = 0;
        }
        echo json_encode($data);
        die;
    }

    public function editInvoice($invoice_id)
    {
        $invoicedets = json_decode(file_get_contents(("php://input")), TRUE);

        if ($invoice_id > 0 && sizeof($invoicedets['rows']) > 0) {
            $rows = $invoicedets;
            foreach ($invoicedets['rows'] as $rowValue) {
                if ($rowValue['invoice_item_id'] > 0) {
                    $old_rows[$rowValue['invoice_item_id']] = true;
                } else {
                    $new_rows[] = $rowValue;
                }
            }
            $result = $this->invoice_model->editInvoice($invoice_id, $new_rows, $old_rows);
        }
        if ($result) {
            $message["code"] = 1;
            $message["message"] = "Invoice Successfully Created";
            echo json_encode($message);
            die;
        } else {
            http_response_code(500);
            $message = "Failed to Edit Invoice";
            echo json_encode($message);
            die;
        }
    }

    public function cancelInvoice($invoice_id)
    {
        $request = file_get_contents("php://input");
        $data  = json_decode($request, true);


        if ($invoice_id > 0) {

            $status_obj = $this->db->select('status')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();

            if ($status_obj->status != 'INVOICED') {

                $json['status'] = 0;
                echo json_encode($json);
                die;
            }
            $result = $this->invoice_model->cancelInvoice($invoice_id, $data);

            if ($result) {
                $json["status"] = 1;
            } else {

                $json['status'] = 0;
            }

            echo json_encode($json);
            die;
        } else {

            $json['status'] = 0;
        }
        echo json_encode($json);
        die;
    }

    public function getSOFileslist()
    {

        $invoice_id = $this->input->get('invoice_id');

        if (empty($invoice_id)) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $so_obj = $this->db->select('salesorder_id')->where('invoice_id', $invoice_id)->get('tbl_invoice')->row();
        $salesorder_id = $so_obj->salesorder_id;

        if (empty($salesorder_id)) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $files = scandir("./upload_so/" . $salesorder_id . "/");
        $file_names = array();

        foreach ($files as $file) {

            if ($file != '.' && $file != '..') {

                $file_names[] = array(

                    "file_name" => $file
                );
            }
        }

        $json['status'] = 1;
        $json["directory"] = "upload_so/" . $salesorder_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
    }
    public function open_invoicepdfOnline($invoice = null, $pdf = '')
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $result = $this->invoice_model->getInvoiceRows_pdf($invoice_id);

        if (!empty($result["rows"])) {
            $total_tax = 0;
            foreach ($result["rows"] as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'imei' => $value["imei"],
                    'ram' => $value["ram"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'tax_amount' => $value["tax_amount"],
                    'price' => $value["price"],
                    'tax_type' => $value["tax_type"],
                    'unit_price' => $value['unit_price'],
                    'unit_price_tax' => $value['unit_price_tax'],
                    'sales_terms' => $value['sales_terms'],
                    'bill_type' => $value['bill_type'],
                    'invoice_type' => $value['invoice_type'],

                );
            }
            $data['rows'] = $invoice_rows;
        }
        if (!empty($result["header"])) {



            if (!empty($result["header"][0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($result["header"][0]["gst_no"], 0, 2))->get('tbl_states')->row();

            $discount = $result["header"][0]['discount_amount'] / 1.18;
            $discount_tax =  $result["header"][0]['discount_amount'] - $discount;

            $freight = $result["header"][0]['freight_amount'] / 1.18;
            $freight_tax =  $result["header"][0]['freight_amount'] - $freight;

            $insurance = $result["header"][0]['insurance_amount'] / 1.18;
            $insurance_tax =  $result["header"][0]['insurance_amount'] - $insurance;

            $tcs = $result["header"][0]['tcs_amount'] / 1.18;
            $tcs_tax =  $result["header"][0]['tcs_amount'] - $tcs;

            $total_amount = $result["header"][0]["amount"] - $result["header"][0]['discount_amount'] + $result["header"][0]['freight_amount'] + $result["header"][0]['insurance_amount'] + $result["header"][0]['tcs_amount'];

            $amount_words = $this->getIndianCurrency($total_amount);
            $get_type = strtolower($this->input->get('type'));
            if ($get_type == 'original') {
                $type = 'ORIGINAL FOR RECIPIENT';
            }
            if ($get_type == 'duplicate') {
                $type = 'DUPLICATE FOR TRANSPORTER';
            }
            if ($get_type == 'triplicate') {
                $type = 'TRIPLICATE FOR SUPPLIER';
            }

            $data["gst_no"] = $result["header"][0]["gst_no"];
            $data["company"] = $result["header"][0]["company"];
            $data["address"] = $result["header"][0]["address"];
            $data["state"] = $result["header"][0]["state"];
            $data["state_id"] = $result["header"][0]["state_id"];
            $data["city"] = $result["header"][0]["city"];
            $data["pincode"] = $result["header"][0]["pincode"];
            $data["payment_mode"] = $result["header"][0]["payment_mode"];
            $data["salesorder_code"] = $result["header"][0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($result["header"][0]["CREATION_DATE"]));
            $data["invoice_code"] = $result["header"][0]["invoice_code"];
            $data["amount"] = $result["header"][0]["amount"];
            $data["total_amount"] = $total_amount;
            $data["tax"] = $result["header"][0]["tax"];
            $data["salesman"] = $result["header"][0]["salesman"];
            $data["sales_channel"] = $result["header"][0]["sales_channel"];
            $data["saleschannel_ref_id"] = $result["header"][0]["saleschannel_ref_id"];
            $data['amount_words'] = $amount_words;
            $data['pan_no'] = $result["header"][0]["pan_card"];
            $data['warehouse'] = $result["header"][0]["warehouse"];
            $data['invoice_id'] = $result["header"][0]["invoice_id"];
            $data['type'] = $type;
            $data['no_grade'] = $this->input->get('no_grade');
            $data['place_supply'] = $supply_place->name;

            $data['discount_total'] = $result["header"][0]['discount_amount'];
            $data['discount_amount'] = $discount;
            $data['discount_tax'] = $discount_tax;

            $data['freight_total'] = $result["header"][0]['freight_amount'];
            $data['freight_amount'] = $freight;
            $data['freight_tax'] = $freight_tax;

            $data['insurance_total'] = $result["header"][0]['insurance_amount'];
            $data['insurance_amount'] = $insurance;
            $data['insurance_tax'] = $insurance_tax;

            $data['tcs_total'] = $result["header"][0]['tcs_amount'];
            $data['tcs_percent'] = $result["header"][0]['tcs_percent'];

            $gross_tax = $result["header"][0]["tax"] - $discount_tax + $freight_tax + $insurance_tax;
            $data['gross_tax'] = $gross_tax;
        }

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_invoice_online', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    public function getInvoiceInfo()
    {
        $invoice_no = $_GET['invoice_no'];
        $result  =  $this->db->where('invoice_code', $invoice_no)->get('INVOICE_LIST_VIEW')->row();
        if (!empty($result)) {
            $json = $result;
        } else {
            http_response_code(500);
            $json['status'] = 'Details not found';
        }

        echo json_encode($json);
        die;
    }

    public function gatepass_pdf($shipping_list_id = 0)
    {
        $download = $this->input->get('download');

        if ($shipping_list_id > 0) {

            $result = $this->db->where('shipping_list_id', $shipping_list_id)->get('INVOICE_GATEPASS_VIEW')->row();
        }


        if (!empty($result)) {

            $data['invoice_code'] = $result->invoice_code;
            $data['package'] = $result->package_no;
            $data['quantity'] = $result->quantity;
            $data['ewaybill_no'] = $result->eway_bill;
            $data['vendor_name'] = $result->vendor_name;
            $data['creation_date'] = $result->CREATION_DATE;
        }

        $data['date'] = date('d-m-Y');

        $this->load->helper('dompdf');

        $viewfile = $this->load->view('admin/security_admin/gatepass', $data, TRUE);

        pdf_picklist($viewfile, "gatepass#" . $shipping_list_id, TRUE, '', $download, '', '');
    }
    public function getInvoiceLogInfo()
    {
        $invoice_no = $_GET['invoice_no'];
        $result = $this->db->where('invoice_code', $invoice_no)->get('INVOICE_DETAILS_LOG')->result_array();
        echo json_encode(array("draw" => 1, "recordsTotal" => count($result), "recordsFiltered" => count($result), "data" => $result));
        die;
    }


    function generateNewInvoice()
    {
        $salesorder_id = $this->input->get('salesorder_id');

        if ((int) $salesorder_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $invoice_check = $this->db->where("salesorder_id", $salesorder_id)->get('tbl_invoice')->row();

        if (!empty($invoice_check)) {
            $json['status'] = 2;
            $json['invoice_code'] = $invoice_check->invoice_code;
            echo json_encode($json);
            exit;
        }

        $sales_order = $this->db->where("salesorder_id", $salesorder_id)->get('tbl_salesorder')->row();

        if (!isset($sales_order)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if (!in_array($sales_order->sales_channel, ['OFFLINE', 'DEALERAPP', 'EXPORT']) ) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if ($sales_order->status != 'FINANCE_APPROVED') {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $module_type = $sales_order->module_type;

        if ($module_type == 2) {
            // $tax_type = 'NA';
            $tax_type = 'IGST18';
        } else {
            $vendorResult = $this->db->where('vendor_id', $sales_order->vendor_id)->get('tbl_vendor')->row();
            $stateResult = $this->db->select('name, state_gst_id')->where('state_id', $vendorResult->state)->get('tbl_states')->row();

            if ($stateResult->state_gst_id == 36) {
                $tax_type = 'CGST18';
            } else {
                $tax_type = 'IGST18';
            }
        }
        

        $so_items = $this->db->where("salesorder_id", $salesorder_id)->get('tbl_salesorder_item')->result_array();
        $rows = array();
        $total_amount = 0;
        $total_tax = 0;
        if (!empty($so_items)) {
            foreach ($so_items as $rowValue) {

                if ((int) $rowValue['grnreport_id'] <= 0) {
                    $no_device = true;
                    break;
                }

                $grnreport = $this->db->select('status, unit_price, unit_price_tax, stock_type, saletype, nhdin, invoice_type, bundle_id')->where('grnreport_id', $rowValue['grnreport_id'])->get('tbl_grnreport')->row();

                if (!isset($grnreport)) {
                    $no_device = true;
                    break;
                }
                if ($grnreport->status != 'RFS') {
                    $invalid_status = true;
                    $tdid = $grnreport->nhdin;
                    break;
                }

                if ($sales_order->sales_channel == 'OFFLINE') {
                    if ($grnreport->saletype != 'OFFLINE') {
                        $invalid_saletype = true;
                        $tdid = $grnreport->nhdin;
                        break;
                    }
                } else if ($sales_order->sales_channel == 'DEALERAPP') {
                    if ($grnreport->saletype != 'OFFLINE' && $grnreport->saletype != 'DEALERAPP') {
                        $invalid_saletype = true;
                        $tdid = $grnreport->nhdin;
                        break;
                    }
                } else if ($sales_order->sales_channel == 'EXPORT') {
                    if ($grnreport->saletype != 'EXPORT') {
                        $invalid_saletype = true;
                        $tdid = $grnreport->nhdin;
                        break;
                    }
                } else {
                    if ($grnreport->saletype != 'ONLINE') {
                        $invalid_saletype = true;
                        $tdid = $grnreport->nhdin;
                        break;
                    }
                }

                $this->db->select('tbl_invoice.status, tbl_invoice.invoice_code')->where('tbl_invoice_item.grnreport_id', $rowValue['grnreport_id']);
                $invoice = $this->db->join('tbl_invoice', 'tbl_invoice_item.invoice_id = tbl_invoice.invoice_id', 'Left')->get('tbl_invoice_item')->result_array();
                $inv_status = ['INVOICED', 'PACKED', 'SHIPPED'];

                foreach ($invoice as $invoiceRow) {
                    if (in_array($invoiceRow['status'], $inv_status)) {
                        $invoice_exists = true;
                        $tdid = $grnreport->nhdin;
                        $inv_code = $invoiceRow['invoice_code'];
                        break 2;
                    }
                }
                
                $tax=0;
                $margin=0;
                $margin_perc=0;
                
                if (in_array($sales_order->sales_channel, MARGINAL_NOT_ALLOWED_CHANNELS)) {
                    $bill_type = 'TAXABLE';
                    $tax = $rowValue['sale_price'] - $rowValue['sale_price'] / 1.18;
                    $taxable = $rowValue['sale_price'] / 1.18;
                    $exempt = 0.00;
                    $margin = $rowValue['sale_price'] - ($grnreport->unit_price + $grnreport->unit_price_tax);
                    $margin_perc = ($margin / $rowValue['sale_price']) * 100;
                } else {
                    $bill_type = $grnreport->invoice_type;
                    if (strtolower($grnreport->invoice_type) == 'exempt') {

                        $margin = $rowValue['sale_price'] - ($grnreport->unit_price + $grnreport->unit_price_tax);
                        $exempt = $grnreport->unit_price + $grnreport->unit_price_tax;
                        $taxable = $margin / 1.18;
                        $tax = $margin - $taxable;

                        if ($margin < 0) $margin = 0;

                        if ($exempt > $rowValue['sale_price']) {
                            $exempt = $rowValue['sale_price'];
                            $tax = 0;
                            $taxable = 0;
                        }
                        $margin_perc = ($margin / $rowValue['sale_price']) * 100;
                    } else {
                        $tax = $rowValue['sale_price'] - $rowValue['sale_price'] / 1.18;
                        $taxable = $rowValue['sale_price'] / 1.18;
                        $exempt = 0.00;
                        $margin = $rowValue['sale_price'] - ($grnreport->unit_price + $grnreport->unit_price_tax);
                        $margin_perc = ($margin / $rowValue['sale_price']) * 100;
                    }
                }

                $total_amount += $rowValue['sale_price'];
                $total_tax += $tax;

                // if ($module_type == 2)  {
                //     /* No Tax for Exporting */
                //     $tax = 0;
                //     $taxable = 0;
                //     $exempt = $rowValue['sale_price'];
                //     $tax_type = 'NA';
                //     $bill_type = 'EXEMPT';
                // }

                $rows[] = array(
                    "grnreport_id" => $rowValue['grnreport_id'],
                    "deviceid" => $grnreport->nhdin,
                    "price" => $rowValue['sale_price'],
                    "tax_amount" => $tax,
                    "taxable_amount" => $taxable,
                    "exempt_amount" => $exempt,
                    "margin" => $margin,
                    "margin_perc" => $margin_perc,
                    "sales_terms" => $rowValue["sales_terms"],
                    "category" => $rowValue["category"],
                    "grade" => $rowValue["grade"],
                    "tax_type" => $tax_type,
                    "bill_type" => $bill_type,
                    "CREATION_DATE" => date("Y-m-d H:i:s")
                );
            }
        }

        if ($no_device == true) {
            $json['status'] = 3;
            echo json_encode($json);
            exit;
        }

        if ($invalid_status == true) {
            $json['status'] = 4;
            $json['tdid'] = $tdid;
            echo json_encode($json);
            exit;
        }

        if ($invoice_exists == true) {
            $json['status'] = 5;
            $json['tdid'] = $tdid;
            $json['inv_code'] = $inv_code;
            echo json_encode($json);
            exit;
        }

        if ($invalid_saletype == true) {
            $json['status'] = 6;
            $json['tdid'] = $tdid;
            echo json_encode($json);
            exit;
        }

        $salesman_id = $sales_order->salesman_code;
	$warehouse = $sales_order->warehouse;
	
	$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr($warehouse, 0, 1);

        if ($module_type == 1) {
            $series = "SL".$string.$current_year.$next_year;
            $res = $this->db->from('tbl_invoice AS inv')
                          ->like('inv.invoice_code',$series)
                          ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
                          ->get()->row_array();
            
            $next_number=$res['max']+1;
            if($res['max']==null) $next_number=1;
            $invoice_code=$series.'-'.$next_number;
            //$invoice_code = 'SLY-' . $sales_order->warehouse . '-' . $next_number;

        } else if ($module_type == 2) {
            $series = "SLE".$current_year.$next_year;
            $res = $this->db->from('tbl_invoice AS inv')
                          ->join('tbl_salesorder AS so', 'so.salesorder_id = inv.salesorder_id AND so.module_type = 2', 'INNER')
                          ->like('inv.invoice_code',$series)
                          ->select('max(CAST(SUBSTRING_INDEX(inv.invoice_code,"-",-1) as UNSIGNED)) as max')
                          ->get()->row_array();
	    
            $next_number = ($res['max']==null)? 1 : $res['max']+1;
            //$invoice_code = $next_number;
            $invoice_code = $series."-".$next_number;

            /* No Tax for Exporting */
            //$total_tax = 0;
            
        } else {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
	
        $invoice_header = array(
            "vendor_id" => $sales_order->vendor_id,
            "invoice_code" => $invoice_code,
            "salesorder_id" => $salesorder_id,
            "salesman_id" => $salesman_id,
            "sales_channel" => $sales_order->sales_channel,
            "warehouse" => $sales_order->warehouse,
            "status" => "INVOICED",
            "invoice_amount" => $total_amount,
            "tax_amount" => $total_tax,
            "payment_mode" => $sales_order->payment_mode,
            "CREATION_DATE" => date("Y-m-d H:i:s"),
            "CREATED_BY" => $this->session->userdata('user_id')
        );
        $this->db->trans_start();

        //Insert Invoice Header
        $this->db->insert('tbl_invoice', $invoice_header);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $invoice_id = $this->db->insert_id();

        foreach ($rows as $key => $rowValue) {

            $rows[$key]['invoice_id'] = $invoice_id;

            $sold_items[] = array(
                "grnreport_id" => $rowValue["grnreport_id"],
                "status" => "SOLD",
                "remark" => $invoice_code
            );
        }

        //Insert Invoice Items
        $this->db->insert_batch('tbl_invoice_item', $rows);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        //Change Device Status
        $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        //Change Sales Order Status
        $this->db->where("salesorder_id", $salesorder_id);
        $this->db->update('tbl_salesorder', array("status" => "INVOICED", "LAST_UPDATED_BY" => $this->session->userdata('user_id')));

        $reference_type = ($module_type == 2)? 'export_invoice' : 'invoice';

        if (!empty($param['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $invoice_id,
                'reference_type' => $reference_type,
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $param['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
        }

        $this->auditlog_model->insert_auditlog(
            $invoice_id,
            $reference_type,
            'INVOICED',
            $this->session->userdata('user_id')
        );

        $this->db->trans_complete();
        //$this->hostbooks_authenticator->createInvoice($invoice_id);
        $this->cliq_api->postSalesImage($salesorder_id);

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

// FOR ADD MANUAL HOSTBOOK INVOICES
    public function hostbooksAddInvoice($invoice_id = 20105)
    {
	//echo $invoice_id; exit;
	$this->hostbooks_authenticator->createHostBookInvoice($invoice_id);
    }

    public function hostbooksInvoice($invoice_id)
    {
	$this->hostbooks_authenticator->createInvoice($invoice_id);
    }

    public function addPackingBoxDetails()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $invoice_id = $data['invoice_id'];

        if (empty($invoice_id) || empty($data['invoice_data'])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        foreach ($data['invoice_data'] as $rowValue) {
            $grnreport_id = $this->db->select('grnreport_id')->where('nhdin', $rowValue['device_id'])->get('tbl_grnreport')->row()->grnreport_id;
            if (empty($grnreport_id)) {
                $error = true;
                $nhdin = $rowValue['device_id'];
                break;
            }

            $invoice_item_id = $this->db->select('invoice_item_id')->where('invoice_id', $invoice_id)->where('grnreport_id', $grnreport_id)->get('tbl_invoice_item')->row()->invoice_item_id;
            //print $this->db->last_query();
            if (empty($invoice_item_id)) {
                $error = true;
                $nhdin = $rowValue['device_id'];
                break;
            }

            $records[] = array(
                "grnreport_id" => $grnreport_id,
                "box_number" => str_replace("\r", "", $rowValue['box_no'])
            );
        }

        if ($error == true) {
            $json['status'] = 0;
            $json['msg'] = $nhdin . ' is not valid TDID or not in the selected invoice';
            echo json_encode($json);
            exit;
        }

        $this->db->where('invoice_id', $invoice_id)->update_batch('tbl_invoice_item', $records, 'grnreport_id');
        //print $this->db->last_query();
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function bulk_addPackingBoxDetails() {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $records = [];

        foreach($data['packing_details'] as $packing_details) {
            $deviceid = $packing_details['deviceid'];

            $grnreport_id = $this->db->select('grnreport_id')->where('nhdin', $deviceid)->get('tbl_grnreport')->row()->grnreport_id;
            if (empty($grnreport_id)) {
                $msg = 'Invalid Device ID';
                GOTO ERROR;
            }

            $invoice_item_row = $this->db->from('tbl_invoice_item AS ini')
                        ->join('tbl_invoice AS inv', 'inv.invoice_id = ini.invoice_id')
                        ->where('inv.invoice_code', $packing_details['invoice_code'])
                        ->where('ini.grnreport_id', $grnreport_id)
                        ->select('ini.invoice_item_id, ini.invoice_id, inv.status')
                        ->get()->row();

            // $invoice_id = $invoice_item_row->invoice_id;
            $invoice_item_id = $invoice_item_row->invoice_item_id;

            if (empty($invoice_item_row)) {
                $msg = 'Mismatch Error at Device '. $deviceid .' and Invoice Code '. $packing_details['invoice_code'];
                GOTO ERROR;
            }
            if ($invoice_item_row->status != 'INVOICED') {
                $msg = $packing_details['invoice_code'] . ' is not in "INVOICED" stage';
                GOTO ERROR;
            }

            $records[] = array(
                'invoice_item_id' => $invoice_item_id,
                "box_number" => str_replace("\r", "", $packing_details['box_number']),
            );
        }

        $upd_status = $this->db->update_batch('tbl_invoice_item', $records, 'invoice_item_id');
        if ($this->db->error()['code'] != 0) { GOTO ERROR; }

        echo json_encode([
            'status' => true,
            'message' => 'Bulk Packing Details for '. count($records) .' devices saved successfully'
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Unable to perform your request'
        ]);
        exit;
    }

    public function getInvoiceNoDropdown()
    {
        $status = $this->input->get('status');

        $status_arr = explode(",", $status);
        $records = [];
        $result = $this->db->select('invoice_id, invoice_code')->where_in('status', $status_arr)->get('tbl_invoice')->result_array();

        foreach ($result as $rowValue) {
            $records[] = array(
                "invoice_id" => $rowValue['invoice_id'],
                "invoice_no" => $rowValue['invoice_code']
            );
        }

        $json['status'] = 1;
        $json['result'] = $records;

        echo json_encode($json);
        exit;
    }

    public function open_box_detailspdf($invoice = null, $pdf = '')
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();
        $box_result = $this->db->select('box_number')->where('invoice_id', $invoice_id)->group_by('box_number')->get('tbl_invoice_item')->result_array();

        //$result = $this->invoice_model->getInvoiceRows_pdf($invoice_id);
        $box_rows = [];
        if (!empty($box_result)) {
            foreach ($box_result as $rowValue) {
                $invoice_rows = [];
                $rows = $this->db->where('invoice_id', $invoice_id)->where('box_number', $rowValue['box_number'])->get('INVOICE_PDF_ROWS_VIEW')->result_array();
                foreach ($rows as $value) {
                    $invoice_rows[] = array(
                        'product_name' => $value["device_name"],
                        'deviceid' => $value["nhdin"],
                        'nhmod' => $value["nhmod"],
                        'price' => $value["price"],
                        'imei' => $value["imei"],
                        'ram' => $value["ram"],
                        'rom' => $value["rom"],
                        'sku' => $value["SKU"],
                        'category' => $value["category"],
                        'box_number' => $value["box_number"],
                        'sales_terms' => $value['sales_terms'],
                        'bill_type' => $value['bill_type'],

                    );
                }
                $box_rows[$rowValue['box_number']] = $invoice_rows;
            }
        }

        if (!empty($invoice_header)) {


            if (!empty($invoice_header[0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($invoice_header[0]["gst_no"], 0, 2))->get('tbl_states')->row();

            $data["gst_no"] = $invoice_header[0]["gst_no"];
            $data["company"] = $invoice_header[0]["company"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['place_supply'] = $supply_place->name;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];

            $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];

            $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];

            $data['box_rows'] = $box_rows;
        }

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_box_details', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    public function posteinvoice($invoice_id)
    {
        if ($invoice_id <= 0) {
            $json['status'] = 0;
            $json['msg'] = 'Invalid Invoice';
            echo json_encode($json);
            exit;
        }

        $invoice_header = $this->db->select('irn, status, gst_no')->where('invoice_id', $invoice_id)
            ->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id')
            ->get('tbl_invoice')->row();
        if (!empty($invoice_header->irn)) {
            $json['status'] = 0;
            $json['msg'] = 'E-Invoice already Created';
            echo json_encode($json);
            exit;
        }

        if (empty($invoice_header->gst_no)) {
            $json['status'] = 0;
            $json['msg'] = 'Customer Don\'t have a GST Number';
            echo json_encode($json);
            exit;
        }

        if ($invoice_header->status == 'VOID') {
            $json['status'] = 0;
            $json['msg'] = 'Invoice status is VOID';
            echo json_encode($json);
            exit;
        }

        $result = $this->einvoice->postEinvoice($invoice_id);

        echo json_encode($result);
        exit;

        // if ($result == true) {
        //     $json['status'] = 1;
        //     $json['msg'] = 'E-Invoice Created Successfully';
        //     echo json_encode($json);
        //     exit;
        // } else {
        //     $json['status'] = 0;
        //     $json['msg'] = 'E-Invoice Creation Failed';
        //     echo json_encode($json);
        //     exit;
        // }
    }

    public function manage_einvoice($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'E-Invoice';
        $data['subview'] = $this->load->view(
            'admin/einvoice/manage_einvoice',
            $data,
            true
        );
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getEInvoiceList()
    {
        $status = $this->input->get('status');

        if (empty($status)) {
            $json['status'] = 0;
            $json['msg'] = 'Invalid Status';
            echo json_encode($json);
            exit;
        }

        if ($status == 'NEW') {
            $this->db->where('irn_status is NULL');
        } else {
            $this->db->where('irn_status', $status);
        }

        $invoice_list = $this->db->select('invoice_id, invoice_code, sales_channel, irn, status, gst_no, irn_status, company, CREATION_DATE')
            ->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id')
            ->where('gst_no !=', '')
            ->where('DATE(CREATION_DATE)>=', "2022-04-01")
            ->get('tbl_invoice')->result_array();
        $result = [];

        foreach ($invoice_list as $key => $value) {

            if (empty($value['irn_status'])) {
                $irn_status = 'NEW';
            } else {
                $irn_status = $value['irn_status'];
            }
            $result[] = array(
                'invoice_id' => $value['invoice_id'],
                'sales_channel' => $value['sales_channel'],
                'irn_no' => $value['irn'],
                'invoice_status' => $value['status'],
                'irn_status' => $irn_status,
                'gst_no' => $value['gst_no'],
                'invoice_no' => $value['invoice_code'],
                'vendor_name' => $value['company'],
                'invoice_date' => date('d-m-Y', strtotime($value['CREATION_DATE']))
            );
        }

        $json['status'] = 1;
        $json['data'] = $result;
        echo json_encode($json);
        exit;
    }

    public function postcancel_einvoice($invoice_id)
    {
        if ($invoice_id <= 0) {
            $json['status'] = 0;
            $json['msg'] = 'Invalid Invoice';
            echo json_encode($json);
            exit;
        }

        $invoice_header = $this->db->select('irn, status, gst_no')->where('invoice_id', $invoice_id)
            ->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id')
            ->get('tbl_invoice')->row();
        if ($invoice_header->irn_status == 'CNL') {
            $json['status'] = 0;
            $json['msg'] = 'E-Invoice already Cancelled';
            echo json_encode($json);
            exit;
        }

        if (empty($invoice_header->gst_no)) {
            $json['status'] = 0;
            $json['msg'] = 'Customer Don\'t have a GST Number';
            echo json_encode($json);
            exit;
        }

        if ($invoice_header->status != 'VOID') {
            $json['status'] = 0;
            $json['msg'] = 'Invoice status is not Void';
            echo json_encode($json);
            exit;
        }

        $result = $this->einvoice->postCancelIRN($invoice_id);
        if ($result == true) {
            $json['status'] = 1;
            $json['msg'] = 'E-Invoice Cancelled Successfully';
            echo json_encode($json);
            exit;
        } else {
            $json['status'] = 0;
            $json['msg'] = 'E-Invoice Cancellation Failed';
            echo json_encode($json);
            exit;
        }
    }

    public function getIRNDetails($invoice_id)
    {
        if ($invoice_id <= 0) {
            $json['status'] = 0;
            $json['msg'] = 'Invalid Invoice';
            echo json_encode($json);
            exit;
        }

        $invoice_header = $this->db->select('irn, status, gst_no')->where('invoice_id', $invoice_id)
            ->join('tbl_vendor', 'tbl_vendor.vendor_id = tbl_invoice.vendor_id')
            ->get('tbl_invoice')->row();
        if (empty($invoice_header->irn)) {
            $json['status'] = 0;
            $json['msg'] = 'E-Invoice not Created';
            echo json_encode($json);
            exit;
        }

        if (empty($invoice_header->gst_no)) {
            $json['status'] = 0;
            $json['msg'] = 'Customer Don\'t have a GST Number';
            echo json_encode($json);
            exit;
        }

        $result = $this->einvoice->getIRNDetails($invoice_id);
        if ($result == true) {
            $json['status'] = 1;
            $json['data'] = $result;
            echo json_encode($json);
            exit;
        } else {
            $json['status'] = 0;
            $json['msg'] = 'E-Invoice Details Not Found';
            echo json_encode($json);
            exit;
        }
    }

    public function getEinvoiceLog($invoice_id)
    {

        $this->db->where('invoice_id', $invoice_id)
            ->join('tbl_users', 'tbl_users.user_id = tbl_einv_log.user_id')
            ->order_by('einv_log_id', 'DESC');
        $result  = $this->db->get('tbl_einv_log')->result_array();

        $data = [];
        foreach ($result as $key => $value) {
            $response = json_decode($value['response'], true);
            $data[] = array(
                "api" => $value['api'],
                "response" => $response['txnOutcome'],
                "updated_date" => date('d-m-Y H:i:s', strtotime($value['updated_date'])),
                "updated_by" => $value['username']
            );
        }

        $json = array(
            "data" => $data,
            "status" => 1
        );
        echo json_encode($json);
        exit;
    }

    public function open_invoicepdf_sku($invoice = null, $pdf = '')
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();

        $rows = $this->db->where('invoice_id', $invoice_id)->get('INVOICE_PDF_ROWS_VIEW')->result_array();

        //$result = $this->invoice_model->getInvoiceRows_pdf($invoice_id);

        $this->db->where('tbl_invoice_item.invoice_id', $invoice_id);
        $this->db->select('sum(tbl_invoice_item.price) as price, sum(tbl_invoice_item.taxable_amount) as taxable_amount, sum(tbl_invoice_item.exempt_amount) as exempt_amount, sum(tbl_invoice_item.tax_amount) as tax_amount, tbl_grnreport.device_name, tbl_grnreport.ram, tbl_grnreport.rom, tbl_grnreport.product_type, count(tbl_grnreport.grnreport_id) as count,tbl_grnreport.color');
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_invoice_item.grnreport_id', 'Left');
        $modelwise = $this->db->group_by('tbl_grnreport.nhmod, tbl_grnreport.ram, tbl_grnreport.rom, tbl_grnreport.color')->order_by('device_name')->get("tbl_invoice_item")->result_array();

        if (!empty($rows)) {
            $total_tax = 0;
            foreach ($rows as $value) {
                $invoice_rows[] = array(
                    'product_name' => $value["device_name"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'imei' => $value["imei"],
                    'ram' => $value["ram"],
                    'grade' => $value["certification_grade"],
                    'rom' => $value["rom"],
                    'sku' => $value["SKU"],
                    'category' => $value["category"],
                    'color_code' => $value["color_code"],
                    'tax_amount' => $value["tax_amount"],
                    'price' => $value["price"],
                    'tax_type' => $value["tax_type"],
                    'unit_price' => $value['unit_price'],
                    'unit_price_tax' => $value['unit_price_tax'],
                    'sales_terms' => $value['sales_terms'],
                    'bill_type' => $value['bill_type'],

                );
            }
            $data['rows'] = $invoice_rows;
        }
	
        foreach ($modelwise as $models) {
            $variant_count[] = array(
                "product_name" => $models['device_name'],
                "ram" => $models['ram'],
                "rom" => $models['rom'],
                "color" => $models['color'],
                "quantity" => $models['count'],
                "price" => $models['price'],
                "taxable_amount" => $models['taxable_amount'],
                "exempt_amount" => $models['exempt_amount'],
                "tax_amount" => $models['tax_amount'],
            );
        }
	$product_type = $modelwise[0]['product_type'];
        $hsn_code = $this->db->get_where('tbl_device_type',array("name"=>$product_type))->row()->hsn_code;
        $data['variant_count'] = $variant_count;

        if (!empty($invoice_header)) {


            if (!empty($invoice_header[0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($invoice_header[0]["gst_no"], 0, 2))->get('tbl_states')->row();

            $discount = $invoice_header[0]['discount_amount'] / 1.18;
            $discount_tax =  $invoice_header[0]['discount_amount'] - $discount;

            $freight = $invoice_header[0]['freight_amount'] / 1.18;
            $freight_tax =  $invoice_header[0]['freight_amount'] - $freight;

            $insurance = $invoice_header[0]['insurance_amount'] / 1.18;
            $insurance_tax =  $invoice_header[0]['insurance_amount'] - $insurance;

            $tcs = $invoice_header[0]['tcs_amount'] / 1.18;
            $tcs_tax =  $invoice_header[0]['tcs_amount'] - $tcs;

            $total_amount = $invoice_header[0]["amount"] - $invoice_header[0]['discount_amount'] + $invoice_header[0]['freight_amount'] + $invoice_header[0]['insurance_amount'] + $invoice_header[0]['tcs_amount'];

            $total_amount = round($total_amount, 0);
            $amount_words = $this->getIndianCurrency($total_amount);
            $get_type = strtolower($this->input->get('type'));
            if ($get_type == 'original') {
                $type = 'Original for recipient';
            }
            if ($get_type == 'duplicate') {
                $type = 'Duplicate for transporter';
            }
            if ($get_type == 'triplicate') {
                $type = 'Triplicate for supplier';
            }

            $data["gst_no"] = $invoice_header[0]["gst_no"];
            $data["company"] = $invoice_header[0]["company"];
            $data["vendor_code"] = $invoice_header[0]["vendor_code"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['device_sub_category'] = $invoice_header[0]["device_sub_category"];
            $data['place_supply'] = $supply_place->name;
	    $data["hsn_code"] = $hsn_code;
	    $data["product_type"] = $product_type;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
            $data["amount"] = $invoice_header[0]["amount"];
            $data["total_amount"] = $total_amount;
            $data["tax"] = $invoice_header[0]["tax"];

            $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];
            $data['amount_words'] = $amount_words;

            $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];
            $data['type'] = $type;
            $data['no_grade'] = $this->input->get('no_grade');


            $data['discount_total'] = $invoice_header[0]['discount_amount'];
            $data['discount_amount'] = $discount;
            $data['discount_tax'] = $discount_tax;

            $data['freight_total'] = $invoice_header[0]['freight_amount'];
            $data['freight_amount'] = $freight;
            $data['freight_tax'] = $freight_tax;

            $data['insurance_total'] = $invoice_header[0]['insurance_amount'];
            $data['insurance_amount'] = $insurance;
            $data['insurance_tax'] = $insurance_tax;

            $data['tcs_total'] = round($invoice_header[0]['tcs_amount'], 0);
            $data['tcs_percent'] = $invoice_header[0]['tcs_percent'];

            $gross_tax = $invoice_header[0]["tax"] - $discount_tax + $freight_tax + $insurance_tax;
            $data['gross_tax'] = $gross_tax;
            $data['irn'] = $invoice_header[0]["irn"];
            $data['qr_code'] = $invoice_header[0]["qr_code"];
        }
        $path = '';
        if (!empty($data['qr_code'])) {
            $path = "./uploads/qr_code/" . $invoice_id . ".png";
            $this->infiqr->generate($invoice_header[0]['qr_code'], 'png', $path);
        }

        $data['filename'] = $path;

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_invoice_sku', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    function checkDeviceForBulkInvoice()
    {
        $data = json_decode(file_get_contents('php://input'), true);

        if (empty($data)) {
            $json = array(
                'status' => 0,
                'message' => 'Invalid Request'
            );
            echo json_encode($json);
            exit;
        }

        $order_no = $data['order_no'];
        if (empty($order_no)) {
            $json = array(
                'status' => 0,
                'message' => 'Invalid Order No'
            );
            echo json_encode($json);
            exit;
        }

        $device_id_or_imei = $data['tdid_imei_wsn_no'];
        if (empty($device_id_or_imei)) {
            $json = array(
                'status' => 0,
                'message' => 'Invalid Device Id Or Imei'
            );
            echo json_encode($json);
            exit;
        }

        $where_so = array(
            "saleschannel_ref_id" => $order_no,
            "status not in ('CANCELED','CANCELLED')"
        );

        $salesorder_dets = $this->db->select('salesorder_id, status, sales_channel')
            ->where($where_so)->get('tbl_salesorder')->row();

        if (empty($salesorder_dets)) {
            $json = array(
                'status' => 0,
                'message' => 'Invalid Order No'
            );
            echo json_encode($json);
            exit;
        }

        if ($salesorder_dets->status != 'FINANCE_APPROVED') {
            $json = array(
                'status' => 0,
                'message' => 'Order is Not Approved'
            );
            echo json_encode($json);
            exit;
        }

        if ($salesorder_dets->sales_channel == 'OFFLINE') {
            $json = array(
                'status' => 0,
                'message' => 'Bulk Invoice Not Allowed For Offline Order'
            );
            echo json_encode($json);
            exit;
        }

        //$device_dets = $this->db->where("'".$device_id_or_imei."'".' in (nhdin , othervendor_id, imei1_no ,imei2_no)')->get('tbl_grnreport')->row();

        if(strlen($device_id_or_imei) == 15){
            $device_dets = $this->db->where("imei1_no", $device_id_or_imei)->get('tbl_grnreport')->row();
            
            if(empty($device_dets)){
                $device_dets = $this->db->where("imei2_no", $device_id_or_imei)->get('tbl_grnreport')->row();
            }

        }else if(strlen($device_id_or_imei) == 13){
            $device_dets = $this->db->where("nhdin", $device_id_or_imei)->get('tbl_grnreport')->row();

        }else{
            $device_dets = $this->db->where("othervendor_id", $device_id_or_imei)->get('tbl_grnreport')->row();
        }

        if(empty($device_dets)){
            $json = array(
                'status' => 0,
                'message' => 'Invalid Device Id Or Imei'
            );
            echo json_encode($json);
            exit;
        }

        if (empty($device_dets)) {
            $json = array(
                'status' => 0,
                'message' => 'Invalid Device Id Or Imei Or WSN No'
            );
            echo json_encode($json);
            exit;
        }

        if ($device_dets->status != 'RFS') {
            $json = array(
                'status' => 0,
                'message' => 'Device is Not in RFS'
            );
            echo json_encode($json);
            exit;
        }

        $so_items = $this->db->select('grnreport_id')
                        ->where('salesorder_id', $salesorder_dets->salesorder_id)
                        ->get('tbl_salesorder_item')->row();
        
        if (empty($so_items)) {
            $json = array(
                'status' => 0,
                'message' => 'This device is not in this order'
            );
            echo json_encode($json);
            exit;
        }

        $existing_so = $this->db->select('tbl_salesorder.salesorder_id, tbl_salesorder.status, tbl_salesorder.salesorder_code')
                            ->join('tbl_salesorder_item', 'tbl_salesorder_item.salesorder_id = tbl_salesorder.salesorder_id', 'left')
                            ->where('grnreport_id', $device_dets->grnreport_id)
                            ->where('tbl_salesorder.salesorder_id !=', $salesorder_dets->salesorder_id)
                            ->where_in('status', array('FINANCE_APPROVED', 'FINANCE_REJECTED', 'FINANCE_PENDING', 'WH_REJECTED', 'DRAFT'))
                            ->get('tbl_salesorder')->row();

            if (!empty($existing_so)) {
            $json = array(
                'status' => 0,
                'message' => 'This device is already in the order ' . $existing_so->salesorder_code
            );
            echo json_encode($json);
            exit;
        }

        $result = array(
            'device_id' =>  $device_dets->grnreport_id,
            'salesorder_id' => $salesorder_dets->salesorder_id,
        );
        $json = array(
            'status' => 1,
            'data' => $result
        );
        echo json_encode($json);
        exit;
    }

    function submitBulkInvoice()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        $order_ids = array_keys($data);
        $order_data = [];
        $vendor_ids = [];
        $device_ids = [];
        $device_details = [];
        $tax_type_arr = [];
        $item_details = [];

        $invoice_check = $this->db->where_in('salesorder_id', $order_ids)->get('tbl_invoice')->result_array();

        if (!empty($invoice_check)) {
            $json['status'] = 0;
            $json['message'] = 'Invoice already generated for some orders';
            echo json_encode($json);
            exit;
        }

        foreach ($data as $key => $value) {
            foreach ($value as $k => $v) {
                $device_ids[] = $v;
            }
        }

        $this->db->select('tbl_invoice.status, tbl_invoice.invoice_code')->where_in('tbl_invoice_item.grnreport_id', $device_ids);
        $invoice = $this->db->join('tbl_invoice', 'tbl_invoice_item.invoice_id = tbl_invoice.invoice_id', 'Left')->get('tbl_invoice_item')->result_array();
        $inv_status = ['INVOICED', 'PACKED', 'SHIPPED'];

        $used_devices = [];
        if (!empty($invoice)) {
            foreach ($invoice as $key => $value) {
                if (in_array($value['status'], $inv_status)) {
                    $used_devices[$value['grnreport_id']] = $value['invoice_code'];
                }
            }
        }

        $order_details = $this->db->select('salesorder_id, sales_channel, saleschannel_ref_id, status, vendor_id, warehouse, payment_mode, salesman_code')
                                ->where_in("salesorder_id", $order_ids)->get('tbl_salesorder')->result_array();

        foreach ($order_details as $key => $rowValue) {
            if ($rowValue['status'] != 'FINANCE_APPROVED') {
                $json['status'] = 0;
                $json['message'] = 'Sales Order is Not Approved for Order No ' . $rowValue['saleschannel_ref_id'];
                echo json_encode($json);
                exit;
            }

            if ($rowValue['sales_channel'] == 'OFFLINE' || $rowValue['sales_channel'] == 'DEALERAPP') {
                $json['status'] = 0;
                $json['message'] = 'Invalid Sales Channel for Order No ' . $rowValue['saleschannel_ref_id'];
                echo json_encode($json);
                exit;
            }

            $order_data[$rowValue['salesorder_id']] = array(
                'salesorder_id' => $rowValue['salesorder_id'],
                'salesman_code' => $rowValue['salesman_code'],
                'sales_channel' => $rowValue['sales_channel'],
                'saleschannel_ref_id' => $rowValue['saleschannel_ref_id'],
                'status' => $rowValue['status'],
                'vendor_id' => $rowValue['vendor_id'],
                'warehouse' => $rowValue['warehouse'],
                'payment_mode' => $rowValue['payment_mode']
            );
            $vendor_ids[] = $rowValue['vendor_id'];
        }

        $deviceResult = $this->db->select('grnreport_id, status, unit_price, unit_price_tax, stock_type, saletype, nhdin, invoice_type, bundle_id')->where_in('grnreport_id', $device_ids)->get('tbl_grnreport')->result_array();

        foreach ($deviceResult as $key => $rowValue) {

            if ($rowValue['status'] != 'RFS') {
                $json['status'] = 0;
                $json['message'] =  $rowValue['nhdin'] . ' is not a RFS Device';
                echo json_encode($json);
                exit;
            }

            if ($rowValue['saletype'] != 'ONLINE') {
                $json['status'] = 0;
                $json['message'] =  $rowValue['nhdin'] . ' is not an ONLINE Device';
                echo json_encode($json);
                exit;
            }

            if ($rowValue['bundle_id'] > 0) {
                $json['status'] = 0;
                $json['message'] =  $rowValue['nhdin'] . ' is a bundled Device';
                echo json_encode($json);
                exit;
            }

            if ($used_devices[$rowValue['grnreport_id']]) {
                $json['status'] = 0;
                $json['message'] =  $rowValue['nhdin'] . ' is already Invoiced in ' . $used_devices[$rowValue['grnreport_id']];
                echo json_encode($json);
                exit;
            }

            $device_details[$rowValue['grnreport_id']] = array(
                'status' => $rowValue['status'],
                'unit_price' => $rowValue['unit_price'],
                'unit_price_tax' => $rowValue['unit_price_tax'],
                'stock_type' => $rowValue['stock_type'],
                'saletype' => $rowValue['saletype'],
                'nhdin' => $rowValue['nhdin'],
                'invoice_type' => $rowValue['invoice_type'],
                'bundle_id' => $rowValue['bundle_id']
            );
        }

        $vendorResult = $this->db->select('vendor_id, state_gst_id')->where_in('vendor_id', $vendor_ids)->join('tbl_states', 'tbl_states.state_id = tbl_vendor.state')->get('tbl_vendor')->result_array();

        foreach ($vendorResult as $rowValue) {
            if ($rowValue['state_gst_id'] == 36) {
                $tax_type = 'CGST18';
            } else {
                $tax_type = 'IGST18';
            }
            $tax_type_arr[$rowValue['vendor_id']] = $tax_type;
        }

        $itemResult = $this->db->where_in('salesorder_id', $order_ids)->get('tbl_salesorder_item')->result_array();

        foreach ($itemResult as $rowValue) {
            $item_details[$rowValue['salesorder_id']][] = $rowValue;
        }

        //Start the Transaction
        $this->db->trans_start();

        foreach ($order_data as $key => $value) {
            $string = substr($value['warehouse'], 0, 1);
            $series = "SL".$string.$current_year.$next_year;
            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(invoice_code,"-",-1) as UNSIGNED)) as max')->from('tbl_invoice')
            ->like('invoice_code',$series)
            ->get()->row_array();
            $next_number = $res['max'] + 1;
    
            if ($res['max'] == null) {
                $next_number = 1;
            }
            
            //$invoice_code = 'SLY-' . $value['warehouse'] . '-' . $next_number;
            $invoice_code =  $series. '-' . $next_number;
            //$next_number++;
            $rows = [];
            $total_amount = 0;
            $total_tax = 0;

            foreach ($item_details[$value['salesorder_id']] as $k => $v) {
                
                if(!in_array($v['grnreport_id'], $device_ids)){
                    $json['status'] = 0;
                    $json['message'] =  'Not All Devices are scanned for Order No ' . $value['saleschannel_ref_id'];
                    echo json_encode($json);
                    exit;
                }

                $unit_price = $device_details[$v['grnreport_id']]['unit_price'];
                $unit_price_tax = $device_details[$v['grnreport_id']]['unit_price_tax'];

                if (in_array($value['sales_channel'], MARGINAL_NOT_ALLOWED_CHANNELS)) {
                    $bill_type = 'TAXABLE';
                    $tax = $v['sale_price'] - $v['sale_price'] / 1.18;
                    $taxable = $v['sale_price'] / 1.18;
                    $exempt = 0.00;
                    $margin = $v['sale_price'] - ($unit_price + $unit_price_tax);
                    $margin_perc = ($margin / $v['sale_price']) * 100;
                } else {
                    $bill_type = $device_details[$v['grnreport_id']]['invoice_type'];

                    if (strtolower($bill_type) == 'exempt') {
                        $margin = $v['sale_price'] - ($unit_price + $unit_price_tax);
                        $exempt = $unit_price + $unit_price_tax;
                        $taxable = $margin / 1.18;
                        $tax = $margin - $taxable;

                        if ($margin < 0) $margin = 0;

                        if ($exempt > $v['sale_price']) {
                            $exempt = $v['sale_price'];
                            $tax = 0;
                            $taxable = 0;
                        }
                        $margin_perc = ($margin / $v['sale_price']) * 100;
                    } else {

                        $tax = $v['sale_price'] - $v['sale_price'] / 1.18;
                        $taxable = $v['sale_price'] / 1.18;
                        $exempt = 0.00;
                        $margin = $v['sale_price'] - ($unit_price + $unit_price_tax);
                        $margin_perc = ($margin / $v['sale_price']) * 100;
                    }
                }

                $total_amount += $v['sale_price'];
                $total_tax += $tax;
                $nhdin = $device_details[$v['grnreport_id']]['nhdin'];
                $rows[] = array(
                    "grnreport_id" => $v['grnreport_id'],
                    "deviceid" => $nhdin,
                    "price" => $v['sale_price'],
                    "tax_amount" => $tax,
                    "taxable_amount" => $taxable,
                    "exempt_amount" => $exempt,
                    "margin" => $margin,
                    "margin_perc" => $margin_perc,
                    "sales_terms" => $v["sales_terms"],
                    "category" => $v["category"],
                    "grade" => $rowValue["grade"],
                    "tax_type" => $tax_type,
                    "bill_type" => $bill_type,
                    "CREATION_DATE" => date("Y-m-d H:i:s")
                );
            }

            $invoice_header = array(
                "vendor_id" => $value['vendor_id'],
                "invoice_code" => $invoice_code,
                "salesorder_id" => $value['salesorder_id'],
                "salesman_id" => $value['salesman_code'],
                "sales_channel" => $value['sales_channel'],
                "warehouse" => $value['warehouse'],
                "status" => "INVOICED",
                "invoice_amount" => $total_amount,
                "tax_amount" => $total_tax,
                "payment_mode" => $value['payment_mode'],
                "CREATION_DATE" => date("Y-m-d H:i:s"),
                "CREATED_BY" => $this->session->userdata('user_id')
            );

            //Insert Invoice Header
            $this->db->insert('tbl_invoice', $invoice_header);
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $json['message'] = 'Failed to Create Invoice';
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }

            $invoice_id = $this->db->insert_id();

            foreach ($rows as $key => $rowValue) {

                $rows[$key]['invoice_id'] = $invoice_id;

                $sold_items[] = array(
                    "grnreport_id" => $rowValue["grnreport_id"],
                    "status" => "SOLD",
                    "remark" => $invoice_code,
                    "user_id" => $this->session->userdata('user_id'),
                );
            }

            //Insert Invoice Items
            $this->db->insert_batch('tbl_invoice_item', $rows);
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                $json['message'] = 'Failed to Add Invoice Items';
                echo json_encode($json);
                exit;
            }

            //Change Device Status
            $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                $json['message'] = 'Failed to Change Device Status';
                echo json_encode($json);
                exit;
            }

            //Change Sales Order Status
            $this->db->where("salesorder_id", $value['salesorder_id']);
            $this->db->update('tbl_salesorder', array("status" => "INVOICED", "LAST_UPDATED_BY" => $this->session->userdata('user_id')));
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                $json['message'] = 'Failed to Change Sales Order Status';
                echo json_encode($json);
                exit;
            }
            $insert_log_array[]= array(
                "reference_id"=> $invoice_id,
                "user_id"=> $this->session->userdata('user_id'),
                "reference_type"=> 'invoice',
                "status"=>' INVOICED',
                "date"=> date("Y-m-d H:i:s")
            );
        }

        $this->db->trans_complete();

        $this->db->insert_batch('tbl_audit_log', $insert_log_array);
        
        $json['status'] = 1;
        $json['message'] = 'Invoice Created Successfully';
        echo json_encode($json);
        exit;
    }

    
    public function open_exportinvoice_pdf($invoice = null, $pdf = '', $is_html = false)
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();

        $rows = $this->db->from('INVOICE_PDF_ROWS_VIEW AS rows')
                        ->join('tbl_device_type AS dt', 'dt.name = rows.product_type')
                        ->where('invoice_id', $invoice_id)
                        // ->group_by('SKU, price')
                        ->group_by('nhmod, ram, rom, device_actv_status, price')
                        ->select('rows.*, COUNT(rows.invoice_id) AS quantity, SUM(rows.price) AS t_amount, dt.hsn_code')
                        ->get()->result_array();

        $rows_hsnWise = $this->db->from('INVOICE_PDF_ROWS_VIEW AS rows')
                        ->join('tbl_device_type AS dt', 'dt.name = rows.product_type')
                        ->where('invoice_id', $invoice_id)
                        ->group_by('dt.hsn_code')
                        ->select('rows.*, COUNT(rows.invoice_id) AS quantity, SUM(rows.price) AS t_amount, dt.hsn_code')
                        ->get()->result_array();

        if (!empty($invoice_header)) {

            $data["company"] = $invoice_header[0]["company"];
            $data["vendor_code"] = $invoice_header[0]["vendor_code"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state_nameorid"];
            $data["country"] = $invoice_header[0]["country"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["mobile"] = $invoice_header[0]["mobile"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['device_sub_category'] = $invoice_header[0]["device_sub_category"];
            $data['terms_of_delivery'] = $invoice_header[0]["terms_of_delivery"];
            $data['product_type'] = $product_type;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
            $data["invoice_cdate"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["salesorder_cdate"] = date("d-m-Y", strtotime($invoice_header[0]["salesorder_cdate"]));

            $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];

            $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];
            $data['no_grade'] = $this->input->get('no_grade');
            
            $data['irn'] = $invoice_header[0]["irn"];
            $data['qr_code'] = $invoice_header[0]["qr_code"];

            /** In INDIAN RUPEE */
            $data["gross_amount"] = $invoice_header[0]["amount"];
            $data['discount_total'] = $invoice_header[0]['discount_amount'];
            $data['freight_total'] = $invoice_header[0]['freight_amount'];
            $data['insurance_total'] = $invoice_header[0]['insurance_amount'];
            // $data['tcs_total'] = round($invoice_header[0]['tcs_amount'], 0);
            // $data['tcs_percent'] = $invoice_header[0]['tcs_percent'];

            
            $invoice_total_hsnWise = 0;
            $invoice_rows_hsnWise = [];
            foreach ($rows_hsnWise as $value) {
                $t_amount_hsnWise = $value["t_amount"];
                $t_amount_hsnWise = number_format((float) $t_amount_hsnWise, 2, '.', '');

                $invoice_total_hsnWise += $t_amount_hsnWise;

                $invoice_rows_hsnWise[] = array(
                    'hsn_code' => $value["hsn_code"],
                    'quantity' => $value['quantity'],
                    't_amount_hsnWise' => $t_amount_hsnWise,
                );
            }
            $data['rows_hsnWise'] = $invoice_rows_hsnWise;
            
            if (abs($invoice_header[0]["amount"] - $invoice_total_hsnWise) > 1) {
                // Should throw error
                echo "Error in Generating Invoice";die;
            }
            $data['gross_amount_hsnWise'] = number_format((float) $invoice_total_hsnWise, 2, '.', '');

            $total_amount = $invoice_total_hsnWise - $invoice_header[0]['discount_amount'] + $invoice_header[0]['freight_amount'] + $invoice_header[0]['insurance_amount'];
            $total_amount = round($total_amount, 0);
            $amount_words = $this->getIndianCurrency($total_amount);
            $data["total_amount"] = $total_amount;
            $data['amount_words'] = $amount_words;


            /** EXCHANGING THE INDIAN CURRENCY */
            $exchange_currency_type = '';
            if ($invoice_header[0]["export_currency_type"] == 'us_dollar') {
                $exchange_currency_type = '$';
            }
            $exchange_rate = $invoice_header[0]["currencyExchangeRate_inRupee"];
            $data['exchange_rate'] = $exchange_rate;
            $data['exchange_currency_type'] = $exchange_currency_type;

            $gross_amount_exch = $invoice_header[0]["amount"] / $exchange_rate;
            $discount_total_exch= $invoice_header[0]['discount_amount'] / $exchange_rate;
            $freight_total_exch = $invoice_header[0]['freight_amount'] / $exchange_rate;
            $insurance_total_exch = $invoice_header[0]['insurance_amount'] / $exchange_rate;
            // $tcs_total_exch = round($invoice_header[0]['tcs_amount'], 0) / $exchange_rate;

            $data['gross_amount_exch'] = number_format((float) $gross_amount_exch, 2, '.', '');
            $data['discount_total_exch'] = number_format((float) $discount_total_exch, 2, '.', '');
            $data['freight_total_exch'] = number_format((float) $freight_total_exch, 2, '.', '');
            $data['insurance_total_exch'] = number_format((float) $insurance_total_exch, 2, '.', '');
            // $data['tcs_total_exch'] = number_format((float) $tcs_total_exch, 2, '.', '');
            
            
        
            $invoice_total_exch = 0;
            $invoice_rows = [];
            foreach ($rows as $value) {
                $price_exch = $value["price"] / $exchange_rate;
                $t_amount_exch = $value["t_amount"] / $exchange_rate;
                // $t_amount_exch = $price_exch * $value['t_amount'];

                $price_exch = number_format((float) $price_exch, 2, '.', '');
                $t_amount_exch = number_format((float) $t_amount_exch, 2, '.', '');

                $invoice_total_exch += $t_amount_exch;

                $invoice_rows[] = array(
                    'hsn_code' => $value["hsn_code"],
                    'product_name' => $value["device_name"],
                    'device_actv_status' => $value["device_actv_status"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'ram' => $value["ram"],
                    'rom' => $value["rom"],
                    'color' => $value["color"],
                    'sku' => $value["SKU"],
                    'category' => $value["category"],
                    'price' => $value["price"],
                    'quantity' => $value['quantity'],
                    't_amount' => $value['t_amount'],
                    'price_exch' => $price_exch,
                    't_amount_exch' => $t_amount_exch,
                );
            }
            $data['rows'] = $invoice_rows;

            if (abs($gross_amount_exch - $invoice_total_exch) > 2) {
                // Should throw error
                echo "Error in Generating Invoice";die;
            }

            $data['gross_amount_exch'] = number_format((float) $invoice_total_exch, 2, '.', '');

            $total_amount_exch = $data['gross_amount_exch'] - $data['discount_total_exch'] + $data['freight_total_exch'] + $data['insurance_total_exch'];
            $total_amount_exch = round($total_amount_exch, 0);
            $amount_words_exch = $this->getCurrencyInWords($total_amount_exch, 'Dollars');
            $data["total_amount_exch"] = $total_amount_exch;
            $data['amount_words_exch'] = $amount_words_exch;

            /** SHIPPING ADDRESS */
            $salesorderid = $invoice_header[0]["salesorder_id"];
            $shipping_from_data = $this->db->get_where('SHIPPING_FROM_AND_TO_LIST_VIEW',array("salesorder_id" => $salesorderid))->row();
            //echo $salesorderid; exit;
            if(count($shipping_from_data) < 1){
                $data['shipping_from_address'] = array(
                    "seller" => "SLOYD VENTURES (P) LTD",
                    "address" => "1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet",
                    "city" => "Hyderabad",
                    "state" => "Telangana",
                    "pincode" => "INDIA 500016"
                );
                $data['shipping_address'] = array(
                    "address" => $invoice_header[0]["address"],
                    "city" => $invoice_header[0]["city"],
                    "state" => $invoice_header[0]["state"],
                    "pincode" => $invoice_header[0]["pincode"]
                );
                
            } else{
                $shipping_to_vendor = $shipping_from_data->shipping_to_vendor;
                if((int)$shipping_to_vendor){
                    $company_name = $this->db->get_where('tbl_vendor', array("vendor_id" => $shipping_to_vendor))->row()->company;
                } else {
                    $company_name = $invoice_header[0]["company"];
                }
                $data['shipping_from_address'] = array(
                    "seller" => $shipping_from_data->from_seller,
                    "address" => $shipping_from_data->from_address,
                    "city" => $shipping_from_data->from_city,
                    "state" => $shipping_from_data->from_state,
                    "pincode" => $shipping_from_data->from_pincode
                );
                $data['shipping_address'] = array(
                    "company" => $company_name,
                    "address" => $shipping_from_data->to_address,
                    "city" => $shipping_from_data->to_city,
                    "state" => $shipping_from_data->to_state,
                    "country" => $shipping_from_data->to_country,
                    "pincode" => $shipping_from_data->to_pincode
                );
            }

        }

        $path = '';
        if (!empty($data['qr_code'])) {
            $path = "./uploads/qr_code/" . $invoice_id . ".png";
            $this->infiqr->generate($invoice_header[0]['qr_code'], 'png', $path);
        }

        $data['filename'] = $path;

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_invoice_export', $data, TRUE);
            if ($is_html) {
                echo $viewfile;die;
            }
            $header = '                                                                                                    ';
            $header .= 'Invoice Code: ' . $data["invoice_code"] . ' | ' . 'Invoice Creation Date: ' . $data['invoice_cdate'] ;
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    
    public function createInvoice_forNonProduct()
    {
        $invoicedets = json_decode(file_get_contents(("php://input")), TRUE);
        
        if (empty($invoicedets) || !(count($invoicedets['rows']) > 0) ) {
            echo json_encode([
                'status' => false,
                'message' => 'Invalid Input Data'
            ]);
            exit;
        }
        
        $result = $this->invoice_model->createInvoice_forNonProduct($invoicedets);

        if ($result['status']) {
            $Res = $this->hostbooks_authenticator->createInvoice_forNonProduct($result['invoice_id']);
        }

        $result['status'] = false;
        $result['HB_Response'] = $Res;
        echo json_encode($result);
        exit;

    }
        
    public function open_nonprod_invoice($invoice = null, $pdf = '') {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();

        $rows = $this->db->where('invoice_id', $invoice_id)->get('tbl_invoice_nonproduct_item')->result_array();
        
        $data['rows'] = $rows;

        // echo json_encode($invoice_header);exit;
        if (!empty($invoice_header)) {

            if (!empty($invoice_header[0]["gst_no"]))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($invoice_header[0]["gst_no"], 0, 2))->get('tbl_states')->row();

            // $discount = $invoice_header[0]['discount_amount'] / 1.18;
            // $discount_tax =  $invoice_header[0]['discount_amount'] - $discount;

            // $freight = $invoice_header[0]['freight_amount'] / 1.18;
            // $freight_tax =  $invoice_header[0]['freight_amount'] - $freight;

            // $insurance = $invoice_header[0]['insurance_amount'] / 1.18;
            // $insurance_tax =  $invoice_header[0]['insurance_amount'] - $insurance;

            // $tcs = $invoice_header[0]['tcs_amount'] / 1.18;
            // $tcs_tax =  $invoice_header[0]['tcs_amount'] - $tcs;

            // $total_amount = $invoice_header[0]["amount"] - $invoice_header[0]['discount_amount'] + $invoice_header[0]['freight_amount'] + $invoice_header[0]['insurance_amount'] + $invoice_header[0]['tcs_amount'];

            $total_amount = $invoice_header[0]["amount"];

            $total_amount = round($total_amount, 0);
            $amount_words = $this->getIndianCurrency($total_amount);
            $get_type = strtolower($this->input->get('type'));
            if ($get_type == 'original') {
                $type = 'Original for recipient';
            }
            if ($get_type == 'duplicate') {
                $type = 'Duplicate for transporter';
            }
            if ($get_type == 'triplicate') {
                $type = 'Triplicate for supplier';
            }

            $data["gst_no"] = $invoice_header[0]["gst_no"];
            $data["company"] = $invoice_header[0]["company"];
            $data["vendor_code"] = $invoice_header[0]["vendor_code"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["mobile"] = $invoice_header[0]["mobile"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['device_sub_category'] = $invoice_header[0]["device_sub_category"];
            $data['place_supply'] = $supply_place->name;
            // $data['hsn_code'] = $hsn_code;
            // $data['product_type'] = $product_type;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            // $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["date"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
            $data["amount"] = $invoice_header[0]["amount"];
            $data["total_amount"] = $total_amount;
            $data["tax"] = $invoice_header[0]["tax"];

            // $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            // $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];
            $data['amount_words'] = $amount_words;

            // $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];
            $data['type'] = $type;
            // $data['no_grade'] = $this->input->get('no_grade');

            // $data['discount_total'] = $invoice_header[0]['discount_amount'];
            // $data['discount_amount'] = $discount;
            // $data['discount_tax'] = $discount_tax;

            // $data['freight_total'] = $invoice_header[0]['freight_amount'];
            // $data['freight_amount'] = $freight;
            // $data['freight_tax'] = $freight_tax;

            // $data['insurance_total'] = $invoice_header[0]['insurance_amount'];
            // $data['insurance_amount'] = $insurance;
            // $data['insurance_tax'] = $insurance_tax;

            // $data['tcs_total'] = round($invoice_header[0]['tcs_amount'], 0);
            // $data['tcs_percent'] = $invoice_header[0]['tcs_percent'];

            // $gross_tax = $invoice_header[0]["tax"] - $discount_tax + $freight_tax + $insurance_tax;

            $gross_tax = $invoice_header[0]["tax"];

            $data['gross_tax'] = $gross_tax;
            $data['irn'] = $invoice_header[0]["irn"];
            $data['qr_code'] = $invoice_header[0]["qr_code"];

            $salesorderid = $invoice_header[0]["salesorder_id"];
            
            $shipping_from_data = $this->db->get_where('SHIPPING_FROM_AND_TO_LIST_VIEW',array("salesorder_id" => $salesorderid))->row();
            
            if(count($shipping_from_data) < 1){
                $data['shipping_from_address'] = array(
                    "address" => "1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet",
                    "city" => "Hyderabad",
                    "state" => "Telangana",
                    "pincode" => "INDIA 500016"
                );
                $data['shipping_address'] = array(
                    "address" => $invoice_header[0]["address"],
                    "city" => $invoice_header[0]["city"],
                    "state" => $invoice_header[0]["state"],
                    "pincode" => $invoice_header[0]["pincode"]
                );
                $data['billing_from_address'] = array(
                    "address" => "4th Floor, 1-11-251/19/A, Jayalakshmi Towers, Motilal Nehru Nagar,
                    Begumpet, Hyderabad, Telangana, 500016",
                    // "city" => "Hyderabad",
                    // "state" => "Telangana",
                    "gst_no" => "36AASCS2801C1ZI"
                );
                
            } else{
                
                $billing_from_id = $shipping_from_data->billing_from_id;
                $billing_from_data = $this->db->get_where('tbl_wh_loc',array("wh_id" => $billing_from_id))->row();
                
                $data['shipping_from_address'] = array(
                    "address" => $shipping_from_data->from_address,
                    "city" => $shipping_from_data->from_city,
                    "state" => $shipping_from_data->from_state,
                    "pincode" => $shipping_from_data->from_pincode
                );
                $data['shipping_address'] = array(
                    "address" => $shipping_from_data->to_address,
                    "city" => $shipping_from_data->to_city,
                    "state" => $shipping_from_data->to_state,
                    "pincode" => $shipping_from_data->to_pincode
                );
                $data['billing_from_address'] = array(
                    "address" => $billing_from_data->address,
                    // "city" => $billing_from_data->city,
                    // "state" => $billing_from_data->state,
                    "gst_no" => $billing_from_data->gst_number
                );
            }

        }
        
        $path = '';
        if (!empty($data['qr_code'])) {
            $path = "./uploads/qr_code/" . $invoice_id . ".png";
            $this->infiqr->generate($invoice_header[0]['qr_code'], 'png', $path);
        }

        $data['filename'] = $path;


        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_invoice_nonproduct', $data, TRUE);
            $header = $data["invoice_code"] . ' | ' . $data['date'];
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

    public function open_exportinvoice_with_tax_pdf($invoice = null, $pdf = '', $is_html = false)
    {

        if ($invoice > 0 && $pdf == 'no_pdf') {
            $invoice_id = $invoice;
        } else {
            $invoice_id = $this->input->get('invoice_id');
        }

        $download = $this->input->get('download');
        $invoice_header = $this->db->where('invoice_id', $invoice_id)->get('PDF_INVOICE_HEADER_VIEW')->result_array();

        $rows = $this->db->from('INVOICE_PDF_ROWS_VIEW AS rows')
                        ->join('tbl_device_type AS dt', 'dt.name = rows.product_type')
                        ->where('invoice_id', $invoice_id)
                        // ->group_by('SKU, price')
                        ->group_by('nhmod, ram, rom, device_actv_status, price')
                        ->select('rows.*, COUNT(rows.invoice_id) AS quantity, SUM(rows.price) AS t_amount, dt.hsn_code')
                        ->get()->result_array();

        $rows_hsnWise = $this->db->from('INVOICE_PDF_ROWS_VIEW AS rows')
                        ->join('tbl_device_type AS dt', 'dt.name = rows.product_type')
                        ->where('invoice_id', $invoice_id)
                        ->group_by('dt.hsn_code')
                        ->select('rows.*, COUNT(rows.invoice_id) AS quantity, SUM(rows.price) AS t_amount, dt.hsn_code')
                        ->get()->result_array();

        if (!empty($invoice_header)) {

            $data["company"] = $invoice_header[0]["company"];
            $data["vendor_code"] = $invoice_header[0]["vendor_code"];
            $data["address"] = $invoice_header[0]["address"];
            $data["state"] = $invoice_header[0]["state_nameorid"];
            $data["country"] = $invoice_header[0]["country"];
            $data["state_id"] = $invoice_header[0]["state_id"];
            $data["mobile"] = $invoice_header[0]["mobile"];
            $data["city"] = $invoice_header[0]["city"];
            $data["pincode"] = $invoice_header[0]["pincode"];
            $data['pan_no'] = $invoice_header[0]["pan_card"];
            $data['device_sub_category'] = $invoice_header[0]["device_sub_category"];
            $data['terms_of_delivery'] = $invoice_header[0]["terms_of_delivery"];
            $data['product_type'] = $product_type;

            $data["payment_mode"] = $invoice_header[0]["payment_mode"];
            $data["invoice_code"] = $invoice_header[0]["invoice_code"];
            $data["invoice_cdate"] = date("d-m-Y", strtotime($invoice_header[0]["CREATION_DATE"]));
            $data["salesorder_code"] = $invoice_header[0]["sales_code"];
            $data["salesorder_cdate"] = date("d-m-Y", strtotime($invoice_header[0]["salesorder_cdate"]));

            $data["salesman"] = $invoice_header[0]["salesman"];
            $data["sales_channel"] = $invoice_header[0]["sales_channel"];
            $data["saleschannel_ref_id"] = $invoice_header[0]["saleschannel_ref_id"];

            $data['warehouse'] = $invoice_header[0]["warehouse"];
            $data['invoice_id'] = $invoice_header[0]["invoice_id"];
            $data['no_grade'] = $this->input->get('no_grade');
            
            $data['irn'] = $invoice_header[0]["irn"];
            $data['qr_code'] = $invoice_header[0]["qr_code"];

            /** In INDIAN RUPEE */
            $data["gross_amount"] = $invoice_header[0]["amount"];
            $data['discount_total'] = $invoice_header[0]['discount_amount'];
            $data['freight_total'] = $invoice_header[0]['freight_amount'];
            $data['insurance_total'] = $invoice_header[0]['insurance_amount'];
            // $data['tcs_total'] = round($invoice_header[0]['tcs_amount'], 0);
            // $data['tcs_percent'] = $invoice_header[0]['tcs_percent'];

            
            $invoice_total_hsnWise = 0;
            $invoice_rows_hsnWise = [];
            foreach ($rows_hsnWise as $value) {
                $t_amount_hsnWise = $value["t_amount"];
                $t_amount_hsnWise = number_format((float) $t_amount_hsnWise, 2, '.', '');

                $invoice_total_hsnWise += $t_amount_hsnWise;

                $invoice_rows_hsnWise[] = array(
                    'hsn_code' => $value["hsn_code"],
                    'quantity' => $value['quantity'],
                    't_amount_hsnWise' => $t_amount_hsnWise,
                );
            }
            $data['rows_hsnWise'] = $invoice_rows_hsnWise;
            
            if (abs($invoice_header[0]["amount"] - $invoice_total_hsnWise) > 1) {
                // Should throw error
                echo "Error in Generating Invoice";die;
            }
            $data['gross_amount_hsnWise'] = number_format((float) $invoice_total_hsnWise, 2, '.', '');

            $total_amount = $invoice_total_hsnWise - $invoice_header[0]['discount_amount'] + $invoice_header[0]['freight_amount'] + $invoice_header[0]['insurance_amount'];
            $total_amount = round($total_amount, 0);
            $amount_words = $this->getIndianCurrency($total_amount);
            $data["total_amount"] = $total_amount;
            $data['amount_words'] = $amount_words;


            /** EXCHANGING THE INDIAN CURRENCY */
            
       

            $gross_amount_exch = $invoice_header[0]["amount"];
            $discount_total_exch= $invoice_header[0]['discount_amount'];
            $freight_total_exch = $invoice_header[0]['freight_amount'];
            $insurance_total_exch = $invoice_header[0]['insurance_amount'];
            // $tcs_total_exch = round($invoice_header[0]['tcs_amount'], 0);

            $data['gross_amount_exch'] = number_format((float) $gross_amount_exch, 2, '.', '');
            $data['discount_total_exch'] = number_format((float) $discount_total_exch, 2, '.', '');
            $data['freight_total_exch'] = number_format((float) $freight_total_exch, 2, '.', '');
            $data['insurance_total_exch'] = number_format((float) $insurance_total_exch, 2, '.', '');
            // $data['tcs_total_exch'] = number_format((float) $tcs_total_exch, 2, '.', '');
            
            
        
            $invoice_total_exch = 0;
            $invoice_rows = [];
            foreach ($rows as $value) {
                $price_exch = $value["price"];
                $t_amount_exch = $value["t_amount"];
                // $t_amount_exch = $price_exch * $value['t_amount'];

                $price_exch = number_format((float) $price_exch, 2, '.', '');
                $t_amount_exch = number_format((float) $t_amount_exch, 2, '.', '');

                $invoice_total_exch += $t_amount_exch;

                $invoice_rows[] = array(
                    'hsn_code' => $value["hsn_code"],
                    'product_name' => $value["device_name"],
                    'device_actv_status' => $value["device_actv_status"],
                    'deviceid' => $value["nhdin"],
                    'nhmod' => $value["nhmod"],
                    'price' => $value["price"],
                    'ram' => $value["ram"],
                    'rom' => $value["rom"],
                    'color' => $value["color"],
                    'sku' => $value["SKU"],
                    'category' => $value["category"],
                    'price' => $value["price"],
                    'quantity' => $value['quantity'],
                    't_amount' => $value['t_amount'],
                    'price_exch' => $price_exch,
                    't_amount_exch' => $t_amount_exch,
                );
            }
            $data['rows'] = $invoice_rows;

            if (abs($gross_amount_exch - $invoice_total_exch) > 2) {
                // Should throw error
                echo "Error in Generating Invoice";die;
            }

            $data['gross_amount_exch'] = number_format((float) $invoice_total_exch, 2, '.', '');

            $total_amount_exch = $data['gross_amount_exch'] - $data['discount_total_exch'] + $data['freight_total_exch'] + $data['insurance_total_exch'];
            $total_amount_exch = round($total_amount_exch, 0);
            $amount_words_exch = $this->getCurrencyInWords($total_amount_exch, 'Rupees');
            $data["total_amount_exch"] = $total_amount_exch;
            $data['amount_words_exch'] = $amount_words_exch;

            /** SHIPPING ADDRESS */
            $salesorderid = $invoice_header[0]["salesorder_id"];
            $shipping_from_data = $this->db->get_where('SHIPPING_FROM_AND_TO_LIST_VIEW',array("salesorder_id" => $salesorderid))->row();
            //echo $salesorderid; exit;
            if(count($shipping_from_data) < 1){
                $data['shipping_from_address'] = array(
                    "seller" => "SLOYD VENTURES (P) LTD",
                    "address" => "1-11-251/19A. 4th Floor, Jayalakshmi Towers, Motilal Nehru Nagar, Begumpet",
                    "city" => "Hyderabad",
                    "state" => "Telangana",
                    "pincode" => "INDIA 500016"
                );
                $data['shipping_address'] = array(
                    "address" => $invoice_header[0]["address"],
                    "city" => $invoice_header[0]["city"],
                    "state" => $invoice_header[0]["state"],
                    "pincode" => $invoice_header[0]["pincode"]
                );
                
            } else{
                $shipping_to_vendor = $shipping_from_data->shipping_to_vendor;
                if((int)$shipping_to_vendor){
                    $company_name = $this->db->get_where('tbl_vendor', array("vendor_id" => $shipping_to_vendor))->row()->company;
                } else {
                    $company_name = $invoice_header[0]["company"];
                }
                $data['shipping_from_address'] = array(
                    "seller" => $shipping_from_data->from_seller,
                    "address" => $shipping_from_data->from_address,
                    "city" => $shipping_from_data->from_city,
                    "state" => $shipping_from_data->from_state,
                    "pincode" => $shipping_from_data->from_pincode
                );
                $data['shipping_address'] = array(
                    "company" => $company_name,
                    "address" => $shipping_from_data->to_address,
                    "city" => $shipping_from_data->to_city,
                    "state" => $shipping_from_data->to_state,
                    "country" => $shipping_from_data->to_country,
                    "pincode" => $shipping_from_data->to_pincode
                );
            }

        }

        $path = '';
        if (!empty($data['qr_code'])) {
            $path = "./uploads/qr_code/" . $invoice_id . ".png";
            $this->infiqr->generate($invoice_header[0]['qr_code'], 'png', $path);
        }

        $data['filename'] = $path;

        if ($invoice > 0 && $pdf == 'no_pdf') {
            return $data;
        } else {
            $this->load->helper('dompdf');
            $viewfile = $this->load->view('admin/invoice/pdf_invoice_export_with_tax', $data, TRUE);
            if ($is_html) {
                echo $viewfile;die;
            }
            $header = '                                                                                                    ';
            $header .= 'Invoice Code: ' . $data["invoice_code"] . ' | ' . 'Invoice Creation Date: ' . $data['invoice_cdate'] ;
            pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
        }
    }

}
