<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Inventory_valuation extends Admin_Controller
{
    private  $prexo_uncertified = array();
    private  $prexo_supplier_graded = array();
    private  $prexo_refurbished = array();
    private  $prexo_faulted = array();
    private  $prexo_ber = array();
    private  $prexo_x = array();
    private  $openbox_uncertified = array();
    private  $openbox_refurbished = array();
    private  $openbox_faulted = array();
    private  $openbox_ber = array();
    private  $openbox_x = array();
    private $valuation_date;

    public function __construct()
    {
        parent::__construct();
    }

    public function manage_inventory_valuation($active = 0)
    {

        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'INVENTORY VALUATION';
        $data['subview'] = $this->load->view('admin/inventory_valuation/manage_inventory_valuation', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getInventory_old($inventory_date = '')
    {
        $date = $inventory_date;
        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];
        $sold_stock = array();
        $total_grn_ids = [];
        $total_inventory = [];

        $available_stock = $this->db->where('grn_inwarddate <= ', $date)->group_by('grnreport_id')->get('AVAILABLE_INVENTORY_VIEW')->result_array();

        $headoffice_sales = $this->db->where('grn_inwarddate <= ', $date)->where('CREATION_DATE >= ', $date)->get('SOLD_AFTER_INVENTORY_VIEW')->result_array();

        foreach ($available_stock as $rowValue) {

            $total_grn_ids[] = $rowValue['grnreport_id'];

            $total_inventory[] = array(
                "grnreport_id" => $rowValue['grnreport_id'],
                "device_id" => $rowValue['nhdin'],
                "nhmod" => $rowValue['nhmod'],
                "device_name" => $rowValue['device_name'],
                "sku" => $rowValue['SKU'],
                "stock_type" => $rowValue['stock_type'],
                "certification_grade" => $rowValue['certification_grade'],
                "procurement_grade" => $rowValue['procurement_grade'],
                "status" => $rowValue['status'],
                "warehouse" => $rowValue['warehouse'],
                "unit_price" => $rowValue['unit_price'],
                "unit_price_tax" => $rowValue['unit_price_tax'],
                "grn_inwarddate" => $rowValue['grn_inwarddate'],
            );
        }

        foreach ($headoffice_sales as $rowValue) {

            if (!in_array($rowValue['grnreport_id'], $total_grn_ids)) {

                $total_grn_ids[] = $rowValue['grnreport_id'];

                $total_inventory[] = array(
                    "grnreport_id" => $rowValue['grnreport_id'],
                    "device_id" => $rowValue['nhdin'],
                    "nhmod" => $rowValue['nhmod'],
                    "device_name" => $rowValue['device_name'],
                    "sku" => $rowValue['SKU'],
                    "stock_type" => $rowValue['stock_type'],
                    "certification_grade" => $rowValue['certification_grade'],
                    "procurement_grade" => $rowValue['procurement_grade'],
                    "status" => $rowValue['status'],
                    "warehouse" => $rowValue['warehouse'],
                    "unit_price" => $rowValue['unit_price'],
                    "unit_price_tax" => $rowValue['unit_price_tax'],
                    "grn_inwarddate" => $rowValue['grn_inwarddate'],
                );
            }
        }

        $this->db->select('count(tbl_grnreport.nhdin) as total_stock, fnsku');
        $this->db->where('tbl_grnreport.saletype', 'AMAZON"');
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
        $total_array = $this->db->group_by('fnsku')->get('tbl_stocktransfer_invoice')->result_array();

        $this->db->select('count(tbl_ecom_invoice_item.ecom_invoice_item_id) as sold, fnsku')->where_in('status', $where_status);
        $this->db->join('tbl_ecom_invoice', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
        $sold_array = $this->db->group_by('fnsku')->get('tbl_ecom_invoice_item')->result_array();

        foreach ($sold_array as $soldFNSKU) {
            $sold_stock[$soldFNSKU['fnsku']] = $soldFNSKU['sold'];
        }

        foreach ($total_array as $totalFnsku) {

            $sold = $sold_stock[$totalFnsku['fnsku']];

            if (empty($sold)) {
                $sold = 0;
            }
            $available_stock = $totalFnsku['total_stock'] - $sold;

            $where = array(
                "fnsku" => $totalFnsku['fnsku'],
                'tbl_grnreport.saletype' => 'AMAZON'
            );
            if ($available_stock > 0) {
                $this->db->select('tbl_grnreport.*');
                $this->db->where($where)->limit($available_stock);
                $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
                $total_array = $this->db->group_by('fnsku')->get('tbl_stocktransfer_invoice')->result_array();


                foreach ($total_array as $rowValue) {
                    if (!in_array($rowValue['grnreport_id'], $total_grn_ids)) {

                        $total_grn_ids[] = $rowValue['grnreport_id'];

                        $total_inventory[] = array(
                            "grnreport_id" => $rowValue['grnreport_id'],
                            "device_id" => $rowValue['nhdin'],
                            "nhmod" => $rowValue['nhmod'],
                            "device_name" => $rowValue['device_name'],
                            "sku" => $rowValue['SKU'],
                            "stock_type" => $rowValue['stock_type'],
                            "certification_grade" => $rowValue['certification_grade'],
                            "procurement_grade" => $rowValue['procurement_grade'],
                            "status" => $rowValue['status'],
                            "warehouse" => $rowValue['warehouse'],
                            "unit_price" => $rowValue['unit_price'],
                            "unit_price_tax" => $rowValue['unit_price_tax'],
                            "grn_inwarddate" => $rowValue['grn_inwarddate'],
                        );
                    }
                }
            }
        }

        return $total_inventory;
    }

    public function exportTotalInventory()
    {
        $date = $this->input->get('inventory_date');
        $this->valuation_date = $date;
        $result = $this->getInventory();

        $csv_output = "Device Id, Device Name, SKU, Category, Grade, status, Warehouse, Unit Price, Unit Price Tax, Inward date, Invoice No, VRP no, Unit Price, Unit Price Tax, Total Cost";
        $csv_output .= "\r\n";

        foreach ($result as $rowValue) {
            $csv_output .= $rowValue['device_id'] . ",";
            $csv_output .= $rowValue['device_name'] . ",";
            $csv_output .= $rowValue['sku'] . ",";
            $csv_output .= $rowValue['stock_type'] . ",";
            $csv_output .= $rowValue['certification_grade'] . ",";
            $csv_output .= $rowValue['status'] . ",";
            $csv_output .= $rowValue['warehouse'] . ",";
            $csv_output .= $rowValue['unit_price'] . ",";
            $csv_output .= $rowValue['unit_price_tax'] . ",";
            $csv_output .= date("d-m-Y", strtotime($rowValue['grn_inwarddate'])) . ",";
            $csv_output .= $rowValue['invoice_no'] . ",";
            $csv_output .= $rowValue['lot_number'] . ",";
            $csv_output .= "\r\n";
        }

        $filename = "Inventory " . "_" . date("Y-m-d_H-i", time());
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;
    }

    public function validation()
    {
        $result = $this->getInventory();

        //Sort Array by Date
        array_multisort(array_column($result, 'grn_inwarddate'), SORT_DESC, $result);

        $prexo_uncertified = [];
        $prexo_supplier_graded = [];
        $prexo_refurbished = [];
        $prexo_faulted = [];
        $prexo_x = [];
        $prexo_ber = [];

        $ob_uncertified = [];
        $ob_supplier_graded = [];
        $ob_refurbished = [];
        $ob_faulted = [];
        $ob_x = [];
        $ob_ber = [];

        $taxable_cat = TAXABLE_CATEGORY;
        foreach ($result as $rowValue) {

            if (in_array($rowValue['stock_type'], $taxable_cat)) { //OPen Box

                if ($rowValue['certification_grade'] == 'UC') {
                    if ($rowValue['procurement_grade'] == 'UC') {

                        $ob_uncertified[] = $rowValue;
                    } else {
                        $ob_supplier_graded[] = $rowValue;
                    }
                } elseif ($rowValue['certification_grade'] == 'FF') {

                    $ob_faulted[] = $rowValue;
                } elseif ($rowValue['certification_grade'] == 'BER') {

                    $ob_ber[] = $rowValue;
                } elseif ($rowValue['certification_grade'] == 'X') {

                    $ob_x[] = $rowValue;
                } else {
                    $ob_refurbished[] = $rowValue;
                }
            } else { //Prexo

                if ($rowValue['certification_grade'] == 'UC') {

                    if ($rowValue['procurement_grade'] == 'UC') { //Uncertified

                        $prexo_uncertified[] = $rowValue;
                    } else {                                    //Supplier Graded
                        $prexo_supplier_graded[] = $rowValue;
                    }
                } elseif ($rowValue['certification_grade'] == 'FF') { // Faulted

                    $prexo_faulted[] = $rowValue;
                } elseif ($rowValue['certification_grade'] == 'BER') {

                    $prexo_ber[] = $rowValue;
                } elseif ($rowValue['certification_grade'] == 'X') {

                    $prexo_x[] = $rowValue;
                } else {                            //Refurbished

                    $prexo_refurbished[] = $rowValue;
                }
            }
        }

        $this->prexo_uncertified = $prexo_uncertified;
        $this->prexo_supplier_graded = $prexo_supplier_graded;
        $this->prexo_refurbished = $prexo_refurbished;
        $this->prexo_faulted = $prexo_faulted;
        $this->prexo_ber = $prexo_ber;
        $this->prexo_x = $prexo_x;
        $this->openbox_uncertified = $ob_uncertified;
        $this->openbox_supplier_graded =  $ob_supplier_graded;
        $this->openbox_refurbished = $ob_refurbished;
        $this->openbox_faulted = $ob_refurbished;
        $this->openbox_ber = $ob_ber;
        $this->openbox_x = $ob_x;

        //Calculating NRV

        $this->getPrexoUncertifiedValuation();
        $this->getPrexoSupplierGradedValuation();
        $this->getPrexoRefurbishedValuation();
        $this->getPrexoFaultedValuation();
        $this->getPrexoBER();
        $this->getPrexoX();
    }

    public function getInventory()
    {
        $date = $this->valuation_date;

        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];
        $sold_stock = array();
        $total_grn_ids = [];
        $total_inventory = [];
        $fba_ids = [];

        //Get All the Stock
        $query = 'SELECT tbl_grnreport.* 
                    from (SELECT c.device_id, d.status, c.last_updated 
                            FROM (SELECT device_id, MAX(last_updated) last_updated FROM tbl_device_log 
                 
                                        WHERE date(last_updated) <= "' . $date . '" GROUP BY device_id ) c 

                            JOIN tbl_device_log d ON c.device_id = d.device_id AND d.last_updated = c.last_updated ORDER by d.last_updated desc) as b
                JOIN tbl_grnreport ON tbl_grnreport.nhdin = b.device_id
                 WHERE b.status not in ("SOLD", "LOST")';


        $result = $this->db->query($query)->result_array();

        foreach ($result as $rowValue) {

            //Separete FBA Stock
            if ($rowValue['saletype'] != 'AMAZON') {
                $total_grn_ids[] = $rowValue['grnreport_id'];

                $total_inventory[] = array(
                    "grnreport_id" => $rowValue['grnreport_id'],
                    "device_id" => $rowValue['nhdin'],
                    "nhmod" => $rowValue['nhmod'],
                    "device_name" => $rowValue['device_name'],
                    "sku" => $rowValue['SKU'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "brand" => $rowValue['product_brand'],
                    "stock_type" => $rowValue['stock_type'],
                    "certification_grade" => $rowValue['certification_grade'],
                    "procurement_grade" => $rowValue['procurement_grade'],
                    "status" => $rowValue['status'],
                    "warehouse" => $rowValue['warehouse'],
                    "unit_price" => $rowValue['unit_price'],
                    "unit_price_tax" => $rowValue['unit_price_tax'],
                    "grn_inwarddate" => $rowValue['grn_inwarddate'],
                    "invoice_no" => $rowValue['invoice_no'],
                    "lot_number" => $rowValue['lot_number'],
                );
            } else {

                $fba_ids[] = $rowValue['grnreport_id'];
            }
        }

        $fba_where = array(
            "tbl_grnreport.saletype" => "AMAZON",
            "tbl_grnreport.warehouse like " => "AMAZON%",
            "st_type" => "OUTWARD",
            "tbl_stocktransfer.status != " => "CANCELLED",
            "DATE(tbl_stocktransfer.stocktransfer_date) <= " => $date
        );
        //Get FBA Stock in reverse order
        $this->db->select('count(tbl_grnreport.nhdin) as total_stock, fnsku');
        $this->db->where($fba_where);
        $this->db->join('tbl_stocktransfer_invoice', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
        $this->db->join('tbl_stocktransfer', 'tbl_stocktransfer.stocktransfer_id = tbl_stocktransfer_invoice.stocktransfer_id');
        $total_array = $this->db->group_by('fnsku')->get('tbl_grnreport')->result_array();

        $this->db->select('count(tbl_ecom_invoice_item.ecom_invoice_item_id) as sold, fnsku')->where_in('status', $where_status);
        $this->db->where('DATE(sale_date) <= ', $date);
        $this->db->join('tbl_ecom_invoice_item', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
        $sold_array = $this->db->group_by('fnsku')->get('tbl_ecom_invoice')->result_array();

        foreach ($sold_array as $soldFNSKU) {
            $sold_stock[$soldFNSKU['fnsku']] = $soldFNSKU['sold'];
        }

        foreach ($total_array as $totalFnsku) {

            $sold = $sold_stock[$totalFnsku['fnsku']];

            if (empty($sold)) {
                $sold = 0;
            }
            $available_stock = $totalFnsku['total_stock'] - $sold;

            $where = array(
                "fnsku" => $totalFnsku['fnsku'],
                'tbl_grnreport.saletype' => 'AMAZON',
                "st_type" => "OUTWARD",
                "tbl_grnreport.warehouse like " => "AMAZON%",
                'tbl_grnreport.status != ' => 'SOLD',
                "tbl_stocktransfer.status != " => "CANCELLED",
                "DATE(tbl_stocktransfer.stocktransfer_date) <= " => $date
            );
            if ($available_stock > 0) {

                $this->db->select('tbl_grnreport.*');
                $this->db->where($where)->limit($available_stock);

                $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
                $this->db->join('tbl_stocktransfer', 'tbl_stocktransfer.stocktransfer_id = tbl_stocktransfer_invoice.stocktransfer_id');
                $total_array = $this->db->group_by('grnreport_id')->order_by('tbl_stocktransfer_invoice.last_update_date', 'DESC')->get('tbl_stocktransfer_invoice')->result_array();


                foreach ($total_array as $rowValue) {
                    if (!in_array($rowValue['grnreport_id'], $total_grn_ids)) {

                        $total_grn_ids[] = $rowValue['grnreport_id'];

                        $total_inventory[] = array(
                            "grnreport_id" => $rowValue['grnreport_id'],
                            "device_id" => $rowValue['nhdin'],
                            "nhmod" => $rowValue['nhmod'],
                            "device_name" => $rowValue['device_name'],
                            "sku" => $rowValue['SKU'],
                            "ram" => $rowValue['ram'],
                            "rom" => $rowValue['rom'],
                            "brand" => $rowValue['product_brand'],
                            "stock_type" => $rowValue['stock_type'],
                            "procurement_grade" => $rowValue['procurement_grade'],
                            "certification_grade" => $rowValue['certification_grade'],
                            "status" => $rowValue['status'],
                            "warehouse" => $rowValue['warehouse'],
                            "unit_price" => $rowValue['unit_price'],
                            "unit_price_tax" => $rowValue['unit_price_tax'],
                            "grn_inwarddate" => $rowValue['grn_inwarddate'],
                        );
                    }
                }
            }
        }

        return $total_inventory;
    }

    public function getInventoryValuation()
    {
        $this->valuation_date = $this->input->get('valuation_date');
        $this->validation();


        $output_arr = array_merge(
            $this->prexo_uncertified,
            $this->prexo_supplier_graded,
            $this->prexo_refurbished,
            $this->prexo_faulted,
            $this->prexo_ber,
            $this->prexo_x,
            $this->openbox_uncertified,
            $this->openbox_refurbished,
            $this->openbox_faulted,
            $this->openbox_ber,
            $this->openbox_x
        );

        $output = 'Device id, Brand Name, Device Name, RAM, ROM, SKU, Category,';
        $output .= 'Procurement Grade, Certification Grade, Status, Inward Date, Unit Price, Unit Price Tax, NRV';
        $output .= "\r\n";
        foreach ($output_arr as $rowValue) {

            $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
            $nrv = $rowValue['nrv'];

            if ($nrv > $cost_price) {
                $nrv = $nrv / 1.18;
            }

            if ($nrv > $cost_price) {
                $nrv = $cost_price;
            }

            if ($rowValue['grn_inwarddate'] == '2020-03-31') {
                $nrv_old = $rowValue['nrv_old'];

                if ($nrv > $nrv_old) {
                    $nrv = $nrv_old;
                }
            }

            if ($rowValue['certification_grade'] != 'X' && $rowValue['certification_grade'] != 'BER') {

                if ($nrv < 300) {
                    $nrv = 300;
                }
            }

            $output .= $rowValue['device_id'] . ",";
            $output .= $rowValue['brand'] . ",";
            $output .= $rowValue['device_name'] . ",";
            $output .= $rowValue['ram'] . ",";
            $output .= $rowValue['rom'] . ",";
            $output .= $rowValue['sku'] . ",";
            $output .= $rowValue['stock_type'] . ",";
            $output .= $rowValue['procurement_grade'] . ",";
            $output .= $rowValue['certification_grade'] . ",";
            $output .= $rowValue['status'] . ",";
            $output .= date('d-m-Y', strtotime($rowValue['grn_inwarddate'])) . ",";
            $output .= $rowValue['unit_price'] . ",";
            $output .= $rowValue['unit_price_tax'] . ",";
            $output .= $rowValue['nrv'] . ",";
            $output .= "\r\n";
        }

        $filename = "FBA Inventory" . "_" . date("Y-m-d_H-i", time());
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $output;
        exit;
    }


    public function getPrexoUncertifiedValuation()
    {
        $prexo_uncertified = $this->prexo_uncertified;
        $valuation_date = $this->valuation_date;
        $prexo_uc_models = [];
        $prexo_model_nrv = array();

        foreach ($prexo_uncertified as $key => $rowValue) {
            $nrv = false;

            //Get NRV from Sale Price
            if (!in_array($rowValue['nhmod'], $prexo_uc_models)) {

                //Calculate Procurement Age
                $v_date = date_create($valuation_date);
                $inward_date = date_create($rowValue['grn_inwarddate']);
                $age_item = date_diff($v_date, $inward_date);
                $procurement_age = $age_item->format('%a');

                $where_arr1 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "DATE(CREATION_DATE) <=" => $valuation_date
                );

                $where_arr2 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $backward = $this->db->where($where_arr1)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (!empty($backward)) {

                    $origin = date_create($valuation_date);
                    $target = date_create($backward->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = $backward->price;
                            $prexo_uc_models[] = $rowValue['nhmod'];
                            $prexo_model_nrv[$rowValue['nhmod']] = $nrv;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = $backward->price;
                            $prexo_uc_models[] = $rowValue['nhmod'];
                            $prexo_model_nrv[$rowValue['nhmod']] = $nrv;
                        }
                    }
                }

                if ($nrv == false) { // Check Forward // Same for both Procurement age within six months and prior to six months
                    $forward = $this->db->where($where_arr2)->order_by('CREATION_DATE', 'ASC')->get('INVOICE_ITEM_VIEW')->row();

                    if (!empty($forward)) {
                        $nrv = $forward->price;
                        $prexo_uc_models[] = $rowValue['nhmod'];
                        $prexo_model_nrv[$rowValue['nhmod']] = $nrv;
                    }
                }

                if ($nrv == false) { //Non-moving Models
                    if ($procurement_age <= 180) {
                        $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                        $nrv = $cost_price + $cost_price * 5 / 100;
                        $prexo_uc_models[] = $rowValue['nhmod'];
                        $prexo_model_nrv[$rowValue['nhmod']] = $nrv;
                    }
                }

                if ($nrv == false) {
                    $network = $this->db->select('network_desc')->where('nhmod', $rowValue['nhmod'])->get('tbl_product_details')->row()->network_desc;
                    $network_arr = ['5G', '4G', '3G'];
                    if (!in_array($network, $network_arr)) {
                        $network = '4G';
                    }

                    $procurement_age_in_months = $procurement_age / 30;

                    $discount_where = array(
                        "network" => $network,
                        "category" => 'PRE_OWNED',
                        "from_age >=" => $procurement_age_in_months,
                        "to_age <=" => $procurement_age_in_months,
                    );
                    $discount = $this->db->where($discount_where)->get('tbl_valuation_discount')->row();

                    $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                    $nrv = $cost_price - $cost_price * $discount / 100;
                    $prexo_uc_models[] = $rowValue['nhmod'];
                    $prexo_model_nrv[$rowValue['nhmod']] = $nrv;
                }
            }

            $prexo_uncertified[$key]['nrv'] = $prexo_model_nrv[$rowValue['nhmod']];
        }

        $this->prexo_uncertified = $prexo_uncertified;
    }

    public function getPrexoSupplierGradedValuation()
    {
        $prexo_supplier_graded = $this->prexo_supplier_graded;
        $valuation_date = $this->valuation_date;
        $prexo_sg_models = [];
        $prexo_sg_nrv = [];

        foreach ($prexo_supplier_graded as $key => $rowValue) {
            $nrv = false;

            $search_arr = array(
                "nhmod" => $rowValue['nhmod'],
                "procurement_grade" => $rowValue['procurement_grade'],
            );
            $search_str = $rowValue['nhmod'] . '-' . $rowValue['procurement_grade'];
            //Get NRV from Sale Price
            if (!in_array($search_arr, $prexo_sg_models)) {

                //Calculate Procurement Age
                $v_date = date_create($valuation_date);
                $inward_date = date_create($rowValue['grn_inwarddate']);
                $age_obj = date_diff($v_date, $inward_date);
                $procurement_age = $age_obj->format('%a');

                $where_arr1 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "procurement_grade" => $rowValue['procurement_grade'],
                    "DATE(CREATION_DATE) <=" => $valuation_date
                );

                $where_arr2 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "procurement_grade" => $rowValue['procurement_grade'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $backward = $this->db->where($where_arr1)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (!empty($backward)) {

                    $origin = date_create($valuation_date);
                    $target = date_create($backward->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = $backward->price;
                            $prexo_sg_models[] = $search_arr;
                            $prexo_sg_nrv[$search_str] = $nrv;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = $backward->price;
                            $prexo_sg_models[] = $search_arr;

                            $prexo_sg_nrv[$search_str] = $nrv;
                        }
                    }
                }

                if ($nrv == false) { // Check Forward // Same for both Procurement age within six months and prior to six months
                    $forward = $this->db->where($where_arr2)->order_by('CREATION_DATE', 'ASC')->get('INVOICE_ITEM_VIEW')->row();

                    if (!empty($forward)) {
                        $nrv = $forward->price;
                        $prexo_sg_models[] = $search_arr;
                        $prexo_sg_nrv[$search_str] = $nrv;
                    }
                }

                if ($nrv == false) { //Non-moving Models
                    if ($procurement_age <= 180) {
                        $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                        $nrv = $cost_price + $cost_price * 5 / 100;
                        $prexo_sg_models[] = $search_arr;
                        $prexo_sg_nrv[$search_str] = $nrv;
                    }
                }

                if ($nrv == false) {  //Non Moving Models

                    $where_arr3 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "DATE(CREATION_DATE) <=" => $valuation_date
                    );

                    $where_arr4 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "DATE(CREATION_DATE) >" => $valuation_date
                    );

                    $backward2 = $this->db->where($where_arr3)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                    if (!empty($backward2)) {
                        $sp_grade = $backward2->certification_grade;

                        if (strtolower($rowValue['brand']) == 'apple') {
                            $brand = 'Apple';
                        } else {
                            $brand = 'Other';
                        }

                        $deemed_cost_result = $this->db->where('brand', $brand)->get('tbl_deemed_price')->result_array();

                        foreach ($deemed_cost_result as $deemed_row) {
                            if ($deemed_row['grade'] == $sp_grade) {
                                $sp_grade_perc = $deemed_row['deemed_cost'];
                            }

                            if ($rowValue['procurement_grade'] == $deemed_row['grade']) {
                                $this_grade_perc = $deemed_row['deemed_cost'];
                            }
                        }

                        $nrv = ($backward2->price * $this_grade_perc) / $sp_grade_perc;
                        $prexo_sg_models[] = $search_arr;
                        $prexo_sg_nrv[$search_str] = $nrv;
                    }

                    if (empty($backward2)) {
                        $forward2 = $this->db->where($where_arr4)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                        if (!empty($forward2)) {
                            $sp_grade = $backward2->certification_grade;

                            if (strtolower($rowValue['brand']) == 'apple') {
                                $brand = 'Apple';
                            } else {
                                $brand = 'Other';
                            }

                            $deemed_cost_result = $this->db->where('brand', $brand)->get('tbl_deemed_price')->result_array();

                            foreach ($deemed_cost_result as $deemed_row) {
                                if ($deemed_row['grade'] == $sp_grade) {
                                    $sp_grade_perc = $deemed_row['deemed_cost'];
                                }

                                if ($rowValue['procurement_grade'] == $deemed_row['grade']) {
                                    $this_grade_perc = $deemed_row['deemed_cost'];
                                }
                            }

                            $nrv = ($backward2->price * $this_grade_perc) / $sp_grade_perc;
                            $prexo_sg_models[] = $search_arr;
                            $prexo_sg_nrv[$search_str] = $nrv;
                        }
                    }
                }

                if ($nrv == false) {
                    $network = $this->db->select('network_desc')->where('nhmod', $rowValue['nhmod'])->get('tbl_product_details')->row()->network_desc;
                    $network_arr = ['5G', '4G', '3G'];
                    if (!in_array($network, $network_arr)) {
                        $network = '4G';
                    }

                    $procurement_age_in_months = $procurement_age / 30;

                    $discount_where = array(
                        "network" => $network,
                        "category" => 'PRE_OWNED',
                        "from_age >=" => $procurement_age_in_months,
                        "to_age <=" => $procurement_age_in_months,
                    );
                    $discount = $this->db->where($discount_where)->get('tbl_valuation_discount')->row();

                    $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                    $nrv = $cost_price - $cost_price * $discount / 100;
                    $prexo_sg_nrv[$search_str] = $nrv;
                }
            }

            $prexo_supplier_graded[$key]['nrv'] = $prexo_sg_nrv[$search_str];
        }

        $this->prexo_supplier_graded = $prexo_supplier_graded;
    }

    public function getPrexoRefurbishedValuation()
    {
        $prexo_refurbished = $this->prexo_refurbished;
        $valuation_date = $this->valuation_date;
        $prexo_refurbished_models = [];
        $prexo_refurbished_nrv = [];

        foreach ($prexo_refurbished as $key => $rowValue) {
            $nrv = false;

            $search_arr = array(
                "nhmod" => $rowValue['nhmod'],
                "certification_grade" => $rowValue['certification_grade'],
                "ram" => $rowValue['ram'],
                "rom" => $rowValue['rom'],
            );

            $search_str = $rowValue['nhmod'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom'] . '-' . $rowValue['certification_grade'];

            //Get NRV from Sale Price
            if (!in_array($search_arr, $prexo_refurbished_models)) {

                //Calculate Procurement Age
                $v_date = date_create($valuation_date);
                $inward_date = date_create($rowValue['grn_inwarddate']);
                $age_obj = date_diff($v_date, $inward_date);
                $procurement_age = $age_obj->format('%a');

                $where_arr1 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "certification_grade" => $rowValue['certification_grade'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) <=" => $valuation_date
                );

                $where_arr2 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "certification_grade" => $rowValue['certification_grade'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $backward = $this->db->where($where_arr1)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (!empty($backward)) {

                    $origin = date_create($valuation_date);
                    $target = date_create($backward->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = $backward->price;
                            $prexo_refurbished_models[] = $search_arr;
                            $prexo_refurbished_nrv[$search_str] = $nrv;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = $backward->price;
                            $prexo_refurbished_models[] = $search_arr;
                            $prexo_refurbished_nrv[$search_str] = $nrv;
                        }
                    }
                }

                if ($nrv == false) { // Check Forward // Same for both Procurement age within six months and prior to six months
                    $forward = $this->db->where($where_arr2)->order_by('CREATION_DATE', 'ASC')->get('INVOICE_ITEM_VIEW')->row();

                    if (!empty($forward)) {
                        $nrv = $forward->price;
                        $prexo_refurbished_models[] = $search_arr;
                        $prexo_refurbished_nrv[$search_str] = $nrv;
                    }
                }
            }

            if ($nrv == false) { //Non Moving Models

                //Same Variant Other Grades

                $where_arr3 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) <=" => $valuation_date,
                );

                $where_arr4 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $other_grade_result = $this->db->where($where_arr3)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (empty($other_grade_result)) {
                    $other_grade_result = $this->db->where($where_arr4)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();
                }

                if (!empty($other_grade_result)) {
                    if (strtolower($rowValue['brand']) == 'apple') {
                        $brand = 'Apple';
                    } else {
                        $brand = 'Other';
                    }
                    $score_where = array(
                        'model_id' => $rowValue['nhmod'],
                        "ram" => $rowValue['ram'],
                        "rom" => $rowValue['rom'],
                        "brand_type" => $brand
                    );

                    $this->db->select('total_score')->where($score_where);
                    $this->db->join('tbl_pm_pricelist', 'tbl_pm_pricelist.modelvariant_id = tbl_pm_modelvariant.modelvariant_id');
                    $score = $this->db->get('tbl_pm_modelvariant')->row()->total_score();

                    $where_deemed_perc = array(
                        "min_score >=" => $score,
                        "max_score <=" => $score
                    );

                    $price_perc = $this->db->where($where_deemed_perc)->get('tbl_pm_price_matrix_preowned')->row();
                    $sp_grade = $other_grade_result->certification_grade;

                    if ($rowValue['certification_grade'] == 'PL-A') {
                        $this_grade_perc = $price_perc->sp_seltrue_grade_a;
                    }
                    if ($rowValue['certification_grade'] == 'PL-B') {
                        $this_grade_perc = $price_perc->sp_seltrue_grade_b;
                    }
                    if ($rowValue['certification_grade'] == 'PL-C') {
                        $this_grade_perc = $price_perc->sp_seltrue_grade_c;
                    }
                    if ($rowValue['certification_grade'] == 'SFF') {
                        $this_grade_perc = $price_perc->sp_seltrue_grade_sff;
                    }

                    if ($sp_grade == 'PL-A') {
                        $sp_grade_perc = $price_perc->sp_seltrue_grade_a;
                    }
                    if ($sp_grade == 'PL-B') {
                        $sp_grade_perc = $price_perc->sp_seltrue_grade_b;
                    }
                    if ($sp_grade == 'PL-C') {
                        $sp_grade_perc = $price_perc->sp_seltrue_grade_c;
                    }
                    if ($sp_grade == 'SFF') {
                        $sp_grade_perc = $price_perc->sp_seltrue_grade_sff;
                    }
                    $origin = date_create($valuation_date);
                    $target = date_create($other_grade_result->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = ($other_grade_result->price * $this_grade_perc) / $sp_grade_perc;
                            $prexo_refurbished_models[] = $search_arr;
                            $prexo_refurbished_nrv[$search_str] = $nrv;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = ($other_grade_result->price * $this_grade_perc) / $sp_grade_perc;
                            $prexo_refurbished_models[] = $search_arr;
                            $prexo_refurbished_nrv[$search_str] = $nrv;
                        }
                    }
                }

                //Different Variant Same Grade

                if ($nrv == false) {

                    $where_arr3 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "certification_grade" => $rowValue['certification_grade'],
                        "DATE(CREATION_DATE) <=" => $valuation_date,
                    );

                    $where_arr4 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "certification_grade" => $rowValue['certification_grade'],
                        "DATE(CREATION_DATE) >" => $valuation_date
                    );

                    $other_grade_result = $this->db->where($where_arr3)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();

                    if (empty($other_grade_result)) {
                        $other_grade_result = $this->db->where($where_arr4)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();
                    }

                    if (!empty($other_grade_result)) {

                        foreach ($other_grade_result as $row) {
                            if ($rowValue['ram'] == $row['ram']) {
                                $exact_ram_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "price" => $row['price']
                                );
                            }

                            if ($rowValue['rom'] == $row['rom']) {
                                $exact_rom_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "price" => $row['price']
                                );
                            }

                            $closest = null;
                            if ($closest === null || abs(chop($rowValue['ram'], 'GB'),  -chop($closest, 'GB')) > abs(chop($closest, 'GB'),  -chop($rowValue['ram'], 'GB'))) {
                                $closest = $rowValue['ram'];
                                $closest_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "price" => $row['price']
                                );
                            }
                        }

                        if (!empty($exact_ram_match)) {

                            $closest_variant = $exact_ram_match;
                        } else if (!empty($exact_rom_match)) {
                            $closest_variant = $exact_rom_match;
                        } else if (!empty($closest_match)) {
                            $closest_variant = $closest_match;
                        }
                    }

                    if (!empty($closest_variant)) {
                        $this->db->where(array("ram" => $rowValue['ram'], "adjust_ram" => $closest_variant['ram']));
                        $adjsut_ram_amount = $this->db->get('tbl_valuation_ram_conversion')->row()->adjust_amount;

                        $this->db->where(array("rom" => $rowValue['rom'], "adjustrom" => $closest_variant['rom']));
                        $adjsut_rom_amount = $this->db->get('tbl_valuation_rom_conversion')->row()->adjust_amount;

                        $origin = date_create($valuation_date);
                        $target = date_create($other_grade_result->CREATION_DATE);
                        $interval = date_diff($origin, $target);
                        $days = $interval->format('%a');

                        if ($procurement_age <= 180) {
                            if ($days <= 180) { //6 months Backwards
                                $nrv = $closest_variant['price'] + $adjsut_rom_amount + $adjsut_ram_amount;
                                $prexo_refurbished_models[] = $search_arr;
                                $prexo_refurbished_nrv[$search_str] = $nrv;
                            }
                        } else {
                            if ($days <= 365) { //12 months Backwards
                                $nrv = $closest_variant['price'] + $adjsut_rom_amount + $adjsut_ram_amount;
                                $prexo_refurbished_models[] = $search_arr;
                                $prexo_refurbished_nrv[$search_str] = $nrv;
                            }
                        }
                    }
                }

                //Different Variant, Different Grade

                if ($nrv == false) {

                    $where_arr5 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "DATE(CREATION_DATE) <=" => $valuation_date,
                    );

                    $where_arr6 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "DATE(CREATION_DATE) >" => $valuation_date
                    );

                    $other_grade_variant_result = $this->db->where($where_arr5)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();

                    if (empty($other_grade_result)) {
                        $other_grade_variant_result = $this->db->where($where_arr6)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();
                    }

                    if (!empty($other_grade_variant_result)) {

                        foreach ($other_grade_variant_result as $row) {

                            if ($rowValue['ram'] == $row['ram']) {
                                $exact_ram_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "certification_grade" => $row['certification_grade'],
                                    "price" => $row['price']
                                );
                            }

                            if ($rowValue['rom'] == $row['rom']) {
                                $exact_rom_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "certification_grade" => $row['certification_grade'],
                                    "price" => $row['price']
                                );
                            }

                            $closest = null;
                            if ($closest === null || abs(chop($rowValue['ram'], 'GB'),  -chop($closest, 'GB')) > abs(chop($closest, 'GB'),  -chop($rowValue['ram'], 'GB'))) {
                                $closest = $rowValue['ram'];
                                $closest_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "certification_grade" => $row['certification_grade'],
                                    "price" => $row['price']
                                );
                            }
                        }

                        if (!empty($exact_ram_match)) {

                            $closest_variant = $exact_ram_match;
                        } else if (!empty($exact_rom_match)) {
                            $closest_variant = $exact_rom_match;
                        } else if (!empty($closest_match)) {
                            $closest_variant = $closest_match;
                        }
                    }

                    if (!empty($closest_variant)) {
                        $this->db->where(array("ram" => $rowValue['ram'], "adjust_ram" => $closest_variant['ram']));
                        $adjsut_ram_amount = $this->db->get('tbl_valuation_ram_conversion')->row()->adjust_amount;

                        $this->db->where(array("rom" => $rowValue['rom'], "adjustrom" => $closest_variant['rom']));
                        $adjsut_rom_amount = $this->db->get('tbl_valuation_rom_conversion')->row()->adjust_amount;


                        if (strtolower($rowValue['brand']) == 'apple') {
                            $brand = 'Apple';
                        } else {
                            $brand = 'Other';
                        }

                        $score_where = array(
                            'model_id' => $closest_variant['nhmod'],
                            "ram" => $closest_variant['ram'],
                            "rom" => $closest_variant['rom'],
                            "brand_type" => $brand
                        );

                        $this->db->select('total_score')->where($score_where);
                        $this->db->join('tbl_pm_pricelist', 'tbl_pm_pricelist.modelvariant_id = tbl_pm_modelvariant.modelvariant_id');
                        $score = $this->db->get('tbl_pm_modelvariant')->row()->total_score();

                        $where_deemed_perc = array(
                            "min_score >=" => $score,
                            "max_score <=" => $score
                        );

                        $deemed_price_perc = $this->db->where($where_deemed_perc)->get('tbl_pm_price_matrix_preowned')->row();

                        if ($closest_variant['certification_grade'] == 'PL-A') {
                            $closest_grade_perc = $deemed_price_perc->sp_seltrue_grade_a;
                        }
                        if ($closest_variant['certification_grade'] == 'PL-B') {
                            $closest_grade_perc = $deemed_price_perc->sp_seltrue_grade_b;
                        }
                        if ($closest_variant['certification_grade'] == 'PL-C') {
                            $closest_grade_perc = $deemed_price_perc->sp_seltrue_grade_c;
                        }
                        if ($closest_variant['certification_grade'] == 'SFF') {
                            $closest_grade_perc = $deemed_price_perc->sp_seltrue_grade_sff;
                        }

                        if ($rowValue['certification_grade'] == 'PL-A') {
                            $required_grade_perc = $deemed_price_perc->sp_seltrue_grade_a;
                        }
                        if ($rowValue['certification_grade'] == 'PL-B') {
                            $required_grade_perc = $deemed_price_perc->sp_seltrue_grade_b;
                        }
                        if ($rowValue['certification_grade'] == 'PL-C') {
                            $required_grade_perc = $deemed_price_perc->sp_seltrue_grade_c;
                        }
                        if ($rowValue['certification_grade'] == 'SFF') {
                            $required_grade_perc = $deemed_price_perc->sp_seltrue_grade_sff;
                        }

                        $grade_adjusted_price = ($closest_variant['price'] * $required_grade_perc) / $closest_grade_perc;


                        $origin = date_create($valuation_date);
                        $target = date_create($other_grade_result->CREATION_DATE);
                        $interval = date_diff($origin, $target);
                        $days = $interval->format('%a');

                        if ($procurement_age <= 180) {
                            if ($days <= 180) { //6 months Backwards
                                $nrv = $grade_adjusted_price + $adjsut_ram_amount + $adjsut_rom_amount;
                                $prexo_refurbished_models[] = $search_arr;
                                $prexo_refurbished_nrv[$search_str] = $nrv;
                            }
                        } else {
                            if ($days <= 365) { //12 months Backwards
                                $nrv = $grade_adjusted_price + $adjsut_ram_amount + $adjsut_rom_amount;
                                $prexo_refurbished_models[] = $search_arr;
                                $prexo_refurbished_nrv[$search_str] = $nrv;
                            }
                        }

                        $prexo_sg_models[] = $search_arr;
                        $prexo_refurbished_nrv[$search_str] = $nrv;
                    }
                }


                if ($nrv == false) {

                    if ($procurement_age <= 180) {
                        if ($rowValue['certification_grade'] == 'PL-A') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.15;
                        }
                        if ($rowValue['certification_grade'] == 'PL-B') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.12;
                        }
                        if ($rowValue['certification_grade'] == 'PL-C') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.08;
                        }
                        $prexo_sg_models[] = $search_arr;
                        $prexo_refurbished_nrv[$search_str] = $nrv;
                    } else {

                        $network = $this->db->select('network_desc')->where('nhmod', $rowValue['nhmod'])->get('tbl_product_details')->row()->network_desc;
                        $network_arr = ['5G', '4G', '3G'];
                        if (!in_array($network, $network_arr)) {
                            $network = '4G';
                        }

                        $procurement_age_in_months = $procurement_age / 30;

                        $discount_where = array(
                            "network" => $network,
                            "category" => 'PRE_OWNED',
                            "from_age >=" => $procurement_age_in_months,
                            "to_age <=" => $procurement_age_in_months,
                        );
                        $discount = $this->db->where($discount_where)->get('tbl_valuation_discount')->row();

                        $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                        $nrv = $cost_price - $cost_price * $discount / 100;
                        $prexo_refurbished_nrv[$search_str] = $nrv;
                    }
                }
            }
            $prexo_refurbished_nrv[$search_str] = $nrv;
        }

        $this->prexo_refurbished = $prexo_refurbished;
    }

    public function getPrexoFaultedValuation()
    {
        $prexo_faulted = $this->prexo_faulted;
        $valuation_date = $this->valuation_date;
        $prexo_ff_models = [];
        $prexo_ff_nrv = array();

        foreach ($prexo_faulted as $key => $rowValue) {
            $nrv = false;

            $search_arr = array(
                "nhmod" => $rowValue['nhmod'],
                "certification_grade" => $rowValue['certification_grade'],
                "ram" => $rowValue['ram'],
                "rom" => $rowValue['rom'],
            );

            $search_str = $rowValue['nhmod'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom'];

            //Get NRV from Sale Price
            if (!in_array($search_arr, $prexo_ff_models)) {

                $nrv = false;
                //Calculate Procurement Age
                $v_date = date_create($valuation_date);
                $inward_date = date_create($rowValue['grn_inwarddate']);
                $age_obj = date_diff($v_date, $inward_date);
                $procurement_age = $age_obj->format('%a');

                $where_arr1 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "procurement_grade" => "D",
                    "date(grn_inwarddate) <=" => $valuation_date
                );

                $result1 = $this->db->where($where_arr1)->order_by('grnreport_id', 'DESC')->get('tbl_grnreport')->row();

                if (!empty($result1)) {
                    if ($procurement_age <= 180) {
                        $nrv = ($result1->unit_price + $result1->unit_price_tax) * 0.9;
                    } else {
                        $nrv = ($result1->unit_price + $result1->unit_price_tax) * 0.6;
                    }
                    $prexo_ff_models[] = $search_arr;
                    $prexo_ff_nrv[$search_str] = $nrv;
                }

                if ($nrv == false) {
                    $where_arr2 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "procurement_grade" => "D",
                        "date(grn_inwarddate) <=" => $valuation_date
                    );

                    $result2 = $this->db->where($where_arr2)->order_by('grnreport_id', 'DESC')->get('tbl_grnreport')->row();

                    if (!empty($result2)) {
                        if ($procurement_age <= 180) {
                            $nrv = ($result2->unit_price + $result2->unit_price_tax) * 0.9;
                        } else {
                            $nrv = ($result2->unit_price + $result2->unit_price_tax) * 0.6;
                        }

                        $prexo_ff_models[] = $search_arr;
                        $prexo_ff_nrv[$search_str] = $nrv;
                    }
                }

                if ($nrv == false) {
                    $where_arr3 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "date(grn_inwarddate) <=" => $valuation_date
                    );

                    $result3 = $this->db->where($where_arr3)->order_by('grnreport_id', 'DESC')->get('tbl_grnreport')->row();

                    if (!empty($result3)) {
                        if ($procurement_age <= 180) {
                            $nrv = ($result3->unit_price + $result3->unit_price_tax) * 0.9;
                        } else {
                            $nrv = ($result3->unit_price + $result3->unit_price_tax) * 0.6;
                        }

                        $prexo_ff_models[] = $search_arr;
                        $prexo_ff_nrv[$search_str] = $nrv;
                    }
                }
            }

            $prexo_faulted[$key]['nrv'] = $prexo_ff_nrv[$search_str];
        }

        $this->prexo_faulted = $prexo_faulted;
    }

    public function getOpenBoxUncertifiedValuation()
    {
        $openbox_uncertified = $this->openbox_uncertified;
        $valuation_date = $this->valuation_date;
        $ob_uc_models = [];
        $ob_uc_nrv = array();

        foreach ($openbox_uncertified as $key => $rowValue) {
            $nrv = false;

            //Get NRV from Sale Price
            if (!in_array($rowValue['nhmod'], $ob_uc_models)) {

                //Calculate Procurement Age
                $v_date = date_create($valuation_date);
                $inward_date = date_create($rowValue['grn_inwarddate']);
                $age_item = date_diff($v_date, $inward_date);
                $procurement_age = $age_item->format('%a');

                $where_arr1 = array(
                    'nhmod' => $rowValue['nhmod'],
                    'ram' => $rowValue['ram'],
                    'rom' => $rowValue['rom'],
                    "DATE(CREATION_DATE) <=" => $valuation_date
                );

                $where_arr2 = array(
                    'nhmod' => $rowValue['nhmod'],
                    'ram' => $rowValue['ram'],
                    'rom' => $rowValue['rom'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $backward = $this->db->where($where_arr1)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (!empty($backward)) {

                    $origin = date_create($valuation_date);
                    $target = date_create($backward->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = $backward->price;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = $backward->price;
                        }
                    }
                    $ob_uc_models[] = $rowValue['nhmod'];
                    $ob_uc_nrv[$rowValue['nhmod']] = $nrv;
                }

                if ($nrv == false) { // Check Forward // Same for both Procurement age within six months and prior to six months
                    $forward = $this->db->where($where_arr2)->order_by('CREATION_DATE', 'ASC')->get('INVOICE_ITEM_VIEW')->row();

                    if (!empty($forward)) {
                        $nrv = $forward->price;
                        $ob_uc_models[] = $rowValue['nhmod'];
                        $ob_uc_nrv[$rowValue['nhmod']] = $nrv;
                    }
                }

                if ($nrv == false) { //Non-moving Models
                    if ($procurement_age <= 180) {
                        $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                        $nrv = $cost_price + $cost_price * 5 / 100;
                        $ob_uc_models[] = $rowValue['nhmod'];
                        $ob_uc_nrv[$rowValue['nhmod']] = $nrv;
                    }
                }
            }

            if ($nrv == false) {

                $network = $this->db->select('network_desc')->where('nhmod', $rowValue['nhmod'])->get('tbl_product_details')->row()->network_desc;
                $network_arr = ['5G', '4G', '3G'];
                if (!in_array($network, $network_arr)) {
                    $network = '4G';
                }

                $procurement_age_in_months = $procurement_age / 30;
                $stock_subtype = '';
                if ($rowValue['stock_subtype'] == 'CX' || $rowValue['stock_subtype'] == 'CX_DAMAGE') {
                    $stock_subtype = 'CX';
                } else {
                    $stock_subtype = 'OTHER';
                }

                $discount_where = array(
                    "network" => $network,
                    "category" => 'OPEN BOX',
                    "stock_subtype" => $stock_subtype,
                    "from_age >=" => $procurement_age_in_months,
                    "to_age <=" => $procurement_age_in_months,
                );
                $discount = $this->db->where($discount_where)->get('tbl_valuation_discount')->row();

                $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                $nrv = $cost_price - $cost_price * $discount / 100;
                $ob_uc_models[] = $rowValue['nhmod'];
                $ob_uc_nrv[$rowValue['nhmod']] = $nrv;
            }

            $openbox_uncertified[$key]['nrv'] = $ob_uc_nrv[$rowValue['nhmod']];
        }
        $this->openbox_uncertified = $openbox_uncertified;
    }

    public function getOpenBoxRefurbishedValuation()
    {
        $openbox_refurbished = $this->openbox_refurbished;
        $valuation_date = $this->valuation_date;
        $ob_refurbished_models = array();
        $ob_refurbished_nrv = array();

        foreach ($openbox_refurbished as $key => $rowValue) {
            $nrv = false;

            $search_arr = array(
                "nhmod" => $rowValue['nhmod'],
                "certification_grade" => $rowValue['certification_grade'],
                "ram" => $rowValue['ram'],
                "rom" => $rowValue['rom'],
            );

            $search_str = $rowValue['nhmod'] . '-' . $rowValue['ram'] . '-' . $rowValue['rom'] . '-' . $rowValue['certification_grade'];
            //Get NRV from Sale Price
            if (!in_array($search_arr, $ob_refurbished_models)) {

                //Calculate Procurement Age
                $v_date = date_create($valuation_date);
                $inward_date = date_create($rowValue['grn_inwarddate']);
                $age_obj = date_diff($v_date, $inward_date);
                $procurement_age = $age_obj->format('%a');

                $where_arr1 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "certification_grade" => $rowValue['certification_grade'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) <=" => $valuation_date
                );

                $where_arr2 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "certification_grade" => $rowValue['certification_grade'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $backward = $this->db->where($where_arr1)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (!empty($backward)) {

                    $origin = date_create($valuation_date);
                    $target = date_create($backward->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = $backward->price;
                            $ob_refurbished_models[] = $search_arr;
                            $ob_refurbished_nrv[$search_str] = $nrv;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = $backward->price;
                            $ob_refurbished_models[] = $search_arr;
                            $ob_refurbished_nrv[$search_str] = $nrv;
                        }
                    }
                }

                if ($nrv == false) { // Check Forward // Same for both Procurement age within six months and prior to six months
                    $forward = $this->db->where($where_arr2)->order_by('CREATION_DATE', 'ASC')->get('INVOICE_ITEM_VIEW')->row();

                    if (!empty($forward)) {
                        $nrv = $forward->price;
                        $ob_refurbished_models[] = $search_arr;
                        $ob_refurbished_nrv[$search_str] = $nrv;
                    }
                }
            }

            if ($nrv == false) {

                //Non Moving Models

                //Same Variant Other Grades

                $where_arr3 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) <=" => $valuation_date,
                );

                $where_arr4 = array(
                    'nhmod' => $rowValue['nhmod'],
                    "ram" => $rowValue['ram'],
                    "rom" => $rowValue['rom'],
                    "DATE(CREATION_DATE) >" => $valuation_date
                );

                $other_grade_result = $this->db->where($where_arr3)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if (empty($other_grade_result)) {
                    $other_grade_result = $this->db->where($where_arr4)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();
                }

                if (!empty($other_grade_result)) {
                    if (strtolower($rowValue['brand']) == 'apple') {
                        $brand = 'Apple';
                    } else {
                        $brand = 'Others';
                    }
                    $score_where = array(
                        'model_id' => $rowValue['nhmod'],
                        "ram" => $rowValue['ram'],
                        "rom" => $rowValue['rom'],
                        "brand_type" => $brand
                    );

                    $this->db->select('total_score')->where($score_where);
                    $this->db->join('tbl_pm_pricelist', 'tbl_pm_pricelist.modelvariant_id = tbl_pm_modelvariant.modelvariant_id');
                    $score = $this->db->get('tbl_pm_modelvariant')->row()->total_score();

                    $where_deemed_perc = array(
                        "min_score >=" => $score,
                        "max_score <=" => $score,
                        "brand_type" => $brand
                    );

                    $price_perc = $this->db->where($where_deemed_perc)->get('tbl_pm_price_matrix_openbox')->row();
                    $sp_grade = $other_grade_result->certification_grade;

                    if ($rowValue['certification_grade'] == 'NFF-A') {
                        $this_grade_perc = $price_perc->sp_seltrue_grade_a;
                        $this_grade_discount_amount = 0;
                        $this_grade_markup_amount = 0;
                    } else {

                        $nff_a_price = ($other_grade_result->price * $price_perc->sp_seltrue_grade_a) / 100;

                        if ($rowValue['certification_grade'] == 'NFF-A1') {
                            $this_grade = 'A1';
                        }
                        if ($rowValue['certification_grade'] == 'NFF-B') {
                            $this_grade = 'B';
                        }
                        if ($rowValue['certification_grade'] == 'NFF-C') {
                            $this_grade = 'C';
                        }
                        if ($rowValue['certification_grade'] == 'SFF') {
                            $this_grade = 'WO';
                        }

                        $brand_res = $this->db->where('brand', $rowValue['brand'])->get('tbl_pm_markup_discount_ob')->row();

                        if (empty($brand_res)) {
                            $brand_name = 'Other';
                        } else {
                            $brand_name = $rowValue['brand'];
                        }
                        $where_markup_discount = array(
                            "min_price >=" => $nff_a_price,
                            "max_price <=" => $nff_a_price,
                            "brand" => $brand_name,
                            "grade" => $this_grade
                        );

                        $markup_discount_row = $this->db->where($where_markup_discount)->get('tbl_pm_markup_discount_ob')->row();

                        $this_grade_discount_amount = $markup_discount_row->discount_price;
                        $this_grade_markup_amount = $markup_discount_row->markup_price;
                    }

                    $origin = date_create($valuation_date);
                    $target = date_create($other_grade_result->CREATION_DATE);
                    $interval = date_diff($origin, $target);
                    $days = $interval->format('%a');

                    if ($procurement_age <= 180) {
                        if ($days <= 180) { //6 months Backwards
                            $nrv = ($other_grade_result->price * $this_grade_perc) / 100;
                            $nrv = $nrv + $this_grade_markup_amount - $this_grade_discount_amount;
                            $ob_refurbished_models[] = $search_arr;
                            $ob_refurbished_nrv[$search_str] = $nrv;
                        }
                    } else {
                        if ($days <= 365) { //12 months Backwards
                            $nrv = ($other_grade_result->price * $this_grade_perc) / 100;
                            $nrv = $nrv + $this_grade_markup_amount - $this_grade_discount_amount;
                            $ob_refurbished_models[] = $search_arr;
                            $ob_refurbished_nrv[$search_str] = $nrv;
                        }
                    }
                }

                //Different Variant Same Grade

                if ($nrv == false) {

                    $where_arr3 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "certification_grade" => $rowValue['certification_grade'],
                        "DATE(CREATION_DATE) <=" => $valuation_date,
                    );

                    $where_arr4 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "certification_grade" => $rowValue['certification_grade'],
                        "DATE(CREATION_DATE) >" => $valuation_date
                    );

                    $other_grade_result = $this->db->where($where_arr3)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();

                    if (empty($other_grade_result)) {
                        $other_grade_result = $this->db->where($where_arr4)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();
                    }

                    if (!empty($other_grade_result)) {

                        foreach ($other_grade_result as $row) {
                            if ($rowValue['ram'] == $row['ram']) {
                                $exact_ram_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "price" => $row['price']
                                );
                            }

                            if ($rowValue['rom'] == $row['rom']) {
                                $exact_rom_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "price" => $row['price']
                                );
                            }

                            $closest = null;
                            if ($closest === null || abs(chop($rowValue['ram'], 'GB'),  -chop($closest, 'GB')) > abs(chop($closest, 'GB'),  -chop($rowValue['ram'], 'GB'))) {
                                $closest = $rowValue['ram'];
                                $closest_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "price" => $row['price']
                                );
                            }
                        }

                        if (!empty($exact_ram_match)) {

                            $closest_variant = $exact_ram_match;
                        } else if (!empty($exact_rom_match)) {
                            $closest_variant = $exact_rom_match;
                        } else if (!empty($closest_match)) {
                            $closest_variant = $closest_match;
                        }
                    }

                    if (!empty($closest_variant)) {
                        $this->db->where(array("ram" => $rowValue['ram'], "adjust_ram" => $closest_variant['ram']));
                        $adjsut_ram_amount = $this->db->get('tbl_valuation_ram_conversion')->row()->adjust_amount;

                        $this->db->where(array("rom" => $rowValue['rom'], "adjustrom" => $closest_variant['rom']));
                        $adjsut_rom_amount = $this->db->get('tbl_valuation_rom_conversion')->row()->adjust_amount;

                        $origin = date_create($valuation_date);
                        $target = date_create($other_grade_result->CREATION_DATE);
                        $interval = date_diff($origin, $target);
                        $days = $interval->format('%a');

                        if ($procurement_age <= 180) {
                            if ($days <= 180) { //6 months Backwards
                                $nrv = $closest_variant['price'] + $adjsut_rom_amount + $adjsut_ram_amount;
                                $ob_refurbished_models[] = $search_arr;
                                $ob_refurbished_nrv[$search_str] = $nrv;
                            }
                        } else {
                            if ($days <= 365) { //12 months Backwards
                                $nrv = $closest_variant['price'] + $adjsut_rom_amount + $adjsut_ram_amount;
                                $ob_refurbished_models[] = $search_arr;
                                $ob_refurbished_nrv[$search_str] = $nrv;
                            }
                        }
                    }
                }

                //Different Variant, Different Grade

                if ($nrv == false) {

                    $where_arr5 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "DATE(CREATION_DATE) <=" => $valuation_date,
                    );

                    $where_arr6 = array(
                        'nhmod' => $rowValue['nhmod'],
                        "DATE(CREATION_DATE) >" => $valuation_date
                    );

                    $other_grade_variant_result = $this->db->where($where_arr5)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();

                    if (empty($other_grade_result)) {
                        $other_grade_variant_result = $this->db->where($where_arr6)->group_by('nhmod, ram, rom')->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->result_array();
                    }

                    if (!empty($other_grade_variant_result)) {

                        foreach ($other_grade_variant_result as $row) {

                            if ($rowValue['ram'] == $row['ram']) {
                                $exact_ram_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "certification_grade" => $row['certification_grade'],
                                    "price" => $row['price']
                                );
                            }

                            if ($rowValue['rom'] == $row['rom']) {
                                $exact_rom_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "certification_grade" => $row['certification_grade'],
                                    "price" => $row['price']
                                );
                            }

                            $closest = null;
                            if ($closest === null || abs(chop($rowValue['ram'], 'GB'),  -chop($closest, 'GB')) > abs(chop($closest, 'GB'),  -chop($rowValue['ram'], 'GB'))) {
                                $closest = $rowValue['ram'];
                                $closest_match = array(
                                    "ram" => $row['ram'],
                                    "rom" => $row['rom'],
                                    "certification_grade" => $row['certification_grade'],
                                    "price" => $row['price']
                                );
                            }
                        }

                        if (!empty($exact_ram_match)) {

                            $closest_variant = $exact_ram_match;
                        } else if (!empty($exact_rom_match)) {
                            $closest_variant = $exact_rom_match;
                        } else if (!empty($closest_match)) {
                            $closest_variant = $closest_match;
                        }
                    }

                    if (!empty($closest_variant)) {

                        $this->db->where(array("ram" => $rowValue['ram'], "adjust_ram" => $closest_variant['ram']));
                        $adjsut_ram_amount = $this->db->get('tbl_valuation_ram_conversion')->row()->adjust_amount;

                        $this->db->where(array("rom" => $rowValue['rom'], "adjustrom" => $closest_variant['rom']));
                        $adjsut_rom_amount = $this->db->get('tbl_valuation_rom_conversion')->row()->adjust_amount;


                        if (strtolower($rowValue['brand']) == 'apple') {
                            $brand = 'Apple';
                        } else {
                            $brand = 'Other';
                        }

                        $score_where = array(
                            'model_id' => $closest_variant['nhmod'],
                            "ram" => $closest_variant['ram'],
                            "rom" => $closest_variant['rom'],
                            "brand_type" => $brand
                        );

                        $this->db->select('total_score')->where($score_where);
                        $this->db->join('tbl_pm_pricelist', 'tbl_pm_pricelist.modelvariant_id = tbl_pm_modelvariant.modelvariant_id');
                        $score = $this->db->get('model_id')->row()->total_score();

                        $where_deemed_perc = array(
                            "min_score >=" => $score,
                            "max_score <=" => $score,
                            "brand_type" => $brand
                        );

                        $price_perc = $this->db->where($where_deemed_perc)->get('tbl_pm_price_matrix_openbox')->row();
                        $sp_grade = $other_grade_result->certification_grade;

                        if ($rowValue['certification_grade'] == 'NFF-A') {
                            $this_grade_perc = $price_perc->sp_seltrue_grade_a;
                            $this_grade_discount_amount = 0;
                            $this_grade_markup_amount = 0;
                        } else {

                            $nff_a_price = ($other_grade_result->price * $price_perc->sp_seltrue_grade_a) / 100;

                            if ($rowValue['certification_grade'] == 'NFF-A1') {
                                $this_grade = 'A1';
                            }
                            if ($rowValue['certification_grade'] == 'NFF-B') {
                                $this_grade = 'B';
                            }
                            if ($rowValue['certification_grade'] == 'NFF-C') {
                                $this_grade = 'C';
                            }
                            if ($rowValue['certification_grade'] == 'SFF') {
                                $this_grade = 'WO';
                            }

                            $brand_res = $this->db->where('brand', $rowValue['brand'])->get('tbl_pm_markup_discount_ob')->row();

                            if (empty($brand_res)) {
                                $brand_name = 'Other';
                            } else {
                                $brand_name = $rowValue['brand'];
                            }
                            $where_markup_discount = array(
                                "min_price >=" => $nff_a_price,
                                "max_price <=" => $nff_a_price,
                                "brand" => $brand_name,
                                "grade" => $this_grade
                            );

                            $markup_discount_row = $this->db->where($where_markup_discount)->get('tbl_pm_markup_discount_ob')->row();

                            $this_grade_discount_amount = $markup_discount_row->discount_price;
                            $this_grade_markup_amount = $markup_discount_row->markup_price;
                        }

                        $origin = date_create($valuation_date);
                        $target = date_create($other_grade_result->CREATION_DATE);
                        $interval = date_diff($origin, $target);
                        $days = $interval->format('%a');

                        if ($procurement_age <= 180) {
                            if ($days <= 180) { //6 months Backwards
                                $nrv = $nff_a_price + $adjsut_ram_amount + $adjsut_rom_amount + $this_grade_markup_amount - $this_grade_discount_amount;
                                $ob_refurbished_models[] = $search_arr;
                                $ob_refurbished_nrv[$search_str] = $nrv;
                            }
                        } else {
                            if ($days <= 365) { //12 months Backwards
                                $nrv = $nff_a_price + $adjsut_ram_amount + $adjsut_rom_amount + $this_grade_markup_amount - $this_grade_discount_amount;
                                $ob_refurbished_models[] = $search_arr;
                                $ob_refurbished_nrv[$search_str] = $nrv;
                            }
                        }

                        $ob_refurbished_models[] = $search_arr;
                        $ob_refurbished_nrv[$search_str] = $nrv;
                    }
                }

                if ($nrv == false) {

                    if ($procurement_age <= 180) {
                        if ($rowValue['certification_grade'] == 'NFF-A1') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.15;
                        }
                        if ($rowValue['certification_grade'] == 'NFF-A') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.12;
                        }
                        if ($rowValue['certification_grade'] == 'NFF-B') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.08;
                        }
                        if ($rowValue['certification_grade'] == 'SFF') {
                            $nrv = ($rowValue['unit_price'] + $rowValue['unit_price']) * 1.08;
                        }

                        $ob_refurbished_models[] = $search_arr;
                        $ob_refurbished_nrv[$search_str] = $nrv;
                    } else {

                        $network = $this->db->select('network_desc')->where('nhmod', $rowValue['nhmod'])->get('tbl_product_details')->row()->network_desc;
                        $network_arr = ['5G', '4G', '3G'];
                        if (!in_array($network, $network_arr)) {
                            $network = '4G';
                        }

                        $procurement_age_in_months = $procurement_age / 30;

                        $discount_where = array(
                            "network" => $network,
                            "category" => 'PRE_OWNED',
                            "from_age >=" => $procurement_age_in_months,
                            "to_age <=" => $procurement_age_in_months,
                        );
                        $discount = $this->db->where($discount_where)->get('tbl_valuation_discount')->row();

                        $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

                        $nrv = $cost_price - $cost_price * $discount / 100;
                        $ob_refurbished_models[] = $search_arr;
                        $ob_refurbished_nrv[$search_str] = $nrv;
                    }
                }
            }

            $openbox_refurbished[$key]['nrv'] = $ob_refurbished_nrv[$search_str];
        }

        $this->openbox_uncertified = $openbox_refurbished;
    }

    public function getOpenBoxFaulted()
    {

        $openbox_faulted = $this->openbox_faulted;
        $valuation_date = $this->valuation_date;

        foreach ($openbox_faulted as $key => $rowValue) {
            $nrv = false;
            $cost_price = $rowValue['unit_price'] + $rowValue['unit_price_tax'];

            //Calculate Procurement Age
            $v_date = date_create($valuation_date);
            $inward_date = date_create($rowValue['grn_inwarddate']);
            $age_obj = date_diff($v_date, $inward_date);
            $procurement_age = $age_obj->format('%a');

            if ($procurement_age <= 180) {
                $nrv = $cost_price * 0.8;
            } else {
                $nrv = $cost_price * 0.5;
            }

            $openbox_faulted[$key]['nrv'] = $nrv;
        }
        $this->openbox_faulted = $openbox_faulted;
    }

    public function getObBER()
    {
        $openbox_ber = $this->openbox_ber;
        $valuation_date = $this->valuation_date;
        $ob_ber_models = array();
        $ob_ber_nrv = array();

        foreach ($openbox_ber as $key => $rowValue) {
            $nrv = false;
            $where = array(
                "nhmod" => $rowValue['nhmod'],
                "procurement_grade" => "NFF-C",
                "date(CREATION_DATE)<=" => $valuation_date
            );

            if (!in_array($ob_ber_models, $rowValue['nhmod'])) {

                $result = $this->db->where($where)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if ($result->price >= 10000) {
                    $nrv = 500;
                } else if ($result->price >= 5000) {
                    $nrv = 300;
                } else {
                    $nrv = 200;
                }

                $ob_ber_models[] = $rowValue['nhmod'];
                $ob_ber_nrv[$rowValue['nhmod']] = $nrv;
            }

            $openbox_ber[$key]['nrv'] = $nrv;
        }

        $this->openbox_ber = $openbox_ber;
    }

    public function getPrexoBER()
    {
        $prexo_ber = $this->prexo_ber;
        $valuation_date = $this->valuation_date;
        $prexo_ber_models = array();
        $prexo_ber_nrv = array();

        foreach ($prexo_ber as $key => $rowValue) {
            $nrv = false;
            $where = array(
                "nhmod" => $rowValue['nhmod'],
                "procurement_grade" => "NFF-C",
                "date(CREATION_DATE)<=" => $valuation_date
            );

            if (!in_array($prexo_ber_models, $rowValue['nhmod'])) {

                $result = $this->db->where($where)->order_by('CREATION_DATE', 'DESC')->get('INVOICE_ITEM_VIEW')->row();

                if ($result->price >= 10000) {
                    $nrv = 500;
                } else if ($result->price >= 5000) {
                    $nrv = 300;
                } else {
                    $nrv = 200;
                }

                $prexo_ber_models[] = $rowValue['nhmod'];
                $prexo_ber_nrv[$rowValue['nhmod']] = $nrv;
            }

            $openbox_ber[$key]['nrv'] = $nrv;
        }

        $this->prexo_ber = $prexo_ber;
    }

    public function getPrexoX()
    {
        $prexo_x = $this->prexo_x;
        $valuation_date = $this->valuation_date;

        foreach ($prexo_x as $key => $rowValue) {
            $prexo_x[$key]['nrv'] = 10;
        }
        $this->prexo_x = $prexo_x;
    }

    public function getObX()
    {
        $openbox_x = $this->openbox_x;
        $valuation_date = $this->valuation_date;

        foreach ($openbox_x as $key => $rowValue) {
            $openbox_x[$key]['nrv'] = 10;
        }

        $this->openbox_x = $openbox_x;
    }

    function getAvailableInventory()
    {
        $inventory_date = $this->input->get('inventory_date');
        $valuation_date = date('Y-m-d', strtotime($inventory_date));
        $inventory_criteria = $this->input->get('inventory_criteria');
        if ($valuation_date == '' || $valuation_date == '1970-01-01' || $valuation_date == '0000-00-00') {
            http_response_code(500);
            die('Valuation Date is required');
        }

        if ($inventory_criteria == 'invoice_date') {
            $this->db->where('DATE(invoice_date)<=', $valuation_date);
        } else {
            $this->db->where('DATE(grn_inwarddate)<=', $valuation_date);
        }
	// Nagireddy newly added code

        $status_arr = array("RTV","SOLD");
        $purchased_inventory = $this->db->select('nhdin, status')->where_not_in('status',$status_arr)->get('tbl_grnreport')->result_array();
        // End

        //$purchased_inventory = $this->db->select('nhdin, status')->where('status != "RTV"')->get('tbl_grnreport')->result_array();
        
        $sold_inventory = $this->db->select('device_id as nhdin, CREATION_DATE')->where('DATE(CREATION_DATE)<=', $valuation_date)->where('status != "VOID"')->get('INVOICE_ITEM_AUDIT_VIEW')->result_array();

        $where_st_out = array(
            "DATE(stocktransfer_date)<=" => $valuation_date,
            "st_type" => "OUTWARD"
        );
        $stock_outward_inventory = $this->db->select('nhdin, stocktransfer_date')->where($where_st_out)->get('STN_INVENTORY_VIEW')->result_array();

        $where_st_in = array(
            "DATE(received_date)<=" => $valuation_date,
            "st_type" => "INWARD"
        );
	
        $stock_inward_inventory = $this->db->select('nhdin, received_date')->where($where_st_in)->get('STN_INVENTORY_VIEW')->result_array();

        $return_inventory = $this->db->select('device_id as nhdin, returned_date, reason_for_return, product_condition')->where('status not in ("CANCELLED", "VOID", "LOST IN TRANSIT", "CANCEL")')->where('DATE(returned_date)<=', $valuation_date)->get('SALESRETURN_EXPORT_VIEW')->result_array();

        $purchase_return = $this->db->select('creation_date, nhdin')->join('tbl_purchase_return', 'tbl_purchase_return.purchase_return_id = PURCHASE_RETURN_ITEM_VIEW.purchase_return_id', 'Left')->where('tbl_purchase_return.creation_date<=', $valuation_date)->get('PURCHASE_RETURN_ITEM_VIEW')->result_array();

        $effective_inventory = array();
        $total_inventory = array();
        $lost_inventory = array();
        if (!empty($purchased_inventory)) {
            foreach ($purchased_inventory as $key => $rowValue) {
                $effective_inventory[] = $rowValue['nhdin'];
                $total_inventory[] = $rowValue['nhdin'];
                if ($rowValue['status'] == 'LOST') {
                    $lost_inventory[] = $rowValue['nhdin'];
                }
            }
        }

        $sold_date = array();
        if (!empty($sold_inventory)) {
            foreach ($sold_inventory as $key => $rowValue) {
                $sold_ids[] = $rowValue['nhdin'];
                if (empty($sold_date[$rowValue['nhdin']])) {
                    $sold_date[$rowValue['nhdin']] = $rowValue['CREATION_DATE'];
                } else {
                    if (strtotime($rowValue['CREATION_DATE']) > strtotime($sold_date[$rowValue['nhdin']])) {
                        $sold_date[$rowValue['nhdin']] = $rowValue['CREATION_DATE'];
                    }
                }
            }
        }

        if(!empty($sold_ids)){
            $effective_inventory = array_diff($effective_inventory, $sold_ids);
        }

        $stocktransfer_date = array();
        if (!empty($stock_outward_inventory)) {
            foreach ($stock_outward_inventory as $key => $rowValue) {
                $stocktransfer_date[$rowValue['nhdin']] = $rowValue['stocktransfer_date'];
                if (empty($stocktransfer_date[$rowValue['nhdin']])) {
                    $stocktransfer_date[$rowValue['nhdin']] = $rowValue['stocktransfer_date'];
                } else {

                    if (strtotime($rowValue['stocktransfer_date']) > strtotime($stocktransfer_date[$rowValue['nhdin']])) {
                        $stocktransfer_date[$rowValue['nhdin']] = $rowValue['stocktransfer_date'];
                    }
                }
                $stocktransfer_out_ids[] = $rowValue['nhdin'];
            }
        }
        
        if(!empty($stocktransfer_out_ids)){
            $effective_inventory = array_diff($effective_inventory, $stocktransfer_out_ids);
        }
        
        $purchase_return_ids = array();
        $purchase_return_date = array();
        if (!empty($purchase_return)) {
            foreach ($purchase_return as $key => $rowValue) {
                $purchase_return_ids[] = $rowValue['nhdin'];
                $purchase_return_date[$rowValue['nhdin']] = $rowValue['creation_date'];
            }
        }

        // Stock Transfer Inward
        $inward_count = 0;
        if (!empty($stock_inward_inventory)) {
            foreach ($stock_inward_inventory as $key => $rowValue) {

                if (!empty($sold_date[$rowValue['nhdin']])) {

                    if (strtotime($sold_date[$rowValue['nhdin']]) > strtotime($rowValue['received_date'])) {
                        continue;
                    }
                }
                if (!empty($purchase_return_date[$rowValue['nhdin']])) {
                    if (strtotime($purchase_return_date[$rowValue['nhdin']]) > strtotime($rowValue['received_date'])) {
                        continue;
                    }
                }

                if ($stocktransfer_date[$rowValue['nhdin']] < $rowValue['received_date']) {
                    $effective_inventory[] = $rowValue['nhdin'];
                    $total_inventory[] = $rowValue['nhdin'];
                    $inward_count++;
                }
            }
        }

        //Return Devices
        $condition_arr = ["LOST IN TRANSIT", "MODEL MISMATCH", "DIFFERENT ITEM", "EMPTY/TRASH", "FAKE/DUMMY"];
        if (!empty($return_inventory)) {
            foreach ($return_inventory as $key => $rowValue) {

                if (!empty($sold_date[$rowValue['nhdin']])) {
                    // if (in_array($rowValue['reason_for_return'], $condition_arr)) {
                    //     continue;
                    // }

                    if (in_array($rowValue['product_condition'], $condition_arr)) {
                        if (in_array($rowValue['nhdin'], $lost_inventory)) {
                            continue;
                        }
                    }

                    if (!empty($stocktransfer_date[$rowValue['nhdin']])) {
                        if (strtotime($stocktransfer_date[$rowValue['nhdin']]) > strtotime($rowValue['returned_date'])) {
                            continue;
                        }
                    }

                    if (!empty($purchase_return_date[$rowValue['nhdin']])) {
                        if (strtotime($purchase_return_date[$rowValue['nhdin']]) > strtotime($rowValue['returned_date'])) {
                            continue;
                        }
                    }

                    if (strtotime($sold_date[$rowValue['nhdin']]) < strtotime($rowValue['returned_date'])) {
                        $effective_inventory[] = $rowValue['nhdin'];
                    }
                }
            }
        }

        $effective_inventory = array_unique($effective_inventory);
	
        //$result_inventory = $this->db->where_in('nhdin', $effective_inventory)->get('tbl_grnreport')->result_array();
	$result_inventory = $this->db->where_in('nhdin', $effective_inventory)->get('INVENTORY_EVALUTION_REPORT_VIEW')->result_array();
	
        $csv_output = '';
        $csv_output .= "Device Id, Product Type, Brand Name, Device Name,RAM,ROM,SKU,Device Status, IMEI1 NO, IME2 No, Category, Sale Type, WSN No, Invoice No,";
        $csv_output .= "Invoice Date, Bin No, Batch No, Procurement Grade, Certification Grade, VRP No, Remark, Inward date, Age in Days, Warehouse, Unit Price, Unit Price Tax, Total Price,Sale Invoice Date, Sale Invoice Code,Outward Date, Sale Price, Exempt Amount, Taxble Amount, Tax, Sale Invoice Status\n";
        
	foreach ($result_inventory as $rowValue) {
		
	    if($rowValue['status'] == "LOST"){
		$td_status = "CLAIM";
		} else{
		$td_status = $rowValue['status'];
	    }
	    if(date("d-m-Y", strtotime($rowValue['sale_date'])) == "01-01-1970"){
		$sale_date = "";
	    } else{
		$sale_date = date("d-m-Y", strtotime($rowValue['sale_date']));
	    }
	    if(date("d-m-Y", strtotime($rowValue['outward_date'])) == "01-01-1970"){
		$outward_date = "";
	    } else{
		$outward_date = date("d-m-Y", strtotime($rowValue['outward_date']));
	    }
	    $csv_output .= $rowValue['nhdin'] . ',';
	    $csv_output .= $rowValue['product_type'] . ',';
            $csv_output .= $rowValue['product_brand'] . ',';
            $csv_output .= $rowValue['device_name'] . ',';
            $csv_output .= $rowValue['ram'] . ',';
            $csv_output .= $rowValue['rom'] . ',';
            $csv_output .= $rowValue['SKU'] . ',';
            //$csv_output .= $rowValue['status'] . ',';
	    $csv_output .= $td_status . ',';
            $csv_output .= $rowValue['imei1_no'] . ',';
            $csv_output .= $rowValue['imei2_no'] . ',';
            $csv_output .= $rowValue['stock_type'] . ',';
            $csv_output .= $rowValue['saletype'] . ',';
            $csv_output .= $rowValue['othervendor_id'] . ',';
            $csv_output .= $rowValue['invoice_no'] . ',';
            $csv_output .= date("d-m-Y", strtotime($rowValue['invoice_date'])) . ',';
            $csv_output .= str_replace([",", "\r\n", "\n", "\r"], ' ', $rowValue['bin_number']) . ',';
            $csv_output .= $rowValue['batch_no'] . ',';
            $csv_output .= $rowValue['procurement_grade'] . ',';
            $csv_output .= $rowValue['certification_grade'] . ',';
            $csv_output .= $rowValue['lot_number'] . ',';
            $csv_output .= str_replace([",", "\r\n", "\n", "\r"], ' ', $rowValue['remark']) . ",";
            $csv_output .= date("d-m-Y", strtotime($rowValue['grn_inwarddate'])) . ',';
            $csv_output .= floor((strtotime($valuation_date) - strtotime($rowValue['grn_inwarddate'])) / 86400) . ',';
            $csv_output .= $rowValue['warehouse'] . ',';
            $csv_output .= $rowValue['unit_price'] . ',';
            $csv_output .= $rowValue['unit_price_tax'] . ',';
            $csv_output .= ($rowValue['unit_price'] + $rowValue['unit_price_tax']) . ',';
	    //$csv_output .= $rowValue['warehouse'] . ',';
	    $csv_output .= $sale_date . ',';
	    $csv_output .= $rowValue['invoice_code'] . ',';
	    $csv_output .= $outward_date . ',';
	    $csv_output .= $rowValue['sale_price'] . ',';
	    $csv_output .= $rowValue['exempt_amount'] . ',';
	    $csv_output .= $rowValue['taxable_amount'] . ',';
	    $csv_output .= $rowValue['tax_amount'] . ',';
	    $csv_output .= $rowValue['invoice_status'] . ',';
	    $csv_output .= "\n";
        }

        $filename = "Inventory" . "_" . date("Y-m-d_H-i", time());
        header("Content-type: application/csv");
        header("Content-disposition: csv" . date("Y-m-d") . ".csv");
        header("Content-disposition: filename=" . $filename . ".csv;");
        print $csv_output;
        exit;
    }
}
