<?php

/**
 * Description of client
 *
 * @author NaYeM
 */
 
 

/// recived_store=1 if pending order move to recived store but by default is 0

/// inward_pending=1 when any order create in grn report but by default is 0

/// inward_pending=2 when any order create in grn report and this order move to store

/// movestoreuser_id=whose user working on grnreport module
	  
	  
class Finance extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct(); 
		$this->load->model('api_model');
    }

    public function create_invoice($active = 0)
    {  
		$salesorderdets=$this->input->post();
		if(!empty($salesorderdets['salesorder_id'])){
			$this->load->model('SalesOrder_model');
			
			$result=$this->SalesOrder_model->get_salesorder_row($salesorderdets['salesorder_id']);
			
			$quantity=$this->SalesOrder_model->get_salesorder_quantity($salesorderdets['salesorder_id']);
			
			$sod = $this->db->select('sum(quantity) as total_qty, sum(amount) as total_amount')->where('salesorder_id',$salesorderdets['salesorder_id'])->group_by('salesorder_id')->get('tbl_salesorder_item')->row();
			
			if(!empty($result)){
				$data['salesorder_id'] = $result[0]['salesorder_id'];
				$data['salesorder_code'] = $result[0]['salesorder_code'];
				$data['vendor_name'] = $result[0]['vendor_name'];
				$data['salesman_name'] = $result[0]['fullname'];
				$data['warehouse'] = $result[0]['warehouse'];
				$data['payment_mode'] = strtoupper($result[0]['payment_mode']);
				$data['sales_channel'] = $result[0]['sales_channel'];
				$data['saleschannel_ref_id'] = $result[0]['saleschannel_ref_id'];
				$data['sales_code'] = $result[0]['sales_code']; //salesman code
				$data['discount_amount'] = $result[0]['discount_amount']; 
				$data['freight_amount'] = $result[0]['freight_amount']; 
				$data['insurance_amount'] = $result[0]['insurance_amount']; 
				$data['tcs_amount'] = $result[0]['tcs_amount']; 
				
				$vendor_details = $this->SalesOrder_model->getVendorDetails($result[0]['vendor_id']);
				$data['vendor_details'] = $vendor_details;
				$data['so_total_amount'] = $sod->total_amount;
				$data['so_total_qty'] = $sod->total_qty;
			}

			$data['quantity']=$quantity;
			
		}
		$data['active'] = 2;
		
		/*WORK FOR UPDATE INVOICE==*/
		
		if($active>0){
			$data['active'] = $active;
		}
		
		$data['excelResult']=array();
		
        $data['title'] = lang('credit_invoice'); //Page title
		
        $data['page'] = "manage_finance";  
		
        $data['subview'] = $this->load->view('admin/finance/manage_finance', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}
	
	public function invoice_list(){
		$data['title'] = 'Invoice List'; //Page title
		
		$data['page'] = "manage_finance";  

		$data['active']=4;
		
        $data['subview'] = $this->load->view('admin/finance/manage_finance', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
	}

	
	public function invoice_details()
    {  
		
		$data['active'] = 1;
		  
        $data['title'] = lang('invoice_details'); //Page title
 
        $data['subview'] = $this->load->view('admin/finance/manage_invoice', $data, TRUE);
		
        $this->load->view('admin/_layout_main', $data); //page load
    }
	
	public function printCreateInvoice()
	{
		
		
		$invoiceId=$_POST['invoiceId']; 
		
		$invoiceResult=$this->db->select('invoice_refno,vendor_code,invoice_code')->where('invoice_id',$invoiceId)->get('tbl_createinvoice')->row_array();  
		
		$vendorCode=$invoiceResult['vendor_code']; 
		
		$invoicecode=$invoiceResult['invoice_code']; 
		
		$relatedInvoiceData=$this->db->select('COUNT(invoice_id) as totalInvoice,SUM(nhsp) as nhsptotal')->where(array('invoice_code'=>$invoicecode,'vendor_code'=>$vendorCode))->get('tbl_createinvoice')->row();

		
		/*==GET OLD INVOICE RESULT IF INVOICE ALREADY GENRATED===*/
		
		$oldInvoiceResult=$this->db->select('outstanding,net_payable,net_receivable,cash,online,card,cheque,total_payment,net_balance_payable')->where('invoice_refno',$invoicecode)->get('tbl_save_invoice')->row();
		
		$cash=0;$online=0;$card=0;$cheque=0;$total_payment=0;
		
		if(!empty($oldInvoiceResult))
		{
			$outstandingAmount=$oldInvoiceResult->outstanding;
			
			$dueAdvancePayment=$oldInvoiceResult->net_receivable;
			
			$netPayable=$oldInvoiceResult->net_payable;
			
			$cash=$oldInvoiceResult->cash;
			
			$online=$oldInvoiceResult->online;
			
			$card=$oldInvoiceResult->card;
			
			$cheque=$oldInvoiceResult->cheque;
			
			$total_payment=$oldInvoiceResult->total_payment;
			
			$net_balance_payable=$oldInvoiceResult->net_balance_payable;
		}
		else
		{
			
			$outstandingAmount=0;$advanceAmount=0;
			
			$getVendorOutstandingAmount=$this->Common_model->getVendorOutstandingAmount($vendorCode);
			
			if($getVendorOutstandingAmount<0)
			{
				$outstandingAmount=0;
				
				$dueAdvancePayment=abs($getVendorOutstandingAmount);
			}
			else
			{
				$outstandingAmount=abs($getVendorOutstandingAmount);
				
				$dueAdvancePayment=0;
			}
 
			$netPayable=($relatedInvoiceData->nhsptotal)+$outstandingAmount-$dueAdvancePayment;
			
			$net_balance_payable=($relatedInvoiceData->nhsptotal)+$outstandingAmount-$dueAdvancePayment;
			
		}
 
		$html='
		 <form action="#" method="post" id="invoiceForm" onsubmit="return addInvoicePayment()">
		 
			<input type="hidden" name="invoice_refno" value="'.$invoicecode.'" />
		 
			<input type="hidden" name="vendor_code" value="'.$vendorCode.'" />
			
			<div class="modal-content" style="padding: 10px;">
				<h4 style="text-align:center">Invoice No:-'.$invoicecode.'</h4>
				<ul class="list-group" style="list-style:none;font-weight:bold">
				<li class="list-group-item">
					<ul class="list-inline">
						<li style="width: 10%;">A)</li>
						<li style="width: 30%;">Invoice Qty</li>
						<li><input type="text" class="form-control"  name="qty" value="'.$relatedInvoiceData->totalInvoice.'" readonly></li>
					</ul>
				</li>
				<li class="list-group-item">
					<ul class="list-inline">
					<li style="width: 10%;">B)</li>
					<li style="width: 30%;">Invoice Amount</li>
					<li><input type="text" class="form-control invoice_amount" name="invoice_amount" value="'.($relatedInvoiceData->nhsptotal).'" readonly ></li>
					</ul>
				</li>  
				<li class="list-group-item">
					<ul class="list-inline">
					<li style="width: 10%;">C)</li>
					<li style="width: 30%;">NET RECEIVABLE</li>
					<li><input type="text" class="form-control advance_payment" name="advance_payment" value="'.str_replace('.00','',$dueAdvancePayment).'" readonly ></li>
					</ul>
				</li>  
				<li class="list-group-item">
					<ul class="list-inline">
					<li style="width: 10%;">D)</li>
					<li style="width: 30%;">PREVIOUS OUTSTANDING</li>
					<li><input type="text" readonly  class="form-control previous_outstanding"  name="previous_outstanding" value="'.str_replace('.00','',$outstandingAmount).'" readonly></li>
					</ul>
				</li>
				<li class="list-group-item">
					<ul class="list-inline">
					<li style="width: 10%;">E)</li>
					<li style="width: 30%;">Net Payable</li>
					<li><input type="text" class="netpayable form-control" readonly value="'.(str_replace('.00','',$netPayable)).'" name="net_payable"   ></li>
					</ul>
				</li>
				</ul>
				<hr style="border-width:medium">
				<ul style="list-style:none;padding: 0px;">
					<li style="width: 40%;text-align: center;float: left;font-weight: bold;">PAYMENT MODE</li>
					<li style="width: 30%;float: left;"><input onchange="hideBreakUpfield()" type="radio" class="payment_mode" checked  name="payment_mode" value="PREPAID"  > PREPAID</li>
					<li><input type="radio" class="payment_mode" onchange="hideBreakUpfield()" name="payment_mode" value="COD"  > COD</li>
				</ul>
				<hr style="border-width:medium">
				<ul style="list-style:none;padding: 0px;text-align: center;">
					<li style="padding: 10px;font-weight: bold;">PAYMENT BREAKUP</li>
					<li>
						<ul class="list-inline" style="display: flex;">
						<li style="width:25%;">CASH</li>
						<li style="width:25%;">ONLINE</li>
						<li style="width:25%;">CARD</li>
						<li style="width:25%;">CHEQUE/DD</li>						
						<li style="width:25%;">TOTAL PAYMENT</li>
						</ul>
					</li>
					<li>
						<ul class="list-inline" style="display: flex;">
						<li style="width:25%;"><input type="text" id="cash" name="cash" onchange="getNetPayableAmount()" onkeypress="return isNumberKey(event)" class="form-control breakup" value="'.str_replace('.00','',$cash).'" ></li>
						<li style="width:25%;"><input type="text" id="online"  name="online" onchange="getNetPayableAmount()" onkeypress="return isNumberKey(event)" class="form-control breakup" value="'.str_replace('.00','',$online).'" ></li>
						<li style="width:25%;"><input type="text" id="card"   name="card" onchange="getNetPayableAmount()" onkeypress="return isNumberKey(event)" class="form-control breakup" value="'.str_replace('.00','',$card).'" ></li>
						<li style="width:25%;"><input type="text" id="cheque"  name="cheque" onchange="getNetPayableAmount()" onkeypress="return isNumberKey(event)" class="form-control breakup" value="'.str_replace('.00','',$cheque).'" ></li>						
						<li style="width:5%;">=</li>
						<li style="width:25%;"><input type="text" id="totalPayment"  name="total_payment" readonly onchange="getNetPayableAmount()" onkeypress="return isNumberKey(event)" class="form-control breakup" value="'.str_replace('.00','',$total_payment).'" ></li>
						</ul>
					</li>
				</ul>
				<ul style="list-style:none;padding: 0px;margin-bottom:10px" >
					<li style="width:40%;float:left;text-align:center">NET BALANCE PAYABLE</li>
					<li style="width:40%;float:left;margin-bottom:4%"><input id="" name="netbalancepayable"  type="text" class="netbalancepayable form-control" value="'.str_replace('.00','',$net_balance_payable).'" readonly></li> 
					<li style="width:50%;position:relative;left:40%;"><input class="btn btn-success"  id="printbtn" type="submit" value="PRINT INVOICE" ></li>
				</ul> 
			</div>
		</form>
		';
		
		$json['msg']='hello';
		$json['html']=$html;
		echo json_encode($json);
		die;
	}
	
	public function printCreateInvoiceData($invoiceCode)
	{    
	
		$data['result']=$this->db->select('created_date,order_id,tax_type,invoice_code,address,mobile,gst,pincode,name,payment_mode,imei,sale_channel,nhdin,vendor_code,state,bill_type,nhsp,nhpp,hsn_code,product_name,invoice_refno')->where('invoice_code',$invoiceCode)->get('tbl_createinvoice')->result_array(); 
 
		if(!empty($data['result']))
		{  
			$this->load->view('admin/finance/pdf_html/invoice_html',$data);
		}
		else
		{
			set_message('error','INVOICE NOT FOUND.PLEASE CHECK.');
			
			redirect($_SERVER['HTTP_REFERER']);
		}
		
	}
	
	public function savePaymentInvoiceData()
	{
		$data=$_POST;
		
		$invoice_code=$data['invoice_refno'];
		
		/*==INSERT ENTRY IN ACCOUNT STATEMENT==*/
		
		$accStat['vendor_code']=$data['vendor_code'];
		
		$accStat['invoice_refno']=$data['invoice_refno']; 
		
		$oldInvoiceResult=$this->db->select('invoice_id,statement_id')->where('invoice_refno',$invoice_code)->get('tbl_save_invoice')->row();
		
		/*==DATA OF INVOICE DATA==*/
 
		$oldInvoice['invoice_refno']=$data['invoice_refno'];
		
		$oldInvoice['qty']=$data['qty'];
		
		$oldInvoice['amount']=$data['invoice_amount'];
		
		$oldInvoice['net_receivable']=$data['advance_payment'];
		
		$oldInvoice['outstanding']=$data['previous_outstanding'];
		
		$oldInvoice['net_payable']=$data['net_payable'];
		
		$oldInvoice['payment_mode']=$data['payment_mode'];
		
		$oldInvoice['cash']=$data['cash'];
		
		$oldInvoice['online']=$data['online'];
		
		$oldInvoice['card']=$data['card'];
		
		$oldInvoice['cheque']=$data['cheque'];
		
		$oldInvoice['total_payment']=$data['total_payment'];
		
		$oldInvoice['net_balance_payable']=$data['netbalancepayable'];
		
		
		/*==DATA OF ACOUNT STATMENT==*/
			
		$accStat['cash']=$data['cash'];
		
		$accStat['online']=$data['online'];
		
		$accStat['cheque']=$data['cheque'];
		
		$accStat['card']=$data['card'];
		
		$accStat['total']=$data['total_payment'];
		
 
		if(!empty($oldInvoiceResult))
		{ 
			if($data['payment_mode']=='PREPAID')
			{
				 $this->db->where('invoice_id',$oldInvoiceResult->invoice_id)->update('tbl_save_invoice',$oldInvoice);
 
				 $this->db->where('payment_id',$oldInvoiceResult->statement_id)->update('tbl_accstatement',$accStat);
			}		
		}
		else
		{
 
			$this->db->insert('tbl_accstatement',$accStat);
			
			$stateInsertId=$this->db->insert_id();
 
			$oldInvoice['statement_id']=$stateInsertId;
				
			$this->db->insert('tbl_save_invoice',$oldInvoice);
		}

		$json['status']='1';
		
		$json['invoice_code']=$invoice_code;
		
		$json['msg']='INVOICE PAYMENT ADDED SUCCESFULLY';
		
		echo json_encode($json);
		die;
	}
	
	public function addTableRow()
	{   
	
		$sno=$_POST['sno'];
		
		$trId=rand();
		$html='
			<tr id="'.$trId.'" class="product_rows">';
				//  <td>
				// 	<select class="form-control sale_channel" required name="sale_channel[]" onchange="getOnlineBuyerCode('."'".$sno."'".'),checkOrderIdRequired('."'".$sno."'".')" id="sale_channel'.$sno.'"> 
				// 		<option value="">CHOOSE SALES CHANNEL</option>
				// 		<option value="EBAY">EBAY</option>
				// 		<option value="UDAAN">UDAAN</option> 
				// 		<option value="YNEW WEB">YNEW WEB</option> 
				// 		<option value="YNEW APP">YNEW APP</option> 
				// 		<option value="SHOP CLUES">SHOP CLUES</option> 
				// 		<option value="FLIPKART">FLIPKART</option> 
				// 		<option value="AMAZON">AMAZON</option> 
				// 		<option value="SNAPDEAL">SNAPDEAL</option> 
				// 		<option value="2GUD">2GUD</option> 
				// 		<option value="OFFLINE">OFFLINE</option> 						
				// 	</select>	
				// </td>
				// <td><input class="form-control" required name="order_id[]" id="order_id'.$sno.'" placeholder="ORDER ID" value="" type="text"></td>
		$html.='	<td><input class="form-control nhdin_cls" required onchange="getDeviceInfoBynhdin('.$sno.')" placeholder="INWARDID" id="nhdin'.$sno.'" name="nhdin[]"  value="" type="text"></td>
				<td><input class="form-control" required placeholder="PRODUCT NAME" id="product_name'.$sno.'"  name="product_name[]" value="" type="text" readonly></td>
				<td><input class="form-control" required placeholder="IMEI" id="imei'.$sno.'" name="imei[]"  value="" type="text" readonly></td>				
				<td><input class="form-control sku_cls" required placeholder="VARIANT" id="variant'.$sno.'" name="variant[]"  value="" type="text" readonly></td>				
				<td><input class="form-control category_cls" required placeholder="CATEGORY" id="category'.$sno.'" name="category[]"  value="" type="text" readonly></td>';			
				// <td><input class="form-control" required placeholder="SLYCOST" id="nhpp'.$sno.'"  name="nhpp[]" value="" type="text"></td>
				// <td><input class="form-control" required onchange="getBothMargin('.$sno.')" onkeypress="return isNumberKey(event)" placeholder="SLYSP" id="nhsp'.$sno.'" name="nhsp[]" value="" type="text"></td>
		$html.=		'<td><input class="form-control input_price" required onkeypress="return isNumberKey(event)" placeholder="PRICE" id="price'.$sno.'" name="price[]" value="" type="text" readonly></td>
				<td><input class="form-control" readonly required onkeypress="return isNumberKey(event)" id="tax_amount'.$sno.'" placeholder="TAX" name="tax_amount[]" value="" type="text" readonly></td>
				<td><input class="form-control" readonly required onkeypress="return isNumberKey(event)" id="rs_margin'.$sno.'" placeholder="MARGIN ( IN RS)" name="rs_margin[]" value="" type="text" readonly></td>
				<td><input class="form-control" readonly required onkeypress="return isNumberKey(event)" id="percent_margin'.$sno.'" placeholder="MARGIN %" name="percent_margin[]" value="" type="text" readonly></td>
				<td>
					<select class="form-control" required name="selling_mode[]" id="selling_mode'.$sno.'" style="pointer-events:none;"> 
						<option value="">CHOOSE SALES TERMS</option>
						<option value="ASIS">ASIS</option>
						<option value="POWER ON">POWER ON</option> 
						<option value="FULL QC">FULL QC</option>  
					 </select>
				 </td>
				 <td>   
					<input readonly class="form-control grade_cls" required name="grade[]" id="grade'.$sno.'" placeholder="SELECT GRADE" readonly> </td>';
				//  <td>
				// 	<select class="form-control" required name="payment_mode[]" id="payment_mode'.$sno.'"> 
				// 		<option value="">CHOOSE PAYMENT MODE</option>
				// 		<option value="COD">COD</option>
				// 		<option value="PREPAID">PREPAID</option>  
				// 	 </select>
				//  </td>			
		$html.='	 <td>
					<select selected disabled="true" class="form-control"  required name="tax_type[]" id="tax_type'.$sno.'" style="pointer-events:none;">
						<option value="">CHOOSE TAX Type</option>
						<option value="CGSG12">CG+SG 12%</option> 
						<option  value="IGST12">IGST 12%</option> 
						<option value="CGSG18">CG+SG 18%</option> 
						<option  value="IGST18">IGST 18%</option> 
					 </select>
					 
					<input type="hidden" name="tax_type[]" id="tax_type_value'.$sno.'" />	
					
				</td> 
			   <td>
						<select class="form-control" required name="bill_type[]" id="bill_type'.$sno.'" style="pointer-events:none;">
							<option value="">CHOOSE BILL TYPE</option>
							<option value="TAXABLE">TAXABLE</option>
							<option value="EXEMPT">EXEMPT</option> 
						</select> 
				 </td>';
				// <td><input class="form-control" required name="sales_code[]" id="sales_code'.$sno.'" placeholder="SALES CODE" value="" type="text"></td>				
		$html.='  <td><a onclick="deleteRow('.$trId.')" class="btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
		<input class="form-control input_grnreport_id" name="grnreport_id[]" id="grnreport_id'.$sno.'" value=""00 type="hidden">
		<input class="form-control" name="model_id[]" id="model_id'.$sno.'" type="hidden">
		<input class="form-control" name="unit_price[]" id="unit_price'.$sno.'" type="hidden">
		<input class="form-control" name="unit_price_tax[]" id="unit_price_tax'.$sno.'" type="hidden">
		</tr>';  

			$json['status']='1';
			$json['html']=$html;
			echo json_encode($json);
			die;
	}
  
	  public function getDeviceInfoByNhdin()
	  {
		  $nhdin=$_GET['nhdin'];
		  $salesorderid=$this->input->get('salesorder_id');
		  $grnResult=$this->db->where('nhdin',$nhdin)->where('status','RFS')->get('tbl_grnreport')->row();
		  // Rule1: Check valid Device Id 1
		  if(empty($grnResult)){
		       $json['status']='0';
			   $json['msg']="Enter valid Inward Device Id.";
			   echo json_encode($json);
		       die;
		  }
		  
		  // Rule 2: Check associated salesorder.	
		  $so_details=$this->api_model->getsalesorderdetails($salesorderid);
		  if(empty($so_details)){
			   $json['status']='0';
			   $json['msg']="SalesOrder Not found #".$salesorderid;
			   echo json_encode($json);
		       die;
		  } 	
		  
		  // Rule 3: Check SKU First, then STOCK TYPE and finally Grade
		  $stock_type = '';
		  $sale_price = 0;
		  $sales_terms = '';
		  foreach($so_details as $item){
		       if(trim($item['sku'])==trim($grnResult->SKU)){
				  if(trim($item['category'])==trim($grnResult->stock_type)){
					 if(trim($item['grade'])==trim($grnResult->certification_grade)){
					    $stock_type=trim($grnResult->stock_type);
						$sale_price = $item['sale_price'];
						$sales_terms = $item['sales_terms'];
						break;
				     }  
				  }
			   }
		  } 	  
		
          // Rule 4: SKU MISMATCH		
          if(empty($stock_type)){
			  $json['status']='0';
			  $json['msg']="SKU/CATEGORY/GRADE MISMATCH.";
			  echo json_encode($json);
		      die;
		  }		
	      
		  $margin = 0; $taxable = 0; $tax=0; $margin_perc = 0;
          // Calculate Taxes for OPEN BOX
		  $taxable_cat = TAXABLE_CATEGORY;	  
		  if(in_array($stock_type, $taxable_cat)){
			  $tax = $sale_price-$sale_price/1.18;			  
		  }else{
			  $margin = $sale_price - ($grnResult->unit_price+$grnResult->unit_price_tax);
			  $taxable = $margin / 1.18;
			  $tax = $margin - $taxable;
			  if($tax<0){
				  $tax =0;
				  $taxable = 0;
			  }
			  if($margin<0){
				  $margin=0;
			  }
			  $margin_perc = ($margin/$sale_price)*100;
		  }
		
            $deviceNhmod=$grnResult->nhmod;
			$typeId=0;
			$typeId=$this->Common_model->getFieldValue('type_id','tbl_product_details','nhmod',$deviceNhmod);
			$taxRatio=$this->Common_model->getFieldValue('tax_ratio','tbl_device_type','type_id',$typeId);
		
			$json['status']='1';			      
			$json['tax_ratio'] = (int) $taxRatio;
			$json['product_name'] = $grnResult->device_name;
			$json['imei'] = $grnResult->imei1_no;	
			$json['invoice_type'] = $grnResult->invoice_type;
			$json['tax_type'] = $grnResult->tax_type;
			$json['tax'] = $grnResult->tax;
			$json['tax_amount']=round($tax,2);
			$json['margin']=round($margin,2);
			$json['margin_perc']=round($margin_perc,2);
			$json['grnreport_id'] = $grnResult->grnreport_id;
			$json['grade']=$grnResult->certification_grade;
			$json['category']=$grnResult->stock_type;
			$json['sale_price']=$sale_price;
			$json['unit_price']=$grnResult->unit_price;
			$json['unit_price_tax']=$grnResult->unit_price_tax;
			$json['sales_terms']=strtoupper($sales_terms);
			$json['sku']=$grnResult->SKU;		
	  
			echo json_encode($json);
		    die;
	  }
	  
	  public function getVendorDetailsByName()
	  {
		$name=$_GET['name'];
		  
		$vendorResult=$this->db->where('name',$name)->get('tbl_vendor')->row();
		$stateResult = $this->db->select('name,state_gst_id')->where('state_id',$vendorResult->state)->get('tbl_states')->row();
		if(!empty($vendorResult))
		{
			  $json['name'] = $vendorResult->name;
			  $json['company'] = $vendorResult->company;	
			  $json['email'] = $vendorResult->email;	
			  $json['mobile'] = $vendorResult->mobile;
			  $json['address'] = $vendorResult->address;
			  $json['city'] = $vendorResult->city;
			  $json['state_id'] = $vendorResult->state;
			  $json['state'] = $stateResult->name;
			  $json['pincode'] = $vendorResult->pincode;
			  $json['code'] = $vendorResult->vendor_code;
			  $json['gstno'] = $vendorResult->gst_no;
			  $json['vendor_id'] = $vendorResult->vendor_id;
			  $json['state_gst_id'] = $stateResult->state_gst_id;
			  
		}
				  
		  echo json_encode($json);
		  die;  
	  }
	  
	  public function getVendorIdByMobileNo()
	  {
		   $allMobile=$_POST['allMobile'];
		   
		   $searchMobile=$_POST['searchMobile'];
		   
		   if($allMobile!='')
		   {
			   $mobileArray=explode(',',$allMobile);
			   
			   $mobileArray=array_unique($mobileArray);
			   
			   $mobileArray=array_values($mobileArray);
			   
			   $vendorId=array_search($searchMobile,$mobileArray);
			   
			   $json['vendorId']=($vendorId+1);
			   
			   $json['status']='1';
		   }
		   else
		   {
			   $json['status']='0';
			   
			   $json['msg']='PLEASE FILL MOBILE NO';
		   }
			echo json_encode($json); 
			die;
	  }
	  
	
	public function createOnlineBuyerCode()
	{
		$invoiceNO=0;
		
		$mobile=$_POST['mobile'];
		
		$saleChannel=$_POST['sale_channel'];
		
		$userLocation=$this->Common_model->getShortValueOfState($this->session->userdata('location')); 
		 
		/*==GET LOCATION TYPE==*/
		
		$category='';
		
		$json['buyer_code']='';
		
		if($userLocation=='DLI')
		{
			$category='D';
		}
		else
		{
			$category='B';
		} 
		
		if($mobile!='' && $saleChannel!='OFFLINE')
		{
			$json['status']='1'; 
 	   
			$json['buyer_code']='SLYHON-'.$mobile; 
		}
		else
		{
			$json['status']='0';  
			 
		}
 
		echo json_encode($json);
		
		die;
	}  
	
	public function addCreateInvoiceEnd()
	{
		 
		$locName=$this->Common_model->getShortValueOfState($this->session->userdata('locationValue'));
		 
		$data=$this->input->post();
 
		$error=0;
		  
		/*==check vendor code with sale channel==*/
		  
		$allVendorCode=$this->input->post('vendor_code');
		
		$allVendorMobile=$this->input->post('mobile');
		 
		$allSaleChannel=$this->input->post('sale_channel');
 
		if(!empty($allVendorCode))
		{
			$i=0;
 
			foreach($allVendorCode as $allVendorCodeValue)
			{
				if($allSaleChannel[$i]=='OFFLINE')
				{	
					$getValue=$this->db->where('vendor_code',$allVendorCodeValue)->get('tbl_vendor')->row();
				 
					 if(empty($getValue))
					 {
						 $error++;
						 $msg = "Invalid Vendor Code #".$allVendorCodeValue;
					 } 
				}
				
				$i++;
			}
		}		
 
		/*==check sales  code==*/
			
		$allSalesCode=$this->input->post('sales_code');
		  
		if(!empty($allSalesCode))
		{
			foreach($allSalesCode as $allSalesCodeValue)
			{
				$getValue=$this->db->where('sales_code',$allSalesCodeValue)->get('tbl_account_details')->row();
					 
				if(empty($getValue))
				{
					 $error++;
					 $msg = "Invalid Sales Code #".$allSalesCodeValue;
				}
			  }
		} 

		/*==check NHDIN  code==*/
			
		$allNhdinCode=$this->input->post('nhdin');
		  
		if(!empty($allNhdinCode))
		{
			 foreach($allNhdinCode as $allNhdinCodeValue)
			 {
				 $getValue=$this->db->where('nhdin',$allNhdinCodeValue)->get('tbl_grnreport')->row();
				 
				 if(empty($getValue))
				 {
					 $error++;
					 $msg = "Invalid Inward Device Id #".$allNhdinCodeValue;
				 }
			
				/*==check put qc pass sales finance stamp exist on all nhdin  code==*/
				
				$stampValue=$this->db->where(array('nhdin'=>$allNhdinCodeValue,'status'=>'1'))->get('tbl_outqcpass_finance')->row();
			
				if(empty($stampValue))
				{
					 $error++;
					 $msg = "Invalid Out QC Finance #".$allNhdinCodeValue;
				}
			 	
				/*==CHECK LOCATION CONDITION==*/
				
				$nhdinArray=explode('-',trim($allDataInSheet[$i]["A"]));
				
				$nhdinLength=count($nhdinArray);
				
				if(((substr($allNhdinCodeValue,0,3)!=$locName && $nhdinLength=='3') || ($nhdinLength=='2' && $locName!='DLI')) &&  $this->session->userdata('user_type')!='1')
				{
					$error++;
					$msg = "Invalid Location #".$locName;
				}
			 }
		 } 
	 
		if($error=='0')
		{
			$v=0;
			
			$refNo=$this->Common_model->createInvoiceRefId();
			
			$allVendorMobileResult=array_values(array_unique($allVendorMobile));
			
			$getInvoiceRefNo=$this->Common_model->getInvoiceRefArray($refNo,$allVendorMobileResult);
			 
			foreach($allVendorCode as $allVendorCodeData)
			{
				$refId=0;
				
				$refId=$this->Common_model->getRefNoFromArray($getInvoiceRefNo,$data['mobile'][$v]);
				
				$invoiceData=array();
				
				$state=$this->Common_model->getFieldValue('location','tbl_account_details','user_id',$this->session->userdata('user_id'));
				
				$hsnCode=0; $deviceType=''; $deviceBrand=''; $deviceName=''; $taxRatio='0';
				 
				$grnResult=$this->db->select('nhmod,stock_type,stock_subtype')->where('nhdin',$data['nhdin'][$v])->get('tbl_grnreport')->row_array();
				
				$productResult=$this->db->select('tbl_device_type.hsn_code,tbl_product_details.product_name as deviceName,tbl_device_type.tax_ratio as taxRatio,tbl_device_type.name as deviceType,tbl_device_brand.name as deviceBrand')->where('tbl_product_details.nhmod',$grnResult['nhmod'])->join('tbl_device_type','tbl_device_type.type_id=tbl_product_details.type_id')->join('tbl_device_brand','tbl_device_brand.brand_id=tbl_product_details.brand_id')->get('tbl_product_details')->row_array();
				
				if(!empty($productResult))
				{
					$hsnCode=$productResult['hsn_code'];
					
					$deviceName=$productResult['deviceName'];
					
					$deviceType=$productResult['deviceType'];
					
					$deviceBrand=$productResult['deviceBrand'];
					
					$taxRatio=$productResult['taxRatio'];
				}
				
							
				$taxResult=$this->Common_model->getTaxRsValueByNhdin($data['nhdin'][$v],$data['nhsp'][$v],$data['nhpp'][$v],$data['bill_type'][$v]);
				
				$raxInRs=$taxResult['taxvalue'];
				
				$inputTax=0;$outputTax=0;$taxPayable=0;
				$taxable_cat = TAXABLE_CATEGORY;
				if(in_array(strtoupper($grnResult['stock_type']), $taxable_cat) && $taxRatio>0)
				{
					if($data['rs_margin'][$v]<=0 || strtoupper($data['bill_type'][$v])=='TAXABLE')
					{
						$inputTax=$data['nhpp'][$v]-((($data['nhpp'][$v])/(100+$taxRatio))*100);
						
						$inputTax=round($inputTax,2);
						
					} 
					
			 	}
				
				$outputTax=round($raxInRs,2);
					 
				$taxPayable=$outputTax-$inputTax;
								 
				$invoiceData=array(
					'user_id'=>$this->session->userdata('user_id'),
					'invoice_refno'=>$refId,
					'invoice_code'=>$this->Common_model->getInvoiceCode($data['bill_type'][$v],$refId,$state),
					'vendor_code'=>$allVendorCodeData,
					'sale_channel'=>$data['sale_channel'][$v],
					'order_id'=>$data['order_id'][$v],
					'nhdin'=>$data['nhdin'][$v],
					'imei'=>$data['imei'][$v],
					'product_name'=>$deviceName,
					'hsn_code'=>$hsnCode,
					'nhpp'=>$data['nhpp'][$v],
					'nhsp'=>$data['nhsp'][$v],
					'input_tax'=>$inputTax,
					'output_tax'=>$outputTax,
					'tax_payable'=>$taxPayable,
					'rs_margin'=>$data['rs_margin'][$v],
					'percent_margin'=>$data['percent_margin'][$v],
					'selling_mode'=>$data['selling_mode'][$v],
					'category'=>$data['category'][$v],
					'payment_mode'=>$data['payment_mode'][$v],
					'name'=>$data['name'][$v],
					'mobile'=>$data['mobile'][$v],
					'address'=>$data['address'][$v],
					'city'=>$data['city'][$v],
					'state'=>$data['state'][$v],
					'pincode'=>$data['pincode'][$v],
					'vendor_id'=>$data['vendor_id'][$v],
					'gst'=>$data['gst'][$v],
					'tax_type'=>$data['tax_type'][$v],
					'bill_type'=>$data['bill_type'][$v],
					'sales_code'=>$data['sales_code'][$v],	
					'warehouse'=>$this->session->userdata('location'),
				);
				
				$this->db->insert('tbl_createinvoice',$invoiceData);
				
				$insertId=$this->db->insert_id();
				
				$bulkstatusId=$this->Common_model->getFieldValue('bulkstatus_id','tbl_outqcpass_salesstamp','nhdin',$data['nhdin'][$v]);
				
				
				$stampArray=array(
					'nhdin'=>$data['nhdin'][$v],
					'invoice_id'=>$insertId,
					'invoice_no'=>$invoiceData['invoice_code'],
					'bulkstatus_id'=>$bulkstatusId,
					'imei_no'=>$data['imei'][$v],
					'user_id'=>$this->session->userdata('user_id'),
					'stock_type'=>$grnResult['stock_type'],
					'stock_subtype'=>$grnResult['stock_subtype'],
					'sale_channel'=>$data['sale_channel'][$v],
					'order_id'=>$data['order_id'][$v],
					'device_type'=>$deviceType,
					'device_brand'=>$deviceBrand,
					'nhmod'=>$grnResult['nhmod'],
					'product_name'=>$deviceName,
					'hsn_code'=>$hsnCode,
					'nhpp'=>$data['nhpp'][$v],
					'nhsp'=>$data['nhsp'][$v],
					'rs_margin'=>$data['rs_margin'][$v],
					'percent_margin'=>$data['percent_margin'][$v],
					'tax_rsvalue'=>$outputTax,
					'input_tax'=>$inputTax,
					'output_tax'=>$outputTax,
					'tax_payable'=>$taxPayable,
					'selling_mode'=>$data['selling_mode'][$v],
					'category'=>$data['category'][$v],
					'payment_mode'=>$data['payment_mode'][$v],
					'name'=>$data['name'][$v],
					'mobile'=>$data['mobile'][$v],
					'address'=>$data['address'][$v],
					'city'=>$data['city'][$v],
					'state'=>$data['state'][$v],
					'pincode'=>$data['pincode'][$v],
					'gst'=>$data['gst'][$v],
					'tax_type'=>$data['tax_type'][$v],
					'bill_type'=>$data['bill_type'][$v],
					'vendor_code'=>$allVendorCodeData,
					'sales_code'=>$data['sales_code'][$v],
					'rfs_type'=>$this->Common_model->checkRfsType($data['nhdin'][$v]),
					'warehouse'=>$this->session->userdata('location'),
				);
				
				$this->db->insert('tbl_soldstamp',$stampArray);
				
				/*===REMOVE STAMP FROM OUT QC PASS SALES finance==*/
				
				$this->db->where(array('nhdin'=>$data['nhdin'][$v],'status'=>'1'))->update('tbl_outqcpass_finance',array('status'=>'0'));
				
				$v++;
				
			  }
 		
			$this->session->set_userdata("success","INVOICE ADDED SUCCESFULLY"); 
			
			header("location:".base_url()."admin/report/invoice-details"); 
		}
		else
		{
 
			$this->session->set_userdata("error", $msg); 
			
			/*===header("location:".base_url()."admin/Finance/create_invoice"); ==*/		
			header("location:".$_SERVER['HTTP_REFERER']);  
		}
 	
	}
	 
	public function updateInvoiceEnd()
	{
		$data=$this->input->post();
		
		$error=0;
		
		/*==CHK ERROR*/
		
		if(!empty($data))
		{
			/*==CHK VENDOR CODE===*/ 
			
			if($data['sale_channel']=='OFFLINE')
			{
				$vendorResult=array();
				
				$vendorResult=$this->db->select('vendor_id')->where('vendor_code',$data['vendor_code'])->get('tbl_vendor')->row();
				
				if(empty($vendorResult))
				{
					$error++;
				}
					
			} 
			  
			if($error=='0')
			{
				$i=0;
				
				foreach($data['invoice_id'] as $invoiceId)
				{
					$invoice['name']=$data['name'];
					
					$invoice['address']=$data['address'];
					
					$invoice['city']=$data['city'];
					
					$invoice['state']=$data['state'];
					
					$invoice['pincode']=$data['pincode'];
					
					$invoice['gst']=$data['gst'];
					
					$invoice['vendor_code']=$data['vendor_code'];
					
					$invoice['nhsp']=$data['nhsp'][$i];
					
					$invoice['nhpp']=$data['nhpp'][$i];
					
					$invoice['rs_margin']=($data['nhsp'][$i]-$data['nhpp'][$i]);
					
					$invoice['nhpp']=$data['nhpp'][$i];
					
					$invoice['percent_margin']=((($data['nhsp'][$i]-$data['nhpp'][$i])/$data['nhsp'][$i])*100);
			
					$this->db->where('invoice_id',$invoiceId)->update('tbl_createinvoice',$invoice);
					
					$i++;
				}
				
				$type="success";
			
				$msg="INVOICE UPDATED SUCCESSFULLY.";
			}
			else
			{
				$type="error";
			
				$msg="VENDOR CODE NOT MATCH.PLEASE CHECK.";
			}
		}
		else
		{
			$type="error";
			
			$msg="SOMETHING WRONG.PLEASE TRY AGAIN.";
		}
		
		$this->session->set_userdata($type,$msg);
		
		header("location:".base_url()."admin/report/invoice-details"); 
		
		die;
	}
	
 
	public function getAllCreateInvoice()
	{
	
		/*==set condition for get result location wise==*/
		 
		if($this->session->userdata('userlocationValue')!='ALL' && $this->session->userdata('userlocationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('userlocationValue'));
			
			$locCond="warehouse='".$this->session->userdata('userlocationValue')."'";
		}
		else
		{ 
			$locCond="invoice_id!='0'";
		}
		
		if($_GET['from']!='')
		{
			$from=date("Y-m-d", strtotime($_GET['from']));
			
			$locCond.=" and date(created_date)>='".$from."'";
			
		}
		
		if($_GET['to']!='')
		{
			$to=date("Y-m-d", strtotime($_GET['to']));
			
			$locCond.=" and date(created_date)<='".$to."'";
			
		}
		
		if($_GET['location']!='' && $_GET['location']!='ALL')
		{ 
			$locCond.=" and warehouse LIKE '%".$_GET['location']."%'";
			
		}
		
		$invoiceResult=$this->db->select('tbl_createinvoice.*,SUM(input_tax) as totalInputTax,SUM(output_tax) as totalOutputTax,SUM(tax_payable) as totalTaxPayable')->group_by('invoice_code')->order_by('created_date','desc')->where($locCond)->get('tbl_createinvoice')->result();
		
		if(!empty($invoiceResult))
		{	 
			foreach($invoiceResult as $invoiceResultValue)
			{
				 
				/*===get related invoice==*/
	
				$relatedInvoiceData=$this->db->where('invoice_code',$invoiceResultValue->invoice_code)->get('tbl_createinvoice')->result();
				 
				$totalRelatedInvoice=count($relatedInvoiceData);
				
				if(!empty($relatedInvoiceData))
				{
					$relatedInvoiceList=array();
					 
					$nhspTotal=0;
					$nhppTotal=0;
					foreach($relatedInvoiceData as $relatedInvoiceDataKey=>$relatedInvoiceDataValue)
					{
						if($relatedInvoiceDataValue->sale_channel!='OFFLINE')
						{
							$sale_channel='ONLINE';
						}
						else
						{
							$sale_channel='OFFLINE';
						}
					
						$InvoiceList=array( 
							'date'=>strftime(config_item('date_format'), strtotime($invoiceResultValue->created_date)),
							'invoice_refno'=>$relatedInvoiceDataValue->invoice_refno,
							'invoice_code'=>$relatedInvoiceDataValue->invoice_code,
							'user_id'=>$relatedInvoiceDataValue->user_id, 
							'vendor_name'=>$this->Common_model->getVendorNameFormVendorCode($relatedInvoiceDataValue->vendor_code,$relatedInvoiceDataValue->invoice_id),
							'vendor_code'=>$relatedInvoiceDataValue->vendor_code, 
							'sale_channel'=>$sale_channel,
							'order_id'=>$relatedInvoiceDataValue->order_id,
							'nhdin'=>$relatedInvoiceDataValue->nhdin,
							'imei'=>$relatedInvoiceDataValue->imei,
							'product_name'=>$relatedInvoiceDataValue->product_name,
							'nhpp'=>number_format($relatedInvoiceDataValue->nhpp,2), 
							'nhsp'=>number_format($relatedInvoiceDataValue->nhsp,2),
							'rs_margin'=>number_format($relatedInvoiceDataValue->rs_margin,2),
							'percent_margin'=>round($relatedInvoiceDataValue->percent_margin),
							'selling_mode'=>$relatedInvoiceDataValue->selling_mode,
							'category'=>$relatedInvoiceDataValue->category,  
							'input_tax'=>$relatedInvoiceDataValue->input_tax,
							'output_tax'=>$relatedInvoiceDataValue->output_tax,
							'tax_payable'=>$relatedInvoiceDataValue->tax_payable,
							'tax_type'=>$relatedInvoiceDataValue->tax_type,
							'payment_mode'=>$relatedInvoiceDataValue->payment_mode,
							'name'=>$relatedInvoiceDataValue->name,
							'mobile'=>$relatedInvoiceDataValue->mobile,
							'address'=>$relatedInvoiceDataValue->address,
							'city'=>$relatedInvoiceDataValue->city,
							'state'=>$relatedInvoiceDataValue->state,
							'pincode'=>$relatedInvoiceDataValue->pincode,
							'vendor_id'=>$relatedInvoiceDataValue->vendor_id,
							'gst'=>$relatedInvoiceDataValue->gst, 
							'bill_type'=>$relatedInvoiceDataValue->bill_type,
							'sales_code'=>$relatedInvoiceDataValue->sales_code,
							'qty'=>1,
						 ); 
						 
						$relatedInvoiceList[]=$InvoiceList;	 
						
						$nhspTotal+=$relatedInvoiceDataValue->nhsp;
						
						$nhppTotal+=$relatedInvoiceDataValue->nhpp;
					} 
				}
				else
				{
					 $relatedInvoiceList=array();
				}
				
				/*==get all common invoice list*/
				
					if($invoiceResultValue->sale_channel!='OFFLINE')
					{
						$sale_channel='ONLINE';
					}
					else
					{
						$sale_channel='OFFLINE';
					}
					
					/*==CALCULATE MARGIN===*/
					
					$rsMargin=$nhspTotal-$nhppTotal;
					
					
					/*==CALCULATE MARGIN PERCENTAGE===*/
					
					$perMargin=0;
					 
					$perMargin=(($nhspTotal-$nhppTotal)/$nhspTotal)*100;
					 
					$invoiceData=array( 
						'date'=>strftime(config_item('date_format'), strtotime($invoiceResultValue->created_date)),
						'invoice_code'=>$invoiceResultValue->invoice_code,
						'vendor_code'=>$invoiceResultValue->vendor_code,
						'vendor_name'=>$this->Common_model->getVendorNameFormVendorCode($invoiceResultValue->vendor_code,$invoiceResultValue->invoice_id),
						'sale_channel'=>$sale_channel,
						'order_id'=>$invoiceResultValue->order_id,
						'name'=>$invoiceResultValue->name,
						'product_name'=>$invoiceResultValue->product_name,
						'nhpp'=>number_format($nhppTotal,2),
						'nhsp'=>number_format($nhspTotal,2),
						'rs_margin'=>number_format($rsMargin,2),
						'percent_margin'=>round($perMargin),
						'tax_type'=>$invoiceResultValue->tax_type, 
						'input_tax'=>$invoiceResultValue->totalInputTax,
						'output_tax'=>$invoiceResultValue->totalOutputTax,
						'tax_payable'=>$invoiceResultValue->totalTaxPayable,
						'payment_mode'=>$invoiceResultValue->payment_mode,
						'bill_type'=>$invoiceResultValue->bill_type,
						'sales_code'=>$invoiceResultValue->sales_code,
						'invoice_refno'=>$invoiceResultValue->invoice_refno,
						'related_invoice'=>$relatedInvoiceList,
						'qty'=>$totalRelatedInvoice,
						'amount'=>number_format($nhspTotal,2),
						'nhdin'=>$invoiceResultValue->nhdin,
						'action'=>'<a href="#popUpModal" onclick="getInvoiceData('.$invoiceResultValue->invoice_id.')" class="btn btn-danger btn-xs" data-placement="top" data-original-title="PRINT INVOICE"><span><i class="fa fa-print"> </i></span></a>',
					 ); 
					
					$invoiceFinalData[]=$invoiceData;	
			}
		}
		else
		{
			 $invoiceFinalData=array();
		}
		   
		$jsonFinal = json_encode(array('data' => $invoiceFinalData));
		echo  $jsonFinal;
		die;
	}

	  
	public function uploadInvoiceExcel()
	{ 
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
				
			if($imageFileType!= "xlsx") 
			{ 
		
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN.";  
				
			}
			else
			{ 
			 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
					
			/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
				
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
		  	 
				 
							  
				$j=0;
				
				$invoiceResult=array();
				
				for($i=2;$i<=$arrayCount;$i++)
				{ 
										 
					$invoiceResult[]=array(
						'sale_channel'=>trim($allDataInSheet[$i]["A"]),
						'order_id'=>trim($allDataInSheet[$i]["B"]), 
						'nhdin'=>trim($allDataInSheet[$i]["C"]),  
						'product_name'=>trim($allDataInSheet[$i]["D"]), 
						'imei_no'=>trim($allDataInSheet[$i]["E"]), 
						'nhpp'=>trim($allDataInSheet[$i]["F"]), 
						'nhsp'=>trim($allDataInSheet[$i]["G"]),
						'selling_mode'=>trim($allDataInSheet[$i]["H"]),
						'category'=>trim($allDataInSheet[$i]["I"]), 
						'payment_mode'=>trim($allDataInSheet[$i]["J"]), 
						'name'=>trim($allDataInSheet[$i]["K"]), 
						'mobile'=>trim($allDataInSheet[$i]["L"]), 
						'address'=>trim($allDataInSheet[$i]["M"]), 
						'city'=>trim($allDataInSheet[$i]["N"]), 
						'state'=>strtoupper(trim($allDataInSheet[$i]["O"])), 
						'pincode'=>trim($allDataInSheet[$i]["P"]),
						'gst'=>trim($allDataInSheet[$i]["Q"]),  						
						'bill_type'=>strtoupper(trim($allDataInSheet[$i]["R"])), 
						'sales_code'=>trim($allDataInSheet[$i]["S"]), 						
						'vendor_code'=>trim($allDataInSheet[$i]["T"]), 	 
					);
					   
					$j++;
				} 
				unlink($inputFileName);
				
				$type="success";
				
				$msg="INVOICE UPLOADED SUCCESSFULLY."; 
				
				$data['excelResult']=$invoiceResult;
			}
		}
		else 
		{
			$type="error";
				
			$msg="NO FILE SELECTED.";  
			
			$data['excelResult']=array();
		} 
		
		// $this->session->set_userdata($type,$msg);  
 
		$data['active'] = 2;
		
		$data['title'] = lang('credit_invoice'); //Page title
		
		$data['page'] = "manage_finance";  
		
		$data['subview'] = $this->load->view('admin/finance/manage_finance', $data, TRUE);
 
		$this->load->view('admin/_layout_main', $data); //page load
		
	}
	
	
	
	
   /*==PRINTINVOICE  WORK==*/
  
	  public function manage_printinvoice()
	  {
		 $data['active'] = 1;		 
		 $data['title'] = lang('print_invoice'); //Page title
		 $data['page'] = "manage_printinvoice";  
		 $data['subview'] = $this->load->view('admin/finance/manage_printinvoice', $data, TRUE);
		 $this->load->view('admin/_layout_main', $data); //page load 
	  }
  
   /*==OUTSTANDING  WORK==*/
   
	public function manage_outstanding()
	{
		$data['active'] = 1;		 
		
		$data['title'] = lang('outstanding_payment'); //Page title
		
		$data['page'] = "manage_outstanding";  
		
		/*==SET LOCATION FOR ACCOUNT STATEMENT==*/
		
		if($this->session->userdata('user_type')!='1' && $this->session->userdata('location')!='')
		{  
			if($this->session->userdata('location')=='BANGALORE')
			{
				 $locCond="tbl_accstatement.vendor_code LIKE '%NHBOFB%' or  tbl_accstatement.vendor_code LIKE '%NHBON%'";
			}
			else
			{
				 $locCond="tbl_accstatement.vendor_code LIKE '%NHBOFD%' or  tbl_accstatement.vendor_code LIKE '%NHBON%'";
			}
						
		}
		else
		{ 
			 $locCond="tbl_accstatement.payment_id!='0'";
		}
		
		
		/*==SET LOCATION FOR ADVANCE PAYMENT==*/
		
		if($this->session->userdata('user_type')!='1' && $this->session->userdata('location')!='')
		{  
			if($this->session->userdata('location')=='BANGALORE')
			{
				 $vendorLocCond="tbl_advancepayment.vendor_code LIKE '%NHBOFB%' or  tbl_advancepayment.vendor_code LIKE '%NHBON%'";
			}
			else
			{
				 $vendorLocCond="tbl_advancepayment.vendor_code LIKE '%NHBOFD%' or  tbl_advancepayment.vendor_code LIKE '%NHBON%'";
			}
						
		}
		else
		{ 
			 $vendorLocCond="tbl_advancepayment.payment_id!='0'";
		}
		
		$data['result']=$this->db->group_by('tbl_accstatement.vendor_code')->select('tbl_accstatement.vendor_code,SUM(tbl_accstatement.cash) as cash,SUM(tbl_accstatement.total) as total,SUM(tbl_accstatement.card) as card,SUM(tbl_accstatement.cheque) as cheque,SUM(tbl_accstatement.online) as online,tbl_accstatement.invoice_refno,tbl_save_invoice.qty,tbl_save_invoice.amount')->join('tbl_save_invoice','tbl_save_invoice.statement_id=tbl_accstatement.payment_id')->where($locCond)->get('tbl_accstatement')->result();
		
		$data['advance_payment']=$this->db->select('SUM(total) as total,vendor_code')->group_by('vendor_code')->where($vendorLocCond)->get('tbl_advancepayment')->result();
		
		$data['credit_note']=$this->db->select('SUM(total) as total,vendor_code')->group_by('vendor_code')->get('tbl_advancepayment')->result();
		
		$data['subview'] = $this->load->view('admin/finance/outstanding/manage_outstanding', $data, TRUE);
		
		$this->load->view('admin/_layout_main', $data); //page load 
	}
	
	public function getAllOutstandingPayment()
	{
		
		$stateResult=$this->db->group_by('vendor_code')->get('tbl_accstatement')->result();
		
		$cond="payment_id!='0'";
		if($_GET['from']!='')
		{
			$fromDate=date("Y-m-d", strtotime($_GET['from'])); 
			$cond.=" and date(created_date)>='".$fromDate."'"; 
		}
		
		if($_GET['to']!='')
		{ 
			$toDate=date("Y-m-d", strtotime($_GET['to'])); 	
			$cond.=" and date(created_date)<='".$toDate."'";
				
		}
		
		if($_GET['vendor_code']!='')
		{
			$cond.=" and vendor_code='".$_GET['vendor_code']."'";
		}
		
		$stateResult=$this->db->group_by('vendor_code')->where($cond)->get('tbl_accstatement')->result();
		
		if(!empty($stateResult))
		{	 
			foreach($stateResult as $stateResultValue)
			{
				 
				/*===get related invoice==*/
				$cond="vendor_code='".$stateResultValue->vendor_code."'";
				
				if($_GET['from']!='' && $_GET['to']!='')
				{
					$cond.=" and date(created_date)>='".$fromDate."' and date(created_date)<='".$toDate."'";
				}
				$relatedPaymentData=$this->db->order_by('payment_id','desc')->where($cond)->get('tbl_accstatement')->result();
				 
				if(!empty($relatedPaymentData))
				{
					$relatedPaymentDataList=array();
					 
					$invoiceAmount=0;$advance_payment=0;$credit_note=0;$previous_outstanding=0;$net_payable=0;$cash_payment=0;
					$online_payment=0;$cheque_payment=0;$card_payment=0;$total_payment=0;$outstanding=0;
					
					foreach($relatedPaymentData as $relatedPaymentDataValue)
					{
						 
						$paymentList=array( 
							'vendor_code'=>$relatedPaymentDataValue->vendor_code,
							'vendor_name'=>$this->Common_model->getVendorNameFormVendorCode($relatedPaymentDataValue->vendor_code),
							'sales_code'=>'SALES CODE',
							'invoice_date'=>strftime(config_item('date_format'), strtotime($relatedPaymentDataValue->created_date)),
							'invoice_no'=>$relatedPaymentDataValue->invoice_refno,
							'invoice_amount'=>$relatedPaymentDataValue->invoice_amount,
							'advance_payment'=>$relatedPaymentDataValue->advance_payment,
							'credit_note'=>$relatedPaymentDataValue->credit_note,
							'previous_outstanding'=>$relatedPaymentDataValue->previous_outstanding,
							'net_payable'=>$relatedPaymentDataValue->net_payable,
							'cash_payment'=>$relatedPaymentDataValue->cash,
							'online_payment'=>$relatedPaymentDataValue->online,
							'cheque_payment'=>$relatedPaymentDataValue->cheque,
							'card_payment'=>$relatedPaymentDataValue->card,
							'total_payment'=>$relatedPaymentDataValue->totalPayment,
							'outstanding'=>$relatedPaymentDataValue->previous_outstanding,  
						 ); 
						$invoiceAmount+=$relatedPaymentDataValue->invoice_amount;
						$advance_payment+=$relatedPaymentDataValue->advance_payment;
						$credit_note+=$relatedPaymentDataValue->credit_note;
						$previous_outstanding+=$relatedPaymentDataValue->previous_outstanding;
						$net_payable+=$relatedPaymentDataValue->net_payable;
						$cash_payment+=$relatedPaymentDataValue->cash;
						$online_payment+=$relatedPaymentDataValue->online;
						$cheque_payment+=$relatedPaymentDataValue->cheque;
						$card_payment+=$relatedPaymentDataValue->card;
						$total_payment+=$relatedPaymentDataValue->totalPayment;
						$outstanding+=$relatedPaymentDataValue->previous_outstanding;
						$relatedInvoiceList[]=$paymentList;	 
					} 
				}
				else
				{
					 $relatedInvoiceList=array();
				}
				
				/*==get all common invoice list*/
				 
					$vendorData=array( 
						'vendor_code'=>$stateResultValue->vendor_code,
						'vendor_name'=>$this->Common_model->getVendorNameFormVendorCode($stateResultValue->vendor_code),
						'sales_code'=>'SALES CODE',
						'invoice_date'=>strftime(config_item('date_format'), strtotime($stateResultValue->created_date)),
						'invoice_no'=>$stateResultValue->invoice_refno,
						'invoice_amount'=>$invoiceAmount,
						'advance_payment'=>$advance_payment,
						'credit_note'=>$credit_note,
						'previous_outstanding'=>$previous_outstanding,
						'net_payable'=>$net_payable,
						'cash_payment'=>$cash_payment,
						'online_payment'=>$online_payment,
						'cheque_payment'=>$cheque_payment,
						'card_payment'=>$card_payment,
						'total_payment'=>$total_payment,
						'outstanding'=>$outstanding, 
						'related_invoice'=>$relatedInvoiceList,
						'action'=>'<a   class="btn btn-danger btn-xs" data-placement="top" data-original-title="PRINT INVOICE"><span><i class="fa fa-print"> </i></span></a>&nbsp;&nbsp;<a href="#" class="btn btn-primary btn-xs" title="" data-toggle="tooltip" data-placement="top" data-original-title="Edit"><i class="fa fa-pencil-square-o"></i></a>',
					 ); 
					
					$invoiceFinalData[]=$vendorData;	
			}
		}
		else
		{
			 $invoiceFinalData=array();
		}
		      
			$jsonFinal = json_encode(array('data' => $invoiceFinalData));
			echo  $jsonFinal;
			die;
	}
	
	public function advancepaymentReciptHtml($paymentId)
	{
		$data['result']=$this->db->where('payment_id',$paymentId)->get('tbl_advancepayment')->row_array();
		
		if(!empty($data['result']))
		{ 
		 
			$this->load->view('admin/finance/pdf_html/advance_payment',$data);
		}
		else
		{
			set_message('error','PAYMENT NOT FOUND.PLEASE CHECK.');
			
			redirect($_SERVER['HTTP_REFERER']);
		}
	}
		
	  /*==OVERALL PAYMENT  WORK==*/
	  public function manage_overallpayment()
	  { 
		 $data['active'] = 1;		 
		 $data['title'] = lang('overall_payment'); //Page title 
		 $data['subview'] = $this->load->view('admin/finance/overall_payment/manage_overall', $data, TRUE);
		 $this->load->view('admin/_layout_main', $data); //page load 
	  }
	  
	  
	/*==CREDIT NOTE WORK==*/
	public function manage_creditNote($activeId=NULL,$id = NULL)
	{ 
		if (!empty($activeId)) 
		{
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }		 
		$data['title'] = lang('credit_note'); //Page title 
		
		$data['subview'] = $this->load->view('admin/finance/credit_note/manage_creditnote', $data, TRUE);
		
		$this->load->view('admin/_layout_main', $data); //page load 
	}
	
	
	public function printCreditNoteData($invoiceCode)
	{ 
		$invoiceIdArray=$this->db->select('tbl_creditnote.creditnote_refno,tbl_creditnote.created_date,tbl_creditnote.user_id,tbl_createinvoice.invoice_code,tbl_createinvoice.name,tbl_createinvoice.mobile,tbl_createinvoice.state,tbl_createinvoice.pincode,tbl_createinvoice.sale_channel,tbl_createinvoice.vendor_code,tbl_createinvoice.order_id,tbl_createinvoice.nhsp,tbl_createinvoice.product_name,tbl_createinvoice.nhdin,tbl_createinvoice.imei,tbl_createinvoice.nhpp,tbl_createinvoice.bill_type')->where('tbl_creditnote.creditnote_refno',$invoiceCode)->join('tbl_createinvoice','tbl_createinvoice.invoice_id=tbl_creditnote.invoice_id')->get('tbl_creditnote')->result_array();
 
		if(!empty($invoiceIdArray))
		{
			 
			$data['result']=$invoiceIdArray;
			
			$this->load->view('admin/finance/pdf_html/credit_receipt',$data);
		}
		else
		{			
			set_message('error','CREDIT NOT FOUND.PLEASE TRY AGAIN');
			redirect('admin/Finance/manage_creditNote/1');
		}
	}
	
	
	public function getAllCreditNote()
	{ 	
	
		/*==set condition for get result location wise==*/
		
		if($this->session->userdata('userlocationValue')!='ALL' && $this->session->userdata('userlocationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('userlocationValue'));
			$locCond="tbl_createinvoice.nhdin LIKE '%".$shortState."%'";
		}
		else
		{ 
			$locCond="tbl_creditnote.creditnote_id!='0'";
		}
		
		
		$creditNoteResult=$this->db->select('tbl_creditnote.*,tbl_createinvoice.vendor_code,tbl_createinvoice.sale_channel,tbl_createinvoice.invoice_code,tbl_createinvoice.invoice_refno,tbl_createinvoice.nhsp,tbl_createinvoice.nhdin')->group_by('tbl_creditnote.creditnote_refno')->where('tbl_creditnote.status','1')->where($locCond)->from('tbl_creditnote')->join('tbl_createinvoice', 'tbl_creditnote.invoice_id = tbl_createinvoice.invoice_id')->get()->result();
 
		if(!empty($creditNoteResult))
		{	 
	
			foreach($creditNoteResult as $creditNoteResultValue)
			{
	
				/*===get related invoice==*/
				 
				$relatedInvoiceData=$this->db->where(array('tbl_creditnote.status'=>'1','tbl_creditnote.creditnote_refno'=>$creditNoteResultValue->creditnote_refno))->where($locCond)->from('tbl_creditnote')->join('tbl_createinvoice', 'tbl_creditnote.invoice_id = tbl_createinvoice.invoice_id')->get()->result();
 
				if(!empty($relatedInvoiceData))
				{
					$relatedInvoiceList=array();
 	
					$qty=0;
					
					$nhspTotal=0;
					
					foreach($relatedInvoiceData as $relatedInvoiceDataKey=>$relatedInvoiceDataValue)
					{
						
						if($relatedInvoiceDataValue->sale_channel=='OFFLINE')
						{
							$customerName=$this->Common_model->getVendorNameFormVendorCode($relatedInvoiceDataValue->vendor_code);
					 	}
						else
						{
							$customerName=$this->db->select('name')->where('vendor_code',$relatedInvoiceDataValue->vendor_code)->get('tbl_createinvoice')->row()->name;
					 	}
						
						$InvoiceList=array( 
							'creditnote_refno'=>$creditNoteResultValue->creditnote_refno,
							'vendor_name'=>$customerName,
							'vendor_code'=>$relatedInvoiceDataValue->vendor_code,
							'invoice_code'=>$relatedInvoiceDataValue->invoice_code,
							'invoice_no'=>$relatedInvoiceDataValue->invoice_refno,
							'invoice_amount'=>number_format($relatedInvoiceDataValue->nhsp,2),
							'return_amount'=>number_format($relatedInvoiceDataValue->nhsp,2),
							'qty'=>'1',
							'return_qty'=>'1',
							'return_nhdin'=>$relatedInvoiceDataValue->nhdin,
							'return_product'=>'1',
						 ); 
							 
						$relatedInvoiceList[]=$InvoiceList;	
						
						$nhspTotal+=$relatedInvoiceDataValue->nhsp; 
						
						$qty++; 
					} 
				}
				else
				{
					 $relatedInvoiceList=array();
				}
				
				/*==get all common invoice list*/
				
				$invoiceResult=$this->db->select('COUNT(invoice_id) as totalInvoice,SUM(nhsp) as invoiceTotal')->where('invoice_code',$creditNoteResultValue->invoice_code)->get('tbl_createinvoice')->row_array();
				
				$invoiceData=array(  
					'creditnote_refno'=>$creditNoteResultValue->creditnote_refno,
					'vendor_name'=>$customerName,
					'vendor_code'=>$relatedInvoiceDataValue->vendor_code,
					'invoice_code'=>$relatedInvoiceDataValue->invoice_code,
					'invoice_no'=>$relatedInvoiceDataValue->invoice_refno,
					'invoice_amount'=>number_format($invoiceResult['invoiceTotal'],2),
					'return_amount'=>number_format($nhspTotal,2),
					'qty'=>$invoiceResult['totalInvoice'],
					'return_qty'=>$qty,
					'return_nhdin'=>$relatedInvoiceDataValue->nhdin,
					'return_product'=>$qty,
					'related_invoice'=>$relatedInvoiceList,
					'action'=>'<a href="'.base_url().'admin/Finance/deleteCreditNote/'.$creditNoteResultValue->creditnote_refno.'"  class="btn btn-info btn-xs" data-placement="top" data-original-title="EDIT CREDIT NOTE"><span><i class="fa fa-pencil"> </i></span></a> &nbsp;&nbsp; <a target="_blank" href="'.base_url().'admin/print-credit-note/'.$creditNoteResultValue->creditnote_refno.'"   class="btn btn-danger btn-xs" data-placement="top" data-original-title="PRINT INVOICE"><span><i class="fa fa-print"> </i></span></a>&nbsp;&nbsp; <a href="#"  onclick="cancelCreditNote('.$creditNoteResultValue->creditnote_id.')"  class="btn btn-warning btn-xs" data-placement="top" data-original-title="CANCEL CREDIT NOTE"><span><i class="fa fa-close"> </i></span></a>', 
				); 
				$invoiceFinalData[]=$invoiceData; 
			}
		}
		else
		{
			$invoiceFinalData=array();
		}  
			
		$jsonFinal = json_encode(array('data' => $invoiceFinalData));
		echo  $jsonFinal;
		die;
	} 
	
	public function deleteCreditNote($creditNote)
	{
		// $this->db->where('creditnote_refno',$creditNote)->delete('tbl_creditnote');
		set_message('success','PREVIOUS CREDIT NOTE-'.$creditNote.' DELETED SUCCESFULLY'); 
		redirect('admin/Finance/manage_creditNote/2'); 
	}
	
	public function cancelCreditNote()
	{
		$creditNoteId=$_POST['id'];
		
		$this->db->where('creditnote_id',$creditNoteId)->update('tbl_creditnote',array('status'=>'0'));
 
		$json['status']='1';
		
		$json['msg']="CREDIT NOTE CANCELLED SUCCESSFULLY";
		
		echo json_encode($json);
		die;
	}
	
	
	public function getAllIssueCreditNote()
	{
		/*==set condition for get result location wise==*/
		
		if($this->session->userdata('userlocationValue')!='ALL' && $this->session->userdata('userlocationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('userlocationValue'));
			$locCond="nhdin LIKE '%".$shortState."%'";
		}
		else
		{ 
			$locCond="invoice_id!='0'";
		}
		
		$textBox='';
		
		if(isset($_GET['textbox']))
		{
			$textBox=$_GET['textbox'];
		}
		 
		if($textBox!='')
		{
			$cond="( invoice_code='".$textBox."' or vendor_code='".$textBox."' or nhdin='".$textBox."' or imei='".$textBox."') ";
			
			$invoiceResult=$this->db->group_by('vendor_id,invoice_refno,bill_type')->order_by('invoice_id','desc')->where($cond)->where($locCond)->get('tbl_createinvoice')->result();
 
			if(!empty($invoiceResult))
			{	 
				$i=1;
				foreach($invoiceResult as $invoiceResultValue)
				{
					 
					/*===get related invoice==*/
					$cond="invoice_refno='".$invoiceResultValue->invoice_refno."' and vendor_code='".$invoiceResultValue->vendor_code."' and bill_type='".$invoiceResultValue->bill_type."'";
					
					$relatedInvoiceData=$this->db->where($cond)->where($locCond)->get('tbl_createinvoice')->result();
					 
					$totalRelatedInvoice=count($relatedInvoiceData);
					
					if(!empty($relatedInvoiceData))
					{
						$relatedInvoiceList=array();
						
						$nhspTotal=0;
						$childClass="'child$i childinvoiceValue'";	
						foreach($relatedInvoiceData as $relatedInvoiceDataKey=>$relatedInvoiceDataValue)
						{
							
							if($relatedInvoiceDataValue->sale_channel=='OFFLINE')
							{
								$customerName=$this->Common_model->getVendorNameFormVendorCode($relatedInvoiceDataValue->vendor_code);
							}
							else
							{
								$customerName=$this->db->select('name')->where('vendor_code',$relatedInvoiceDataValue->vendor_code)->get('tbl_createinvoice')->row()->name;
							}
						
							$InvoiceList=array( 
								'vendor_name'=>$customerName,
								'vendor_code'=>$relatedInvoiceDataValue->vendor_code,
								'invoice_code'=>$relatedInvoiceDataValue->invoice_code,
								'invoice_refno'=>$relatedInvoiceDataValue->invoice_refno,
								'nhsp'=>$relatedInvoiceDataValue->nhsp,
								'qty'=>'1',
								'nhdin'=>$relatedInvoiceDataValue->nhdin,
								'product_name'=>$relatedInvoiceDataValue->product_name,
								'action'=>'<input type="checkbox" class='.$childClass.' value="'.$relatedInvoiceDataValue->invoice_id.'" onclick="selectChildCheckBox('.$i.')"  />', 
							 ); 
							 
							$relatedInvoiceList[]=$InvoiceList;	
							$nhspTotal+=$relatedInvoiceDataValue->nhsp; 
						} 
					}
					else
					{
						 $relatedInvoiceList=array();
					}
					
					/*==get all common invoice list*/
					
					$parentClass="'parent$i'";	
					$invoiceData=array(  
						'vendor_name'=>$customerName,
						'vendor_code'=>$invoiceResultValue->vendor_code,
						'invoice_code'=>$invoiceResultValue->invoice_code,
						'invoice_refno'=>$invoiceResultValue->invoice_refno,
						'nhsp'=>$nhspTotal,
						'qty'=>$totalRelatedInvoice,
						'nhdin'=>$invoiceResultValue->nhdin,
						'product_name'=>$invoiceResultValue->product_name,
						'related_invoice'=>$relatedInvoiceList,
						'action'=>'<input type="checkbox" class="parentinvoiceValue" id="parent'.$i.'"  value="'.$invoiceResultValue->invoice_refno.'"  onclick="selectChildCheckBox('.$i.')" />', 
					); 
					
					$invoiceFinalData[]=$invoiceData;	
					$i++;
				}
			}
			else
			{
				$invoiceFinalData=array();
			}
		}
		else
		{
			$invoiceFinalData=array();
		}
		      
		$jsonFinal = json_encode(array('data' => $invoiceFinalData));
		echo  $jsonFinal;
		die;
	} 
	 
	public function moveToCreditNote()
	{ 
		 
		$childinvoiceValue=$_POST['childinvoiceValue']; 
		
		if($childinvoiceValue!='')
		{ 	 
				$childinvoiceResult=explode(',',$childinvoiceValue);
				
				$cond='';
				if(!empty($childinvoiceResult))
				{
					foreach($childinvoiceResult as $childinvoiceValue)
					{
						$cond.=" invoice_id='".$childinvoiceValue."' or ";
					}
				}	
		 
				$cond=rtrim($cond,'or ');
				
				$invoiceResult=$this->db->group_by('vendor_id,invoice_refno')->where($cond)->get('tbl_createinvoice')->result();
 
				if(!empty($invoiceResult))
				{
					foreach($invoiceResult as $invoiceResultValue)
					{
						$createCreditRefNo=$this->Common_model->createCreditNoteRefNo();
						
						$error='0';
					
						$AllRelatedInvoiceResult=$this->db->where(array('invoice_refno'=>$invoiceResultValue->invoice_refno,'vendor_id'=>$invoiceResultValue->vendor_id))->where($cond)->get('tbl_createinvoice')->result();
						 
						foreach($AllRelatedInvoiceResult as $AllRelatedInvoiceResultValue)
						{
							 
							/*==check all nhdin==*/
						 	 
							$assResult=$this->db->where(array('nhdin'=>$AllRelatedInvoiceResultValue->nhdin,'status'=>'1'))->get('tbl_assinspection')->row();
							
							$rtoResult=$this->db->where(array('nhdin'=>$AllRelatedInvoiceResultValue->nhdin,'status'=>'1'))->get('tbl_returntoorigin')->row();
							
							$returnResult=$this->db->where(array('nhdin'=>$AllRelatedInvoiceResultValue->nhdin,'status'=>'1'))->get('tbl_salesreturn')->row();
							 
							if(!empty($nhdinResult) || !empty($rtoResult)  || !empty($returnResult) )
							{
						 
								
								/*==if related stamp exist in bulk status than invoice moves to credit note==*/
								
								$creditRefNo=$this->Common_model->createFormatNoteRefNo($createCreditRefNo,$AllRelatedInvoiceResultValue->vendor_code);
								
								$creditArray=array(
									'user_id'=>$this->session->userdata('user_id'),
									'refno'=>$createCreditRefNo,
									'creditnote_refno'=>$creditRefNo,
									'invoice_id'=>$AllRelatedInvoiceResultValue->invoice_id,
								);
								
								$this->db->insert('tbl_creditnote',$creditArray);
								
								$type="success";
				
								$msg="ITEM SUCCESSFULLY MOVED TO CREDIT NOTE."; 
								
								$this->session->set_userdata($type,$msg); 
			 					
								$json['status']='1';
								
								$json['msg']="ITEM SUCCESSFULLY MOVED TO CREDIT NOTE"; 
								
						 	}
							else
							{
								$json['status']='0';
								
								$json['msg']="STAMP NOT FOUND OF RELATED INVOICE ID.";
							}
						}
						 					
					}
					 
				}
				else
				{
					$json['status']='0';
					$json['msg']="INVOICE NOT FOUND.PLEASE TRY AGAIN.";
				}			
		}
		else
		{
			$json['status']='0';
			$json['msg']='PLEASE SELECT AT LEAST ONE ITEM';
		}
		echo json_encode($json);
		die;
	} 
	
	public function getAllCancelCreditNote()
	{ 	
	
	
		/*==set condition for get result location wise==*/
		
		if($this->session->userdata('userlocationValue')!='ALL' && $this->session->userdata('userlocationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('userlocationValue'));
			
			$locCond="tbl_createinvoice.nhdin LIKE '%".$shortState."%'";
		}
		else
		{ 
			$locCond="tbl_creditnote.creditnote_id!='0'";
		}
		
		$creditNoteResult=$this->db->group_by('tbl_creditnote.creditnote_refno')->where('tbl_creditnote.status','0')->where($locCond)->from('tbl_creditnote')->join('tbl_createinvoice', 'tbl_creditnote.invoice_id = tbl_createinvoice.invoice_id')->get()->result();
 
		if(!empty($creditNoteResult))
		{	 
	
			foreach($creditNoteResult as $creditNoteResultValue)
			{
	
				/*===get related invoice==*/
				 
				$relatedInvoiceData=$this->db->where(array('tbl_creditnote.status'=>'0','tbl_creditnote.creditnote_refno'=>$creditNoteResultValue->creditnote_refno))->where($locCond)->from('tbl_creditnote')->join('tbl_createinvoice', 'tbl_creditnote.invoice_id = tbl_createinvoice.invoice_id')->get()->result();
 
				if(!empty($relatedInvoiceData))
				{
					$relatedInvoiceList=array();
 	
					$qty=0;
					$nhspTotal=0; 	
					foreach($relatedInvoiceData as $relatedInvoiceDataKey=>$relatedInvoiceDataValue)
					{
						
						if($relatedInvoiceDataValue->sale_channel=='OFFLINE')
						{
							$customerName=$this->Common_model->getVendorNameFormVendorCode($relatedInvoiceDataValue->vendor_code);
					 	}
						else
						{
							$customerName=$this->db->select('name')->where('vendor_code',$relatedInvoiceDataValue->vendor_code)->get('tbl_createinvoice')->row()->name;
					 	}
						
						$InvoiceList=array( 
							'creditnote_refno'=>$creditNoteResultValue->creditnote_refno,
							'vendor_name'=>$customerName,
							'vendor_code'=>$relatedInvoiceDataValue->vendor_code,
							'invoice_code'=>$relatedInvoiceDataValue->invoice_code,
							'invoice_no'=>$relatedInvoiceDataValue->invoice_refno,
							'invoice_amount'=>$relatedInvoiceDataValue->nhsp,
							'return_ammount'=>$relatedInvoiceDataValue->nhsp,
							'qty'=>'1',
							'return_qty'=>'1',
							'return_nhdin'=>$relatedInvoiceDataValue->nhdin,
							'return_product'=>'1',
						 ); 
							 
						$relatedInvoiceList[]=$InvoiceList;	
						
						$nhspTotal+=$relatedInvoiceDataValue->nhsp; 
						$qty++; 
					} 
				}
				else
				{
					 $relatedInvoiceList=array();
				}
				
				/*==get all common invoice list*/
				 
				$invoiceData=array(  
					'creditnote_refno'=>$creditNoteResultValue->creditnote_refno,
					'vendor_name'=>$customerName,
					'vendor_code'=>$relatedInvoiceDataValue->vendor_code,
					'invoice_code'=>$relatedInvoiceDataValue->invoice_code,
					'invoice_no'=>$relatedInvoiceDataValue->invoice_refno,
					'invoice_amount'=>$nhspTotal,
					'qty'=>$qty,
					'return_qty'=>$qty,
					'return_nhdin'=>$relatedInvoiceDataValue->nhdin,
					'return_product'=>$qty,
					'related_invoice'=>$relatedInvoiceList,
					'action'=>'<a href="'.base_url().'admin/Finance/deleteCreditNote/'.$creditNoteResultValue->creditnote_refno.'"  class="btn btn-info btn-xs" data-placement="top" data-original-title="EDIT CREDIT NOTE"><span><i class="fa fa-pencil"> </i></span></a> &nbsp;&nbsp; <a target="_blank" href="'.base_url().'admin/print-credit-note/'.$creditNoteResultValue->creditnote_refno.'"   class="btn btn-danger btn-xs" data-placement="top"  data-original-title="PRINT INVOICE"><span><i class="fa fa-print"> </i></span></a>&nbsp;&nbsp; <a href="#"  onclick="cancelCreditNote('.$creditNoteResultValue->creditnote_id.')"  class="btn btn-warning btn-xs" data-placement="top" data-original-title="CANCEL CREDIT NOTE"><span><i class="fa fa-close"> </i></span></a>', 
				); 
				$invoiceFinalData[]=$invoiceData; 
			}
		}
		else
		{
			$invoiceFinalData=array();
		}  
			
		$jsonFinal = json_encode(array('data' => $invoiceFinalData));
		echo  $jsonFinal;
		die;
	} 
	  /*==ADVANCE PAYMENT WORK==*/
	  
	  public function manage_advancepayment($id = NULL,$activeId=NULL)
	  { 
	  
		if (!empty($activeId)) 
		{
            if (is_numeric($activeId)) {
                $data['active'] = $activeId; 
            } else {
                $data['active'] = 1;
            }
        } else {
            $data['active'] = 1;
        }
		
		$data['paymentresult']=array();
		
		if($id!='')
		{
			$data['paymentresult']=$this->db->where('payment_id',$id)->get('tbl_advancepayment')->row();			
		}
		
		 /*==SET LOCATION ==*/
		
			if($this->session->userdata('user_type')!='1' && $this->session->userdata('location')!='')
			{  
				if($this->session->userdata('location')=='BANGALORE')
				{
					 $locCond="vendor_code LIKE '%NHBOFB%'";
				}
				else
				{
					 $locCond="vendor_code LIKE '%NHBOFD%'";
				}							
			}
			else
			{ 
				 $locCond="payment_id!='0'";
			}
		
		 $data['title'] = lang('advance_payment'); //Page title 
		 $data['result']=$this->db->order_by('payment_id','desc')->where($locCond)->get('tbl_advancepayment')->result();
		 
		 $data['subview'] = $this->load->view('admin/finance/advance_payment/manage_advancepayment', $data, TRUE);
		 
		 $this->load->view('admin/_layout_main', $data); //page load 
	  }
	  
	  public function getVendorReport()
	  {
		  $vendorCode=$_POST['code'];
		  
		  $result=$this->db->where('vendor_code',$vendorCode)->get('tbl_vendor')->row();
		  
		  if(!empty($result))
		  {
			  $json['status']='1';
			  $json['name']=$result->name;
			  $json['gst']=$result->gst_no;
			  $json['mobile']=$result->mobile;
		  }
		  else
		  {
			  $json['status']='0';
			  $json['msg']='VENDOR CODE NOT FOUND.PLEASE TRY AGAIN';
		  }
		  echo json_encode($json);
		  die;
	  }
	  
	  public function getVendorReportForMultipleCode()
	  {
		  $error=array();
		  
		  $vendorCode=$_POST['code'];
		  
		  $sale_channel=$_POST['sale_channel'];
		  
		  $codeArray=explode(',',$vendorCode);
		  
		  $sale_channelArray=explode(',',$sale_channel);
		   
		  if(!empty($codeArray))
		  {
			  
			  if(count($sale_channelArray)==count($codeArray))
			  {
				  $i=0;
				  
				  foreach($codeArray as $resultValue)
				  {
					  if($sale_channelArray[$i]=='OFFLINE')
					  {
						  $vendorResult=$this->db->where('vendor_code',$resultValue)->get('tbl_vendor')->row();
					  
						  if(empty($vendorResult))
						  {
							  $error[]=$resultValue;
						  }
					  }
   
					  $i++;
				  }
				  
				  $json['status']='1'; 
				  
				  $json['error']=implode(',',$error); 
			  }
			  else
			  {
				    $json['status']='0';
					
					$json['msg']='SOME DATA MISSING.PLEASE CHECK.';
			  }			 
		  }
		  else
		  {
			  $json['status']='0';
			  
			  $json['msg']='VENDOR CODE NOT FOUND.PLEASE TRY AGAIN';
		  }
		  
		  echo json_encode($json);
		  die;
	  }
	  
	  public function addAdvancePaymentEnd()
	  {
		  $data=$this->input->post();
		  
		  if($data['total']>0)
		  { 	  
			  $paymentId=$data['payment_id']; 
				  
			 if($data['device']=='MOBILE')
			 {
				 $data['hsn_code']='8517';
			 }
			 elseif($data['device']=='LAPTOP' || $data['device']=='TABLET' || $data['device']=='LCD/LED TV')
			 {
				 $data['hsn_code']='8471';
			 }
			 elseif($data['device']=='MACBOOK')
			 {
				 $data['hsn_code']='8517';
			 }  
			 
			 if($paymentId=='')
			 { 
 
				  unset($data['payment_id']); 
				  
				  $data['user_id']=$this->session->userdata('user_id'); 
				  
				  $this->db->insert('tbl_advancepayment',$data);
 
				  $this->session->set_userdata('success','ADVACE PAYMENT ADDED SUCCESFULLY');
			  }
			  else
			  { 
				  
				  $this->db->where('payment_id',$paymentId)->update('tbl_advancepayment',$data);
				  
				  $this->session->set_userdata('success','ADVACE PAYMENT UPDATED SUCCESFULLY');
			  }
		  }
		  else
		  {
			  
			  $this->session->set_userdata('error','TOTAL AMOUNT MUST BE GREATER THAN 0');
		  }
		   		  
		  redirect($_SERVER['HTTP_REFERER']);
	  }
	  
	  public function deleteAdvancePayment($id)
	  { 
		  $this->db->where('payment_id',$id)->delete('tbl_advancepayment');
		  
		  $this->session->set_userdata('success','ADVACE PAYMENT ENTRY DELETED SUCCESFULLY');
		  
		  redirect($_SERVER['HTTP_REFERER']);
	  }
	  
	  public function inward_pending()
	  {
		 $data['active'] = 1;	
		 
		 $data['title'] = lang('Inward Pending Finance'); //Page title 	
		 
		 $data['subview'] = $this->load->view('admin/finance/inward_pending/manage_inwardpending', $data, TRUE);
		 
		 $this->load->view('admin/_layout_main', $data); //page load 
	  }
	  
	  public function invardPendingList()
	  {
		/*==set condition for get result location wise==*/
		 
		if($this->session->userdata('userlocationValue')!='ALL' && $this->session->userdata('userlocationValue')!='')
		{  
			$shortState=$this->Common_model->getShortValueOfState($this->session->userdata('userlocationValue'));
			
			$locCond="nhdin LIKE '%".$shortState."%'";
		}
		else
		{ 
			$locCond="grnreport_id!='0'";
		}
		
		 
		$pendingResult=$this->db->group_by('invoice_no')->order_by('grnreport_id','desc')->where('status','INWARD')->where($locCond)->get('tbl_grnreport')->result();
		  
		if(!empty($pendingResult))
		{	
			 
			foreach($pendingResult as $pendingResultKey=>$pendingResultValue)
			{
				
				
				/*===get related invoice==*/
				$relatedInvoiceData=$this->db->where(array('invoice_no'=>$pendingResultValue->invoice_no,'inward_pending'=>'1'))->where($locCond)->get('tbl_grnreport')->result();
				
				if(!empty($relatedInvoiceData))
				{
					$relatedInvoiceList=array();
					$totalNhdp=0;$totalNhpp=0;$totalUnit=0;
					foreach($relatedInvoiceData as $relatedInvoiceDataKey=>$relatedInvoiceDataValue)
					{	
							$InvoiceList=array( 
								'invoice_no'=>$relatedInvoiceDataValue->invoice_no,
								'mrn_number'=>"MRNHY-".str_pad($relatedInvoiceDataValue->order_refno, 5, "0", STR_PAD_LEFT),
								'vendor_code'=>$relatedInvoiceDataValue->vendor_code,
								'qty'=>'1',
								'invoice_date'=>$relatedInvoiceDataValue->invoice_date,
								'invoice_type'=>$relatedInvoiceDataValue->invoice_type,
								'nhdin'=>$relatedInvoiceDataValue->nhdin,
								'vendor_name'=>$relatedInvoiceDataValue->vendor_name,
								'nhdp'=>$relatedInvoiceDataValue->nhdp, 
								'device_name'=>$relatedInvoiceDataValue->device_name,
								'imei1_no'=>$relatedInvoiceDataValue->imei1_no,
								'tax_type'=>$relatedInvoiceDataValue->tax_type,
								'tax'=>$relatedInvoiceDataValue->tax,
								'unit_price'=>$relatedInvoiceDataValue->unit_price,
								'unit_price_tax'=>$relatedInvoiceDataValue->unit_price_tax,								
								'grn_inwarddate'=>strftime(config_item('date_format'), strtotime($relatedInvoiceDataValue->grn_inwarddate)),
							 ); 
							$totalUnit+=$relatedInvoiceDataValue->unit_price;
							$totalNhpp+=$relatedInvoiceDataValue->nhpp;
							$totalNhdp+=$relatedInvoiceDataValue->nhdp;
							$relatedInvoiceList[]=$InvoiceList;	
					}
				}
				else
				{
					 $relatedInvoiceList=array();
				}
				
				$pendingData=array( 
					'invoice_no'=>$pendingResultValue->invoice_no,
					'mrn_number'=>"MRNHY-".str_pad($pendingResultValue->order_refno, 5, "0", STR_PAD_LEFT),
					'vendor_code'=>$pendingResultValue->vendor_code,
					'qty'=>count($relatedInvoiceList),
					'invoice_date'=>$pendingResultValue->invoice_date,
					'invoice_type'=>$pendingResultValue->invoice_type,
					'nhdin'=>$pendingResultValue->nhdin,
					'unit_price'=>$pendingResultValue->unit_price,
                    'vendor_name'=>$pendingResultValue->vendor_name,
					'nhdp'=>$totalNhdp, 
					'device_name'=>$pendingResultValue->device_name,
					'imei1_no'=>$pendingResultValue->imei1_no,
					'tax_type'=>$pendingResultValue->tax_type,
					'tax'=>$pendingResultValue->tax,
					'nhpp'=>round($totalNhpp,2),
					'totalUnit'=>round($totalUnit,2),
					'grn_inwarddate'=>strftime(config_item('date_format'), strtotime($pendingResultValue->grn_inwarddate)),
					'related_invoice'=>$relatedInvoiceList,
					'check_all'=>'<input type="checkbox"  class="movestore" title="MOVE TO STORES" value="'.$pendingResultValue->invoice_no.'" />',
				); 
				$pendingList[]=$pendingData;				
			}
		  }
		  else
		  {
			  $pendingList=array();
		  }
		      
		   $jsonFinal = json_encode(array('data' => $pendingList));
			echo  $jsonFinal;
			die;
	  }
	  
	  public function invoicemovestore()
	  {
		  $invoiceId=$_POST['invoiceId'];
		  
		  $invoiceArrary=explode(',',$invoiceId);
		  
		  if(!empty($invoiceArrary) && $invoiceArrary[0]!='')
		  {
			  
			  foreach($invoiceArrary as $invoiceId)
			  {
				  $this->db->where('invoice_no',$invoiceId)->update('tbl_grnreport',array('recived_store'=>'1','recivedstore_datetime'=>date("Y-m-d H:i:s"),'inward_pending'=>'2','movestoreuser_id'=>$this->session->userdata('user_id')));
			  }
			  
			  $json['status']='1';
			  
			   /*===set message==*/
			   
			   $this->session->set_userdata('success','INVOICE SUCCESFULLY MOVED TO STORE'); 
		  }
		  else
		  {
			  $json['status']='0';
			  $json['msg']='SOMETHING WRONG.PLEASE TRY AGAIN.';
		  }
		  
			echo json_encode($json);
			die;
	  }
	  
	  public function rejectPurchase()
	  {
		  $invoiceId=$_POST['invoiceId'];
		  $remark=$_POST['remark'];
		  
		  $invoiceArrary=explode(',',$invoiceId);
		  
		  if(!empty($invoiceArrary) && $invoiceArrary[0]!='')
		  {
			  
			  foreach($invoiceArrary as $invoiceId)
			  {
				  
				  $getPurchaseRefNo=$this->db->select('order_refno')->group_by('order_refno')->where(array('invoice_no'=>$invoiceId,'inward_pending'=>'1'))->get('tbl_grnreport')->result_array();
				   
				   /*===SAVE DATA IN PURCHASE REJECT TABLE===*/
				   
				   /*===DELETE DATA ACCORDING TO INVOICE NO FROM GRN REPORT==*/
				   
				   $grnResult=$this->db->select('invoice_no,nhdin')->where(array('invoice_no'=>$invoiceId,'inward_pending'=>'1'))->get('tbl_grnreport')->result_array();
				   
					if(!empty($grnResult))	
					{
						foreach($grnResult as $grnResultValue)
						{
							$this->db->insert('tbl_purchasereject',array('nhdin'=>$grnResultValue['nhdin'],'invoice_no'=>$grnResultValue['invoice_no'],'remark'=>$remark));
						}
					}	
					
				  $this->db->where(array('invoice_no'=>$invoiceId,'inward_pending'=>'1'))->delete('tbl_grnreport');
				  
				  /*==DELETE DATA FROM BULK ORDER==*/
				  
				  if(!empty($getPurchaseRefNo))
				  {
					  foreach($getPurchaseRefNo as $getPurchaseRefNoValue)
					  {
						  $this->db->where(array('invoice_no'=>$invoiceId,'order_refno'=>$getPurchaseRefNoValue['order_refno']))->delete('tbl_bulkorder');
					  }
				  }
				  
			  }
			  
			  $json['status']='1';
			  
			   /*===set message==*/
			   
			   $this->session->set_userdata('success','PURCHASE REJECTED SUCCESSFULLY'); 
		  }
		  else
		  {
			  $json['status']='0';
			  $json['msg']='SOMETHING WRONG.PLEASE TRY AGAIN.';
		  }
		  
			echo json_encode($json);
			die;
	  }
	  
	  
	public function uploadOrderByExcel()
	{
		if (isset($_FILES["excel_file"])) 
		{ 
			$imageFileType = pathinfo($_FILES["excel_file"]["name"],PATHINFO_EXTENSION);
			
			if ($imageFileType!= "xlsx") 
			{ 
		
				$type="error";
				
				$msg="FILE IS NOT VALID FORMAT.PLEASE TRY AGAIN.";  
			}
			else
			{ 
		 
				require_once 'assets/ExcelClasses/PHPExcel.php';
				
				if($_FILES['excel_file']['name']!="")
				{
					$ran_no=rand(1111,9999);
					$this->load->library('upload');
					$config['file_name']='excel_file'.$ran_no;
					$config['upload_path']   = './assets/upload/';
					$config['allowed_types'] = 'xlsx';
					$config['max_size']      = 8000;
					$this->load->library('image_lib', $config);
					$this->image_lib->resize();
					$this->upload->initialize($config); 
					$this->upload->do_upload('excel_file');
					$upload_data = $this->upload->data();
					$image_name = $upload_data['file_name'];
				}
				
			/************************ YOUR DATABASE CONNECTION END HERE  ****************************/
			
				$inputFileName =  './assets/upload/'.$image_name;
				include './assets/ExcelClasses/PHPExcel/IOFactory.php'; 
				$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
				$allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				$arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
		
				/*==check vendor code exise in datatbase==*/
					
				$error=0; 
					
				if($error == '0') {	
					for($d=2;$d<=$arrayCount;$d++)
					{ 
						$vendorCodeResult=$this->db->where('vendor_code',trim($allDataInSheet[$d]["A"]))->get('tbl_vendor')->row();
						$nhmodResult=$this->db->where('nhmod',trim($allDataInSheet[$d]["C"]))->get('tbl_product_details')->row();
						
						$nhdin=$allDataInSheet[$d]["A"];
						$vendorDeviceId=$allDataInSheet[$d]["B"];					
						$invoiceType=$allDataInSheet[$d]["O"];
						$unitPrice=$allDataInSheet[$d]["P"];
						$tax=$allDataInSheet[$d]["Q"];
						
						$this->db->where(array('nhdin'=>$nhdin,'othervendor_id'=>$vendorDeviceId))->update('tbl_grnreport',array('unit_price'=>$unitPrice,'tax'=>$tax, 'invoice_type'=>$invoiceType));					
					}
					
					$type = "success";
					$msg = "Unit price update success";
				} else {
					$type="error";
					$msg = "Unit price update failed";
				}	
			}	
		}
	
		$this->session->set_userdata($type,$msg);  
		header("location:".$_SERVER['HTTP_REFERER']);  
	}	
	
	public function downloadInwardPending(){			
		$csv_output="INWARDID,INVOICE NO,VENDOR NAME,PRODUCT TYPE,PRODUCT NAME,OTHER VENDOR ID,RAM,ROM,COLOR,GRADE,INVOICE TYPE,UNIT PRICE,UNIT PRICE TAX,STOCK TYPE,STOCK SUB TYPE";
	
		$invoice_no = $_POST['invoice_no'];
		$result=$this->db->where(array('status'=>'INWARD','invoice_no'=>$invoice_no))->get('tbl_grnreport')->result_array();
 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= $value['vendor_name'].",";
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['device_name'].",";
				$csv_output .= $value['othervendor_id'].",";
				$csv_output .= $value['ram'].",";
				$csv_output .= $value['rom'].",";
				$csv_output .= $value['color'].",";
				$csv_output .= $value['procurement_grade'].",";
				$csv_output .= $value['invoice_type'].",";
				$csv_output .= $value['unit_price'].",";
				$csv_output .= $value['unit_price_tax'].",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output.="\n";
			}
		}
 
		$file="inward_pending_finance";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}
	
	public function downloadInwardPendingByBatch(){			
		$csv_output="INWARDID,INVOICE NO,VENDOR NAME,PRODUCT TYPE,PRODUCT NAME,OTHER VENDOR ID,RAM,ROM,COLOR,GRADE,INVOICE TYPE,UNIT PRICE,UNIT PRICE TAX,STOCK TYPE,STOCK SUB TYPE";
	
		$batch_no = $_POST['batch_no'];
		$result=$this->db->where(array('status'=>'INWARD','batch_no'=>$batch_no))->get('tbl_grnreport')->result_array();
 
		$csv_output.="\n";
		if(!empty($result))
		{
			foreach($result as $value)
			{
				$csv_output .= $value['nhdin'].",";
				$csv_output .= $value['invoice_no'].",";
				$csv_output .= $value['vendor_name'].",";
				$csv_output .= $value['product_type'].",";
				$csv_output .= $value['device_name'].",";
				$csv_output .= $value['othervendor_id'].",";
				$csv_output .= $value['ram'].",";
				$csv_output .= $value['rom'].",";
				$csv_output .= $value['color'].",";
				$csv_output .= $value['procurement_grade'].",";
				$csv_output .= $value['invoice_type'].",";
				$csv_output .= $value['unit_price'].",";
				$csv_output .= $value['unit_price_tax'].",";
				$csv_output .= $value['stock_type'].",";
				$csv_output .= $value['stock_subtype'].",";
				$csv_output.="\n";
			}
		}
 
		$file="inward_pending_finance";
		$filename = $file."_".date("Y-m-d_H-i",time());
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=".$filename.".csv");
		print $csv_output;
		exit;
	}

	public function uploadUnitCost(){
	    $type=""; $msg=""; 
	    if (isset($_FILES["csv_file"])){ 
	      $file_name = $_FILES['csv_file']['name'];
		  $file_size =$_FILES['csv_file']['size'];
		  $file_tmp =$_FILES['csv_file']['tmp_name'];
		  $file_type=$_FILES['csv_file']['type'];
		  $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
		  
		  $extensions= array("csv");
		  //echo $file_size; exit;
		  if(in_array($file_ext,$extensions)=== false){
			 $msg = "extension not allowed, please choose a CSV file.";
		  }
		  
		  if($file_size > 2097152){
			 $msg = 'File size must not exceed 2 MB';
		  }
		  
		  if(empty($errors)==true){
         	 $total_invoice_amount = 0;
		
			 $invoice_no = array();
			 $handle = fopen($_FILES['csv_file']['tmp_name'], "r");
			 $first_line = true;
			 while($col = fgetcsv($handle)){
				if($first_line == false){
					$deviceid = $col[0];

					if(!in_array($col[1], $invoice_no)){
						$invoice_no[] = $col[1];
					}
					
					$invoice_type=$col[10];
					$unit_price = $col[11];
					$unit_price_tax = $col[12];
					$status = 'IN_STOCK';	
					$stock_type = $col[13];	
					
					$device_status = $this->db->select('status')->where('nhdin',$deviceid)->get('tbl_grnreport')->row()->status;
					if($device_status != 'INWARD'){
						$type = "error";
						$msg = "Device Id ".$deviceid.' status is not INWARD';
						break;
					}
					
					//if($stock_type=='PREXO' || $stock_type=='PRELOVED'){
						//$status = 'RFS';
					//}
					if(strpos($unit_price, ',') !== false){
						$type = "error";
						$msg = "Commas(,) are not allowed in prices";
						break;
					}
					$taxable_cat = TAXABLE_CATEGORY;
					if(in_array($stock_type, $taxable_cat)){
						
						if($unit_price_tax <= 0){
							$type = "error";
							$msg = "For Open Box/New Items Unit Cost Tax shouldn't be 0.";
							break; 
						}
					}else{
						if($unit_price_tax != 0){
							$type = "error";
							$msg = "For Open Box Items Unit Cost Tax should be 0.";
							break; 
						}
					}
					
					$updateArray[] = array(
						'nhdin'=> $deviceid,
						'status' => $status,
						'unit_price'=>$unit_price,		
						'unit_price_tax'=>$unit_price_tax,
						'invoice_type'=>$invoice_type,
					);
					
					$total_invoice_amount = $total_invoice_amount + $unit_price + $unit_price_tax;
					
				}
			   $first_line = false;
			 } // end of while      
			 
			 $invoice_result = $this->db->select('sum(invoice_value) as total_invoice_value')->where_in('invoice_no', $invoice_no)->get('tbl_security_admin')->row();
			 
			 if(($invoice_result->total_invoice_value-100) <= $total_invoice_amount &&  $total_invoice_amount <= ($invoice_result->total_invoice_value+100)){
				if(empty($type)){

					$this->db->update_batch('tbl_grnreport',$updateArray, 'nhdin');
				 }
			 }else{
				$type = "error";
				$msg = "Total Amount is not matching with Invoice Amount.".$total_invoice_amount;
			 }
			 
			 $status_res = $this->db->where_in('invoice_no', $invoice_no)->where('status!=','APPROVED')->get('tbl_security_admin')->row();
			 if(!empty($status_res) ){
				$type = "error";
				$msg = "Not all invoices are Approved";
			 }
             
          }	
	    }else{
			$type="error";
			$msg="NO FILE SELECTED.PLEASE TRY AGAIN"; 
	    }
		
		$this->session->set_userdata($type,$msg);  
		header("location:".$_SERVER['HTTP_REFERER']);
	}
	
	public function getInvoices(){
		$result = $this->db->distinct()->select('invoice_no')->where('status','INWARD')->get('tbl_grnreport')->result_array();
		
		echo json_encode($result);
		die;
	}
	
	public function getBatchDetails(){
		$result = $this->db->distinct()->select('batch_no')->where('status','INWARD')->get('tbl_grnreport')->result_array();
		
		echo json_encode($result);
		die;
	}


	public function getDeviceprice() {
        $input = file_get_contents("php://input");
		$request = json_decode($input,false);
		
		$this->db->select('nhdin,product_brand,device_name,SKU,stock_type,certification_grade,procurement_grade,batch_no,status,unit_price,unit_price_tax,invoice_type,tax');
		$this->db->where_in('nhdin', $request);
		$this->db->group_by('nhdin,status,SKU,stock_type,certification_grade');
		$this->db->order_by('device_name asc');
		$result  = $this->db->get('tbl_grnreport')->result_array();
        
		if(!empty($result)){
            $json = $result;
		} else{
			http_response_code(500);
			$json['status']='Device not found';
		}   
		
		echo json_encode($json);
		die;
    }
	
	
}
