<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

//Create Class Fastcheckout with extends Admin_Controller
class Fastcheckout extends Admin_Controller
{
    //Constructor
    public function __construct()
    {
        parent::__construct();
        $this->load->library('cliq_api');
    }
    //CReate manage_fastcheckout function
    public function manage_fastcheckout($active = 0)
    {
        if ($active > 0) {
            $data['active'] = $active;
        } else {
            $data['active'] = 1;
        }

        $data['title'] = 'Fast Checkout';
        $data['subview'] = $this->load->view(
            'admin/fastcheckout/manage_fastcheckout',
            $data,
            true
        );
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function uploadMRP()
    {
        //get JSON data with nhdin and price
        $data = json_decode(file_get_contents('php://input'), TRUE);

        $price_array = [];
        $price_log_array = [];
        $json_array = [];
        $nhdin_arr = [];
        //foreach
        foreach ($data as $key => $value) {
            $price_array[] = [
                'mrp' => $value['mrp'],
                'nhdin' => $value['device_id'],
            ];
            $nhdin_arr[] = strtoupper($value['device_id']);
            $price_log_array[] = [
                'mrp' => $value['mrp'],
                'nhdin' => $value['device_id'],
                'lot_no' => $value['lot_no'],
                'date' => date('Y-m-d H:i:s'),
                'user_id' => $this->session->userdata('user_id'),
            ];
        }
	
        //start MySql Transaction
        $this->db->trans_start();
        //Update price in tbl_grnreport in batch
        $result = $this->db->select('grnreport_id, nhdin, status, mrp, bundle_id')->where_in('nhdin', $nhdin_arr)->get('tbl_grnreport')->result_array();
        $valid_nhdin = [];
        foreach ($result as $key => $rowValue) {
            if ($rowValue['status'] == 'SOLD' || $rowValue['status'] == 'FFC') {
                $json_array['status'] = 0;
                $json_array['message'] = $rowValue['nhdin'] . ' is a SOLD/FFC Device';
                $this->db->trans_rollback();
                echo json_encode($json_array);
                exit;
            }
            /* if ($rowValue['mrp'] > 0) {
                $json_array['status'] = 0;
                $json_array['message'] = 'Price is Already added for ' . $rowValue['nhdin'];
                $this->db->trans_rollback();
                echo json_encode($json_array);
                exit;
            } */
            $valid_nhdin[]  = strtoupper($rowValue['nhdin']);
            if ($rowValue['bundle_id'] > 0) {
                $bundle_id_arr[] = $rowValue['bundle_id'];
                $bundle_grn_id[strtoupper($rowValue['nhdin'])] = $rowValue['grnreport_id'];
            }
            unset($result[$key]);
        }
	
        $diff = array_diff($nhdin_arr, $valid_nhdin);
	
        if (count($diff) > 0) {
            $json_array['status'] = 0;
            $json_array['message'] = 'Invalid Device ID ' . implode(',', $diff);
            $this->db->trans_rollback();
            unset($valid_nhdin);
            unset($diff);
            unset($price_log_array);
            unset($price_array);
            exit;
        }

        $this->db->update_batch('tbl_grnreport', $price_array, 'nhdin');
        //check error
        $error = $this->db->error();
        //if error
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        if (!empty($bundle_id_arr)) {
            $this->db->where_in('bundle_id', $bundle_id_arr);
            $this->db->where_in('status', ["ACTIVE", "PENDING"]);
            $valid_bundle = $this->db->get('tbl_dealer_bundle')->result_array();

            foreach ($valid_bundle as $key => $value) {
                $valid_bundle_id_arr[] = $value['bundle_id'];
            }

            // Map Price array to bundle_grn_id
            foreach ($price_array as $key => $value) {
                if (!empty($bundle_grn_id[strtoupper($value['nhdin'])])) {
                    $bndle_price_arr[] = array(
                        "grnreport_id" => $bundle_grn_id[strtoupper($value['nhdin'])],
                        "price" => $value['mrp'],
                    );
                }
            }

            if (!empty($valid_bundle_id_arr) && !empty($bndle_price_arr)) {
                $this->db->where_in('bundle_id', $valid_bundle_id_arr);
                $this->db->update_batch('tbl_dealer_bundle_item', $bndle_price_arr, 'grnreport_id');

                $error = $this->db->error();
                //if error
                if ($error['code'] != 0) {
                    $this->db->trans_rollback();
                    $json_array['status'] = 0;
                    $json_array['message'] = $error['message'];
                    echo json_encode($json_array);
                    exit();
                }
		foreach ($valid_bundle_id_arr as $key_no => $bundle_id_val) {
                    $bundleAmount = $this->db->select('SUM(price) AS bundle_amount')->from('tbl_dealer_bundle_item')
                    ->where('bundle_id', $bundle_id_val)->get()->row()->bundle_amount;
                    
                    $this->db->where('bundle_id', $bundle_id_val)->update('tbl_dealer_bundle', array("amount" => $bundleAmount));
                }
            }
        }

        //Insert price log in tbl_grnreport_price_log in batch
        $this->db->insert_batch('tbl_grnreport_price_log', $price_log_array);

        $error = $this->db->error();
	
        //if error
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        //End MySql Transaction
        $this->db->trans_complete();
        $json_array['status'] = 1;
        $json_array['message'] = 'Success';
        echo json_encode($json_array);
        exit();
    }

    public function getMRP()
    {
        //get nhdin
        $nhdin = $this->input->get('device_id');
        $device_sub_category = $this->input->get('device_sub_category');
        $json_array = [];
        if (strlen($nhdin) <= 0) {
            $json_array['status'] = 0;
            $json_array['message'] = 'Invalid nhdins';
            echo json_encode($json_array);
            exit();
        }
        $where = [
            'nhdin' => $nhdin,
            'status' => 'RFS',
            'saletype' => 'OFFLINE',
        ];
        $data = $this->db
            ->select(
                'grnreport_id, nhdin,certification_grade, product_brand, device_name, SKU, mrp, stock_type, device_sub_category'
            )
            ->where($where)
            ->get('tbl_grnreport')
            ->row();

        if (empty($data)) {
            $json_array['status'] = 0;
            $json_array['message'] = 'Invalid nhdin';
            echo json_encode($json_array);
            exit();
        }

        if ($data->device_sub_category != $device_sub_category) {
            $json_array['status'] = 0;
            $json_array['message'] = 'Invalid device sub category';
            echo json_encode($json_array);
            exit();
        }

        $status_arr = [
            'DRAFT',
            'FINANCE_PENDING',
            'FINANCE_APPROVED',
            'INVOICED',
        ];
        $this->db
            ->select('tbl_salesorder.salesorder_code')
            ->join(
                'tbl_salesorder',
                'tbl_salesorder.salesorder_id = tbl_salesorder_item.salesorder_id',
                'Left'
            );
        $old_so = $this->db
            ->where('tbl_salesorder_item.grnreport_id', $data->grnreport_id)
            ->where_in('tbl_salesorder.status', $status_arr)
            ->get('tbl_salesorder_item')
            ->row();

        if (!empty($old_so)) {
            $json['status'] = 0;
            $json['message'] =
                'Device ' .
                $data->nhdin .
                ' Already present in ' .
                $old_so->salesorder_code;
            echo json_encode($json);
            die();
        }

        if ($data->device_sub_category != $device_sub_category) {
            $json['status'] = 0;
            $json['message'] =
                $data->nhdin_id .
                ' is not a ' .
                $device_sub_category .
                ' device';
            echo json_encode($json);
            die();
        }

        $price_arr = [
            'nhdin' => $data->nhdin,
            'mrp' => $data->mrp,
            'grnreport_id' => $data->grnreport_id,
            'product_brand' => $data->product_brand,
            'device_name' => $data->device_name,
            'sku' => $data->SKU,
            'category' => $data->stock_type,
            'certification_grade' => $data->certification_grade,
        ];
        $json_array['status'] = 1;
        $json_array['message'] = 'Success';
        $json_array['result'] = $price_arr;
        echo json_encode($json_array);
        exit();
    }

    public function getMRP_log()
    {
        //get nhdin
        $nhdin = $this->input->get('nhdin');
        $json_array = [];
        if (strlen($nhdin) <= 0) {
            $json_array['status'] = 0;
            $json_array['message'] = 'Invalid nhdin';
            echo json_encode($json_array);
            exit();
        }
        $where = [
            'nhdin' => $nhdin,
        ];
        $data = $this->db
            ->select('*')
            ->where($where)
            ->get('tbl_grnreport_price_log')
            ->result();

        if (empty($data)) {
            $json_array['status'] = 0;
            $json_array['message'] = 'Invalid nhdin';
            echo json_encode($json_array);
            exit();
        }

        $json_array['status'] = 1;
        $json_array['message'] = 'Success';
        $json_array['data'] = $data;
        exit();
    }

    public function getDevicePriceList()
    {
        $action = $this->input->get('action');

        if ($action == 'SOLD') {
            $where_arr = array(
                'tbl_grnreport.saletype' => 'OFFLINE',
                'tbl_grnreport.mrp>' => 0,
                'tbl_grnreport.status' => 'SOLD',
            );
        } else {
            $where_arr = array(
                'tbl_grnreport.saletype' => 'OFFLINE',
                'tbl_grnreport.mrp>' => 0,
                'tbl_grnreport.status !=' => 'SOLD',
            );
        }


        $result = $this->db
            ->select('tbl_grnreport.*, tbl_grnreport_price_log.lot_no')
            ->where($where_arr)
            ->join('tbl_grnreport_price_log', 'tbl_grnreport.nhdin = tbl_grnreport_price_log.nhdin', 'left')
            ->get('tbl_grnreport')
            ->result();
        $json_array = [];
        if (empty($result)) {
            $json_array['status'] = 0;
            $json_array['data'] = [];
            echo json_encode($json_array);
            exit();
        }
        $data = [];
        foreach ($result as $key => $rowValue) {
            $data[] = [
                'grnreport_id' => $rowValue->grnreport_id,
                'device_id' => $rowValue->nhdin,
                'mrp' => $rowValue->mrp,
                'device_name' => $rowValue->device_name,
                'sku' => $rowValue->SKU,
                'category' => $rowValue->stock_type,
                'status' => $rowValue->status,
                'batch_no' => $rowValue->batch_no,
                'lot_no' => $rowValue->lot_no,
            ];
            unset($result[$key]);
        }
        $json_array['status'] = 1;
        $json_array['data'] = $data;
        unset($data);
        echo json_encode($json_array);
        exit();
    }

    //Create SO and Invoice
    public function createInvoice()
    {
        //get JSON data
        $data = json_decode(file_get_contents('php://input'), true);
        $customer_id = $data['customer_id'];
        $bundle_cat = $data['device_sub_category'];
        $shipping_from_id = $data['shipping_from_id'];
        $shipping_to_data = $data['shipping_data'][0];
        $nhdin = [];
        $nhdin_amount = [];
        if (empty($data['items'])) {
            $json_array['status'] = 0;
            $json_array['message'] = 'No items found';
            echo json_encode($json_array);
            exit();
        }
        foreach ($data['items'] as $item) {
            $nhdin[] = strtoupper($item['nhdin']);
            $nhdin_amount[$item['grnreport_id']] = $item['price'];
        }
        //var_dump($nhdin_amount);exit;
        //Get Product Details
        $nhdin_result = $this->db
            ->select(
                'grnreport_id, nhdin, SKU, saletype, stock_type, status, invoice_type, certification_grade, tax_type, product_brand, device_name, mrp, unit_price, unit_price_tax, bundle_id'
            )
            ->where_in('nhdin', $nhdin)
            ->get('tbl_grnreport')
            ->result_array();

        $bundle_ids = [];
        $invoice_item_arr = [];
        $item_arr = [];
        $grn_id_arr = [];
        $existing_nhdin_arr = [];
        $total_amount = 0;
        $total_tax = 0;
        foreach ($nhdin_result as $rowValue) {
            
            if($bundle_cat == "BUNDLE"){
               $bundle_id = $rowValue['bundle_id'];
                if(!(in_array($bundle_ids))){
                    array_push($bundle_ids,$bundle_id);
                } 
            }
            
            
            if (in_array(strtoupper($rowValue['nhdin']), $nhdin)) {
                if ($rowValue['saletype'] != 'OFFLINE') {
                    $json_array['status'] = 0;
                    $json_array['message'] =
                        'Device ' .
                        $rowValue['nhdin'] .
                        ' not an OFFLINE Device';
                    echo json_encode($json_array);
                    die();
                }

                if ($rowValue['status'] != 'RFS') {
                    $json_array['status'] = 0;
                    $json_array['message'] =
                        'Device ' . $rowValue['nhdin'] . ' not a RFS Device';
                    echo json_encode($json_array);
                    die();
                }

                if ($rowValue['mrp'] <= 0) {
                    $json_array['status'] = 0;
                    $json_array['message'] =
                        'Device ' . $rowValue['nhdin'] . ' doesn\'t have a MRP amount';
                    echo json_encode($json_array);
                    die();
                }
                if($bundle_cat != "BUNDLE"){
                    if ($rowValue['bundle_id'] > 0) {
                        $json_array['status'] = 0;
                        $json_array['message'] =
                            'Device ' . $rowValue['nhdin'] . ' is Bundle Device';
                        echo json_encode($json_array);
                        die();
                    }    
                }
                

                if (
                    strtolower($rowValue['invoice_type']) == 'exempt' ||
                    strtolower($rowValue['invoice_type']) == 'exempted'
                ) {
                    $exempt_amount = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                    $sale_price = $nhdin_amount[$rowValue['grnreport_id']];

                    $margin = $sale_price - $exempt_amount;
                    $taxable_amount = $margin / 1.18;
                    $tax_amount = $margin - $taxable_amount;

                    if ($exempt_amount > $sale_price) {
                        $exempt_amount = $sale_price;
                        $taxable_amount = 0;
                        $tax_amount = 0;
                    }
                } else {
                    $sale_price = $nhdin_amount[$rowValue['grnreport_id']];
                    $taxable_amount = $sale_price / 1.18;
                    $tax_amount = $sale_price - $taxable_amount;
                    $exempt_amount = 0;
                }
                $total_amount += $sale_price;
                $total_tax += $tax_amount;
                $invoice_item_arr[] = [
                    'grnreport_id' => $rowValue['grnreport_id'],
                    'price' => $sale_price,
                    'tax_amount' => $tax_amount,
                    'taxable_amount' => $taxable_amount,
                    'exempt_amount' => $exempt_amount,
                    'margin' => $taxable_amount,
                    'sales_terms' => $data['sales_terms'],
                    'category' => $rowValue['stock_type'],
                    'grade' => $rowValue['certification_grade'],
                    'bill_type' => $rowValue['invoice_type'],
                    'CREATION_DATE' => date('Y-m-d H:i:s'),
                ];

                $item_arr[] = [
                    'grnreport_id' => $rowValue['grnreport_id'],
                    'sku' => $rowValue['SKU'],
                    'category' => $rowValue['stock_type'],
                    'grade' => $rowValue['certification_grade'],
                    'brand' => $rowValue['product_brand'],
                    'device_name' => $rowValue['device_name'],
                    'quantity' => 1,
                    'sale_price' => $sale_price,
                    'amount' => $sale_price,
                ];
                $sold_items[] = [
                    'grnreport_id' => $rowValue['grnreport_id'],
                    'status' => 'SOLD',
                ];
                $grn_id_arr[] = $rowValue['grnreport_id'];
                $existing_nhdin_arr[] = strtoupper($rowValue['nhdin']);
            } else {
                $json_array['status'] = 0;
                $json_array['message'] = 'Invalid nhdin' . $rowValue['nhdin'];
                echo json_encode($json_array);
                exit();
            }
        }

        if ($data['discount_value'] > 0) {
            $discount = $data['discount_value'];
            if ($data['discount_type'] == 'amount') {
                $discount_amount = $discount;
            } else {
                $discount_amount = $discount * $total_amount / 100;
            }
        } else {
            $discount_amount = 0;
        }

        if ($data['freight_amount'] > 0) {
            $freight_amount = $data['freight_amount'];
        } else {
            $freight_amount = 0;
        }

        //Compare existing nhdin and $nhdin
        $diff_nhdin = array_diff($nhdin, $existing_nhdin_arr);

        if (!empty($diff_nhdin)) {
            $json_array['status'] = 0;
            $json_array['message'] =
                'Invalid Device ids : ' . implode(',', $diff_nhdin);
            echo json_encode($json_array);
            exit();
        }

        //Check if grnreport_id exists in existing sales order
        $where_so_status = [
            'FINANCE_PENDING',
            'FINANCE_APPROVED',
            'FINANCE_REJECTED',
            'WAREHOUSE_REJECTED',
            'DRAFT',
            'INVOICED',
        ];
        $grn_id_result = $this->db
            ->select('grnreport_id')
            ->where_in('status', $where_so_status)
            ->where_in('grnreport_id', $grn_id_arr)
            ->join(
                'tbl_salesorder_item',
                'tbl_salesorder.salesorder_id = tbl_salesorder_item.salesorder_id',
                'left'
            )
            ->get('tbl_salesorder')
            ->result_array();

        if (count($grn_id_result) > 0) {
            $grn_str = '';
            foreach ($grn_id_result as $rowValue) {
                $grn_str .= $rowValue['grnreport_id'] . ', ';
            }
            $json_array['status'] = 0;
            $json_array['message'] =
                $grn_str . ' already exists in a sales order';
            echo json_encode($json_array);
            exit();
        }

        //Start Mysql Transaction
        $this->db->trans_start();

        //Create Customer
        if (empty($customer_id)) {
            $customer_details = $data['customer_details'];
            $insert_arr = [];

            $insert_arr['added_userid'] = $this->session->userdata('user_id');
            $insert_arr['name'] = $customer_details['customer_name'];
            $insert_arr['company'] = $customer_details['customer_name'];
            $insert_arr['user_type'] = 'INDIVIDUAL';
            if (!empty($customer_details['customer_email'])) {
                $insert_arr['email'] = $customer_details['customer_email'];
            } else {
                $insert_arr['email'] = '';
            }
            $insert_arr['mobile'] = $customer_details['customer_mobile'];

            //Sanitize Customer Address
            $insert_arr['address'] = $customer_details['customer_address'];
            $insert_arr['city'] = $customer_details['customer_city'];
            $insert_arr['state'] = $customer_details['customer_state'];
            $insert_arr['country'] = 'INDIA';
            $insert_arr['pincode'] = $customer_details['customer_pincode'];
            $insert_arr['gst_no'] = $customer_details['customer_gstin'];
            $insert_arr['pan_card'] = $customer_details['customer_pan'];
            $insert_arr['used_type'] = 'buyer';
            $insert_arr['created_date'] = date('Y-m-d H:i:s');
            if (!empty($customer_details['customer_alias'])) {
                $insert_arr['alias'] = $customer_details['customer_alias'];
            }

            //Insert Customer
            $this->db->insert('tbl_vendor', $insert_arr);
            $customer_id = $this->db->insert_id();
            //If Error Return false
            if (empty($customer_id)) {
                $json_array['status'] = 0;
                $json_array['message'] = 'Error in creating customer';
                echo json_encode($json_array);
                exit();
            }

            $customer_code = 'SLYB-H-B2C-' . $customer_id;
            $this->db->where('vendor_id', $customer_id);
            $this->db->update('tbl_vendor', [
                'vendor_code' => $customer_code,
            ]);

            //unset
            unset($insert_arr);
            unset($customer_details);
            unset($data['customer_details']);
        }

        if (empty($customer_id)) {
            $this->db->trans_rollback();
            $json_array['status'] = 0;
            $json_array['message'] = 'Failed to create Customer';
            echo json_encode($json_array);
            exit();
        }

        $state_gst_id = $this->db->select('state_gst_id')->where('vendor_id', $customer_id)->join('tbl_vendor', 'tbl_vendor.state = tbl_states.state_id')->get('tbl_states')->row()->state_gst_id;

        if ($state_gst_id == 36) {
            $tax_type = 'CGST18';
        } else {
            $tax_type = 'IGST18';
        }

        //Create Sales Order
        $res = $this->db
            ->select(
                'max(CAST(SUBSTRING_INDEX(salesorder_code,"-",-1) as UNSIGNED)) as max'
            )
            ->from('tbl_salesorder')
            ->get()
            ->row_array();
        $next_number = $res['max'] + 1;

        if ($res['max'] == null) {
            $next_number = 1;
        }

        $salesorder_code = 'SO-HYD-' . $next_number;
        if($data['device_sub_category'] == "BUNDLE"){
            $device_sub_cat = "SG100";  
        } else{
            $device_sub_cat = $data['device_sub_category'];
        }
        $headerArray = [
            'vendor_id' => $customer_id,
            'salesorder_code' => $salesorder_code,
            'salesman_code' => $data['sales_executive'],
            'payment_mode' => $data['payment_mode'],
            'warehouse' => "HYD",
            'sales_channel' => 'OFFLINE',
            'saleschannel_ref_id' => $data['saleschannel_ref_id'],
            'device_sub_category' => $device_sub_cat,
            'tcs_amount' => $data['tcs_value'],
            'tcs_percent' => $data['tcs_percentage'],
            'status' => 'INVOICED',
            'discount_type' => $data['discount_type'],
            'discount_amount' => $discount_amount,
            'discount_value' => $data['discount_value'],
            'insurance_type' => 'amount',
            'insurance_amount' => 0,
            'insurance_value' => 0,
            'freight_amount' => $freight_amount,
            'CREATION_DATE' => date('Y-m-d H:i:s'),
            'CREATED_BY' => $this->session->userdata('user_id'),
        ];
	$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $string = substr("HYD", 0, 1);
        $series = "SL".$string.$current_year.$next_year;
	
        $res = $this->db
            ->select(
                'max(CAST(SUBSTRING_INDEX(invoice_code,"-",-1) as UNSIGNED)) as max'
            )
            ->from('tbl_invoice')
	    ->like('invoice_code',$series)
            ->get()
            ->row_array();
        $next_number = $res['max'] + 1;
        if ($res['max'] == null) {
            $next_number = 1;
        }
        //$invoice_code = 'SLY-HYD-' . $next_number;
        $invoice_code=$series.'-'.$next_number;

        $this->db->insert('tbl_salesorder', $headerArray);
        $salesorder_id = $this->db->insert_id();
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        //Create Sales Order Item
        //Add salesorder_id to item array
        foreach ($item_arr as $key => $value) {
            $item_arr[$key]['salesorder_id'] = $salesorder_id;
        }
        $this->db->insert_batch('tbl_salesorder_item', $item_arr);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        //Create Invoice
        //Invoice Header
        $invoice_header = [
            'vendor_id' => $customer_id,
            'invoice_code' => $invoice_code,
            'salesorder_id' => $salesorder_id,
            'salesman_id' => $data['sales_executive'],
            'sales_channel' => 'OFFLINE',
            'warehouse' => 'HYD',
            'status' => 'INVOICED',
            'invoice_amount' => $total_amount,
            'tax_amount' => $total_tax,
            'payment_mode' => $data['payment_mode'],
            'CREATION_DATE' => date('Y-m-d H:i:s'),
            'CREATED_BY' => $this->session->userdata('user_id'),
        ];

        //Inset invoice header to tbl_invoice
        $this->db->insert('tbl_invoice', $invoice_header);
        $invoice_id = $this->db->insert_id();
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        //Add invooice_id, tax_type to invoice_item
        foreach ($invoice_item_arr as $key => $value) {
            $invoice_item_arr[$key]['invoice_id'] = $invoice_id;
            $invoice_item_arr[$key]['tax_type'] = $tax_type;
        }

        //Insert invoice item to tbl_invoice_item
        $this->db->insert_batch('tbl_invoice_item', $invoice_item_arr);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        //Add invoice_code to sold_items
        foreach ($sold_items as $key => $value) {
            $sold_items[$key]['remark'] = $invoice_code;
        }

        //update sold_items in tbl_grnreport
        $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json_array['status'] = 0;
            $json_array['message'] = $error['message'];
            echo json_encode($json_array);
            exit();
        }

        $new_receipt_details = $data['new_receipt_details'];

        foreach ($new_receipt_details as $receiptRow) {
            $res = $this->db->select('max(CAST(SUBSTRING_INDEX(receipt_no,"-",-1) as UNSIGNED)) as max')->from('tbl_receipt')->get()->row_array();
            $next_number = $res['max'] + 1;
            $receipt_no = 'RCPT-' . $next_number;
            $record = array(
                "receipt_no" => $receipt_no,
                "vendor_id"  => $customer_id,
                "receipt_type" => $receiptRow["receipt_type"],
                "account_no" => $receiptRow["bank_account"],
                "received_or_verified_by" => $receiptRow["received_or_verified_by"],
                "reference_no" => $receiptRow["receipt_ref_no"],
                "received_amount" => $receiptRow["receipt_amount"],
                "received_date" => $receiptRow["receipt_date"],
                "CREATED_BY" => $this->session->userdata('user_id'),
                "CREATION_DATE" => date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_receipt', $record);
            $receipt_id = $this->db->insert_id();
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }

            $net_amount = $total_amount + $data['tcs_value'];
            $receipt[] = array(
                'receipt_id' => $receipt_id,
                'vendor_id' => $customer_id,
                'salesorder_id' => $salesorder_id,
                'receipt_amount' => $receiptRow['receipt_amount'],
                'salesorder_amount' => $net_amount,
                'adjusted_amount' => $receiptRow['adjusted_amount'],
                'CREATED_BY' => $this->session->userdata('user_id')

            );
        }

        $receipt_details = $data['receipt_details'];
        foreach ($receipt_details as $receiptRow) {
            $receipt[] = array(
                'receipt_id' => $receiptRow['receipt_id'],
                'vendor_id' => $customer_id,
                'salesorder_id' => $salesorder_id,
                'receipt_amount' => $receiptRow['receipt_amount'],
                'salesorder_amount' => $net_amount,
                'adjusted_amount' => $receiptRow['adjusted_amount'],
                'CREATED_BY' => $this->session->userdata('user_id')

            );
        }

        $this->db->insert_batch('tbl_receipt_so', $receipt);
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $state_name = $this->db->get_where('tbl_states', array("state_id" => $shipping_to_data['to_state']))->row()->name;;
        $shipping_to = array(
                "shipping_from_id"  => $shipping_from_id,
                "salesorder_id"     => $salesorder_id,
                "address"           => $shipping_to_data['to_address'],
                "city"              => $shipping_to_data['to_city'],
                "state"             => $state_name,
                "pincode"           => $shipping_to_data['to_pincode']
                );

        $insrert = $this->db->insert('tbl_shipping_to_address', $shipping_to);
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        //Commit Transaction
        $this->db->trans_complete();

        try {
            if (!empty($param['remarks_header'])) {
                $remark_array = [
                    'reference_id' => $invoice_id,
                    'reference_type' => 'invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $param['remarks_header'],
                    'date' => date('Y-m-d H:i:s'),
                ];
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();

                $remark_array = [
                    'reference_id' => $salesorder_id,
                    'reference_type' => 'salesorder',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $param['remarks_header'],
                    'date' => date('Y-m-d H:i:s'),
                ];
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }

            $this->load->model('auditlog_model');
            // Insert audit log for invoice
            $this->auditlog_model->insert_auditlog(
                $salesorder_id,
                'salesorder',
                'INVOICED',
                $this->session->userdata('user_id')
            );
            $this->auditlog_model->insert_auditlog(
                $invoice_id,
                'invoice',
                'INVOICED',
                $this->session->userdata('user_id')
            );
            $this->auditlog_model->insert_auditlog($receipt_id, 'receipt', 'CREATED', $this->session->userdata('user_id'));
            if($bundle_cat == "BUNDLE"){
                $this->db->where_in('bundle_id', $bundle_ids)->update('tbl_dealer_bundle', array("order_id" => $salesorder_id,"status"=>"RESERVE"));
            }
        } catch (Exception $e) {
        }

        $json_array['status'] = 1;
        $json_array['message'] = 'Sales Order Created Successfully';
        echo json_encode($json_array);
        $this->cliq_api->postSalesImage($salesorder_id);
        exit();
    }


    public function getStateList()
    {
        $result = $this->db->get('tbl_states')->result_array();
        $states_arr = [];
        foreach ($result as $rowValue) {
            $states_arr[] = array(
                "state_id" => $rowValue['state_id'],
                "state_name" => $rowValue['name']
            );
        }

        $json_array = array();
        $json_array['status'] = 1;
        $json_array['result'] = $states_arr;
        echo json_encode($json_array);
        exit;
    }

    public function getTax()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, true);

        if (empty($data)) {
            $json_array = array();
            $json_array['status'] = 0;
            $json_array['message'] = 'No Devices Found';
            echo json_encode($json_array);
            exit;
        }

        $result = $this->db->select('unit_price, mrp, stock_type, invoice_type')->where_in('grnreport_id', $data)->get('tbl_grnreport')->result_array();

        $total_tax = 0;
        $total_exempt = 0;
        $total_taxable = 0;
        foreach ($result as $rowValue) {
            if (
                strtolower($rowValue['invoice_type']) == 'exempt' ||
                strtolower($rowValue['invoice_type']) == 'exempted'
            ) {
                $exempt_amount = $rowValue['unit_price'] + $rowValue['unit_price_tax'];
                $sale_price = $rowValue['mrp'];

                $margin = $sale_price - $exempt_amount;
                $taxable_amount = $margin / 1.18;
                $tax_amount = $margin - $taxable_amount;

                if ($exempt_amount > $sale_price) {
                    $exempt_amount = $sale_price;
                    $taxable_amount = 0;
                    $tax_amount = 0;
                }
            } else {
                $sale_price = $rowValue['mrp'];
                $taxable_amount = $sale_price / 1.18;
                $tax_amount = $sale_price - $taxable_amount;
                $exempt_amount = 0;
            }
            $total_tax += $tax_amount;
            $total_exempt += $exempt_amount;
            $total_taxable += $taxable_amount;
        }

        $result_arr = array(
            "total_tax" => $total_tax,
            "total_exempt" => $total_exempt,
            "total_taxable" => $total_taxable
        );

        $json_array = array();
        $json_array['status'] = 1;
        $json_array['result'] = $result_arr;
        echo json_encode($json_array);
        exit;
    }
}
