<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Ecom_invoice extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('hostbooks_authenticator');
    }

    public function manage_ecom_invoice($active = 1) {

        if ($active == 2) {
            return $this->new_ecom_invoice();
        }

        $data['title'] = 'ECOM INVOICE';
        $data['active'] = $active;
        
        $data['subview'] = $this->load->view('admin/ecom_invoice/manage_ecom_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function new_ecom_invoice($order_id = null) {
        if (!isset($order_id)) {
            echo 'Invalid Order ID';
            exit;
        }

        $where_arr = [
            'amazon_order_id' => $order_id,
            // 'is_added_inERP' => 0,
        ];
        $rs = $this->db->from('tbl_amazon_orders_data')->where($where_arr)->get()->result_array();
        if (count($rs) == 0) {
            echo 'Invalid Order ID';
            exit;
        }
        if ($rs[0]['is_added_inERP'] == 1) {
            echo 'Order ID already added into ERP';
            exit;
        }

        $data['title'] = 'ECOM INVOICE';
        $data['active'] = 2;
        $data['order_id'] = $order_id;
        
        $data['subview'] = $this->load->view('admin/ecom_invoice/manage_ecom_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function updateInvoiceForm($invoice_id)
    {

        if (empty($invoice_id) || (int) $invoice_id <= 0) {
            $data['active'] = 1;
        } else {
            $data['active'] = 3;
            $data['update_ecom_invoice_id'] = $invoice_id;
        }

        $data['title'] = 'UPDATE INVOICE';
        $data['subview'] = $this->load->view('admin/ecom_invoice/manage_ecom_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function editEcomInvoiceForm($invoice_id)
    {
        if (empty($invoice_id) || (int) $invoice_id <= 0) {
            $data['active'] = 1;
        } else {
            $data['active'] = 8;
            $data['edit_ecom_invoice_id'] = $invoice_id;
        }

        $data['title'] = 'EDIT INVOICE';
        $data['subview'] = $this->load->view('admin/ecom_invoice/manage_ecom_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function getEcomInvoiceList()
    {
        $status = $this->input->get('status');
        $saleschannel_ref_id = $this->input->get('saleschannel_ref_id');

        if (!empty($status)) {
            $this->db->where('status', $status);
        }

        if (!empty($saleschannel_ref_id)) {
            $this->db->where('saleschannel_ref_id', $saleschannel_ref_id);
        }

        $result = $this->db->get('ECOM_INVOICE_LIST_VIEW')->result_array();
        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        $records = array();
        foreach ($result as $rowValue) {
            $sale_date = date("d-m-Y", strtotime($rowValue['sale_date']));
            if ($sale_date == '01-01-1970' || $sale_date == '30-11--0001') {
                $sale_date = '';
            }
            $records[] = array(
                'ecom_invoice_id' => $rowValue['ecom_invoice_id'],
                'ecom_invoice_no' => $rowValue['ecom_invoice_no'],
                'creditnote_no' => $rowValue['creditnote_no'],
                'vendor_name' => $rowValue['vendor_name'],
                'vendor_id' => $rowValue['vendor_id'],
                'salesman' => $rowValue['salesman'],
                'salesman_id' => $rowValue['salesman_id'],
                'status' => $rowValue['status'],
                'return_type' => $rowValue['return_type'],
                'payment_mode' => $rowValue['payment_mode'],
                'warehouse' => $rowValue['warehouse'],
                'sales_channel' => $rowValue['sales_channel'],
                'saleschannel_ref_id' => $rowValue['saleschannel_ref_id'],
                'invoice_ref_id' => $rowValue['invoice_ref_id'],
                'quantity' => $rowValue['quantity'],
                'total_amount' => $rowValue['invoice_amount'],
                'total_taxable' => $rowValue['taxable_amount'],
                'total_exempt' => $rowValue['exempt_amount'],
                'total_tax' => $rowValue['tax_amount'],
                "sale_date" => $sale_date,
                'created_by' => $rowValue['created_by'],
                'last_updated_by' => $rowValue['last_updated_by'],
                "creation_date" => date("d-m-Y", strtotime($rowValue['creation_date'])),
                "last_update_date" => date("d-m-Y", strtotime($rowValue['last_update_date']))
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getEcomInvoiceDetails()
    {
        $ecom_invoice_id = $this->input->get('ecom_invoice_id');

        if (empty($ecom_invoice_id) || (int) $ecom_invoice_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        // $this->db->where('ecom_invoice_id', $ecom_invoice_id);
        // $result = $this->db->get('tbl_ecom_invoice_item')->result_array();

        $result = $this->db->from('tbl_ecom_invoice_item AS eii')
                ->join('tbl_stocktransfer_invoice AS sti', 'sti.stocktransfer_invoice_id = eii.stocktransfer_invoice_id', 'LEFT')
                ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'LEFT')
                ->join('tbl_stocktransfer_note AS stn', 'stn.stocktransfer_invoice_id = eii.stocktransfer_invoice_id', 'LEFT')
                ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'Left')
                ->where('eii.ecom_invoice_id', $ecom_invoice_id)
                ->group_by('eii.ecom_invoice_item_id')
                ->select("eii.*, d.nhdin, d.imei1_no, d.imei2_no, GROUP_CONCAT(stn.to_loc ORDER BY stn.stocktransfer_note_id ASC SEPARATOR ',') AS stn_locns, st.from_loc AS st_from_loc, st.to_loc AS st_to_loc")
                ->get()->result_array();
                // ->get_compiled_select();
        // echo $result; die;

        $records = array();
        if (!empty($result)) {
            foreach ($result as $rowValue) {

                $this->db->where('tbl_stocktransfer_item.fnsku', $rowValue['fnsku']);
                $this->db->select('tbl_grnreport.SKU, tbl_grnreport.device_name');
                $this->db->join('tbl_grnreport', 'tbl_grnreport.SKU = tbl_stocktransfer_item.sku', 'Left');
                $device_row = $this->db->get('tbl_stocktransfer_item')->row();

                $records[] = array(
                    "ecom_invoice_id" => $rowValue['ecom_invoice_id'],
                    "ecom_invoice_item_id" => $rowValue['ecom_invoice_item_id'],
                    "stock_type" => $rowValue['category'],
                    "nhdin" => $rowValue['nhdin'],
                    "imei1_no" => $rowValue['imei1_no'],
                    "imei2_no" => $rowValue['imei2_no'],
                    "device_name" => $device_row->device_name,
                    "sku" => $device_row->SKU,
                    "fnsku" => $rowValue['fnsku'],
                    "price" => $rowValue['price'],
                    "taxable_amount" => $rowValue['taxable_amount'],
                    "exempt_amount" => $rowValue['exempt_amount'],
                    "tax_amount" => $rowValue['tax_amount'],
                    "tax_type" => $rowValue['tax_type'],
                    "bill_type" => $rowValue['bill_type'],
                    "stn_locns" => $rowValue['stn_locns'],
                    "st_from_loc" => $rowValue['st_from_loc'],
                    "st_to_loc" => $rowValue['st_to_loc'],
                );
            }
        }

        $json['result'] = $records;
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getEcomInvoiceHeader($ecom_invoice_id)
    {

        if (empty($ecom_invoice_id) || (int) $ecom_invoice_id <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->where('ecom_invoice_id', $ecom_invoice_id);
        $result = $this->db->get('ECOM_INVOICE_LIST_VIEW')->row();
        if (empty($result)) {
            $json['data'] = array();
            echo json_encode($json);
            exit;
        }
        $records = array();

        $records[] = array(
            'ecom_invoice_id' => $result->ecom_invoice_id,
            'ecom_invoice_no' => $result->ecom_invoice_no,
            'vendor_name' => $result->vendor_name,
            'vendor_id' => $result->vendor_id,
            'salesman' => $result->salesman,
            'salesman_id' => $result->salesman_id,
            'status' => $result->status,
            'payment_mode' => $result->payment_mode,
            'warehouse' => $result->warehouse,
            'sales_channel' => $result->sales_channel,
            'sale_date' => $result->sale_date,
            'source_invoice_date' => $result->source_invoice_date,
            'saleschannel_ref_id' => $result->saleschannel_ref_id,
            'invoice_ref_id' => $result->invoice_ref_id,
            'quantity' => $result->quantity,
            'total_amount' => $result->invoice_amount,
            'total_taxable' => $result->taxable_amount,
            'total_exempt' => $result->exempt_amount,
            'total_tax' => $result->tax_amount,
            'created_by' => $result->created_by,
            'last_updated_by' => $result->last_updated_by,
            "creation_date" => date("d-m-Y", strtotime($result->creation_date)),
            "last_update_date" => date("d-m-Y", strtotime($result->last_update_date))
        );

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function createEcomInvoice()
    {

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $sales_channel_ref_id = $this->db->where('saleschannel_ref_id', trim($data["saleschannel_ref_id"]))->get('tbl_ecom_invoice')->row();

        if (!empty($sales_channel_ref_id)) {
            $json['status'] = 2;
            echo json_encode($json);
            exit;
        }

        $this->db->select('max(CAST(SUBSTRING_INDEX(ecom_invoice_no,"-",-1) as UNSIGNED)) as max')->where('warehouse', $data['warehouse']);
        $res = $this->db->where('ecom_invoice_no like "FF-%"')->from('tbl_ecom_invoice')->get()->row_array();
        $next_number = $res['max'] + 1;
        $ecom_invoice_no = 'FF-' . $data["warehouse"] . '-' . $next_number;

        $vendorState = $this->db->select('state')->where('vendor_id', $data["vendor_id"])->get('tbl_vendor')->row()->state;
        $vendor_state_gst = $this->db->select('state_gst_id')->where('state_id', $vendorState)->get('tbl_states')->row()->state_gst_id;

        $warehouse_state_gst = $this->db->select('state_gst_code')->where('short_code', $data['warehouse'])->get('tbl_wh_loc')->row()->state_gst_code;

        if ($warehouse_state_gst == $vendor_state_gst) {
            $tax_type = 'CGSG18';
        } else {
            $tax_type = 'IGST18';
        }

        $total_amount = 0;
        $taxable_total = 0;
        $exempt_total = 0;
        $tax_total = 0;

        foreach ($data["rows"] as $value) {

            $tax = 0;
            if(in_array('AMAZON-FBA', MARGINAL_NOT_ALLOWED_CHANNELS)){
                $tax = $value['price'] - $value['price'] / 1.18;
                $taxable = $value['price'] / 1.18;
                $exempt = 0.00;
            }else{
                if (strtolower($value['bill_type']) == 'taxable') {

                    $tax = $value['price'] - $value['price'] / 1.18;
                    $taxable = $value['price'] / 1.18;
                    $exempt = 0.00;
                }
    
                if (strtolower($value['bill_type']) == 'exempt') {
    
                    $margin = $value['price'] - ($value['unit_price'] + $value['unit_price_tax']);
                    $exempt = $value['unit_price'] + $value['unit_price_tax'];
                    $taxable = $margin / 1.18;
                    $tax = $margin - $taxable;
    
                    if ($margin < 0) $margin = 0;
    
                    if ($exempt > $value['price']) {
    
                        $exempt = $value['price'];
                        $tax = 0;
                        $taxable = 0;
                    }
                }
            }
            
            $total_amount += $value['price'];
            $taxable_total += $taxable;
            $exempt_total += $exempt;
            $tax_total += $tax;

            $rows[] = array(
                "grnreport_id" => $value["grnreport_id"],
                "fnsku" => $value["fnsku"],
                "price" => $value["price"],
                "tax_amount" => $tax,
                "taxable_amount" => $taxable,
                "exempt_amount" => $exempt,
                "category" => $value['category'],
                "tax_type" => $value["tax_type"],
                "bill_type" => $value["bill_type"],
                "tax_type" => $tax_type,
                "creation_date" => date("Y-m-d H:i:s")
            );
        }
        $sale_date = date("Y-m-d", $data['sale_date']);

        if ($sale_date == '1970-01-01') {
            $sale_date = date('Y-m-d');
        }

        $headerArray = array(
            "ecom_invoice_no" => $ecom_invoice_no,
            "vendor_id" => $data["vendor_id"],
            "sales_channel" => $data["sales_channel"],
            "saleschannel_ref_id" => trim($data["saleschannel_ref_id"]),
            "invoice_ref_id" => $data["invoice_ref_id"],
            "warehouse" => $data["warehouse"],
            "salesman_id" => $this->session->userdata('user_id'),
            "status" => "FINANCE_PENDING",
            "payment_mode" => $data["payment_mode"],
            "invoice_amount" => $total_amount,
            "taxable_amount" => $taxable_total,
            "exempt_amount" => $exempt_total,
            "tax_amount" => $tax_total,
            "sale_date" => $data['sale_date'],
            "created_by" => $this->session->userdata('user_id'),
            "creation_date" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->insert('tbl_ecom_invoice', $headerArray);
        $invoice_id = $this->db->insert_id();

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        foreach ($rows as $key => $rowArray) {

            $rows[$key]["ecom_invoice_id"] = $invoice_id;
        }

        $this->db->insert_batch('tbl_ecom_invoice_item', $rows);

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $invoice_id,
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->db->trans_complete();

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function createEcomInvoiceByFNSKU() {
        return $this->createEcomInvoiceByDevice();
    }
    
    public function createEcomInvoiceByDevice() {

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data)) {
            $msg = 'Invalid Entries';
            GOTO ERROR;
        }

        $saleschannel_ref_id = trim($data["saleschannel_ref_id"]);
        if (empty($saleschannel_ref_id)) {
            $msg = 'Invalid SalesChannel RefID';
            GOTO ERROR;
        }
        $rs = $this->db->from('tbl_amazon_orders_data')->where('amazon_order_id', $saleschannel_ref_id)->get()->result_array();
        if (count($rs) == 0) {
            echo 'Invalid SalesChannel RefID';
            GOTO ERROR;
        }
        $check_OrderID = $this->db->where('saleschannel_ref_id', $saleschannel_ref_id)->where('status != "CANCELLED"')->get('tbl_ecom_invoice')->row();
        if ($rs[0]['is_added_inERP'] == 1 || !empty($check_OrderID)) {
            echo 'SalesChannel RefID already added into ERP';
            GOTO ERROR;
        }

	$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        $series = $data["warehouse"]."FBA".$current_year.$next_year;

        $this->db->select('max(CAST(SUBSTRING_INDEX(ecom_invoice_no,"-",-1) as UNSIGNED)) as max')->where('warehouse', $data['warehouse']);
        $res = $this->db->like('ecom_invoice_no',$series)->from('tbl_ecom_invoice')->get()->row_array();
        $next_number = $res['max'] + 1;
        $ecom_invoice_no = $series . '-' . $next_number;

        $vendorState = $this->db->select('state')->where('vendor_id', $data["vendor_id"])->get('tbl_vendor')->row()->state;
        $vendor_state_gst = $this->db->select('state_gst_id')->where('state_id', $vendorState)->get('tbl_states')->row()->state_gst_id;

        $warehouse_state_gst = $this->db->select('state_gst_code')->where('short_code', $data['warehouse'])->get('tbl_wh_loc')->row()->state_gst_code;

        if ($warehouse_state_gst == $vendor_state_gst) {
            $tax_type = 'CGSG18';
        } else {
            $tax_type = 'IGST18';
        }
        
        $sale_date = date("Y-m-d", $data['sale_date']);
        if ($sale_date == '1970-01-01') {
            $sale_date = date('Y-m-d');
        }

        $total_amount = 0;
        $taxable_total = 0;
        $exempt_total = 0;
        $tax_total = 0;

        $FnskuWise_stn_objs = $data['FnskuWise_stn_objs'];
        
        $this->db->trans_start();

        foreach ($data["rows"] as $value) {

            $tax = 0;

            for ($i = 0; $i < $value['quantity']; $i++) {
                $stocktransfer_note_id = null;
                $fnsku = $value["fnsku"];

                if (is_null($value["st_invoice_id"]) && array_key_exists($fnsku, $FnskuWise_stn_objs)) {
                    foreach($FnskuWise_stn_objs[$fnsku] as $k => $v) {
                        if ((int)$v > 0 && ($k != $data["warehouse"])) {
                            $stn_data = [
                                'fnsku' => $fnsku,
                                'from_loc' => $k,
                                'to_loc' => $data["warehouse"],
                                'CREATED_BY' => $this->session->userdata('user_id'),
                                "CREATION_DATE" => date("Y-m-d H:i:s")
                            ];

                            $this->db->insert('tbl_stocktransfer_note', $stn_data);
                            $stocktransfer_note_id = $this->db->insert_id();

                            $error = $this->db->error();
                            if ($error['code'] != 0) {
                                $msg = 'Error in creating ST Note';
                                GOTO ERROR;
                            }

                            $FnskuWise_stn_objs[$fnsku][$k] = $v - 1;
                            break;
                        }
                    }
                }

                $tax = $value['price'] - $value['price'] / 1.18;
                $taxable = $value['price'] / 1.18;
                $exempt = 0.00;
                $bill_type = 'taxable';

                $total_amount += $value['price'];
                $taxable_total += $taxable;
                $exempt_total += $exempt;
                $tax_total += $tax;

                $rows[] = array(
                    "stocktransfer_note_id" => $stocktransfer_note_id,
                    "stocktransfer_invoice_id" => $value["st_invoice_id"],
                    "grnreport_id" => $value["device_id"],
                    "fnsku" => $value["fnsku"],
                    "price" => $value["price"],
                    "tax_amount" => $tax,
                    "taxable_amount" => $taxable,
                    "exempt_amount" => $exempt,
                    "bill_type" => $bill_type,
                    "category" => $value['category'],
                    "tax_type" => $tax_type,
                    "creation_date" => date("Y-m-d H:i:s")
                );
            }
        }

        $headerArray = array(
            "ecom_invoice_no" => $ecom_invoice_no,
            "vendor_id" => $data["vendor_id"],
            "sales_channel" => $data["sales_channel"],
            "saleschannel_ref_id" => trim($data["saleschannel_ref_id"]),
            "invoice_ref_id" => $data["invoice_ref_id"],
            "warehouse" => $data["warehouse"],
            "salesman_id" => $this->session->userdata('user_id'),
            "status" => "FINANCE_PENDING",
            "payment_mode" => $data["payment_mode"],
            "invoice_amount" => $total_amount,
            "taxable_amount" => $taxable_total,
            "exempt_amount" => $exempt_total,
            "tax_amount" => $tax_total,
            "sale_date" => $data['sale_date'],
            "source_invoice_date" => $data['source_invoice_date'],
            "created_by" => $this->session->userdata('user_id'),
            "creation_date" => date("Y-m-d H:i:s")
        );

        $this->db->insert('tbl_ecom_invoice', $headerArray);
        $invoice_id = $this->db->insert_id();

        $error = $this->db->error();

        if ($error['code'] != 0) {
            $msg = 'Error in saving Invoice';
            GOTO ERROR;
        }

        foreach ($rows as $key => $rowArray) {

            $rows[$key]["ecom_invoice_id"] = $invoice_id;
        }

        $this->db->insert_batch('tbl_ecom_invoice_item', $rows);

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $msg = 'Error in saving Invoice Items';
            GOTO ERROR;
        }

        if (!empty($data['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $invoice_id,
                'reference_type' => 'ecom_invoice',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
            $error = $this->db->error();
        }

        $update = $this->db->where('amazon_order_id', $saleschannel_ref_id)->update('tbl_amazon_orders_data', ['is_added_inERP' => 1]);

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $msg = 'Error in Updating AmazonApiOrders Status';
            GOTO ERROR;
        }

        $this->db->trans_complete();

        echo json_encode([
            'status' => true,
            'message' => 'FBA Invoice Created Successfully'
        ]);
        exit;

        ERROR:
        $this->db->trans_rollback();
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something wrong'
        ]);
        exit;
    }
    
    /* Not required this anymore -- Bulk_AttachDeviceTo_EcomInvoice */
    public function Bulk_AttachDeviceTo_EcomInvoice() {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->trans_start();

        foreach($data as $key => $obj) {

            $ecom_invoice_no = $obj['ecom_invoice_no'];
            $saleschannel_ref_id = $obj['saleschannel_ref_id'];
            $imei = $obj['imei'];
            $fnsku = $obj['fnsku'];
            $warehouse = $obj['warehouse'];
            $sku = $obj['sku'];
            
            $Fetching_cnt = 0;
            FETCH_DEVICE_DETAILS:
            $Fetching_cnt++;

            $grn_join_cond = "d.grnreport_id = sti.device_id AND "
                    . "(d.imei1_no = '$imei' OR d.imei2_no = '$imei')";
            $stn_sql_custm = "(SELECT * FROM tbl_stocktransfer_note AS sn WHERE sn.stocktransfer_note_id = "
            ." (SELECT MAX(stocktransfer_note_id) FROM tbl_stocktransfer_note WHERE stocktransfer_invoice_id = sn.stocktransfer_invoice_id))";

            $this->db->select('sti.stocktransfer_invoice_id, sti.device_id, sti.fnsku, st.st_type, d.nhdin, d.device_name, d.SKU, d.warehouse, st.website, st.to_loc, stn.to_loc AS crnt_loc');
            $this->db->from('tbl_stocktransfer_invoice AS sti');
            $this->db->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER');
            $this->db->join($stn_sql_custm . ' AS stn', 'stn.stocktransfer_invoice_id = sti.stocktransfer_invoice_id', 'LEFT');
            $this->db->join('tbl_grnreport AS d', $grn_join_cond, 'INNER');
            $this->db->where('st.st_type', 'OUTWARD');
            $this->db->order_by('sti.stocktransfer_invoice_id', 'desc');
            $this->db->limit(1);
            $result = $this->db->get()->result_array();
            // $query = $this->db->get_compiled_select();echo $query; die;

            $error = $this->db->error();
            if ($error['code'] != 0 || count($result) != 1) {
                $json['status'] = 0;
                $json['message'] = 'Please check Device IMEI - for record no: ' . ($key + 1);
                echo json_encode($json);
                exit;
            }

            $device_details = $result[0];

            if ($device_details['st_type'] != 'OUTWARD') {
                echo json_encode([
                    'status' => 0,
                    'message' => 'The last Stock Transfer Type of this device is "'. $device_details['st_type'] .'" - for record no: ' . ($key + 1)
                ]);
                exit;
            } else if ($device_details['fnsku'] != $fnsku) {
                echo json_encode([
                    'status' => 0,
                    'message' => 'Lastly the device sent to Amazon warehouse with the FNSKU: "' . $device_details['fnsku'] . '" - for record no: ' . ($key + 1)
                ]);
                exit;
            } else if ($device_details['SKU'] != $sku) {
                echo json_encode([
                    'status' => 0,
                    'message' => 'Device IMEI and SKU mismatch - for record no: ' . ($key + 1)
                ]);
                exit;
            }

            $rs = $this->db->from('tbl_ecom_invoice_item AS eii')
                        ->join('tbl_ecom_invoice AS ei', 'ei.ecom_invoice_id = eii.ecom_invoice_id', 'INNER')
                        ->where('ei.saleschannel_ref_id', $saleschannel_ref_id)
                        ->where('ei.ecom_invoice_no', $ecom_invoice_no)
                        ->where('eii.fnsku', $fnsku)
                        ->where('eii.stocktransfer_invoice_id is null')
                        ->order_by('eii.ecom_invoice_item_id', 'ASC')
                        ->limit(1)
                        ->select('eii.*, ei.ecom_invoice_no, ei.status')
                        ->get()->result_array();
                        // ->get_compiled_select();echo $rs; die;
                        
            if (count($rs) != 1) {
                $json['status'] = 0;
                $json['message'] = 'Error in fetching Invoice details - for record no: ' . ($key + 1);
                echo json_encode($json);
                exit;
            }
            $invoice_item = $rs[0];

            if (isset($invoice_item['grnreport_id']) || isset($invoice_item['stocktransfer_invoice_id'])) {
                $json['status'] = 0;
                $json['message'] = 'This invoice already attached to a device - for record no: ' . ($key + 1);
                echo json_encode($json);
                exit;
            }

            if ($invoice_item['ecom_invoice_item_id'] > 0) {

                $device_loc = is_null($device_details['crnt_loc'])? $device_details['to_loc'] : $device_details['crnt_loc'];
        
                if ($device_loc != $warehouse) {

                    $data = [
                        'stocktransfer_invoice_id' => $device_details['stocktransfer_invoice_id'],
                        'device_id' => $device_details['device_id'],
                        'fnsku' => $device_details['fnsku'],
                        'from_loc' => $device_loc,
                        'to_loc' => $warehouse,
                        'CREATED_BY' => $this->session->userdata('user_id'),
                        "CREATION_DATE" => date("Y-m-d H:i:s")
                    ];

                    $this->db->insert('tbl_stocktransfer_note', $data);
                    $error = $this->db->error();
                    if ($error['code'] != 0) {
                        $this->db->trans_rollback();
                        $json['status'] = 0;
                        $json['message'] = 'Error in STN creation - for record no: ' . ($key + 1);
                        echo json_encode($json);
                        die;
                    }

                    if ($Fetching_cnt == 1) {
                        GOTO FETCH_DEVICE_DETAILS;
                    } else {
                        $this->db->trans_rollback();
                        $json['status'] = 0;
                        $json['message'] = 'Error in STN creation - for record no: ' . ($key + 1);
                        echo json_encode($json);
                        die;
                    }
                }

                $update = $this->db->where('ecom_invoice_item_id', $invoice_item['ecom_invoice_item_id'])
                                ->update('tbl_ecom_invoice_item', [
                                    'grnreport_id' => $device_details['device_id'],
                                    'stocktransfer_invoice_id' => $device_details['stocktransfer_invoice_id'],
                                    'later_device_attached_date' => date("Y-m-d H:i:s"),
                                    'later_device_attached_by' => $this->session->userdata('user_id'),
                                        ]);
                
                $error = $this->db->error();
                if ($error['code'] != 0 || $update == 0) {
                    $this->db->trans_rollback();
                    $json['status'] = 0;
                    $json['message'] = 'Error in updation - for record no: ' . ($key + 1);
                    echo json_encode($json);
                    die;
                }

                if ($invoice_item['status'] == 'FINANCE_APPROVED') {
                    $update = $this->db->where('grnreport_id', $device_details['device_id'])
                                    ->update('tbl_grnreport', ['status' => 'SOLD', 'remark' => $invoice_item['ecom_invoice_no']]);
                    $error = $this->db->error();
                    if ($error['code'] != 0 || $update == 0) {
                        $this->db->trans_rollback();
                        $json['status'] = 0;
                        $json['message'] = 'Error in updation - for record no: ' . ($key + 1);
                        echo json_encode($json);
                        die;
                    }
                }

            } else {
                $json['status'] = 0;
                $json['message'] = 'Error in fetching Invoice details - for record no: ' . ($key + 1);
                echo json_encode($json);
                die;
            }

        }
        
        $this->db->trans_complete();

        $json['status'] = 1;
        $json['message'] = ($key + 1) . " Devices attached to the Ecom Invoices successfully";
        echo json_encode($json);
        die;

    }

    public function AttachDeviceTo_EcomInvoice() {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $ecom_invoice_no = $data['ecom_invoice_no'];
        $saleschannel_ref_id = $data['saleschannel_ref_id'];
        $imei = $data['imei'];
        $fnsku = $data['fnsku'];
        // $warehouse = $data['warehouse'];
        $sales_channel = $data['sales_channel'];
        $category = $data['category'];

        $saletype_arr = explode('-', $sales_channel);

        $where_arr = array(
            "d.saletype" => $saletype_arr[0],
            "d.stock_type" => $category,
        );
        $grn_join_cond = "d.grnreport_id = sti.device_id AND "
                   . "(d.imei1_no = '$imei' OR d.imei2_no = '$imei')";
        $stn_sql_custm = "(SELECT * FROM tbl_stocktransfer_note AS sn WHERE sn.stocktransfer_note_id = "
        ." (SELECT MAX(stocktransfer_note_id) FROM tbl_stocktransfer_note WHERE stocktransfer_invoice_id = sn.stocktransfer_invoice_id))";

        $this->db->select('sti.stocktransfer_invoice_id, sti.device_id, sti.fnsku, st.st_type, d.nhdin, d.device_name, d.SKU, d.warehouse, st.website, st.to_loc, stn.to_loc AS crnt_loc');
        $this->db->from('tbl_stocktransfer_invoice AS sti');
        $this->db->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER');
        $this->db->join($stn_sql_custm . ' AS stn', 'stn.stocktransfer_invoice_id = sti.stocktransfer_invoice_id', 'LEFT');
        $this->db->join('tbl_grnreport AS d', $grn_join_cond, 'INNER');
        $this->db->where($where_arr);
        $this->db->order_by('sti.stocktransfer_invoice_id', 'desc');
        $this->db->limit(1);
        $result = $this->db->get()->result_array();
        // $query = $this->db->get_compiled_select();echo $query; die;

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            $json['message'] = "Something went wrong";
            echo json_encode($json);
            exit;
        }
        if (count($result) != 1) {
            $json['status'] = 0;
            $json['message'] = "Something went wrong";
            echo json_encode($json);
            exit;
        }

        $device_details = $result[0];

        if ($device_details['st_type'] != 'OUTWARD') {
            echo json_encode([
                'status' => 0,
                'message' => 'The last Stock Transfer Type of this device is "'. $device_details['st_type'] .'"'
            ]);
            exit;
        } else if ($device_details['fnsku'] != $fnsku) {
            echo json_encode([
                'status' => 0,
                'message' => 'Lastly the device sent to Amazon warehouse with the FNSKU: "' . $device_details['fnsku'] . '"'
            ]);
            exit;
        }

        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];
        $ecom_invoice = $this->db->from('tbl_ecom_invoice_item AS eii')
                       ->join('tbl_ecom_invoice AS ei', 'ei.ecom_invoice_id = eii.ecom_invoice_id', 'INNER')
                       ->where('eii.stocktransfer_invoice_id', $device_details['stocktransfer_invoice_id'])
                       ->where_in('ei.status', $where_status)
                       ->select('count(ecom_invoice_item_id) AS cnt')
                       ->get()->row();

        if ($ecom_invoice->cnt > 0) {
            echo json_encode([
                'status' => 0,
                'message' => 'This Device Status is "SOLD"'
            ]);
            exit;
        }

        $rs = $this->db->from('tbl_ecom_invoice_item AS eii')
                       ->join('tbl_ecom_invoice AS ei', 'ei.ecom_invoice_id = eii.ecom_invoice_id', 'INNER')
                       ->where('ei.saleschannel_ref_id', $saleschannel_ref_id)
                       ->where('ei.ecom_invoice_no', $ecom_invoice_no)
                       ->where('eii.fnsku', $fnsku)
                       ->where('eii.stocktransfer_invoice_id is null')
                       ->order_by('eii.ecom_invoice_item_id', 'ASC')
                       ->limit(1)
                       ->select('eii.*, ei.ecom_invoice_no, ei.status')
                       ->get()->result_array();
                       
        if (count($rs) != 1) {
            $json['status'] = 0;
            $json['message'] = "Error in fetching Invoice details";
            echo json_encode($json);
            exit;
        }
        $invoice_item = $rs[0];

        if (isset($invoice_item['grnreport_id']) || isset($invoice_item['stocktransfer_invoice_id'])) {
            $json['status'] = 0;
            $json['message'] = "This invoice already attached to a device.";
            echo json_encode($json);
            exit;
        }

        if ($invoice_item['ecom_invoice_item_id'] > 0) {

            $this->db->trans_start();

            $update = $this->db->where('ecom_invoice_item_id', $invoice_item['ecom_invoice_item_id'])
                               ->update('tbl_ecom_invoice_item', [
                                'grnreport_id' => $device_details['device_id'],
                                'stocktransfer_invoice_id' => $device_details['stocktransfer_invoice_id'],
                                'later_device_attached_date' => date("Y-m-d H:i:s"),
                                'later_device_attached_by' => $this->session->userdata('user_id'),
                                    ]);
            
            $error = $this->db->error();
            if ($error['code'] != 0 || $update == 0) {
                GOTO ERROR;
            }

            if ($invoice_item['status'] == 'FINANCE_APPROVED') {
                $update = $this->db->where('grnreport_id', $device_details['device_id'])
                                   ->update('tbl_grnreport', ['status' => 'SOLD', 'remark' => $invoice_item['ecom_invoice_no']]);
                $error = $this->db->error();
                if ($error['code'] != 0 || $update == 0) {
                    GOTO ERROR;
                }
            }
            
            $this->db->trans_complete();

            $json['status'] = 1;
            $json['message'] = "Device attached to the Invoice successfully";
            echo json_encode($json);
            die;

            ERROR:
            $this->db->trans_rollback();
            $json['status'] = 0;
            $json['message'] = "Error in updation";
            echo json_encode($json);
            die;

        } else {
            $json['status'] = 0;
            $json['message'] = "Error in fetching Invoice details";
            echo json_encode($json);
            die;
        }

    }

    public function updateEcomInvoice()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data["ecom_invoice_id"] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $update_arr = array(
            "status" => $data['status'],
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->set($update_arr);
        $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"]);
        $this->db->update('tbl_ecom_invoice');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $ecom_invoice_no = $this->db->select('ecom_invoice_no')->where('ecom_invoice_id', $data["ecom_invoice_id"])->get('tbl_ecom_invoice')->row()->ecom_invoice_no;

        $item_arr = $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"])->get('tbl_ecom_invoice_item')->result_array();
        $sold_items = array();
        foreach ($item_arr as $item) {
            $sold_items[] = array(
                "grnreport_id" => $item["grnreport_id"],
                "status" => "SOLD",
                "remark" => $ecom_invoice_no
            );
        }

        $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }

        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['ecom_invoice_id'],
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->db->trans_complete();

        if ($data['status'] == 'FINANCE_APPROVED') {
            $this->hostbooks_authenticator->postFFInvoice($data['ecom_invoice_id']);
        }
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateEcomInvoiceByFNSKU()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data["ecom_invoice_id"] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $update_arr = array(
            "status" => $data['status'],
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->set($update_arr);
        $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"]);
        $this->db->update('tbl_ecom_invoice');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['ecom_invoice_id'],
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->db->trans_complete();

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function getDeviceDetails()
    {
        $device_id = $this->input->get('device_id');

        if (empty($device_id)) {
            $json['status'] = '0';
            $json['msg'] = "No TDID Entered";
            echo json_encode($json);
            die;
        }

        $grnResult = $this->db->where('nhdin', $device_id)->where('status', 'RFS')->get('tbl_grnreport')->row();

        // Rule1: Check valid Device Id 1
        if (empty($grnResult)) {
            $json['status'] = '0';
            $json['msg'] = "Enter valid Inward Device Id.";
            echo json_encode($json);
            die;
        }

        $tax = 0;

        $deviceNhmod = $grnResult->nhmod;
        $typeId = 0;
        $typeId = $this->Common_model->getFieldValue('type_id', 'tbl_product_details', 'nhmod', $deviceNhmod);
        $taxRatio = $this->Common_model->getFieldValue('tax_ratio', 'tbl_device_type', 'type_id', $typeId);

        $category = $grnResult->stock_type;

        $taxable_cat = TAXABLE_CATEGORY;
        if (in_array($category, $taxable_cat)) {
            $bill_type = 'TAXABLE';
        } else {
            $bill_type = 'EXEMPT';
        }
        //GET Tax Type

        $json['status'] = '1';
        $json['tax_ratio'] = (int) $taxRatio;
        $json['product_name'] = $grnResult->device_name;
        $json['imei'] = $grnResult->imei1_no;
        $json['grnreport_id'] = $grnResult->grnreport_id;
        $json['grade'] = $grnResult->certification_grade;
        $json['category'] = $grnResult->stock_type;
        $json['unit_price'] = $grnResult->unit_price;
        $json['unit_price_tax'] = $grnResult->unit_price_tax;
        $json['sku'] = $grnResult->SKU;
        $json['bill_type'] = $bill_type;

        echo json_encode($json);
        die;
    }

    public function addNewRow()
    {
        $sno = $this->input->get('sno');

        if ($sno <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $html = '<tr id="' . $sno . '" class="product_rows">
            <td><a onclick="deleteRow(\'' . $sno . '\')" class="btn btn-danger btn-xs mr" tabindex="0" aria-controls="DataTables"><span><i class="fa fa-trash-o"> </i></span></a></td>
            <td><input class="form-control fnsku_cls" required onchange="getDeviceList(this)" placeholder="FNSKU" name="fnsku[]" id="fnsku_' . $sno . '"  value="" type="text" ></td>
            <td><input class="form-control nhdin_cls" required onchange="getDeviceDetails(this)" placeholder="INWARDID" name="nhdin[]" id="nhdin_' . $sno . '" value="" type="text" readonly></td>
            <td><input class="form-control" required placeholder="PRODUCT NAME"  id="product_name_' . $sno . '" name="product_name[]" value="" type="text" readonly></td>
            <td><input class="form-control sku_cls" required placeholder="SKU" name="sku[]" id="sku_' . $sno . '"  value="" type="text" readonly></td>
            
            <td><input class="form-control input_price" required placeholder="PRICE" onchange="getTaxBreakup(this)" onkeypress="return isNumberKey(event)" name="price[]" id="price_' . $sno . '" value="" type="text" ></td>
            <td><input class="form-control" required placeholder="TAX" onkeypress="return isNumberKey(event)" name="tax_amount[]" id="tax_amount_' . $sno . '" value="" type="text" readonly></td>
            <td><input class="form-control" required placeholder="TAXABLE" onkeypress="return isNumberKey(event)" name="taxable_amount[]" id="taxable_amount_' . $sno . '" value="" type="text" readonly></td>
            <td><input class="form-control" required placeholder="EXEMPT" onkeypress="return isNumberKey(event)" name="exempt_amount[]" id="exempt_amount_' . $sno . '" value="" type="text" readonly></td>
            
            <td><input class="form-control category_cls" required placeholder="CATEGORY" name="category[]" id="category_' . $sno . '"  value="" type="text" readonly></td>
            <td><input class="form-control grade_cls" required name="grade[]" id="grade_' . $sno . '" place="SELECT GRADE" readonly></td>
            <td><input class="form-control" required placeholder="IMEI" name="imei[]" id="imei_' . $sno . '"  value="" type="text" readonly></td>
            <td><input type="text" class="form-control" placeholder="BILL TYPE" required name="bill_type[]" id="bill_type_' . $sno . '" readonly></td>
            
            <input class="form-control input_grnreport_id" required name="grnreport_id[]" id="grnreport_id_' . $sno . '" type="hidden" value="" readonly>
            <input class="form-control" required name="unit_price[]" id="unit_price_' . $sno . '" type="hidden" readonly>
            <input class="form-control" required name="unit_price_tax[]" id="unit_price_tax_' . $sno . '" type="hidden" readonly>
            <input class="form-control" id="tax_rate_' . $sno . '" type="hidden" readonly>
            
        </tr>';

        $json['status'] = 1;
        $json['html'] = $html;
        echo json_encode($json);
        exit;
    }

    public function getDeviceListByFNSKU()
    {

        $fnsku = $this->input->get('fnsku');
        $warehouse = $this->input->get('warehouse');
        $sales_channel = $this->input->get('sales_channel');

        $saletype_arr = explode('-', $sales_channel);

        if (empty($fnsku) || empty($warehouse)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $where_arr = array(
            "tbl_stocktransfer_invoice.fnsku" => $fnsku,
            "tbl_grnreport.status" => 'RFS',
            "tbl_grnreport.saletype" => $saletype_arr[0],
        );
        $this->db->select('tbl_grnreport.nhdin,tbl_grnreport.grnreport_id');
        $this->db->where('tbl_grnreport.warehouse LIKE "%-' . $warehouse . '"');
        $this->db->where($where_arr);
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
        $result = $this->db->get('tbl_stocktransfer_invoice')->result_array();

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $this->db->select('tbl_ecom_invoice_item.grnreport_id')->where('tbl_ecom_invoice.status', 'FINANCE_PENDING');
        $this->db->join('tbl_ecom_invoice', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
        $reserved = $this->db->get('tbl_ecom_invoice_item')->result_array();

        $reserved_items = array();
        $available_items = array();

        foreach ($reserved as $reserved_product) {
            $reserved_items[] = $reserved_product['grnreport_id'];
        }

        foreach ($result as $rowValue) {
            if (!in_array($rowValue['grnreport_id'], $reserved_items)) {
                $available_items[] = array(
                    "nhdin" => $rowValue['nhdin']
                );
            }
        }

        $json['status'] = 1;
        $json['device_id'] = $available_items;
        echo json_encode($json);
        exit;
    }
    
    /** To check Device Details using IMEI and also it can create StockTransferNote (STN) */
    public function checkDeviceDetails_usingIMEI()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $imei = $data['imei'];
        $fnsku = $data['fnsku'];
        $warehouse = $data['warehouse'];
        $sales_channel = $data['sales_channel'];
        $category = $data['category'];
        $create_st_note = $data['create_st_note'];

        $saletype_arr = explode('-', $sales_channel);

        if (empty($fnsku) || empty($warehouse)) {
            $json['status'] = 7;
            echo json_encode($json);
            exit;
        }

        $Fetching_cnt = 0;
        FETCH_DEVICE_DETAILS:
        $Fetching_cnt++;

        $where_arr = array(
            // "st.st_type" => "OUTWARD",
            // "sti.fnsku" => $fnsku,
            "d.saletype" => $saletype_arr[0],
            "d.stock_type" => $category,
        );
        $grn_join_cond = "d.grnreport_id = sti.device_id AND "
                   . "(d.imei1_no = '$imei' OR d.imei2_no = '$imei')";
        $stn_sql_custm = "(SELECT * FROM tbl_stocktransfer_note AS sn WHERE sn.stocktransfer_note_id = "
        ." (SELECT MAX(stocktransfer_note_id) FROM tbl_stocktransfer_note WHERE stocktransfer_invoice_id = sn.stocktransfer_invoice_id))";

        $this->db->select('stn.stocktransfer_note_id, sti.stocktransfer_invoice_id, sti.device_id, sti.fnsku, st.st_type, d.nhdin, d.device_name, d.SKU, d.warehouse, st.website, st.from_loc, st.to_loc, stn.to_loc AS crnt_loc');
        $this->db->from('tbl_stocktransfer_invoice AS sti');
        $this->db->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER');
        $this->db->join($stn_sql_custm . ' AS stn', 'stn.stocktransfer_invoice_id = sti.stocktransfer_invoice_id', 'LEFT');
        $this->db->join('tbl_grnreport AS d', $grn_join_cond, 'INNER');
        $this->db->where($where_arr);
        $this->db->order_by('stn.stocktransfer_invoice_id', 'desc');
        $this->db->limit(1);
        $result = $this->db->get()->result_array();
        // $query = $this->db->get_compiled_select();echo $query; die;

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        if (count($result) == 0) {
            $json['status'] = 0;
            $json['message'] = "No Device Found";
            echo json_encode($json);
            exit;
        } else if (count($result) > 1) {
            $json['status'] = 0;
            $json['message'] = "Something went wrong";
            echo json_encode($json);
            exit;
        }

        $device_details = $result[0];

        if ($device_details['st_type'] != 'OUTWARD') {
            echo json_encode([
                'status' => 0,
                'message' => 'The last Stock Transfer Type of this device is "'. $device_details['st_type'] .'"'
            ]);
            exit;
        } else if ($device_details['fnsku'] != $fnsku) {
            echo json_encode([
                'status' => 0,
                'message' => 'FNSKU with which device sent to Amazon warehouse is ' . $device_details['fnsku']
            ]);
            exit;
        }

        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];
        $ecom_invoice = $this->db->from('tbl_ecom_invoice_item AS eii')
                       ->join('tbl_ecom_invoice AS ei', 'ei.ecom_invoice_id = eii.ecom_invoice_id', 'INNER')
                       ->where('eii.stocktransfer_invoice_id', $device_details['stocktransfer_invoice_id'])
                       ->where_in('ei.status', $where_status)
                       ->select('saleschannel_ref_id, count(ecom_invoice_item_id) AS cnt')
                       ->get()->row();
                    //    ->get_compiled_select();echo $ecom_invoice;die;

        if ($ecom_invoice->cnt > 0) {
            echo json_encode([
                'status' => 0,
                'message' => 'This Device is "SOLD" under SalesChannelRefID: ' . $ecom_invoice->saleschannel_ref_id
            ]);
            exit;
        }

        $stn_notes = $this->db->from('tbl_stocktransfer_note')
                      ->where('stocktransfer_invoice_id', $device_details['stocktransfer_invoice_id'])
                      ->get()->result_array();

        
        $device_loc = is_null($device_details['crnt_loc'])? $device_details['to_loc'] : $device_details['crnt_loc'];
        
        if ($device_loc != $warehouse) {
            if ($create_st_note) {

                $data = [
                    'stocktransfer_invoice_id' => $device_details['stocktransfer_invoice_id'],
                    'device_id' => $device_details['device_id'],
                    'fnsku' => $device_details['fnsku'],
                    'from_loc' => $device_loc,
                    'to_loc' => $warehouse,
                    'status' => 'STN',
                    'CREATED_BY' => $this->session->userdata('user_id'),
                    "CREATION_DATE" => date("Y-m-d H:i:s")
                ];

                $this->db->insert('tbl_stocktransfer_note', $data);
                $error = $this->db->error();
                if ($error['code'] != 0) {
                    GOTO ERROR__ST_NOTE;
                }

                if ($Fetching_cnt == 1) {
                    GOTO FETCH_DEVICE_DETAILS;
                } else {
                    GOTO ERROR__ST_NOTE;
                }
                
            } else {
                $json['status'] = -1;
                $json['message'] = 'Device with IMEI "'. $imei .'" is at "'. $device_loc .'" warehouse.';
                $json['warehouse_loc'] = $device_loc;
                $json['new_warehouse_loc'] = $warehouse;
                $json['stocktransfer_invoice_id'] = $device_details['stocktransfer_invoice_id'];
                $json['stn_from_loc'] = $device_details['from_loc'];
                $json['stn_to_loc'] = $device_details['to_loc'];
                $json['stn_notes'] = $stn_notes;
                echo json_encode($json);
                exit;
            }
        }
        
        $json['status'] = 1;
        $json['stocktransfer_invoice_id'] = $device_details['stocktransfer_invoice_id'];
        $json['device_id'] = $device_details['device_id'];
        $json['device_name'] = $device_details['device_name'];
        $json['sku'] = $device_details['SKU'];
        $json['stn_from_loc'] = $device_details['from_loc'];
        $json['stn_to_loc'] = $device_details['to_loc'];
        $json['stn_notes'] = $stn_notes;
        echo json_encode($json);
        exit;

        ERROR__ST_NOTE:
        $json['status'] = -1;
        $json['message'] = "Error in creating Stock Transfer Note";
        echo json_encode($json);
        die;
    }
    
    public function deleteStockTransferNote() {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        $stocktransfer_invoice_id = $data['stocktransfer_invoice_id'];
        $stocktransfer_note_id = $data['stocktransfer_note_id'];

        $max_index = $this->db->from('tbl_stocktransfer_note')
                       ->where('stocktransfer_invoice_id', $stocktransfer_invoice_id)
                       ->select('MAX(stocktransfer_note_id) AS max_index')
                       ->get()->row()->max_index;

        if ($max_index != $stocktransfer_note_id) {
            echo json_encode([
                'status' => 0,
                'message' => "Last Stock Transfer Note should be deleted first"
            ]);
            exit;
        }

        
        // // $this->db->trans_start();

        $del_status = $this->db->where('stocktransfer_invoice_id', $stocktransfer_invoice_id)
                       ->where('stocktransfer_note_id', $stocktransfer_note_id)
                       ->delete('tbl_stocktransfer_note');

        $error = $this->db->error();
        if ($error['code'] != 0) {
            // // $this->db->trans_rollback();
            GOTO ERROR;
        }

        // // $stn_sql_custm = "(SELECT * FROM tbl_stocktransfer_note AS sn WHERE sn.stocktransfer_note_id = "
        // // ." (SELECT MAX(stocktransfer_note_id) FROM tbl_stocktransfer_note WHERE stocktransfer_invoice_id = sn.stocktransfer_invoice_id))";

        // // $result = $this->db->from('tbl_stocktransfer_invoice AS sti')
        // //        ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER')
        // //        ->join($stn_sql_custm . ' AS stn', 'stn.stocktransfer_invoice_id = sti.stocktransfer_invoice_id', 'LEFT')
        // //        ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'INNER')
        // //        ->where('sti.stocktransfer_invoice_id', $stocktransfer_invoice_id)
        // //        ->select('sti.stocktransfer_invoice_id, sti.device_id, d.warehouse, st.website, st.from_loc, st.to_loc, stn.to_loc AS crnt_loc')
        // //        ->get()->result_array();

        // // $error = $this->db->error();
        // // if ($error['code'] != 0 || count($result) != 1) {
        // //     echo json_encode([
        // //         'status' => 0,
        // //         'message' => "Something went wrong",
        // //     ]);
        // //     exit;
        // // }

        // // $device_details = $result[0];
        // // $device_loc = is_null($device_details['crnt_loc'])? $device_details['to_loc'] : $device_details['crnt_loc'];
        
        // // $data = ['warehouse' => $device_details['website'] . '-' . $device_loc];
        // // $update_status = $this->db->where('grnreport_id', $device_details['device_id'])->update('tbl_grnreport', $data);
        // // $error = $this->db->error();
        // // if ($error['code'] != 0) {
        // //     $this->db->trans_rollback();
        // //     GOTO ERROR;
        // // }
        // $this->db->trans_complete();

        echo json_encode([
            'status' => 1,
            'message' => "Stock Transfer Note deleted successfully"
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => 0,
            'message' => "Error in deleting the Stock Transfer Note",
        ]);
        exit;
    }

    /** To get Available stock using FNSKU */
    public function getAvailableStock()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $fnsku = $data['fnsku'];
        $warehouse = $data['warehouse'];
        $sales_channel = $data['sales_channel'];
        $category = $data['category'];

        $saletype_arr = explode('-', $sales_channel);

        if (empty($fnsku) || empty($warehouse)) {
            $json['status'] = 7;
            echo json_encode($json);
            exit;
        }

        $wh_locns = $this->db->from('tbl_wh_loc')->where('warehouse', 'Amazon')->select('short_code')->get()->result_array();
        $wh_locns = array_column($wh_locns, 'short_code');

        $where_arr = array(
            'sti.fnsku' => $fnsku,
            'd.saletype' => $saletype_arr[0],
            'd.stock_type' => $category,
        );

        $or_where_arr = [];
        foreach($wh_locns as $wh) {
            $or_where_arr['d.warehouse LIKE "%-' . $wh . '"'] = null;
        }

        /** Fetching FNSKU based Device Details */
        $this->db->select('sti.fnsku, sti.device_id, d.nhdin, d.device_name, d.SKU, d.warehouse');
        $this->db->from('tbl_stocktransfer_invoice AS sti');
        // $this->db->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER');
        $this->db->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'INNER');
        $this->db->where($where_arr);
        $this->db->group_start()->or_where($or_where_arr)->group_end();
        $this->db->limit(1);
        $Device_Details = $this->db->get()->result_array();


        /** Fetching FNSKU based Warehouse wise Total Count */
        $this->db->select('sti.fnsku, d.warehouse,  COUNT(sti.stocktransfer_invoice_id) AS cnt');
        $this->db->from('tbl_stocktransfer_invoice AS sti');
        $this->db->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'INNER');
        $this->db->where($where_arr);
        $this->db->group_start()->or_where($or_where_arr)->group_end();
        $this->db->group_by('d.warehouse');
        $warehouse_wise_details = $this->db->get()->result_array();
        // $query = $this->db->get_compiled_select(); echo $query; die;

        
        $total_quantity = [];
        foreach($warehouse_wise_details as $v) {
            $arr = explode('-', $v['warehouse']);
            $wh = trim($arr[1]);
            $total_quantity[$wh] = $v['cnt'];
        }
        // echo json_encode($total_quantity).'<br>';

        
        $stn_where_arr = array(
            'fnsku' => $fnsku,
            // 'status' => 'SOLD'
        );
        /** In TotalQuantity, deducting the STN quantity happened at "FROM" Location */
        $rs = $this->db->from('tbl_stocktransfer_note')->where($stn_where_arr)->group_by('from_loc')
                ->select('from_loc, COUNT(stocktransfer_note_id) AS cnt')
                ->get()->result_array();
        foreach($rs as $v) {
            $total_quantity[$v['from_loc']] -= $v['cnt'];
        }
        // echo json_encode($total_quantity).'<br>';

        
        /** In TotalQuantity, adding the STN quantity happened at "TO" Location */
        $rs = $this->db->from('tbl_stocktransfer_note')->where($stn_where_arr)->group_by('to_loc')
                ->select('to_loc, COUNT(stocktransfer_note_id) AS cnt')
                ->get()->result_array();
        foreach($rs as $v) {
            $total_quantity[$v['to_loc']] += $v['cnt'];
        }
        // echo json_encode($total_quantity).'<br>';

        
        /** Fetching FNSKU based Warehouse wise Sold Count */
        $where_sold = array(
            "eii.fnsku" => $fnsku,
            "eii.category" => $category,
        );
        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];
        $rs = $this->db->from('tbl_ecom_invoice_item AS eii')
                       ->join('tbl_ecom_invoice AS ei', 'ei.ecom_invoice_id = eii.ecom_invoice_id', 'INNER')
                       ->where($where_sold)
                       ->where_in('ei.status', $where_status)
                       ->group_by('ei.warehouse')
                       ->select('ei.warehouse, count(eii.ecom_invoice_item_id) AS cnt')
                       ->get()->result_array();
        
        $sold_quantity = [];
        foreach($rs as $v) {
            $sold_quantity[$v['warehouse']] = $v['cnt'];
        }
        // echo json_encode($sold_quantity).'<br>';

        $sel_warehouse_avbl_cnt = 0;
        $stock_details = [];
        foreach($wh_locns as $k => $wh) {
            $temp = [
                'total' => isset($total_quantity[$wh])? $total_quantity[$wh] : 0,
                'sold_cnt' => isset($sold_quantity[$wh])? $sold_quantity[$wh] : 0,
            ];
            $temp['avbl_cnt'] = $temp['total'] - $temp['sold_cnt'];
            $stock_details[$wh] = $temp;

            if ($wh == $warehouse) {
                $sel_warehouse_avbl_cnt = $temp['avbl_cnt'];
            }
        }
        // echo json_encode($stock_details).'<br>';die;

        $json['status'] = 1;
        $json['sel_warehouse'] = $warehouse;
        $json['sel_warehouse_avbl_cnt'] = $sel_warehouse_avbl_cnt;
        $json['stock_details'] = $stock_details;
        $json['device_name'] = $Device_Details[0]['device_name'];
        $json['sku'] = $Device_Details[0]['SKU'];
        $json['fnsku'] = $Device_Details[0]['fnsku'];
        echo json_encode($json);
        exit;
    }

    /* This is old -- Deletable */
    public function getAvailableStock__old()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $fnsku = $data['fnsku'];
        $warehouse = $data['warehouse'];
        $sales_channel = $data['sales_channel'];
        $category = $data['category'];

        $saletype_arr = explode('-', $sales_channel);

        if (empty($fnsku) || empty($warehouse)) {
            $json['status'] = 7;
            echo json_encode($json);
            exit;
        }

        $where_arr = array(
            "tbl_stocktransfer_invoice.fnsku" => $fnsku,
            "tbl_grnreport.saletype" => $saletype_arr[0],
            "tbl_grnreport.stock_type" => $category,
        );
        $this->db->select('tbl_grnreport.nhdin,tbl_grnreport.device_name, tbl_grnreport.SKU');
        $this->db->where('tbl_grnreport.warehouse LIKE "%-' . $warehouse . '"');
        $this->db->where($where_arr);
        $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
        $result = $this->db->get('tbl_stocktransfer_invoice')->result_array();

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $total_quantity = count($result);

        $where_sold = array(
            "fnsku" => $fnsku,
            "warehouse" => $warehouse,
            "category" => $category,
        );
        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];

        $this->db->select('count(tbl_ecom_invoice_item.ecom_invoice_item_id) as sold')->where($where_sold)->where_in('status', $where_status);
        $this->db->join('tbl_ecom_invoice', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
        $sold_quantity = $this->db->get('tbl_ecom_invoice_item')->row()->sold;

        $available_quantity = $total_quantity - $sold_quantity;

        $json['status'] = 1;
        $json['available_quantity'] = $available_quantity;
        $json['device_name'] = $result[0]['device_name'];
        $json['SKU'] = $result[0]['SKU'];
        echo json_encode($json);
        exit;
    }

    public function editEcomInvoice()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data["ecom_invoice_id"] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $update_arr = array(
            "saleschannel_ref_id" => trim($data['saleschannel_ref_id']),
            "invoice_ref_id" => trim($data['invoice_ref_id']),
            "sale_date" => $data['sale_date'],
            "source_invoice_date" => $data['source_invoice_date'],
            "payment_mode" => $data['payment_mode'],
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->set($update_arr);
        $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"]);
        $this->db->update('tbl_ecom_invoice');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['ecom_invoice_id'],
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }

        $this->db->trans_complete();

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    function submitReturnlInvoice()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data['ecom_invoice_id'] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $status = $this->db->where('ecom_invoice_id', $data['ecom_invoice_id'])->get('tbl_ecom_invoice')->row()->status;

        if ($status != 'FINANCE_APPROVED') {
            $json['status'] = 7;
            echo json_encode($json);
            exit;
        }

        $return_date = date("Y-m-d", strtotime($data['return_date']));

        if ($return_date == '1970-01-01') {
            $return_date = '';
        }

        $update_arr = array(
            "status" => "RETURN",
            "return_type" => $data['return_type'],
            "returned_date" => $return_date,
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s")
        );

        $items = [];
        foreach ($data['items'] as $itemValue) {
            $items[] = array(
                "ecom_invoice_item_id" => $itemValue['ecom_invoice_item_id'],
                "lpn_number" => $itemValue['lpn_number']
            );
        }

        $this->db->trans_start();

        $this->db->set($update_arr);
        $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"]);
        $this->db->update('tbl_ecom_invoice');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if (!empty($items)) {
            $this->db->update_batch('tbl_ecom_invoice_item', $items, 'ecom_invoice_item_id');
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $this->db->trans_rollback();
                $json['status'] = 0;
                echo json_encode($json);
                exit;
            }
        }

        /*      $ecom_invoice_no = $this->db->select('ecom_invoice_no')->where('ecom_invoice_id',$data["ecom_invoice_id"])->get('tbl_ecom_invoice')->row()->ecom_invoice_no;

        $item_arr = $this->db->where('ecom_invoice_id',$data["ecom_invoice_id"])->get('tbl_ecom_invoice_item')->result_array();
        $sold_items = array();
        foreach($item_arr as $item){
            $sold_items[] = array(
                "grnreport_id" => $item["grnreport_id"],
                "status" => "RFS",
                "remark" => 'ECOM RETURN'. $ecom_invoice_no
            );
        }

        $this->db->update_batch('tbl_grnreport',$sold_items,'grnreport_id');
        $error=$this->db->error();

        if($error['code'] != 0){
            $this->db->trans_rollback();
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
*/
        if (!empty($data['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $data['ecom_invoice_id'],
                'reference_type' => 'ecom_invoice',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
            $error = $this->db->error();
        }

        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    function cancelInvoice() {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data['ecom_invoice_id'] <= 0) {
            $msg = 'Invalid Data';
            GOTO ERROR;
        }
        $ecom_invoice_id = $data['ecom_invoice_id'];

        $rs = $this->db->where('ecom_invoice_id', $ecom_invoice_id)->get('tbl_ecom_invoice')->result_array();

        if (count($rs) == 0 || $rs[0]['status'] != 'FINANCE_PENDING') {
            $msg = "You can't cancel this Invoice at this stage";
            GOTO ERROR;
        }
        $saleschannel_ref_id = $rs[0]['saleschannel_ref_id'];

        $update_arr = array(
            "status" => "CANCELLED",
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->set($update_arr);
        $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"]);
        $this->db->update('tbl_ecom_invoice');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $msg = 'Error in Cancelling FBA Invoice Status';
            GOTO ERROR;
        }

        $rs = $this->db->from('tbl_ecom_invoice_item AS eii')
                          ->join('tbl_stocktransfer_invoice AS sti', 'sti.stocktransfer_invoice_id = eii.stocktransfer_invoice_id', 'INNER')
                          ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id', 'INNER')
                          ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'INNER')
                          ->where('eii.ecom_invoice_id', $data['ecom_invoice_id'])
                          ->select('d.grnreport_id, d.warehouse, st.website, st.to_loc')
                          ->get()
                          ->result_array();
        $cancelled_items = [];
        foreach($rs as $item) {
            $cancelled_items[] = array(
                "grnreport_id" => $item["grnreport_id"],
                "status" => 'FFC',
                "remark" => $item["website"] . ' FBA',
            );
            // "warehouse" => $item["website"] .'-'. $item["to_loc"]
        }

        if (count($cancelled_items) > 0) {
            $this->db->update_batch('tbl_grnreport', $cancelled_items, 'grnreport_id');
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $msg = 'Error in Updating Devices Status';
                GOTO ERROR;
            }
        }
        
        if (!empty($data['remarks_header'])) {
            $remark_array = array(
                'reference_id' => $data['ecom_invoice_id'],
                'reference_type' => 'ecom_invoice',
                'user_id' => $this->session->userdata('user_id'),
                'remark' => $data['remarks_header'],
                "date" => date("Y-m-d H:i:s")
            );
            $this->db->insert('tbl_remark', $remark_array);
            $error = $this->db->error();
        }

        $where_arr = [
            'saleschannel_ref_id' => $saleschannel_ref_id,
            'ecom_invoice_id !=' => $ecom_invoice_id,
            'status !=' => 'CANCELLED',
        ];
        $rs = $this->db->where($where_arr)->get('tbl_ecom_invoice')->result_array();
        if (count($rs) == 0) {
            $update = $this->db->where('amazon_order_id', $saleschannel_ref_id)->update('tbl_amazon_orders_data', ['is_added_inERP' => 0]);

            $error = $this->db->error();
            if ($error['code'] != 0) {
                $msg = 'Error in Updating AmazonApiOrders Status';
                GOTO ERROR;
            }
        }

        $this->db->trans_complete();
        
        echo json_encode([
            'status' => true,
            'message' => 'FBA Invoice Cancelled Successfully'
        ]);
        exit;

        ERROR:
        $this->db->trans_rollback();
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something wrong'
        ]);
        exit;
    }

    public function open_invoicepdf($invoice = null, $pdf = '')
    {

        $ecom_invoice_id = $this->input->get('ecom_invoice_id');

        $this->db->where('ecom_invoice_id', $ecom_invoice_id);
        $result = $this->db->get('ECOM_INVOICE_ITEM_VIEW')->result_array();

        $invoice_rows = array();
        if (!empty($result)) {
            foreach ($result as $rowValue) {

                $this->db->where('tbl_stocktransfer_item.fnsku', $rowValue['fnsku']);
                $this->db->select('tbl_grnreport.SKU, tbl_grnreport.device_name');
                $this->db->join('tbl_grnreport', 'tbl_grnreport.SKU = tbl_stocktransfer_item.sku', 'Left');
                $device_row = $this->db->get('tbl_stocktransfer_item')->row();

                $invoice_rows[] = array(
                    "ecom_invoice_id" => $rowValue['ecom_invoice_id'],
                    "ecom_invoice_item_id" => $rowValue['ecom_invoice_item_id'],
                    "device_name" => $device_row->device_name,
                    "stock_type" => $rowValue['category'],
                    "sku" => $device_row->SKU,
                    "fnsku" => $rowValue['fnsku'],
                    "price" => $rowValue['price'],
                    "taxable_amount" => $rowValue['taxable_amount'],
                    "exempt_amount" => $rowValue['exempt_amount'],
                    "tax_amount" => $rowValue['tax_amount'],
                    "tax_type" => $rowValue['tax_type'],
                    "bill_type" => $rowValue['bill_type'],
                );
            }
        }

        $download = $this->input->get('download');
        $this->db->where('ecom_invoice_id', $ecom_invoice_id);
        $header = $this->db->get('ECOM_INVOICE_LIST_VIEW')->row();

        if (!empty($header)) {
            $sale_date = date("d-m-Y", strtotime($header->sale_date));
            if ($sale_date == '01-01-1970' || $sale_date == '30-11--0001') {
                $sale_date = '';
            }
            $data = array(
                'ecom_invoice_id' => $header->ecom_invoice_id,
                'ecom_invoice_no' => $header->ecom_invoice_no,
                'vendor_name' => $header->vendor_name,
                'vendor_id' => $header->vendor_id,
                'salesman' => $header->salesman,
                'salesman_id' => $header->salesman_id,
                'status' => $header->status,
                'payment_mode' => $header->payment_mode,
                'warehouse' => $header->warehouse,
                'sales_channel' => $header->sales_channel,
                'saleschannel_ref_id' => $header->saleschannel_ref_id,
                'invoice_ref_id' => $header->invoice_ref_id,
                'quantity' => $header->quantity,
                'total_amount' => $header->invoice_amount,
                'total_taxable' => $header->taxable_amount,
                'total_exempt' => $header->exempt_amount,
                'total_tax' => $header->tax_amount,
                'created_by' => $header->created_by,
                'last_updated_by' => $header->last_updated_by,
                'sale_date' => $sale_date,
                "creation_date" => date("d-m-Y", strtotime($header->creation_date)),
                "last_update_date" => date("d-m-Y", strtotime($header->last_update_date))
            );
            $this->db->select('tbl_vendor.*, tbl_states.name as state_name,tbl_states.state_gst_id as state_id')->where('vendor_id', $header->vendor_id);
            $vendor_obj = $this->db->join('tbl_states', 'tbl_vendor.state = tbl_states.state_id', 'Left')->get('tbl_vendor')->row();

            if (!empty($vendor_obj->gst_no))
                $supply_place = $this->db->select('name')->where('state_gst_id', substr($vendor_obj->gst_no, 0, 2))->get('tbl_states')->row();

            $data["gst_no"] = $vendor_obj->gst_no;
            $data["company"] = $vendor_obj->company;
            $data["address"] = $vendor_obj->address;
            $data["state"] = $vendor_obj->state_name;
            $data["state_id"] = $vendor_obj->state_id;
            $data["city"] = $vendor_obj->city;
            $data["pincode"] = $vendor_obj->pincode;
            $data['pan_no'] = $vendor_obj->pan_card;
            $data['place_supply'] = $supply_place->name;
            $data['rows'] = $invoice_rows;

            $wh_loc_details = $this->db->from('tbl_wh_loc')->where('warehouse', 'Amazon')->where('short_code', $header->warehouse)->get()->result_array();
            if (count($wh_loc_details) == 0 || count($wh_loc_details) > 1) {
                echo 'Error in fetching GSTIN';
                exit;
            }
            $wh_loc_details = $wh_loc_details[0];

            $data['wh_gstin'] = $wh_loc_details['gst_number'];
            $data['wh_address'] = $wh_loc_details['address'];
            $data['wh_city'] = $wh_loc_details['city'];
            $data['wh_state'] = $wh_loc_details['state'];
        }

        $this->load->helper('dompdf');
        $viewfile = $this->load->view('admin/ecom_invoice/pdf_invoice', $data, TRUE);
        $header = $data["invoice_code"] . ' | ' . $data['date'];
        pdf_create($viewfile, $data["invoice_code"], TRUE, '', $download, null, $header);
    }
    public function uploadFilesEcom($ecom_invoice_id)
    {

        if ((int) $ecom_invoice_id <= 0) {
            $json['status'] = 0;
            $json['error'] = "No Ecom invoice Selected";
            echo json_encode($json);
            die;
        }

        if (!is_dir('upload_ecom/' . $ecom_invoice_id)) {
            mkdir('./upload_ecom/' . $ecom_invoice_id, 0777, TRUE);
        }

        $config['upload_path'] = './upload_ecom/' . $ecom_invoice_id . '/';
        $config['allowed_types'] = 'pdf';

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            $error = $this->upload->display_errors();

            $json['status'] = 0;
            $json['error'] = $error;
            echo json_encode($json);
            die;
        }

        $json['status'] = 1;
        echo json_encode($json);
        die;
    }

    public function getSOFileslist()
    {

        $ecom_invoice_id = $this->input->get('ecom_invoice_id');

        if (empty($ecom_invoice_id)) {

            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }


        $files = scandir("./upload_ecom/" . $ecom_invoice_id . "/");
        $file_names = array();

        foreach ($files as $file) {

            if ($file != '.' && $file != '..') {

                $file_names[] = array(

                    "file_name" => $file
                );
            }
        }

        $json['status'] = 1;
        $json["directory"] = "upload_ecom/" . $ecom_invoice_id;
        $json['result'] = $file_names;
        echo json_encode($json);
        exit;
    }

    public function createBulkEcomInvoice()
    {

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || empty($data['sales_channel']) || empty($data['warehouse'])) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        //GEt Unique FNSKUS
        $warehouse = $data['warehouse'];
        $fnsku = [];
        $rfs_items = [];
        foreach ($data['rows'] as $rows) {
            if (!in_array($rows['fnsku'], $fnsku)) {
                $fnsku[] = $rows['fnsku'];
            }
        }

        //Get Inward ID from fnskus
        foreach ($fnsku as $fnskuValue) {

            $where_arr = array(
                "tbl_stocktransfer_invoice.fnsku" => $fnskuValue,
                "tbl_grnreport.status" => 'RFS',
            );

            $this->db->select('tbl_grnreport.nhdin,tbl_grnreport.grnreport_id, tbl_grnreport.stock_type, tbl_grnreport.unit_price, tbl_grnreport.unit_price_tax');
            $this->db->where('tbl_grnreport.warehouse LIKE "%-' . $warehouse . '"');
            $this->db->where($where_arr);
            $this->db->join('tbl_grnreport', 'tbl_grnreport.grnreport_id = tbl_stocktransfer_invoice.device_id', 'Left');
            $result = $this->db->get('tbl_stocktransfer_invoice')->result_array();

            $rfs_items[$fnskuValue] = $result;
        }

        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        //GET Reserved Items
        $this->db->select('tbl_ecom_invoice_item.grnreport_id')->where('tbl_ecom_invoice.status', 'FINANCE_PENDING');
        $this->db->join('tbl_ecom_invoice', 'tbl_ecom_invoice.ecom_invoice_id = tbl_ecom_invoice_item.ecom_invoice_id', 'Left');
        $reserved = $this->db->get('tbl_ecom_invoice_item')->result_array();

        $reserved_items = array();
        $available_items = array();

        foreach ($reserved as $reserved_product) {
            $reserved_items[] = $reserved_product['grnreport_id'];
        }

        //Create Invoices
        $this->db->select('max(CAST(SUBSTRING_INDEX(ecom_invoice_no,"-",-1) as UNSIGNED)) as max')->where('warehouse', $data['warehouse']);
        $res = $this->db->where('ecom_invoice_no like "FF%"')->from('tbl_ecom_invoice')->get()->row_array();
        $max_number = $res['max'];

        //start the transaction
        $this->db->trans_start();

        foreach ($data['rows'] as $row) {

            //get DEVICES
            $grnreport_id = 0;
            foreach ($rfs_items[$row['fnsku']] as $device_details) {

                if (!in_array($device_details['grnreport_id'], $reserved_items) && !in_array($device_details['grnreport_id'], $used_array)) {
                    $grnreport_id = $device_details['grnreport_id'];
                    $stock_type = $device_details['stock_type'];
                    $unit_price = $device_details['unit_price'];
                    $unit_price_tax = $device_details['unit_price_tax'];
                    $used_array[] = $device_details['grnreport_id'];
                    break;
                }
            }

            if ($grnreport_id <= 0) {
                $msg = 'Device Not Available For FNSKU #' . $row['fnsku'];
                break;
            }

            $vendor = $this->db->select('state, vendor_id')->where('vendor_code', $row["vendor_no"])->get('tbl_vendor')->row();
            $vendor_state_gst = $this->db->select('state_gst_id')->where('state_id', $vendor->state)->get('tbl_states')->row()->state_gst_id;

            $warehouse_state_gst = $this->db->select('state_gst_code')->where('short_code', $data['warehouse'])->get('tbl_wh_loc')->row()->state_gst_code;

            if ($vendor->vendor_id <= 0) {
                $msg = 'Invalid Vendor  #' . $row['vendor_code'];
                break;
            }
            if ($warehouse_state_gst == $vendor_state_gst) {
                $tax_type = 'CGSG18';
            } else {
                $tax_type = 'IGST18';
            }

            $total_amount = 0;
            $taxable_total = 0;
            $exempt_total = 0;
            $tax_total = 0;
            $tax = 0;
            $taxable_cat = TAXABLE_CATEGORY;
            if (in_array('AMAZON-FBA', MARGINAL_NOT_ALLOWED_CHANNELS)) {
                $bill_type = 'TAXABLE';
                $tax = $row['price'] - $row['price'] / 1.18;
                $taxable = $row['price'] / 1.18;
                $exempt = 0.00;
            } else {
                if (in_array($stock_type, $taxable_cat)) {
                    $bill_type = 'TAXABLE';
                    $tax = $row['price'] - $row['price'] / 1.18;
                    $taxable = $row['price'] / 1.18;
                    $exempt = 0.00;
                } else {
                    $bill_type = 'EXEMPT';
                    $margin = $row['price'] - ($unit_price + $unit_price_tax);
                    $exempt = $unit_price + $unit_price_tax;
                    $taxable = $margin / 1.18;
                    $tax = $margin - $taxable;

                    if ($margin < 0) $margin = 0;

                    if ($exempt > $row['price']) {

                        $exempt = $row['price'];
                        $tax = 0;
                        $taxable = 0;
                    }
                }
            }

            $total_amount += $row['price'];
            $taxable_total += $taxable;
            $exempt_total += $exempt;
            $tax_total += $tax;

            $sale_date = date("Y-m-d", strtotime($row['sale_date']));

            if ($sale_date == '1970-01-01') {
                $sale_date = '';
            }

            if (empty($sale_date)) {
                $msg = 'Invalid Sale date for #' . $row["saleschannel_ref_id"];
                break;
            }

            $next_number = $max_number + 1;
            $ecom_invoice_no = 'FF-' . $data["warehouse"] . '-' . $next_number;
            $max_number += 1;

            $headerArray = array(
                "ecom_invoice_no" => $ecom_invoice_no,
                "vendor_id" => $vendor->vendor_id,
                "sales_channel" => $data["sales_channel"],
                "saleschannel_ref_id" => trim($row["saleschannel_ref_id"]),
                "invoice_ref_id" => $row["invoice_ref_id"],
                "warehouse" => $data["warehouse"],
                "salesman_id" => $this->session->userdata('user_id'),
                "status" => "FINANCE_PENDING",
                "payment_mode" => 'PREPAID',
                "invoice_amount" => $total_amount,
                "taxable_amount" => $taxable_total,
                "exempt_amount" => $exempt_total,
                "tax_amount" => $tax_total,
                "sale_date" => $sale_date,
                "created_by" => $this->session->userdata('user_id'),
                "creation_date" => date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_ecom_invoice', $headerArray);
            $invoice_id = $this->db->insert_id();

            $error = $this->db->error();

            if ($error['code'] != 0) {
                $msg = 'Failed to Create Invoice for #' . $row["saleschannel_ref_id"];
                break;
            }

            $invoice_item = array(
                "ecom_invoice_id" => $invoice_id,
                "grnreport_id" => $grnreport_id,
                "fnsku" => $row["fnsku"],
                "price" => $row["price"],
                "tax_amount" => $tax,
                "taxable_amount" => $taxable,
                "exempt_amount" => $exempt,
                "bill_type" => $bill_type,
                "tax_type" => $tax_type,
                "creation_date" => date("Y-m-d H:i:s")
            );

            $this->db->insert('tbl_ecom_invoice_item', $invoice_item);
            $error = $this->db->error();

            if ($error['code'] != 0) {
                $msg = 'Failed to Create Invoice for #' . $row["saleschannel_ref_id"];
                break;
            }
        }

        if (!empty($msg)) {
            $this->db->trans_rollback();
            $json['msg'] = $msg;
            $json['status'] = 0;
            echo json_encode($json);
            die;
        }
        $this->db->trans_complete();

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateReturnInvoiceForm($invoice_id)
    {

        if (empty($invoice_id) || (int) $invoice_id <= 0) {
            $data['active'] = 1;
        } else {
            $data['active'] = 5;
            $data['update_ecom_invoice_return_id'] = $invoice_id;
        }

        $data['title'] = 'CREDIT NOTE';
        $data['subview'] = $this->load->view('admin/ecom_invoice/manage_ecom_invoice', $data, TRUE);
        $this->load->view('admin/_layout_main', $data); //page load
    }

    public function createEcomInvoiceCreditNote()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);

        if (empty($data) || (int) $data["ecom_invoice_id"] <= 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $warehouse = $this->db->select('warehouse')->where('ecom_invoice_id', $data["ecom_invoice_id"])->get('tbl_ecom_invoice')->row()->warehouse;

	$current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
        $next_year = $current_year + 1;
        //$string = substr($warehouse, 0, 1);
        $series = "CN".$warehouse."FBA".$current_year.$next_year;

        $res = $this->db->select('max(CAST(SUBSTRING_INDEX(creditnote_no,"-",-1) as UNSIGNED)) as max')
        ->like('creditnote_no',$series)
        ->where('warehouse', $warehouse)->from('tbl_ecom_invoice')->get()->row_array();
        $next_number = $res['max'] + 1;
        //$creditnote_no = 'CN-FF-' . $warehouse . '-' . $next_number;
        $creditnote_no =  $series. '-' . $next_number;

        $update_arr = array(
            "status" => "CN_CREATED",
            "creditnote_no" => $creditnote_no,
            "last_updated_by" => $this->session->userdata('user_id'),
            "last_update_date" => date("Y-m-d H:i:s")
        );

        $this->db->trans_start();

        $this->db->set($update_arr);
        $this->db->where('ecom_invoice_id', $data["ecom_invoice_id"]);
        $this->db->update('tbl_ecom_invoice');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        if ($error['code'] == 0) {
            if (!empty($data['remarks_header'])) {
                $remark_array = array(
                    'reference_id' => $data['ecom_invoice_id'],
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $data['remarks_header'],
                    "date" => date("Y-m-d H:i:s")
                );
                $this->db->insert('tbl_remark', $remark_array);
                $error = $this->db->error();
            }
        }
        $this->hostbooks_authenticator->postFFCreditNote($data['ecom_invoice_id']);
        $this->db->trans_complete();

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }
    
    public function manualStockDetails()
    {
	$ecom_invoice_id = 6031;
	$this->hostbooks_authenticator->manualPostFFCreditNote($ecom_invoice_id);

    }


    public function stockDetails()
    {
        $warehouse = $this->input->get('warehouse');
        //var_dump($warehouse);

        $result = $this->db->select('invoice.fnsku,grn_report.warehouse, grn_report.status, count(grn_report.grnreport_id) as stock ')
            ->select('SUM(IF(status = "SOLD", 1, 0)) AS sold,SUM(IF(status = "RFS", 1, 0)) AS rfs')
            ->from('tbl_grnreport grn_report')
            ->join('tbl_stocktransfer_invoice  invoice', 'invoice.device_id  = grn_report.grnreport_id')
            ->where('warehouse', $warehouse)
            ->group_by('grn_report.warehouse, grn_report.status, invoice.fnsku')->get()->result_array();

        $result_reserved = $this->db->select('ecom_item.fnsku,count(ecom_item.ecom_invoice_item_id) as reserved')
            ->from('tbl_ecom_invoice_item ecom_item')
            ->join('tbl_ecom_invoice ecom', 'ecom.ecom_invoice_id=ecom_item.ecom_invoice_id')
            ->where(' status', 'FINANCE_PENDING')
            ->where(' warehouse', $warehouse)
            ->group_by('fnsku')->get()->result_array();

        foreach ($result_reserved as $rowValue) {
            $reserved[$rowValue['fnsku']] = $rowValue['reserved'];
        }

        foreach ($result as $rowValue) {

            $records[] = array(
                "fnsku" => $rowValue['fnsku'],
                "warehouse" => $rowValue['warehouse'],
                "sold" => $rowValue['sold'],
                "rfs" => $rowValue['rfs'],
                "reserved" => $reserved[$rowValue['fnsku']],
                "total_stock" => $rowValue['stock']
            );
        }

        $json['data'] = $records;
        echo json_encode($json);
        exit;
    }

    public function getStockDetailsByFNSKU() {
        // $warehouse = $this->input->get('warehouse');

        // $total_array = $this->db->from('tbl_stocktransfer_invoice AS sti')
        //         ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'Left')
        //         ->where('d.warehouse LIKE "%-' . $warehouse . '"')
        //         ->select('sti.fnsku, count(d.nhdin) as total_stock')
        //         ->group_by('sti.fnsku')
        //         ->get()->result_array();
        // print $this->db->last_query();exit;

        // $where1_arr = ['stn.to_loc is null' => null, 'st.to_loc' => $warehouse];
        // $where2_arr = ['stn.to_loc is not null' => null, 'stn.to_loc' => $warehouse];

        // $stn_sql_custm = "(SELECT * FROM tbl_stocktransfer_note AS sn WHERE sn.stocktransfer_note_id = "
        // ." (SELECT MAX(stocktransfer_note_id) FROM tbl_stocktransfer_note WHERE stocktransfer_invoice_id = sn.stocktransfer_invoice_id))";

        $ST_Outward_array = $this->db->from('tbl_stocktransfer_invoice AS sti')
                ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id AND st.st_type = "OUTWARD"', 'INNER')
                ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'INNER')
                ->select('sti.fnsku, count(sti.device_id) as cnt')
                ->group_by('sti.fnsku')
                ->get()->result_array();

        $ST_Inward_array = $this->db->from('tbl_stocktransfer_invoice AS sti')
                ->join('tbl_stocktransfer AS st', 'st.stocktransfer_id = sti.stocktransfer_id AND st.st_type = "INWARD"', 'INNER')
                ->join('tbl_grnreport AS d', 'd.grnreport_id = sti.device_id', 'INNER')
                ->select('sti.fnsku, count(sti.device_id) as cnt')
                ->group_by('sti.fnsku')
                ->get()->result_array();

        $where_status = ['FINANCE_PENDING', 'FINANCE_APPROVED'];

        $Sold_array = $this->db->from('tbl_ecom_invoice_item AS eii')
                ->join('tbl_ecom_invoice AS ei', 'ei.ecom_invoice_id = eii.ecom_invoice_id', 'INNER')
                // ->where('ei.warehouse', $warehouse)
                ->where_in('ei.status', $where_status)
                ->select('eii.fnsku, count(eii.ecom_invoice_item_id) as cnt')
                ->group_by('eii.fnsku')
                ->get()->result_array();
                // ->get_compiled_select(); echo $sold_array; die;

        $Sold_stock = array();
        foreach ($Sold_array as $row) {
            $Sold_stock[$row['fnsku']] = (int) $row['cnt'];
        }

        $In_stock = array();
        foreach ($ST_Inward_array as $row) {
            $In_stock[$row['fnsku']] = (int) $row['cnt'];
        }

        foreach ($ST_Outward_array as $OutRow) {
            $fnsku = $OutRow['fnsku'];
            $outStock_cnt = $OutRow['cnt'];

            $sold = 0;
            if (isset($Sold_stock[$fnsku])) {
                $sold = $Sold_stock[$fnsku];
            }
            $return = 0;
            if (isset($In_stock[$fnsku])) {
                $return = $In_stock[$fnsku];
            }
            $data[] = array(
                "fnsku" => $fnsku,
                "total_stock" => $outStock_cnt,
                "sold" =>  $sold,
                "return" =>  $return,
                "available" => $outStock_cnt - $sold - $return
            );
        }

        echo json_encode([
            'status' => true,
            'data' => $data
        ]);
        exit;
    }

    public function checkDuplicate()
    {
        $saleschannel_ref_id = $this->input->get('saleschannel_ref_id');

        $check = $this->db->where('saleschannel_ref_id', trim($saleschannel_ref_id))->where('status != "CANCELLED"')->get('tbl_ecom_invoice')->row();
        //print $this->db->last_query();exit;
        if (!empty($check)) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }

        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function updateBulkEcomInvoice()
    {
        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $remarks_arr = [];
        $ecom_invoice_nos = [];
        $sold_items = array();

        if (empty($data)) {
            $json['status'] = 0;
            $json['msg'] = "No Data Received";
            echo json_encode($json);
            exit;
        }

        foreach($data as $rowValue){
            if(!empty($rowValue['remarks'])){
                $remarks_arr[strtoupper(trim($rowValue['ecom_invoice_no']))] = $rowValue['remarks'];
            }
            if(strtoupper(trim($rowValue['status'])) == 'APPROVED'){
                $ecom_invoice_nos[] = strtoupper(trim($rowValue['ecom_invoice_no']));
            }
        }

        $ecomInvoces = $this->db->where_in('ecom_invoice_no', $ecom_invoice_nos)->get('tbl_ecom_invoice')->result_array();

        if(empty($ecomInvoces)){
            $json['status'] = 0;
            $json['msg'] = "Inavlid Ecom Invoices";
            echo json_encode($json);
            exit;
        }

        foreach($ecomInvoces as $rowValue){
            if($rowValue['status'] != 'FINANCE_PENDING'){
                $json['status'] = 0;
                $json['msg'] = $rowValue['ecom_invoice_no']." is not in Finance Pending Status";
                echo json_encode($json);
                exit;
            }

            $update_status_arr[] = array(
                "ecom_invoice_id"=>$rowValue['ecom_invoice_id'],
                "status" => "FINANCE_APPROVED",
                "is_HB_integrated" => 0,
                "last_updated_by" => $this->session->userdata('user_id'),
                "last_update_date" => date("Y-m-d H:i:s")
            );

            
            if (!empty($remarks_arr[$rowValue['ecom_invoice_no']])) {
                $insert_remark_array[] = array(
                    'reference_id' => $rowValue['ecom_invoice_id'],
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $remarks_arr[$rowValue['ecom_invoice_no']],
                    "date" => date("Y-m-d H:i:s")
                );
            }
            $ecom_invoice_no = $this->db->select('ecom_invoice_no')->where('ecom_invoice_id', $rowValue["ecom_invoice_id"])->get('tbl_ecom_invoice')->row()->ecom_invoice_no;
            $item_arr = $this->db->where('ecom_invoice_id', $rowValue["ecom_invoice_id"])->get('tbl_ecom_invoice_item')->result_array();
            
            foreach ($item_arr as $item) {
                $sold_items[] = array(
                    "grnreport_id" => $item["grnreport_id"],
                    "status" => "SOLD",
                    "remark" => $ecom_invoice_no
                );
            }
        }

        $this->db->trans_start();

        $this->db->update_batch('tbl_ecom_invoice',$update_status_arr, 'ecom_invoice_id');
        $error = $this->db->error();

        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        $this->db->update_batch('tbl_grnreport', $sold_items, 'grnreport_id');
        $error = $this->db->error();
        if ($error['code'] != 0) {
            $json['status'] = 0;
            echo json_encode($json);
            exit;
        }
        // foreach($update_status_arr as $ecom_data){
        //     $approvedData = $this->db->where('ecom_invoice_id',$ecom_data['ecom_invoice_id'])
        //         ->select('ecom_invoice_id, status')->from('tbl_ecom_invoice')->get()->row();
        //         if($approvedData->status == "FINANCE_APPROVED"){
                    
        //             $this->hostbooks_authenticator->postFFInvoice($ecom_data['ecom_invoice_id']);   
        //         }
        // }
        if(!empty($insert_remark_array)){
            try{
                $this->db->insert_batch('tbl_remark',$insert_remark_array);
            }catch(Exception $e){
    
            } 
        }
        $this->db->trans_complete();
        $json['status'] = 1;
        echo json_encode($json);
        exit;
    }

    public function pending_integrations_with_HB() {
        $status = ['FINANCE_APPROVED', 'RETURN'];

        $rs = $this->db->select('ecom_invoice_id, ecom_invoice_no')
                         ->where('is_HB_integrated', 0)
                         ->where_in('status', $status)
                         ->get('tbl_ecom_invoice')->result_array();
        
        $pending_inv_nos = array_column($rs, 'ecom_invoice_no');

        echo json_encode([
            'status' => true,
            'pending_inv_nos' => $pending_inv_nos,
            'pendings_count' => count($pending_inv_nos)
        ]);
        exit;
    }

    public function integrate_with_HB() {
        $status = ['FINANCE_APPROVED', 'RETURN'];

        $rs = $this->db->select('ecom_invoice_id, ecom_invoice_no')
                         ->where('is_HB_integrated', 0)
                         ->where_in('status', $status)
                         ->limit(1)
                         ->get('tbl_ecom_invoice')->result_array();

        if (count($rs) == 0) {
            $msg = 'All are done. No Pending Invoices left for HB integration';
            GOTO ERROR;
        }

        $ecom_update_arr = [];
        $integrated_inv_nos = [];
        $error_inv_nos = [];

        
        $this->db->trans_start();

        $st_time = time();
        foreach($rs as $k => $v) {
            if (time() > ($st_time + 30)) {
                break;
            }
            $inv_id = (int) $v['ecom_invoice_id'];
            $inv_no = $v['ecom_invoice_no'];

            // $this->hostbooks_authenticator->postFFInvoice($inv_id);
            $Res = $this->hostbooks_authenticator->postFFInvoice_test($inv_id);

            if ($Res['HB_response']['status'] == 200) {
                $ecom_update_arr[] = [
                    "ecom_invoice_id" => $inv_id,
                    "is_HB_integrated" => 1,
                ];
                $integrated_inv_nos[] = $inv_no;
            } else {
                $ecom_update_arr[] = [
                    "ecom_invoice_id" => $inv_id,
                    "is_HB_integrated" => 2,
                ];
                $error_inv_nos[] = $inv_no;
            }
            
        }
        
        if (!empty($ecom_update_arr)) {
            $this->db->update_batch('tbl_ecom_invoice', $ecom_update_arr, 'ecom_invoice_id');
        }
        
        $this->db->trans_complete();


        echo json_encode([
            'status' => true,
            'message' => 'Total Invoices Integrated: '. count($integrated_inv_nos),
            'integrated_inv_nos' => $integrated_inv_nos,
            'error_inv_ids' => $error_inv_nos,
            'HB_Response' => $Res
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong'
        ]);
        exit;
    }
    
    public function updateBulkEcom_CNs() {

        $request = file_get_contents("php://input");
        $data = json_decode($request, TRUE);
        $remarks_arr = [];
        $ecom_invoice_nos = [];

        if (empty($data)) {
            $msg = "No Data Received";
            GOTO ERROR;
        }

        foreach($data as $rowValue){
            if(!empty($rowValue['remarks'])){
                $remarks_arr[strtoupper(trim($rowValue['ecom_invoice_no']))] = $rowValue['remarks'];
            }
            if(strtoupper(trim($rowValue['status'])) == 'APPROVED'){
                $ecom_invoice_nos[] = strtoupper(trim($rowValue['ecom_invoice_no']));
            }
        }

        if (empty($ecom_invoice_nos)) {
            $msg = 'Non of the Invoice CN status is "APPROVED"';
            GOTO ERROR;
        }

        $ecomInvoces = $this->db->where_in('ecom_invoice_no', $ecom_invoice_nos)->get('tbl_ecom_invoice')->result_array();

        if(empty($ecomInvoces)) {
            $msg = "Inavlid Ecom Invoices";
            GOTO ERROR;
        }

        foreach($ecomInvoces as $rowValue) {
            if($rowValue['status'] != 'RETURN') {
                $msg = $rowValue['ecom_invoice_no']." is not in RETURN Status";
                GOTO ERROR;
            }

	    $current_year = ( date('m') > 3) ? date('y') : date('y') - 1;
            $next_year = $current_year + 1;

            $warehouse = $rowValue['warehouse'];
	    $series = "CN".$warehouse."FBA".$current_year.$next_year;

	    $res = $this->db->select('max(CAST(SUBSTRING_INDEX(creditnote_no,"-",-1) as UNSIGNED)) as max')
            ->like('creditnote_no',$series)
            ->where('warehouse', $warehouse)->from('tbl_ecom_invoice')->get()->row_array();

            $next_number = $res['max'] + 1;
            //$creditnote_no = 'CN-FF-' . $warehouse . '-' . $next_number;
            $creditnote_no =  $series. '-' . $next_number;

            $update_status_arr[] = array(
                "ecom_invoice_id" => $rowValue['ecom_invoice_id'],
                "status" => "CN_CREATED",
                "creditnote_no" => $creditnote_no,
                "is_HB_updatedwith_CN" => 0,
                "last_updated_by" => $this->session->userdata('user_id'),
                "last_update_date" => date("Y-m-d H:i:s")
            );
            
            if (!empty($remarks_arr[$rowValue['ecom_invoice_no']])) {
                $insert_remark_array[] = array(
                    'reference_id' => $rowValue['ecom_invoice_id'],
                    'reference_type' => 'ecom_invoice',
                    'user_id' => $this->session->userdata('user_id'),
                    'remark' => $remarks_arr[$rowValue['ecom_invoice_no']],
                    "date" => date("Y-m-d H:i:s")
                );
            }
        }

        $this->db->trans_start();

        $this->db->update_batch('tbl_ecom_invoice', $update_status_arr, 'ecom_invoice_id');

        if ($this->db->error()['code'] != 0) {
            $msg = "Error in updating Credit Note";
            GOTO ERROR;
        }
        
        if(!empty($insert_remark_array)){
            $this->db->insert_batch('tbl_remark',$insert_remark_array);
            if ($this->db->error()['code'] != 0) {
                $msg = "Error in updating Remarks";
                GOTO ERROR;
            }
        }

        $this->db->trans_complete();

        echo json_encode([
            'status' => true,
            'message' => 'CN created for '. count($update_status_arr) .' records'
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something wrong',
            'error' => isset($err)? $err : ''
        ]);
        exit;
    }
    
    public function CN_pendings_with_HB() {
        $status = ['CN_CREATED'];

        $rs = $this->db->select('ecom_invoice_id, ecom_invoice_no')
                         ->where('is_HB_updatedwith_CN', 0)
                         ->where_in('status', $status)
                         ->get('tbl_ecom_invoice')->result_array();
        
        $pending_inv_nos = array_column($rs, 'ecom_invoice_no');

        echo json_encode([
            'status' => true,
            'pending_inv_nos' => $pending_inv_nos,
            'pendings_count' => count($pending_inv_nos)
        ]);
        exit;
    }
    
    public function CN_update_in_HB() {
        $status = ['CN_CREATED'];

        $rs = $this->db->select('ecom_invoice_id, ecom_invoice_no')
                         ->where('is_HB_updatedwith_CN', 0)
                         ->where_in('status', $status)
                         ->limit(1)
                         ->get('tbl_ecom_invoice')->result_array();

        if (count($rs) == 0) {
            $msg = 'All are done. No Pending CNs left for HB integration';
            GOTO ERROR;
        }

        $ecom_update_arr = [];
        $integrated_inv_nos = [];
        $error_inv_nos = [];

        
        $this->db->trans_start();

        $st_time = time();
        foreach($rs as $k => $v) {
            if (time() > ($st_time + 30)) {
                break;
            }
            $inv_id = (int) $v['ecom_invoice_id'];
            $inv_no = $v['ecom_invoice_no'];

            // $Res = $this->hostbooks_authenticator->postFFCreditNote($inv_id);

            // if ($Res['HB_response']['status'] == 200) {
            //     $ecom_update_arr[] = [
            //         "ecom_invoice_id" => $inv_id,
            //         "is_HB_integrated" => 1,
            //     ];
            //     $integrated_inv_nos[] = $inv_no;
            // } else {
            //     $ecom_update_arr[] = [
            //         "ecom_invoice_id" => $inv_id,
            //         "is_HB_integrated" => 2,
            //     ];
            //     $error_inv_nos[] = $inv_no;
            // }
            
        }
        
        if (!empty($ecom_update_arr)) {
            $this->db->update_batch('tbl_ecom_invoice', $ecom_update_arr, 'ecom_invoice_id');
        }
        
        $this->db->trans_complete();


        echo json_encode([
            'status' => true,
            'message' => 'Total Invoices Integrated: '. count($integrated_inv_nos),
            'integrated_inv_nos' => $integrated_inv_nos,
            'error_inv_ids' => $error_inv_nos,
            'HB_Response' => $Res
        ]);
        exit;

        ERROR:
        echo json_encode([
            'status' => false,
            'message' => isset($msg)? $msg : 'Something went wrong'
        ]);
        exit;
    }

    public function getPendingOrdersCSV() {
        
        $queryData = $this->db->where('status', 'FINANCE_PENDING')->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();

        $csvRow = "Ecom Invoice No,Order Id,Invoice Date,Vednor Name,FNSKU,SKU,Category,Taxable Amount,Exempt Amount,Tax Amount, Total Amount, status, remarks";
        $csvRow .= "\n";

         foreach($queryData as $rowValue){
            $csvRow .= $rowValue['ecom_invoice_no'].",";    
            $csvRow .= $rowValue['sales_channel_ref_id'].",";    
            $csvRow .= $rowValue['invoice_date'].",";    
            $csvRow .= $rowValue['vendor_name'].",";    
            $csvRow .= $rowValue['fnsku'].",";    
            $csvRow .= $rowValue['sku'].",";    
            $csvRow .= $rowValue['Category'].",";    
            $csvRow .= $rowValue['taxable_amount'].",";    
            $csvRow .= $rowValue['exempt_amount'].",";    
            $csvRow .= $rowValue['tax_amount'].",";    
            $csvRow .= $rowValue['amount'].",";    
            $csvRow .= "\n";
         }

        $filename = "pending_ff_invoice" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csvRow;
		exit;
    }
    
    public function getPendingCNs_CSV() {
        
        $queryData = $this->db->where('status', 'RETURN')->get('ECOM_INVOICE_ITEM_EXPORT_VIEW')->result_array();

        $csvRow = "Ecom Invoice No,Order Id,Invoice Date,Vednor Name,FNSKU,SKU,Category,Taxable Amount,Exempt Amount,Tax Amount, Total Amount, status, remarks";
        $csvRow .= "\n";

         foreach($queryData as $rowValue){
            $csvRow .= $rowValue['ecom_invoice_no'].",";    
            $csvRow .= $rowValue['sales_channel_ref_id'].",";    
            $csvRow .= $rowValue['invoice_date'].",";    
            $csvRow .= $rowValue['vendor_name'].",";    
            $csvRow .= $rowValue['fnsku'].",";    
            $csvRow .= $rowValue['sku'].",";    
            $csvRow .= $rowValue['Category'].",";    
            $csvRow .= $rowValue['taxable_amount'].",";    
            $csvRow .= $rowValue['exempt_amount'].",";    
            $csvRow .= $rowValue['tax_amount'].",";    
            $csvRow .= $rowValue['amount'].",";    
            $csvRow .= "\n";
         }

        $filename = "pending_ff_creditnotes" . "_" . date("Y-m-d_H-i", time());
		header("Content-type: application/csv");
		header("Content-disposition: csv" . date("Y-m-d") . ".csv");
		header("Content-disposition: filename=" . $filename . ".csv;");
		print $csvRow;
		exit;
    }

}
