<?php

/**
 * Manage Discounts on Dealer App
 * */

class Discounts_dealerapp extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();
    }

    public function manage_discounts_dealerapp($active = 0)
    {
        if($active <= 0){
            $data['active'] = 1;
        }else{
            $data['active'] = 0;
        }

        $data['title'] = 'Manage Discounts on Dealer App';
        $data['subview'] = $this->load->view('admin/discounts_dealerapp/manage_discounts_dealerapp', $data, TRUE);
		$this->load->view('admin/_layout_main', $data);
    }

    public function addDiscountsRule()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if(empty($data)){
            $json = array('status' => 0, 'message' => 'No Data Received');
            echo json_encode($json);
            exit;
        }

        // Validate the data received
        if(empty($data['category'])){
            $json = array('status' => 0, 'message' => 'Category is required');
            echo json_encode($json);
            exit;
        }

        if($data['category'] == 'bundle'){
            if(empty($data['bundle_type'])){
                $json = array('status' => 0, 'message' => 'Bundle Type is required');
                echo json_encode($json);
                exit;
            }
        }

        if(empty($data['discount_criteria'])){
            $json = array('status' => 0, 'message' => 'Discount Criteria is required');
            echo json_encode($json);
            exit;
        }

        if(empty($data['discount_type'])){
            $json = array('status' => 0, 'message' => 'Discount Type is required');
            echo json_encode($json);
            exit;
        }

        // criteria = 'value' check for min_invoice_amount, else if criteria= 'quantity' check min_quantity
        if($data['discount_criteria'] == 'value'){
            if(empty($data['min_invoice_amount'])){
                $json = array('status' => 0, 'message' => 'Minimum Invoice Amount is required');
                echo json_encode($json);
                exit;
            }
        }else if($data['discount_criteria'] == 'quantity'){
            if(empty($data['min_quantity'])){
                $json = array('status' => 0, 'message' => 'Minimum Quantity is required');
                echo json_encode($json);
                exit;
            }
        }

        // discount_type = 'amount' check for discount_amount, else if discount_type= 'percent' check discount_percent
        if($data['discount_type'] == 'amount'){
            if(empty($data['discount_amount']) || $data['discount_amount'] <= 0){
                $json = array('status' => 0, 'message' => 'Discount Amount is required');
                echo json_encode($json);
                exit;
            }
        }else if($data['discount_type'] == 'percent'){
            if(empty($data['discount_percent']) || $data['discount_percent'] <= 0){
                $json = array('status' => 0, 'message' => 'Discount Percent is required');
                echo json_encode($json);
                exit;
            }
        }

        if(empty($data['start_date'])){
            $json = array('status' => 0, 'message' => 'Start Date is required');
            echo json_encode($json);
            exit;
        }

        if(empty($data['end_date'])){
            $json = array('status' => 0, 'message' => 'End Date is required');
            echo json_encode($json);
            exit;
        }

        if(strtotime($data['start_date']) > strtotime($data['end_date'])){
            $json = array('status' => 0, 'message' => 'End Date should be Greater than or Equal to Start Date');
            echo json_encode($json);
            exit;
        }

        // Check if the discount rule already exists
        // $this->db->where('category', $data['category']);
        
        // if($data['category'] == 'bundle'){
        //     $this->db->where('bundle_type', $data['bundle_type']);
        // }
        
        // $this->db->where('start_date <=', $data['start_date']);
        // $this->db->where('end_date >=', $data['start_date']);
        // $this->db->where('status !=', 'CANCELLED');
        // $start_date_check = $this->db->get('tbl_dealerapp_discount_rules')->row();

        // if(!empty($start_date_check)){
        //     $json = array('status' => 0, 'message' => 'Discount Rule already exists for this Period');
        //     echo json_encode($json);
        //     exit;
        // }

        // Check if the discount rule already exists
        // $this->db->where('start_date <=', $data['end_date']);
        
        $this->db->where('category', $data['category']);
        
        if($data['category'] == 'bundle'){
            $this->db->where('bundle_type', $data['bundle_type']);
        }
        // $end_date_check = $this->db->query("SELECT * FROM `tbl_dealerapp_discount_rules` WHERE `category` = 'bundle' AND `bundle_type` = 'ALL' AND `status` != 'CANCELLED' AND `start_date` BETWEEN '2023-04-19' AND '2023-04-21' OR `end_date` BETWEEN '2023-04-19' AND '2023-04-21';
        // ");
	$statusArr = array("ACTIVE","INACTIVE");
        $this->db->where_in('status', $statusArr );
        $this->db->where("`start_date` BETWEEN '". $data['start_date']. "' AND '" . $data['end_date']."' OR `bundle_type` = '". $data['bundle_type']. "' AND `status` IN ('ACTIVE','INACTIVE') AND `end_date` BETWEEN '".$data['start_date']. "' AND '" . $data['end_date']."'");
        //$this->db->where('end_date BETWEEN '. $data['start_date']. " AND '" . $data['end_date']."'");
        $end_date_check = $this->db->get('tbl_dealerapp_discount_rules');
	
        if($end_date_check->num_rows() > 0){
            
            $exist_data = $end_date_check->row();
	    //print_r($this->db->last_query()); exit;
            if($exist_data->discount_criteria != $data['discount_criteria']){
                $json = array('status' => 0, 'message' => 'Discount Rule already exists on ' .$exist_data->discount_criteria. ' for this Period');
                echo json_encode($json);
                exit;
            }
            if($end_date_check->num_rows() >= 6){
                $json = array('status' => 0, 'message' => 'You can not add more than 6 discount rules for this Period');
                echo json_encode($json);
                exit;
            }
            if($exist_data->start_date != $data['start_date']){
                $json = array('status' => 0, 'message' => 'Discount Start date should be ' .$exist_data->start_date. ' as per previous discount rule');
                echo json_encode($json);
                exit;
            }
            if($exist_data->end_date != $data['end_date']){
                $json = array('status' => 0, 'message' => 'Discount End date should be ' .$exist_data->end_date. ' as per previous discount rule');
                echo json_encode($json);
                exit;
            } 
            
            // $json = array('status' => 0, 'message' => 'Discount Rule already exists for this Period');
            // echo json_encode($json);
            // exit;
        }

        $data['status'] = 'INACTIVE';
        $data['created_by'] = $this->session->userdata('user_id');
        $data['updated_by'] = $this->session->userdata('user_id');

        // add the data to the database
        $this->db->insert('tbl_dealerapp_discount_rules', $data);
        $insert_id = $this->db->insert_id();
        
        if($insert_id){
            $json = array('status' => 1, 'message' => 'Discount Rule added successfully');
            echo json_encode($json);
            exit;
        }else{
            $error = $this->db->error();
            $json = array('status' => 0, 'message' => $error['message']);
            echo json_encode($json);
            exit;
        }
    }

    public function editDiscountRule()
    {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if(empty($data)){
            $json = array('success' => 0, 'message' => 'No Data Received');
            echo json_encode($json);
            exit;
        }

        // Validate the data received
        if(empty($data['category'])){
            $json = array('success' => 0, 'message' => 'Category is required');
            echo json_encode($json);
            exit;
        }

        if(empty($data['discount_criteria'])){
            $json = array('success' => 0, 'message' => 'Discount Criteria is required');
            echo json_encode($json);
            exit;
        }

        if(empty($data['discount_type'])){
            $json = array('success' => 0, 'message' => 'Discount Type is required');
            echo json_encode($json);
            exit;
        }

        // criteria = 'value' check for min_invoice_amount, else if criteria= 'quantity' check min_quantity
        if($data['discount_criteria'] == 'value'){
            if(empty($data['min_invoice_amount'])){
                $json = array('success' => 0, 'message' => 'Minimum Invoice Amount is required');
                echo json_encode($json);
                exit;
            }
        }else if($data['discount_criteria'] == 'quantity'){
            if(empty($data['min_quantity'])){
                $json = array('success' => 0, 'message' => 'Minimum Quantity is required');
                echo json_encode($json);
                exit;
            }
        }

        // discount_type = 'amount' check for discount_amount, else if discount_type= 'percent' check discount_percent
        if($data['discount_type'] == 'amount'){
            if(empty($data['discount_amount']) || $data['discount_amount'] <= 0){
                $json = array('success' => 0, 'message' => 'Discount Amount is required');
                echo json_encode($json);
                exit;
            }
        }else if($data['discount_type'] == 'percent'){
            if(empty($data['discount_percent']) || $data['discount_percent'] <= 0){
                $json = array('success' => 0, 'message' => 'Discount Percent is required');
                echo json_encode($json);
                exit;
            }
        }

        if(empty($data['start_date'])){
            $json = array('success' => 0, 'message' => 'Start Date is required');
            echo json_encode($json);
            exit;
        }

        if(empty($data['end_date'])){
            $json = array('success' => 0, 'message' => 'End Date is required');
            echo json_encode($json);
            exit;
        }

        if(strtotime($data['start_date']) >= strtotime($data['end_date'])){
            $json = array('success' => 0, 'message' => 'Start Date should be less than End Date');
            echo json_encode($json);
            exit;
        }

        // add the data to the database
        $this->db->where('id', $data['id']);
        $this->db->update('tbl_dealerapp_discounts_rules', $data);
        $error = $this->db->error();
        
        if($error['message'] == ''){
            $json = array('success' => 1, 'message' => 'Discount Rule updated successfully');
            echo json_encode($json);
            exit;
        }else{
            $json = array('success' => 0, 'message' => $error['message']);
            echo json_encode($json);
            exit;
        }
    }

    public function updateDiscountStatus(){
        $data = json_decode(file_get_contents('php://input'), true);
        
        if(empty($data) || empty($data['discount_rule_id'])){
            $json = array('status' => 0, 'message' => 'No Data Received');
            echo json_encode($json);
            exit;
        }

        if(empty($data['status'])){
            $json = array('status' => 0, 'message' => 'Status is required');
            echo json_encode($json);
            exit;
        }

        $this->db->where('discount_rule_id', $data['discount_rule_id']);
        $this->db->update('tbl_dealerapp_discount_rules', array('status' => $data['status']));
        $error = $this->db->error();
        
        if($error['message'] == ''){
            $json = array('status' => 1, 'message' => 'Discount Rule updated successfully');
            echo json_encode($json);
            exit;
        }else{
            $json = array('status' => 0, 'message' => $error['message']);
            echo json_encode($json);
            exit;
        }
    }

    public function getDiscountRulesList(){
        $status = $this->input->get('status');
        $data = array();

        if(empty($status)){
            $json = array('success' => 0, 'message' => 'Status is required');
            echo json_encode($json);
            exit;
        }

        $result = $this->db->where('status', $status)->get('tbl_dealerapp_discount_rules')->result_array();

        if(empty($result)){
            $json['status'] = 0;
            $json['data'] = $data;
            echo json_encode($json);
            exit;
        }

        foreach($result as $key => $value){
            $data[] = array(
                'discount_rule_id' => $value['discount_rule_id'],
                'discount_rule_no' => 'DC-'.$value['discount_rule_id'],
                'category' => $value['category'],
                'discount_criteria' => $value['discount_criteria'],
                'bundle_type' => $value['bundle_type'],
                'discount_type' => $value['discount_type'],
                'min_invoice_amount' => $value['min_invoice_amount'],
                'min_quantity' => $value['min_quantity'],
                'discount_amount' => $value['discount_amount'],
                'discount_percent' => $value['discount_percent'],
                "maximum_discount_amount" => $value['maximum_discount_amount'],
                'start_date' => $value['start_date'],
                'end_date' => $value['end_date'],
                'status' => $value['status']
            );
            unset($result[$key]);
        }

        $json['status'] = 1;
        $json['data'] = $data;
        echo json_encode($json);
        exit;
    }
}